package carbonite;

import clojure.lang.IFn;
import clojure.java.api.Clojure;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

public class ClojureMapSerializer extends Serializer {
    final IFn writeMap;
    final IFn readMap;

    public ClojureMapSerializer() {
	JavaBridge.requireCarbonite();
	writeMap = Clojure.var("carbonite.serializer", "write-map");
	readMap = Clojure.var("carbonite.serializer", "read-map");
    }

    public void write(Kryo kryo, Output output, Object o) {
	writeMap.invoke(kryo, output, o);
    }

    public Object read(Kryo kryo, Input input, Class aClass) {
	return readMap.invoke(kryo, input);
    }
}
