(ns leiningen.new.foxy
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]
            [clojure.java.io :as io]
            [clojure.string :as string]))

(def render (renderer "foxy"))
(defn binary
  [file]
  (io/input-stream (io/resource (string/join "/" ["leiningen" "new" "foxy" file]))))

(defn foxy
  "Initialises new FxOS App boilerplate"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)
              :description "A boilerplate for FirefoxOS"
              :license "MIT"
              :url "https://your.org"
              :version "0.0.1"}]
    (main/info "Generating fresh 'lein new' foxy project.")
    (->files data
             ["manifest.webapp" (render "manifest.tmpl" data)]
             ["README.md" (render "README.tmpl" data)]
             ["CHANGELOGS.md" (render "CHANGELOGS.tmpl" data)]
             ;["src/{{sanitized}}/foo.clj" (render "foo.clj" data)]
             ["project.clj" (render "project.tmpl" data)]
             ["crossdomain.xml" (render "crossdomain.xml" data)]
             [".htaccess" (render ".htaccess" data)]
             ["apple-touch-icon-precomposed.png" (binary "apple-touch-icon-precomposed.png")]
             ["favicon.ico" (binary "favicon.ico")]
             ["index.html" (render "index.tmpl" data)]
             ["repl.html" (render "repl.tmpl" data)]
             ;;styles
             ["css/main.css" (binary "css/main.css")]
             ["css/normalize.css" (binary "css/normalize.css")]
             ["css/normalize.min.css" (binary "css/normalize.min.css")]
             ;;images
             ["img/icon-128.png" (binary "img/icon-128.png")]
             ["img/icon-512.png" (binary "img/icon-512.png")]
             ;;compiled and vendors code
             ["js/main.js" (render "js/main.js" data)]
             ["js/vendor/html5shiv.js" (render "js/vendor/html5shiv.js" data)]
             ;;starter code
             ["src/{{sanitized}}/core.cljs" (render "src/foxy/core.cljs" data)]
             ["src/{{sanitized}}/repl.cljs" (render "src/foxy/repl.cljs" data)])
    (main/info "Done!")))
