(ns app.core
  (:require [app.common :as c]
            [om.core :as om :include-macros true]
            [sablono.core :refer-macros [html]]))

(enable-console-print!)

(defonce app-state (atom {:text "Hello"}))

(defn widget [cursor owner]
  (reify
    om/IRender
    (render [_]
      (html
       [:div
        [:h1 (:text cursor)]]))))

(defn init []
  (om/root widget app-state
           {:target (. js/document (getElementById "container"))}))

(defn reload []
  (om/refresh! widget))
