(ns linked.set
  (:require [linked.map :refer [linked-map]]
            [clojure.string :as string]
                   [cljs.reader :as reader])
                                      
                                   
                                  
                                      
                                                    
                                             
                                                
                                         
                                      
                                           
                                
                                      )

(declare empty-linked-set)

(defn linked-set
  ([] empty-linked-set)
  ([x] (if (coll? x) (into empty-linked-set x) (linked-set [x])))
  ([x & more] (apply conj empty-linked-set x more)))

     
                               
                
                
                                       
                 
                             
               
                                

     
              
                  

          
                  
                               

         

                       
            
                       
                
                                
          
                                             
            
                 
                 
                                    
                                         
                               

         
          
                                                

            
           
                                                 

     
                  
                 

      
              
                             
                    
                                                

        
                  
                                                    
                  
                                      
                      
                               
                                  
                                
                                              
                                                               

     
                                                       
                           
                           


      
(deftype LinkedSet [linked-map]
  Object
  (toString [this]
    (str "#{" (string/join " " (map str this)) "}"))
  (equiv [this other]
    (-equiv this other))

  ICloneable
  (-clone [_] (LinkedSet. linked-map))

  IWithMeta
  (-with-meta [coll meta] (LinkedSet. (with-meta linked-map meta)))

  IMeta
  (-meta [coll] (meta linked-map))

  ICollection
  (-conj [coll o]
    (LinkedSet. (assoc linked-map o nil)))

  IEmptyableCollection
  (-empty [coll] (with-meta empty-linked-set meta))

  IEquiv
  (-equiv [coll other]
    (and
     (set? other)
     (== (count coll) (count other))
     (every? #(contains? coll %)
             other)))

  IHash
  (-hash [coll] (hash-unordered-coll coll))

  ISeqable
  (-seq [coll] (when-let [s (seq linked-map)] (map key s)))

  IReversible
  (-rseq [coll] (when-let [s (rseq linked-map)] (map key s)))

  ISequential

  ICounted
  (-count [coll] (-count linked-map))

  ILookup
  (-lookup [coll v]
    (-lookup coll v nil))
  (-lookup [coll v not-found]
    (if (-contains-key? linked-map v)
      v
      not-found))

  ISet
  (-disjoin [coll v]
    (LinkedSet. (-dissoc linked-map v)))

  IFn
  (-invoke [coll k]
    (-lookup coll k))
  (-invoke [coll k not-found]
    (-lookup coll k not-found))

  ;; IEditableCollection

  IPrintWithWriter
  (-pr-writer [coll writer opts]
    (-write writer (str "#linked/set " (if-let [s (seq coll)] s '())))))

       (reader/register-tag-parser! "linked/set" linked-set)

(def ^{:private true,:tag LinkedSet} empty-linked-set
  (LinkedSet. (linked-map)))

;;;;;;;;;;;; This file autogenerated from src/linked/set.cljx
