(ns leiningen.new.fu-template
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "fu-template"))

(defn fu-template
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["project.clj" (render "project.clj" data)]
["src/clj/{{sanitized}}/core.clj" (render "core.clj" data)]
["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)]
["resources/public/simple.html" (render "simple.html")]
)))