// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__79872 = arguments.length;
switch (G__79872) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async79873 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async79873 = (function (f,blockable,meta79874){
this.f = f;
this.blockable = blockable;
this.meta79874 = meta79874;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async79873.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_79875,meta79874__$1){
var self__ = this;
var _79875__$1 = this;
return (new cljs.core.async.t_cljs$core$async79873(self__.f,self__.blockable,meta79874__$1));
});


cljs.core.async.t_cljs$core$async79873.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_79875){
var self__ = this;
var _79875__$1 = this;
return self__.meta79874;
});


cljs.core.async.t_cljs$core$async79873.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async79873.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async79873.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async79873.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async79873.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta79874","meta79874",1249832842,null)], null);
});

cljs.core.async.t_cljs$core$async79873.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async79873.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async79873";

cljs.core.async.t_cljs$core$async79873.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async79873");
});

cljs.core.async.__GT_t_cljs$core$async79873 = (function cljs$core$async$__GT_t_cljs$core$async79873(f__$1,blockable__$1,meta79874){
return (new cljs.core.async.t_cljs$core$async79873(f__$1,blockable__$1,meta79874));
});

}

return (new cljs.core.async.t_cljs$core$async79873(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__79882 = arguments.length;
switch (G__79882) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__79885 = arguments.length;
switch (G__79885) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__79888 = arguments.length;
switch (G__79888) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_79890 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_79890);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_79890,ret){
return (function (){
return fn1.call(null,val_79890);
});})(val_79890,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__79899 = arguments.length;
switch (G__79899) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29088__auto___79902 = n;
var x_79903 = (0);
while(true){
if((x_79903 < n__29088__auto___79902)){
(a[x_79903] = (0));

var G__79904 = (x_79903 + (1));
x_79903 = G__79904;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__79905 = (i + (1));
i = G__79905;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async79906 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async79906 = (function (flag,meta79907){
this.flag = flag;
this.meta79907 = meta79907;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async79906.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_79908,meta79907__$1){
var self__ = this;
var _79908__$1 = this;
return (new cljs.core.async.t_cljs$core$async79906(self__.flag,meta79907__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async79906.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_79908){
var self__ = this;
var _79908__$1 = this;
return self__.meta79907;
});})(flag))
;


cljs.core.async.t_cljs$core$async79906.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async79906.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async79906.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async79906.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async79906.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta79907","meta79907",-670087563,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async79906.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async79906.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async79906";

cljs.core.async.t_cljs$core$async79906.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async79906");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async79906 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async79906(flag__$1,meta79907){
return (new cljs.core.async.t_cljs$core$async79906(flag__$1,meta79907));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async79906(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async79909 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async79909 = (function (flag,cb,meta79910){
this.flag = flag;
this.cb = cb;
this.meta79910 = meta79910;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async79909.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_79911,meta79910__$1){
var self__ = this;
var _79911__$1 = this;
return (new cljs.core.async.t_cljs$core$async79909(self__.flag,self__.cb,meta79910__$1));
});


cljs.core.async.t_cljs$core$async79909.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_79911){
var self__ = this;
var _79911__$1 = this;
return self__.meta79910;
});


cljs.core.async.t_cljs$core$async79909.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async79909.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async79909.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async79909.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async79909.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta79910","meta79910",-474959280,null)], null);
});

cljs.core.async.t_cljs$core$async79909.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async79909.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async79909";

cljs.core.async.t_cljs$core$async79909.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async79909");
});

cljs.core.async.__GT_t_cljs$core$async79909 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async79909(flag__$1,cb__$1,meta79910){
return (new cljs.core.async.t_cljs$core$async79909(flag__$1,cb__$1,meta79910));
});

}

return (new cljs.core.async.t_cljs$core$async79909(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__79915_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__79915_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__79916_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__79916_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28141__auto__ = wport;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return port;
}
})()], null));
} else {
var G__79920 = (i + (1));
i = G__79920;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28141__auto__ = ret;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28129__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___79926 = arguments.length;
var i__29313__auto___79927 = (0);
while(true){
if((i__29313__auto___79927 < len__29312__auto___79926)){
args__29319__auto__.push((arguments[i__29313__auto___79927]));

var G__79931 = (i__29313__auto___79927 + (1));
i__29313__auto___79927 = G__79931;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__79923){
var map__79924 = p__79923;
var map__79924__$1 = ((((!((map__79924 == null)))?((((map__79924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__79924.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__79924):map__79924);
var opts = map__79924__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq79921){
var G__79922 = cljs.core.first.call(null,seq79921);
var seq79921__$1 = cljs.core.next.call(null,seq79921);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__79922,seq79921__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__79937 = arguments.length;
switch (G__79937) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42036__auto___79992 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___79992){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___79992){
return (function (state_79961){
var state_val_79962 = (state_79961[(1)]);
if((state_val_79962 === (7))){
var inst_79957 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
var statearr_79968_79993 = state_79961__$1;
(statearr_79968_79993[(2)] = inst_79957);

(statearr_79968_79993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (1))){
var state_79961__$1 = state_79961;
var statearr_79969_79994 = state_79961__$1;
(statearr_79969_79994[(2)] = null);

(statearr_79969_79994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (4))){
var inst_79940 = (state_79961[(7)]);
var inst_79940__$1 = (state_79961[(2)]);
var inst_79941 = (inst_79940__$1 == null);
var state_79961__$1 = (function (){var statearr_79970 = state_79961;
(statearr_79970[(7)] = inst_79940__$1);

return statearr_79970;
})();
if(cljs.core.truth_(inst_79941)){
var statearr_79971_79996 = state_79961__$1;
(statearr_79971_79996[(1)] = (5));

} else {
var statearr_79972_79997 = state_79961__$1;
(statearr_79972_79997[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (13))){
var state_79961__$1 = state_79961;
var statearr_79973_79998 = state_79961__$1;
(statearr_79973_79998[(2)] = null);

(statearr_79973_79998[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (6))){
var inst_79940 = (state_79961[(7)]);
var state_79961__$1 = state_79961;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79961__$1,(11),to,inst_79940);
} else {
if((state_val_79962 === (3))){
var inst_79959 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79961__$1,inst_79959);
} else {
if((state_val_79962 === (12))){
var state_79961__$1 = state_79961;
var statearr_79975_79999 = state_79961__$1;
(statearr_79975_79999[(2)] = null);

(statearr_79975_79999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (2))){
var state_79961__$1 = state_79961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79961__$1,(4),from);
} else {
if((state_val_79962 === (11))){
var inst_79950 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
if(cljs.core.truth_(inst_79950)){
var statearr_79976_80000 = state_79961__$1;
(statearr_79976_80000[(1)] = (12));

} else {
var statearr_79977_80001 = state_79961__$1;
(statearr_79977_80001[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (9))){
var state_79961__$1 = state_79961;
var statearr_79978_80002 = state_79961__$1;
(statearr_79978_80002[(2)] = null);

(statearr_79978_80002[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (5))){
var state_79961__$1 = state_79961;
if(cljs.core.truth_(close_QMARK_)){
var statearr_79979_80003 = state_79961__$1;
(statearr_79979_80003[(1)] = (8));

} else {
var statearr_79980_80004 = state_79961__$1;
(statearr_79980_80004[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (14))){
var inst_79955 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
var statearr_79981_80005 = state_79961__$1;
(statearr_79981_80005[(2)] = inst_79955);

(statearr_79981_80005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (10))){
var inst_79947 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
var statearr_79982_80006 = state_79961__$1;
(statearr_79982_80006[(2)] = inst_79947);

(statearr_79982_80006[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (8))){
var inst_79944 = cljs.core.async.close_BANG_.call(null,to);
var state_79961__$1 = state_79961;
var statearr_79983_80007 = state_79961__$1;
(statearr_79983_80007[(2)] = inst_79944);

(statearr_79983_80007[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___79992))
;
return ((function (switch__42015__auto__,c__42036__auto___79992){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_79984 = [null,null,null,null,null,null,null,null];
(statearr_79984[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_79984[(1)] = (1));

return statearr_79984;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_79961){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_79961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e79985){if((e79985 instanceof Object)){
var ex__42019__auto__ = e79985;
var statearr_79986_80008 = state_79961;
(statearr_79986_80008[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79985;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80009 = state_79961;
state_79961 = G__80009;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_79961){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_79961);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___79992))
})();
var state__42038__auto__ = (function (){var statearr_79987 = f__42037__auto__.call(null);
(statearr_79987[(6)] = c__42036__auto___79992);

return statearr_79987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___79992))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__80010){
var vec__80011 = p__80010;
var v = cljs.core.nth.call(null,vec__80011,(0),null);
var p = cljs.core.nth.call(null,vec__80011,(1),null);
var job = vec__80011;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__42036__auto___80182 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___80182,res,vec__80011,v,p,job,jobs,results){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___80182,res,vec__80011,v,p,job,jobs,results){
return (function (state_80018){
var state_val_80019 = (state_80018[(1)]);
if((state_val_80019 === (1))){
var state_80018__$1 = state_80018;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80018__$1,(2),res,v);
} else {
if((state_val_80019 === (2))){
var inst_80015 = (state_80018[(2)]);
var inst_80016 = cljs.core.async.close_BANG_.call(null,res);
var state_80018__$1 = (function (){var statearr_80020 = state_80018;
(statearr_80020[(7)] = inst_80015);

return statearr_80020;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80018__$1,inst_80016);
} else {
return null;
}
}
});})(c__42036__auto___80182,res,vec__80011,v,p,job,jobs,results))
;
return ((function (switch__42015__auto__,c__42036__auto___80182,res,vec__80011,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0 = (function (){
var statearr_80021 = [null,null,null,null,null,null,null,null];
(statearr_80021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__);

(statearr_80021[(1)] = (1));

return statearr_80021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1 = (function (state_80018){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80022){if((e80022 instanceof Object)){
var ex__42019__auto__ = e80022;
var statearr_80023_80183 = state_80018;
(statearr_80023_80183[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80018);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80184 = state_80018;
state_80018 = G__80184;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = function(state_80018){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1.call(this,state_80018);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___80182,res,vec__80011,v,p,job,jobs,results))
})();
var state__42038__auto__ = (function (){var statearr_80024 = f__42037__auto__.call(null);
(statearr_80024[(6)] = c__42036__auto___80182);

return statearr_80024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___80182,res,vec__80011,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__80025){
var vec__80026 = p__80025;
var v = cljs.core.nth.call(null,vec__80026,(0),null);
var p = cljs.core.nth.call(null,vec__80026,(1),null);
var job = vec__80026;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29088__auto___80185 = n;
var __80186 = (0);
while(true){
if((__80186 < n__29088__auto___80185)){
var G__80029_80187 = type;
var G__80029_80188__$1 = (((G__80029_80187 instanceof cljs.core.Keyword))?G__80029_80187.fqn:null);
switch (G__80029_80188__$1) {
case "compute":
var c__42036__auto___80192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__80186,c__42036__auto___80192,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (__80186,c__42036__auto___80192,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async){
return (function (state_80042){
var state_val_80043 = (state_80042[(1)]);
if((state_val_80043 === (1))){
var state_80042__$1 = state_80042;
var statearr_80044_80193 = state_80042__$1;
(statearr_80044_80193[(2)] = null);

(statearr_80044_80193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80043 === (2))){
var state_80042__$1 = state_80042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80042__$1,(4),jobs);
} else {
if((state_val_80043 === (3))){
var inst_80040 = (state_80042[(2)]);
var state_80042__$1 = state_80042;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80042__$1,inst_80040);
} else {
if((state_val_80043 === (4))){
var inst_80032 = (state_80042[(2)]);
var inst_80033 = process.call(null,inst_80032);
var state_80042__$1 = state_80042;
if(cljs.core.truth_(inst_80033)){
var statearr_80045_80195 = state_80042__$1;
(statearr_80045_80195[(1)] = (5));

} else {
var statearr_80046_80196 = state_80042__$1;
(statearr_80046_80196[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80043 === (5))){
var state_80042__$1 = state_80042;
var statearr_80047_80198 = state_80042__$1;
(statearr_80047_80198[(2)] = null);

(statearr_80047_80198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80043 === (6))){
var state_80042__$1 = state_80042;
var statearr_80048_80200 = state_80042__$1;
(statearr_80048_80200[(2)] = null);

(statearr_80048_80200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80043 === (7))){
var inst_80038 = (state_80042[(2)]);
var state_80042__$1 = state_80042;
var statearr_80049_80201 = state_80042__$1;
(statearr_80049_80201[(2)] = inst_80038);

(statearr_80049_80201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__80186,c__42036__auto___80192,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async))
;
return ((function (__80186,switch__42015__auto__,c__42036__auto___80192,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0 = (function (){
var statearr_80050 = [null,null,null,null,null,null,null];
(statearr_80050[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__);

(statearr_80050[(1)] = (1));

return statearr_80050;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1 = (function (state_80042){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80042);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80051){if((e80051 instanceof Object)){
var ex__42019__auto__ = e80051;
var statearr_80052_80209 = state_80042;
(statearr_80052_80209[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80042);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80051;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80211 = state_80042;
state_80042 = G__80211;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = function(state_80042){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1.call(this,state_80042);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__;
})()
;})(__80186,switch__42015__auto__,c__42036__auto___80192,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async))
})();
var state__42038__auto__ = (function (){var statearr_80053 = f__42037__auto__.call(null);
(statearr_80053[(6)] = c__42036__auto___80192);

return statearr_80053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(__80186,c__42036__auto___80192,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async))
);


break;
case "async":
var c__42036__auto___80216 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__80186,c__42036__auto___80216,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (__80186,c__42036__auto___80216,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async){
return (function (state_80066){
var state_val_80067 = (state_80066[(1)]);
if((state_val_80067 === (1))){
var state_80066__$1 = state_80066;
var statearr_80068_80220 = state_80066__$1;
(statearr_80068_80220[(2)] = null);

(statearr_80068_80220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80067 === (2))){
var state_80066__$1 = state_80066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80066__$1,(4),jobs);
} else {
if((state_val_80067 === (3))){
var inst_80064 = (state_80066[(2)]);
var state_80066__$1 = state_80066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80066__$1,inst_80064);
} else {
if((state_val_80067 === (4))){
var inst_80056 = (state_80066[(2)]);
var inst_80057 = async.call(null,inst_80056);
var state_80066__$1 = state_80066;
if(cljs.core.truth_(inst_80057)){
var statearr_80069_80222 = state_80066__$1;
(statearr_80069_80222[(1)] = (5));

} else {
var statearr_80070_80223 = state_80066__$1;
(statearr_80070_80223[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80067 === (5))){
var state_80066__$1 = state_80066;
var statearr_80071_80225 = state_80066__$1;
(statearr_80071_80225[(2)] = null);

(statearr_80071_80225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80067 === (6))){
var state_80066__$1 = state_80066;
var statearr_80072_80228 = state_80066__$1;
(statearr_80072_80228[(2)] = null);

(statearr_80072_80228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80067 === (7))){
var inst_80062 = (state_80066[(2)]);
var state_80066__$1 = state_80066;
var statearr_80073_80229 = state_80066__$1;
(statearr_80073_80229[(2)] = inst_80062);

(statearr_80073_80229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__80186,c__42036__auto___80216,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async))
;
return ((function (__80186,switch__42015__auto__,c__42036__auto___80216,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0 = (function (){
var statearr_80074 = [null,null,null,null,null,null,null];
(statearr_80074[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__);

(statearr_80074[(1)] = (1));

return statearr_80074;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1 = (function (state_80066){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80075){if((e80075 instanceof Object)){
var ex__42019__auto__ = e80075;
var statearr_80076_80230 = state_80066;
(statearr_80076_80230[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80066);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80075;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80231 = state_80066;
state_80066 = G__80231;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = function(state_80066){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1.call(this,state_80066);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__;
})()
;})(__80186,switch__42015__auto__,c__42036__auto___80216,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async))
})();
var state__42038__auto__ = (function (){var statearr_80077 = f__42037__auto__.call(null);
(statearr_80077[(6)] = c__42036__auto___80216);

return statearr_80077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(__80186,c__42036__auto___80216,G__80029_80187,G__80029_80188__$1,n__29088__auto___80185,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__80029_80188__$1)].join('')));

}

var G__80232 = (__80186 + (1));
__80186 = G__80232;
continue;
} else {
}
break;
}

var c__42036__auto___80233 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___80233,jobs,results,process,async){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___80233,jobs,results,process,async){
return (function (state_80099){
var state_val_80100 = (state_80099[(1)]);
if((state_val_80100 === (1))){
var state_80099__$1 = state_80099;
var statearr_80101_80234 = state_80099__$1;
(statearr_80101_80234[(2)] = null);

(statearr_80101_80234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80100 === (2))){
var state_80099__$1 = state_80099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80099__$1,(4),from);
} else {
if((state_val_80100 === (3))){
var inst_80097 = (state_80099[(2)]);
var state_80099__$1 = state_80099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80099__$1,inst_80097);
} else {
if((state_val_80100 === (4))){
var inst_80080 = (state_80099[(7)]);
var inst_80080__$1 = (state_80099[(2)]);
var inst_80081 = (inst_80080__$1 == null);
var state_80099__$1 = (function (){var statearr_80102 = state_80099;
(statearr_80102[(7)] = inst_80080__$1);

return statearr_80102;
})();
if(cljs.core.truth_(inst_80081)){
var statearr_80103_80235 = state_80099__$1;
(statearr_80103_80235[(1)] = (5));

} else {
var statearr_80104_80236 = state_80099__$1;
(statearr_80104_80236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80100 === (5))){
var inst_80083 = cljs.core.async.close_BANG_.call(null,jobs);
var state_80099__$1 = state_80099;
var statearr_80105_80237 = state_80099__$1;
(statearr_80105_80237[(2)] = inst_80083);

(statearr_80105_80237[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80100 === (6))){
var inst_80085 = (state_80099[(8)]);
var inst_80080 = (state_80099[(7)]);
var inst_80085__$1 = cljs.core.async.chan.call(null,(1));
var inst_80086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80087 = [inst_80080,inst_80085__$1];
var inst_80088 = (new cljs.core.PersistentVector(null,2,(5),inst_80086,inst_80087,null));
var state_80099__$1 = (function (){var statearr_80106 = state_80099;
(statearr_80106[(8)] = inst_80085__$1);

return statearr_80106;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80099__$1,(8),jobs,inst_80088);
} else {
if((state_val_80100 === (7))){
var inst_80095 = (state_80099[(2)]);
var state_80099__$1 = state_80099;
var statearr_80107_80238 = state_80099__$1;
(statearr_80107_80238[(2)] = inst_80095);

(statearr_80107_80238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80100 === (8))){
var inst_80085 = (state_80099[(8)]);
var inst_80090 = (state_80099[(2)]);
var state_80099__$1 = (function (){var statearr_80108 = state_80099;
(statearr_80108[(9)] = inst_80090);

return statearr_80108;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80099__$1,(9),results,inst_80085);
} else {
if((state_val_80100 === (9))){
var inst_80092 = (state_80099[(2)]);
var state_80099__$1 = (function (){var statearr_80109 = state_80099;
(statearr_80109[(10)] = inst_80092);

return statearr_80109;
})();
var statearr_80110_80239 = state_80099__$1;
(statearr_80110_80239[(2)] = null);

(statearr_80110_80239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___80233,jobs,results,process,async))
;
return ((function (switch__42015__auto__,c__42036__auto___80233,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0 = (function (){
var statearr_80111 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_80111[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__);

(statearr_80111[(1)] = (1));

return statearr_80111;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1 = (function (state_80099){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80112){if((e80112 instanceof Object)){
var ex__42019__auto__ = e80112;
var statearr_80113_80244 = state_80099;
(statearr_80113_80244[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80099);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80248 = state_80099;
state_80099 = G__80248;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = function(state_80099){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1.call(this,state_80099);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___80233,jobs,results,process,async))
})();
var state__42038__auto__ = (function (){var statearr_80114 = f__42037__auto__.call(null);
(statearr_80114[(6)] = c__42036__auto___80233);

return statearr_80114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___80233,jobs,results,process,async))
);


var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,jobs,results,process,async){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,jobs,results,process,async){
return (function (state_80152){
var state_val_80153 = (state_80152[(1)]);
if((state_val_80153 === (7))){
var inst_80148 = (state_80152[(2)]);
var state_80152__$1 = state_80152;
var statearr_80154_80252 = state_80152__$1;
(statearr_80154_80252[(2)] = inst_80148);

(statearr_80154_80252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (20))){
var state_80152__$1 = state_80152;
var statearr_80155_80253 = state_80152__$1;
(statearr_80155_80253[(2)] = null);

(statearr_80155_80253[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (1))){
var state_80152__$1 = state_80152;
var statearr_80156_80254 = state_80152__$1;
(statearr_80156_80254[(2)] = null);

(statearr_80156_80254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (4))){
var inst_80117 = (state_80152[(7)]);
var inst_80117__$1 = (state_80152[(2)]);
var inst_80118 = (inst_80117__$1 == null);
var state_80152__$1 = (function (){var statearr_80157 = state_80152;
(statearr_80157[(7)] = inst_80117__$1);

return statearr_80157;
})();
if(cljs.core.truth_(inst_80118)){
var statearr_80158_80255 = state_80152__$1;
(statearr_80158_80255[(1)] = (5));

} else {
var statearr_80159_80256 = state_80152__$1;
(statearr_80159_80256[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (15))){
var inst_80130 = (state_80152[(8)]);
var state_80152__$1 = state_80152;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80152__$1,(18),to,inst_80130);
} else {
if((state_val_80153 === (21))){
var inst_80143 = (state_80152[(2)]);
var state_80152__$1 = state_80152;
var statearr_80160_80257 = state_80152__$1;
(statearr_80160_80257[(2)] = inst_80143);

(statearr_80160_80257[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (13))){
var inst_80145 = (state_80152[(2)]);
var state_80152__$1 = (function (){var statearr_80161 = state_80152;
(statearr_80161[(9)] = inst_80145);

return statearr_80161;
})();
var statearr_80162_80258 = state_80152__$1;
(statearr_80162_80258[(2)] = null);

(statearr_80162_80258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (6))){
var inst_80117 = (state_80152[(7)]);
var state_80152__$1 = state_80152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80152__$1,(11),inst_80117);
} else {
if((state_val_80153 === (17))){
var inst_80138 = (state_80152[(2)]);
var state_80152__$1 = state_80152;
if(cljs.core.truth_(inst_80138)){
var statearr_80163_80260 = state_80152__$1;
(statearr_80163_80260[(1)] = (19));

} else {
var statearr_80164_80261 = state_80152__$1;
(statearr_80164_80261[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (3))){
var inst_80150 = (state_80152[(2)]);
var state_80152__$1 = state_80152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80152__$1,inst_80150);
} else {
if((state_val_80153 === (12))){
var inst_80127 = (state_80152[(10)]);
var state_80152__$1 = state_80152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80152__$1,(14),inst_80127);
} else {
if((state_val_80153 === (2))){
var state_80152__$1 = state_80152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80152__$1,(4),results);
} else {
if((state_val_80153 === (19))){
var state_80152__$1 = state_80152;
var statearr_80165_80264 = state_80152__$1;
(statearr_80165_80264[(2)] = null);

(statearr_80165_80264[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (11))){
var inst_80127 = (state_80152[(2)]);
var state_80152__$1 = (function (){var statearr_80166 = state_80152;
(statearr_80166[(10)] = inst_80127);

return statearr_80166;
})();
var statearr_80167_80268 = state_80152__$1;
(statearr_80167_80268[(2)] = null);

(statearr_80167_80268[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (9))){
var state_80152__$1 = state_80152;
var statearr_80168_80269 = state_80152__$1;
(statearr_80168_80269[(2)] = null);

(statearr_80168_80269[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (5))){
var state_80152__$1 = state_80152;
if(cljs.core.truth_(close_QMARK_)){
var statearr_80169_80270 = state_80152__$1;
(statearr_80169_80270[(1)] = (8));

} else {
var statearr_80170_80271 = state_80152__$1;
(statearr_80170_80271[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (14))){
var inst_80132 = (state_80152[(11)]);
var inst_80130 = (state_80152[(8)]);
var inst_80130__$1 = (state_80152[(2)]);
var inst_80131 = (inst_80130__$1 == null);
var inst_80132__$1 = cljs.core.not.call(null,inst_80131);
var state_80152__$1 = (function (){var statearr_80171 = state_80152;
(statearr_80171[(11)] = inst_80132__$1);

(statearr_80171[(8)] = inst_80130__$1);

return statearr_80171;
})();
if(inst_80132__$1){
var statearr_80172_80272 = state_80152__$1;
(statearr_80172_80272[(1)] = (15));

} else {
var statearr_80173_80273 = state_80152__$1;
(statearr_80173_80273[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (16))){
var inst_80132 = (state_80152[(11)]);
var state_80152__$1 = state_80152;
var statearr_80174_80274 = state_80152__$1;
(statearr_80174_80274[(2)] = inst_80132);

(statearr_80174_80274[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (10))){
var inst_80124 = (state_80152[(2)]);
var state_80152__$1 = state_80152;
var statearr_80175_80275 = state_80152__$1;
(statearr_80175_80275[(2)] = inst_80124);

(statearr_80175_80275[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (18))){
var inst_80135 = (state_80152[(2)]);
var state_80152__$1 = state_80152;
var statearr_80176_80276 = state_80152__$1;
(statearr_80176_80276[(2)] = inst_80135);

(statearr_80176_80276[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80153 === (8))){
var inst_80121 = cljs.core.async.close_BANG_.call(null,to);
var state_80152__$1 = state_80152;
var statearr_80177_80277 = state_80152__$1;
(statearr_80177_80277[(2)] = inst_80121);

(statearr_80177_80277[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__,jobs,results,process,async))
;
return ((function (switch__42015__auto__,c__42036__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0 = (function (){
var statearr_80178 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80178[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__);

(statearr_80178[(1)] = (1));

return statearr_80178;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1 = (function (state_80152){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80179){if((e80179 instanceof Object)){
var ex__42019__auto__ = e80179;
var statearr_80180_80281 = state_80152;
(statearr_80180_80281[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80152);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80179;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80282 = state_80152;
state_80152 = G__80282;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__ = function(state_80152){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1.call(this,state_80152);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,jobs,results,process,async))
})();
var state__42038__auto__ = (function (){var statearr_80181 = f__42037__auto__.call(null);
(statearr_80181[(6)] = c__42036__auto__);

return statearr_80181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,jobs,results,process,async))
);

return c__42036__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__80284 = arguments.length;
switch (G__80284) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__80287 = arguments.length;
switch (G__80287) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__80293 = arguments.length;
switch (G__80293) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__42036__auto___80345 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___80345,tc,fc){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___80345,tc,fc){
return (function (state_80319){
var state_val_80320 = (state_80319[(1)]);
if((state_val_80320 === (7))){
var inst_80315 = (state_80319[(2)]);
var state_80319__$1 = state_80319;
var statearr_80321_80346 = state_80319__$1;
(statearr_80321_80346[(2)] = inst_80315);

(statearr_80321_80346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (1))){
var state_80319__$1 = state_80319;
var statearr_80322_80347 = state_80319__$1;
(statearr_80322_80347[(2)] = null);

(statearr_80322_80347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (4))){
var inst_80296 = (state_80319[(7)]);
var inst_80296__$1 = (state_80319[(2)]);
var inst_80297 = (inst_80296__$1 == null);
var state_80319__$1 = (function (){var statearr_80323 = state_80319;
(statearr_80323[(7)] = inst_80296__$1);

return statearr_80323;
})();
if(cljs.core.truth_(inst_80297)){
var statearr_80324_80348 = state_80319__$1;
(statearr_80324_80348[(1)] = (5));

} else {
var statearr_80325_80349 = state_80319__$1;
(statearr_80325_80349[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (13))){
var state_80319__$1 = state_80319;
var statearr_80326_80350 = state_80319__$1;
(statearr_80326_80350[(2)] = null);

(statearr_80326_80350[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (6))){
var inst_80296 = (state_80319[(7)]);
var inst_80302 = p.call(null,inst_80296);
var state_80319__$1 = state_80319;
if(cljs.core.truth_(inst_80302)){
var statearr_80327_80354 = state_80319__$1;
(statearr_80327_80354[(1)] = (9));

} else {
var statearr_80328_80355 = state_80319__$1;
(statearr_80328_80355[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (3))){
var inst_80317 = (state_80319[(2)]);
var state_80319__$1 = state_80319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80319__$1,inst_80317);
} else {
if((state_val_80320 === (12))){
var state_80319__$1 = state_80319;
var statearr_80329_80356 = state_80319__$1;
(statearr_80329_80356[(2)] = null);

(statearr_80329_80356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (2))){
var state_80319__$1 = state_80319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80319__$1,(4),ch);
} else {
if((state_val_80320 === (11))){
var inst_80296 = (state_80319[(7)]);
var inst_80306 = (state_80319[(2)]);
var state_80319__$1 = state_80319;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80319__$1,(8),inst_80306,inst_80296);
} else {
if((state_val_80320 === (9))){
var state_80319__$1 = state_80319;
var statearr_80333_80357 = state_80319__$1;
(statearr_80333_80357[(2)] = tc);

(statearr_80333_80357[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (5))){
var inst_80299 = cljs.core.async.close_BANG_.call(null,tc);
var inst_80300 = cljs.core.async.close_BANG_.call(null,fc);
var state_80319__$1 = (function (){var statearr_80334 = state_80319;
(statearr_80334[(8)] = inst_80299);

return statearr_80334;
})();
var statearr_80335_80358 = state_80319__$1;
(statearr_80335_80358[(2)] = inst_80300);

(statearr_80335_80358[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (14))){
var inst_80313 = (state_80319[(2)]);
var state_80319__$1 = state_80319;
var statearr_80336_80359 = state_80319__$1;
(statearr_80336_80359[(2)] = inst_80313);

(statearr_80336_80359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (10))){
var state_80319__$1 = state_80319;
var statearr_80337_80360 = state_80319__$1;
(statearr_80337_80360[(2)] = fc);

(statearr_80337_80360[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80320 === (8))){
var inst_80308 = (state_80319[(2)]);
var state_80319__$1 = state_80319;
if(cljs.core.truth_(inst_80308)){
var statearr_80338_80361 = state_80319__$1;
(statearr_80338_80361[(1)] = (12));

} else {
var statearr_80339_80362 = state_80319__$1;
(statearr_80339_80362[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___80345,tc,fc))
;
return ((function (switch__42015__auto__,c__42036__auto___80345,tc,fc){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_80340 = [null,null,null,null,null,null,null,null,null];
(statearr_80340[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_80340[(1)] = (1));

return statearr_80340;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_80319){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80341){if((e80341 instanceof Object)){
var ex__42019__auto__ = e80341;
var statearr_80342_80363 = state_80319;
(statearr_80342_80363[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80341;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80364 = state_80319;
state_80319 = G__80364;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_80319){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_80319);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___80345,tc,fc))
})();
var state__42038__auto__ = (function (){var statearr_80343 = f__42037__auto__.call(null);
(statearr_80343[(6)] = c__42036__auto___80345);

return statearr_80343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___80345,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_80385){
var state_val_80386 = (state_80385[(1)]);
if((state_val_80386 === (7))){
var inst_80381 = (state_80385[(2)]);
var state_80385__$1 = state_80385;
var statearr_80390_80408 = state_80385__$1;
(statearr_80390_80408[(2)] = inst_80381);

(statearr_80390_80408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80386 === (1))){
var inst_80365 = init;
var state_80385__$1 = (function (){var statearr_80391 = state_80385;
(statearr_80391[(7)] = inst_80365);

return statearr_80391;
})();
var statearr_80392_80409 = state_80385__$1;
(statearr_80392_80409[(2)] = null);

(statearr_80392_80409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80386 === (4))){
var inst_80368 = (state_80385[(8)]);
var inst_80368__$1 = (state_80385[(2)]);
var inst_80369 = (inst_80368__$1 == null);
var state_80385__$1 = (function (){var statearr_80393 = state_80385;
(statearr_80393[(8)] = inst_80368__$1);

return statearr_80393;
})();
if(cljs.core.truth_(inst_80369)){
var statearr_80394_80410 = state_80385__$1;
(statearr_80394_80410[(1)] = (5));

} else {
var statearr_80395_80411 = state_80385__$1;
(statearr_80395_80411[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80386 === (6))){
var inst_80365 = (state_80385[(7)]);
var inst_80372 = (state_80385[(9)]);
var inst_80368 = (state_80385[(8)]);
var inst_80372__$1 = f.call(null,inst_80365,inst_80368);
var inst_80373 = cljs.core.reduced_QMARK_.call(null,inst_80372__$1);
var state_80385__$1 = (function (){var statearr_80396 = state_80385;
(statearr_80396[(9)] = inst_80372__$1);

return statearr_80396;
})();
if(inst_80373){
var statearr_80397_80412 = state_80385__$1;
(statearr_80397_80412[(1)] = (8));

} else {
var statearr_80398_80416 = state_80385__$1;
(statearr_80398_80416[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80386 === (3))){
var inst_80383 = (state_80385[(2)]);
var state_80385__$1 = state_80385;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80385__$1,inst_80383);
} else {
if((state_val_80386 === (2))){
var state_80385__$1 = state_80385;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80385__$1,(4),ch);
} else {
if((state_val_80386 === (9))){
var inst_80372 = (state_80385[(9)]);
var inst_80365 = inst_80372;
var state_80385__$1 = (function (){var statearr_80399 = state_80385;
(statearr_80399[(7)] = inst_80365);

return statearr_80399;
})();
var statearr_80400_80417 = state_80385__$1;
(statearr_80400_80417[(2)] = null);

(statearr_80400_80417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80386 === (5))){
var inst_80365 = (state_80385[(7)]);
var state_80385__$1 = state_80385;
var statearr_80401_80418 = state_80385__$1;
(statearr_80401_80418[(2)] = inst_80365);

(statearr_80401_80418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80386 === (10))){
var inst_80379 = (state_80385[(2)]);
var state_80385__$1 = state_80385;
var statearr_80402_80419 = state_80385__$1;
(statearr_80402_80419[(2)] = inst_80379);

(statearr_80402_80419[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80386 === (8))){
var inst_80372 = (state_80385[(9)]);
var inst_80375 = cljs.core.deref.call(null,inst_80372);
var state_80385__$1 = state_80385;
var statearr_80403_80420 = state_80385__$1;
(statearr_80403_80420[(2)] = inst_80375);

(statearr_80403_80420[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__42016__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42016__auto____0 = (function (){
var statearr_80404 = [null,null,null,null,null,null,null,null,null,null];
(statearr_80404[(0)] = cljs$core$async$reduce_$_state_machine__42016__auto__);

(statearr_80404[(1)] = (1));

return statearr_80404;
});
var cljs$core$async$reduce_$_state_machine__42016__auto____1 = (function (state_80385){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80385);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80405){if((e80405 instanceof Object)){
var ex__42019__auto__ = e80405;
var statearr_80406_80421 = state_80385;
(statearr_80406_80421[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80385);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80405;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80422 = state_80385;
state_80385 = G__80422;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42016__auto__ = function(state_80385){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42016__auto____1.call(this,state_80385);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42016__auto____0;
cljs$core$async$reduce_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42016__auto____1;
return cljs$core$async$reduce_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_80407 = f__42037__auto__.call(null);
(statearr_80407[(6)] = c__42036__auto__);

return statearr_80407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,f__$1){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,f__$1){
return (function (state_80428){
var state_val_80429 = (state_80428[(1)]);
if((state_val_80429 === (1))){
var inst_80423 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_80428__$1 = state_80428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80428__$1,(2),inst_80423);
} else {
if((state_val_80429 === (2))){
var inst_80425 = (state_80428[(2)]);
var inst_80426 = f__$1.call(null,inst_80425);
var state_80428__$1 = state_80428;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80428__$1,inst_80426);
} else {
return null;
}
}
});})(c__42036__auto__,f__$1))
;
return ((function (switch__42015__auto__,c__42036__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__42016__auto__ = null;
var cljs$core$async$transduce_$_state_machine__42016__auto____0 = (function (){
var statearr_80433 = [null,null,null,null,null,null,null];
(statearr_80433[(0)] = cljs$core$async$transduce_$_state_machine__42016__auto__);

(statearr_80433[(1)] = (1));

return statearr_80433;
});
var cljs$core$async$transduce_$_state_machine__42016__auto____1 = (function (state_80428){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80428);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80434){if((e80434 instanceof Object)){
var ex__42019__auto__ = e80434;
var statearr_80435_80437 = state_80428;
(statearr_80435_80437[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80428);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80438 = state_80428;
state_80428 = G__80438;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__42016__auto__ = function(state_80428){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__42016__auto____1.call(this,state_80428);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__42016__auto____0;
cljs$core$async$transduce_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__42016__auto____1;
return cljs$core$async$transduce_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,f__$1))
})();
var state__42038__auto__ = (function (){var statearr_80436 = f__42037__auto__.call(null);
(statearr_80436[(6)] = c__42036__auto__);

return statearr_80436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,f__$1))
);

return c__42036__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__80440 = arguments.length;
switch (G__80440) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_80465){
var state_val_80466 = (state_80465[(1)]);
if((state_val_80466 === (7))){
var inst_80447 = (state_80465[(2)]);
var state_80465__$1 = state_80465;
var statearr_80467_80491 = state_80465__$1;
(statearr_80467_80491[(2)] = inst_80447);

(statearr_80467_80491[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (1))){
var inst_80441 = cljs.core.seq.call(null,coll);
var inst_80442 = inst_80441;
var state_80465__$1 = (function (){var statearr_80468 = state_80465;
(statearr_80468[(7)] = inst_80442);

return statearr_80468;
})();
var statearr_80469_80492 = state_80465__$1;
(statearr_80469_80492[(2)] = null);

(statearr_80469_80492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (4))){
var inst_80442 = (state_80465[(7)]);
var inst_80445 = cljs.core.first.call(null,inst_80442);
var state_80465__$1 = state_80465;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80465__$1,(7),ch,inst_80445);
} else {
if((state_val_80466 === (13))){
var inst_80459 = (state_80465[(2)]);
var state_80465__$1 = state_80465;
var statearr_80470_80493 = state_80465__$1;
(statearr_80470_80493[(2)] = inst_80459);

(statearr_80470_80493[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (6))){
var inst_80450 = (state_80465[(2)]);
var state_80465__$1 = state_80465;
if(cljs.core.truth_(inst_80450)){
var statearr_80474_80498 = state_80465__$1;
(statearr_80474_80498[(1)] = (8));

} else {
var statearr_80475_80499 = state_80465__$1;
(statearr_80475_80499[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (3))){
var inst_80463 = (state_80465[(2)]);
var state_80465__$1 = state_80465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80465__$1,inst_80463);
} else {
if((state_val_80466 === (12))){
var state_80465__$1 = state_80465;
var statearr_80476_80503 = state_80465__$1;
(statearr_80476_80503[(2)] = null);

(statearr_80476_80503[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (2))){
var inst_80442 = (state_80465[(7)]);
var state_80465__$1 = state_80465;
if(cljs.core.truth_(inst_80442)){
var statearr_80477_80504 = state_80465__$1;
(statearr_80477_80504[(1)] = (4));

} else {
var statearr_80478_80505 = state_80465__$1;
(statearr_80478_80505[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (11))){
var inst_80456 = cljs.core.async.close_BANG_.call(null,ch);
var state_80465__$1 = state_80465;
var statearr_80479_80510 = state_80465__$1;
(statearr_80479_80510[(2)] = inst_80456);

(statearr_80479_80510[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (9))){
var state_80465__$1 = state_80465;
if(cljs.core.truth_(close_QMARK_)){
var statearr_80480_80511 = state_80465__$1;
(statearr_80480_80511[(1)] = (11));

} else {
var statearr_80481_80512 = state_80465__$1;
(statearr_80481_80512[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (5))){
var inst_80442 = (state_80465[(7)]);
var state_80465__$1 = state_80465;
var statearr_80482_80513 = state_80465__$1;
(statearr_80482_80513[(2)] = inst_80442);

(statearr_80482_80513[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (10))){
var inst_80461 = (state_80465[(2)]);
var state_80465__$1 = state_80465;
var statearr_80483_80514 = state_80465__$1;
(statearr_80483_80514[(2)] = inst_80461);

(statearr_80483_80514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80466 === (8))){
var inst_80442 = (state_80465[(7)]);
var inst_80452 = cljs.core.next.call(null,inst_80442);
var inst_80442__$1 = inst_80452;
var state_80465__$1 = (function (){var statearr_80484 = state_80465;
(statearr_80484[(7)] = inst_80442__$1);

return statearr_80484;
})();
var statearr_80485_80515 = state_80465__$1;
(statearr_80485_80515[(2)] = null);

(statearr_80485_80515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_80486 = [null,null,null,null,null,null,null,null];
(statearr_80486[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_80486[(1)] = (1));

return statearr_80486;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_80465){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80487){if((e80487 instanceof Object)){
var ex__42019__auto__ = e80487;
var statearr_80488_80516 = state_80465;
(statearr_80488_80516[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80465);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80487;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80517 = state_80465;
state_80465 = G__80517;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_80465){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_80465);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_80489 = f__42037__auto__.call(null);
(statearr_80489[(6)] = c__42036__auto__);

return statearr_80489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28824__auto__ = (((_ == null))?null:_);
var m__28825__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,_);
} else {
var m__28825__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28825__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m);
} else {
var m__28825__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async80521 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async80521 = (function (ch,cs,meta80522){
this.ch = ch;
this.cs = cs;
this.meta80522 = meta80522;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async80521.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_80523,meta80522__$1){
var self__ = this;
var _80523__$1 = this;
return (new cljs.core.async.t_cljs$core$async80521(self__.ch,self__.cs,meta80522__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async80521.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_80523){
var self__ = this;
var _80523__$1 = this;
return self__.meta80522;
});})(cs))
;


cljs.core.async.t_cljs$core$async80521.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async80521.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async80521.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async80521.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async80521.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async80521.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async80521.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta80522","meta80522",38491434,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async80521.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async80521.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async80521";

cljs.core.async.t_cljs$core$async80521.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async80521");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async80521 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async80521(ch__$1,cs__$1,meta80522){
return (new cljs.core.async.t_cljs$core$async80521(ch__$1,cs__$1,meta80522));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async80521(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__42036__auto___80755 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___80755,cs,m,dchan,dctr,done){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___80755,cs,m,dchan,dctr,done){
return (function (state_80661){
var state_val_80662 = (state_80661[(1)]);
if((state_val_80662 === (7))){
var inst_80657 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80663_80756 = state_80661__$1;
(statearr_80663_80756[(2)] = inst_80657);

(statearr_80663_80756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (20))){
var inst_80560 = (state_80661[(7)]);
var inst_80572 = cljs.core.first.call(null,inst_80560);
var inst_80573 = cljs.core.nth.call(null,inst_80572,(0),null);
var inst_80574 = cljs.core.nth.call(null,inst_80572,(1),null);
var state_80661__$1 = (function (){var statearr_80664 = state_80661;
(statearr_80664[(8)] = inst_80573);

return statearr_80664;
})();
if(cljs.core.truth_(inst_80574)){
var statearr_80665_80757 = state_80661__$1;
(statearr_80665_80757[(1)] = (22));

} else {
var statearr_80666_80758 = state_80661__$1;
(statearr_80666_80758[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (27))){
var inst_80609 = (state_80661[(9)]);
var inst_80602 = (state_80661[(10)]);
var inst_80529 = (state_80661[(11)]);
var inst_80604 = (state_80661[(12)]);
var inst_80609__$1 = cljs.core._nth.call(null,inst_80602,inst_80604);
var inst_80610 = cljs.core.async.put_BANG_.call(null,inst_80609__$1,inst_80529,done);
var state_80661__$1 = (function (){var statearr_80667 = state_80661;
(statearr_80667[(9)] = inst_80609__$1);

return statearr_80667;
})();
if(cljs.core.truth_(inst_80610)){
var statearr_80668_80762 = state_80661__$1;
(statearr_80668_80762[(1)] = (30));

} else {
var statearr_80670_80763 = state_80661__$1;
(statearr_80670_80763[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (1))){
var state_80661__$1 = state_80661;
var statearr_80673_80764 = state_80661__$1;
(statearr_80673_80764[(2)] = null);

(statearr_80673_80764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (24))){
var inst_80560 = (state_80661[(7)]);
var inst_80579 = (state_80661[(2)]);
var inst_80580 = cljs.core.next.call(null,inst_80560);
var inst_80538 = inst_80580;
var inst_80539 = null;
var inst_80540 = (0);
var inst_80541 = (0);
var state_80661__$1 = (function (){var statearr_80674 = state_80661;
(statearr_80674[(13)] = inst_80540);

(statearr_80674[(14)] = inst_80539);

(statearr_80674[(15)] = inst_80579);

(statearr_80674[(16)] = inst_80541);

(statearr_80674[(17)] = inst_80538);

return statearr_80674;
})();
var statearr_80675_80765 = state_80661__$1;
(statearr_80675_80765[(2)] = null);

(statearr_80675_80765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (39))){
var state_80661__$1 = state_80661;
var statearr_80679_80766 = state_80661__$1;
(statearr_80679_80766[(2)] = null);

(statearr_80679_80766[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (4))){
var inst_80529 = (state_80661[(11)]);
var inst_80529__$1 = (state_80661[(2)]);
var inst_80530 = (inst_80529__$1 == null);
var state_80661__$1 = (function (){var statearr_80680 = state_80661;
(statearr_80680[(11)] = inst_80529__$1);

return statearr_80680;
})();
if(cljs.core.truth_(inst_80530)){
var statearr_80681_80767 = state_80661__$1;
(statearr_80681_80767[(1)] = (5));

} else {
var statearr_80682_80768 = state_80661__$1;
(statearr_80682_80768[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (15))){
var inst_80540 = (state_80661[(13)]);
var inst_80539 = (state_80661[(14)]);
var inst_80541 = (state_80661[(16)]);
var inst_80538 = (state_80661[(17)]);
var inst_80556 = (state_80661[(2)]);
var inst_80557 = (inst_80541 + (1));
var tmp80676 = inst_80540;
var tmp80677 = inst_80539;
var tmp80678 = inst_80538;
var inst_80538__$1 = tmp80678;
var inst_80539__$1 = tmp80677;
var inst_80540__$1 = tmp80676;
var inst_80541__$1 = inst_80557;
var state_80661__$1 = (function (){var statearr_80683 = state_80661;
(statearr_80683[(13)] = inst_80540__$1);

(statearr_80683[(18)] = inst_80556);

(statearr_80683[(14)] = inst_80539__$1);

(statearr_80683[(16)] = inst_80541__$1);

(statearr_80683[(17)] = inst_80538__$1);

return statearr_80683;
})();
var statearr_80684_80769 = state_80661__$1;
(statearr_80684_80769[(2)] = null);

(statearr_80684_80769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (21))){
var inst_80583 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80688_80770 = state_80661__$1;
(statearr_80688_80770[(2)] = inst_80583);

(statearr_80688_80770[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (31))){
var inst_80609 = (state_80661[(9)]);
var inst_80613 = done.call(null,null);
var inst_80614 = cljs.core.async.untap_STAR_.call(null,m,inst_80609);
var state_80661__$1 = (function (){var statearr_80689 = state_80661;
(statearr_80689[(19)] = inst_80613);

return statearr_80689;
})();
var statearr_80690_80771 = state_80661__$1;
(statearr_80690_80771[(2)] = inst_80614);

(statearr_80690_80771[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (32))){
var inst_80602 = (state_80661[(10)]);
var inst_80603 = (state_80661[(20)]);
var inst_80604 = (state_80661[(12)]);
var inst_80601 = (state_80661[(21)]);
var inst_80616 = (state_80661[(2)]);
var inst_80617 = (inst_80604 + (1));
var tmp80685 = inst_80602;
var tmp80686 = inst_80603;
var tmp80687 = inst_80601;
var inst_80601__$1 = tmp80687;
var inst_80602__$1 = tmp80685;
var inst_80603__$1 = tmp80686;
var inst_80604__$1 = inst_80617;
var state_80661__$1 = (function (){var statearr_80691 = state_80661;
(statearr_80691[(10)] = inst_80602__$1);

(statearr_80691[(20)] = inst_80603__$1);

(statearr_80691[(12)] = inst_80604__$1);

(statearr_80691[(21)] = inst_80601__$1);

(statearr_80691[(22)] = inst_80616);

return statearr_80691;
})();
var statearr_80692_80775 = state_80661__$1;
(statearr_80692_80775[(2)] = null);

(statearr_80692_80775[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (40))){
var inst_80629 = (state_80661[(23)]);
var inst_80633 = done.call(null,null);
var inst_80634 = cljs.core.async.untap_STAR_.call(null,m,inst_80629);
var state_80661__$1 = (function (){var statearr_80693 = state_80661;
(statearr_80693[(24)] = inst_80633);

return statearr_80693;
})();
var statearr_80694_80776 = state_80661__$1;
(statearr_80694_80776[(2)] = inst_80634);

(statearr_80694_80776[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (33))){
var inst_80620 = (state_80661[(25)]);
var inst_80622 = cljs.core.chunked_seq_QMARK_.call(null,inst_80620);
var state_80661__$1 = state_80661;
if(inst_80622){
var statearr_80695_80777 = state_80661__$1;
(statearr_80695_80777[(1)] = (36));

} else {
var statearr_80696_80778 = state_80661__$1;
(statearr_80696_80778[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (13))){
var inst_80550 = (state_80661[(26)]);
var inst_80553 = cljs.core.async.close_BANG_.call(null,inst_80550);
var state_80661__$1 = state_80661;
var statearr_80697_80779 = state_80661__$1;
(statearr_80697_80779[(2)] = inst_80553);

(statearr_80697_80779[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (22))){
var inst_80573 = (state_80661[(8)]);
var inst_80576 = cljs.core.async.close_BANG_.call(null,inst_80573);
var state_80661__$1 = state_80661;
var statearr_80698_80780 = state_80661__$1;
(statearr_80698_80780[(2)] = inst_80576);

(statearr_80698_80780[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (36))){
var inst_80620 = (state_80661[(25)]);
var inst_80624 = cljs.core.chunk_first.call(null,inst_80620);
var inst_80625 = cljs.core.chunk_rest.call(null,inst_80620);
var inst_80626 = cljs.core.count.call(null,inst_80624);
var inst_80601 = inst_80625;
var inst_80602 = inst_80624;
var inst_80603 = inst_80626;
var inst_80604 = (0);
var state_80661__$1 = (function (){var statearr_80699 = state_80661;
(statearr_80699[(10)] = inst_80602);

(statearr_80699[(20)] = inst_80603);

(statearr_80699[(12)] = inst_80604);

(statearr_80699[(21)] = inst_80601);

return statearr_80699;
})();
var statearr_80700_80781 = state_80661__$1;
(statearr_80700_80781[(2)] = null);

(statearr_80700_80781[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (41))){
var inst_80620 = (state_80661[(25)]);
var inst_80636 = (state_80661[(2)]);
var inst_80637 = cljs.core.next.call(null,inst_80620);
var inst_80601 = inst_80637;
var inst_80602 = null;
var inst_80603 = (0);
var inst_80604 = (0);
var state_80661__$1 = (function (){var statearr_80701 = state_80661;
(statearr_80701[(10)] = inst_80602);

(statearr_80701[(20)] = inst_80603);

(statearr_80701[(27)] = inst_80636);

(statearr_80701[(12)] = inst_80604);

(statearr_80701[(21)] = inst_80601);

return statearr_80701;
})();
var statearr_80702_80782 = state_80661__$1;
(statearr_80702_80782[(2)] = null);

(statearr_80702_80782[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (43))){
var state_80661__$1 = state_80661;
var statearr_80703_80783 = state_80661__$1;
(statearr_80703_80783[(2)] = null);

(statearr_80703_80783[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (29))){
var inst_80645 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80704_80784 = state_80661__$1;
(statearr_80704_80784[(2)] = inst_80645);

(statearr_80704_80784[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (44))){
var inst_80654 = (state_80661[(2)]);
var state_80661__$1 = (function (){var statearr_80705 = state_80661;
(statearr_80705[(28)] = inst_80654);

return statearr_80705;
})();
var statearr_80706_80788 = state_80661__$1;
(statearr_80706_80788[(2)] = null);

(statearr_80706_80788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (6))){
var inst_80593 = (state_80661[(29)]);
var inst_80592 = cljs.core.deref.call(null,cs);
var inst_80593__$1 = cljs.core.keys.call(null,inst_80592);
var inst_80594 = cljs.core.count.call(null,inst_80593__$1);
var inst_80595 = cljs.core.reset_BANG_.call(null,dctr,inst_80594);
var inst_80600 = cljs.core.seq.call(null,inst_80593__$1);
var inst_80601 = inst_80600;
var inst_80602 = null;
var inst_80603 = (0);
var inst_80604 = (0);
var state_80661__$1 = (function (){var statearr_80707 = state_80661;
(statearr_80707[(10)] = inst_80602);

(statearr_80707[(29)] = inst_80593__$1);

(statearr_80707[(20)] = inst_80603);

(statearr_80707[(30)] = inst_80595);

(statearr_80707[(12)] = inst_80604);

(statearr_80707[(21)] = inst_80601);

return statearr_80707;
})();
var statearr_80708_80789 = state_80661__$1;
(statearr_80708_80789[(2)] = null);

(statearr_80708_80789[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (28))){
var inst_80620 = (state_80661[(25)]);
var inst_80601 = (state_80661[(21)]);
var inst_80620__$1 = cljs.core.seq.call(null,inst_80601);
var state_80661__$1 = (function (){var statearr_80709 = state_80661;
(statearr_80709[(25)] = inst_80620__$1);

return statearr_80709;
})();
if(inst_80620__$1){
var statearr_80710_80790 = state_80661__$1;
(statearr_80710_80790[(1)] = (33));

} else {
var statearr_80711_80791 = state_80661__$1;
(statearr_80711_80791[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (25))){
var inst_80603 = (state_80661[(20)]);
var inst_80604 = (state_80661[(12)]);
var inst_80606 = (inst_80604 < inst_80603);
var inst_80607 = inst_80606;
var state_80661__$1 = state_80661;
if(cljs.core.truth_(inst_80607)){
var statearr_80712_80793 = state_80661__$1;
(statearr_80712_80793[(1)] = (27));

} else {
var statearr_80713_80794 = state_80661__$1;
(statearr_80713_80794[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (34))){
var state_80661__$1 = state_80661;
var statearr_80714_80795 = state_80661__$1;
(statearr_80714_80795[(2)] = null);

(statearr_80714_80795[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (17))){
var state_80661__$1 = state_80661;
var statearr_80715_80796 = state_80661__$1;
(statearr_80715_80796[(2)] = null);

(statearr_80715_80796[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (3))){
var inst_80659 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80661__$1,inst_80659);
} else {
if((state_val_80662 === (12))){
var inst_80588 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80716_80797 = state_80661__$1;
(statearr_80716_80797[(2)] = inst_80588);

(statearr_80716_80797[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (2))){
var state_80661__$1 = state_80661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80661__$1,(4),ch);
} else {
if((state_val_80662 === (23))){
var state_80661__$1 = state_80661;
var statearr_80717_80798 = state_80661__$1;
(statearr_80717_80798[(2)] = null);

(statearr_80717_80798[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (35))){
var inst_80643 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80718_80799 = state_80661__$1;
(statearr_80718_80799[(2)] = inst_80643);

(statearr_80718_80799[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (19))){
var inst_80560 = (state_80661[(7)]);
var inst_80564 = cljs.core.chunk_first.call(null,inst_80560);
var inst_80565 = cljs.core.chunk_rest.call(null,inst_80560);
var inst_80566 = cljs.core.count.call(null,inst_80564);
var inst_80538 = inst_80565;
var inst_80539 = inst_80564;
var inst_80540 = inst_80566;
var inst_80541 = (0);
var state_80661__$1 = (function (){var statearr_80719 = state_80661;
(statearr_80719[(13)] = inst_80540);

(statearr_80719[(14)] = inst_80539);

(statearr_80719[(16)] = inst_80541);

(statearr_80719[(17)] = inst_80538);

return statearr_80719;
})();
var statearr_80720_80800 = state_80661__$1;
(statearr_80720_80800[(2)] = null);

(statearr_80720_80800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (11))){
var inst_80560 = (state_80661[(7)]);
var inst_80538 = (state_80661[(17)]);
var inst_80560__$1 = cljs.core.seq.call(null,inst_80538);
var state_80661__$1 = (function (){var statearr_80721 = state_80661;
(statearr_80721[(7)] = inst_80560__$1);

return statearr_80721;
})();
if(inst_80560__$1){
var statearr_80722_80803 = state_80661__$1;
(statearr_80722_80803[(1)] = (16));

} else {
var statearr_80726_80807 = state_80661__$1;
(statearr_80726_80807[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (9))){
var inst_80590 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80727_80808 = state_80661__$1;
(statearr_80727_80808[(2)] = inst_80590);

(statearr_80727_80808[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (5))){
var inst_80536 = cljs.core.deref.call(null,cs);
var inst_80537 = cljs.core.seq.call(null,inst_80536);
var inst_80538 = inst_80537;
var inst_80539 = null;
var inst_80540 = (0);
var inst_80541 = (0);
var state_80661__$1 = (function (){var statearr_80728 = state_80661;
(statearr_80728[(13)] = inst_80540);

(statearr_80728[(14)] = inst_80539);

(statearr_80728[(16)] = inst_80541);

(statearr_80728[(17)] = inst_80538);

return statearr_80728;
})();
var statearr_80729_80809 = state_80661__$1;
(statearr_80729_80809[(2)] = null);

(statearr_80729_80809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (14))){
var state_80661__$1 = state_80661;
var statearr_80730_80810 = state_80661__$1;
(statearr_80730_80810[(2)] = null);

(statearr_80730_80810[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (45))){
var inst_80651 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80731_80811 = state_80661__$1;
(statearr_80731_80811[(2)] = inst_80651);

(statearr_80731_80811[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (26))){
var inst_80593 = (state_80661[(29)]);
var inst_80647 = (state_80661[(2)]);
var inst_80648 = cljs.core.seq.call(null,inst_80593);
var state_80661__$1 = (function (){var statearr_80732 = state_80661;
(statearr_80732[(31)] = inst_80647);

return statearr_80732;
})();
if(inst_80648){
var statearr_80733_80812 = state_80661__$1;
(statearr_80733_80812[(1)] = (42));

} else {
var statearr_80734_80813 = state_80661__$1;
(statearr_80734_80813[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (16))){
var inst_80560 = (state_80661[(7)]);
var inst_80562 = cljs.core.chunked_seq_QMARK_.call(null,inst_80560);
var state_80661__$1 = state_80661;
if(inst_80562){
var statearr_80735_80814 = state_80661__$1;
(statearr_80735_80814[(1)] = (19));

} else {
var statearr_80736_80815 = state_80661__$1;
(statearr_80736_80815[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (38))){
var inst_80640 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80737_80816 = state_80661__$1;
(statearr_80737_80816[(2)] = inst_80640);

(statearr_80737_80816[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (30))){
var state_80661__$1 = state_80661;
var statearr_80738_80817 = state_80661__$1;
(statearr_80738_80817[(2)] = null);

(statearr_80738_80817[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (10))){
var inst_80539 = (state_80661[(14)]);
var inst_80541 = (state_80661[(16)]);
var inst_80549 = cljs.core._nth.call(null,inst_80539,inst_80541);
var inst_80550 = cljs.core.nth.call(null,inst_80549,(0),null);
var inst_80551 = cljs.core.nth.call(null,inst_80549,(1),null);
var state_80661__$1 = (function (){var statearr_80739 = state_80661;
(statearr_80739[(26)] = inst_80550);

return statearr_80739;
})();
if(cljs.core.truth_(inst_80551)){
var statearr_80740_80821 = state_80661__$1;
(statearr_80740_80821[(1)] = (13));

} else {
var statearr_80741_80822 = state_80661__$1;
(statearr_80741_80822[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (18))){
var inst_80586 = (state_80661[(2)]);
var state_80661__$1 = state_80661;
var statearr_80742_80823 = state_80661__$1;
(statearr_80742_80823[(2)] = inst_80586);

(statearr_80742_80823[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (42))){
var state_80661__$1 = state_80661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80661__$1,(45),dchan);
} else {
if((state_val_80662 === (37))){
var inst_80629 = (state_80661[(23)]);
var inst_80529 = (state_80661[(11)]);
var inst_80620 = (state_80661[(25)]);
var inst_80629__$1 = cljs.core.first.call(null,inst_80620);
var inst_80630 = cljs.core.async.put_BANG_.call(null,inst_80629__$1,inst_80529,done);
var state_80661__$1 = (function (){var statearr_80743 = state_80661;
(statearr_80743[(23)] = inst_80629__$1);

return statearr_80743;
})();
if(cljs.core.truth_(inst_80630)){
var statearr_80744_80824 = state_80661__$1;
(statearr_80744_80824[(1)] = (39));

} else {
var statearr_80745_80825 = state_80661__$1;
(statearr_80745_80825[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80662 === (8))){
var inst_80540 = (state_80661[(13)]);
var inst_80541 = (state_80661[(16)]);
var inst_80543 = (inst_80541 < inst_80540);
var inst_80544 = inst_80543;
var state_80661__$1 = state_80661;
if(cljs.core.truth_(inst_80544)){
var statearr_80746_80826 = state_80661__$1;
(statearr_80746_80826[(1)] = (10));

} else {
var statearr_80747_80827 = state_80661__$1;
(statearr_80747_80827[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___80755,cs,m,dchan,dctr,done))
;
return ((function (switch__42015__auto__,c__42036__auto___80755,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__42016__auto__ = null;
var cljs$core$async$mult_$_state_machine__42016__auto____0 = (function (){
var statearr_80748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80748[(0)] = cljs$core$async$mult_$_state_machine__42016__auto__);

(statearr_80748[(1)] = (1));

return statearr_80748;
});
var cljs$core$async$mult_$_state_machine__42016__auto____1 = (function (state_80661){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e80749){if((e80749 instanceof Object)){
var ex__42019__auto__ = e80749;
var statearr_80750_80828 = state_80661;
(statearr_80750_80828[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80661);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80749;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80829 = state_80661;
state_80661 = G__80829;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42016__auto__ = function(state_80661){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42016__auto____1.call(this,state_80661);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42016__auto____0;
cljs$core$async$mult_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42016__auto____1;
return cljs$core$async$mult_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___80755,cs,m,dchan,dctr,done))
})();
var state__42038__auto__ = (function (){var statearr_80751 = f__42037__auto__.call(null);
(statearr_80751[(6)] = c__42036__auto___80755);

return statearr_80751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___80755,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__80834 = arguments.length;
switch (G__80834) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m);
} else {
var m__28825__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,state_map);
} else {
var m__28825__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,mode);
} else {
var m__28825__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___80852 = arguments.length;
var i__29313__auto___80853 = (0);
while(true){
if((i__29313__auto___80853 < len__29312__auto___80852)){
args__29319__auto__.push((arguments[i__29313__auto___80853]));

var G__80854 = (i__29313__auto___80853 + (1));
i__29313__auto___80853 = G__80854;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__80846){
var map__80847 = p__80846;
var map__80847__$1 = ((((!((map__80847 == null)))?((((map__80847.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80847.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__80847):map__80847);
var opts = map__80847__$1;
var statearr_80849_80860 = state;
(statearr_80849_80860[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__80847,map__80847__$1,opts){
return (function (val){
var statearr_80850_80861 = state;
(statearr_80850_80861[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__80847,map__80847__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_80851_80862 = state;
(statearr_80851_80862[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq80842){
var G__80843 = cljs.core.first.call(null,seq80842);
var seq80842__$1 = cljs.core.next.call(null,seq80842);
var G__80844 = cljs.core.first.call(null,seq80842__$1);
var seq80842__$2 = cljs.core.next.call(null,seq80842__$1);
var G__80845 = cljs.core.first.call(null,seq80842__$2);
var seq80842__$3 = cljs.core.next.call(null,seq80842__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__80843,G__80844,G__80845,seq80842__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async80864 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async80864 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta80865){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta80865 = meta80865;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_80866,meta80865__$1){
var self__ = this;
var _80866__$1 = this;
return (new cljs.core.async.t_cljs$core$async80864(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta80865__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_80866){
var self__ = this;
var _80866__$1 = this;
return self__.meta80865;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async80864.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80864.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta80865","meta80865",2037987558,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80864.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async80864.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async80864";

cljs.core.async.t_cljs$core$async80864.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async80864");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async80864 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async80864(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta80865){
return (new cljs.core.async.t_cljs$core$async80864(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta80865));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async80864(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42036__auto___81052 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81052,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81052,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_80975){
var state_val_80976 = (state_80975[(1)]);
if((state_val_80976 === (7))){
var inst_80883 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
var statearr_80977_81056 = state_80975__$1;
(statearr_80977_81056[(2)] = inst_80883);

(statearr_80977_81056[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (20))){
var inst_80896 = (state_80975[(7)]);
var state_80975__$1 = state_80975;
var statearr_80978_81057 = state_80975__$1;
(statearr_80978_81057[(2)] = inst_80896);

(statearr_80978_81057[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (27))){
var state_80975__$1 = state_80975;
var statearr_80979_81058 = state_80975__$1;
(statearr_80979_81058[(2)] = null);

(statearr_80979_81058[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (1))){
var inst_80870 = (state_80975[(8)]);
var inst_80870__$1 = calc_state.call(null);
var inst_80872 = (inst_80870__$1 == null);
var inst_80873 = cljs.core.not.call(null,inst_80872);
var state_80975__$1 = (function (){var statearr_80980 = state_80975;
(statearr_80980[(8)] = inst_80870__$1);

return statearr_80980;
})();
if(inst_80873){
var statearr_80982_81059 = state_80975__$1;
(statearr_80982_81059[(1)] = (2));

} else {
var statearr_80983_81060 = state_80975__$1;
(statearr_80983_81060[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (24))){
var inst_80932 = (state_80975[(9)]);
var inst_80949 = (state_80975[(10)]);
var inst_80923 = (state_80975[(11)]);
var inst_80949__$1 = inst_80923.call(null,inst_80932);
var state_80975__$1 = (function (){var statearr_80984 = state_80975;
(statearr_80984[(10)] = inst_80949__$1);

return statearr_80984;
})();
if(cljs.core.truth_(inst_80949__$1)){
var statearr_80985_81061 = state_80975__$1;
(statearr_80985_81061[(1)] = (29));

} else {
var statearr_80986_81062 = state_80975__$1;
(statearr_80986_81062[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (4))){
var inst_80886 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
if(cljs.core.truth_(inst_80886)){
var statearr_80987_81063 = state_80975__$1;
(statearr_80987_81063[(1)] = (8));

} else {
var statearr_80988_81064 = state_80975__$1;
(statearr_80988_81064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (15))){
var inst_80915 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
if(cljs.core.truth_(inst_80915)){
var statearr_80989_81065 = state_80975__$1;
(statearr_80989_81065[(1)] = (19));

} else {
var statearr_80990_81066 = state_80975__$1;
(statearr_80990_81066[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (21))){
var inst_80921 = (state_80975[(12)]);
var inst_80921__$1 = (state_80975[(2)]);
var inst_80923 = cljs.core.get.call(null,inst_80921__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_80924 = cljs.core.get.call(null,inst_80921__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_80925 = cljs.core.get.call(null,inst_80921__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_80975__$1 = (function (){var statearr_80991 = state_80975;
(statearr_80991[(12)] = inst_80921__$1);

(statearr_80991[(13)] = inst_80924);

(statearr_80991[(11)] = inst_80923);

return statearr_80991;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80975__$1,(22),inst_80925);
} else {
if((state_val_80976 === (31))){
var inst_80957 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
if(cljs.core.truth_(inst_80957)){
var statearr_80992_81067 = state_80975__$1;
(statearr_80992_81067[(1)] = (32));

} else {
var statearr_80993_81068 = state_80975__$1;
(statearr_80993_81068[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (32))){
var inst_80931 = (state_80975[(14)]);
var state_80975__$1 = state_80975;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80975__$1,(35),out,inst_80931);
} else {
if((state_val_80976 === (33))){
var inst_80921 = (state_80975[(12)]);
var inst_80896 = inst_80921;
var state_80975__$1 = (function (){var statearr_80994 = state_80975;
(statearr_80994[(7)] = inst_80896);

return statearr_80994;
})();
var statearr_80995_81069 = state_80975__$1;
(statearr_80995_81069[(2)] = null);

(statearr_80995_81069[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (13))){
var inst_80896 = (state_80975[(7)]);
var inst_80904 = inst_80896.cljs$lang$protocol_mask$partition0$;
var inst_80905 = (inst_80904 & (64));
var inst_80906 = inst_80896.cljs$core$ISeq$;
var inst_80907 = (cljs.core.PROTOCOL_SENTINEL === inst_80906);
var inst_80908 = (inst_80905) || (inst_80907);
var state_80975__$1 = state_80975;
if(cljs.core.truth_(inst_80908)){
var statearr_80996_81073 = state_80975__$1;
(statearr_80996_81073[(1)] = (16));

} else {
var statearr_80997_81074 = state_80975__$1;
(statearr_80997_81074[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (22))){
var inst_80932 = (state_80975[(9)]);
var inst_80931 = (state_80975[(14)]);
var inst_80930 = (state_80975[(2)]);
var inst_80931__$1 = cljs.core.nth.call(null,inst_80930,(0),null);
var inst_80932__$1 = cljs.core.nth.call(null,inst_80930,(1),null);
var inst_80936 = (inst_80931__$1 == null);
var inst_80937 = cljs.core._EQ_.call(null,inst_80932__$1,change);
var inst_80938 = (inst_80936) || (inst_80937);
var state_80975__$1 = (function (){var statearr_80998 = state_80975;
(statearr_80998[(9)] = inst_80932__$1);

(statearr_80998[(14)] = inst_80931__$1);

return statearr_80998;
})();
if(cljs.core.truth_(inst_80938)){
var statearr_80999_81075 = state_80975__$1;
(statearr_80999_81075[(1)] = (23));

} else {
var statearr_81000_81076 = state_80975__$1;
(statearr_81000_81076[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (36))){
var inst_80921 = (state_80975[(12)]);
var inst_80896 = inst_80921;
var state_80975__$1 = (function (){var statearr_81001 = state_80975;
(statearr_81001[(7)] = inst_80896);

return statearr_81001;
})();
var statearr_81002_81077 = state_80975__$1;
(statearr_81002_81077[(2)] = null);

(statearr_81002_81077[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (29))){
var inst_80949 = (state_80975[(10)]);
var state_80975__$1 = state_80975;
var statearr_81003_81078 = state_80975__$1;
(statearr_81003_81078[(2)] = inst_80949);

(statearr_81003_81078[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (6))){
var state_80975__$1 = state_80975;
var statearr_81005_81079 = state_80975__$1;
(statearr_81005_81079[(2)] = false);

(statearr_81005_81079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (28))){
var inst_80945 = (state_80975[(2)]);
var inst_80946 = calc_state.call(null);
var inst_80896 = inst_80946;
var state_80975__$1 = (function (){var statearr_81007 = state_80975;
(statearr_81007[(7)] = inst_80896);

(statearr_81007[(15)] = inst_80945);

return statearr_81007;
})();
var statearr_81008_81080 = state_80975__$1;
(statearr_81008_81080[(2)] = null);

(statearr_81008_81080[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (25))){
var inst_80971 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
var statearr_81009_81081 = state_80975__$1;
(statearr_81009_81081[(2)] = inst_80971);

(statearr_81009_81081[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (34))){
var inst_80969 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
var statearr_81010_81082 = state_80975__$1;
(statearr_81010_81082[(2)] = inst_80969);

(statearr_81010_81082[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (17))){
var state_80975__$1 = state_80975;
var statearr_81012_81083 = state_80975__$1;
(statearr_81012_81083[(2)] = false);

(statearr_81012_81083[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (3))){
var state_80975__$1 = state_80975;
var statearr_81014_81084 = state_80975__$1;
(statearr_81014_81084[(2)] = false);

(statearr_81014_81084[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (12))){
var inst_80973 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80975__$1,inst_80973);
} else {
if((state_val_80976 === (2))){
var inst_80870 = (state_80975[(8)]);
var inst_80875 = inst_80870.cljs$lang$protocol_mask$partition0$;
var inst_80876 = (inst_80875 & (64));
var inst_80877 = inst_80870.cljs$core$ISeq$;
var inst_80878 = (cljs.core.PROTOCOL_SENTINEL === inst_80877);
var inst_80879 = (inst_80876) || (inst_80878);
var state_80975__$1 = state_80975;
if(cljs.core.truth_(inst_80879)){
var statearr_81016_81088 = state_80975__$1;
(statearr_81016_81088[(1)] = (5));

} else {
var statearr_81017_81089 = state_80975__$1;
(statearr_81017_81089[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (23))){
var inst_80931 = (state_80975[(14)]);
var inst_80940 = (inst_80931 == null);
var state_80975__$1 = state_80975;
if(cljs.core.truth_(inst_80940)){
var statearr_81021_81090 = state_80975__$1;
(statearr_81021_81090[(1)] = (26));

} else {
var statearr_81022_81091 = state_80975__$1;
(statearr_81022_81091[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (35))){
var inst_80960 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
if(cljs.core.truth_(inst_80960)){
var statearr_81023_81092 = state_80975__$1;
(statearr_81023_81092[(1)] = (36));

} else {
var statearr_81024_81093 = state_80975__$1;
(statearr_81024_81093[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (19))){
var inst_80896 = (state_80975[(7)]);
var inst_80918 = cljs.core.apply.call(null,cljs.core.hash_map,inst_80896);
var state_80975__$1 = state_80975;
var statearr_81025_81094 = state_80975__$1;
(statearr_81025_81094[(2)] = inst_80918);

(statearr_81025_81094[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (11))){
var inst_80896 = (state_80975[(7)]);
var inst_80901 = (inst_80896 == null);
var inst_80902 = cljs.core.not.call(null,inst_80901);
var state_80975__$1 = state_80975;
if(inst_80902){
var statearr_81026_81095 = state_80975__$1;
(statearr_81026_81095[(1)] = (13));

} else {
var statearr_81027_81096 = state_80975__$1;
(statearr_81027_81096[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (9))){
var inst_80870 = (state_80975[(8)]);
var state_80975__$1 = state_80975;
var statearr_81028_81097 = state_80975__$1;
(statearr_81028_81097[(2)] = inst_80870);

(statearr_81028_81097[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (5))){
var state_80975__$1 = state_80975;
var statearr_81029_81098 = state_80975__$1;
(statearr_81029_81098[(2)] = true);

(statearr_81029_81098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (14))){
var state_80975__$1 = state_80975;
var statearr_81030_81099 = state_80975__$1;
(statearr_81030_81099[(2)] = false);

(statearr_81030_81099[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (26))){
var inst_80932 = (state_80975[(9)]);
var inst_80942 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_80932);
var state_80975__$1 = state_80975;
var statearr_81031_81100 = state_80975__$1;
(statearr_81031_81100[(2)] = inst_80942);

(statearr_81031_81100[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (16))){
var state_80975__$1 = state_80975;
var statearr_81032_81101 = state_80975__$1;
(statearr_81032_81101[(2)] = true);

(statearr_81032_81101[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (38))){
var inst_80965 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
var statearr_81033_81102 = state_80975__$1;
(statearr_81033_81102[(2)] = inst_80965);

(statearr_81033_81102[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (30))){
var inst_80932 = (state_80975[(9)]);
var inst_80924 = (state_80975[(13)]);
var inst_80923 = (state_80975[(11)]);
var inst_80952 = cljs.core.empty_QMARK_.call(null,inst_80923);
var inst_80953 = inst_80924.call(null,inst_80932);
var inst_80954 = cljs.core.not.call(null,inst_80953);
var inst_80955 = (inst_80952) && (inst_80954);
var state_80975__$1 = state_80975;
var statearr_81034_81103 = state_80975__$1;
(statearr_81034_81103[(2)] = inst_80955);

(statearr_81034_81103[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (10))){
var inst_80870 = (state_80975[(8)]);
var inst_80891 = (state_80975[(2)]);
var inst_80892 = cljs.core.get.call(null,inst_80891,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_80893 = cljs.core.get.call(null,inst_80891,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_80894 = cljs.core.get.call(null,inst_80891,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_80896 = inst_80870;
var state_80975__$1 = (function (){var statearr_81035 = state_80975;
(statearr_81035[(16)] = inst_80892);

(statearr_81035[(7)] = inst_80896);

(statearr_81035[(17)] = inst_80893);

(statearr_81035[(18)] = inst_80894);

return statearr_81035;
})();
var statearr_81036_81107 = state_80975__$1;
(statearr_81036_81107[(2)] = null);

(statearr_81036_81107[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (18))){
var inst_80912 = (state_80975[(2)]);
var state_80975__$1 = state_80975;
var statearr_81037_81108 = state_80975__$1;
(statearr_81037_81108[(2)] = inst_80912);

(statearr_81037_81108[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (37))){
var state_80975__$1 = state_80975;
var statearr_81038_81109 = state_80975__$1;
(statearr_81038_81109[(2)] = null);

(statearr_81038_81109[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80976 === (8))){
var inst_80870 = (state_80975[(8)]);
var inst_80888 = cljs.core.apply.call(null,cljs.core.hash_map,inst_80870);
var state_80975__$1 = state_80975;
var statearr_81039_81110 = state_80975__$1;
(statearr_81039_81110[(2)] = inst_80888);

(statearr_81039_81110[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81052,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__42015__auto__,c__42036__auto___81052,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__42016__auto__ = null;
var cljs$core$async$mix_$_state_machine__42016__auto____0 = (function (){
var statearr_81040 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81040[(0)] = cljs$core$async$mix_$_state_machine__42016__auto__);

(statearr_81040[(1)] = (1));

return statearr_81040;
});
var cljs$core$async$mix_$_state_machine__42016__auto____1 = (function (state_80975){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_80975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81041){if((e81041 instanceof Object)){
var ex__42019__auto__ = e81041;
var statearr_81042_81111 = state_80975;
(statearr_81042_81111[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80975);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81112 = state_80975;
state_80975 = G__81112;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42016__auto__ = function(state_80975){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42016__auto____1.call(this,state_80975);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42016__auto____0;
cljs$core$async$mix_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42016__auto____1;
return cljs$core$async$mix_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81052,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__42038__auto__ = (function (){var statearr_81043 = f__42037__auto__.call(null);
(statearr_81043[(6)] = c__42036__auto___81052);

return statearr_81043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81052,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28825__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__81118 = arguments.length;
switch (G__81118) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__81133 = arguments.length;
switch (G__81133) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28141__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28141__auto__,mults){
return (function (p1__81128_SHARP_){
if(cljs.core.truth_(p1__81128_SHARP_.call(null,topic))){
return p1__81128_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__81128_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28141__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async81134 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81134 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta81135){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta81135 = meta81135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_81136,meta81135__$1){
var self__ = this;
var _81136__$1 = this;
return (new cljs.core.async.t_cljs$core$async81134(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta81135__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_81136){
var self__ = this;
var _81136__$1 = this;
return self__.meta81135;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async81134.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async81134.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta81135","meta81135",1810869881,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async81134.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81134.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81134";

cljs.core.async.t_cljs$core$async81134.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async81134");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async81134 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async81134(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta81135){
return (new cljs.core.async.t_cljs$core$async81134(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta81135));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async81134(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42036__auto___81274 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81274,mults,ensure_mult,p){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81274,mults,ensure_mult,p){
return (function (state_81213){
var state_val_81214 = (state_81213[(1)]);
if((state_val_81214 === (7))){
var inst_81207 = (state_81213[(2)]);
var state_81213__$1 = state_81213;
var statearr_81215_81275 = state_81213__$1;
(statearr_81215_81275[(2)] = inst_81207);

(statearr_81215_81275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (20))){
var state_81213__$1 = state_81213;
var statearr_81216_81276 = state_81213__$1;
(statearr_81216_81276[(2)] = null);

(statearr_81216_81276[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (1))){
var state_81213__$1 = state_81213;
var statearr_81217_81277 = state_81213__$1;
(statearr_81217_81277[(2)] = null);

(statearr_81217_81277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (24))){
var inst_81190 = (state_81213[(7)]);
var inst_81199 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_81190);
var state_81213__$1 = state_81213;
var statearr_81219_81278 = state_81213__$1;
(statearr_81219_81278[(2)] = inst_81199);

(statearr_81219_81278[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (4))){
var inst_81139 = (state_81213[(8)]);
var inst_81139__$1 = (state_81213[(2)]);
var inst_81140 = (inst_81139__$1 == null);
var state_81213__$1 = (function (){var statearr_81220 = state_81213;
(statearr_81220[(8)] = inst_81139__$1);

return statearr_81220;
})();
if(cljs.core.truth_(inst_81140)){
var statearr_81221_81279 = state_81213__$1;
(statearr_81221_81279[(1)] = (5));

} else {
var statearr_81222_81280 = state_81213__$1;
(statearr_81222_81280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (15))){
var inst_81184 = (state_81213[(2)]);
var state_81213__$1 = state_81213;
var statearr_81223_81281 = state_81213__$1;
(statearr_81223_81281[(2)] = inst_81184);

(statearr_81223_81281[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (21))){
var inst_81204 = (state_81213[(2)]);
var state_81213__$1 = (function (){var statearr_81224 = state_81213;
(statearr_81224[(9)] = inst_81204);

return statearr_81224;
})();
var statearr_81225_81282 = state_81213__$1;
(statearr_81225_81282[(2)] = null);

(statearr_81225_81282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (13))){
var inst_81166 = (state_81213[(10)]);
var inst_81168 = cljs.core.chunked_seq_QMARK_.call(null,inst_81166);
var state_81213__$1 = state_81213;
if(inst_81168){
var statearr_81226_81283 = state_81213__$1;
(statearr_81226_81283[(1)] = (16));

} else {
var statearr_81227_81284 = state_81213__$1;
(statearr_81227_81284[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (22))){
var inst_81196 = (state_81213[(2)]);
var state_81213__$1 = state_81213;
if(cljs.core.truth_(inst_81196)){
var statearr_81228_81285 = state_81213__$1;
(statearr_81228_81285[(1)] = (23));

} else {
var statearr_81229_81286 = state_81213__$1;
(statearr_81229_81286[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (6))){
var inst_81192 = (state_81213[(11)]);
var inst_81139 = (state_81213[(8)]);
var inst_81190 = (state_81213[(7)]);
var inst_81190__$1 = topic_fn.call(null,inst_81139);
var inst_81191 = cljs.core.deref.call(null,mults);
var inst_81192__$1 = cljs.core.get.call(null,inst_81191,inst_81190__$1);
var state_81213__$1 = (function (){var statearr_81230 = state_81213;
(statearr_81230[(11)] = inst_81192__$1);

(statearr_81230[(7)] = inst_81190__$1);

return statearr_81230;
})();
if(cljs.core.truth_(inst_81192__$1)){
var statearr_81231_81287 = state_81213__$1;
(statearr_81231_81287[(1)] = (19));

} else {
var statearr_81232_81288 = state_81213__$1;
(statearr_81232_81288[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (25))){
var inst_81201 = (state_81213[(2)]);
var state_81213__$1 = state_81213;
var statearr_81233_81289 = state_81213__$1;
(statearr_81233_81289[(2)] = inst_81201);

(statearr_81233_81289[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (17))){
var inst_81166 = (state_81213[(10)]);
var inst_81175 = cljs.core.first.call(null,inst_81166);
var inst_81176 = cljs.core.async.muxch_STAR_.call(null,inst_81175);
var inst_81177 = cljs.core.async.close_BANG_.call(null,inst_81176);
var inst_81178 = cljs.core.next.call(null,inst_81166);
var inst_81152 = inst_81178;
var inst_81153 = null;
var inst_81154 = (0);
var inst_81155 = (0);
var state_81213__$1 = (function (){var statearr_81234 = state_81213;
(statearr_81234[(12)] = inst_81153);

(statearr_81234[(13)] = inst_81154);

(statearr_81234[(14)] = inst_81177);

(statearr_81234[(15)] = inst_81155);

(statearr_81234[(16)] = inst_81152);

return statearr_81234;
})();
var statearr_81235_81290 = state_81213__$1;
(statearr_81235_81290[(2)] = null);

(statearr_81235_81290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (3))){
var inst_81210 = (state_81213[(2)]);
var state_81213__$1 = state_81213;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81213__$1,inst_81210);
} else {
if((state_val_81214 === (12))){
var inst_81186 = (state_81213[(2)]);
var state_81213__$1 = state_81213;
var statearr_81236_81291 = state_81213__$1;
(statearr_81236_81291[(2)] = inst_81186);

(statearr_81236_81291[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (2))){
var state_81213__$1 = state_81213;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81213__$1,(4),ch);
} else {
if((state_val_81214 === (23))){
var state_81213__$1 = state_81213;
var statearr_81237_81293 = state_81213__$1;
(statearr_81237_81293[(2)] = null);

(statearr_81237_81293[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (19))){
var inst_81192 = (state_81213[(11)]);
var inst_81139 = (state_81213[(8)]);
var inst_81194 = cljs.core.async.muxch_STAR_.call(null,inst_81192);
var state_81213__$1 = state_81213;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81213__$1,(22),inst_81194,inst_81139);
} else {
if((state_val_81214 === (11))){
var inst_81166 = (state_81213[(10)]);
var inst_81152 = (state_81213[(16)]);
var inst_81166__$1 = cljs.core.seq.call(null,inst_81152);
var state_81213__$1 = (function (){var statearr_81238 = state_81213;
(statearr_81238[(10)] = inst_81166__$1);

return statearr_81238;
})();
if(inst_81166__$1){
var statearr_81240_81298 = state_81213__$1;
(statearr_81240_81298[(1)] = (13));

} else {
var statearr_81241_81300 = state_81213__$1;
(statearr_81241_81300[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (9))){
var inst_81188 = (state_81213[(2)]);
var state_81213__$1 = state_81213;
var statearr_81243_81302 = state_81213__$1;
(statearr_81243_81302[(2)] = inst_81188);

(statearr_81243_81302[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (5))){
var inst_81146 = cljs.core.deref.call(null,mults);
var inst_81147 = cljs.core.vals.call(null,inst_81146);
var inst_81148 = cljs.core.seq.call(null,inst_81147);
var inst_81152 = inst_81148;
var inst_81153 = null;
var inst_81154 = (0);
var inst_81155 = (0);
var state_81213__$1 = (function (){var statearr_81247 = state_81213;
(statearr_81247[(12)] = inst_81153);

(statearr_81247[(13)] = inst_81154);

(statearr_81247[(15)] = inst_81155);

(statearr_81247[(16)] = inst_81152);

return statearr_81247;
})();
var statearr_81248_81306 = state_81213__$1;
(statearr_81248_81306[(2)] = null);

(statearr_81248_81306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (14))){
var state_81213__$1 = state_81213;
var statearr_81252_81308 = state_81213__$1;
(statearr_81252_81308[(2)] = null);

(statearr_81252_81308[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (16))){
var inst_81166 = (state_81213[(10)]);
var inst_81170 = cljs.core.chunk_first.call(null,inst_81166);
var inst_81171 = cljs.core.chunk_rest.call(null,inst_81166);
var inst_81172 = cljs.core.count.call(null,inst_81170);
var inst_81152 = inst_81171;
var inst_81153 = inst_81170;
var inst_81154 = inst_81172;
var inst_81155 = (0);
var state_81213__$1 = (function (){var statearr_81253 = state_81213;
(statearr_81253[(12)] = inst_81153);

(statearr_81253[(13)] = inst_81154);

(statearr_81253[(15)] = inst_81155);

(statearr_81253[(16)] = inst_81152);

return statearr_81253;
})();
var statearr_81254_81312 = state_81213__$1;
(statearr_81254_81312[(2)] = null);

(statearr_81254_81312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (10))){
var inst_81153 = (state_81213[(12)]);
var inst_81154 = (state_81213[(13)]);
var inst_81155 = (state_81213[(15)]);
var inst_81152 = (state_81213[(16)]);
var inst_81160 = cljs.core._nth.call(null,inst_81153,inst_81155);
var inst_81161 = cljs.core.async.muxch_STAR_.call(null,inst_81160);
var inst_81162 = cljs.core.async.close_BANG_.call(null,inst_81161);
var inst_81163 = (inst_81155 + (1));
var tmp81249 = inst_81153;
var tmp81250 = inst_81154;
var tmp81251 = inst_81152;
var inst_81152__$1 = tmp81251;
var inst_81153__$1 = tmp81249;
var inst_81154__$1 = tmp81250;
var inst_81155__$1 = inst_81163;
var state_81213__$1 = (function (){var statearr_81255 = state_81213;
(statearr_81255[(17)] = inst_81162);

(statearr_81255[(12)] = inst_81153__$1);

(statearr_81255[(13)] = inst_81154__$1);

(statearr_81255[(15)] = inst_81155__$1);

(statearr_81255[(16)] = inst_81152__$1);

return statearr_81255;
})();
var statearr_81256_81314 = state_81213__$1;
(statearr_81256_81314[(2)] = null);

(statearr_81256_81314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (18))){
var inst_81181 = (state_81213[(2)]);
var state_81213__$1 = state_81213;
var statearr_81257_81315 = state_81213__$1;
(statearr_81257_81315[(2)] = inst_81181);

(statearr_81257_81315[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81214 === (8))){
var inst_81154 = (state_81213[(13)]);
var inst_81155 = (state_81213[(15)]);
var inst_81157 = (inst_81155 < inst_81154);
var inst_81158 = inst_81157;
var state_81213__$1 = state_81213;
if(cljs.core.truth_(inst_81158)){
var statearr_81258_81316 = state_81213__$1;
(statearr_81258_81316[(1)] = (10));

} else {
var statearr_81259_81317 = state_81213__$1;
(statearr_81259_81317[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81274,mults,ensure_mult,p))
;
return ((function (switch__42015__auto__,c__42036__auto___81274,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_81260 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81260[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_81260[(1)] = (1));

return statearr_81260;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_81213){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81213);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81261){if((e81261 instanceof Object)){
var ex__42019__auto__ = e81261;
var statearr_81262_81318 = state_81213;
(statearr_81262_81318[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81213);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81261;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81319 = state_81213;
state_81213 = G__81319;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_81213){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_81213);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81274,mults,ensure_mult,p))
})();
var state__42038__auto__ = (function (){var statearr_81263 = f__42037__auto__.call(null);
(statearr_81263[(6)] = c__42036__auto___81274);

return statearr_81263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81274,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__81326 = arguments.length;
switch (G__81326) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__81338 = arguments.length;
switch (G__81338) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__81341 = arguments.length;
switch (G__81341) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__42036__auto___81411 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81411,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81411,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_81380){
var state_val_81381 = (state_81380[(1)]);
if((state_val_81381 === (7))){
var state_81380__$1 = state_81380;
var statearr_81382_81412 = state_81380__$1;
(statearr_81382_81412[(2)] = null);

(statearr_81382_81412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (1))){
var state_81380__$1 = state_81380;
var statearr_81383_81413 = state_81380__$1;
(statearr_81383_81413[(2)] = null);

(statearr_81383_81413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (4))){
var inst_81344 = (state_81380[(7)]);
var inst_81346 = (inst_81344 < cnt);
var state_81380__$1 = state_81380;
if(cljs.core.truth_(inst_81346)){
var statearr_81384_81414 = state_81380__$1;
(statearr_81384_81414[(1)] = (6));

} else {
var statearr_81385_81415 = state_81380__$1;
(statearr_81385_81415[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (15))){
var inst_81376 = (state_81380[(2)]);
var state_81380__$1 = state_81380;
var statearr_81386_81416 = state_81380__$1;
(statearr_81386_81416[(2)] = inst_81376);

(statearr_81386_81416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (13))){
var inst_81369 = cljs.core.async.close_BANG_.call(null,out);
var state_81380__$1 = state_81380;
var statearr_81387_81417 = state_81380__$1;
(statearr_81387_81417[(2)] = inst_81369);

(statearr_81387_81417[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (6))){
var state_81380__$1 = state_81380;
var statearr_81388_81418 = state_81380__$1;
(statearr_81388_81418[(2)] = null);

(statearr_81388_81418[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (3))){
var inst_81378 = (state_81380[(2)]);
var state_81380__$1 = state_81380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81380__$1,inst_81378);
} else {
if((state_val_81381 === (12))){
var inst_81366 = (state_81380[(8)]);
var inst_81366__$1 = (state_81380[(2)]);
var inst_81367 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_81366__$1);
var state_81380__$1 = (function (){var statearr_81389 = state_81380;
(statearr_81389[(8)] = inst_81366__$1);

return statearr_81389;
})();
if(cljs.core.truth_(inst_81367)){
var statearr_81390_81419 = state_81380__$1;
(statearr_81390_81419[(1)] = (13));

} else {
var statearr_81391_81420 = state_81380__$1;
(statearr_81391_81420[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (2))){
var inst_81343 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_81344 = (0);
var state_81380__$1 = (function (){var statearr_81392 = state_81380;
(statearr_81392[(7)] = inst_81344);

(statearr_81392[(9)] = inst_81343);

return statearr_81392;
})();
var statearr_81393_81421 = state_81380__$1;
(statearr_81393_81421[(2)] = null);

(statearr_81393_81421[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (11))){
var inst_81344 = (state_81380[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_81380,(10),Object,null,(9));
var inst_81353 = chs__$1.call(null,inst_81344);
var inst_81354 = done.call(null,inst_81344);
var inst_81355 = cljs.core.async.take_BANG_.call(null,inst_81353,inst_81354);
var state_81380__$1 = state_81380;
var statearr_81394_81422 = state_81380__$1;
(statearr_81394_81422[(2)] = inst_81355);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81380__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (9))){
var inst_81344 = (state_81380[(7)]);
var inst_81357 = (state_81380[(2)]);
var inst_81358 = (inst_81344 + (1));
var inst_81344__$1 = inst_81358;
var state_81380__$1 = (function (){var statearr_81395 = state_81380;
(statearr_81395[(10)] = inst_81357);

(statearr_81395[(7)] = inst_81344__$1);

return statearr_81395;
})();
var statearr_81396_81423 = state_81380__$1;
(statearr_81396_81423[(2)] = null);

(statearr_81396_81423[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (5))){
var inst_81364 = (state_81380[(2)]);
var state_81380__$1 = (function (){var statearr_81397 = state_81380;
(statearr_81397[(11)] = inst_81364);

return statearr_81397;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81380__$1,(12),dchan);
} else {
if((state_val_81381 === (14))){
var inst_81366 = (state_81380[(8)]);
var inst_81371 = cljs.core.apply.call(null,f,inst_81366);
var state_81380__$1 = state_81380;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81380__$1,(16),out,inst_81371);
} else {
if((state_val_81381 === (16))){
var inst_81373 = (state_81380[(2)]);
var state_81380__$1 = (function (){var statearr_81401 = state_81380;
(statearr_81401[(12)] = inst_81373);

return statearr_81401;
})();
var statearr_81402_81424 = state_81380__$1;
(statearr_81402_81424[(2)] = null);

(statearr_81402_81424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (10))){
var inst_81348 = (state_81380[(2)]);
var inst_81349 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_81380__$1 = (function (){var statearr_81403 = state_81380;
(statearr_81403[(13)] = inst_81348);

return statearr_81403;
})();
var statearr_81404_81425 = state_81380__$1;
(statearr_81404_81425[(2)] = inst_81349);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81380__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81381 === (8))){
var inst_81362 = (state_81380[(2)]);
var state_81380__$1 = state_81380;
var statearr_81405_81426 = state_81380__$1;
(statearr_81405_81426[(2)] = inst_81362);

(statearr_81405_81426[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81411,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__42015__auto__,c__42036__auto___81411,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_81406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81406[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_81406[(1)] = (1));

return statearr_81406;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_81380){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81407){if((e81407 instanceof Object)){
var ex__42019__auto__ = e81407;
var statearr_81408_81427 = state_81380;
(statearr_81408_81427[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81380);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81428 = state_81380;
state_81380 = G__81428;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_81380){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_81380);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81411,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__42038__auto__ = (function (){var statearr_81409 = f__42037__auto__.call(null);
(statearr_81409[(6)] = c__42036__auto___81411);

return statearr_81409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81411,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__81431 = arguments.length;
switch (G__81431) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42036__auto___81485 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81485,out){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81485,out){
return (function (state_81463){
var state_val_81464 = (state_81463[(1)]);
if((state_val_81464 === (7))){
var inst_81442 = (state_81463[(7)]);
var inst_81443 = (state_81463[(8)]);
var inst_81442__$1 = (state_81463[(2)]);
var inst_81443__$1 = cljs.core.nth.call(null,inst_81442__$1,(0),null);
var inst_81444 = cljs.core.nth.call(null,inst_81442__$1,(1),null);
var inst_81445 = (inst_81443__$1 == null);
var state_81463__$1 = (function (){var statearr_81465 = state_81463;
(statearr_81465[(9)] = inst_81444);

(statearr_81465[(7)] = inst_81442__$1);

(statearr_81465[(8)] = inst_81443__$1);

return statearr_81465;
})();
if(cljs.core.truth_(inst_81445)){
var statearr_81466_81486 = state_81463__$1;
(statearr_81466_81486[(1)] = (8));

} else {
var statearr_81467_81487 = state_81463__$1;
(statearr_81467_81487[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81464 === (1))){
var inst_81432 = cljs.core.vec.call(null,chs);
var inst_81433 = inst_81432;
var state_81463__$1 = (function (){var statearr_81468 = state_81463;
(statearr_81468[(10)] = inst_81433);

return statearr_81468;
})();
var statearr_81469_81488 = state_81463__$1;
(statearr_81469_81488[(2)] = null);

(statearr_81469_81488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81464 === (4))){
var inst_81433 = (state_81463[(10)]);
var state_81463__$1 = state_81463;
return cljs.core.async.ioc_alts_BANG_.call(null,state_81463__$1,(7),inst_81433);
} else {
if((state_val_81464 === (6))){
var inst_81459 = (state_81463[(2)]);
var state_81463__$1 = state_81463;
var statearr_81470_81489 = state_81463__$1;
(statearr_81470_81489[(2)] = inst_81459);

(statearr_81470_81489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81464 === (3))){
var inst_81461 = (state_81463[(2)]);
var state_81463__$1 = state_81463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81463__$1,inst_81461);
} else {
if((state_val_81464 === (2))){
var inst_81433 = (state_81463[(10)]);
var inst_81435 = cljs.core.count.call(null,inst_81433);
var inst_81436 = (inst_81435 > (0));
var state_81463__$1 = state_81463;
if(cljs.core.truth_(inst_81436)){
var statearr_81472_81490 = state_81463__$1;
(statearr_81472_81490[(1)] = (4));

} else {
var statearr_81473_81491 = state_81463__$1;
(statearr_81473_81491[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81464 === (11))){
var inst_81433 = (state_81463[(10)]);
var inst_81452 = (state_81463[(2)]);
var tmp81471 = inst_81433;
var inst_81433__$1 = tmp81471;
var state_81463__$1 = (function (){var statearr_81474 = state_81463;
(statearr_81474[(11)] = inst_81452);

(statearr_81474[(10)] = inst_81433__$1);

return statearr_81474;
})();
var statearr_81475_81492 = state_81463__$1;
(statearr_81475_81492[(2)] = null);

(statearr_81475_81492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81464 === (9))){
var inst_81443 = (state_81463[(8)]);
var state_81463__$1 = state_81463;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81463__$1,(11),out,inst_81443);
} else {
if((state_val_81464 === (5))){
var inst_81457 = cljs.core.async.close_BANG_.call(null,out);
var state_81463__$1 = state_81463;
var statearr_81476_81493 = state_81463__$1;
(statearr_81476_81493[(2)] = inst_81457);

(statearr_81476_81493[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81464 === (10))){
var inst_81455 = (state_81463[(2)]);
var state_81463__$1 = state_81463;
var statearr_81477_81494 = state_81463__$1;
(statearr_81477_81494[(2)] = inst_81455);

(statearr_81477_81494[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81464 === (8))){
var inst_81444 = (state_81463[(9)]);
var inst_81433 = (state_81463[(10)]);
var inst_81442 = (state_81463[(7)]);
var inst_81443 = (state_81463[(8)]);
var inst_81447 = (function (){var cs = inst_81433;
var vec__81438 = inst_81442;
var v = inst_81443;
var c = inst_81444;
return ((function (cs,vec__81438,v,c,inst_81444,inst_81433,inst_81442,inst_81443,state_val_81464,c__42036__auto___81485,out){
return (function (p1__81429_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__81429_SHARP_);
});
;})(cs,vec__81438,v,c,inst_81444,inst_81433,inst_81442,inst_81443,state_val_81464,c__42036__auto___81485,out))
})();
var inst_81448 = cljs.core.filterv.call(null,inst_81447,inst_81433);
var inst_81433__$1 = inst_81448;
var state_81463__$1 = (function (){var statearr_81478 = state_81463;
(statearr_81478[(10)] = inst_81433__$1);

return statearr_81478;
})();
var statearr_81479_81495 = state_81463__$1;
(statearr_81479_81495[(2)] = null);

(statearr_81479_81495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81485,out))
;
return ((function (switch__42015__auto__,c__42036__auto___81485,out){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_81480 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81480[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_81480[(1)] = (1));

return statearr_81480;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_81463){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81481){if((e81481 instanceof Object)){
var ex__42019__auto__ = e81481;
var statearr_81482_81496 = state_81463;
(statearr_81482_81496[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81481;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81497 = state_81463;
state_81463 = G__81497;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_81463){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_81463);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81485,out))
})();
var state__42038__auto__ = (function (){var statearr_81483 = f__42037__auto__.call(null);
(statearr_81483[(6)] = c__42036__auto___81485);

return statearr_81483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81485,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__81499 = arguments.length;
switch (G__81499) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42036__auto___81544 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81544,out){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81544,out){
return (function (state_81523){
var state_val_81524 = (state_81523[(1)]);
if((state_val_81524 === (7))){
var inst_81505 = (state_81523[(7)]);
var inst_81505__$1 = (state_81523[(2)]);
var inst_81506 = (inst_81505__$1 == null);
var inst_81507 = cljs.core.not.call(null,inst_81506);
var state_81523__$1 = (function (){var statearr_81525 = state_81523;
(statearr_81525[(7)] = inst_81505__$1);

return statearr_81525;
})();
if(inst_81507){
var statearr_81526_81545 = state_81523__$1;
(statearr_81526_81545[(1)] = (8));

} else {
var statearr_81527_81546 = state_81523__$1;
(statearr_81527_81546[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81524 === (1))){
var inst_81500 = (0);
var state_81523__$1 = (function (){var statearr_81528 = state_81523;
(statearr_81528[(8)] = inst_81500);

return statearr_81528;
})();
var statearr_81529_81547 = state_81523__$1;
(statearr_81529_81547[(2)] = null);

(statearr_81529_81547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81524 === (4))){
var state_81523__$1 = state_81523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81523__$1,(7),ch);
} else {
if((state_val_81524 === (6))){
var inst_81518 = (state_81523[(2)]);
var state_81523__$1 = state_81523;
var statearr_81530_81548 = state_81523__$1;
(statearr_81530_81548[(2)] = inst_81518);

(statearr_81530_81548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81524 === (3))){
var inst_81520 = (state_81523[(2)]);
var inst_81521 = cljs.core.async.close_BANG_.call(null,out);
var state_81523__$1 = (function (){var statearr_81531 = state_81523;
(statearr_81531[(9)] = inst_81520);

return statearr_81531;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81523__$1,inst_81521);
} else {
if((state_val_81524 === (2))){
var inst_81500 = (state_81523[(8)]);
var inst_81502 = (inst_81500 < n);
var state_81523__$1 = state_81523;
if(cljs.core.truth_(inst_81502)){
var statearr_81532_81549 = state_81523__$1;
(statearr_81532_81549[(1)] = (4));

} else {
var statearr_81533_81550 = state_81523__$1;
(statearr_81533_81550[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81524 === (11))){
var inst_81500 = (state_81523[(8)]);
var inst_81510 = (state_81523[(2)]);
var inst_81511 = (inst_81500 + (1));
var inst_81500__$1 = inst_81511;
var state_81523__$1 = (function (){var statearr_81534 = state_81523;
(statearr_81534[(10)] = inst_81510);

(statearr_81534[(8)] = inst_81500__$1);

return statearr_81534;
})();
var statearr_81535_81551 = state_81523__$1;
(statearr_81535_81551[(2)] = null);

(statearr_81535_81551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81524 === (9))){
var state_81523__$1 = state_81523;
var statearr_81536_81552 = state_81523__$1;
(statearr_81536_81552[(2)] = null);

(statearr_81536_81552[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81524 === (5))){
var state_81523__$1 = state_81523;
var statearr_81537_81553 = state_81523__$1;
(statearr_81537_81553[(2)] = null);

(statearr_81537_81553[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81524 === (10))){
var inst_81515 = (state_81523[(2)]);
var state_81523__$1 = state_81523;
var statearr_81538_81554 = state_81523__$1;
(statearr_81538_81554[(2)] = inst_81515);

(statearr_81538_81554[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81524 === (8))){
var inst_81505 = (state_81523[(7)]);
var state_81523__$1 = state_81523;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81523__$1,(11),out,inst_81505);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81544,out))
;
return ((function (switch__42015__auto__,c__42036__auto___81544,out){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_81539 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_81539[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_81539[(1)] = (1));

return statearr_81539;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_81523){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81540){if((e81540 instanceof Object)){
var ex__42019__auto__ = e81540;
var statearr_81541_81555 = state_81523;
(statearr_81541_81555[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81523);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81540;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81556 = state_81523;
state_81523 = G__81556;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_81523){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_81523);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81544,out))
})();
var state__42038__auto__ = (function (){var statearr_81542 = f__42037__auto__.call(null);
(statearr_81542[(6)] = c__42036__auto___81544);

return statearr_81542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81544,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async81558 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81558 = (function (f,ch,meta81559){
this.f = f;
this.ch = ch;
this.meta81559 = meta81559;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81560,meta81559__$1){
var self__ = this;
var _81560__$1 = this;
return (new cljs.core.async.t_cljs$core$async81558(self__.f,self__.ch,meta81559__$1));
});


cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81560){
var self__ = this;
var _81560__$1 = this;
return self__.meta81559;
});


cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async81561 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81561 = (function (f,ch,meta81559,_,fn1,meta81562){
this.f = f;
this.ch = ch;
this.meta81559 = meta81559;
this._ = _;
this.fn1 = fn1;
this.meta81562 = meta81562;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async81561.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_81563,meta81562__$1){
var self__ = this;
var _81563__$1 = this;
return (new cljs.core.async.t_cljs$core$async81561(self__.f,self__.ch,self__.meta81559,self__._,self__.fn1,meta81562__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async81561.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_81563){
var self__ = this;
var _81563__$1 = this;
return self__.meta81562;
});})(___$1))
;


cljs.core.async.t_cljs$core$async81561.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81561.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async81561.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async81561.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__81557_SHARP_){
return f1.call(null,(((p1__81557_SHARP_ == null))?null:self__.f.call(null,p1__81557_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async81561.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta81559","meta81559",-750997046,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async81558","cljs.core.async/t_cljs$core$async81558",-2006121450,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta81562","meta81562",1378273073,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async81561.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81561.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81561";

cljs.core.async.t_cljs$core$async81561.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async81561");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async81561 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async81561(f__$1,ch__$1,meta81559__$1,___$2,fn1__$1,meta81562){
return (new cljs.core.async.t_cljs$core$async81561(f__$1,ch__$1,meta81559__$1,___$2,fn1__$1,meta81562));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async81561(self__.f,self__.ch,self__.meta81559,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28129__auto__ = ret;
if(cljs.core.truth_(and__28129__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28129__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81558.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async81558.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta81559","meta81559",-750997046,null)], null);
});

cljs.core.async.t_cljs$core$async81558.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81558.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81558";

cljs.core.async.t_cljs$core$async81558.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async81558");
});

cljs.core.async.__GT_t_cljs$core$async81558 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async81558(f__$1,ch__$1,meta81559){
return (new cljs.core.async.t_cljs$core$async81558(f__$1,ch__$1,meta81559));
});

}

return (new cljs.core.async.t_cljs$core$async81558(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async81564 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81564 = (function (f,ch,meta81565){
this.f = f;
this.ch = ch;
this.meta81565 = meta81565;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async81564.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81566,meta81565__$1){
var self__ = this;
var _81566__$1 = this;
return (new cljs.core.async.t_cljs$core$async81564(self__.f,self__.ch,meta81565__$1));
});


cljs.core.async.t_cljs$core$async81564.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81566){
var self__ = this;
var _81566__$1 = this;
return self__.meta81565;
});


cljs.core.async.t_cljs$core$async81564.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81564.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async81564.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81564.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async81564.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81564.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async81564.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta81565","meta81565",-1875725423,null)], null);
});

cljs.core.async.t_cljs$core$async81564.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81564.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81564";

cljs.core.async.t_cljs$core$async81564.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async81564");
});

cljs.core.async.__GT_t_cljs$core$async81564 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async81564(f__$1,ch__$1,meta81565){
return (new cljs.core.async.t_cljs$core$async81564(f__$1,ch__$1,meta81565));
});

}

return (new cljs.core.async.t_cljs$core$async81564(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async81567 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81567 = (function (p,ch,meta81568){
this.p = p;
this.ch = ch;
this.meta81568 = meta81568;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81569,meta81568__$1){
var self__ = this;
var _81569__$1 = this;
return (new cljs.core.async.t_cljs$core$async81567(self__.p,self__.ch,meta81568__$1));
});


cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81569){
var self__ = this;
var _81569__$1 = this;
return self__.meta81568;
});


cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async81567.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async81567.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta81568","meta81568",-373035569,null)], null);
});

cljs.core.async.t_cljs$core$async81567.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81567.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81567";

cljs.core.async.t_cljs$core$async81567.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async81567");
});

cljs.core.async.__GT_t_cljs$core$async81567 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async81567(p__$1,ch__$1,meta81568){
return (new cljs.core.async.t_cljs$core$async81567(p__$1,ch__$1,meta81568));
});

}

return (new cljs.core.async.t_cljs$core$async81567(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__81571 = arguments.length;
switch (G__81571) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42036__auto___81611 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81611,out){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81611,out){
return (function (state_81592){
var state_val_81593 = (state_81592[(1)]);
if((state_val_81593 === (7))){
var inst_81588 = (state_81592[(2)]);
var state_81592__$1 = state_81592;
var statearr_81594_81612 = state_81592__$1;
(statearr_81594_81612[(2)] = inst_81588);

(statearr_81594_81612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81593 === (1))){
var state_81592__$1 = state_81592;
var statearr_81595_81613 = state_81592__$1;
(statearr_81595_81613[(2)] = null);

(statearr_81595_81613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81593 === (4))){
var inst_81574 = (state_81592[(7)]);
var inst_81574__$1 = (state_81592[(2)]);
var inst_81575 = (inst_81574__$1 == null);
var state_81592__$1 = (function (){var statearr_81596 = state_81592;
(statearr_81596[(7)] = inst_81574__$1);

return statearr_81596;
})();
if(cljs.core.truth_(inst_81575)){
var statearr_81597_81614 = state_81592__$1;
(statearr_81597_81614[(1)] = (5));

} else {
var statearr_81598_81615 = state_81592__$1;
(statearr_81598_81615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81593 === (6))){
var inst_81574 = (state_81592[(7)]);
var inst_81579 = p.call(null,inst_81574);
var state_81592__$1 = state_81592;
if(cljs.core.truth_(inst_81579)){
var statearr_81599_81616 = state_81592__$1;
(statearr_81599_81616[(1)] = (8));

} else {
var statearr_81600_81617 = state_81592__$1;
(statearr_81600_81617[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81593 === (3))){
var inst_81590 = (state_81592[(2)]);
var state_81592__$1 = state_81592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81592__$1,inst_81590);
} else {
if((state_val_81593 === (2))){
var state_81592__$1 = state_81592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81592__$1,(4),ch);
} else {
if((state_val_81593 === (11))){
var inst_81582 = (state_81592[(2)]);
var state_81592__$1 = state_81592;
var statearr_81601_81618 = state_81592__$1;
(statearr_81601_81618[(2)] = inst_81582);

(statearr_81601_81618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81593 === (9))){
var state_81592__$1 = state_81592;
var statearr_81602_81619 = state_81592__$1;
(statearr_81602_81619[(2)] = null);

(statearr_81602_81619[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81593 === (5))){
var inst_81577 = cljs.core.async.close_BANG_.call(null,out);
var state_81592__$1 = state_81592;
var statearr_81603_81620 = state_81592__$1;
(statearr_81603_81620[(2)] = inst_81577);

(statearr_81603_81620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81593 === (10))){
var inst_81585 = (state_81592[(2)]);
var state_81592__$1 = (function (){var statearr_81604 = state_81592;
(statearr_81604[(8)] = inst_81585);

return statearr_81604;
})();
var statearr_81605_81621 = state_81592__$1;
(statearr_81605_81621[(2)] = null);

(statearr_81605_81621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81593 === (8))){
var inst_81574 = (state_81592[(7)]);
var state_81592__$1 = state_81592;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81592__$1,(11),out,inst_81574);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81611,out))
;
return ((function (switch__42015__auto__,c__42036__auto___81611,out){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_81606 = [null,null,null,null,null,null,null,null,null];
(statearr_81606[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_81606[(1)] = (1));

return statearr_81606;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_81592){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81607){if((e81607 instanceof Object)){
var ex__42019__auto__ = e81607;
var statearr_81608_81622 = state_81592;
(statearr_81608_81622[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81592);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81607;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81623 = state_81592;
state_81592 = G__81623;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_81592){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_81592);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81611,out))
})();
var state__42038__auto__ = (function (){var statearr_81609 = f__42037__auto__.call(null);
(statearr_81609[(6)] = c__42036__auto___81611);

return statearr_81609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81611,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__81625 = arguments.length;
switch (G__81625) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_81688){
var state_val_81689 = (state_81688[(1)]);
if((state_val_81689 === (7))){
var inst_81684 = (state_81688[(2)]);
var state_81688__$1 = state_81688;
var statearr_81690_81728 = state_81688__$1;
(statearr_81690_81728[(2)] = inst_81684);

(statearr_81690_81728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (20))){
var inst_81654 = (state_81688[(7)]);
var inst_81665 = (state_81688[(2)]);
var inst_81666 = cljs.core.next.call(null,inst_81654);
var inst_81640 = inst_81666;
var inst_81641 = null;
var inst_81642 = (0);
var inst_81643 = (0);
var state_81688__$1 = (function (){var statearr_81691 = state_81688;
(statearr_81691[(8)] = inst_81643);

(statearr_81691[(9)] = inst_81640);

(statearr_81691[(10)] = inst_81665);

(statearr_81691[(11)] = inst_81642);

(statearr_81691[(12)] = inst_81641);

return statearr_81691;
})();
var statearr_81692_81729 = state_81688__$1;
(statearr_81692_81729[(2)] = null);

(statearr_81692_81729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (1))){
var state_81688__$1 = state_81688;
var statearr_81693_81730 = state_81688__$1;
(statearr_81693_81730[(2)] = null);

(statearr_81693_81730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (4))){
var inst_81629 = (state_81688[(13)]);
var inst_81629__$1 = (state_81688[(2)]);
var inst_81630 = (inst_81629__$1 == null);
var state_81688__$1 = (function (){var statearr_81694 = state_81688;
(statearr_81694[(13)] = inst_81629__$1);

return statearr_81694;
})();
if(cljs.core.truth_(inst_81630)){
var statearr_81695_81731 = state_81688__$1;
(statearr_81695_81731[(1)] = (5));

} else {
var statearr_81696_81732 = state_81688__$1;
(statearr_81696_81732[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (15))){
var state_81688__$1 = state_81688;
var statearr_81700_81733 = state_81688__$1;
(statearr_81700_81733[(2)] = null);

(statearr_81700_81733[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (21))){
var state_81688__$1 = state_81688;
var statearr_81701_81734 = state_81688__$1;
(statearr_81701_81734[(2)] = null);

(statearr_81701_81734[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (13))){
var inst_81643 = (state_81688[(8)]);
var inst_81640 = (state_81688[(9)]);
var inst_81642 = (state_81688[(11)]);
var inst_81641 = (state_81688[(12)]);
var inst_81650 = (state_81688[(2)]);
var inst_81651 = (inst_81643 + (1));
var tmp81697 = inst_81640;
var tmp81698 = inst_81642;
var tmp81699 = inst_81641;
var inst_81640__$1 = tmp81697;
var inst_81641__$1 = tmp81699;
var inst_81642__$1 = tmp81698;
var inst_81643__$1 = inst_81651;
var state_81688__$1 = (function (){var statearr_81702 = state_81688;
(statearr_81702[(14)] = inst_81650);

(statearr_81702[(8)] = inst_81643__$1);

(statearr_81702[(9)] = inst_81640__$1);

(statearr_81702[(11)] = inst_81642__$1);

(statearr_81702[(12)] = inst_81641__$1);

return statearr_81702;
})();
var statearr_81703_81735 = state_81688__$1;
(statearr_81703_81735[(2)] = null);

(statearr_81703_81735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (22))){
var state_81688__$1 = state_81688;
var statearr_81704_81736 = state_81688__$1;
(statearr_81704_81736[(2)] = null);

(statearr_81704_81736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (6))){
var inst_81629 = (state_81688[(13)]);
var inst_81638 = f.call(null,inst_81629);
var inst_81639 = cljs.core.seq.call(null,inst_81638);
var inst_81640 = inst_81639;
var inst_81641 = null;
var inst_81642 = (0);
var inst_81643 = (0);
var state_81688__$1 = (function (){var statearr_81705 = state_81688;
(statearr_81705[(8)] = inst_81643);

(statearr_81705[(9)] = inst_81640);

(statearr_81705[(11)] = inst_81642);

(statearr_81705[(12)] = inst_81641);

return statearr_81705;
})();
var statearr_81706_81737 = state_81688__$1;
(statearr_81706_81737[(2)] = null);

(statearr_81706_81737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (17))){
var inst_81654 = (state_81688[(7)]);
var inst_81658 = cljs.core.chunk_first.call(null,inst_81654);
var inst_81659 = cljs.core.chunk_rest.call(null,inst_81654);
var inst_81660 = cljs.core.count.call(null,inst_81658);
var inst_81640 = inst_81659;
var inst_81641 = inst_81658;
var inst_81642 = inst_81660;
var inst_81643 = (0);
var state_81688__$1 = (function (){var statearr_81707 = state_81688;
(statearr_81707[(8)] = inst_81643);

(statearr_81707[(9)] = inst_81640);

(statearr_81707[(11)] = inst_81642);

(statearr_81707[(12)] = inst_81641);

return statearr_81707;
})();
var statearr_81708_81738 = state_81688__$1;
(statearr_81708_81738[(2)] = null);

(statearr_81708_81738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (3))){
var inst_81686 = (state_81688[(2)]);
var state_81688__$1 = state_81688;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81688__$1,inst_81686);
} else {
if((state_val_81689 === (12))){
var inst_81674 = (state_81688[(2)]);
var state_81688__$1 = state_81688;
var statearr_81709_81739 = state_81688__$1;
(statearr_81709_81739[(2)] = inst_81674);

(statearr_81709_81739[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (2))){
var state_81688__$1 = state_81688;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81688__$1,(4),in$);
} else {
if((state_val_81689 === (23))){
var inst_81682 = (state_81688[(2)]);
var state_81688__$1 = state_81688;
var statearr_81710_81740 = state_81688__$1;
(statearr_81710_81740[(2)] = inst_81682);

(statearr_81710_81740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (19))){
var inst_81669 = (state_81688[(2)]);
var state_81688__$1 = state_81688;
var statearr_81711_81741 = state_81688__$1;
(statearr_81711_81741[(2)] = inst_81669);

(statearr_81711_81741[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (11))){
var inst_81654 = (state_81688[(7)]);
var inst_81640 = (state_81688[(9)]);
var inst_81654__$1 = cljs.core.seq.call(null,inst_81640);
var state_81688__$1 = (function (){var statearr_81712 = state_81688;
(statearr_81712[(7)] = inst_81654__$1);

return statearr_81712;
})();
if(inst_81654__$1){
var statearr_81713_81742 = state_81688__$1;
(statearr_81713_81742[(1)] = (14));

} else {
var statearr_81714_81743 = state_81688__$1;
(statearr_81714_81743[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (9))){
var inst_81676 = (state_81688[(2)]);
var inst_81677 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_81688__$1 = (function (){var statearr_81715 = state_81688;
(statearr_81715[(15)] = inst_81676);

return statearr_81715;
})();
if(cljs.core.truth_(inst_81677)){
var statearr_81716_81744 = state_81688__$1;
(statearr_81716_81744[(1)] = (21));

} else {
var statearr_81717_81745 = state_81688__$1;
(statearr_81717_81745[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (5))){
var inst_81632 = cljs.core.async.close_BANG_.call(null,out);
var state_81688__$1 = state_81688;
var statearr_81718_81746 = state_81688__$1;
(statearr_81718_81746[(2)] = inst_81632);

(statearr_81718_81746[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (14))){
var inst_81654 = (state_81688[(7)]);
var inst_81656 = cljs.core.chunked_seq_QMARK_.call(null,inst_81654);
var state_81688__$1 = state_81688;
if(inst_81656){
var statearr_81719_81747 = state_81688__$1;
(statearr_81719_81747[(1)] = (17));

} else {
var statearr_81720_81748 = state_81688__$1;
(statearr_81720_81748[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (16))){
var inst_81672 = (state_81688[(2)]);
var state_81688__$1 = state_81688;
var statearr_81721_81749 = state_81688__$1;
(statearr_81721_81749[(2)] = inst_81672);

(statearr_81721_81749[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81689 === (10))){
var inst_81643 = (state_81688[(8)]);
var inst_81641 = (state_81688[(12)]);
var inst_81648 = cljs.core._nth.call(null,inst_81641,inst_81643);
var state_81688__$1 = state_81688;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81688__$1,(13),out,inst_81648);
} else {
if((state_val_81689 === (18))){
var inst_81654 = (state_81688[(7)]);
var inst_81663 = cljs.core.first.call(null,inst_81654);
var state_81688__$1 = state_81688;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81688__$1,(20),out,inst_81663);
} else {
if((state_val_81689 === (8))){
var inst_81643 = (state_81688[(8)]);
var inst_81642 = (state_81688[(11)]);
var inst_81645 = (inst_81643 < inst_81642);
var inst_81646 = inst_81645;
var state_81688__$1 = state_81688;
if(cljs.core.truth_(inst_81646)){
var statearr_81722_81750 = state_81688__$1;
(statearr_81722_81750[(1)] = (10));

} else {
var statearr_81723_81751 = state_81688__$1;
(statearr_81723_81751[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42016__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42016__auto____0 = (function (){
var statearr_81724 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81724[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42016__auto__);

(statearr_81724[(1)] = (1));

return statearr_81724;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42016__auto____1 = (function (state_81688){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81725){if((e81725 instanceof Object)){
var ex__42019__auto__ = e81725;
var statearr_81726_81752 = state_81688;
(statearr_81726_81752[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81688);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81725;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81753 = state_81688;
state_81688 = G__81753;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42016__auto__ = function(state_81688){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42016__auto____1.call(this,state_81688);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42016__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42016__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_81727 = f__42037__auto__.call(null);
(statearr_81727[(6)] = c__42036__auto__);

return statearr_81727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__81755 = arguments.length;
switch (G__81755) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__81758 = arguments.length;
switch (G__81758) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__81761 = arguments.length;
switch (G__81761) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42036__auto___81808 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81808,out){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81808,out){
return (function (state_81785){
var state_val_81786 = (state_81785[(1)]);
if((state_val_81786 === (7))){
var inst_81780 = (state_81785[(2)]);
var state_81785__$1 = state_81785;
var statearr_81787_81809 = state_81785__$1;
(statearr_81787_81809[(2)] = inst_81780);

(statearr_81787_81809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (1))){
var inst_81762 = null;
var state_81785__$1 = (function (){var statearr_81788 = state_81785;
(statearr_81788[(7)] = inst_81762);

return statearr_81788;
})();
var statearr_81789_81810 = state_81785__$1;
(statearr_81789_81810[(2)] = null);

(statearr_81789_81810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (4))){
var inst_81765 = (state_81785[(8)]);
var inst_81765__$1 = (state_81785[(2)]);
var inst_81766 = (inst_81765__$1 == null);
var inst_81767 = cljs.core.not.call(null,inst_81766);
var state_81785__$1 = (function (){var statearr_81790 = state_81785;
(statearr_81790[(8)] = inst_81765__$1);

return statearr_81790;
})();
if(inst_81767){
var statearr_81791_81811 = state_81785__$1;
(statearr_81791_81811[(1)] = (5));

} else {
var statearr_81792_81812 = state_81785__$1;
(statearr_81792_81812[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (6))){
var state_81785__$1 = state_81785;
var statearr_81793_81813 = state_81785__$1;
(statearr_81793_81813[(2)] = null);

(statearr_81793_81813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (3))){
var inst_81782 = (state_81785[(2)]);
var inst_81783 = cljs.core.async.close_BANG_.call(null,out);
var state_81785__$1 = (function (){var statearr_81794 = state_81785;
(statearr_81794[(9)] = inst_81782);

return statearr_81794;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81785__$1,inst_81783);
} else {
if((state_val_81786 === (2))){
var state_81785__$1 = state_81785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81785__$1,(4),ch);
} else {
if((state_val_81786 === (11))){
var inst_81765 = (state_81785[(8)]);
var inst_81774 = (state_81785[(2)]);
var inst_81762 = inst_81765;
var state_81785__$1 = (function (){var statearr_81795 = state_81785;
(statearr_81795[(7)] = inst_81762);

(statearr_81795[(10)] = inst_81774);

return statearr_81795;
})();
var statearr_81796_81814 = state_81785__$1;
(statearr_81796_81814[(2)] = null);

(statearr_81796_81814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (9))){
var inst_81765 = (state_81785[(8)]);
var state_81785__$1 = state_81785;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81785__$1,(11),out,inst_81765);
} else {
if((state_val_81786 === (5))){
var inst_81762 = (state_81785[(7)]);
var inst_81765 = (state_81785[(8)]);
var inst_81769 = cljs.core._EQ_.call(null,inst_81765,inst_81762);
var state_81785__$1 = state_81785;
if(inst_81769){
var statearr_81798_81815 = state_81785__$1;
(statearr_81798_81815[(1)] = (8));

} else {
var statearr_81799_81816 = state_81785__$1;
(statearr_81799_81816[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (10))){
var inst_81777 = (state_81785[(2)]);
var state_81785__$1 = state_81785;
var statearr_81800_81817 = state_81785__$1;
(statearr_81800_81817[(2)] = inst_81777);

(statearr_81800_81817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (8))){
var inst_81762 = (state_81785[(7)]);
var tmp81797 = inst_81762;
var inst_81762__$1 = tmp81797;
var state_81785__$1 = (function (){var statearr_81801 = state_81785;
(statearr_81801[(7)] = inst_81762__$1);

return statearr_81801;
})();
var statearr_81802_81818 = state_81785__$1;
(statearr_81802_81818[(2)] = null);

(statearr_81802_81818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81808,out))
;
return ((function (switch__42015__auto__,c__42036__auto___81808,out){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_81803 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_81803[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_81803[(1)] = (1));

return statearr_81803;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_81785){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81804){if((e81804 instanceof Object)){
var ex__42019__auto__ = e81804;
var statearr_81805_81819 = state_81785;
(statearr_81805_81819[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81785);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81804;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81820 = state_81785;
state_81785 = G__81820;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_81785){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_81785);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81808,out))
})();
var state__42038__auto__ = (function (){var statearr_81806 = f__42037__auto__.call(null);
(statearr_81806[(6)] = c__42036__auto___81808);

return statearr_81806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81808,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__81822 = arguments.length;
switch (G__81822) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42036__auto___81888 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81888,out){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81888,out){
return (function (state_81860){
var state_val_81861 = (state_81860[(1)]);
if((state_val_81861 === (7))){
var inst_81856 = (state_81860[(2)]);
var state_81860__$1 = state_81860;
var statearr_81862_81889 = state_81860__$1;
(statearr_81862_81889[(2)] = inst_81856);

(statearr_81862_81889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (1))){
var inst_81823 = (new Array(n));
var inst_81824 = inst_81823;
var inst_81825 = (0);
var state_81860__$1 = (function (){var statearr_81863 = state_81860;
(statearr_81863[(7)] = inst_81824);

(statearr_81863[(8)] = inst_81825);

return statearr_81863;
})();
var statearr_81864_81890 = state_81860__$1;
(statearr_81864_81890[(2)] = null);

(statearr_81864_81890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (4))){
var inst_81828 = (state_81860[(9)]);
var inst_81828__$1 = (state_81860[(2)]);
var inst_81829 = (inst_81828__$1 == null);
var inst_81830 = cljs.core.not.call(null,inst_81829);
var state_81860__$1 = (function (){var statearr_81865 = state_81860;
(statearr_81865[(9)] = inst_81828__$1);

return statearr_81865;
})();
if(inst_81830){
var statearr_81866_81891 = state_81860__$1;
(statearr_81866_81891[(1)] = (5));

} else {
var statearr_81867_81892 = state_81860__$1;
(statearr_81867_81892[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (15))){
var inst_81850 = (state_81860[(2)]);
var state_81860__$1 = state_81860;
var statearr_81868_81893 = state_81860__$1;
(statearr_81868_81893[(2)] = inst_81850);

(statearr_81868_81893[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (13))){
var state_81860__$1 = state_81860;
var statearr_81869_81894 = state_81860__$1;
(statearr_81869_81894[(2)] = null);

(statearr_81869_81894[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (6))){
var inst_81825 = (state_81860[(8)]);
var inst_81846 = (inst_81825 > (0));
var state_81860__$1 = state_81860;
if(cljs.core.truth_(inst_81846)){
var statearr_81870_81895 = state_81860__$1;
(statearr_81870_81895[(1)] = (12));

} else {
var statearr_81871_81896 = state_81860__$1;
(statearr_81871_81896[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (3))){
var inst_81858 = (state_81860[(2)]);
var state_81860__$1 = state_81860;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81860__$1,inst_81858);
} else {
if((state_val_81861 === (12))){
var inst_81824 = (state_81860[(7)]);
var inst_81848 = cljs.core.vec.call(null,inst_81824);
var state_81860__$1 = state_81860;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81860__$1,(15),out,inst_81848);
} else {
if((state_val_81861 === (2))){
var state_81860__$1 = state_81860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81860__$1,(4),ch);
} else {
if((state_val_81861 === (11))){
var inst_81840 = (state_81860[(2)]);
var inst_81841 = (new Array(n));
var inst_81824 = inst_81841;
var inst_81825 = (0);
var state_81860__$1 = (function (){var statearr_81872 = state_81860;
(statearr_81872[(10)] = inst_81840);

(statearr_81872[(7)] = inst_81824);

(statearr_81872[(8)] = inst_81825);

return statearr_81872;
})();
var statearr_81873_81897 = state_81860__$1;
(statearr_81873_81897[(2)] = null);

(statearr_81873_81897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (9))){
var inst_81824 = (state_81860[(7)]);
var inst_81838 = cljs.core.vec.call(null,inst_81824);
var state_81860__$1 = state_81860;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81860__$1,(11),out,inst_81838);
} else {
if((state_val_81861 === (5))){
var inst_81824 = (state_81860[(7)]);
var inst_81833 = (state_81860[(11)]);
var inst_81828 = (state_81860[(9)]);
var inst_81825 = (state_81860[(8)]);
var inst_81832 = (inst_81824[inst_81825] = inst_81828);
var inst_81833__$1 = (inst_81825 + (1));
var inst_81834 = (inst_81833__$1 < n);
var state_81860__$1 = (function (){var statearr_81874 = state_81860;
(statearr_81874[(11)] = inst_81833__$1);

(statearr_81874[(12)] = inst_81832);

return statearr_81874;
})();
if(cljs.core.truth_(inst_81834)){
var statearr_81875_81898 = state_81860__$1;
(statearr_81875_81898[(1)] = (8));

} else {
var statearr_81876_81899 = state_81860__$1;
(statearr_81876_81899[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (14))){
var inst_81853 = (state_81860[(2)]);
var inst_81854 = cljs.core.async.close_BANG_.call(null,out);
var state_81860__$1 = (function (){var statearr_81878 = state_81860;
(statearr_81878[(13)] = inst_81853);

return statearr_81878;
})();
var statearr_81879_81900 = state_81860__$1;
(statearr_81879_81900[(2)] = inst_81854);

(statearr_81879_81900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (10))){
var inst_81844 = (state_81860[(2)]);
var state_81860__$1 = state_81860;
var statearr_81880_81901 = state_81860__$1;
(statearr_81880_81901[(2)] = inst_81844);

(statearr_81880_81901[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81861 === (8))){
var inst_81824 = (state_81860[(7)]);
var inst_81833 = (state_81860[(11)]);
var tmp81877 = inst_81824;
var inst_81824__$1 = tmp81877;
var inst_81825 = inst_81833;
var state_81860__$1 = (function (){var statearr_81881 = state_81860;
(statearr_81881[(7)] = inst_81824__$1);

(statearr_81881[(8)] = inst_81825);

return statearr_81881;
})();
var statearr_81882_81902 = state_81860__$1;
(statearr_81882_81902[(2)] = null);

(statearr_81882_81902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81888,out))
;
return ((function (switch__42015__auto__,c__42036__auto___81888,out){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_81883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81883[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_81883[(1)] = (1));

return statearr_81883;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_81860){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81860);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81884){if((e81884 instanceof Object)){
var ex__42019__auto__ = e81884;
var statearr_81885_81903 = state_81860;
(statearr_81885_81903[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81860);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81904 = state_81860;
state_81860 = G__81904;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_81860){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_81860);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81888,out))
})();
var state__42038__auto__ = (function (){var statearr_81886 = f__42037__auto__.call(null);
(statearr_81886[(6)] = c__42036__auto___81888);

return statearr_81886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81888,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__81906 = arguments.length;
switch (G__81906) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42036__auto___81976 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___81976,out){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___81976,out){
return (function (state_81948){
var state_val_81949 = (state_81948[(1)]);
if((state_val_81949 === (7))){
var inst_81944 = (state_81948[(2)]);
var state_81948__$1 = state_81948;
var statearr_81950_81977 = state_81948__$1;
(statearr_81950_81977[(2)] = inst_81944);

(statearr_81950_81977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (1))){
var inst_81907 = [];
var inst_81908 = inst_81907;
var inst_81909 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_81948__$1 = (function (){var statearr_81951 = state_81948;
(statearr_81951[(7)] = inst_81909);

(statearr_81951[(8)] = inst_81908);

return statearr_81951;
})();
var statearr_81952_81978 = state_81948__$1;
(statearr_81952_81978[(2)] = null);

(statearr_81952_81978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (4))){
var inst_81912 = (state_81948[(9)]);
var inst_81912__$1 = (state_81948[(2)]);
var inst_81913 = (inst_81912__$1 == null);
var inst_81914 = cljs.core.not.call(null,inst_81913);
var state_81948__$1 = (function (){var statearr_81953 = state_81948;
(statearr_81953[(9)] = inst_81912__$1);

return statearr_81953;
})();
if(inst_81914){
var statearr_81954_81979 = state_81948__$1;
(statearr_81954_81979[(1)] = (5));

} else {
var statearr_81955_81980 = state_81948__$1;
(statearr_81955_81980[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (15))){
var inst_81938 = (state_81948[(2)]);
var state_81948__$1 = state_81948;
var statearr_81956_81981 = state_81948__$1;
(statearr_81956_81981[(2)] = inst_81938);

(statearr_81956_81981[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (13))){
var state_81948__$1 = state_81948;
var statearr_81957_81982 = state_81948__$1;
(statearr_81957_81982[(2)] = null);

(statearr_81957_81982[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (6))){
var inst_81908 = (state_81948[(8)]);
var inst_81933 = inst_81908.length;
var inst_81934 = (inst_81933 > (0));
var state_81948__$1 = state_81948;
if(cljs.core.truth_(inst_81934)){
var statearr_81958_81983 = state_81948__$1;
(statearr_81958_81983[(1)] = (12));

} else {
var statearr_81959_81984 = state_81948__$1;
(statearr_81959_81984[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (3))){
var inst_81946 = (state_81948[(2)]);
var state_81948__$1 = state_81948;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81948__$1,inst_81946);
} else {
if((state_val_81949 === (12))){
var inst_81908 = (state_81948[(8)]);
var inst_81936 = cljs.core.vec.call(null,inst_81908);
var state_81948__$1 = state_81948;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81948__$1,(15),out,inst_81936);
} else {
if((state_val_81949 === (2))){
var state_81948__$1 = state_81948;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81948__$1,(4),ch);
} else {
if((state_val_81949 === (11))){
var inst_81912 = (state_81948[(9)]);
var inst_81916 = (state_81948[(10)]);
var inst_81926 = (state_81948[(2)]);
var inst_81927 = [];
var inst_81928 = inst_81927.push(inst_81912);
var inst_81908 = inst_81927;
var inst_81909 = inst_81916;
var state_81948__$1 = (function (){var statearr_81960 = state_81948;
(statearr_81960[(11)] = inst_81928);

(statearr_81960[(7)] = inst_81909);

(statearr_81960[(8)] = inst_81908);

(statearr_81960[(12)] = inst_81926);

return statearr_81960;
})();
var statearr_81961_81985 = state_81948__$1;
(statearr_81961_81985[(2)] = null);

(statearr_81961_81985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (9))){
var inst_81908 = (state_81948[(8)]);
var inst_81924 = cljs.core.vec.call(null,inst_81908);
var state_81948__$1 = state_81948;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81948__$1,(11),out,inst_81924);
} else {
if((state_val_81949 === (5))){
var inst_81909 = (state_81948[(7)]);
var inst_81912 = (state_81948[(9)]);
var inst_81916 = (state_81948[(10)]);
var inst_81916__$1 = f.call(null,inst_81912);
var inst_81917 = cljs.core._EQ_.call(null,inst_81916__$1,inst_81909);
var inst_81918 = cljs.core.keyword_identical_QMARK_.call(null,inst_81909,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_81919 = (inst_81917) || (inst_81918);
var state_81948__$1 = (function (){var statearr_81962 = state_81948;
(statearr_81962[(10)] = inst_81916__$1);

return statearr_81962;
})();
if(cljs.core.truth_(inst_81919)){
var statearr_81963_81986 = state_81948__$1;
(statearr_81963_81986[(1)] = (8));

} else {
var statearr_81964_81987 = state_81948__$1;
(statearr_81964_81987[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (14))){
var inst_81941 = (state_81948[(2)]);
var inst_81942 = cljs.core.async.close_BANG_.call(null,out);
var state_81948__$1 = (function (){var statearr_81966 = state_81948;
(statearr_81966[(13)] = inst_81941);

return statearr_81966;
})();
var statearr_81967_81988 = state_81948__$1;
(statearr_81967_81988[(2)] = inst_81942);

(statearr_81967_81988[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (10))){
var inst_81931 = (state_81948[(2)]);
var state_81948__$1 = state_81948;
var statearr_81968_81989 = state_81948__$1;
(statearr_81968_81989[(2)] = inst_81931);

(statearr_81968_81989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81949 === (8))){
var inst_81912 = (state_81948[(9)]);
var inst_81908 = (state_81948[(8)]);
var inst_81916 = (state_81948[(10)]);
var inst_81921 = inst_81908.push(inst_81912);
var tmp81965 = inst_81908;
var inst_81908__$1 = tmp81965;
var inst_81909 = inst_81916;
var state_81948__$1 = (function (){var statearr_81969 = state_81948;
(statearr_81969[(14)] = inst_81921);

(statearr_81969[(7)] = inst_81909);

(statearr_81969[(8)] = inst_81908__$1);

return statearr_81969;
})();
var statearr_81970_81990 = state_81948__$1;
(statearr_81970_81990[(2)] = null);

(statearr_81970_81990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___81976,out))
;
return ((function (switch__42015__auto__,c__42036__auto___81976,out){
return (function() {
var cljs$core$async$state_machine__42016__auto__ = null;
var cljs$core$async$state_machine__42016__auto____0 = (function (){
var statearr_81971 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81971[(0)] = cljs$core$async$state_machine__42016__auto__);

(statearr_81971[(1)] = (1));

return statearr_81971;
});
var cljs$core$async$state_machine__42016__auto____1 = (function (state_81948){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_81948);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e81972){if((e81972 instanceof Object)){
var ex__42019__auto__ = e81972;
var statearr_81973_81991 = state_81948;
(statearr_81973_81991[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81948);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81972;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81992 = state_81948;
state_81948 = G__81992;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
cljs$core$async$state_machine__42016__auto__ = function(state_81948){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42016__auto____1.call(this,state_81948);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42016__auto____0;
cljs$core$async$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42016__auto____1;
return cljs$core$async$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___81976,out))
})();
var state__42038__auto__ = (function (){var statearr_81974 = f__42037__auto__.call(null);
(statearr_81974[(6)] = c__42036__auto___81976);

return statearr_81974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___81976,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1511229588596
