// Compiled by ClojureScript 1.9.946 {:cache-key "67523D0BD16D0FF208174C21D2AC9291721B9CC9"}
goog.provide('cljs.loader');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('goog.module.ModuleLoader');
goog.require('goog.module.ModuleManager');
cljs.loader.module_infos = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cljs-base","cljs-base",-1271626984),cljs.core.PersistentVector.EMPTY], null);
cljs.loader.module_uris = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cljs-base","cljs-base",-1271626984),cljs.core.PersistentVector.fromArray(["js/compiled/devcards_out/goog/base.js","js/compiled/devcards_out/goog/string/string.js","js/compiled/devcards_out/goog/debug/error.js","js/compiled/devcards_out/goog/dom/nodetype.js","js/compiled/devcards_out/goog/asserts/asserts.js","js/compiled/devcards_out/goog/array/array.js","js/compiled/devcards_out/goog/object/object.js","js/compiled/devcards_out/goog/structs/structs.js","js/compiled/devcards_out/goog/functions/functions.js","js/compiled/devcards_out/goog/math/math.js","js/compiled/devcards_out/goog/iter/iter.js","js/compiled/devcards_out/goog/structs/map.js","js/compiled/devcards_out/goog/uri/utils.js","js/compiled/devcards_out/goog/uri/uri.js","js/compiled/devcards_out/goog/math/integer.js","js/compiled/devcards_out/goog/string/stringbuffer.js","js/compiled/devcards_out/goog/reflect/reflect.js","js/compiled/devcards_out/goog/math/long.js","js/compiled/devcards_out/cljs/core.js","js/compiled/devcards_out/goog/labs/useragent/util.js","js/compiled/devcards_out/goog/labs/useragent/browser.js","js/compiled/devcards_out/goog/labs/useragent/engine.js","js/compiled/devcards_out/goog/labs/useragent/platform.js","js/compiled/devcards_out/goog/useragent/useragent.js","js/compiled/devcards_out/goog/dom/browserfeature.js","js/compiled/devcards_out/goog/dom/htmlelement.js","js/compiled/devcards_out/goog/dom/tagname.js","js/compiled/devcards_out/goog/dom/asserts.js","js/compiled/devcards_out/goog/dom/tags.js","js/compiled/devcards_out/goog/string/typedstring.js","js/compiled/devcards_out/goog/string/const.js","js/compiled/devcards_out/goog/html/safescript.js","js/compiled/devcards_out/goog/fs/url.js","js/compiled/devcards_out/goog/i18n/bidi.js","js/compiled/devcards_out/goog/html/trustedresourceurl.js","js/compiled/devcards_out/goog/html/safeurl.js","js/compiled/devcards_out/goog/html/safestyle.js","js/compiled/devcards_out/goog/html/safestylesheet.js","js/compiled/devcards_out/goog/html/safehtml.js","js/compiled/devcards_out/goog/dom/safe.js","js/compiled/devcards_out/goog/html/uncheckedconversions.js","js/compiled/devcards_out/goog/math/coordinate.js","js/compiled/devcards_out/goog/math/size.js","js/compiled/devcards_out/goog/dom/dom.js","js/compiled/devcards_out/om/next/cache.js","js/compiled/devcards_out/clojure/set.js","js/compiled/devcards_out/om/util.js","js/compiled/devcards_out/om/next/impl/parser.js","js/compiled/devcards_out/cljsjs/react/development/react.inc.js","js/compiled/devcards_out/cljsjs/react-dom/development/react-dom.inc.js","js/compiled/devcards_out/om/dom.js","js/compiled/devcards_out/com/cognitect/transit/util.js","js/compiled/devcards_out/com/cognitect/transit/eq.js","js/compiled/devcards_out/com/cognitect/transit/types.js","js/compiled/devcards_out/com/cognitect/transit/delimiters.js","js/compiled/devcards_out/com/cognitect/transit/caching.js","js/compiled/devcards_out/com/cognitect/transit/impl/decoder.js","js/compiled/devcards_out/com/cognitect/transit/impl/reader.js","js/compiled/devcards_out/com/cognitect/transit/handlers.js","js/compiled/devcards_out/com/cognitect/transit/impl/writer.js","js/compiled/devcards_out/com/cognitect/transit.js","js/compiled/devcards_out/cognitect/transit.js","js/compiled/devcards_out/om/next/protocols.js","js/compiled/devcards_out/clojure/string.js","js/compiled/devcards_out/cljs/pprint.js","js/compiled/devcards_out/clojure/zip.js","js/compiled/devcards_out/goog/debug/errorcontext.js","js/compiled/devcards_out/goog/debug/debug.js","js/compiled/devcards_out/goog/debug/logrecord.js","js/compiled/devcards_out/goog/debug/logbuffer.js","js/compiled/devcards_out/goog/debug/logger.js","js/compiled/devcards_out/goog/debug/relativetimeprovider.js","js/compiled/devcards_out/goog/debug/formatter.js","js/compiled/devcards_out/goog/debug/console.js","js/compiled/devcards_out/cljs/env.js","js/compiled/devcards_out/cljs/tools/reader/impl/utils.js","js/compiled/devcards_out/cljs/tools/reader/reader_types.js","js/compiled/devcards_out/cljs/tools/reader/impl/inspect.js","js/compiled/devcards_out/cljs/tools/reader/impl/errors.js","js/compiled/devcards_out/cljs/tools/reader/impl/commons.js","js/compiled/devcards_out/cljs/tools/reader.js","js/compiled/devcards_out/cljs/tools/reader/edn.js","js/compiled/devcards_out/cljs/reader.js","js/compiled/devcards_out/cljs/tagged_literals.js","js/compiled/devcards_out/cljs/analyzer.js","js/compiled/devcards_out/cljs/analyzer/api.js","js/compiled/devcards_out/goog/log/log.js","js/compiled/devcards_out/om/tempid.js","js/compiled/devcards_out/om/transit.js","js/compiled/devcards_out/om/next.js","js/compiled/devcards_out/clojure/walk.js","js/compiled/devcards_out/cljs/spec/gen/alpha.js","js/compiled/devcards_out/cljs/spec/alpha.js","js/compiled/devcards_out/fulcro/client/util.js","js/compiled/devcards_out/goog/disposable/idisposable.js","js/compiled/devcards_out/goog/disposable/disposable.js","js/compiled/devcards_out/goog/promise/thenable.js","js/compiled/devcards_out/goog/async/freelist.js","js/compiled/devcards_out/goog/async/workqueue.js","js/compiled/devcards_out/goog/debug/entrypointregistry.js","js/compiled/devcards_out/goog/async/nexttick.js","js/compiled/devcards_out/goog/async/run.js","js/compiled/devcards_out/goog/promise/resolver.js","js/compiled/devcards_out/goog/promise/promise.js","js/compiled/devcards_out/goog/mochikit/async/deferred.js","js/compiled/devcards_out/goog/structs/simplepool.js","js/compiled/devcards_out/goog/debug/tracer.js","js/compiled/devcards_out/goog/module/module.js","js/compiled/devcards_out/goog/module/basemodule.js","js/compiled/devcards_out/goog/module/moduleloadcallback.js","js/compiled/devcards_out/goog/module/moduleinfo.js","js/compiled/devcards_out/goog/module/abstractmoduleloader.js","js/compiled/devcards_out/goog/module/modulemanager.js","js/compiled/devcards_out/goog/events/browserfeature.js","js/compiled/devcards_out/goog/events/eventid.js","js/compiled/devcards_out/goog/events/event.js","js/compiled/devcards_out/goog/events/eventtype.js","js/compiled/devcards_out/goog/events/browserevent.js","js/compiled/devcards_out/goog/events/listenable.js","js/compiled/devcards_out/goog/events/listener.js","js/compiled/devcards_out/goog/events/listenermap.js","js/compiled/devcards_out/goog/events/events.js","js/compiled/devcards_out/goog/events/eventtarget.js","js/compiled/devcards_out/goog/timer/timer.js","js/compiled/devcards_out/goog/events/eventhandler.js","js/compiled/devcards_out/goog/html/legacyconversions.js","js/compiled/devcards_out/goog/net/bulkloaderhelper.js","js/compiled/devcards_out/goog/net/eventtype.js","js/compiled/devcards_out/goog/json/json.js","js/compiled/devcards_out/goog/json/hybrid.js","js/compiled/devcards_out/goog/net/errorcode.js","js/compiled/devcards_out/goog/net/httpstatus.js","js/compiled/devcards_out/goog/net/xhrlike.js","js/compiled/devcards_out/goog/net/xmlhttpfactory.js","js/compiled/devcards_out/goog/net/wrapperxmlhttpfactory.js","js/compiled/devcards_out/goog/net/xmlhttp.js","js/compiled/devcards_out/goog/net/xhrio.js","js/compiled/devcards_out/goog/net/bulkloader.js","js/compiled/devcards_out/goog/net/jsloader.js","js/compiled/devcards_out/goog/useragent/product.js","js/compiled/devcards_out/goog/module/moduleloader.js","js/compiled/devcards_out/cljs/loader.js","js/compiled/devcards_out/fulcro/client/logging.js","js/compiled/devcards_out/yahoo/intl-messageformat-with-locales.js","js/compiled/devcards_out/fulcro/i18n.js","js/compiled/devcards_out/fulcro/client/mutations.js","js/compiled/devcards_out/cljs/core/async/impl/protocols.js","js/compiled/devcards_out/cljs/core/async/impl/buffers.js","js/compiled/devcards_out/cljs/core/async/impl/dispatch.js","js/compiled/devcards_out/cljs/core/async/impl/channels.js","js/compiled/devcards_out/cljs/core/async/impl/ioc_helpers.js","js/compiled/devcards_out/cljs/core/async/impl/timers.js","js/compiled/devcards_out/cljs/core/async.js","js/compiled/devcards_out/fulcro/client/impl/om_plumbing.js","js/compiled/devcards_out/fulcro/client/impl/data_fetch.js","js/compiled/devcards_out/fulcro/client/network.js","js/compiled/devcards_out/fulcro/client/impl/application.js","js/compiled/devcards_out/fulcro/client/core.js","js/compiled/devcards_out/fulcro/inspect/helpers.js","js/compiled/devcards_out/com/rpl/specter/protocols.js","js/compiled/devcards_out/com/rpl/specter/impl.js","js/compiled/devcards_out/com/rpl/specter/navs.js","js/compiled/devcards_out/com/rpl/specter.js","js/compiled/devcards_out/garden/selectors.js","js/compiled/devcards_out/garden/types.js","js/compiled/devcards_out/goog/string/stringformat.js","js/compiled/devcards_out/garden/util.js","js/compiled/devcards_out/garden/units.js","js/compiled/devcards_out/garden/color.js","js/compiled/devcards_out/garden/compression.js","js/compiled/devcards_out/garden/compiler.js","js/compiled/devcards_out/garden/core.js","js/compiled/devcards_out/fulcro_css/core.js","js/compiled/devcards_out/fulcro_css/css.js","js/compiled/devcards_out/fulcro/inspect/ui/core.js","js/compiled/devcards_out/fulcro/inspect/ui/data_viewer.js","js/compiled/devcards_out/clojure/data.js","js/compiled/devcards_out/fulcro/inspect/ui/transactions.js","js/compiled/devcards_out/fulcro/inspect/ui/network.js","js/compiled/devcards_out/fulcro/inspect/ui/data_watcher.js","js/compiled/devcards_out/fulcro/inspect/ui/events.js","js/compiled/devcards_out/fulcro/inspect/ui/inspector.js","js/compiled/devcards_out/fulcro/inspect/core.js","js/compiled/devcards_out/fulcro/inspect/prefs.js","js/compiled/devcards_out/fulcro/inspect/preload.js","js/compiled/devcards_out/devtools/version.js","js/compiled/devcards_out/devtools/context.js","js/compiled/devcards_out/devtools/defaults.js","js/compiled/devcards_out/devtools/prefs.js","js/compiled/devcards_out/devtools/util.js","js/compiled/devcards_out/process/env.js","js/compiled/devcards_out/devtools/protocols.js","js/compiled/devcards_out/devtools/format.js","js/compiled/devcards_out/devtools/munging.js","js/compiled/devcards_out/devtools/formatters/helpers.js","js/compiled/devcards_out/devtools/formatters/state.js","js/compiled/devcards_out/devtools/formatters/templating.js","js/compiled/devcards_out/devtools/formatters/printing.js","js/compiled/devcards_out/devtools/formatters/markup.js","js/compiled/devcards_out/cljs/stacktrace.js","js/compiled/devcards_out/devtools/toolbox.js","js/compiled/devcards_out/devtools/async.js","js/compiled/devcards_out/devtools/reporter.js","js/compiled/devcards_out/devtools/formatters/budgeting.js","js/compiled/devcards_out/devtools/formatters/core.js","js/compiled/devcards_out/devtools/formatters.js","js/compiled/devcards_out/devtools/hints.js","js/compiled/devcards_out/devtools/core.js","js/compiled/devcards_out/devtools/preload.js","js/compiled/devcards_out/goog/dom/inputtype.js","js/compiled/devcards_out/sablono/util.js","js/compiled/devcards_out/sablono/normalize.js","js/compiled/devcards_out/cljsjs/showdown/development/showdown.inc.js","js/compiled/devcards_out/devcards/util/markdown.js","js/compiled/devcards_out/cljs/test.js","js/compiled/devcards_out/figwheel/client/utils.js","js/compiled/devcards_out/figwheel/client/socket.js","js/compiled/devcards_out/clojure/test/check/random/longs/bit_count_impl.js","js/compiled/devcards_out/clojure/test/check/random/longs.js","js/compiled/devcards_out/clojure/test/check/random/doubles.js","js/compiled/devcards_out/clojure/test/check/random.js","js/compiled/devcards_out/sablono/interpreter.js","js/compiled/devcards_out/figwheel/client/file_reloading.js","js/compiled/devcards_out/devcards/util/utils.js","js/compiled/devcards_out/goog/history/eventtype.js","js/compiled/devcards_out/goog/history/event.js","js/compiled/devcards_out/goog/labs/useragent/device.js","js/compiled/devcards_out/goog/memoize/memoize.js","js/compiled/devcards_out/goog/history/history.js","js/compiled/devcards_out/sablono/core.js","js/compiled/devcards_out/devcards/util/edn_renderer.js","js/compiled/devcards_out/devcards/system.js","js/compiled/devcards_out/devcards/core.js","js/compiled/devcards_out/fulcro/inspect/card_helpers.js","js/compiled/devcards_out/fulcro/client/cards.js","js/compiled/devcards_out/fulcro/inspect/ui/transactions_cards.js","js/compiled/devcards_out/clojure/test/check/rose_tree.js","js/compiled/devcards_out/clojure/test/check/generators.js","js/compiled/devcards_out/fulcro/inspect/ui/data_viewer_cards.js","js/compiled/devcards_out/goog/dom/dataset.js","js/compiled/devcards_out/figwheel/client/heads_up.js","js/compiled/devcards_out/cljs/repl.js","js/compiled/devcards_out/fulcro/inspect/ui/data_watcher_cards.js","js/compiled/devcards_out/fulcro/inspect/devcards.js","js/compiled/devcards_out/figwheel/client.js","js/compiled/devcards_out/figwheel/connect/build_devcards.js"], true)], null);
cljs.loader.deps_for = (function cljs$loader$deps_for(x,graph){
var depends_on = cljs.core.get.call(null,graph,x);
return cljs.core.vec.call(null,cljs.core.distinct.call(null,cljs.core.concat.call(null,cljs.core.mapcat.call(null,((function (depends_on){
return (function (p1__236059_SHARP_){
return cljs.loader.deps_for.call(null,p1__236059_SHARP_,graph);
});})(depends_on))
,depends_on),depends_on)));
});
cljs.loader.munge_kw = (function cljs$loader$munge_kw(x){
var G__236060 = x;
if((x instanceof cljs.core.Keyword)){
return cljs.core.munge.call(null,cljs.core.name.call(null,G__236060));
} else {
return G__236060;
}
});
cljs.loader.to_js = (function cljs$loader$to_js(m){
return cljs.core.reduce_kv.call(null,(function (ret,k,xs){
var arr = cljs.core.into_array.call(null,cljs.core.map.call(null,cljs.loader.munge_kw,xs));
var G__236061 = ret;
goog.object.set(G__236061,cljs.core.munge.call(null,cljs.core.name.call(null,k)),arr);

return G__236061;
}),({}),m);
});
cljs.loader.create_module_manager = (function cljs$loader$create_module_manager(){
var mm = (new goog.module.ModuleManager());
var ml = (new goog.module.ModuleLoader());
mm.setLoader(ml);

return mm;
});
if(typeof cljs.loader._STAR_module_manager_STAR_ !== 'undefined'){
} else {
cljs.loader._STAR_module_manager_STAR_ = cljs.loader.create_module_manager.call(null);
}
cljs.loader._STAR_module_manager_STAR_.setAllModuleInfo(cljs.loader.to_js.call(null,cljs.loader.module_infos));
cljs.loader._STAR_module_manager_STAR_.setModuleUris(cljs.loader.to_js.call(null,cljs.loader.module_uris));
/**
 * Return true if modules is loaded. module-name should be a keyword matching
 * a :modules module definition.
 */
cljs.loader.loaded_QMARK_ = (function cljs$loader$loaded_QMARK_(module_name){
if(cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,module_name)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Module ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(module_name)," does not exist"].join('')),"\n","(contains? module-infos module-name)"].join('')));
}

var mname = cljs.core.munge.call(null,cljs.core.name.call(null,module_name));
var module = cljs.loader._STAR_module_manager_STAR_.getModuleInfo(mname);
if(!((module == null))){
return module.isLoaded();
} else {
return null;
}
});
/**
 * Load a module. module-name should be a keyword matching a :modules module
 * definition.
 */
cljs.loader.load = (function cljs$loader$load(var_args){
var G__236063 = arguments.length;
switch (G__236063) {
case 1:
return cljs.loader.load.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.loader.load.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.loader.load.cljs$core$IFn$_invoke$arity$1 = (function (module_name){
return cljs.loader.load.call(null,module_name,null);
});

cljs.loader.load.cljs$core$IFn$_invoke$arity$2 = (function (module_name,cb){
if(cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,module_name)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Module ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(module_name)," does not exist"].join('')),"\n","(contains? module-infos module-name)"].join('')));
}

var mname = cljs.core.munge.call(null,cljs.core.name.call(null,module_name));
if(!((cb == null))){
return cljs.loader._STAR_module_manager_STAR_.execOnLoad(mname,cb);
} else {
return cljs.loader._STAR_module_manager_STAR_.load(mname);
}
});

cljs.loader.load.cljs$lang$maxFixedArity = 2;

/**
 * Set a module as being loaded. module-name should be a keyword matching a
 *   :modules module definition. Will mark all parent modules as also being
 *   loaded. Note that calls to this function will be automatically generated
 *   as the final expression for known :modules entry points that require the
 *   cljs.loader namespace.
 */
cljs.loader.set_loaded_BANG_ = (function cljs$loader$set_loaded_BANG_(module_name){
if(cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,module_name)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Module ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(module_name)," does not exist"].join('')),"\n","(contains? module-infos module-name)"].join('')));
}

var xs = cljs.loader.deps_for.call(null,module_name,cljs.loader.module_infos);
var seq__236065_236069 = cljs.core.seq.call(null,xs);
var chunk__236066_236070 = null;
var count__236067_236071 = (0);
var i__236068_236072 = (0);
while(true){
if((i__236068_236072 < count__236067_236071)){
var x_236073 = cljs.core._nth.call(null,chunk__236066_236070,i__236068_236072);
cljs.loader._STAR_module_manager_STAR_.setLoaded(cljs.loader.munge_kw.call(null,x_236073));

var G__236074 = seq__236065_236069;
var G__236075 = chunk__236066_236070;
var G__236076 = count__236067_236071;
var G__236077 = (i__236068_236072 + (1));
seq__236065_236069 = G__236074;
chunk__236066_236070 = G__236075;
count__236067_236071 = G__236076;
i__236068_236072 = G__236077;
continue;
} else {
var temp__4657__auto___236078 = cljs.core.seq.call(null,seq__236065_236069);
if(temp__4657__auto___236078){
var seq__236065_236079__$1 = temp__4657__auto___236078;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__236065_236079__$1)){
var c__28980__auto___236080 = cljs.core.chunk_first.call(null,seq__236065_236079__$1);
var G__236081 = cljs.core.chunk_rest.call(null,seq__236065_236079__$1);
var G__236082 = c__28980__auto___236080;
var G__236083 = cljs.core.count.call(null,c__28980__auto___236080);
var G__236084 = (0);
seq__236065_236069 = G__236081;
chunk__236066_236070 = G__236082;
count__236067_236071 = G__236083;
i__236068_236072 = G__236084;
continue;
} else {
var x_236085 = cljs.core.first.call(null,seq__236065_236079__$1);
cljs.loader._STAR_module_manager_STAR_.setLoaded(cljs.loader.munge_kw.call(null,x_236085));

var G__236086 = cljs.core.next.call(null,seq__236065_236079__$1);
var G__236087 = null;
var G__236088 = (0);
var G__236089 = (0);
seq__236065_236069 = G__236086;
chunk__236066_236070 = G__236087;
count__236067_236071 = G__236088;
i__236068_236072 = G__236089;
continue;
}
} else {
}
}
break;
}

return cljs.loader._STAR_module_manager_STAR_.setLoaded(cljs.loader.munge_kw.call(null,module_name));
});
/**
 * Prefetch a module. module-name should be a keyword matching a :modules
 *   module definition. Will download the module but not evaluate it. To
 *   complete module load, one must also call cljs.loader/load after prefetching
 *   the module. Does nothing if the module is loading or has been loaded.
 */
cljs.loader.prefetch = (function cljs$loader$prefetch(module_name){
if(cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,module_name)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Module ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(module_name)," does not exist"].join('')),"\n","(contains? module-infos module-name)"].join('')));
}

if(cljs.core.truth_(cljs.loader.loaded_QMARK_.call(null,module_name))){
return null;
} else {
var mname = cljs.core.munge.call(null,cljs.core.name.call(null,module_name));
if(cljs.core.truth_(cljs.loader._STAR_module_manager_STAR_.isModuleLoading(mname))){
return null;
} else {
return cljs.loader._STAR_module_manager_STAR_.prefetchModule(mname);
}
}
});

//# sourceMappingURL=loader.js.map?rel=1511294528400
