// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e73053){if((e73053 instanceof Error)){
var e = e73053;
return "Error: Unable to stringify";
} else {
throw e73053;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__73057 = arguments.length;
switch (G__73057) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__73055_SHARP_){
if(typeof p1__73055_SHARP_ === 'string'){
return p1__73055_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__73055_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___73068 = arguments.length;
var i__29313__auto___73069 = (0);
while(true){
if((i__29313__auto___73069 < len__29312__auto___73068)){
args__29319__auto__.push((arguments[i__29313__auto___73069]));

var G__73070 = (i__29313__auto___73069 + (1));
i__29313__auto___73069 = G__73070;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq73067){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq73067));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___73073 = arguments.length;
var i__29313__auto___73074 = (0);
while(true){
if((i__29313__auto___73074 < len__29312__auto___73073)){
args__29319__auto__.push((arguments[i__29313__auto___73074]));

var G__73075 = (i__29313__auto___73074 + (1));
i__29313__auto___73074 = G__73075;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq73071){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq73071));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__73083){
var map__73084 = p__73083;
var map__73084__$1 = ((((!((map__73084 == null)))?((((map__73084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73084.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73084):map__73084);
var message = cljs.core.get.call(null,map__73084__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__73084__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28141__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28129__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28129__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28129__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__42036__auto___73173 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___73173,ch){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___73173,ch){
return (function (state_73142){
var state_val_73143 = (state_73142[(1)]);
if((state_val_73143 === (7))){
var inst_73138 = (state_73142[(2)]);
var state_73142__$1 = state_73142;
var statearr_73144_73174 = state_73142__$1;
(statearr_73144_73174[(2)] = inst_73138);

(statearr_73144_73174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (1))){
var state_73142__$1 = state_73142;
var statearr_73145_73176 = state_73142__$1;
(statearr_73145_73176[(2)] = null);

(statearr_73145_73176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (4))){
var inst_73095 = (state_73142[(7)]);
var inst_73095__$1 = (state_73142[(2)]);
var state_73142__$1 = (function (){var statearr_73146 = state_73142;
(statearr_73146[(7)] = inst_73095__$1);

return statearr_73146;
})();
if(cljs.core.truth_(inst_73095__$1)){
var statearr_73147_73178 = state_73142__$1;
(statearr_73147_73178[(1)] = (5));

} else {
var statearr_73148_73179 = state_73142__$1;
(statearr_73148_73179[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (15))){
var inst_73102 = (state_73142[(8)]);
var inst_73117 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_73102);
var inst_73118 = cljs.core.first.call(null,inst_73117);
var inst_73119 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_73118);
var inst_73120 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73119)].join('');
var inst_73121 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_73120);
var state_73142__$1 = state_73142;
var statearr_73150_73180 = state_73142__$1;
(statearr_73150_73180[(2)] = inst_73121);

(statearr_73150_73180[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (13))){
var inst_73126 = (state_73142[(2)]);
var state_73142__$1 = state_73142;
var statearr_73151_73181 = state_73142__$1;
(statearr_73151_73181[(2)] = inst_73126);

(statearr_73151_73181[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (6))){
var state_73142__$1 = state_73142;
var statearr_73152_73182 = state_73142__$1;
(statearr_73152_73182[(2)] = null);

(statearr_73152_73182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (17))){
var inst_73124 = (state_73142[(2)]);
var state_73142__$1 = state_73142;
var statearr_73153_73183 = state_73142__$1;
(statearr_73153_73183[(2)] = inst_73124);

(statearr_73153_73183[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (3))){
var inst_73140 = (state_73142[(2)]);
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73142__$1,inst_73140);
} else {
if((state_val_73143 === (12))){
var inst_73101 = (state_73142[(9)]);
var inst_73115 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_73101,opts);
var state_73142__$1 = state_73142;
if(cljs.core.truth_(inst_73115)){
var statearr_73154_73185 = state_73142__$1;
(statearr_73154_73185[(1)] = (15));

} else {
var statearr_73155_73186 = state_73142__$1;
(statearr_73155_73186[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (2))){
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73142__$1,(4),ch);
} else {
if((state_val_73143 === (11))){
var inst_73102 = (state_73142[(8)]);
var inst_73107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73108 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_73102);
var inst_73109 = cljs.core.async.timeout.call(null,(1000));
var inst_73110 = [inst_73108,inst_73109];
var inst_73111 = (new cljs.core.PersistentVector(null,2,(5),inst_73107,inst_73110,null));
var state_73142__$1 = state_73142;
return cljs.core.async.ioc_alts_BANG_.call(null,state_73142__$1,(14),inst_73111);
} else {
if((state_val_73143 === (9))){
var inst_73102 = (state_73142[(8)]);
var inst_73128 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_73129 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_73102);
var inst_73130 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_73129);
var inst_73131 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73130)].join('');
var inst_73132 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_73131);
var state_73142__$1 = (function (){var statearr_73156 = state_73142;
(statearr_73156[(10)] = inst_73128);

return statearr_73156;
})();
var statearr_73157_73188 = state_73142__$1;
(statearr_73157_73188[(2)] = inst_73132);

(statearr_73157_73188[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (5))){
var inst_73095 = (state_73142[(7)]);
var inst_73097 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_73098 = (new cljs.core.PersistentArrayMap(null,2,inst_73097,null));
var inst_73099 = (new cljs.core.PersistentHashSet(null,inst_73098,null));
var inst_73100 = figwheel.client.focus_msgs.call(null,inst_73099,inst_73095);
var inst_73101 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_73100);
var inst_73102 = cljs.core.first.call(null,inst_73100);
var inst_73103 = figwheel.client.autoload_QMARK_.call(null);
var state_73142__$1 = (function (){var statearr_73158 = state_73142;
(statearr_73158[(8)] = inst_73102);

(statearr_73158[(9)] = inst_73101);

return statearr_73158;
})();
if(cljs.core.truth_(inst_73103)){
var statearr_73159_73189 = state_73142__$1;
(statearr_73159_73189[(1)] = (8));

} else {
var statearr_73160_73190 = state_73142__$1;
(statearr_73160_73190[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (14))){
var inst_73113 = (state_73142[(2)]);
var state_73142__$1 = state_73142;
var statearr_73161_73191 = state_73142__$1;
(statearr_73161_73191[(2)] = inst_73113);

(statearr_73161_73191[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (16))){
var state_73142__$1 = state_73142;
var statearr_73162_73193 = state_73142__$1;
(statearr_73162_73193[(2)] = null);

(statearr_73162_73193[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (10))){
var inst_73134 = (state_73142[(2)]);
var state_73142__$1 = (function (){var statearr_73163 = state_73142;
(statearr_73163[(11)] = inst_73134);

return statearr_73163;
})();
var statearr_73164_73196 = state_73142__$1;
(statearr_73164_73196[(2)] = null);

(statearr_73164_73196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73143 === (8))){
var inst_73101 = (state_73142[(9)]);
var inst_73105 = figwheel.client.reload_file_state_QMARK_.call(null,inst_73101,opts);
var state_73142__$1 = state_73142;
if(cljs.core.truth_(inst_73105)){
var statearr_73166_73200 = state_73142__$1;
(statearr_73166_73200[(1)] = (11));

} else {
var statearr_73167_73201 = state_73142__$1;
(statearr_73167_73201[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___73173,ch))
;
return ((function (switch__42015__auto__,c__42036__auto___73173,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____0 = (function (){
var statearr_73169 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73169[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__);

(statearr_73169[(1)] = (1));

return statearr_73169;
});
var figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____1 = (function (state_73142){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_73142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e73170){if((e73170 instanceof Object)){
var ex__42019__auto__ = e73170;
var statearr_73171_73204 = state_73142;
(statearr_73171_73204[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73142);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73170;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73205 = state_73142;
state_73142 = G__73205;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__ = function(state_73142){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____1.call(this,state_73142);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___73173,ch))
})();
var state__42038__auto__ = (function (){var statearr_73172 = f__42037__auto__.call(null);
(statearr_73172[(6)] = c__42036__auto___73173);

return statearr_73172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___73173,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__73206_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__73206_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_73214 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_73214){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e73212){if((e73212 instanceof Error)){
var e = e73212;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_73214], null));
} else {
var e = e73212;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_73214))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__73216){
var map__73217 = p__73216;
var map__73217__$1 = ((((!((map__73217 == null)))?((((map__73217.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73217.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73217):map__73217);
var opts = map__73217__$1;
var build_id = cljs.core.get.call(null,map__73217__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__73217,map__73217__$1,opts,build_id){
return (function (p__73220){
var vec__73221 = p__73220;
var seq__73222 = cljs.core.seq.call(null,vec__73221);
var first__73223 = cljs.core.first.call(null,seq__73222);
var seq__73222__$1 = cljs.core.next.call(null,seq__73222);
var map__73224 = first__73223;
var map__73224__$1 = ((((!((map__73224 == null)))?((((map__73224.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73224.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73224):map__73224);
var msg = map__73224__$1;
var msg_name = cljs.core.get.call(null,map__73224__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__73222__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__73221,seq__73222,first__73223,seq__73222__$1,map__73224,map__73224__$1,msg,msg_name,_,map__73217,map__73217__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__73221,seq__73222,first__73223,seq__73222__$1,map__73224,map__73224__$1,msg,msg_name,_,map__73217,map__73217__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__73217,map__73217__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__73227){
var vec__73228 = p__73227;
var seq__73229 = cljs.core.seq.call(null,vec__73228);
var first__73230 = cljs.core.first.call(null,seq__73229);
var seq__73229__$1 = cljs.core.next.call(null,seq__73229);
var map__73231 = first__73230;
var map__73231__$1 = ((((!((map__73231 == null)))?((((map__73231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73231.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73231):map__73231);
var msg = map__73231__$1;
var msg_name = cljs.core.get.call(null,map__73231__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__73229__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__73237){
var map__73238 = p__73237;
var map__73238__$1 = ((((!((map__73238 == null)))?((((map__73238.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73238.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73238):map__73238);
var on_compile_warning = cljs.core.get.call(null,map__73238__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__73238__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__73238,map__73238__$1,on_compile_warning,on_compile_fail){
return (function (p__73242){
var vec__73243 = p__73242;
var seq__73244 = cljs.core.seq.call(null,vec__73243);
var first__73245 = cljs.core.first.call(null,seq__73244);
var seq__73244__$1 = cljs.core.next.call(null,seq__73244);
var map__73246 = first__73245;
var map__73246__$1 = ((((!((map__73246 == null)))?((((map__73246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73246.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73246):map__73246);
var msg = map__73246__$1;
var msg_name = cljs.core.get.call(null,map__73246__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__73244__$1;
var pred__73248 = cljs.core._EQ_;
var expr__73249 = msg_name;
if(cljs.core.truth_(pred__73248.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__73249))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__73248.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__73249))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__73238,map__73238__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,msg_hist,msg_names,msg){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,msg_hist,msg_names,msg){
return (function (state_73338){
var state_val_73339 = (state_73338[(1)]);
if((state_val_73339 === (7))){
var inst_73258 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
if(cljs.core.truth_(inst_73258)){
var statearr_73340_73389 = state_73338__$1;
(statearr_73340_73389[(1)] = (8));

} else {
var statearr_73341_73390 = state_73338__$1;
(statearr_73341_73390[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (20))){
var inst_73332 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73342_73391 = state_73338__$1;
(statearr_73342_73391[(2)] = inst_73332);

(statearr_73342_73391[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (27))){
var inst_73328 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73343_73392 = state_73338__$1;
(statearr_73343_73392[(2)] = inst_73328);

(statearr_73343_73392[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (1))){
var inst_73251 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_73338__$1 = state_73338;
if(cljs.core.truth_(inst_73251)){
var statearr_73344_73393 = state_73338__$1;
(statearr_73344_73393[(1)] = (2));

} else {
var statearr_73345_73394 = state_73338__$1;
(statearr_73345_73394[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (24))){
var inst_73330 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73346_73395 = state_73338__$1;
(statearr_73346_73395[(2)] = inst_73330);

(statearr_73346_73395[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (4))){
var inst_73336 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73338__$1,inst_73336);
} else {
if((state_val_73339 === (15))){
var inst_73334 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73347_73396 = state_73338__$1;
(statearr_73347_73396[(2)] = inst_73334);

(statearr_73347_73396[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (21))){
var inst_73287 = (state_73338[(2)]);
var inst_73288 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73289 = figwheel.client.auto_jump_to_error.call(null,opts,inst_73288);
var state_73338__$1 = (function (){var statearr_73348 = state_73338;
(statearr_73348[(7)] = inst_73287);

return statearr_73348;
})();
var statearr_73349_73397 = state_73338__$1;
(statearr_73349_73397[(2)] = inst_73289);

(statearr_73349_73397[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (31))){
var inst_73317 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_73338__$1 = state_73338;
if(cljs.core.truth_(inst_73317)){
var statearr_73350_73398 = state_73338__$1;
(statearr_73350_73398[(1)] = (34));

} else {
var statearr_73351_73399 = state_73338__$1;
(statearr_73351_73399[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (32))){
var inst_73326 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73352_73402 = state_73338__$1;
(statearr_73352_73402[(2)] = inst_73326);

(statearr_73352_73402[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (33))){
var inst_73313 = (state_73338[(2)]);
var inst_73314 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73315 = figwheel.client.auto_jump_to_error.call(null,opts,inst_73314);
var state_73338__$1 = (function (){var statearr_73353 = state_73338;
(statearr_73353[(8)] = inst_73313);

return statearr_73353;
})();
var statearr_73354_73405 = state_73338__$1;
(statearr_73354_73405[(2)] = inst_73315);

(statearr_73354_73405[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (13))){
var inst_73272 = figwheel.client.heads_up.clear.call(null);
var state_73338__$1 = state_73338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(16),inst_73272);
} else {
if((state_val_73339 === (22))){
var inst_73293 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73294 = figwheel.client.heads_up.append_warning_message.call(null,inst_73293);
var state_73338__$1 = state_73338;
var statearr_73355_73406 = state_73338__$1;
(statearr_73355_73406[(2)] = inst_73294);

(statearr_73355_73406[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (36))){
var inst_73324 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73356_73408 = state_73338__$1;
(statearr_73356_73408[(2)] = inst_73324);

(statearr_73356_73408[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (29))){
var inst_73304 = (state_73338[(2)]);
var inst_73305 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73306 = figwheel.client.auto_jump_to_error.call(null,opts,inst_73305);
var state_73338__$1 = (function (){var statearr_73357 = state_73338;
(statearr_73357[(9)] = inst_73304);

return statearr_73357;
})();
var statearr_73358_73409 = state_73338__$1;
(statearr_73358_73409[(2)] = inst_73306);

(statearr_73358_73409[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (6))){
var inst_73253 = (state_73338[(10)]);
var state_73338__$1 = state_73338;
var statearr_73359_73410 = state_73338__$1;
(statearr_73359_73410[(2)] = inst_73253);

(statearr_73359_73410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (28))){
var inst_73300 = (state_73338[(2)]);
var inst_73301 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73302 = figwheel.client.heads_up.display_warning.call(null,inst_73301);
var state_73338__$1 = (function (){var statearr_73360 = state_73338;
(statearr_73360[(11)] = inst_73300);

return statearr_73360;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(29),inst_73302);
} else {
if((state_val_73339 === (25))){
var inst_73298 = figwheel.client.heads_up.clear.call(null);
var state_73338__$1 = state_73338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(28),inst_73298);
} else {
if((state_val_73339 === (34))){
var inst_73319 = figwheel.client.heads_up.flash_loaded.call(null);
var state_73338__$1 = state_73338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(37),inst_73319);
} else {
if((state_val_73339 === (17))){
var inst_73278 = (state_73338[(2)]);
var inst_73279 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73280 = figwheel.client.auto_jump_to_error.call(null,opts,inst_73279);
var state_73338__$1 = (function (){var statearr_73361 = state_73338;
(statearr_73361[(12)] = inst_73278);

return statearr_73361;
})();
var statearr_73362_73418 = state_73338__$1;
(statearr_73362_73418[(2)] = inst_73280);

(statearr_73362_73418[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (3))){
var inst_73270 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_73338__$1 = state_73338;
if(cljs.core.truth_(inst_73270)){
var statearr_73363_73420 = state_73338__$1;
(statearr_73363_73420[(1)] = (13));

} else {
var statearr_73364_73421 = state_73338__$1;
(statearr_73364_73421[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (12))){
var inst_73266 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73365_73422 = state_73338__$1;
(statearr_73365_73422[(2)] = inst_73266);

(statearr_73365_73422[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (2))){
var inst_73253 = (state_73338[(10)]);
var inst_73253__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_73338__$1 = (function (){var statearr_73366 = state_73338;
(statearr_73366[(10)] = inst_73253__$1);

return statearr_73366;
})();
if(cljs.core.truth_(inst_73253__$1)){
var statearr_73367_73424 = state_73338__$1;
(statearr_73367_73424[(1)] = (5));

} else {
var statearr_73368_73425 = state_73338__$1;
(statearr_73368_73425[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (23))){
var inst_73296 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_73338__$1 = state_73338;
if(cljs.core.truth_(inst_73296)){
var statearr_73369_73426 = state_73338__$1;
(statearr_73369_73426[(1)] = (25));

} else {
var statearr_73370_73427 = state_73338__$1;
(statearr_73370_73427[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (35))){
var state_73338__$1 = state_73338;
var statearr_73371_73428 = state_73338__$1;
(statearr_73371_73428[(2)] = null);

(statearr_73371_73428[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (19))){
var inst_73291 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_73338__$1 = state_73338;
if(cljs.core.truth_(inst_73291)){
var statearr_73372_73429 = state_73338__$1;
(statearr_73372_73429[(1)] = (22));

} else {
var statearr_73373_73430 = state_73338__$1;
(statearr_73373_73430[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (11))){
var inst_73262 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73374_73432 = state_73338__$1;
(statearr_73374_73432[(2)] = inst_73262);

(statearr_73374_73432[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (9))){
var inst_73264 = figwheel.client.heads_up.clear.call(null);
var state_73338__$1 = state_73338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(12),inst_73264);
} else {
if((state_val_73339 === (5))){
var inst_73255 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_73338__$1 = state_73338;
var statearr_73375_73435 = state_73338__$1;
(statearr_73375_73435[(2)] = inst_73255);

(statearr_73375_73435[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (14))){
var inst_73282 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_73338__$1 = state_73338;
if(cljs.core.truth_(inst_73282)){
var statearr_73376_73437 = state_73338__$1;
(statearr_73376_73437[(1)] = (18));

} else {
var statearr_73377_73438 = state_73338__$1;
(statearr_73377_73438[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (26))){
var inst_73308 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_73338__$1 = state_73338;
if(cljs.core.truth_(inst_73308)){
var statearr_73378_73439 = state_73338__$1;
(statearr_73378_73439[(1)] = (30));

} else {
var statearr_73379_73440 = state_73338__$1;
(statearr_73379_73440[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (16))){
var inst_73274 = (state_73338[(2)]);
var inst_73275 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73276 = figwheel.client.heads_up.display_exception.call(null,inst_73275);
var state_73338__$1 = (function (){var statearr_73380 = state_73338;
(statearr_73380[(13)] = inst_73274);

return statearr_73380;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(17),inst_73276);
} else {
if((state_val_73339 === (30))){
var inst_73310 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73311 = figwheel.client.heads_up.display_warning.call(null,inst_73310);
var state_73338__$1 = state_73338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(33),inst_73311);
} else {
if((state_val_73339 === (10))){
var inst_73268 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73382_73441 = state_73338__$1;
(statearr_73382_73441[(2)] = inst_73268);

(statearr_73382_73441[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (18))){
var inst_73284 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_73285 = figwheel.client.heads_up.display_exception.call(null,inst_73284);
var state_73338__$1 = state_73338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(21),inst_73285);
} else {
if((state_val_73339 === (37))){
var inst_73321 = (state_73338[(2)]);
var state_73338__$1 = state_73338;
var statearr_73383_73442 = state_73338__$1;
(statearr_73383_73442[(2)] = inst_73321);

(statearr_73383_73442[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73339 === (8))){
var inst_73260 = figwheel.client.heads_up.flash_loaded.call(null);
var state_73338__$1 = state_73338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73338__$1,(11),inst_73260);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__42015__auto__,c__42036__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____0 = (function (){
var statearr_73384 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73384[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__);

(statearr_73384[(1)] = (1));

return statearr_73384;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____1 = (function (state_73338){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_73338);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e73385){if((e73385 instanceof Object)){
var ex__42019__auto__ = e73385;
var statearr_73386_73443 = state_73338;
(statearr_73386_73443[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73338);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73444 = state_73338;
state_73338 = G__73444;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__ = function(state_73338){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____1.call(this,state_73338);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,msg_hist,msg_names,msg))
})();
var state__42038__auto__ = (function (){var statearr_73387 = f__42037__auto__.call(null);
(statearr_73387[(6)] = c__42036__auto__);

return statearr_73387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,msg_hist,msg_names,msg))
);

return c__42036__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__42036__auto___73475 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___73475,ch){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___73475,ch){
return (function (state_73459){
var state_val_73460 = (state_73459[(1)]);
if((state_val_73460 === (1))){
var state_73459__$1 = state_73459;
var statearr_73461_73476 = state_73459__$1;
(statearr_73461_73476[(2)] = null);

(statearr_73461_73476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73460 === (2))){
var state_73459__$1 = state_73459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73459__$1,(4),ch);
} else {
if((state_val_73460 === (3))){
var inst_73457 = (state_73459[(2)]);
var state_73459__$1 = state_73459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73459__$1,inst_73457);
} else {
if((state_val_73460 === (4))){
var inst_73447 = (state_73459[(7)]);
var inst_73447__$1 = (state_73459[(2)]);
var state_73459__$1 = (function (){var statearr_73462 = state_73459;
(statearr_73462[(7)] = inst_73447__$1);

return statearr_73462;
})();
if(cljs.core.truth_(inst_73447__$1)){
var statearr_73463_73477 = state_73459__$1;
(statearr_73463_73477[(1)] = (5));

} else {
var statearr_73464_73478 = state_73459__$1;
(statearr_73464_73478[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73460 === (5))){
var inst_73447 = (state_73459[(7)]);
var inst_73449 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_73447);
var state_73459__$1 = state_73459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73459__$1,(8),inst_73449);
} else {
if((state_val_73460 === (6))){
var state_73459__$1 = state_73459;
var statearr_73466_73479 = state_73459__$1;
(statearr_73466_73479[(2)] = null);

(statearr_73466_73479[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73460 === (7))){
var inst_73455 = (state_73459[(2)]);
var state_73459__$1 = state_73459;
var statearr_73467_73480 = state_73459__$1;
(statearr_73467_73480[(2)] = inst_73455);

(statearr_73467_73480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73460 === (8))){
var inst_73451 = (state_73459[(2)]);
var state_73459__$1 = (function (){var statearr_73468 = state_73459;
(statearr_73468[(8)] = inst_73451);

return statearr_73468;
})();
var statearr_73469_73482 = state_73459__$1;
(statearr_73469_73482[(2)] = null);

(statearr_73469_73482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__42036__auto___73475,ch))
;
return ((function (switch__42015__auto__,c__42036__auto___73475,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__42016__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__42016__auto____0 = (function (){
var statearr_73470 = [null,null,null,null,null,null,null,null,null];
(statearr_73470[(0)] = figwheel$client$heads_up_plugin_$_state_machine__42016__auto__);

(statearr_73470[(1)] = (1));

return statearr_73470;
});
var figwheel$client$heads_up_plugin_$_state_machine__42016__auto____1 = (function (state_73459){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_73459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e73471){if((e73471 instanceof Object)){
var ex__42019__auto__ = e73471;
var statearr_73472_73484 = state_73459;
(statearr_73472_73484[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73459);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73471;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73485 = state_73459;
state_73459 = G__73485;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__42016__auto__ = function(state_73459){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__42016__auto____1.call(this,state_73459);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__42016__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__42016__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___73475,ch))
})();
var state__42038__auto__ = (function (){var statearr_73473 = f__42037__auto__.call(null);
(statearr_73473[(6)] = c__42036__auto___73475);

return statearr_73473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___73475,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_73492){
var state_val_73493 = (state_73492[(1)]);
if((state_val_73493 === (1))){
var inst_73487 = cljs.core.async.timeout.call(null,(3000));
var state_73492__$1 = state_73492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73492__$1,(2),inst_73487);
} else {
if((state_val_73493 === (2))){
var inst_73489 = (state_73492[(2)]);
var inst_73490 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_73492__$1 = (function (){var statearr_73494 = state_73492;
(statearr_73494[(7)] = inst_73489);

return statearr_73494;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73492__$1,inst_73490);
} else {
return null;
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____0 = (function (){
var statearr_73495 = [null,null,null,null,null,null,null,null];
(statearr_73495[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__);

(statearr_73495[(1)] = (1));

return statearr_73495;
});
var figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____1 = (function (state_73492){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_73492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e73496){if((e73496 instanceof Object)){
var ex__42019__auto__ = e73496;
var statearr_73497_73504 = state_73492;
(statearr_73497_73504[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73492);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73496;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73506 = state_73492;
state_73492 = G__73506;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__ = function(state_73492){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____1.call(this,state_73492);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_73498 = f__42037__auto__.call(null);
(statearr_73498[(6)] = c__42036__auto__);

return statearr_73498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,figwheel_version,temp__4657__auto__){
return (function (state_73513){
var state_val_73514 = (state_73513[(1)]);
if((state_val_73514 === (1))){
var inst_73507 = cljs.core.async.timeout.call(null,(2000));
var state_73513__$1 = state_73513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73513__$1,(2),inst_73507);
} else {
if((state_val_73514 === (2))){
var inst_73509 = (state_73513[(2)]);
var inst_73510 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_73511 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_73510);
var state_73513__$1 = (function (){var statearr_73515 = state_73513;
(statearr_73515[(7)] = inst_73509);

return statearr_73515;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73513__$1,inst_73511);
} else {
return null;
}
}
});})(c__42036__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____0 = (function (){
var statearr_73516 = [null,null,null,null,null,null,null,null];
(statearr_73516[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__);

(statearr_73516[(1)] = (1));

return statearr_73516;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____1 = (function (state_73513){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_73513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e73517){if((e73517 instanceof Object)){
var ex__42019__auto__ = e73517;
var statearr_73518_73520 = state_73513;
(statearr_73518_73520[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73513);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73517;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73521 = state_73513;
state_73513 = G__73521;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__ = function(state_73513){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____1.call(this,state_73513);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,figwheel_version,temp__4657__auto__))
})();
var state__42038__auto__ = (function (){var statearr_73519 = f__42037__auto__.call(null);
(statearr_73519[(6)] = c__42036__auto__);

return statearr_73519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,figwheel_version,temp__4657__auto__))
);

return c__42036__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__73522){
var map__73523 = p__73522;
var map__73523__$1 = ((((!((map__73523 == null)))?((((map__73523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73523.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73523):map__73523);
var file = cljs.core.get.call(null,map__73523__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__73523__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__73523__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__73531 = "";
var G__73531__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__73531),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__73531);
var G__73531__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__73531__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__73531__$1);
if(cljs.core.truth_((function (){var and__28129__auto__ = line;
if(cljs.core.truth_(and__28129__auto__)){
return column;
} else {
return and__28129__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__73531__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__73531__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__73534){
var map__73535 = p__73534;
var map__73535__$1 = ((((!((map__73535 == null)))?((((map__73535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73535.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73535):map__73535);
var ed = map__73535__$1;
var formatted_exception = cljs.core.get.call(null,map__73535__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__73535__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__73535__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__73537_73543 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__73538_73544 = null;
var count__73539_73545 = (0);
var i__73540_73546 = (0);
while(true){
if((i__73540_73546 < count__73539_73545)){
var msg_73547 = cljs.core._nth.call(null,chunk__73538_73544,i__73540_73546);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_73547);

var G__73548 = seq__73537_73543;
var G__73549 = chunk__73538_73544;
var G__73550 = count__73539_73545;
var G__73551 = (i__73540_73546 + (1));
seq__73537_73543 = G__73548;
chunk__73538_73544 = G__73549;
count__73539_73545 = G__73550;
i__73540_73546 = G__73551;
continue;
} else {
var temp__4657__auto___73552 = cljs.core.seq.call(null,seq__73537_73543);
if(temp__4657__auto___73552){
var seq__73537_73553__$1 = temp__4657__auto___73552;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73537_73553__$1)){
var c__28980__auto___73555 = cljs.core.chunk_first.call(null,seq__73537_73553__$1);
var G__73556 = cljs.core.chunk_rest.call(null,seq__73537_73553__$1);
var G__73557 = c__28980__auto___73555;
var G__73558 = cljs.core.count.call(null,c__28980__auto___73555);
var G__73559 = (0);
seq__73537_73543 = G__73556;
chunk__73538_73544 = G__73557;
count__73539_73545 = G__73558;
i__73540_73546 = G__73559;
continue;
} else {
var msg_73560 = cljs.core.first.call(null,seq__73537_73553__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_73560);

var G__73561 = cljs.core.next.call(null,seq__73537_73553__$1);
var G__73562 = null;
var G__73563 = (0);
var G__73564 = (0);
seq__73537_73543 = G__73561;
chunk__73538_73544 = G__73562;
count__73539_73545 = G__73563;
i__73540_73546 = G__73564;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__73569){
var map__73570 = p__73569;
var map__73570__$1 = ((((!((map__73570 == null)))?((((map__73570.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73570.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73570):map__73570);
var w = map__73570__$1;
var message = cljs.core.get.call(null,map__73570__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/compiled/devcards_out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/compiled/devcards_out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28129__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28129__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28129__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__73573 = cljs.core.seq.call(null,plugins);
var chunk__73574 = null;
var count__73575 = (0);
var i__73576 = (0);
while(true){
if((i__73576 < count__73575)){
var vec__73577 = cljs.core._nth.call(null,chunk__73574,i__73576);
var k = cljs.core.nth.call(null,vec__73577,(0),null);
var plugin = cljs.core.nth.call(null,vec__73577,(1),null);
if(cljs.core.truth_(plugin)){
var pl_73584 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__73573,chunk__73574,count__73575,i__73576,pl_73584,vec__73577,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_73584.call(null,msg_hist);
});})(seq__73573,chunk__73574,count__73575,i__73576,pl_73584,vec__73577,k,plugin))
);
} else {
}

var G__73585 = seq__73573;
var G__73586 = chunk__73574;
var G__73587 = count__73575;
var G__73588 = (i__73576 + (1));
seq__73573 = G__73585;
chunk__73574 = G__73586;
count__73575 = G__73587;
i__73576 = G__73588;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__73573);
if(temp__4657__auto__){
var seq__73573__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73573__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__73573__$1);
var G__73589 = cljs.core.chunk_rest.call(null,seq__73573__$1);
var G__73590 = c__28980__auto__;
var G__73591 = cljs.core.count.call(null,c__28980__auto__);
var G__73592 = (0);
seq__73573 = G__73589;
chunk__73574 = G__73590;
count__73575 = G__73591;
i__73576 = G__73592;
continue;
} else {
var vec__73581 = cljs.core.first.call(null,seq__73573__$1);
var k = cljs.core.nth.call(null,vec__73581,(0),null);
var plugin = cljs.core.nth.call(null,vec__73581,(1),null);
if(cljs.core.truth_(plugin)){
var pl_73593 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__73573,chunk__73574,count__73575,i__73576,pl_73593,vec__73581,k,plugin,seq__73573__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_73593.call(null,msg_hist);
});})(seq__73573,chunk__73574,count__73575,i__73576,pl_73593,vec__73581,k,plugin,seq__73573__$1,temp__4657__auto__))
);
} else {
}

var G__73594 = cljs.core.next.call(null,seq__73573__$1);
var G__73595 = null;
var G__73596 = (0);
var G__73597 = (0);
seq__73573 = G__73594;
chunk__73574 = G__73595;
count__73575 = G__73596;
i__73576 = G__73597;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__73599 = arguments.length;
switch (G__73599) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__73600_73608 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__73601_73609 = null;
var count__73602_73610 = (0);
var i__73603_73611 = (0);
while(true){
if((i__73603_73611 < count__73602_73610)){
var msg_73612 = cljs.core._nth.call(null,chunk__73601_73609,i__73603_73611);
figwheel.client.socket.handle_incoming_message.call(null,msg_73612);

var G__73613 = seq__73600_73608;
var G__73614 = chunk__73601_73609;
var G__73615 = count__73602_73610;
var G__73616 = (i__73603_73611 + (1));
seq__73600_73608 = G__73613;
chunk__73601_73609 = G__73614;
count__73602_73610 = G__73615;
i__73603_73611 = G__73616;
continue;
} else {
var temp__4657__auto___73617 = cljs.core.seq.call(null,seq__73600_73608);
if(temp__4657__auto___73617){
var seq__73600_73618__$1 = temp__4657__auto___73617;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73600_73618__$1)){
var c__28980__auto___73619 = cljs.core.chunk_first.call(null,seq__73600_73618__$1);
var G__73620 = cljs.core.chunk_rest.call(null,seq__73600_73618__$1);
var G__73621 = c__28980__auto___73619;
var G__73622 = cljs.core.count.call(null,c__28980__auto___73619);
var G__73623 = (0);
seq__73600_73608 = G__73620;
chunk__73601_73609 = G__73621;
count__73602_73610 = G__73622;
i__73603_73611 = G__73623;
continue;
} else {
var msg_73624 = cljs.core.first.call(null,seq__73600_73618__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_73624);

var G__73625 = cljs.core.next.call(null,seq__73600_73618__$1);
var G__73626 = null;
var G__73627 = (0);
var G__73628 = (0);
seq__73600_73608 = G__73625;
chunk__73601_73609 = G__73626;
count__73602_73610 = G__73627;
i__73603_73611 = G__73628;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29319__auto__ = [];
var len__29312__auto___73641 = arguments.length;
var i__29313__auto___73642 = (0);
while(true){
if((i__29313__auto___73642 < len__29312__auto___73641)){
args__29319__auto__.push((arguments[i__29313__auto___73642]));

var G__73645 = (i__29313__auto___73642 + (1));
i__29313__auto___73642 = G__73645;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__73635){
var map__73636 = p__73635;
var map__73636__$1 = ((((!((map__73636 == null)))?((((map__73636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73636.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73636):map__73636);
var opts = map__73636__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq73632){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq73632));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e73651){if((e73651 instanceof Error)){
var e = e73651;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e73651;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__73652){
var map__73653 = p__73652;
var map__73653__$1 = ((((!((map__73653 == null)))?((((map__73653.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73653.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73653):map__73653);
var msg_name = cljs.core.get.call(null,map__73653__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1511229582782
