// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.impl.application');
goog.require('cljs.core');
goog.require('fulcro.client.logging');
goog.require('om.next');
goog.require('om.util');
goog.require('fulcro.i18n');
goog.require('fulcro.client.impl.data_fetch');
goog.require('fulcro.client.util');
goog.require('cljs.core.async');
goog.require('fulcro.client.network');
goog.require('fulcro.client.impl.om_plumbing');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
fulcro.client.impl.application.fallback_handler = (function fulcro$client$impl$application$fallback_handler(p__83369,query){
var map__83370 = p__83369;
var map__83370__$1 = ((((!((map__83370 == null)))?((((map__83370.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83370.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83370):map__83370);
var reconciler = cljs.core.get.call(null,map__83370__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__83370,map__83370__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("fulcro","server-error","fulcro/server-error",-1254037316),error);

var temp__4655__auto__ = fulcro.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__4655__auto__)){
var q = temp__4655__auto__;
fulcro.client.logging.warn.call(null,fulcro.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return fulcro.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__83370,map__83370__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
fulcro.client.impl.application.enqueue = (function fulcro$client$impl$application$enqueue(q,v){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_83381){
var state_val_83382 = (state_83381[(1)]);
if((state_val_83382 === (1))){
var state_83381__$1 = state_83381;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_83381__$1,(2),q,v);
} else {
if((state_val_83382 === (2))){
var inst_83379 = (state_83381[(2)]);
var state_83381__$1 = state_83381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83381__$1,inst_83379);
} else {
return null;
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____0 = (function (){
var statearr_83383 = [null,null,null,null,null,null,null];
(statearr_83383[(0)] = fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__);

(statearr_83383[(1)] = (1));

return statearr_83383;
});
var fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____1 = (function (state_83381){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_83381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e83384){if((e83384 instanceof Object)){
var ex__42019__auto__ = e83384;
var statearr_83385_83387 = state_83381;
(statearr_83385_83387[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_83381);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e83384;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83388 = state_83381;
state_83381 = G__83388;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__ = function(state_83381){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____1.call(this,state_83381);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____0;
fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_83386 = f__42037__auto__.call(null);
(statearr_83386[(6)] = c__42036__auto__);

return statearr_83386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
fulcro.client.impl.application.real_send = (function fulcro$client$impl$application$real_send(net,tx,on_done,on_error,on_load){
if(((!((net == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === net.fulcro$client$network$ProgressiveTransfer$)))?true:false):false)){
return fulcro.client.network.updating_send.call(null,net,fulcro.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error,on_load);
} else {
return fulcro.client.network.send.call(null,net,fulcro.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error);
}
});
/**
 * Split a tx that contains mutations. Returns a vector that contains at least one tx (the original).
 * 
 * Examples:
 * [(f) (g)] => [[(f) (g)]]
 * [(f) (g) (f) (k)] => [[(f) (g)] [(f) (k)]]
 * [(f) (g) (f) (k) (g)] => [[(f) (g)] [(f) (k) (g)]]
 * 
 */
fulcro.client.impl.application.split_mutations = (function fulcro$client$impl$application$split_mutations(tx){
if(!((cljs.core.vector_QMARK_.call(null,tx)) && (cljs.core.every_QMARK_.call(null,(function (t){
return (cljs.core.list_QMARK_.call(null,t)) && ((cljs.core.first.call(null,t) instanceof cljs.core.Symbol));
}),tx)))){
fulcro.client.logging.error.call(null,"INTERNAL ERROR: split-mutations was asked to split a tx that contained things other than mutations.",tx);

return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tx], null);
} else {
if(cljs.core.empty_QMARK_.call(null,tx)){
return cljs.core.PersistentVector.EMPTY;
} else {
var mutation_name = (function (m){
return cljs.core.first.call(null,m);
});
var map__83390 = cljs.core.reduce.call(null,((function (mutation_name){
return (function (p__83391,mutation){
var map__83392 = p__83391;
var map__83392__$1 = ((((!((map__83392 == null)))?((((map__83392.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83392.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83392):map__83392);
var seen = cljs.core.get.call(null,map__83392__$1,new cljs.core.Keyword(null,"seen","seen",-518999789));
var accumulator = cljs.core.get.call(null,map__83392__$1,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501));
var current_tx = cljs.core.get.call(null,map__83392__$1,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374));
if(cljs.core.contains_QMARK_.call(null,seen,mutation_name.call(null,mutation))){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),cljs.core.conj.call(null,accumulator,current_tx),new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [mutation], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.conj.call(null,seen,mutation_name.call(null,mutation)),new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),accumulator,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),cljs.core.conj.call(null,current_tx,mutation)], null);
}
});})(mutation_name))
,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),cljs.core.PersistentVector.EMPTY], null),tx);
var map__83390__$1 = ((((!((map__83390 == null)))?((((map__83390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83390.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83390):map__83390);
var accumulator = cljs.core.get.call(null,map__83390__$1,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501));
var current_tx = cljs.core.get.call(null,map__83390__$1,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374));
return cljs.core.conj.call(null,accumulator,current_tx);
}
}
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue. If duplicate mutation names
 * appear, then they will be separated into separate network requests.
 * 
 * NOTE: If the mutation in the tx has duplicates, then the same fallback will be used for the
 * resulting split tx. See `split-mutations` (which is used by this function to split dupes out of txes).
 */
fulcro.client.impl.application.enqueue_mutations = (function fulcro$client$impl$application$enqueue_mutations(p__83396,remote_tx_map,cb){
var map__83397 = p__83396;
var map__83397__$1 = ((((!((map__83397 == null)))?((((map__83397.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83397.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83397):map__83397);
var app = map__83397__$1;
var send_queues = cljs.core.get.call(null,map__83397__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var seq__83399 = cljs.core.seq.call(null,cljs.core.keys.call(null,remote_tx_map));
var chunk__83400 = null;
var count__83401 = (0);
var i__83402 = (0);
while(true){
if((i__83402 < count__83401)){
var remote = cljs.core._nth.call(null,chunk__83400,i__83402);
var queue_83411 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_83412 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_83413 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_83412);
var desired_remote_mutations_83414 = fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_83412);
var tx_list_83415 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_83414);
var has_mutations_QMARK__83416 = ((function (seq__83399,chunk__83400,count__83401,i__83402,queue_83411,full_remote_transaction_83412,fallback_83413,desired_remote_mutations_83414,tx_list_83415,remote,map__83397,map__83397__$1,app,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__83399,chunk__83400,count__83401,i__83402,queue_83411,full_remote_transaction_83412,fallback_83413,desired_remote_mutations_83414,tx_list_83415,remote,map__83397,map__83397__$1,app,send_queues))
;
var payload_83417 = ((function (seq__83399,chunk__83400,count__83401,i__83402,queue_83411,full_remote_transaction_83412,fallback_83413,desired_remote_mutations_83414,tx_list_83415,has_mutations_QMARK__83416,remote,map__83397,map__83397__$1,app,send_queues){
return (function (tx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),tx,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__83399,chunk__83400,count__83401,i__83402,queue_83411,full_remote_transaction_83412,fallback_83413,desired_remote_mutations_83414,tx_list_83415,has_mutations_QMARK__83416,remote,map__83397,map__83397__$1,app,send_queues){
return (function (p1__83395_SHARP_){
return fallback_83413.call(null,p1__83395_SHARP_);
});})(seq__83399,chunk__83400,count__83401,i__83402,queue_83411,full_remote_transaction_83412,fallback_83413,desired_remote_mutations_83414,tx_list_83415,has_mutations_QMARK__83416,remote,map__83397,map__83397__$1,app,send_queues))
], null);
});})(seq__83399,chunk__83400,count__83401,i__83402,queue_83411,full_remote_transaction_83412,fallback_83413,desired_remote_mutations_83414,tx_list_83415,has_mutations_QMARK__83416,remote,map__83397,map__83397__$1,app,send_queues))
;
var seq__83403_83418 = cljs.core.seq.call(null,tx_list_83415);
var chunk__83404_83419 = null;
var count__83405_83420 = (0);
var i__83406_83421 = (0);
while(true){
if((i__83406_83421 < count__83405_83420)){
var tx_83422 = cljs.core._nth.call(null,chunk__83404_83419,i__83406_83421);
if(cljs.core.truth_(has_mutations_QMARK__83416.call(null,tx_83422))){
fulcro.client.impl.application.enqueue.call(null,queue_83411,payload_83417.call(null,tx_83422));
} else {
}

var G__83424 = seq__83403_83418;
var G__83425 = chunk__83404_83419;
var G__83426 = count__83405_83420;
var G__83427 = (i__83406_83421 + (1));
seq__83403_83418 = G__83424;
chunk__83404_83419 = G__83425;
count__83405_83420 = G__83426;
i__83406_83421 = G__83427;
continue;
} else {
var temp__4657__auto___83429 = cljs.core.seq.call(null,seq__83403_83418);
if(temp__4657__auto___83429){
var seq__83403_83430__$1 = temp__4657__auto___83429;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83403_83430__$1)){
var c__28980__auto___83431 = cljs.core.chunk_first.call(null,seq__83403_83430__$1);
var G__83432 = cljs.core.chunk_rest.call(null,seq__83403_83430__$1);
var G__83433 = c__28980__auto___83431;
var G__83434 = cljs.core.count.call(null,c__28980__auto___83431);
var G__83435 = (0);
seq__83403_83418 = G__83432;
chunk__83404_83419 = G__83433;
count__83405_83420 = G__83434;
i__83406_83421 = G__83435;
continue;
} else {
var tx_83436 = cljs.core.first.call(null,seq__83403_83430__$1);
if(cljs.core.truth_(has_mutations_QMARK__83416.call(null,tx_83436))){
fulcro.client.impl.application.enqueue.call(null,queue_83411,payload_83417.call(null,tx_83436));
} else {
}

var G__83438 = cljs.core.next.call(null,seq__83403_83430__$1);
var G__83439 = null;
var G__83440 = (0);
var G__83441 = (0);
seq__83403_83418 = G__83438;
chunk__83404_83419 = G__83439;
count__83405_83420 = G__83440;
i__83406_83421 = G__83441;
continue;
}
} else {
}
}
break;
}

var G__83442 = seq__83399;
var G__83443 = chunk__83400;
var G__83444 = count__83401;
var G__83445 = (i__83402 + (1));
seq__83399 = G__83442;
chunk__83400 = G__83443;
count__83401 = G__83444;
i__83402 = G__83445;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__83399);
if(temp__4657__auto__){
var seq__83399__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83399__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__83399__$1);
var G__83446 = cljs.core.chunk_rest.call(null,seq__83399__$1);
var G__83447 = c__28980__auto__;
var G__83448 = cljs.core.count.call(null,c__28980__auto__);
var G__83449 = (0);
seq__83399 = G__83446;
chunk__83400 = G__83447;
count__83401 = G__83448;
i__83402 = G__83449;
continue;
} else {
var remote = cljs.core.first.call(null,seq__83399__$1);
var queue_83452 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_83453 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_83454 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_83453);
var desired_remote_mutations_83455 = fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_83453);
var tx_list_83456 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_83455);
var has_mutations_QMARK__83457 = ((function (seq__83399,chunk__83400,count__83401,i__83402,queue_83452,full_remote_transaction_83453,fallback_83454,desired_remote_mutations_83455,tx_list_83456,remote,seq__83399__$1,temp__4657__auto__,map__83397,map__83397__$1,app,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__83399,chunk__83400,count__83401,i__83402,queue_83452,full_remote_transaction_83453,fallback_83454,desired_remote_mutations_83455,tx_list_83456,remote,seq__83399__$1,temp__4657__auto__,map__83397,map__83397__$1,app,send_queues))
;
var payload_83458 = ((function (seq__83399,chunk__83400,count__83401,i__83402,queue_83452,full_remote_transaction_83453,fallback_83454,desired_remote_mutations_83455,tx_list_83456,has_mutations_QMARK__83457,remote,seq__83399__$1,temp__4657__auto__,map__83397,map__83397__$1,app,send_queues){
return (function (tx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),tx,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__83399,chunk__83400,count__83401,i__83402,queue_83452,full_remote_transaction_83453,fallback_83454,desired_remote_mutations_83455,tx_list_83456,has_mutations_QMARK__83457,remote,seq__83399__$1,temp__4657__auto__,map__83397,map__83397__$1,app,send_queues){
return (function (p1__83395_SHARP_){
return fallback_83454.call(null,p1__83395_SHARP_);
});})(seq__83399,chunk__83400,count__83401,i__83402,queue_83452,full_remote_transaction_83453,fallback_83454,desired_remote_mutations_83455,tx_list_83456,has_mutations_QMARK__83457,remote,seq__83399__$1,temp__4657__auto__,map__83397,map__83397__$1,app,send_queues))
], null);
});})(seq__83399,chunk__83400,count__83401,i__83402,queue_83452,full_remote_transaction_83453,fallback_83454,desired_remote_mutations_83455,tx_list_83456,has_mutations_QMARK__83457,remote,seq__83399__$1,temp__4657__auto__,map__83397,map__83397__$1,app,send_queues))
;
var seq__83407_83464 = cljs.core.seq.call(null,tx_list_83456);
var chunk__83408_83465 = null;
var count__83409_83466 = (0);
var i__83410_83467 = (0);
while(true){
if((i__83410_83467 < count__83409_83466)){
var tx_83468 = cljs.core._nth.call(null,chunk__83408_83465,i__83410_83467);
if(cljs.core.truth_(has_mutations_QMARK__83457.call(null,tx_83468))){
fulcro.client.impl.application.enqueue.call(null,queue_83452,payload_83458.call(null,tx_83468));
} else {
}

var G__83469 = seq__83407_83464;
var G__83470 = chunk__83408_83465;
var G__83471 = count__83409_83466;
var G__83472 = (i__83410_83467 + (1));
seq__83407_83464 = G__83469;
chunk__83408_83465 = G__83470;
count__83409_83466 = G__83471;
i__83410_83467 = G__83472;
continue;
} else {
var temp__4657__auto___83473__$1 = cljs.core.seq.call(null,seq__83407_83464);
if(temp__4657__auto___83473__$1){
var seq__83407_83474__$1 = temp__4657__auto___83473__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83407_83474__$1)){
var c__28980__auto___83475 = cljs.core.chunk_first.call(null,seq__83407_83474__$1);
var G__83476 = cljs.core.chunk_rest.call(null,seq__83407_83474__$1);
var G__83477 = c__28980__auto___83475;
var G__83478 = cljs.core.count.call(null,c__28980__auto___83475);
var G__83479 = (0);
seq__83407_83464 = G__83476;
chunk__83408_83465 = G__83477;
count__83409_83466 = G__83478;
i__83410_83467 = G__83479;
continue;
} else {
var tx_83480 = cljs.core.first.call(null,seq__83407_83474__$1);
if(cljs.core.truth_(has_mutations_QMARK__83457.call(null,tx_83480))){
fulcro.client.impl.application.enqueue.call(null,queue_83452,payload_83458.call(null,tx_83480));
} else {
}

var G__83481 = cljs.core.next.call(null,seq__83407_83474__$1);
var G__83483 = null;
var G__83484 = (0);
var G__83485 = (0);
seq__83407_83464 = G__83481;
chunk__83408_83465 = G__83483;
count__83409_83466 = G__83484;
i__83410_83467 = G__83485;
continue;
}
} else {
}
}
break;
}

var G__83486 = cljs.core.next.call(null,seq__83399__$1);
var G__83487 = null;
var G__83488 = (0);
var G__83489 = (0);
seq__83399 = G__83486;
chunk__83400 = G__83487;
count__83401 = G__83488;
i__83402 = G__83489;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
fulcro.client.impl.application.enqueue_reads = (function fulcro$client$impl$application$enqueue_reads(p__83492){
var map__83493 = p__83492;
var map__83493__$1 = ((((!((map__83493 == null)))?((((map__83493.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83493.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83493):map__83493);
var send_queues = cljs.core.get.call(null,map__83493__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var reconciler = cljs.core.get.call(null,map__83493__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__83493__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var seq__83495 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__83496 = null;
var count__83497 = (0);
var i__83498 = (0);
while(true){
if((i__83498 < count__83497)){
var remote = cljs.core._nth.call(null,chunk__83496,i__83498);
var queue_83528 = cljs.core.get.call(null,send_queues,remote);
var network_83529 = cljs.core.get.call(null,networking,remote);
var parallel_payload_83530 = fulcro.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__83499_83531 = cljs.core.seq.call(null,parallel_payload_83530);
var chunk__83500_83532 = null;
var count__83501_83533 = (0);
var i__83502_83534 = (0);
while(true){
if((i__83502_83534 < count__83501_83533)){
var map__83503_83535 = cljs.core._nth.call(null,chunk__83500_83532,i__83502_83534);
var map__83503_83536__$1 = ((((!((map__83503_83535 == null)))?((((map__83503_83535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83503_83535.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83503_83535):map__83503_83535);
var query_83537 = cljs.core.get.call(null,map__83503_83536__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_83538 = cljs.core.get.call(null,map__83503_83536__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_83539 = cljs.core.get.call(null,map__83503_83536__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_83540 = cljs.core.get.call(null,map__83503_83536__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__83541 = ((function (seq__83499_83531,chunk__83500_83532,count__83501_83533,i__83502_83534,seq__83495,chunk__83496,count__83497,i__83498,map__83503_83535,map__83503_83536__$1,query_83537,on_load_83538,on_error_83539,load_descriptors_83540,queue_83528,network_83529,parallel_payload_83530,remote,map__83493,map__83493__$1,send_queues,reconciler,networking){
return (function (p1__83490_SHARP_){
return on_load_83538.call(null,p1__83490_SHARP_,load_descriptors_83540);
});})(seq__83499_83531,chunk__83500_83532,count__83501_83533,i__83502_83534,seq__83495,chunk__83496,count__83497,i__83498,map__83503_83535,map__83503_83536__$1,query_83537,on_load_83538,on_error_83539,load_descriptors_83540,queue_83528,network_83529,parallel_payload_83530,remote,map__83493,map__83493__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__83542 = ((function (seq__83499_83531,chunk__83500_83532,count__83501_83533,i__83502_83534,seq__83495,chunk__83496,count__83497,i__83498,on_load_SINGLEQUOTE__83541,map__83503_83535,map__83503_83536__$1,query_83537,on_load_83538,on_error_83539,load_descriptors_83540,queue_83528,network_83529,parallel_payload_83530,remote,map__83493,map__83493__$1,send_queues,reconciler,networking){
return (function (p1__83491_SHARP_){
return on_error_83539.call(null,p1__83491_SHARP_,load_descriptors_83540);
});})(seq__83499_83531,chunk__83500_83532,count__83501_83533,i__83502_83534,seq__83495,chunk__83496,count__83497,i__83498,on_load_SINGLEQUOTE__83541,map__83503_83535,map__83503_83536__$1,query_83537,on_load_83538,on_error_83539,load_descriptors_83540,queue_83528,network_83529,parallel_payload_83530,remote,map__83493,map__83493__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_83529,query_83537,on_load_SINGLEQUOTE__83541,on_error_SINGLEQUOTE__83542,null);

var G__83544 = seq__83499_83531;
var G__83545 = chunk__83500_83532;
var G__83546 = count__83501_83533;
var G__83547 = (i__83502_83534 + (1));
seq__83499_83531 = G__83544;
chunk__83500_83532 = G__83545;
count__83501_83533 = G__83546;
i__83502_83534 = G__83547;
continue;
} else {
var temp__4657__auto___83551 = cljs.core.seq.call(null,seq__83499_83531);
if(temp__4657__auto___83551){
var seq__83499_83552__$1 = temp__4657__auto___83551;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83499_83552__$1)){
var c__28980__auto___83553 = cljs.core.chunk_first.call(null,seq__83499_83552__$1);
var G__83554 = cljs.core.chunk_rest.call(null,seq__83499_83552__$1);
var G__83555 = c__28980__auto___83553;
var G__83556 = cljs.core.count.call(null,c__28980__auto___83553);
var G__83557 = (0);
seq__83499_83531 = G__83554;
chunk__83500_83532 = G__83555;
count__83501_83533 = G__83556;
i__83502_83534 = G__83557;
continue;
} else {
var map__83505_83558 = cljs.core.first.call(null,seq__83499_83552__$1);
var map__83505_83559__$1 = ((((!((map__83505_83558 == null)))?((((map__83505_83558.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83505_83558.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83505_83558):map__83505_83558);
var query_83560 = cljs.core.get.call(null,map__83505_83559__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_83561 = cljs.core.get.call(null,map__83505_83559__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_83562 = cljs.core.get.call(null,map__83505_83559__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_83563 = cljs.core.get.call(null,map__83505_83559__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__83564 = ((function (seq__83499_83531,chunk__83500_83532,count__83501_83533,i__83502_83534,seq__83495,chunk__83496,count__83497,i__83498,map__83505_83558,map__83505_83559__$1,query_83560,on_load_83561,on_error_83562,load_descriptors_83563,seq__83499_83552__$1,temp__4657__auto___83551,queue_83528,network_83529,parallel_payload_83530,remote,map__83493,map__83493__$1,send_queues,reconciler,networking){
return (function (p1__83490_SHARP_){
return on_load_83561.call(null,p1__83490_SHARP_,load_descriptors_83563);
});})(seq__83499_83531,chunk__83500_83532,count__83501_83533,i__83502_83534,seq__83495,chunk__83496,count__83497,i__83498,map__83505_83558,map__83505_83559__$1,query_83560,on_load_83561,on_error_83562,load_descriptors_83563,seq__83499_83552__$1,temp__4657__auto___83551,queue_83528,network_83529,parallel_payload_83530,remote,map__83493,map__83493__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__83565 = ((function (seq__83499_83531,chunk__83500_83532,count__83501_83533,i__83502_83534,seq__83495,chunk__83496,count__83497,i__83498,on_load_SINGLEQUOTE__83564,map__83505_83558,map__83505_83559__$1,query_83560,on_load_83561,on_error_83562,load_descriptors_83563,seq__83499_83552__$1,temp__4657__auto___83551,queue_83528,network_83529,parallel_payload_83530,remote,map__83493,map__83493__$1,send_queues,reconciler,networking){
return (function (p1__83491_SHARP_){
return on_error_83562.call(null,p1__83491_SHARP_,load_descriptors_83563);
});})(seq__83499_83531,chunk__83500_83532,count__83501_83533,i__83502_83534,seq__83495,chunk__83496,count__83497,i__83498,on_load_SINGLEQUOTE__83564,map__83505_83558,map__83505_83559__$1,query_83560,on_load_83561,on_error_83562,load_descriptors_83563,seq__83499_83552__$1,temp__4657__auto___83551,queue_83528,network_83529,parallel_payload_83530,remote,map__83493,map__83493__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_83529,query_83560,on_load_SINGLEQUOTE__83564,on_error_SINGLEQUOTE__83565,null);

var G__83570 = cljs.core.next.call(null,seq__83499_83552__$1);
var G__83571 = null;
var G__83572 = (0);
var G__83573 = (0);
seq__83499_83531 = G__83570;
chunk__83500_83532 = G__83571;
count__83501_83533 = G__83572;
i__83502_83534 = G__83573;
continue;
}
} else {
}
}
break;
}

var fetch_payload_83574 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_83574)){
fulcro.client.impl.application.enqueue.call(null,queue_83528,cljs.core.assoc.call(null,fetch_payload_83574,new cljs.core.Keyword(null,"networking","networking",586110628),network_83529));

var G__83575 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_83574 = G__83575;
continue;
} else {
}
break;
}

var G__83576 = seq__83495;
var G__83577 = chunk__83496;
var G__83578 = count__83497;
var G__83579 = (i__83498 + (1));
seq__83495 = G__83576;
chunk__83496 = G__83577;
count__83497 = G__83578;
i__83498 = G__83579;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__83495);
if(temp__4657__auto__){
var seq__83495__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83495__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__83495__$1);
var G__83580 = cljs.core.chunk_rest.call(null,seq__83495__$1);
var G__83581 = c__28980__auto__;
var G__83582 = cljs.core.count.call(null,c__28980__auto__);
var G__83583 = (0);
seq__83495 = G__83580;
chunk__83496 = G__83581;
count__83497 = G__83582;
i__83498 = G__83583;
continue;
} else {
var remote = cljs.core.first.call(null,seq__83495__$1);
var queue_83584 = cljs.core.get.call(null,send_queues,remote);
var network_83585 = cljs.core.get.call(null,networking,remote);
var parallel_payload_83586 = fulcro.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__83511_83594 = cljs.core.seq.call(null,parallel_payload_83586);
var chunk__83512_83595 = null;
var count__83513_83596 = (0);
var i__83514_83597 = (0);
while(true){
if((i__83514_83597 < count__83513_83596)){
var map__83515_83598 = cljs.core._nth.call(null,chunk__83512_83595,i__83514_83597);
var map__83515_83599__$1 = ((((!((map__83515_83598 == null)))?((((map__83515_83598.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83515_83598.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83515_83598):map__83515_83598);
var query_83600 = cljs.core.get.call(null,map__83515_83599__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_83601 = cljs.core.get.call(null,map__83515_83599__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_83602 = cljs.core.get.call(null,map__83515_83599__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_83603 = cljs.core.get.call(null,map__83515_83599__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__83604 = ((function (seq__83511_83594,chunk__83512_83595,count__83513_83596,i__83514_83597,seq__83495,chunk__83496,count__83497,i__83498,map__83515_83598,map__83515_83599__$1,query_83600,on_load_83601,on_error_83602,load_descriptors_83603,queue_83584,network_83585,parallel_payload_83586,remote,seq__83495__$1,temp__4657__auto__,map__83493,map__83493__$1,send_queues,reconciler,networking){
return (function (p1__83490_SHARP_){
return on_load_83601.call(null,p1__83490_SHARP_,load_descriptors_83603);
});})(seq__83511_83594,chunk__83512_83595,count__83513_83596,i__83514_83597,seq__83495,chunk__83496,count__83497,i__83498,map__83515_83598,map__83515_83599__$1,query_83600,on_load_83601,on_error_83602,load_descriptors_83603,queue_83584,network_83585,parallel_payload_83586,remote,seq__83495__$1,temp__4657__auto__,map__83493,map__83493__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__83605 = ((function (seq__83511_83594,chunk__83512_83595,count__83513_83596,i__83514_83597,seq__83495,chunk__83496,count__83497,i__83498,on_load_SINGLEQUOTE__83604,map__83515_83598,map__83515_83599__$1,query_83600,on_load_83601,on_error_83602,load_descriptors_83603,queue_83584,network_83585,parallel_payload_83586,remote,seq__83495__$1,temp__4657__auto__,map__83493,map__83493__$1,send_queues,reconciler,networking){
return (function (p1__83491_SHARP_){
return on_error_83602.call(null,p1__83491_SHARP_,load_descriptors_83603);
});})(seq__83511_83594,chunk__83512_83595,count__83513_83596,i__83514_83597,seq__83495,chunk__83496,count__83497,i__83498,on_load_SINGLEQUOTE__83604,map__83515_83598,map__83515_83599__$1,query_83600,on_load_83601,on_error_83602,load_descriptors_83603,queue_83584,network_83585,parallel_payload_83586,remote,seq__83495__$1,temp__4657__auto__,map__83493,map__83493__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_83585,query_83600,on_load_SINGLEQUOTE__83604,on_error_SINGLEQUOTE__83605,null);

var G__83606 = seq__83511_83594;
var G__83607 = chunk__83512_83595;
var G__83608 = count__83513_83596;
var G__83609 = (i__83514_83597 + (1));
seq__83511_83594 = G__83606;
chunk__83512_83595 = G__83607;
count__83513_83596 = G__83608;
i__83514_83597 = G__83609;
continue;
} else {
var temp__4657__auto___83612__$1 = cljs.core.seq.call(null,seq__83511_83594);
if(temp__4657__auto___83612__$1){
var seq__83511_83613__$1 = temp__4657__auto___83612__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83511_83613__$1)){
var c__28980__auto___83614 = cljs.core.chunk_first.call(null,seq__83511_83613__$1);
var G__83615 = cljs.core.chunk_rest.call(null,seq__83511_83613__$1);
var G__83616 = c__28980__auto___83614;
var G__83617 = cljs.core.count.call(null,c__28980__auto___83614);
var G__83618 = (0);
seq__83511_83594 = G__83615;
chunk__83512_83595 = G__83616;
count__83513_83596 = G__83617;
i__83514_83597 = G__83618;
continue;
} else {
var map__83517_83619 = cljs.core.first.call(null,seq__83511_83613__$1);
var map__83517_83620__$1 = ((((!((map__83517_83619 == null)))?((((map__83517_83619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83517_83619.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83517_83619):map__83517_83619);
var query_83621 = cljs.core.get.call(null,map__83517_83620__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_83622 = cljs.core.get.call(null,map__83517_83620__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_83623 = cljs.core.get.call(null,map__83517_83620__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_83624 = cljs.core.get.call(null,map__83517_83620__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__83627 = ((function (seq__83511_83594,chunk__83512_83595,count__83513_83596,i__83514_83597,seq__83495,chunk__83496,count__83497,i__83498,map__83517_83619,map__83517_83620__$1,query_83621,on_load_83622,on_error_83623,load_descriptors_83624,seq__83511_83613__$1,temp__4657__auto___83612__$1,queue_83584,network_83585,parallel_payload_83586,remote,seq__83495__$1,temp__4657__auto__,map__83493,map__83493__$1,send_queues,reconciler,networking){
return (function (p1__83490_SHARP_){
return on_load_83622.call(null,p1__83490_SHARP_,load_descriptors_83624);
});})(seq__83511_83594,chunk__83512_83595,count__83513_83596,i__83514_83597,seq__83495,chunk__83496,count__83497,i__83498,map__83517_83619,map__83517_83620__$1,query_83621,on_load_83622,on_error_83623,load_descriptors_83624,seq__83511_83613__$1,temp__4657__auto___83612__$1,queue_83584,network_83585,parallel_payload_83586,remote,seq__83495__$1,temp__4657__auto__,map__83493,map__83493__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__83628 = ((function (seq__83511_83594,chunk__83512_83595,count__83513_83596,i__83514_83597,seq__83495,chunk__83496,count__83497,i__83498,on_load_SINGLEQUOTE__83627,map__83517_83619,map__83517_83620__$1,query_83621,on_load_83622,on_error_83623,load_descriptors_83624,seq__83511_83613__$1,temp__4657__auto___83612__$1,queue_83584,network_83585,parallel_payload_83586,remote,seq__83495__$1,temp__4657__auto__,map__83493,map__83493__$1,send_queues,reconciler,networking){
return (function (p1__83491_SHARP_){
return on_error_83623.call(null,p1__83491_SHARP_,load_descriptors_83624);
});})(seq__83511_83594,chunk__83512_83595,count__83513_83596,i__83514_83597,seq__83495,chunk__83496,count__83497,i__83498,on_load_SINGLEQUOTE__83627,map__83517_83619,map__83517_83620__$1,query_83621,on_load_83622,on_error_83623,load_descriptors_83624,seq__83511_83613__$1,temp__4657__auto___83612__$1,queue_83584,network_83585,parallel_payload_83586,remote,seq__83495__$1,temp__4657__auto__,map__83493,map__83493__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_83585,query_83621,on_load_SINGLEQUOTE__83627,on_error_SINGLEQUOTE__83628,null);

var G__83633 = cljs.core.next.call(null,seq__83511_83613__$1);
var G__83634 = null;
var G__83635 = (0);
var G__83636 = (0);
seq__83511_83594 = G__83633;
chunk__83512_83595 = G__83634;
count__83513_83596 = G__83635;
i__83514_83597 = G__83636;
continue;
}
} else {
}
}
break;
}

var fetch_payload_83638 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_83638)){
fulcro.client.impl.application.enqueue.call(null,queue_83584,cljs.core.assoc.call(null,fetch_payload_83638,new cljs.core.Keyword(null,"networking","networking",586110628),network_83585));

var G__83639 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_83638 = G__83639;
continue;
} else {
}
break;
}

var G__83640 = cljs.core.next.call(null,seq__83495__$1);
var G__83641 = null;
var G__83642 = (0);
var G__83643 = (0);
seq__83495 = G__83640;
chunk__83496 = G__83641;
count__83497 = G__83642;
i__83498 = G__83643;
continue;
}
} else {
return null;
}
}
break;
}
});
fulcro.client.impl.application.detect_errant_remotes = (function fulcro$client$impl$application$detect_errant_remotes(p__83644){
var map__83645 = p__83644;
var map__83645__$1 = ((((!((map__83645 == null)))?((((map__83645.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83645.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83645):map__83645);
var app = map__83645__$1;
var reconciler = cljs.core.get.call(null,map__83645__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var send_queues = cljs.core.get.call(null,map__83645__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var state = om.next.app_state.call(null,reconciler);
var all_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var item_remotes = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.data_remote,all_items));
var all_remotes = cljs.core.set.call(null,cljs.core.keys.call(null,send_queues));
var invalid_remotes = clojure.set.difference.call(null,item_remotes,all_remotes);
if(cljs.core.truth_(cljs.core.not_empty.call(null,invalid_remotes))){
return fulcro.client.logging.error.call(null,["Use of invalid remote(s) detected! ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(invalid_remotes)].join(''));
} else {
return null;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
fulcro.client.impl.application.server_send = (function fulcro$client$impl$application$server_send(app,remote_tx_map,cb){
fulcro.client.impl.application.detect_errant_remotes.call(null,app);

fulcro.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return fulcro.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Sends a network payload. There are two kinds of payloads in Fulcro. The first is
 *   for reads, which are tracked by load descriptors in the app state. These load descriptors
 *   tell the plumbing how to handle the response, and expect to only be merged in once. Mutations
 *   do not have a payload, and can technically received progress updates from the network. The built-in
 *   networking does not (currently) give progress events, but plugin networking can. It is currently not
 *   supported to give an update on a load, so this function is careful to detect that a payload is a send
 *   and turns all but the last update into a no-op. The send-complete function comes from the
 *   network sequential processing loop, and when called unblocks the network processing to allow the
 *   next request to go. Be very careful with this code, as bugs will cause applications to stop responding
 *   to remote requests.
 */
fulcro.client.impl.application.send_payload = (function fulcro$client$impl$application$send_payload(network,payload,send_complete){
var map__83652 = payload;
var map__83652__$1 = ((((!((map__83652 == null)))?((((map__83652.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83652.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83652):map__83652);
var query = cljs.core.get.call(null,map__83652__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load = cljs.core.get.call(null,map__83652__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error = cljs.core.get.call(null,map__83652__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors = cljs.core.get.call(null,map__83652__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var merge_data = (cljs.core.truth_(load_descriptors)?((function (map__83652,map__83652__$1,query,on_load,on_error,load_descriptors){
return (function (p1__83648_SHARP_){
return on_load.call(null,p1__83648_SHARP_,load_descriptors);
});})(map__83652,map__83652__$1,query,on_load,on_error,load_descriptors))
:on_load);
var on_update = (cljs.core.truth_(load_descriptors)?cljs.core.identity:merge_data);
var on_error__$1 = (cljs.core.truth_(load_descriptors)?((function (map__83652,map__83652__$1,query,on_load,on_error,load_descriptors,merge_data,on_update){
return (function (p1__83650_SHARP_){
return on_error.call(null,p1__83650_SHARP_,load_descriptors);
});})(map__83652,map__83652__$1,query,on_load,on_error,load_descriptors,merge_data,on_update))
:on_error);
var on_error__$2 = cljs.core.comp.call(null,send_complete,on_error__$1);
var on_done = cljs.core.comp.call(null,send_complete,merge_data);
return fulcro.client.impl.application.real_send.call(null,network,query,on_done,on_error__$2,on_update);
});
fulcro.client.impl.application.is_sequential_QMARK_ = (function fulcro$client$impl$application$is_sequential_QMARK_(network){
if(((!((network == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === network.fulcro$client$network$NetworkBehavior$)))?true:false):false)){
return fulcro.client.network.serialize_requests_QMARK_.call(null,network);
} else {
return true;
}
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
fulcro.client.impl.application.start_network_sequential_processing = (function fulcro$client$impl$application$start_network_sequential_processing(p__83663){
var map__83664 = p__83663;
var map__83664__$1 = ((((!((map__83664 == null)))?((((map__83664.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83664.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83664):map__83664);
var networking = cljs.core.get.call(null,map__83664__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var send_queues = cljs.core.get.call(null,map__83664__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var response_channels = cljs.core.get.call(null,map__83664__$1,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128));
var seq__83666 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__83667 = null;
var count__83668 = (0);
var i__83669 = (0);
while(true){
if((i__83669 < count__83668)){
var remote = cljs.core._nth.call(null,chunk__83667,i__83669);
var queue_83759 = cljs.core.get.call(null,send_queues,remote);
var network_83760 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__83761 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_83760);
var response_channel_83762 = cljs.core.get.call(null,response_channels,remote);
var send_complete_83763 = (cljs.core.truth_(sequential_QMARK__83761)?((function (seq__83666,chunk__83667,count__83668,i__83669,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,remote,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto__,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,remote,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto__,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,remote,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (state_83673){
var state_val_83674 = (state_83673[(1)]);
if((state_val_83674 === (1))){
var state_83673__$1 = state_83673;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_83673__$1,(2),response_channel_83762,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_83674 === (2))){
var inst_83671 = (state_83673[(2)]);
var state_83673__$1 = state_83673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83673__$1,inst_83671);
} else {
return null;
}
}
});})(seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto__,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,remote,map__83664,map__83664__$1,networking,send_queues,response_channels))
;
return ((function (seq__83666,chunk__83667,count__83668,i__83669,switch__42015__auto__,c__42036__auto__,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,remote,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0 = (function (){
var statearr_83675 = [null,null,null,null,null,null,null];
(statearr_83675[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__);

(statearr_83675[(1)] = (1));

return statearr_83675;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1 = (function (state_83673){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_83673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e83676){if((e83676 instanceof Object)){
var ex__42019__auto__ = e83676;
var statearr_83677_83764 = state_83673;
(statearr_83677_83764[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_83673);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e83676;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83765 = state_83673;
state_83673 = G__83765;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = function(state_83673){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1.call(this,state_83673);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__;
})()
;})(seq__83666,chunk__83667,count__83668,i__83669,switch__42015__auto__,c__42036__auto__,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,remote,map__83664,map__83664__$1,networking,send_queues,response_channels))
})();
var state__42038__auto__ = (function (){var statearr_83678 = f__42037__auto__.call(null);
(statearr_83678[(6)] = c__42036__auto__);

return statearr_83678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto__,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,remote,map__83664,map__83664__$1,networking,send_queues,response_channels))
);

return c__42036__auto__;
});})(seq__83666,chunk__83667,count__83668,i__83669,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,remote,map__83664,map__83664__$1,networking,send_queues,response_channels))
:cljs.core.identity);
var c__42036__auto___83766 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto___83766,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,send_complete_83763,remote,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto___83766,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,send_complete_83763,remote,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (state_83696){
var state_val_83697 = (state_83696[(1)]);
if((state_val_83697 === (1))){
var state_83696__$1 = state_83696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83696__$1,(2),queue_83759);
} else {
if((state_val_83697 === (2))){
var inst_83680 = (state_83696[(2)]);
var inst_83681 = inst_83680;
var state_83696__$1 = (function (){var statearr_83698 = state_83696;
(statearr_83698[(7)] = inst_83681);

return statearr_83698;
})();
var statearr_83699_83767 = state_83696__$1;
(statearr_83699_83767[(2)] = null);

(statearr_83699_83767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83697 === (3))){
var inst_83681 = (state_83696[(7)]);
var inst_83683 = fulcro.client.impl.application.send_payload.call(null,network_83760,inst_83681,send_complete_83763);
var state_83696__$1 = (function (){var statearr_83703 = state_83696;
(statearr_83703[(8)] = inst_83683);

return statearr_83703;
})();
if(cljs.core.truth_(sequential_QMARK__83761)){
var statearr_83704_83768 = state_83696__$1;
(statearr_83704_83768[(1)] = (5));

} else {
var statearr_83705_83769 = state_83696__$1;
(statearr_83705_83769[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83697 === (4))){
var inst_83694 = (state_83696[(2)]);
var state_83696__$1 = state_83696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83696__$1,inst_83694);
} else {
if((state_val_83697 === (5))){
var state_83696__$1 = state_83696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83696__$1,(8),response_channel_83762);
} else {
if((state_val_83697 === (6))){
var state_83696__$1 = state_83696;
var statearr_83708_83770 = state_83696__$1;
(statearr_83708_83770[(2)] = null);

(statearr_83708_83770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83697 === (7))){
var inst_83689 = (state_83696[(2)]);
var state_83696__$1 = (function (){var statearr_83709 = state_83696;
(statearr_83709[(9)] = inst_83689);

return statearr_83709;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83696__$1,(9),queue_83759);
} else {
if((state_val_83697 === (8))){
var inst_83686 = (state_83696[(2)]);
var state_83696__$1 = state_83696;
var statearr_83710_83771 = state_83696__$1;
(statearr_83710_83771[(2)] = inst_83686);

(statearr_83710_83771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83697 === (9))){
var inst_83691 = (state_83696[(2)]);
var inst_83681 = inst_83691;
var state_83696__$1 = (function (){var statearr_83711 = state_83696;
(statearr_83711[(7)] = inst_83681);

return statearr_83711;
})();
var statearr_83712_83772 = state_83696__$1;
(statearr_83712_83772[(2)] = null);

(statearr_83712_83772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto___83766,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,send_complete_83763,remote,map__83664,map__83664__$1,networking,send_queues,response_channels))
;
return ((function (seq__83666,chunk__83667,count__83668,i__83669,switch__42015__auto__,c__42036__auto___83766,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,send_complete_83763,remote,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0 = (function (){
var statearr_83713 = [null,null,null,null,null,null,null,null,null,null];
(statearr_83713[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__);

(statearr_83713[(1)] = (1));

return statearr_83713;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1 = (function (state_83696){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_83696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e83714){if((e83714 instanceof Object)){
var ex__42019__auto__ = e83714;
var statearr_83715_83773 = state_83696;
(statearr_83715_83773[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_83696);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e83714;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83775 = state_83696;
state_83696 = G__83775;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = function(state_83696){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1.call(this,state_83696);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__;
})()
;})(seq__83666,chunk__83667,count__83668,i__83669,switch__42015__auto__,c__42036__auto___83766,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,send_complete_83763,remote,map__83664,map__83664__$1,networking,send_queues,response_channels))
})();
var state__42038__auto__ = (function (){var statearr_83716 = f__42037__auto__.call(null);
(statearr_83716[(6)] = c__42036__auto___83766);

return statearr_83716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto___83766,queue_83759,network_83760,sequential_QMARK__83761,response_channel_83762,send_complete_83763,remote,map__83664,map__83664__$1,networking,send_queues,response_channels))
);


var G__83776 = seq__83666;
var G__83777 = chunk__83667;
var G__83778 = count__83668;
var G__83779 = (i__83669 + (1));
seq__83666 = G__83776;
chunk__83667 = G__83777;
count__83668 = G__83778;
i__83669 = G__83779;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__83666);
if(temp__4657__auto__){
var seq__83666__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83666__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__83666__$1);
var G__83783 = cljs.core.chunk_rest.call(null,seq__83666__$1);
var G__83784 = c__28980__auto__;
var G__83785 = cljs.core.count.call(null,c__28980__auto__);
var G__83786 = (0);
seq__83666 = G__83783;
chunk__83667 = G__83784;
count__83668 = G__83785;
i__83669 = G__83786;
continue;
} else {
var remote = cljs.core.first.call(null,seq__83666__$1);
var queue_83787 = cljs.core.get.call(null,send_queues,remote);
var network_83788 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__83789 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_83788);
var response_channel_83790 = cljs.core.get.call(null,response_channels,remote);
var send_complete_83791 = (cljs.core.truth_(sequential_QMARK__83789)?((function (seq__83666,chunk__83667,count__83668,i__83669,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto__,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto__,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (state_83720){
var state_val_83721 = (state_83720[(1)]);
if((state_val_83721 === (1))){
var state_83720__$1 = state_83720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_83720__$1,(2),response_channel_83790,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_83721 === (2))){
var inst_83718 = (state_83720[(2)]);
var state_83720__$1 = state_83720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83720__$1,inst_83718);
} else {
return null;
}
}
});})(seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto__,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels))
;
return ((function (seq__83666,chunk__83667,count__83668,i__83669,switch__42015__auto__,c__42036__auto__,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0 = (function (){
var statearr_83722 = [null,null,null,null,null,null,null];
(statearr_83722[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__);

(statearr_83722[(1)] = (1));

return statearr_83722;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1 = (function (state_83720){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_83720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e83723){if((e83723 instanceof Object)){
var ex__42019__auto__ = e83723;
var statearr_83724_83798 = state_83720;
(statearr_83724_83798[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_83720);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e83723;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83799 = state_83720;
state_83720 = G__83799;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = function(state_83720){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1.call(this,state_83720);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__;
})()
;})(seq__83666,chunk__83667,count__83668,i__83669,switch__42015__auto__,c__42036__auto__,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels))
})();
var state__42038__auto__ = (function (){var statearr_83725 = f__42037__auto__.call(null);
(statearr_83725[(6)] = c__42036__auto__);

return statearr_83725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto__,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels))
);

return c__42036__auto__;
});})(seq__83666,chunk__83667,count__83668,i__83669,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels))
:cljs.core.identity);
var c__42036__auto___83805 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto___83805,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,send_complete_83791,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto___83805,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,send_complete_83791,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function (state_83743){
var state_val_83744 = (state_83743[(1)]);
if((state_val_83744 === (1))){
var state_83743__$1 = state_83743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83743__$1,(2),queue_83787);
} else {
if((state_val_83744 === (2))){
var inst_83727 = (state_83743[(2)]);
var inst_83728 = inst_83727;
var state_83743__$1 = (function (){var statearr_83745 = state_83743;
(statearr_83745[(7)] = inst_83728);

return statearr_83745;
})();
var statearr_83746_83809 = state_83743__$1;
(statearr_83746_83809[(2)] = null);

(statearr_83746_83809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83744 === (3))){
var inst_83728 = (state_83743[(7)]);
var inst_83730 = fulcro.client.impl.application.send_payload.call(null,network_83788,inst_83728,send_complete_83791);
var state_83743__$1 = (function (){var statearr_83747 = state_83743;
(statearr_83747[(8)] = inst_83730);

return statearr_83747;
})();
if(cljs.core.truth_(sequential_QMARK__83789)){
var statearr_83748_83810 = state_83743__$1;
(statearr_83748_83810[(1)] = (5));

} else {
var statearr_83749_83811 = state_83743__$1;
(statearr_83749_83811[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83744 === (4))){
var inst_83741 = (state_83743[(2)]);
var state_83743__$1 = state_83743;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83743__$1,inst_83741);
} else {
if((state_val_83744 === (5))){
var state_83743__$1 = state_83743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83743__$1,(8),response_channel_83790);
} else {
if((state_val_83744 === (6))){
var state_83743__$1 = state_83743;
var statearr_83750_83812 = state_83743__$1;
(statearr_83750_83812[(2)] = null);

(statearr_83750_83812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83744 === (7))){
var inst_83736 = (state_83743[(2)]);
var state_83743__$1 = (function (){var statearr_83751 = state_83743;
(statearr_83751[(9)] = inst_83736);

return statearr_83751;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83743__$1,(9),queue_83787);
} else {
if((state_val_83744 === (8))){
var inst_83733 = (state_83743[(2)]);
var state_83743__$1 = state_83743;
var statearr_83752_83813 = state_83743__$1;
(statearr_83752_83813[(2)] = inst_83733);

(statearr_83752_83813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83744 === (9))){
var inst_83738 = (state_83743[(2)]);
var inst_83728 = inst_83738;
var state_83743__$1 = (function (){var statearr_83753 = state_83743;
(statearr_83753[(7)] = inst_83728);

return statearr_83753;
})();
var statearr_83754_83814 = state_83743__$1;
(statearr_83754_83814[(2)] = null);

(statearr_83754_83814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto___83805,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,send_complete_83791,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels))
;
return ((function (seq__83666,chunk__83667,count__83668,i__83669,switch__42015__auto__,c__42036__auto___83805,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,send_complete_83791,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0 = (function (){
var statearr_83755 = [null,null,null,null,null,null,null,null,null,null];
(statearr_83755[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__);

(statearr_83755[(1)] = (1));

return statearr_83755;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1 = (function (state_83743){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_83743);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e83756){if((e83756 instanceof Object)){
var ex__42019__auto__ = e83756;
var statearr_83757_83815 = state_83743;
(statearr_83757_83815[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_83743);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e83756;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83816 = state_83743;
state_83743 = G__83816;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = function(state_83743){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1.call(this,state_83743);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__;
})()
;})(seq__83666,chunk__83667,count__83668,i__83669,switch__42015__auto__,c__42036__auto___83805,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,send_complete_83791,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels))
})();
var state__42038__auto__ = (function (){var statearr_83758 = f__42037__auto__.call(null);
(statearr_83758[(6)] = c__42036__auto___83805);

return statearr_83758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(seq__83666,chunk__83667,count__83668,i__83669,c__42036__auto___83805,queue_83787,network_83788,sequential_QMARK__83789,response_channel_83790,send_complete_83791,remote,seq__83666__$1,temp__4657__auto__,map__83664,map__83664__$1,networking,send_queues,response_channels))
);


var G__83817 = cljs.core.next.call(null,seq__83666__$1);
var G__83818 = null;
var G__83819 = (0);
var G__83820 = (0);
seq__83666 = G__83817;
chunk__83667 = G__83818;
count__83668 = G__83819;
i__83669 = G__83820;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Configure a re-render when the locale changes and also when the translations arrive from a module load.
 * During startup this function will be called once for each reconciler that is running on a page.
 */
fulcro.client.impl.application.initialize_internationalization = (function fulcro$client$impl$application$initialize_internationalization(reconciler){
var re_render = (function fulcro$client$impl$application$initialize_internationalization_$_re_render(k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
fulcro.client.logging.debug.call(null,"Forcing a UI refresh on locale change.");

return fulcro.client.util.force_render.call(null,reconciler);
} else {
return null;
}
});
cljs.core.remove_watch.call(null,fulcro.i18n._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

cljs.core.add_watch.call(null,fulcro.i18n._STAR_loaded_translations_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),re_render);

return cljs.core.add_watch.call(null,fulcro.i18n._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),re_render);
});
/**
 * Remove not-found keys from m (non-recursive)
 */
fulcro.client.impl.application.sweep_one = (function fulcro$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__83821){
var vec__83822 = p__83821;
var k = cljs.core.nth.call(null,vec__83822,(0),null);
var v = cljs.core.nth.call(null,vec__83822,(1),null);
if((cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),k)) || (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),v))){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,fulcro.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
fulcro.client.impl.application.sweep = (function fulcro$client$impl$application$sweep(m){
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return fulcro.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__83825){
var vec__83826 = p__83825;
var k = cljs.core.nth.call(null,vec__83826,(0),null);
var v = cljs.core.nth.call(null,vec__83826,(1),null);
if((cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),k)) || (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),v))){
return acc;
} else {
if((om.util.ident_QMARK_.call(null,v)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),cljs.core.second.call(null,v)))){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,fulcro.client.impl.application.sweep.call(null,v));

}
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,fulcro.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
fulcro.client.impl.application.sweep_merge = (function fulcro$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__83829){
var vec__83830 = p__83829;
var key = cljs.core.nth.call(null,vec__83830,(0),null);
var new_value = cljs.core.nth.call(null,vec__83830,(1),null);
var existing_value = cljs.core.get.call(null,acc,key);
if(cljs.core._EQ_.call(null,key,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951))){
return acc;
} else {
if(cljs.core._EQ_.call(null,new_value,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951))){
return cljs.core.dissoc.call(null,acc,key);
} else {
if((om.util.ident_QMARK_.call(null,new_value)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),cljs.core.second.call(null,new_value)))){
return acc;
} else {
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.leaf_QMARK_.call(null,new_value))){
return cljs.core.assoc.call(null,acc,key,fulcro.client.impl.application.sweep_one.call(null,new_value));
} else {
if((cljs.core.map_QMARK_.call(null,existing_value)) && (cljs.core.map_QMARK_.call(null,new_value))){
return cljs.core.update.call(null,acc,key,fulcro.client.impl.application.sweep_merge,new_value);
} else {
return cljs.core.assoc.call(null,acc,key,fulcro.client.impl.application.sweep.call(null,new_value));

}
}
}
}
}
}),target,source);
});
fulcro.client.impl.application.merge_handler = (function fulcro$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__83833){
var vec__83834 = p__83833;
var k = cljs.core.nth.call(null,vec__83834,(0),null);
var _ = cljs.core.nth.call(null,vec__83834,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = fulcro.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__83837){
var vec__83838 = p__83837;
var k = cljs.core.nth.call(null,vec__83838,(0),null);
var v = cljs.core.nth.call(null,vec__83838,(1),null);
if(cljs.core.truth_((function (){var and__28129__auto__ = mutation_merge;
if(cljs.core.truth_(and__28129__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__28129__auto__;
}
})())){
var temp__4655__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__4655__auto__)){
var updated_state = temp__4655__auto__;
return updated_state;
} else {
fulcro.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls FulcroApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
fulcro.client.impl.application.generate_reconciler = (function fulcro$client$impl$application$generate_reconciler(p__83841,initial_state,parser,p__83842){
var map__83843 = p__83841;
var map__83843__$1 = ((((!((map__83843 == null)))?((((map__83843.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83843.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83843):map__83843);
var app = map__83843__$1;
var send_queues = cljs.core.get.call(null,map__83843__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var mutation_merge = cljs.core.get.call(null,map__83843__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__83844 = p__83842;
var map__83844__$1 = ((((!((map__83844 == null)))?((((map__83844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83844.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83844):map__83844);
var reconciler_options = map__83844__$1;
var migrate = cljs.core.get.call(null,map__83844__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743));
var rec_atom = cljs.core.atom.call(null,null);
var remotes = cljs.core.keys.call(null,send_queues);
var tempid_migrate = ((function (rec_atom,remotes,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate){
return (function (pure,_,tempids,___$1){
var seq__83847_83851 = cljs.core.seq.call(null,cljs.core.vals.call(null,send_queues));
var chunk__83848_83852 = null;
var count__83849_83853 = (0);
var i__83850_83854 = (0);
while(true){
if((i__83850_83854 < count__83849_83853)){
var queue_83855 = cljs.core._nth.call(null,chunk__83848_83852,i__83850_83854);
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_83855,tempids);

var G__83856 = seq__83847_83851;
var G__83857 = chunk__83848_83852;
var G__83858 = count__83849_83853;
var G__83859 = (i__83850_83854 + (1));
seq__83847_83851 = G__83856;
chunk__83848_83852 = G__83857;
count__83849_83853 = G__83858;
i__83850_83854 = G__83859;
continue;
} else {
var temp__4657__auto___83860 = cljs.core.seq.call(null,seq__83847_83851);
if(temp__4657__auto___83860){
var seq__83847_83861__$1 = temp__4657__auto___83860;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83847_83861__$1)){
var c__28980__auto___83862 = cljs.core.chunk_first.call(null,seq__83847_83861__$1);
var G__83863 = cljs.core.chunk_rest.call(null,seq__83847_83861__$1);
var G__83864 = c__28980__auto___83862;
var G__83865 = cljs.core.count.call(null,c__28980__auto___83862);
var G__83866 = (0);
seq__83847_83851 = G__83863;
chunk__83848_83852 = G__83864;
count__83849_83853 = G__83865;
i__83850_83854 = G__83866;
continue;
} else {
var queue_83867 = cljs.core.first.call(null,seq__83847_83861__$1);
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_83867,tempids);

var G__83868 = cljs.core.next.call(null,seq__83847_83861__$1);
var G__83869 = null;
var G__83870 = (0);
var G__83871 = (0);
seq__83847_83851 = G__83868;
chunk__83848_83852 = G__83869;
count__83849_83853 = G__83870;
i__83850_83854 = G__83871;
continue;
}
} else {
}
}
break;
}

var state_migrate = (function (){var or__28141__auto__ = migrate;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro.client.impl.om_plumbing.resolve_tempids;
}
})();
return state_migrate.call(null,pure,tempids);
});})(rec_atom,remotes,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate))
;
var initial_state_with_locale = (function (){var set_default_locale = ((function (rec_atom,remotes,tempid_migrate,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate){
return (function (s){
return cljs.core.update.call(null,s,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),cljs.core.fnil.call(null,cljs.core.identity,new cljs.core.Keyword(null,"en","en",88457073)));
});})(rec_atom,remotes,tempid_migrate,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate))
;
var is_atom_QMARK_ = fulcro.client.util.atom_QMARK_.call(null,initial_state);
var incoming_locale = cljs.core.get.call(null,(cljs.core.truth_(is_atom_QMARK_)?cljs.core.deref.call(null,initial_state):initial_state),new cljs.core.Keyword("ui","locale","ui/locale",-2115717461));
if(cljs.core.truth_(incoming_locale)){
cljs.core.reset_BANG_.call(null,fulcro.i18n._STAR_current_locale_STAR_,incoming_locale);
} else {
}

if(cljs.core.truth_(is_atom_QMARK_)){
cljs.core.swap_BANG_.call(null,initial_state,set_default_locale);

return initial_state;
} else {
return set_default_locale.call(null,initial_state);
}
})();
var config = cljs.core.merge.call(null,cljs.core.PersistentArrayMap.EMPTY,reconciler_options,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"migrate","migrate",-207110743),tempid_migrate,new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate){
return (function (tx,cb){
return fulcro.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"remotes","remotes",1132366312),remotes,new cljs.core.Keyword(null,"merge-ident","merge-ident",1040841862),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate){
return (function (reconciler,app_state,ident,props){
return cljs.core.update_in.call(null,app_state,ident,cljs.core.comp.call(null,fulcro.client.impl.application.sweep_one,cljs.core.merge),props);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate){
return (function (target,source){
return fulcro.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__83843,map__83843__$1,app,send_queues,mutation_merge,map__83844,map__83844__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser], null));
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
fulcro.client.impl.application.initialize_global_error_callbacks = (function fulcro$client$impl$application$initialize_global_error_callbacks(app){
var seq__83887 = cljs.core.seq.call(null,cljs.core.keys.call(null,new cljs.core.Keyword(null,"networking","networking",586110628).cljs$core$IFn$_invoke$arity$1(app)));
var chunk__83888 = null;
var count__83889 = (0);
var i__83890 = (0);
while(true){
if((i__83890 < count__83889)){
var remote = cljs.core._nth.call(null,chunk__83888,i__83890);
var cb_atom_83891 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(fulcro.client.util.atom_QMARK_.call(null,cb_atom_83891))){
cljs.core.swap_BANG_.call(null,cb_atom_83891,((function (seq__83887,chunk__83888,count__83889,i__83890,cb_atom_83891,remote){
return (function (p1__83886_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__83886_SHARP_)){
return cljs.core.partial.call(null,p1__83886_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__83887,chunk__83888,count__83889,i__83890,cb_atom_83891,remote))
);
} else {
}

var G__83894 = seq__83887;
var G__83895 = chunk__83888;
var G__83896 = count__83889;
var G__83897 = (i__83890 + (1));
seq__83887 = G__83894;
chunk__83888 = G__83895;
count__83889 = G__83896;
i__83890 = G__83897;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__83887);
if(temp__4657__auto__){
var seq__83887__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83887__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__83887__$1);
var G__83898 = cljs.core.chunk_rest.call(null,seq__83887__$1);
var G__83899 = c__28980__auto__;
var G__83900 = cljs.core.count.call(null,c__28980__auto__);
var G__83901 = (0);
seq__83887 = G__83898;
chunk__83888 = G__83899;
count__83889 = G__83900;
i__83890 = G__83901;
continue;
} else {
var remote = cljs.core.first.call(null,seq__83887__$1);
var cb_atom_83902 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(fulcro.client.util.atom_QMARK_.call(null,cb_atom_83902))){
cljs.core.swap_BANG_.call(null,cb_atom_83902,((function (seq__83887,chunk__83888,count__83889,i__83890,cb_atom_83902,remote,seq__83887__$1,temp__4657__auto__){
return (function (p1__83886_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__83886_SHARP_)){
return cljs.core.partial.call(null,p1__83886_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__83887,chunk__83888,count__83889,i__83890,cb_atom_83902,remote,seq__83887__$1,temp__4657__auto__))
);
} else {
}

var G__83907 = cljs.core.next.call(null,seq__83887__$1);
var G__83908 = null;
var G__83909 = (0);
var G__83910 = (0);
seq__83887 = G__83907;
chunk__83888 = G__83908;
count__83889 = G__83909;
i__83890 = G__83910;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=application.js.map?rel=1511229599695
