// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.i18n');
goog.require('cljs.core');
goog.require('fulcro.client.logging');
goog.require('yahoo.intl_messageformat_with_locales');
fulcro.i18n._STAR_current_locale_STAR_ = cljs.core.atom.call(null,"en-US");
fulcro.i18n._STAR_loaded_translations_STAR_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fulcro.i18n._STAR_custom_formats_STAR_ = cljs.core.atom.call(null,null);
fulcro.i18n.current_locale = (function fulcro$i18n$current_locale(){
return cljs.core.deref.call(null,fulcro.i18n._STAR_current_locale_STAR_);
});
fulcro.i18n.translations_for_locale = (function fulcro$i18n$translations_for_locale(){
return cljs.core.get.call(null,cljs.core.deref.call(null,fulcro.i18n._STAR_loaded_translations_STAR_),fulcro.i18n.current_locale.call(null));
});
/**
 * Merges the given formats into the supported custom formats. See https://formatjs.io/guides/message-syntax/#custom-formats
 *   for more information on the structure of custom formats.
 * 
 *   IMPORTANT: `formats` must be a clj/cljs map. It will be converted to the proper JS object behind the scenes during
 *   translation.
 */
fulcro.i18n.merge_custom_formats = (function fulcro$i18n$merge_custom_formats(formats){
if(cljs.core.map_QMARK_.call(null,formats)){
} else {
throw (new Error("Assert failed: (map? formats)"));
}

return cljs.core.swap_BANG_.call(null,fulcro.i18n._STAR_custom_formats_STAR_,cljs.core.merge,formats);
});
var ret__29352__auto___82849 = fulcro.i18n.if_cljs = (function fulcro$i18n$if_cljs(_AMPERSAND_form,_AMPERSAND_env,then,else$){
if(cljs.core.truth_(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env))){
return then;
} else {
return else$;
}
});
fulcro.i18n.if_cljs.cljs$lang$macro = true;

var real_tr = (function fulcro$i18n$real_tr(msg){
var msg_key = ["|",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('');
var translations = fulcro.i18n.translations_for_locale.call(null);
var translation = cljs.core.get.call(null,translations,msg_key,msg);
return translation;
});
tr = (function fulcro$i18n$tr(msg){
return real_tr.call(null,msg);
});
var real_trc = (function fulcro$i18n$real_trc(ctxt,msg){
var msg_key = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ctxt),"|",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('');
var translations = fulcro.i18n.translations_for_locale.call(null);
var translation = cljs.core.get.call(null,translations,msg_key,msg);
return translation;
});
trc = (function (ctxt,msg){
return real_trc.call(null,ctxt,msg);
});
trf = (function() { 
var fulcro$i18n$trf__delegate = function (fmt,args){
try{console.log(args);

var argmap = (((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,args))))?cljs.core.first.call(null,args):cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.mapv.call(null,cljs.core.vec,cljs.core.partition.call(null,(2),args))));
var msg_key = ["|",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join('');
var translations = fulcro.i18n.translations_for_locale.call(null);
var translation = cljs.core.get.call(null,translations,msg_key,fmt);
var custom_formats = (cljs.core.truth_(cljs.core.deref.call(null,fulcro.i18n._STAR_custom_formats_STAR_))?cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,fulcro.i18n._STAR_custom_formats_STAR_)):null);
var _ = console.log(custom_formats);
var formatter = (cljs.core.truth_(custom_formats)?(new IntlMessageFormat(translation,fulcro.i18n.current_locale.call(null),custom_formats)):(new IntlMessageFormat(translation,fulcro.i18n.current_locale.call(null))));
return formatter.format(cljs.core.clj__GT_js.call(null,argmap));
}catch (e82850){var e = e82850;
return "???";
}};
var fulcro$i18n$trf = function (fmt,var_args){
var args = null;
if (arguments.length > 1) {
var G__82853__i = 0, G__82853__a = new Array(arguments.length -  1);
while (G__82853__i < G__82853__a.length) {G__82853__a[G__82853__i] = arguments[G__82853__i + 1]; ++G__82853__i;}
  args = new cljs.core.IndexedSeq(G__82853__a,0,null);
} 
return fulcro$i18n$trf__delegate.call(this,fmt,args);};
fulcro$i18n$trf.cljs$lang$maxFixedArity = 1;
fulcro$i18n$trf.cljs$lang$applyTo = (function (arglist__82854){
var fmt = cljs.core.first(arglist__82854);
var args = cljs.core.rest(arglist__82854);
return fulcro$i18n$trf__delegate(fmt,args);
});
fulcro$i18n$trf.cljs$core$IFn$_invoke$arity$variadic = fulcro$i18n$trf__delegate;
return fulcro$i18n$trf;
})()
;

//# sourceMappingURL=i18n.js.map?rel=1511229599054
