// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__47219 = arguments.length;
switch (G__47219) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async47220 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47220 = (function (f,blockable,meta47221){
this.f = f;
this.blockable = blockable;
this.meta47221 = meta47221;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47222,meta47221__$1){
var self__ = this;
var _47222__$1 = this;
return (new cljs.core.async.t_cljs$core$async47220(self__.f,self__.blockable,meta47221__$1));
});


cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47222){
var self__ = this;
var _47222__$1 = this;
return self__.meta47221;
});


cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async47220.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async47220.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta47221","meta47221",496584256,null)], null);
});

cljs.core.async.t_cljs$core$async47220.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47220.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47220";

cljs.core.async.t_cljs$core$async47220.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async47220");
});

cljs.core.async.__GT_t_cljs$core$async47220 = (function cljs$core$async$__GT_t_cljs$core$async47220(f__$1,blockable__$1,meta47221){
return (new cljs.core.async.t_cljs$core$async47220(f__$1,blockable__$1,meta47221));
});

}

return (new cljs.core.async.t_cljs$core$async47220(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__47226 = arguments.length;
switch (G__47226) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__47229 = arguments.length;
switch (G__47229) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__47232 = arguments.length;
switch (G__47232) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_47234 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_47234);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_47234,ret){
return (function (){
return fn1.call(null,val_47234);
});})(val_47234,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__47236 = arguments.length;
switch (G__47236) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29089__auto___47238 = n;
var x_47239 = (0);
while(true){
if((x_47239 < n__29089__auto___47238)){
(a[x_47239] = (0));

var G__47240 = (x_47239 + (1));
x_47239 = G__47240;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__47241 = (i + (1));
i = G__47241;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async47242 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47242 = (function (flag,meta47243){
this.flag = flag;
this.meta47243 = meta47243;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async47242.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_47244,meta47243__$1){
var self__ = this;
var _47244__$1 = this;
return (new cljs.core.async.t_cljs$core$async47242(self__.flag,meta47243__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async47242.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_47244){
var self__ = this;
var _47244__$1 = this;
return self__.meta47243;
});})(flag))
;


cljs.core.async.t_cljs$core$async47242.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async47242.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async47242.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async47242.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async47242.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta47243","meta47243",1901995829,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async47242.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47242.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47242";

cljs.core.async.t_cljs$core$async47242.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async47242");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async47242 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async47242(flag__$1,meta47243){
return (new cljs.core.async.t_cljs$core$async47242(flag__$1,meta47243));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async47242(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async47245 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47245 = (function (flag,cb,meta47246){
this.flag = flag;
this.cb = cb;
this.meta47246 = meta47246;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47247,meta47246__$1){
var self__ = this;
var _47247__$1 = this;
return (new cljs.core.async.t_cljs$core$async47245(self__.flag,self__.cb,meta47246__$1));
});


cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47247){
var self__ = this;
var _47247__$1 = this;
return self__.meta47246;
});


cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async47245.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta47246","meta47246",-936653561,null)], null);
});

cljs.core.async.t_cljs$core$async47245.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47245.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47245";

cljs.core.async.t_cljs$core$async47245.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async47245");
});

cljs.core.async.__GT_t_cljs$core$async47245 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async47245(flag__$1,cb__$1,meta47246){
return (new cljs.core.async.t_cljs$core$async47245(flag__$1,cb__$1,meta47246));
});

}

return (new cljs.core.async.t_cljs$core$async47245(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47248_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47248_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47249_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47249_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28141__auto__ = wport;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return port;
}
})()], null));
} else {
var G__47250 = (i + (1));
i = G__47250;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28141__auto__ = ret;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28129__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29320__auto__ = [];
var len__29313__auto___47256 = arguments.length;
var i__29314__auto___47257 = (0);
while(true){
if((i__29314__auto___47257 < len__29313__auto___47256)){
args__29320__auto__.push((arguments[i__29314__auto___47257]));

var G__47258 = (i__29314__auto___47257 + (1));
i__29314__auto___47257 = G__47258;
continue;
} else {
}
break;
}

var argseq__29321__auto__ = ((((1) < args__29320__auto__.length))?(new cljs.core.IndexedSeq(args__29320__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29321__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__47253){
var map__47254 = p__47253;
var map__47254__$1 = ((((!((map__47254 == null)))?((((map__47254.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47254.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47254):map__47254);
var opts = map__47254__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq47251){
var G__47252 = cljs.core.first.call(null,seq47251);
var seq47251__$1 = cljs.core.next.call(null,seq47251);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__47252,seq47251__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__47260 = arguments.length;
switch (G__47260) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__47173__auto___47306 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___47306){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___47306){
return (function (state_47284){
var state_val_47285 = (state_47284[(1)]);
if((state_val_47285 === (7))){
var inst_47280 = (state_47284[(2)]);
var state_47284__$1 = state_47284;
var statearr_47286_47307 = state_47284__$1;
(statearr_47286_47307[(2)] = inst_47280);

(statearr_47286_47307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (1))){
var state_47284__$1 = state_47284;
var statearr_47287_47308 = state_47284__$1;
(statearr_47287_47308[(2)] = null);

(statearr_47287_47308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (4))){
var inst_47263 = (state_47284[(7)]);
var inst_47263__$1 = (state_47284[(2)]);
var inst_47264 = (inst_47263__$1 == null);
var state_47284__$1 = (function (){var statearr_47288 = state_47284;
(statearr_47288[(7)] = inst_47263__$1);

return statearr_47288;
})();
if(cljs.core.truth_(inst_47264)){
var statearr_47289_47309 = state_47284__$1;
(statearr_47289_47309[(1)] = (5));

} else {
var statearr_47290_47310 = state_47284__$1;
(statearr_47290_47310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (13))){
var state_47284__$1 = state_47284;
var statearr_47291_47311 = state_47284__$1;
(statearr_47291_47311[(2)] = null);

(statearr_47291_47311[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (6))){
var inst_47263 = (state_47284[(7)]);
var state_47284__$1 = state_47284;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47284__$1,(11),to,inst_47263);
} else {
if((state_val_47285 === (3))){
var inst_47282 = (state_47284[(2)]);
var state_47284__$1 = state_47284;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47284__$1,inst_47282);
} else {
if((state_val_47285 === (12))){
var state_47284__$1 = state_47284;
var statearr_47292_47312 = state_47284__$1;
(statearr_47292_47312[(2)] = null);

(statearr_47292_47312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (2))){
var state_47284__$1 = state_47284;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47284__$1,(4),from);
} else {
if((state_val_47285 === (11))){
var inst_47273 = (state_47284[(2)]);
var state_47284__$1 = state_47284;
if(cljs.core.truth_(inst_47273)){
var statearr_47293_47313 = state_47284__$1;
(statearr_47293_47313[(1)] = (12));

} else {
var statearr_47294_47314 = state_47284__$1;
(statearr_47294_47314[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (9))){
var state_47284__$1 = state_47284;
var statearr_47295_47315 = state_47284__$1;
(statearr_47295_47315[(2)] = null);

(statearr_47295_47315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (5))){
var state_47284__$1 = state_47284;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47296_47316 = state_47284__$1;
(statearr_47296_47316[(1)] = (8));

} else {
var statearr_47297_47317 = state_47284__$1;
(statearr_47297_47317[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (14))){
var inst_47278 = (state_47284[(2)]);
var state_47284__$1 = state_47284;
var statearr_47298_47318 = state_47284__$1;
(statearr_47298_47318[(2)] = inst_47278);

(statearr_47298_47318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (10))){
var inst_47270 = (state_47284[(2)]);
var state_47284__$1 = state_47284;
var statearr_47299_47319 = state_47284__$1;
(statearr_47299_47319[(2)] = inst_47270);

(statearr_47299_47319[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47285 === (8))){
var inst_47267 = cljs.core.async.close_BANG_.call(null,to);
var state_47284__$1 = state_47284;
var statearr_47300_47320 = state_47284__$1;
(statearr_47300_47320[(2)] = inst_47267);

(statearr_47300_47320[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___47306))
;
return ((function (switch__47085__auto__,c__47173__auto___47306){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_47301 = [null,null,null,null,null,null,null,null];
(statearr_47301[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_47301[(1)] = (1));

return statearr_47301;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_47284){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47284);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47302){if((e47302 instanceof Object)){
var ex__47089__auto__ = e47302;
var statearr_47303_47321 = state_47284;
(statearr_47303_47321[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47284);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47302;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47322 = state_47284;
state_47284 = G__47322;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_47284){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_47284);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___47306))
})();
var state__47175__auto__ = (function (){var statearr_47304 = f__47174__auto__.call(null);
(statearr_47304[(6)] = c__47173__auto___47306);

return statearr_47304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___47306))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__47323){
var vec__47324 = p__47323;
var v = cljs.core.nth.call(null,vec__47324,(0),null);
var p = cljs.core.nth.call(null,vec__47324,(1),null);
var job = vec__47324;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__47173__auto___47495 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___47495,res,vec__47324,v,p,job,jobs,results){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___47495,res,vec__47324,v,p,job,jobs,results){
return (function (state_47331){
var state_val_47332 = (state_47331[(1)]);
if((state_val_47332 === (1))){
var state_47331__$1 = state_47331;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47331__$1,(2),res,v);
} else {
if((state_val_47332 === (2))){
var inst_47328 = (state_47331[(2)]);
var inst_47329 = cljs.core.async.close_BANG_.call(null,res);
var state_47331__$1 = (function (){var statearr_47333 = state_47331;
(statearr_47333[(7)] = inst_47328);

return statearr_47333;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47331__$1,inst_47329);
} else {
return null;
}
}
});})(c__47173__auto___47495,res,vec__47324,v,p,job,jobs,results))
;
return ((function (switch__47085__auto__,c__47173__auto___47495,res,vec__47324,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_47334 = [null,null,null,null,null,null,null,null];
(statearr_47334[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_47334[(1)] = (1));

return statearr_47334;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_47331){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47331);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47335){if((e47335 instanceof Object)){
var ex__47089__auto__ = e47335;
var statearr_47336_47496 = state_47331;
(statearr_47336_47496[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47331);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47335;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47497 = state_47331;
state_47331 = G__47497;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_47331){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_47331);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___47495,res,vec__47324,v,p,job,jobs,results))
})();
var state__47175__auto__ = (function (){var statearr_47337 = f__47174__auto__.call(null);
(statearr_47337[(6)] = c__47173__auto___47495);

return statearr_47337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___47495,res,vec__47324,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__47338){
var vec__47339 = p__47338;
var v = cljs.core.nth.call(null,vec__47339,(0),null);
var p = cljs.core.nth.call(null,vec__47339,(1),null);
var job = vec__47339;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29089__auto___47498 = n;
var __47499 = (0);
while(true){
if((__47499 < n__29089__auto___47498)){
var G__47342_47500 = type;
var G__47342_47501__$1 = (((G__47342_47500 instanceof cljs.core.Keyword))?G__47342_47500.fqn:null);
switch (G__47342_47501__$1) {
case "compute":
var c__47173__auto___47503 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__47499,c__47173__auto___47503,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (__47499,c__47173__auto___47503,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async){
return (function (state_47355){
var state_val_47356 = (state_47355[(1)]);
if((state_val_47356 === (1))){
var state_47355__$1 = state_47355;
var statearr_47357_47504 = state_47355__$1;
(statearr_47357_47504[(2)] = null);

(statearr_47357_47504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47356 === (2))){
var state_47355__$1 = state_47355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47355__$1,(4),jobs);
} else {
if((state_val_47356 === (3))){
var inst_47353 = (state_47355[(2)]);
var state_47355__$1 = state_47355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47355__$1,inst_47353);
} else {
if((state_val_47356 === (4))){
var inst_47345 = (state_47355[(2)]);
var inst_47346 = process.call(null,inst_47345);
var state_47355__$1 = state_47355;
if(cljs.core.truth_(inst_47346)){
var statearr_47358_47505 = state_47355__$1;
(statearr_47358_47505[(1)] = (5));

} else {
var statearr_47359_47506 = state_47355__$1;
(statearr_47359_47506[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47356 === (5))){
var state_47355__$1 = state_47355;
var statearr_47360_47507 = state_47355__$1;
(statearr_47360_47507[(2)] = null);

(statearr_47360_47507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47356 === (6))){
var state_47355__$1 = state_47355;
var statearr_47361_47508 = state_47355__$1;
(statearr_47361_47508[(2)] = null);

(statearr_47361_47508[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47356 === (7))){
var inst_47351 = (state_47355[(2)]);
var state_47355__$1 = state_47355;
var statearr_47362_47509 = state_47355__$1;
(statearr_47362_47509[(2)] = inst_47351);

(statearr_47362_47509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47499,c__47173__auto___47503,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async))
;
return ((function (__47499,switch__47085__auto__,c__47173__auto___47503,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_47363 = [null,null,null,null,null,null,null];
(statearr_47363[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_47363[(1)] = (1));

return statearr_47363;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_47355){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47364){if((e47364 instanceof Object)){
var ex__47089__auto__ = e47364;
var statearr_47365_47510 = state_47355;
(statearr_47365_47510[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47355);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47364;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47511 = state_47355;
state_47355 = G__47511;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_47355){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_47355);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(__47499,switch__47085__auto__,c__47173__auto___47503,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_47366 = f__47174__auto__.call(null);
(statearr_47366[(6)] = c__47173__auto___47503);

return statearr_47366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(__47499,c__47173__auto___47503,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async))
);


break;
case "async":
var c__47173__auto___47512 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__47499,c__47173__auto___47512,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (__47499,c__47173__auto___47512,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async){
return (function (state_47379){
var state_val_47380 = (state_47379[(1)]);
if((state_val_47380 === (1))){
var state_47379__$1 = state_47379;
var statearr_47381_47513 = state_47379__$1;
(statearr_47381_47513[(2)] = null);

(statearr_47381_47513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47380 === (2))){
var state_47379__$1 = state_47379;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47379__$1,(4),jobs);
} else {
if((state_val_47380 === (3))){
var inst_47377 = (state_47379[(2)]);
var state_47379__$1 = state_47379;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47379__$1,inst_47377);
} else {
if((state_val_47380 === (4))){
var inst_47369 = (state_47379[(2)]);
var inst_47370 = async.call(null,inst_47369);
var state_47379__$1 = state_47379;
if(cljs.core.truth_(inst_47370)){
var statearr_47382_47514 = state_47379__$1;
(statearr_47382_47514[(1)] = (5));

} else {
var statearr_47383_47515 = state_47379__$1;
(statearr_47383_47515[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47380 === (5))){
var state_47379__$1 = state_47379;
var statearr_47384_47516 = state_47379__$1;
(statearr_47384_47516[(2)] = null);

(statearr_47384_47516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47380 === (6))){
var state_47379__$1 = state_47379;
var statearr_47385_47517 = state_47379__$1;
(statearr_47385_47517[(2)] = null);

(statearr_47385_47517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47380 === (7))){
var inst_47375 = (state_47379[(2)]);
var state_47379__$1 = state_47379;
var statearr_47386_47518 = state_47379__$1;
(statearr_47386_47518[(2)] = inst_47375);

(statearr_47386_47518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47499,c__47173__auto___47512,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async))
;
return ((function (__47499,switch__47085__auto__,c__47173__auto___47512,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_47387 = [null,null,null,null,null,null,null];
(statearr_47387[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_47387[(1)] = (1));

return statearr_47387;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_47379){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47379);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47388){if((e47388 instanceof Object)){
var ex__47089__auto__ = e47388;
var statearr_47389_47519 = state_47379;
(statearr_47389_47519[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47379);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47388;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47520 = state_47379;
state_47379 = G__47520;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_47379){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_47379);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(__47499,switch__47085__auto__,c__47173__auto___47512,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_47390 = f__47174__auto__.call(null);
(statearr_47390[(6)] = c__47173__auto___47512);

return statearr_47390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(__47499,c__47173__auto___47512,G__47342_47500,G__47342_47501__$1,n__29089__auto___47498,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__47342_47501__$1)].join('')));

}

var G__47521 = (__47499 + (1));
__47499 = G__47521;
continue;
} else {
}
break;
}

var c__47173__auto___47522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___47522,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___47522,jobs,results,process,async){
return (function (state_47412){
var state_val_47413 = (state_47412[(1)]);
if((state_val_47413 === (1))){
var state_47412__$1 = state_47412;
var statearr_47414_47523 = state_47412__$1;
(statearr_47414_47523[(2)] = null);

(statearr_47414_47523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47413 === (2))){
var state_47412__$1 = state_47412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47412__$1,(4),from);
} else {
if((state_val_47413 === (3))){
var inst_47410 = (state_47412[(2)]);
var state_47412__$1 = state_47412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47412__$1,inst_47410);
} else {
if((state_val_47413 === (4))){
var inst_47393 = (state_47412[(7)]);
var inst_47393__$1 = (state_47412[(2)]);
var inst_47394 = (inst_47393__$1 == null);
var state_47412__$1 = (function (){var statearr_47415 = state_47412;
(statearr_47415[(7)] = inst_47393__$1);

return statearr_47415;
})();
if(cljs.core.truth_(inst_47394)){
var statearr_47416_47524 = state_47412__$1;
(statearr_47416_47524[(1)] = (5));

} else {
var statearr_47417_47525 = state_47412__$1;
(statearr_47417_47525[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47413 === (5))){
var inst_47396 = cljs.core.async.close_BANG_.call(null,jobs);
var state_47412__$1 = state_47412;
var statearr_47418_47526 = state_47412__$1;
(statearr_47418_47526[(2)] = inst_47396);

(statearr_47418_47526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47413 === (6))){
var inst_47393 = (state_47412[(7)]);
var inst_47398 = (state_47412[(8)]);
var inst_47398__$1 = cljs.core.async.chan.call(null,(1));
var inst_47399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47400 = [inst_47393,inst_47398__$1];
var inst_47401 = (new cljs.core.PersistentVector(null,2,(5),inst_47399,inst_47400,null));
var state_47412__$1 = (function (){var statearr_47419 = state_47412;
(statearr_47419[(8)] = inst_47398__$1);

return statearr_47419;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47412__$1,(8),jobs,inst_47401);
} else {
if((state_val_47413 === (7))){
var inst_47408 = (state_47412[(2)]);
var state_47412__$1 = state_47412;
var statearr_47420_47527 = state_47412__$1;
(statearr_47420_47527[(2)] = inst_47408);

(statearr_47420_47527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47413 === (8))){
var inst_47398 = (state_47412[(8)]);
var inst_47403 = (state_47412[(2)]);
var state_47412__$1 = (function (){var statearr_47421 = state_47412;
(statearr_47421[(9)] = inst_47403);

return statearr_47421;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47412__$1,(9),results,inst_47398);
} else {
if((state_val_47413 === (9))){
var inst_47405 = (state_47412[(2)]);
var state_47412__$1 = (function (){var statearr_47422 = state_47412;
(statearr_47422[(10)] = inst_47405);

return statearr_47422;
})();
var statearr_47423_47528 = state_47412__$1;
(statearr_47423_47528[(2)] = null);

(statearr_47423_47528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___47522,jobs,results,process,async))
;
return ((function (switch__47085__auto__,c__47173__auto___47522,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_47424 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47424[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_47424[(1)] = (1));

return statearr_47424;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_47412){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47425){if((e47425 instanceof Object)){
var ex__47089__auto__ = e47425;
var statearr_47426_47529 = state_47412;
(statearr_47426_47529[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47412);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47425;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47530 = state_47412;
state_47412 = G__47530;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_47412){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_47412);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___47522,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_47427 = f__47174__auto__.call(null);
(statearr_47427[(6)] = c__47173__auto___47522);

return statearr_47427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___47522,jobs,results,process,async))
);


var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,jobs,results,process,async){
return (function (state_47465){
var state_val_47466 = (state_47465[(1)]);
if((state_val_47466 === (7))){
var inst_47461 = (state_47465[(2)]);
var state_47465__$1 = state_47465;
var statearr_47467_47531 = state_47465__$1;
(statearr_47467_47531[(2)] = inst_47461);

(statearr_47467_47531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (20))){
var state_47465__$1 = state_47465;
var statearr_47468_47532 = state_47465__$1;
(statearr_47468_47532[(2)] = null);

(statearr_47468_47532[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (1))){
var state_47465__$1 = state_47465;
var statearr_47469_47533 = state_47465__$1;
(statearr_47469_47533[(2)] = null);

(statearr_47469_47533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (4))){
var inst_47430 = (state_47465[(7)]);
var inst_47430__$1 = (state_47465[(2)]);
var inst_47431 = (inst_47430__$1 == null);
var state_47465__$1 = (function (){var statearr_47470 = state_47465;
(statearr_47470[(7)] = inst_47430__$1);

return statearr_47470;
})();
if(cljs.core.truth_(inst_47431)){
var statearr_47471_47534 = state_47465__$1;
(statearr_47471_47534[(1)] = (5));

} else {
var statearr_47472_47535 = state_47465__$1;
(statearr_47472_47535[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (15))){
var inst_47443 = (state_47465[(8)]);
var state_47465__$1 = state_47465;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47465__$1,(18),to,inst_47443);
} else {
if((state_val_47466 === (21))){
var inst_47456 = (state_47465[(2)]);
var state_47465__$1 = state_47465;
var statearr_47473_47536 = state_47465__$1;
(statearr_47473_47536[(2)] = inst_47456);

(statearr_47473_47536[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (13))){
var inst_47458 = (state_47465[(2)]);
var state_47465__$1 = (function (){var statearr_47474 = state_47465;
(statearr_47474[(9)] = inst_47458);

return statearr_47474;
})();
var statearr_47475_47537 = state_47465__$1;
(statearr_47475_47537[(2)] = null);

(statearr_47475_47537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (6))){
var inst_47430 = (state_47465[(7)]);
var state_47465__$1 = state_47465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47465__$1,(11),inst_47430);
} else {
if((state_val_47466 === (17))){
var inst_47451 = (state_47465[(2)]);
var state_47465__$1 = state_47465;
if(cljs.core.truth_(inst_47451)){
var statearr_47476_47538 = state_47465__$1;
(statearr_47476_47538[(1)] = (19));

} else {
var statearr_47477_47539 = state_47465__$1;
(statearr_47477_47539[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (3))){
var inst_47463 = (state_47465[(2)]);
var state_47465__$1 = state_47465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47465__$1,inst_47463);
} else {
if((state_val_47466 === (12))){
var inst_47440 = (state_47465[(10)]);
var state_47465__$1 = state_47465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47465__$1,(14),inst_47440);
} else {
if((state_val_47466 === (2))){
var state_47465__$1 = state_47465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47465__$1,(4),results);
} else {
if((state_val_47466 === (19))){
var state_47465__$1 = state_47465;
var statearr_47478_47540 = state_47465__$1;
(statearr_47478_47540[(2)] = null);

(statearr_47478_47540[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (11))){
var inst_47440 = (state_47465[(2)]);
var state_47465__$1 = (function (){var statearr_47479 = state_47465;
(statearr_47479[(10)] = inst_47440);

return statearr_47479;
})();
var statearr_47480_47541 = state_47465__$1;
(statearr_47480_47541[(2)] = null);

(statearr_47480_47541[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (9))){
var state_47465__$1 = state_47465;
var statearr_47481_47542 = state_47465__$1;
(statearr_47481_47542[(2)] = null);

(statearr_47481_47542[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (5))){
var state_47465__$1 = state_47465;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47482_47543 = state_47465__$1;
(statearr_47482_47543[(1)] = (8));

} else {
var statearr_47483_47544 = state_47465__$1;
(statearr_47483_47544[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (14))){
var inst_47445 = (state_47465[(11)]);
var inst_47443 = (state_47465[(8)]);
var inst_47443__$1 = (state_47465[(2)]);
var inst_47444 = (inst_47443__$1 == null);
var inst_47445__$1 = cljs.core.not.call(null,inst_47444);
var state_47465__$1 = (function (){var statearr_47484 = state_47465;
(statearr_47484[(11)] = inst_47445__$1);

(statearr_47484[(8)] = inst_47443__$1);

return statearr_47484;
})();
if(inst_47445__$1){
var statearr_47485_47545 = state_47465__$1;
(statearr_47485_47545[(1)] = (15));

} else {
var statearr_47486_47546 = state_47465__$1;
(statearr_47486_47546[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (16))){
var inst_47445 = (state_47465[(11)]);
var state_47465__$1 = state_47465;
var statearr_47487_47547 = state_47465__$1;
(statearr_47487_47547[(2)] = inst_47445);

(statearr_47487_47547[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (10))){
var inst_47437 = (state_47465[(2)]);
var state_47465__$1 = state_47465;
var statearr_47488_47548 = state_47465__$1;
(statearr_47488_47548[(2)] = inst_47437);

(statearr_47488_47548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (18))){
var inst_47448 = (state_47465[(2)]);
var state_47465__$1 = state_47465;
var statearr_47489_47549 = state_47465__$1;
(statearr_47489_47549[(2)] = inst_47448);

(statearr_47489_47549[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47466 === (8))){
var inst_47434 = cljs.core.async.close_BANG_.call(null,to);
var state_47465__$1 = state_47465;
var statearr_47490_47550 = state_47465__$1;
(statearr_47490_47550[(2)] = inst_47434);

(statearr_47490_47550[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__,jobs,results,process,async))
;
return ((function (switch__47085__auto__,c__47173__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_47491 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47491[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_47491[(1)] = (1));

return statearr_47491;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_47465){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47492){if((e47492 instanceof Object)){
var ex__47089__auto__ = e47492;
var statearr_47493_47551 = state_47465;
(statearr_47493_47551[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47465);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47492;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47552 = state_47465;
state_47465 = G__47552;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_47465){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_47465);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_47494 = f__47174__auto__.call(null);
(statearr_47494[(6)] = c__47173__auto__);

return statearr_47494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,jobs,results,process,async))
);

return c__47173__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__47554 = arguments.length;
switch (G__47554) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__47557 = arguments.length;
switch (G__47557) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__47560 = arguments.length;
switch (G__47560) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__47173__auto___47609 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___47609,tc,fc){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___47609,tc,fc){
return (function (state_47586){
var state_val_47587 = (state_47586[(1)]);
if((state_val_47587 === (7))){
var inst_47582 = (state_47586[(2)]);
var state_47586__$1 = state_47586;
var statearr_47588_47610 = state_47586__$1;
(statearr_47588_47610[(2)] = inst_47582);

(statearr_47588_47610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (1))){
var state_47586__$1 = state_47586;
var statearr_47589_47611 = state_47586__$1;
(statearr_47589_47611[(2)] = null);

(statearr_47589_47611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (4))){
var inst_47563 = (state_47586[(7)]);
var inst_47563__$1 = (state_47586[(2)]);
var inst_47564 = (inst_47563__$1 == null);
var state_47586__$1 = (function (){var statearr_47590 = state_47586;
(statearr_47590[(7)] = inst_47563__$1);

return statearr_47590;
})();
if(cljs.core.truth_(inst_47564)){
var statearr_47591_47612 = state_47586__$1;
(statearr_47591_47612[(1)] = (5));

} else {
var statearr_47592_47613 = state_47586__$1;
(statearr_47592_47613[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (13))){
var state_47586__$1 = state_47586;
var statearr_47593_47614 = state_47586__$1;
(statearr_47593_47614[(2)] = null);

(statearr_47593_47614[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (6))){
var inst_47563 = (state_47586[(7)]);
var inst_47569 = p.call(null,inst_47563);
var state_47586__$1 = state_47586;
if(cljs.core.truth_(inst_47569)){
var statearr_47594_47615 = state_47586__$1;
(statearr_47594_47615[(1)] = (9));

} else {
var statearr_47595_47616 = state_47586__$1;
(statearr_47595_47616[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (3))){
var inst_47584 = (state_47586[(2)]);
var state_47586__$1 = state_47586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47586__$1,inst_47584);
} else {
if((state_val_47587 === (12))){
var state_47586__$1 = state_47586;
var statearr_47596_47617 = state_47586__$1;
(statearr_47596_47617[(2)] = null);

(statearr_47596_47617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (2))){
var state_47586__$1 = state_47586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47586__$1,(4),ch);
} else {
if((state_val_47587 === (11))){
var inst_47563 = (state_47586[(7)]);
var inst_47573 = (state_47586[(2)]);
var state_47586__$1 = state_47586;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47586__$1,(8),inst_47573,inst_47563);
} else {
if((state_val_47587 === (9))){
var state_47586__$1 = state_47586;
var statearr_47597_47618 = state_47586__$1;
(statearr_47597_47618[(2)] = tc);

(statearr_47597_47618[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (5))){
var inst_47566 = cljs.core.async.close_BANG_.call(null,tc);
var inst_47567 = cljs.core.async.close_BANG_.call(null,fc);
var state_47586__$1 = (function (){var statearr_47598 = state_47586;
(statearr_47598[(8)] = inst_47566);

return statearr_47598;
})();
var statearr_47599_47619 = state_47586__$1;
(statearr_47599_47619[(2)] = inst_47567);

(statearr_47599_47619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (14))){
var inst_47580 = (state_47586[(2)]);
var state_47586__$1 = state_47586;
var statearr_47600_47620 = state_47586__$1;
(statearr_47600_47620[(2)] = inst_47580);

(statearr_47600_47620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (10))){
var state_47586__$1 = state_47586;
var statearr_47601_47621 = state_47586__$1;
(statearr_47601_47621[(2)] = fc);

(statearr_47601_47621[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47587 === (8))){
var inst_47575 = (state_47586[(2)]);
var state_47586__$1 = state_47586;
if(cljs.core.truth_(inst_47575)){
var statearr_47602_47622 = state_47586__$1;
(statearr_47602_47622[(1)] = (12));

} else {
var statearr_47603_47623 = state_47586__$1;
(statearr_47603_47623[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___47609,tc,fc))
;
return ((function (switch__47085__auto__,c__47173__auto___47609,tc,fc){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_47604 = [null,null,null,null,null,null,null,null,null];
(statearr_47604[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_47604[(1)] = (1));

return statearr_47604;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_47586){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47605){if((e47605 instanceof Object)){
var ex__47089__auto__ = e47605;
var statearr_47606_47624 = state_47586;
(statearr_47606_47624[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47605;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47625 = state_47586;
state_47586 = G__47625;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_47586){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_47586);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___47609,tc,fc))
})();
var state__47175__auto__ = (function (){var statearr_47607 = f__47174__auto__.call(null);
(statearr_47607[(6)] = c__47173__auto___47609);

return statearr_47607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___47609,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_47646){
var state_val_47647 = (state_47646[(1)]);
if((state_val_47647 === (7))){
var inst_47642 = (state_47646[(2)]);
var state_47646__$1 = state_47646;
var statearr_47648_47666 = state_47646__$1;
(statearr_47648_47666[(2)] = inst_47642);

(statearr_47648_47666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47647 === (1))){
var inst_47626 = init;
var state_47646__$1 = (function (){var statearr_47649 = state_47646;
(statearr_47649[(7)] = inst_47626);

return statearr_47649;
})();
var statearr_47650_47667 = state_47646__$1;
(statearr_47650_47667[(2)] = null);

(statearr_47650_47667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47647 === (4))){
var inst_47629 = (state_47646[(8)]);
var inst_47629__$1 = (state_47646[(2)]);
var inst_47630 = (inst_47629__$1 == null);
var state_47646__$1 = (function (){var statearr_47651 = state_47646;
(statearr_47651[(8)] = inst_47629__$1);

return statearr_47651;
})();
if(cljs.core.truth_(inst_47630)){
var statearr_47652_47668 = state_47646__$1;
(statearr_47652_47668[(1)] = (5));

} else {
var statearr_47653_47669 = state_47646__$1;
(statearr_47653_47669[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47647 === (6))){
var inst_47629 = (state_47646[(8)]);
var inst_47626 = (state_47646[(7)]);
var inst_47633 = (state_47646[(9)]);
var inst_47633__$1 = f.call(null,inst_47626,inst_47629);
var inst_47634 = cljs.core.reduced_QMARK_.call(null,inst_47633__$1);
var state_47646__$1 = (function (){var statearr_47654 = state_47646;
(statearr_47654[(9)] = inst_47633__$1);

return statearr_47654;
})();
if(inst_47634){
var statearr_47655_47670 = state_47646__$1;
(statearr_47655_47670[(1)] = (8));

} else {
var statearr_47656_47671 = state_47646__$1;
(statearr_47656_47671[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47647 === (3))){
var inst_47644 = (state_47646[(2)]);
var state_47646__$1 = state_47646;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47646__$1,inst_47644);
} else {
if((state_val_47647 === (2))){
var state_47646__$1 = state_47646;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47646__$1,(4),ch);
} else {
if((state_val_47647 === (9))){
var inst_47633 = (state_47646[(9)]);
var inst_47626 = inst_47633;
var state_47646__$1 = (function (){var statearr_47657 = state_47646;
(statearr_47657[(7)] = inst_47626);

return statearr_47657;
})();
var statearr_47658_47672 = state_47646__$1;
(statearr_47658_47672[(2)] = null);

(statearr_47658_47672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47647 === (5))){
var inst_47626 = (state_47646[(7)]);
var state_47646__$1 = state_47646;
var statearr_47659_47673 = state_47646__$1;
(statearr_47659_47673[(2)] = inst_47626);

(statearr_47659_47673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47647 === (10))){
var inst_47640 = (state_47646[(2)]);
var state_47646__$1 = state_47646;
var statearr_47660_47674 = state_47646__$1;
(statearr_47660_47674[(2)] = inst_47640);

(statearr_47660_47674[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47647 === (8))){
var inst_47633 = (state_47646[(9)]);
var inst_47636 = cljs.core.deref.call(null,inst_47633);
var state_47646__$1 = state_47646;
var statearr_47661_47675 = state_47646__$1;
(statearr_47661_47675[(2)] = inst_47636);

(statearr_47661_47675[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__47086__auto__ = null;
var cljs$core$async$reduce_$_state_machine__47086__auto____0 = (function (){
var statearr_47662 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47662[(0)] = cljs$core$async$reduce_$_state_machine__47086__auto__);

(statearr_47662[(1)] = (1));

return statearr_47662;
});
var cljs$core$async$reduce_$_state_machine__47086__auto____1 = (function (state_47646){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47646);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47663){if((e47663 instanceof Object)){
var ex__47089__auto__ = e47663;
var statearr_47664_47676 = state_47646;
(statearr_47664_47676[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47646);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47663;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47677 = state_47646;
state_47646 = G__47677;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__47086__auto__ = function(state_47646){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__47086__auto____1.call(this,state_47646);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__47086__auto____0;
cljs$core$async$reduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__47086__auto____1;
return cljs$core$async$reduce_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_47665 = f__47174__auto__.call(null);
(statearr_47665[(6)] = c__47173__auto__);

return statearr_47665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,f__$1){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,f__$1){
return (function (state_47683){
var state_val_47684 = (state_47683[(1)]);
if((state_val_47684 === (1))){
var inst_47678 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_47683__$1 = state_47683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47683__$1,(2),inst_47678);
} else {
if((state_val_47684 === (2))){
var inst_47680 = (state_47683[(2)]);
var inst_47681 = f__$1.call(null,inst_47680);
var state_47683__$1 = state_47683;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47683__$1,inst_47681);
} else {
return null;
}
}
});})(c__47173__auto__,f__$1))
;
return ((function (switch__47085__auto__,c__47173__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__47086__auto__ = null;
var cljs$core$async$transduce_$_state_machine__47086__auto____0 = (function (){
var statearr_47685 = [null,null,null,null,null,null,null];
(statearr_47685[(0)] = cljs$core$async$transduce_$_state_machine__47086__auto__);

(statearr_47685[(1)] = (1));

return statearr_47685;
});
var cljs$core$async$transduce_$_state_machine__47086__auto____1 = (function (state_47683){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47686){if((e47686 instanceof Object)){
var ex__47089__auto__ = e47686;
var statearr_47687_47689 = state_47683;
(statearr_47687_47689[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47683);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47686;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47690 = state_47683;
state_47683 = G__47690;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__47086__auto__ = function(state_47683){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__47086__auto____1.call(this,state_47683);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__47086__auto____0;
cljs$core$async$transduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__47086__auto____1;
return cljs$core$async$transduce_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,f__$1))
})();
var state__47175__auto__ = (function (){var statearr_47688 = f__47174__auto__.call(null);
(statearr_47688[(6)] = c__47173__auto__);

return statearr_47688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,f__$1))
);

return c__47173__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__47692 = arguments.length;
switch (G__47692) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_47717){
var state_val_47718 = (state_47717[(1)]);
if((state_val_47718 === (7))){
var inst_47699 = (state_47717[(2)]);
var state_47717__$1 = state_47717;
var statearr_47719_47740 = state_47717__$1;
(statearr_47719_47740[(2)] = inst_47699);

(statearr_47719_47740[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (1))){
var inst_47693 = cljs.core.seq.call(null,coll);
var inst_47694 = inst_47693;
var state_47717__$1 = (function (){var statearr_47720 = state_47717;
(statearr_47720[(7)] = inst_47694);

return statearr_47720;
})();
var statearr_47721_47741 = state_47717__$1;
(statearr_47721_47741[(2)] = null);

(statearr_47721_47741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (4))){
var inst_47694 = (state_47717[(7)]);
var inst_47697 = cljs.core.first.call(null,inst_47694);
var state_47717__$1 = state_47717;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47717__$1,(7),ch,inst_47697);
} else {
if((state_val_47718 === (13))){
var inst_47711 = (state_47717[(2)]);
var state_47717__$1 = state_47717;
var statearr_47722_47742 = state_47717__$1;
(statearr_47722_47742[(2)] = inst_47711);

(statearr_47722_47742[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (6))){
var inst_47702 = (state_47717[(2)]);
var state_47717__$1 = state_47717;
if(cljs.core.truth_(inst_47702)){
var statearr_47723_47743 = state_47717__$1;
(statearr_47723_47743[(1)] = (8));

} else {
var statearr_47724_47744 = state_47717__$1;
(statearr_47724_47744[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (3))){
var inst_47715 = (state_47717[(2)]);
var state_47717__$1 = state_47717;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47717__$1,inst_47715);
} else {
if((state_val_47718 === (12))){
var state_47717__$1 = state_47717;
var statearr_47725_47745 = state_47717__$1;
(statearr_47725_47745[(2)] = null);

(statearr_47725_47745[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (2))){
var inst_47694 = (state_47717[(7)]);
var state_47717__$1 = state_47717;
if(cljs.core.truth_(inst_47694)){
var statearr_47726_47746 = state_47717__$1;
(statearr_47726_47746[(1)] = (4));

} else {
var statearr_47727_47747 = state_47717__$1;
(statearr_47727_47747[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (11))){
var inst_47708 = cljs.core.async.close_BANG_.call(null,ch);
var state_47717__$1 = state_47717;
var statearr_47728_47748 = state_47717__$1;
(statearr_47728_47748[(2)] = inst_47708);

(statearr_47728_47748[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (9))){
var state_47717__$1 = state_47717;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47729_47749 = state_47717__$1;
(statearr_47729_47749[(1)] = (11));

} else {
var statearr_47730_47750 = state_47717__$1;
(statearr_47730_47750[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (5))){
var inst_47694 = (state_47717[(7)]);
var state_47717__$1 = state_47717;
var statearr_47731_47751 = state_47717__$1;
(statearr_47731_47751[(2)] = inst_47694);

(statearr_47731_47751[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (10))){
var inst_47713 = (state_47717[(2)]);
var state_47717__$1 = state_47717;
var statearr_47732_47752 = state_47717__$1;
(statearr_47732_47752[(2)] = inst_47713);

(statearr_47732_47752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47718 === (8))){
var inst_47694 = (state_47717[(7)]);
var inst_47704 = cljs.core.next.call(null,inst_47694);
var inst_47694__$1 = inst_47704;
var state_47717__$1 = (function (){var statearr_47733 = state_47717;
(statearr_47733[(7)] = inst_47694__$1);

return statearr_47733;
})();
var statearr_47734_47753 = state_47717__$1;
(statearr_47734_47753[(2)] = null);

(statearr_47734_47753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_47735 = [null,null,null,null,null,null,null,null];
(statearr_47735[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_47735[(1)] = (1));

return statearr_47735;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_47717){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47736){if((e47736 instanceof Object)){
var ex__47089__auto__ = e47736;
var statearr_47737_47754 = state_47717;
(statearr_47737_47754[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47717);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47736;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47755 = state_47717;
state_47717 = G__47755;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_47717){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_47717);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_47738 = f__47174__auto__.call(null);
(statearr_47738[(6)] = c__47173__auto__);

return statearr_47738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28824__auto__ = (((_ == null))?null:_);
var m__28825__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,_);
} else {
var m__28825__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28825__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m);
} else {
var m__28825__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async47756 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47756 = (function (ch,cs,meta47757){
this.ch = ch;
this.cs = cs;
this.meta47757 = meta47757;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async47756.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_47758,meta47757__$1){
var self__ = this;
var _47758__$1 = this;
return (new cljs.core.async.t_cljs$core$async47756(self__.ch,self__.cs,meta47757__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async47756.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_47758){
var self__ = this;
var _47758__$1 = this;
return self__.meta47757;
});})(cs))
;


cljs.core.async.t_cljs$core$async47756.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async47756.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async47756.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async47756.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async47756.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async47756.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47756.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47757","meta47757",-2104093305,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async47756.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47756.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47756";

cljs.core.async.t_cljs$core$async47756.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async47756");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async47756 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async47756(ch__$1,cs__$1,meta47757){
return (new cljs.core.async.t_cljs$core$async47756(ch__$1,cs__$1,meta47757));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async47756(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__47173__auto___47978 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___47978,cs,m,dchan,dctr,done){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___47978,cs,m,dchan,dctr,done){
return (function (state_47893){
var state_val_47894 = (state_47893[(1)]);
if((state_val_47894 === (7))){
var inst_47889 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47895_47979 = state_47893__$1;
(statearr_47895_47979[(2)] = inst_47889);

(statearr_47895_47979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (20))){
var inst_47792 = (state_47893[(7)]);
var inst_47804 = cljs.core.first.call(null,inst_47792);
var inst_47805 = cljs.core.nth.call(null,inst_47804,(0),null);
var inst_47806 = cljs.core.nth.call(null,inst_47804,(1),null);
var state_47893__$1 = (function (){var statearr_47896 = state_47893;
(statearr_47896[(8)] = inst_47805);

return statearr_47896;
})();
if(cljs.core.truth_(inst_47806)){
var statearr_47897_47980 = state_47893__$1;
(statearr_47897_47980[(1)] = (22));

} else {
var statearr_47898_47981 = state_47893__$1;
(statearr_47898_47981[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (27))){
var inst_47834 = (state_47893[(9)]);
var inst_47836 = (state_47893[(10)]);
var inst_47841 = (state_47893[(11)]);
var inst_47761 = (state_47893[(12)]);
var inst_47841__$1 = cljs.core._nth.call(null,inst_47834,inst_47836);
var inst_47842 = cljs.core.async.put_BANG_.call(null,inst_47841__$1,inst_47761,done);
var state_47893__$1 = (function (){var statearr_47899 = state_47893;
(statearr_47899[(11)] = inst_47841__$1);

return statearr_47899;
})();
if(cljs.core.truth_(inst_47842)){
var statearr_47900_47982 = state_47893__$1;
(statearr_47900_47982[(1)] = (30));

} else {
var statearr_47901_47983 = state_47893__$1;
(statearr_47901_47983[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (1))){
var state_47893__$1 = state_47893;
var statearr_47902_47984 = state_47893__$1;
(statearr_47902_47984[(2)] = null);

(statearr_47902_47984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (24))){
var inst_47792 = (state_47893[(7)]);
var inst_47811 = (state_47893[(2)]);
var inst_47812 = cljs.core.next.call(null,inst_47792);
var inst_47770 = inst_47812;
var inst_47771 = null;
var inst_47772 = (0);
var inst_47773 = (0);
var state_47893__$1 = (function (){var statearr_47903 = state_47893;
(statearr_47903[(13)] = inst_47811);

(statearr_47903[(14)] = inst_47773);

(statearr_47903[(15)] = inst_47772);

(statearr_47903[(16)] = inst_47771);

(statearr_47903[(17)] = inst_47770);

return statearr_47903;
})();
var statearr_47904_47985 = state_47893__$1;
(statearr_47904_47985[(2)] = null);

(statearr_47904_47985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (39))){
var state_47893__$1 = state_47893;
var statearr_47908_47986 = state_47893__$1;
(statearr_47908_47986[(2)] = null);

(statearr_47908_47986[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (4))){
var inst_47761 = (state_47893[(12)]);
var inst_47761__$1 = (state_47893[(2)]);
var inst_47762 = (inst_47761__$1 == null);
var state_47893__$1 = (function (){var statearr_47909 = state_47893;
(statearr_47909[(12)] = inst_47761__$1);

return statearr_47909;
})();
if(cljs.core.truth_(inst_47762)){
var statearr_47910_47987 = state_47893__$1;
(statearr_47910_47987[(1)] = (5));

} else {
var statearr_47911_47988 = state_47893__$1;
(statearr_47911_47988[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (15))){
var inst_47773 = (state_47893[(14)]);
var inst_47772 = (state_47893[(15)]);
var inst_47771 = (state_47893[(16)]);
var inst_47770 = (state_47893[(17)]);
var inst_47788 = (state_47893[(2)]);
var inst_47789 = (inst_47773 + (1));
var tmp47905 = inst_47772;
var tmp47906 = inst_47771;
var tmp47907 = inst_47770;
var inst_47770__$1 = tmp47907;
var inst_47771__$1 = tmp47906;
var inst_47772__$1 = tmp47905;
var inst_47773__$1 = inst_47789;
var state_47893__$1 = (function (){var statearr_47912 = state_47893;
(statearr_47912[(14)] = inst_47773__$1);

(statearr_47912[(15)] = inst_47772__$1);

(statearr_47912[(16)] = inst_47771__$1);

(statearr_47912[(17)] = inst_47770__$1);

(statearr_47912[(18)] = inst_47788);

return statearr_47912;
})();
var statearr_47913_47989 = state_47893__$1;
(statearr_47913_47989[(2)] = null);

(statearr_47913_47989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (21))){
var inst_47815 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47917_47990 = state_47893__$1;
(statearr_47917_47990[(2)] = inst_47815);

(statearr_47917_47990[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (31))){
var inst_47841 = (state_47893[(11)]);
var inst_47845 = done.call(null,null);
var inst_47846 = cljs.core.async.untap_STAR_.call(null,m,inst_47841);
var state_47893__$1 = (function (){var statearr_47918 = state_47893;
(statearr_47918[(19)] = inst_47845);

return statearr_47918;
})();
var statearr_47919_47991 = state_47893__$1;
(statearr_47919_47991[(2)] = inst_47846);

(statearr_47919_47991[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (32))){
var inst_47834 = (state_47893[(9)]);
var inst_47835 = (state_47893[(20)]);
var inst_47836 = (state_47893[(10)]);
var inst_47833 = (state_47893[(21)]);
var inst_47848 = (state_47893[(2)]);
var inst_47849 = (inst_47836 + (1));
var tmp47914 = inst_47834;
var tmp47915 = inst_47835;
var tmp47916 = inst_47833;
var inst_47833__$1 = tmp47916;
var inst_47834__$1 = tmp47914;
var inst_47835__$1 = tmp47915;
var inst_47836__$1 = inst_47849;
var state_47893__$1 = (function (){var statearr_47920 = state_47893;
(statearr_47920[(9)] = inst_47834__$1);

(statearr_47920[(20)] = inst_47835__$1);

(statearr_47920[(10)] = inst_47836__$1);

(statearr_47920[(21)] = inst_47833__$1);

(statearr_47920[(22)] = inst_47848);

return statearr_47920;
})();
var statearr_47921_47992 = state_47893__$1;
(statearr_47921_47992[(2)] = null);

(statearr_47921_47992[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (40))){
var inst_47861 = (state_47893[(23)]);
var inst_47865 = done.call(null,null);
var inst_47866 = cljs.core.async.untap_STAR_.call(null,m,inst_47861);
var state_47893__$1 = (function (){var statearr_47922 = state_47893;
(statearr_47922[(24)] = inst_47865);

return statearr_47922;
})();
var statearr_47923_47993 = state_47893__$1;
(statearr_47923_47993[(2)] = inst_47866);

(statearr_47923_47993[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (33))){
var inst_47852 = (state_47893[(25)]);
var inst_47854 = cljs.core.chunked_seq_QMARK_.call(null,inst_47852);
var state_47893__$1 = state_47893;
if(inst_47854){
var statearr_47924_47994 = state_47893__$1;
(statearr_47924_47994[(1)] = (36));

} else {
var statearr_47925_47995 = state_47893__$1;
(statearr_47925_47995[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (13))){
var inst_47782 = (state_47893[(26)]);
var inst_47785 = cljs.core.async.close_BANG_.call(null,inst_47782);
var state_47893__$1 = state_47893;
var statearr_47926_47996 = state_47893__$1;
(statearr_47926_47996[(2)] = inst_47785);

(statearr_47926_47996[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (22))){
var inst_47805 = (state_47893[(8)]);
var inst_47808 = cljs.core.async.close_BANG_.call(null,inst_47805);
var state_47893__$1 = state_47893;
var statearr_47927_47997 = state_47893__$1;
(statearr_47927_47997[(2)] = inst_47808);

(statearr_47927_47997[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (36))){
var inst_47852 = (state_47893[(25)]);
var inst_47856 = cljs.core.chunk_first.call(null,inst_47852);
var inst_47857 = cljs.core.chunk_rest.call(null,inst_47852);
var inst_47858 = cljs.core.count.call(null,inst_47856);
var inst_47833 = inst_47857;
var inst_47834 = inst_47856;
var inst_47835 = inst_47858;
var inst_47836 = (0);
var state_47893__$1 = (function (){var statearr_47928 = state_47893;
(statearr_47928[(9)] = inst_47834);

(statearr_47928[(20)] = inst_47835);

(statearr_47928[(10)] = inst_47836);

(statearr_47928[(21)] = inst_47833);

return statearr_47928;
})();
var statearr_47929_47998 = state_47893__$1;
(statearr_47929_47998[(2)] = null);

(statearr_47929_47998[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (41))){
var inst_47852 = (state_47893[(25)]);
var inst_47868 = (state_47893[(2)]);
var inst_47869 = cljs.core.next.call(null,inst_47852);
var inst_47833 = inst_47869;
var inst_47834 = null;
var inst_47835 = (0);
var inst_47836 = (0);
var state_47893__$1 = (function (){var statearr_47930 = state_47893;
(statearr_47930[(9)] = inst_47834);

(statearr_47930[(20)] = inst_47835);

(statearr_47930[(10)] = inst_47836);

(statearr_47930[(21)] = inst_47833);

(statearr_47930[(27)] = inst_47868);

return statearr_47930;
})();
var statearr_47931_47999 = state_47893__$1;
(statearr_47931_47999[(2)] = null);

(statearr_47931_47999[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (43))){
var state_47893__$1 = state_47893;
var statearr_47932_48000 = state_47893__$1;
(statearr_47932_48000[(2)] = null);

(statearr_47932_48000[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (29))){
var inst_47877 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47933_48001 = state_47893__$1;
(statearr_47933_48001[(2)] = inst_47877);

(statearr_47933_48001[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (44))){
var inst_47886 = (state_47893[(2)]);
var state_47893__$1 = (function (){var statearr_47934 = state_47893;
(statearr_47934[(28)] = inst_47886);

return statearr_47934;
})();
var statearr_47935_48002 = state_47893__$1;
(statearr_47935_48002[(2)] = null);

(statearr_47935_48002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (6))){
var inst_47825 = (state_47893[(29)]);
var inst_47824 = cljs.core.deref.call(null,cs);
var inst_47825__$1 = cljs.core.keys.call(null,inst_47824);
var inst_47826 = cljs.core.count.call(null,inst_47825__$1);
var inst_47827 = cljs.core.reset_BANG_.call(null,dctr,inst_47826);
var inst_47832 = cljs.core.seq.call(null,inst_47825__$1);
var inst_47833 = inst_47832;
var inst_47834 = null;
var inst_47835 = (0);
var inst_47836 = (0);
var state_47893__$1 = (function (){var statearr_47936 = state_47893;
(statearr_47936[(9)] = inst_47834);

(statearr_47936[(20)] = inst_47835);

(statearr_47936[(10)] = inst_47836);

(statearr_47936[(30)] = inst_47827);

(statearr_47936[(21)] = inst_47833);

(statearr_47936[(29)] = inst_47825__$1);

return statearr_47936;
})();
var statearr_47937_48003 = state_47893__$1;
(statearr_47937_48003[(2)] = null);

(statearr_47937_48003[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (28))){
var inst_47852 = (state_47893[(25)]);
var inst_47833 = (state_47893[(21)]);
var inst_47852__$1 = cljs.core.seq.call(null,inst_47833);
var state_47893__$1 = (function (){var statearr_47938 = state_47893;
(statearr_47938[(25)] = inst_47852__$1);

return statearr_47938;
})();
if(inst_47852__$1){
var statearr_47939_48004 = state_47893__$1;
(statearr_47939_48004[(1)] = (33));

} else {
var statearr_47940_48005 = state_47893__$1;
(statearr_47940_48005[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (25))){
var inst_47835 = (state_47893[(20)]);
var inst_47836 = (state_47893[(10)]);
var inst_47838 = (inst_47836 < inst_47835);
var inst_47839 = inst_47838;
var state_47893__$1 = state_47893;
if(cljs.core.truth_(inst_47839)){
var statearr_47941_48006 = state_47893__$1;
(statearr_47941_48006[(1)] = (27));

} else {
var statearr_47942_48007 = state_47893__$1;
(statearr_47942_48007[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (34))){
var state_47893__$1 = state_47893;
var statearr_47943_48008 = state_47893__$1;
(statearr_47943_48008[(2)] = null);

(statearr_47943_48008[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (17))){
var state_47893__$1 = state_47893;
var statearr_47944_48009 = state_47893__$1;
(statearr_47944_48009[(2)] = null);

(statearr_47944_48009[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (3))){
var inst_47891 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47893__$1,inst_47891);
} else {
if((state_val_47894 === (12))){
var inst_47820 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47945_48010 = state_47893__$1;
(statearr_47945_48010[(2)] = inst_47820);

(statearr_47945_48010[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (2))){
var state_47893__$1 = state_47893;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47893__$1,(4),ch);
} else {
if((state_val_47894 === (23))){
var state_47893__$1 = state_47893;
var statearr_47946_48011 = state_47893__$1;
(statearr_47946_48011[(2)] = null);

(statearr_47946_48011[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (35))){
var inst_47875 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47947_48012 = state_47893__$1;
(statearr_47947_48012[(2)] = inst_47875);

(statearr_47947_48012[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (19))){
var inst_47792 = (state_47893[(7)]);
var inst_47796 = cljs.core.chunk_first.call(null,inst_47792);
var inst_47797 = cljs.core.chunk_rest.call(null,inst_47792);
var inst_47798 = cljs.core.count.call(null,inst_47796);
var inst_47770 = inst_47797;
var inst_47771 = inst_47796;
var inst_47772 = inst_47798;
var inst_47773 = (0);
var state_47893__$1 = (function (){var statearr_47948 = state_47893;
(statearr_47948[(14)] = inst_47773);

(statearr_47948[(15)] = inst_47772);

(statearr_47948[(16)] = inst_47771);

(statearr_47948[(17)] = inst_47770);

return statearr_47948;
})();
var statearr_47949_48013 = state_47893__$1;
(statearr_47949_48013[(2)] = null);

(statearr_47949_48013[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (11))){
var inst_47792 = (state_47893[(7)]);
var inst_47770 = (state_47893[(17)]);
var inst_47792__$1 = cljs.core.seq.call(null,inst_47770);
var state_47893__$1 = (function (){var statearr_47950 = state_47893;
(statearr_47950[(7)] = inst_47792__$1);

return statearr_47950;
})();
if(inst_47792__$1){
var statearr_47951_48014 = state_47893__$1;
(statearr_47951_48014[(1)] = (16));

} else {
var statearr_47952_48015 = state_47893__$1;
(statearr_47952_48015[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (9))){
var inst_47822 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47953_48016 = state_47893__$1;
(statearr_47953_48016[(2)] = inst_47822);

(statearr_47953_48016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (5))){
var inst_47768 = cljs.core.deref.call(null,cs);
var inst_47769 = cljs.core.seq.call(null,inst_47768);
var inst_47770 = inst_47769;
var inst_47771 = null;
var inst_47772 = (0);
var inst_47773 = (0);
var state_47893__$1 = (function (){var statearr_47954 = state_47893;
(statearr_47954[(14)] = inst_47773);

(statearr_47954[(15)] = inst_47772);

(statearr_47954[(16)] = inst_47771);

(statearr_47954[(17)] = inst_47770);

return statearr_47954;
})();
var statearr_47955_48017 = state_47893__$1;
(statearr_47955_48017[(2)] = null);

(statearr_47955_48017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (14))){
var state_47893__$1 = state_47893;
var statearr_47956_48018 = state_47893__$1;
(statearr_47956_48018[(2)] = null);

(statearr_47956_48018[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (45))){
var inst_47883 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47957_48019 = state_47893__$1;
(statearr_47957_48019[(2)] = inst_47883);

(statearr_47957_48019[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (26))){
var inst_47825 = (state_47893[(29)]);
var inst_47879 = (state_47893[(2)]);
var inst_47880 = cljs.core.seq.call(null,inst_47825);
var state_47893__$1 = (function (){var statearr_47958 = state_47893;
(statearr_47958[(31)] = inst_47879);

return statearr_47958;
})();
if(inst_47880){
var statearr_47959_48020 = state_47893__$1;
(statearr_47959_48020[(1)] = (42));

} else {
var statearr_47960_48021 = state_47893__$1;
(statearr_47960_48021[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (16))){
var inst_47792 = (state_47893[(7)]);
var inst_47794 = cljs.core.chunked_seq_QMARK_.call(null,inst_47792);
var state_47893__$1 = state_47893;
if(inst_47794){
var statearr_47961_48022 = state_47893__$1;
(statearr_47961_48022[(1)] = (19));

} else {
var statearr_47962_48023 = state_47893__$1;
(statearr_47962_48023[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (38))){
var inst_47872 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47963_48024 = state_47893__$1;
(statearr_47963_48024[(2)] = inst_47872);

(statearr_47963_48024[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (30))){
var state_47893__$1 = state_47893;
var statearr_47964_48025 = state_47893__$1;
(statearr_47964_48025[(2)] = null);

(statearr_47964_48025[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (10))){
var inst_47773 = (state_47893[(14)]);
var inst_47771 = (state_47893[(16)]);
var inst_47781 = cljs.core._nth.call(null,inst_47771,inst_47773);
var inst_47782 = cljs.core.nth.call(null,inst_47781,(0),null);
var inst_47783 = cljs.core.nth.call(null,inst_47781,(1),null);
var state_47893__$1 = (function (){var statearr_47965 = state_47893;
(statearr_47965[(26)] = inst_47782);

return statearr_47965;
})();
if(cljs.core.truth_(inst_47783)){
var statearr_47966_48026 = state_47893__$1;
(statearr_47966_48026[(1)] = (13));

} else {
var statearr_47967_48027 = state_47893__$1;
(statearr_47967_48027[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (18))){
var inst_47818 = (state_47893[(2)]);
var state_47893__$1 = state_47893;
var statearr_47968_48028 = state_47893__$1;
(statearr_47968_48028[(2)] = inst_47818);

(statearr_47968_48028[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (42))){
var state_47893__$1 = state_47893;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47893__$1,(45),dchan);
} else {
if((state_val_47894 === (37))){
var inst_47852 = (state_47893[(25)]);
var inst_47761 = (state_47893[(12)]);
var inst_47861 = (state_47893[(23)]);
var inst_47861__$1 = cljs.core.first.call(null,inst_47852);
var inst_47862 = cljs.core.async.put_BANG_.call(null,inst_47861__$1,inst_47761,done);
var state_47893__$1 = (function (){var statearr_47969 = state_47893;
(statearr_47969[(23)] = inst_47861__$1);

return statearr_47969;
})();
if(cljs.core.truth_(inst_47862)){
var statearr_47970_48029 = state_47893__$1;
(statearr_47970_48029[(1)] = (39));

} else {
var statearr_47971_48030 = state_47893__$1;
(statearr_47971_48030[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47894 === (8))){
var inst_47773 = (state_47893[(14)]);
var inst_47772 = (state_47893[(15)]);
var inst_47775 = (inst_47773 < inst_47772);
var inst_47776 = inst_47775;
var state_47893__$1 = state_47893;
if(cljs.core.truth_(inst_47776)){
var statearr_47972_48031 = state_47893__$1;
(statearr_47972_48031[(1)] = (10));

} else {
var statearr_47973_48032 = state_47893__$1;
(statearr_47973_48032[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___47978,cs,m,dchan,dctr,done))
;
return ((function (switch__47085__auto__,c__47173__auto___47978,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__47086__auto__ = null;
var cljs$core$async$mult_$_state_machine__47086__auto____0 = (function (){
var statearr_47974 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47974[(0)] = cljs$core$async$mult_$_state_machine__47086__auto__);

(statearr_47974[(1)] = (1));

return statearr_47974;
});
var cljs$core$async$mult_$_state_machine__47086__auto____1 = (function (state_47893){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_47893);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e47975){if((e47975 instanceof Object)){
var ex__47089__auto__ = e47975;
var statearr_47976_48033 = state_47893;
(statearr_47976_48033[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47893);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47975;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48034 = state_47893;
state_47893 = G__48034;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__47086__auto__ = function(state_47893){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__47086__auto____1.call(this,state_47893);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__47086__auto____0;
cljs$core$async$mult_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__47086__auto____1;
return cljs$core$async$mult_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___47978,cs,m,dchan,dctr,done))
})();
var state__47175__auto__ = (function (){var statearr_47977 = f__47174__auto__.call(null);
(statearr_47977[(6)] = c__47173__auto___47978);

return statearr_47977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___47978,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__48036 = arguments.length;
switch (G__48036) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m);
} else {
var m__28825__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,state_map);
} else {
var m__28825__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,mode);
} else {
var m__28825__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29320__auto__ = [];
var len__29313__auto___48048 = arguments.length;
var i__29314__auto___48049 = (0);
while(true){
if((i__29314__auto___48049 < len__29313__auto___48048)){
args__29320__auto__.push((arguments[i__29314__auto___48049]));

var G__48050 = (i__29314__auto___48049 + (1));
i__29314__auto___48049 = G__48050;
continue;
} else {
}
break;
}

var argseq__29321__auto__ = ((((3) < args__29320__auto__.length))?(new cljs.core.IndexedSeq(args__29320__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29321__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__48042){
var map__48043 = p__48042;
var map__48043__$1 = ((((!((map__48043 == null)))?((((map__48043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48043.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48043):map__48043);
var opts = map__48043__$1;
var statearr_48045_48051 = state;
(statearr_48045_48051[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__48043,map__48043__$1,opts){
return (function (val){
var statearr_48046_48052 = state;
(statearr_48046_48052[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__48043,map__48043__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_48047_48053 = state;
(statearr_48047_48053[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq48038){
var G__48039 = cljs.core.first.call(null,seq48038);
var seq48038__$1 = cljs.core.next.call(null,seq48038);
var G__48040 = cljs.core.first.call(null,seq48038__$1);
var seq48038__$2 = cljs.core.next.call(null,seq48038__$1);
var G__48041 = cljs.core.first.call(null,seq48038__$2);
var seq48038__$3 = cljs.core.next.call(null,seq48038__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__48039,G__48040,G__48041,seq48038__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async48054 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48054 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta48055){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta48055 = meta48055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_48056,meta48055__$1){
var self__ = this;
var _48056__$1 = this;
return (new cljs.core.async.t_cljs$core$async48054(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta48055__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_48056){
var self__ = this;
var _48056__$1 = this;
return self__.meta48055;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async48054.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48054.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta48055","meta48055",719240838,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48054.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48054.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48054";

cljs.core.async.t_cljs$core$async48054.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async48054");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async48054 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async48054(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta48055){
return (new cljs.core.async.t_cljs$core$async48054(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta48055));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async48054(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47173__auto___48218 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___48218,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___48218,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_48158){
var state_val_48159 = (state_48158[(1)]);
if((state_val_48159 === (7))){
var inst_48073 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
var statearr_48160_48219 = state_48158__$1;
(statearr_48160_48219[(2)] = inst_48073);

(statearr_48160_48219[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (20))){
var inst_48085 = (state_48158[(7)]);
var state_48158__$1 = state_48158;
var statearr_48161_48220 = state_48158__$1;
(statearr_48161_48220[(2)] = inst_48085);

(statearr_48161_48220[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (27))){
var state_48158__$1 = state_48158;
var statearr_48162_48221 = state_48158__$1;
(statearr_48162_48221[(2)] = null);

(statearr_48162_48221[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (1))){
var inst_48060 = (state_48158[(8)]);
var inst_48060__$1 = calc_state.call(null);
var inst_48062 = (inst_48060__$1 == null);
var inst_48063 = cljs.core.not.call(null,inst_48062);
var state_48158__$1 = (function (){var statearr_48163 = state_48158;
(statearr_48163[(8)] = inst_48060__$1);

return statearr_48163;
})();
if(inst_48063){
var statearr_48164_48222 = state_48158__$1;
(statearr_48164_48222[(1)] = (2));

} else {
var statearr_48165_48223 = state_48158__$1;
(statearr_48165_48223[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (24))){
var inst_48132 = (state_48158[(9)]);
var inst_48118 = (state_48158[(10)]);
var inst_48109 = (state_48158[(11)]);
var inst_48132__$1 = inst_48109.call(null,inst_48118);
var state_48158__$1 = (function (){var statearr_48166 = state_48158;
(statearr_48166[(9)] = inst_48132__$1);

return statearr_48166;
})();
if(cljs.core.truth_(inst_48132__$1)){
var statearr_48167_48224 = state_48158__$1;
(statearr_48167_48224[(1)] = (29));

} else {
var statearr_48168_48225 = state_48158__$1;
(statearr_48168_48225[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (4))){
var inst_48076 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
if(cljs.core.truth_(inst_48076)){
var statearr_48169_48226 = state_48158__$1;
(statearr_48169_48226[(1)] = (8));

} else {
var statearr_48170_48227 = state_48158__$1;
(statearr_48170_48227[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (15))){
var inst_48103 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
if(cljs.core.truth_(inst_48103)){
var statearr_48171_48228 = state_48158__$1;
(statearr_48171_48228[(1)] = (19));

} else {
var statearr_48172_48229 = state_48158__$1;
(statearr_48172_48229[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (21))){
var inst_48108 = (state_48158[(12)]);
var inst_48108__$1 = (state_48158[(2)]);
var inst_48109 = cljs.core.get.call(null,inst_48108__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48110 = cljs.core.get.call(null,inst_48108__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48111 = cljs.core.get.call(null,inst_48108__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_48158__$1 = (function (){var statearr_48173 = state_48158;
(statearr_48173[(12)] = inst_48108__$1);

(statearr_48173[(11)] = inst_48109);

(statearr_48173[(13)] = inst_48110);

return statearr_48173;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_48158__$1,(22),inst_48111);
} else {
if((state_val_48159 === (31))){
var inst_48140 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
if(cljs.core.truth_(inst_48140)){
var statearr_48174_48230 = state_48158__$1;
(statearr_48174_48230[(1)] = (32));

} else {
var statearr_48175_48231 = state_48158__$1;
(statearr_48175_48231[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (32))){
var inst_48117 = (state_48158[(14)]);
var state_48158__$1 = state_48158;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48158__$1,(35),out,inst_48117);
} else {
if((state_val_48159 === (33))){
var inst_48108 = (state_48158[(12)]);
var inst_48085 = inst_48108;
var state_48158__$1 = (function (){var statearr_48176 = state_48158;
(statearr_48176[(7)] = inst_48085);

return statearr_48176;
})();
var statearr_48177_48232 = state_48158__$1;
(statearr_48177_48232[(2)] = null);

(statearr_48177_48232[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (13))){
var inst_48085 = (state_48158[(7)]);
var inst_48092 = inst_48085.cljs$lang$protocol_mask$partition0$;
var inst_48093 = (inst_48092 & (64));
var inst_48094 = inst_48085.cljs$core$ISeq$;
var inst_48095 = (cljs.core.PROTOCOL_SENTINEL === inst_48094);
var inst_48096 = (inst_48093) || (inst_48095);
var state_48158__$1 = state_48158;
if(cljs.core.truth_(inst_48096)){
var statearr_48178_48233 = state_48158__$1;
(statearr_48178_48233[(1)] = (16));

} else {
var statearr_48179_48234 = state_48158__$1;
(statearr_48179_48234[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (22))){
var inst_48117 = (state_48158[(14)]);
var inst_48118 = (state_48158[(10)]);
var inst_48116 = (state_48158[(2)]);
var inst_48117__$1 = cljs.core.nth.call(null,inst_48116,(0),null);
var inst_48118__$1 = cljs.core.nth.call(null,inst_48116,(1),null);
var inst_48119 = (inst_48117__$1 == null);
var inst_48120 = cljs.core._EQ_.call(null,inst_48118__$1,change);
var inst_48121 = (inst_48119) || (inst_48120);
var state_48158__$1 = (function (){var statearr_48180 = state_48158;
(statearr_48180[(14)] = inst_48117__$1);

(statearr_48180[(10)] = inst_48118__$1);

return statearr_48180;
})();
if(cljs.core.truth_(inst_48121)){
var statearr_48181_48235 = state_48158__$1;
(statearr_48181_48235[(1)] = (23));

} else {
var statearr_48182_48236 = state_48158__$1;
(statearr_48182_48236[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (36))){
var inst_48108 = (state_48158[(12)]);
var inst_48085 = inst_48108;
var state_48158__$1 = (function (){var statearr_48183 = state_48158;
(statearr_48183[(7)] = inst_48085);

return statearr_48183;
})();
var statearr_48184_48237 = state_48158__$1;
(statearr_48184_48237[(2)] = null);

(statearr_48184_48237[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (29))){
var inst_48132 = (state_48158[(9)]);
var state_48158__$1 = state_48158;
var statearr_48185_48238 = state_48158__$1;
(statearr_48185_48238[(2)] = inst_48132);

(statearr_48185_48238[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (6))){
var state_48158__$1 = state_48158;
var statearr_48186_48239 = state_48158__$1;
(statearr_48186_48239[(2)] = false);

(statearr_48186_48239[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (28))){
var inst_48128 = (state_48158[(2)]);
var inst_48129 = calc_state.call(null);
var inst_48085 = inst_48129;
var state_48158__$1 = (function (){var statearr_48187 = state_48158;
(statearr_48187[(15)] = inst_48128);

(statearr_48187[(7)] = inst_48085);

return statearr_48187;
})();
var statearr_48188_48240 = state_48158__$1;
(statearr_48188_48240[(2)] = null);

(statearr_48188_48240[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (25))){
var inst_48154 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
var statearr_48189_48241 = state_48158__$1;
(statearr_48189_48241[(2)] = inst_48154);

(statearr_48189_48241[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (34))){
var inst_48152 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
var statearr_48190_48242 = state_48158__$1;
(statearr_48190_48242[(2)] = inst_48152);

(statearr_48190_48242[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (17))){
var state_48158__$1 = state_48158;
var statearr_48191_48243 = state_48158__$1;
(statearr_48191_48243[(2)] = false);

(statearr_48191_48243[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (3))){
var state_48158__$1 = state_48158;
var statearr_48192_48244 = state_48158__$1;
(statearr_48192_48244[(2)] = false);

(statearr_48192_48244[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (12))){
var inst_48156 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48158__$1,inst_48156);
} else {
if((state_val_48159 === (2))){
var inst_48060 = (state_48158[(8)]);
var inst_48065 = inst_48060.cljs$lang$protocol_mask$partition0$;
var inst_48066 = (inst_48065 & (64));
var inst_48067 = inst_48060.cljs$core$ISeq$;
var inst_48068 = (cljs.core.PROTOCOL_SENTINEL === inst_48067);
var inst_48069 = (inst_48066) || (inst_48068);
var state_48158__$1 = state_48158;
if(cljs.core.truth_(inst_48069)){
var statearr_48193_48245 = state_48158__$1;
(statearr_48193_48245[(1)] = (5));

} else {
var statearr_48194_48246 = state_48158__$1;
(statearr_48194_48246[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (23))){
var inst_48117 = (state_48158[(14)]);
var inst_48123 = (inst_48117 == null);
var state_48158__$1 = state_48158;
if(cljs.core.truth_(inst_48123)){
var statearr_48195_48247 = state_48158__$1;
(statearr_48195_48247[(1)] = (26));

} else {
var statearr_48196_48248 = state_48158__$1;
(statearr_48196_48248[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (35))){
var inst_48143 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
if(cljs.core.truth_(inst_48143)){
var statearr_48197_48249 = state_48158__$1;
(statearr_48197_48249[(1)] = (36));

} else {
var statearr_48198_48250 = state_48158__$1;
(statearr_48198_48250[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (19))){
var inst_48085 = (state_48158[(7)]);
var inst_48105 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48085);
var state_48158__$1 = state_48158;
var statearr_48199_48251 = state_48158__$1;
(statearr_48199_48251[(2)] = inst_48105);

(statearr_48199_48251[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (11))){
var inst_48085 = (state_48158[(7)]);
var inst_48089 = (inst_48085 == null);
var inst_48090 = cljs.core.not.call(null,inst_48089);
var state_48158__$1 = state_48158;
if(inst_48090){
var statearr_48200_48252 = state_48158__$1;
(statearr_48200_48252[(1)] = (13));

} else {
var statearr_48201_48253 = state_48158__$1;
(statearr_48201_48253[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (9))){
var inst_48060 = (state_48158[(8)]);
var state_48158__$1 = state_48158;
var statearr_48202_48254 = state_48158__$1;
(statearr_48202_48254[(2)] = inst_48060);

(statearr_48202_48254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (5))){
var state_48158__$1 = state_48158;
var statearr_48203_48255 = state_48158__$1;
(statearr_48203_48255[(2)] = true);

(statearr_48203_48255[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (14))){
var state_48158__$1 = state_48158;
var statearr_48204_48256 = state_48158__$1;
(statearr_48204_48256[(2)] = false);

(statearr_48204_48256[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (26))){
var inst_48118 = (state_48158[(10)]);
var inst_48125 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_48118);
var state_48158__$1 = state_48158;
var statearr_48205_48257 = state_48158__$1;
(statearr_48205_48257[(2)] = inst_48125);

(statearr_48205_48257[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (16))){
var state_48158__$1 = state_48158;
var statearr_48206_48258 = state_48158__$1;
(statearr_48206_48258[(2)] = true);

(statearr_48206_48258[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (38))){
var inst_48148 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
var statearr_48207_48259 = state_48158__$1;
(statearr_48207_48259[(2)] = inst_48148);

(statearr_48207_48259[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (30))){
var inst_48118 = (state_48158[(10)]);
var inst_48109 = (state_48158[(11)]);
var inst_48110 = (state_48158[(13)]);
var inst_48135 = cljs.core.empty_QMARK_.call(null,inst_48109);
var inst_48136 = inst_48110.call(null,inst_48118);
var inst_48137 = cljs.core.not.call(null,inst_48136);
var inst_48138 = (inst_48135) && (inst_48137);
var state_48158__$1 = state_48158;
var statearr_48208_48260 = state_48158__$1;
(statearr_48208_48260[(2)] = inst_48138);

(statearr_48208_48260[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (10))){
var inst_48060 = (state_48158[(8)]);
var inst_48081 = (state_48158[(2)]);
var inst_48082 = cljs.core.get.call(null,inst_48081,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48083 = cljs.core.get.call(null,inst_48081,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48084 = cljs.core.get.call(null,inst_48081,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_48085 = inst_48060;
var state_48158__$1 = (function (){var statearr_48209 = state_48158;
(statearr_48209[(16)] = inst_48083);

(statearr_48209[(17)] = inst_48082);

(statearr_48209[(18)] = inst_48084);

(statearr_48209[(7)] = inst_48085);

return statearr_48209;
})();
var statearr_48210_48261 = state_48158__$1;
(statearr_48210_48261[(2)] = null);

(statearr_48210_48261[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (18))){
var inst_48100 = (state_48158[(2)]);
var state_48158__$1 = state_48158;
var statearr_48211_48262 = state_48158__$1;
(statearr_48211_48262[(2)] = inst_48100);

(statearr_48211_48262[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (37))){
var state_48158__$1 = state_48158;
var statearr_48212_48263 = state_48158__$1;
(statearr_48212_48263[(2)] = null);

(statearr_48212_48263[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48159 === (8))){
var inst_48060 = (state_48158[(8)]);
var inst_48078 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48060);
var state_48158__$1 = state_48158;
var statearr_48213_48264 = state_48158__$1;
(statearr_48213_48264[(2)] = inst_48078);

(statearr_48213_48264[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___48218,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__47085__auto__,c__47173__auto___48218,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__47086__auto__ = null;
var cljs$core$async$mix_$_state_machine__47086__auto____0 = (function (){
var statearr_48214 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48214[(0)] = cljs$core$async$mix_$_state_machine__47086__auto__);

(statearr_48214[(1)] = (1));

return statearr_48214;
});
var cljs$core$async$mix_$_state_machine__47086__auto____1 = (function (state_48158){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48158);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48215){if((e48215 instanceof Object)){
var ex__47089__auto__ = e48215;
var statearr_48216_48265 = state_48158;
(statearr_48216_48265[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48158);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48215;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48266 = state_48158;
state_48158 = G__48266;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__47086__auto__ = function(state_48158){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__47086__auto____1.call(this,state_48158);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__47086__auto____0;
cljs$core$async$mix_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__47086__auto____1;
return cljs$core$async$mix_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___48218,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__47175__auto__ = (function (){var statearr_48217 = f__47174__auto__.call(null);
(statearr_48217[(6)] = c__47173__auto___48218);

return statearr_48217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___48218,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28825__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__48268 = arguments.length;
switch (G__48268) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__48272 = arguments.length;
switch (G__48272) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28141__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28141__auto__,mults){
return (function (p1__48270_SHARP_){
if(cljs.core.truth_(p1__48270_SHARP_.call(null,topic))){
return p1__48270_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__48270_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28141__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async48273 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48273 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta48274){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta48274 = meta48274;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_48275,meta48274__$1){
var self__ = this;
var _48275__$1 = this;
return (new cljs.core.async.t_cljs$core$async48273(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta48274__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_48275){
var self__ = this;
var _48275__$1 = this;
return self__.meta48274;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async48273.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48273.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta48274","meta48274",-1969597975,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48273.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48273.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48273";

cljs.core.async.t_cljs$core$async48273.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async48273");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async48273 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async48273(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48274){
return (new cljs.core.async.t_cljs$core$async48273(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48274));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async48273(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47173__auto___48393 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___48393,mults,ensure_mult,p){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___48393,mults,ensure_mult,p){
return (function (state_48347){
var state_val_48348 = (state_48347[(1)]);
if((state_val_48348 === (7))){
var inst_48343 = (state_48347[(2)]);
var state_48347__$1 = state_48347;
var statearr_48349_48394 = state_48347__$1;
(statearr_48349_48394[(2)] = inst_48343);

(statearr_48349_48394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (20))){
var state_48347__$1 = state_48347;
var statearr_48350_48395 = state_48347__$1;
(statearr_48350_48395[(2)] = null);

(statearr_48350_48395[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (1))){
var state_48347__$1 = state_48347;
var statearr_48351_48396 = state_48347__$1;
(statearr_48351_48396[(2)] = null);

(statearr_48351_48396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (24))){
var inst_48326 = (state_48347[(7)]);
var inst_48335 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_48326);
var state_48347__$1 = state_48347;
var statearr_48352_48397 = state_48347__$1;
(statearr_48352_48397[(2)] = inst_48335);

(statearr_48352_48397[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (4))){
var inst_48278 = (state_48347[(8)]);
var inst_48278__$1 = (state_48347[(2)]);
var inst_48279 = (inst_48278__$1 == null);
var state_48347__$1 = (function (){var statearr_48353 = state_48347;
(statearr_48353[(8)] = inst_48278__$1);

return statearr_48353;
})();
if(cljs.core.truth_(inst_48279)){
var statearr_48354_48398 = state_48347__$1;
(statearr_48354_48398[(1)] = (5));

} else {
var statearr_48355_48399 = state_48347__$1;
(statearr_48355_48399[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (15))){
var inst_48320 = (state_48347[(2)]);
var state_48347__$1 = state_48347;
var statearr_48356_48400 = state_48347__$1;
(statearr_48356_48400[(2)] = inst_48320);

(statearr_48356_48400[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (21))){
var inst_48340 = (state_48347[(2)]);
var state_48347__$1 = (function (){var statearr_48357 = state_48347;
(statearr_48357[(9)] = inst_48340);

return statearr_48357;
})();
var statearr_48358_48401 = state_48347__$1;
(statearr_48358_48401[(2)] = null);

(statearr_48358_48401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (13))){
var inst_48302 = (state_48347[(10)]);
var inst_48304 = cljs.core.chunked_seq_QMARK_.call(null,inst_48302);
var state_48347__$1 = state_48347;
if(inst_48304){
var statearr_48359_48402 = state_48347__$1;
(statearr_48359_48402[(1)] = (16));

} else {
var statearr_48360_48403 = state_48347__$1;
(statearr_48360_48403[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (22))){
var inst_48332 = (state_48347[(2)]);
var state_48347__$1 = state_48347;
if(cljs.core.truth_(inst_48332)){
var statearr_48361_48404 = state_48347__$1;
(statearr_48361_48404[(1)] = (23));

} else {
var statearr_48362_48405 = state_48347__$1;
(statearr_48362_48405[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (6))){
var inst_48326 = (state_48347[(7)]);
var inst_48328 = (state_48347[(11)]);
var inst_48278 = (state_48347[(8)]);
var inst_48326__$1 = topic_fn.call(null,inst_48278);
var inst_48327 = cljs.core.deref.call(null,mults);
var inst_48328__$1 = cljs.core.get.call(null,inst_48327,inst_48326__$1);
var state_48347__$1 = (function (){var statearr_48363 = state_48347;
(statearr_48363[(7)] = inst_48326__$1);

(statearr_48363[(11)] = inst_48328__$1);

return statearr_48363;
})();
if(cljs.core.truth_(inst_48328__$1)){
var statearr_48364_48406 = state_48347__$1;
(statearr_48364_48406[(1)] = (19));

} else {
var statearr_48365_48407 = state_48347__$1;
(statearr_48365_48407[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (25))){
var inst_48337 = (state_48347[(2)]);
var state_48347__$1 = state_48347;
var statearr_48366_48408 = state_48347__$1;
(statearr_48366_48408[(2)] = inst_48337);

(statearr_48366_48408[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (17))){
var inst_48302 = (state_48347[(10)]);
var inst_48311 = cljs.core.first.call(null,inst_48302);
var inst_48312 = cljs.core.async.muxch_STAR_.call(null,inst_48311);
var inst_48313 = cljs.core.async.close_BANG_.call(null,inst_48312);
var inst_48314 = cljs.core.next.call(null,inst_48302);
var inst_48288 = inst_48314;
var inst_48289 = null;
var inst_48290 = (0);
var inst_48291 = (0);
var state_48347__$1 = (function (){var statearr_48367 = state_48347;
(statearr_48367[(12)] = inst_48290);

(statearr_48367[(13)] = inst_48289);

(statearr_48367[(14)] = inst_48291);

(statearr_48367[(15)] = inst_48313);

(statearr_48367[(16)] = inst_48288);

return statearr_48367;
})();
var statearr_48368_48409 = state_48347__$1;
(statearr_48368_48409[(2)] = null);

(statearr_48368_48409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (3))){
var inst_48345 = (state_48347[(2)]);
var state_48347__$1 = state_48347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48347__$1,inst_48345);
} else {
if((state_val_48348 === (12))){
var inst_48322 = (state_48347[(2)]);
var state_48347__$1 = state_48347;
var statearr_48369_48410 = state_48347__$1;
(statearr_48369_48410[(2)] = inst_48322);

(statearr_48369_48410[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (2))){
var state_48347__$1 = state_48347;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48347__$1,(4),ch);
} else {
if((state_val_48348 === (23))){
var state_48347__$1 = state_48347;
var statearr_48370_48411 = state_48347__$1;
(statearr_48370_48411[(2)] = null);

(statearr_48370_48411[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (19))){
var inst_48328 = (state_48347[(11)]);
var inst_48278 = (state_48347[(8)]);
var inst_48330 = cljs.core.async.muxch_STAR_.call(null,inst_48328);
var state_48347__$1 = state_48347;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48347__$1,(22),inst_48330,inst_48278);
} else {
if((state_val_48348 === (11))){
var inst_48302 = (state_48347[(10)]);
var inst_48288 = (state_48347[(16)]);
var inst_48302__$1 = cljs.core.seq.call(null,inst_48288);
var state_48347__$1 = (function (){var statearr_48371 = state_48347;
(statearr_48371[(10)] = inst_48302__$1);

return statearr_48371;
})();
if(inst_48302__$1){
var statearr_48372_48412 = state_48347__$1;
(statearr_48372_48412[(1)] = (13));

} else {
var statearr_48373_48413 = state_48347__$1;
(statearr_48373_48413[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (9))){
var inst_48324 = (state_48347[(2)]);
var state_48347__$1 = state_48347;
var statearr_48374_48414 = state_48347__$1;
(statearr_48374_48414[(2)] = inst_48324);

(statearr_48374_48414[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (5))){
var inst_48285 = cljs.core.deref.call(null,mults);
var inst_48286 = cljs.core.vals.call(null,inst_48285);
var inst_48287 = cljs.core.seq.call(null,inst_48286);
var inst_48288 = inst_48287;
var inst_48289 = null;
var inst_48290 = (0);
var inst_48291 = (0);
var state_48347__$1 = (function (){var statearr_48375 = state_48347;
(statearr_48375[(12)] = inst_48290);

(statearr_48375[(13)] = inst_48289);

(statearr_48375[(14)] = inst_48291);

(statearr_48375[(16)] = inst_48288);

return statearr_48375;
})();
var statearr_48376_48415 = state_48347__$1;
(statearr_48376_48415[(2)] = null);

(statearr_48376_48415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (14))){
var state_48347__$1 = state_48347;
var statearr_48380_48416 = state_48347__$1;
(statearr_48380_48416[(2)] = null);

(statearr_48380_48416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (16))){
var inst_48302 = (state_48347[(10)]);
var inst_48306 = cljs.core.chunk_first.call(null,inst_48302);
var inst_48307 = cljs.core.chunk_rest.call(null,inst_48302);
var inst_48308 = cljs.core.count.call(null,inst_48306);
var inst_48288 = inst_48307;
var inst_48289 = inst_48306;
var inst_48290 = inst_48308;
var inst_48291 = (0);
var state_48347__$1 = (function (){var statearr_48381 = state_48347;
(statearr_48381[(12)] = inst_48290);

(statearr_48381[(13)] = inst_48289);

(statearr_48381[(14)] = inst_48291);

(statearr_48381[(16)] = inst_48288);

return statearr_48381;
})();
var statearr_48382_48417 = state_48347__$1;
(statearr_48382_48417[(2)] = null);

(statearr_48382_48417[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (10))){
var inst_48290 = (state_48347[(12)]);
var inst_48289 = (state_48347[(13)]);
var inst_48291 = (state_48347[(14)]);
var inst_48288 = (state_48347[(16)]);
var inst_48296 = cljs.core._nth.call(null,inst_48289,inst_48291);
var inst_48297 = cljs.core.async.muxch_STAR_.call(null,inst_48296);
var inst_48298 = cljs.core.async.close_BANG_.call(null,inst_48297);
var inst_48299 = (inst_48291 + (1));
var tmp48377 = inst_48290;
var tmp48378 = inst_48289;
var tmp48379 = inst_48288;
var inst_48288__$1 = tmp48379;
var inst_48289__$1 = tmp48378;
var inst_48290__$1 = tmp48377;
var inst_48291__$1 = inst_48299;
var state_48347__$1 = (function (){var statearr_48383 = state_48347;
(statearr_48383[(12)] = inst_48290__$1);

(statearr_48383[(13)] = inst_48289__$1);

(statearr_48383[(14)] = inst_48291__$1);

(statearr_48383[(17)] = inst_48298);

(statearr_48383[(16)] = inst_48288__$1);

return statearr_48383;
})();
var statearr_48384_48418 = state_48347__$1;
(statearr_48384_48418[(2)] = null);

(statearr_48384_48418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (18))){
var inst_48317 = (state_48347[(2)]);
var state_48347__$1 = state_48347;
var statearr_48385_48419 = state_48347__$1;
(statearr_48385_48419[(2)] = inst_48317);

(statearr_48385_48419[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48348 === (8))){
var inst_48290 = (state_48347[(12)]);
var inst_48291 = (state_48347[(14)]);
var inst_48293 = (inst_48291 < inst_48290);
var inst_48294 = inst_48293;
var state_48347__$1 = state_48347;
if(cljs.core.truth_(inst_48294)){
var statearr_48386_48420 = state_48347__$1;
(statearr_48386_48420[(1)] = (10));

} else {
var statearr_48387_48421 = state_48347__$1;
(statearr_48387_48421[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___48393,mults,ensure_mult,p))
;
return ((function (switch__47085__auto__,c__47173__auto___48393,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_48388 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48388[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_48388[(1)] = (1));

return statearr_48388;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_48347){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48389){if((e48389 instanceof Object)){
var ex__47089__auto__ = e48389;
var statearr_48390_48422 = state_48347;
(statearr_48390_48422[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48347);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48389;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48423 = state_48347;
state_48347 = G__48423;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_48347){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_48347);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___48393,mults,ensure_mult,p))
})();
var state__47175__auto__ = (function (){var statearr_48391 = f__47174__auto__.call(null);
(statearr_48391[(6)] = c__47173__auto___48393);

return statearr_48391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___48393,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__48425 = arguments.length;
switch (G__48425) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__48428 = arguments.length;
switch (G__48428) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__48431 = arguments.length;
switch (G__48431) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__47173__auto___48498 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___48498,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___48498,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_48470){
var state_val_48471 = (state_48470[(1)]);
if((state_val_48471 === (7))){
var state_48470__$1 = state_48470;
var statearr_48472_48499 = state_48470__$1;
(statearr_48472_48499[(2)] = null);

(statearr_48472_48499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (1))){
var state_48470__$1 = state_48470;
var statearr_48473_48500 = state_48470__$1;
(statearr_48473_48500[(2)] = null);

(statearr_48473_48500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (4))){
var inst_48434 = (state_48470[(7)]);
var inst_48436 = (inst_48434 < cnt);
var state_48470__$1 = state_48470;
if(cljs.core.truth_(inst_48436)){
var statearr_48474_48501 = state_48470__$1;
(statearr_48474_48501[(1)] = (6));

} else {
var statearr_48475_48502 = state_48470__$1;
(statearr_48475_48502[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (15))){
var inst_48466 = (state_48470[(2)]);
var state_48470__$1 = state_48470;
var statearr_48476_48503 = state_48470__$1;
(statearr_48476_48503[(2)] = inst_48466);

(statearr_48476_48503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (13))){
var inst_48459 = cljs.core.async.close_BANG_.call(null,out);
var state_48470__$1 = state_48470;
var statearr_48477_48504 = state_48470__$1;
(statearr_48477_48504[(2)] = inst_48459);

(statearr_48477_48504[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (6))){
var state_48470__$1 = state_48470;
var statearr_48478_48505 = state_48470__$1;
(statearr_48478_48505[(2)] = null);

(statearr_48478_48505[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (3))){
var inst_48468 = (state_48470[(2)]);
var state_48470__$1 = state_48470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48470__$1,inst_48468);
} else {
if((state_val_48471 === (12))){
var inst_48456 = (state_48470[(8)]);
var inst_48456__$1 = (state_48470[(2)]);
var inst_48457 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_48456__$1);
var state_48470__$1 = (function (){var statearr_48479 = state_48470;
(statearr_48479[(8)] = inst_48456__$1);

return statearr_48479;
})();
if(cljs.core.truth_(inst_48457)){
var statearr_48480_48506 = state_48470__$1;
(statearr_48480_48506[(1)] = (13));

} else {
var statearr_48481_48507 = state_48470__$1;
(statearr_48481_48507[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (2))){
var inst_48433 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_48434 = (0);
var state_48470__$1 = (function (){var statearr_48482 = state_48470;
(statearr_48482[(9)] = inst_48433);

(statearr_48482[(7)] = inst_48434);

return statearr_48482;
})();
var statearr_48483_48508 = state_48470__$1;
(statearr_48483_48508[(2)] = null);

(statearr_48483_48508[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (11))){
var inst_48434 = (state_48470[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_48470,(10),Object,null,(9));
var inst_48443 = chs__$1.call(null,inst_48434);
var inst_48444 = done.call(null,inst_48434);
var inst_48445 = cljs.core.async.take_BANG_.call(null,inst_48443,inst_48444);
var state_48470__$1 = state_48470;
var statearr_48484_48509 = state_48470__$1;
(statearr_48484_48509[(2)] = inst_48445);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48470__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (9))){
var inst_48434 = (state_48470[(7)]);
var inst_48447 = (state_48470[(2)]);
var inst_48448 = (inst_48434 + (1));
var inst_48434__$1 = inst_48448;
var state_48470__$1 = (function (){var statearr_48485 = state_48470;
(statearr_48485[(7)] = inst_48434__$1);

(statearr_48485[(10)] = inst_48447);

return statearr_48485;
})();
var statearr_48486_48510 = state_48470__$1;
(statearr_48486_48510[(2)] = null);

(statearr_48486_48510[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (5))){
var inst_48454 = (state_48470[(2)]);
var state_48470__$1 = (function (){var statearr_48487 = state_48470;
(statearr_48487[(11)] = inst_48454);

return statearr_48487;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48470__$1,(12),dchan);
} else {
if((state_val_48471 === (14))){
var inst_48456 = (state_48470[(8)]);
var inst_48461 = cljs.core.apply.call(null,f,inst_48456);
var state_48470__$1 = state_48470;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48470__$1,(16),out,inst_48461);
} else {
if((state_val_48471 === (16))){
var inst_48463 = (state_48470[(2)]);
var state_48470__$1 = (function (){var statearr_48488 = state_48470;
(statearr_48488[(12)] = inst_48463);

return statearr_48488;
})();
var statearr_48489_48511 = state_48470__$1;
(statearr_48489_48511[(2)] = null);

(statearr_48489_48511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (10))){
var inst_48438 = (state_48470[(2)]);
var inst_48439 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_48470__$1 = (function (){var statearr_48490 = state_48470;
(statearr_48490[(13)] = inst_48438);

return statearr_48490;
})();
var statearr_48491_48512 = state_48470__$1;
(statearr_48491_48512[(2)] = inst_48439);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48470__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48471 === (8))){
var inst_48452 = (state_48470[(2)]);
var state_48470__$1 = state_48470;
var statearr_48492_48513 = state_48470__$1;
(statearr_48492_48513[(2)] = inst_48452);

(statearr_48492_48513[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___48498,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__47085__auto__,c__47173__auto___48498,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_48493 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48493[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_48493[(1)] = (1));

return statearr_48493;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_48470){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48494){if((e48494 instanceof Object)){
var ex__47089__auto__ = e48494;
var statearr_48495_48514 = state_48470;
(statearr_48495_48514[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48494;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48515 = state_48470;
state_48470 = G__48515;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_48470){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_48470);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___48498,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__47175__auto__ = (function (){var statearr_48496 = f__47174__auto__.call(null);
(statearr_48496[(6)] = c__47173__auto___48498);

return statearr_48496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___48498,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__48518 = arguments.length;
switch (G__48518) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___48572 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___48572,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___48572,out){
return (function (state_48550){
var state_val_48551 = (state_48550[(1)]);
if((state_val_48551 === (7))){
var inst_48530 = (state_48550[(7)]);
var inst_48529 = (state_48550[(8)]);
var inst_48529__$1 = (state_48550[(2)]);
var inst_48530__$1 = cljs.core.nth.call(null,inst_48529__$1,(0),null);
var inst_48531 = cljs.core.nth.call(null,inst_48529__$1,(1),null);
var inst_48532 = (inst_48530__$1 == null);
var state_48550__$1 = (function (){var statearr_48552 = state_48550;
(statearr_48552[(7)] = inst_48530__$1);

(statearr_48552[(8)] = inst_48529__$1);

(statearr_48552[(9)] = inst_48531);

return statearr_48552;
})();
if(cljs.core.truth_(inst_48532)){
var statearr_48553_48573 = state_48550__$1;
(statearr_48553_48573[(1)] = (8));

} else {
var statearr_48554_48574 = state_48550__$1;
(statearr_48554_48574[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48551 === (1))){
var inst_48519 = cljs.core.vec.call(null,chs);
var inst_48520 = inst_48519;
var state_48550__$1 = (function (){var statearr_48555 = state_48550;
(statearr_48555[(10)] = inst_48520);

return statearr_48555;
})();
var statearr_48556_48575 = state_48550__$1;
(statearr_48556_48575[(2)] = null);

(statearr_48556_48575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48551 === (4))){
var inst_48520 = (state_48550[(10)]);
var state_48550__$1 = state_48550;
return cljs.core.async.ioc_alts_BANG_.call(null,state_48550__$1,(7),inst_48520);
} else {
if((state_val_48551 === (6))){
var inst_48546 = (state_48550[(2)]);
var state_48550__$1 = state_48550;
var statearr_48557_48576 = state_48550__$1;
(statearr_48557_48576[(2)] = inst_48546);

(statearr_48557_48576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48551 === (3))){
var inst_48548 = (state_48550[(2)]);
var state_48550__$1 = state_48550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48550__$1,inst_48548);
} else {
if((state_val_48551 === (2))){
var inst_48520 = (state_48550[(10)]);
var inst_48522 = cljs.core.count.call(null,inst_48520);
var inst_48523 = (inst_48522 > (0));
var state_48550__$1 = state_48550;
if(cljs.core.truth_(inst_48523)){
var statearr_48559_48577 = state_48550__$1;
(statearr_48559_48577[(1)] = (4));

} else {
var statearr_48560_48578 = state_48550__$1;
(statearr_48560_48578[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48551 === (11))){
var inst_48520 = (state_48550[(10)]);
var inst_48539 = (state_48550[(2)]);
var tmp48558 = inst_48520;
var inst_48520__$1 = tmp48558;
var state_48550__$1 = (function (){var statearr_48561 = state_48550;
(statearr_48561[(11)] = inst_48539);

(statearr_48561[(10)] = inst_48520__$1);

return statearr_48561;
})();
var statearr_48562_48579 = state_48550__$1;
(statearr_48562_48579[(2)] = null);

(statearr_48562_48579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48551 === (9))){
var inst_48530 = (state_48550[(7)]);
var state_48550__$1 = state_48550;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48550__$1,(11),out,inst_48530);
} else {
if((state_val_48551 === (5))){
var inst_48544 = cljs.core.async.close_BANG_.call(null,out);
var state_48550__$1 = state_48550;
var statearr_48563_48580 = state_48550__$1;
(statearr_48563_48580[(2)] = inst_48544);

(statearr_48563_48580[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48551 === (10))){
var inst_48542 = (state_48550[(2)]);
var state_48550__$1 = state_48550;
var statearr_48564_48581 = state_48550__$1;
(statearr_48564_48581[(2)] = inst_48542);

(statearr_48564_48581[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48551 === (8))){
var inst_48530 = (state_48550[(7)]);
var inst_48529 = (state_48550[(8)]);
var inst_48531 = (state_48550[(9)]);
var inst_48520 = (state_48550[(10)]);
var inst_48534 = (function (){var cs = inst_48520;
var vec__48525 = inst_48529;
var v = inst_48530;
var c = inst_48531;
return ((function (cs,vec__48525,v,c,inst_48530,inst_48529,inst_48531,inst_48520,state_val_48551,c__47173__auto___48572,out){
return (function (p1__48516_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__48516_SHARP_);
});
;})(cs,vec__48525,v,c,inst_48530,inst_48529,inst_48531,inst_48520,state_val_48551,c__47173__auto___48572,out))
})();
var inst_48535 = cljs.core.filterv.call(null,inst_48534,inst_48520);
var inst_48520__$1 = inst_48535;
var state_48550__$1 = (function (){var statearr_48565 = state_48550;
(statearr_48565[(10)] = inst_48520__$1);

return statearr_48565;
})();
var statearr_48566_48582 = state_48550__$1;
(statearr_48566_48582[(2)] = null);

(statearr_48566_48582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___48572,out))
;
return ((function (switch__47085__auto__,c__47173__auto___48572,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_48567 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48567[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_48567[(1)] = (1));

return statearr_48567;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_48550){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48568){if((e48568 instanceof Object)){
var ex__47089__auto__ = e48568;
var statearr_48569_48583 = state_48550;
(statearr_48569_48583[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48568;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48584 = state_48550;
state_48550 = G__48584;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_48550){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_48550);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___48572,out))
})();
var state__47175__auto__ = (function (){var statearr_48570 = f__47174__auto__.call(null);
(statearr_48570[(6)] = c__47173__auto___48572);

return statearr_48570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___48572,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__48586 = arguments.length;
switch (G__48586) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___48631 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___48631,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___48631,out){
return (function (state_48610){
var state_val_48611 = (state_48610[(1)]);
if((state_val_48611 === (7))){
var inst_48592 = (state_48610[(7)]);
var inst_48592__$1 = (state_48610[(2)]);
var inst_48593 = (inst_48592__$1 == null);
var inst_48594 = cljs.core.not.call(null,inst_48593);
var state_48610__$1 = (function (){var statearr_48612 = state_48610;
(statearr_48612[(7)] = inst_48592__$1);

return statearr_48612;
})();
if(inst_48594){
var statearr_48613_48632 = state_48610__$1;
(statearr_48613_48632[(1)] = (8));

} else {
var statearr_48614_48633 = state_48610__$1;
(statearr_48614_48633[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48611 === (1))){
var inst_48587 = (0);
var state_48610__$1 = (function (){var statearr_48615 = state_48610;
(statearr_48615[(8)] = inst_48587);

return statearr_48615;
})();
var statearr_48616_48634 = state_48610__$1;
(statearr_48616_48634[(2)] = null);

(statearr_48616_48634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48611 === (4))){
var state_48610__$1 = state_48610;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48610__$1,(7),ch);
} else {
if((state_val_48611 === (6))){
var inst_48605 = (state_48610[(2)]);
var state_48610__$1 = state_48610;
var statearr_48617_48635 = state_48610__$1;
(statearr_48617_48635[(2)] = inst_48605);

(statearr_48617_48635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48611 === (3))){
var inst_48607 = (state_48610[(2)]);
var inst_48608 = cljs.core.async.close_BANG_.call(null,out);
var state_48610__$1 = (function (){var statearr_48618 = state_48610;
(statearr_48618[(9)] = inst_48607);

return statearr_48618;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48610__$1,inst_48608);
} else {
if((state_val_48611 === (2))){
var inst_48587 = (state_48610[(8)]);
var inst_48589 = (inst_48587 < n);
var state_48610__$1 = state_48610;
if(cljs.core.truth_(inst_48589)){
var statearr_48619_48636 = state_48610__$1;
(statearr_48619_48636[(1)] = (4));

} else {
var statearr_48620_48637 = state_48610__$1;
(statearr_48620_48637[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48611 === (11))){
var inst_48587 = (state_48610[(8)]);
var inst_48597 = (state_48610[(2)]);
var inst_48598 = (inst_48587 + (1));
var inst_48587__$1 = inst_48598;
var state_48610__$1 = (function (){var statearr_48621 = state_48610;
(statearr_48621[(10)] = inst_48597);

(statearr_48621[(8)] = inst_48587__$1);

return statearr_48621;
})();
var statearr_48622_48638 = state_48610__$1;
(statearr_48622_48638[(2)] = null);

(statearr_48622_48638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48611 === (9))){
var state_48610__$1 = state_48610;
var statearr_48623_48639 = state_48610__$1;
(statearr_48623_48639[(2)] = null);

(statearr_48623_48639[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48611 === (5))){
var state_48610__$1 = state_48610;
var statearr_48624_48640 = state_48610__$1;
(statearr_48624_48640[(2)] = null);

(statearr_48624_48640[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48611 === (10))){
var inst_48602 = (state_48610[(2)]);
var state_48610__$1 = state_48610;
var statearr_48625_48641 = state_48610__$1;
(statearr_48625_48641[(2)] = inst_48602);

(statearr_48625_48641[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48611 === (8))){
var inst_48592 = (state_48610[(7)]);
var state_48610__$1 = state_48610;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48610__$1,(11),out,inst_48592);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___48631,out))
;
return ((function (switch__47085__auto__,c__47173__auto___48631,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_48626 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48626[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_48626[(1)] = (1));

return statearr_48626;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_48610){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48610);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48627){if((e48627 instanceof Object)){
var ex__47089__auto__ = e48627;
var statearr_48628_48642 = state_48610;
(statearr_48628_48642[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48610);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48643 = state_48610;
state_48610 = G__48643;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_48610){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_48610);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___48631,out))
})();
var state__47175__auto__ = (function (){var statearr_48629 = f__47174__auto__.call(null);
(statearr_48629[(6)] = c__47173__auto___48631);

return statearr_48629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___48631,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async48645 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48645 = (function (f,ch,meta48646){
this.f = f;
this.ch = ch;
this.meta48646 = meta48646;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48647,meta48646__$1){
var self__ = this;
var _48647__$1 = this;
return (new cljs.core.async.t_cljs$core$async48645(self__.f,self__.ch,meta48646__$1));
});


cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48647){
var self__ = this;
var _48647__$1 = this;
return self__.meta48646;
});


cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async48648 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48648 = (function (f,ch,meta48646,_,fn1,meta48649){
this.f = f;
this.ch = ch;
this.meta48646 = meta48646;
this._ = _;
this.fn1 = fn1;
this.meta48649 = meta48649;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async48648.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_48650,meta48649__$1){
var self__ = this;
var _48650__$1 = this;
return (new cljs.core.async.t_cljs$core$async48648(self__.f,self__.ch,self__.meta48646,self__._,self__.fn1,meta48649__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async48648.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_48650){
var self__ = this;
var _48650__$1 = this;
return self__.meta48649;
});})(___$1))
;


cljs.core.async.t_cljs$core$async48648.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48648.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async48648.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async48648.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__48644_SHARP_){
return f1.call(null,(((p1__48644_SHARP_ == null))?null:self__.f.call(null,p1__48644_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async48648.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48646","meta48646",-858463887,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48645","cljs.core.async/t_cljs$core$async48645",-145788467,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48649","meta48649",1585349135,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48648.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48648.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48648";

cljs.core.async.t_cljs$core$async48648.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async48648");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async48648 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48648(f__$1,ch__$1,meta48646__$1,___$2,fn1__$1,meta48649){
return (new cljs.core.async.t_cljs$core$async48648(f__$1,ch__$1,meta48646__$1,___$2,fn1__$1,meta48649));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async48648(self__.f,self__.ch,self__.meta48646,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28129__auto__ = ret;
if(cljs.core.truth_(and__28129__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28129__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48645.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async48645.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48646","meta48646",-858463887,null)], null);
});

cljs.core.async.t_cljs$core$async48645.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48645.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48645";

cljs.core.async.t_cljs$core$async48645.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async48645");
});

cljs.core.async.__GT_t_cljs$core$async48645 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48645(f__$1,ch__$1,meta48646){
return (new cljs.core.async.t_cljs$core$async48645(f__$1,ch__$1,meta48646));
});

}

return (new cljs.core.async.t_cljs$core$async48645(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async48651 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48651 = (function (f,ch,meta48652){
this.f = f;
this.ch = ch;
this.meta48652 = meta48652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async48651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48653,meta48652__$1){
var self__ = this;
var _48653__$1 = this;
return (new cljs.core.async.t_cljs$core$async48651(self__.f,self__.ch,meta48652__$1));
});


cljs.core.async.t_cljs$core$async48651.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48653){
var self__ = this;
var _48653__$1 = this;
return self__.meta48652;
});


cljs.core.async.t_cljs$core$async48651.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48651.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async48651.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48651.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async48651.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48651.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async48651.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48652","meta48652",-1040087273,null)], null);
});

cljs.core.async.t_cljs$core$async48651.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48651.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48651";

cljs.core.async.t_cljs$core$async48651.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async48651");
});

cljs.core.async.__GT_t_cljs$core$async48651 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48651(f__$1,ch__$1,meta48652){
return (new cljs.core.async.t_cljs$core$async48651(f__$1,ch__$1,meta48652));
});

}

return (new cljs.core.async.t_cljs$core$async48651(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async48654 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48654 = (function (p,ch,meta48655){
this.p = p;
this.ch = ch;
this.meta48655 = meta48655;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48656,meta48655__$1){
var self__ = this;
var _48656__$1 = this;
return (new cljs.core.async.t_cljs$core$async48654(self__.p,self__.ch,meta48655__$1));
});


cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48656){
var self__ = this;
var _48656__$1 = this;
return self__.meta48655;
});


cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async48654.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async48654.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48655","meta48655",-979424581,null)], null);
});

cljs.core.async.t_cljs$core$async48654.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48654.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48654";

cljs.core.async.t_cljs$core$async48654.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async48654");
});

cljs.core.async.__GT_t_cljs$core$async48654 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48654(p__$1,ch__$1,meta48655){
return (new cljs.core.async.t_cljs$core$async48654(p__$1,ch__$1,meta48655));
});

}

return (new cljs.core.async.t_cljs$core$async48654(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__48658 = arguments.length;
switch (G__48658) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___48698 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___48698,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___48698,out){
return (function (state_48679){
var state_val_48680 = (state_48679[(1)]);
if((state_val_48680 === (7))){
var inst_48675 = (state_48679[(2)]);
var state_48679__$1 = state_48679;
var statearr_48681_48699 = state_48679__$1;
(statearr_48681_48699[(2)] = inst_48675);

(statearr_48681_48699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48680 === (1))){
var state_48679__$1 = state_48679;
var statearr_48682_48700 = state_48679__$1;
(statearr_48682_48700[(2)] = null);

(statearr_48682_48700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48680 === (4))){
var inst_48661 = (state_48679[(7)]);
var inst_48661__$1 = (state_48679[(2)]);
var inst_48662 = (inst_48661__$1 == null);
var state_48679__$1 = (function (){var statearr_48683 = state_48679;
(statearr_48683[(7)] = inst_48661__$1);

return statearr_48683;
})();
if(cljs.core.truth_(inst_48662)){
var statearr_48684_48701 = state_48679__$1;
(statearr_48684_48701[(1)] = (5));

} else {
var statearr_48685_48702 = state_48679__$1;
(statearr_48685_48702[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48680 === (6))){
var inst_48661 = (state_48679[(7)]);
var inst_48666 = p.call(null,inst_48661);
var state_48679__$1 = state_48679;
if(cljs.core.truth_(inst_48666)){
var statearr_48686_48703 = state_48679__$1;
(statearr_48686_48703[(1)] = (8));

} else {
var statearr_48687_48704 = state_48679__$1;
(statearr_48687_48704[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48680 === (3))){
var inst_48677 = (state_48679[(2)]);
var state_48679__$1 = state_48679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48679__$1,inst_48677);
} else {
if((state_val_48680 === (2))){
var state_48679__$1 = state_48679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48679__$1,(4),ch);
} else {
if((state_val_48680 === (11))){
var inst_48669 = (state_48679[(2)]);
var state_48679__$1 = state_48679;
var statearr_48688_48705 = state_48679__$1;
(statearr_48688_48705[(2)] = inst_48669);

(statearr_48688_48705[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48680 === (9))){
var state_48679__$1 = state_48679;
var statearr_48689_48706 = state_48679__$1;
(statearr_48689_48706[(2)] = null);

(statearr_48689_48706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48680 === (5))){
var inst_48664 = cljs.core.async.close_BANG_.call(null,out);
var state_48679__$1 = state_48679;
var statearr_48690_48707 = state_48679__$1;
(statearr_48690_48707[(2)] = inst_48664);

(statearr_48690_48707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48680 === (10))){
var inst_48672 = (state_48679[(2)]);
var state_48679__$1 = (function (){var statearr_48691 = state_48679;
(statearr_48691[(8)] = inst_48672);

return statearr_48691;
})();
var statearr_48692_48708 = state_48679__$1;
(statearr_48692_48708[(2)] = null);

(statearr_48692_48708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48680 === (8))){
var inst_48661 = (state_48679[(7)]);
var state_48679__$1 = state_48679;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48679__$1,(11),out,inst_48661);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___48698,out))
;
return ((function (switch__47085__auto__,c__47173__auto___48698,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_48693 = [null,null,null,null,null,null,null,null,null];
(statearr_48693[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_48693[(1)] = (1));

return statearr_48693;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_48679){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48694){if((e48694 instanceof Object)){
var ex__47089__auto__ = e48694;
var statearr_48695_48709 = state_48679;
(statearr_48695_48709[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48679);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48694;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48710 = state_48679;
state_48679 = G__48710;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_48679){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_48679);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___48698,out))
})();
var state__47175__auto__ = (function (){var statearr_48696 = f__47174__auto__.call(null);
(statearr_48696[(6)] = c__47173__auto___48698);

return statearr_48696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___48698,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__48712 = arguments.length;
switch (G__48712) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_48775){
var state_val_48776 = (state_48775[(1)]);
if((state_val_48776 === (7))){
var inst_48771 = (state_48775[(2)]);
var state_48775__$1 = state_48775;
var statearr_48777_48815 = state_48775__$1;
(statearr_48777_48815[(2)] = inst_48771);

(statearr_48777_48815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (20))){
var inst_48741 = (state_48775[(7)]);
var inst_48752 = (state_48775[(2)]);
var inst_48753 = cljs.core.next.call(null,inst_48741);
var inst_48727 = inst_48753;
var inst_48728 = null;
var inst_48729 = (0);
var inst_48730 = (0);
var state_48775__$1 = (function (){var statearr_48778 = state_48775;
(statearr_48778[(8)] = inst_48730);

(statearr_48778[(9)] = inst_48727);

(statearr_48778[(10)] = inst_48728);

(statearr_48778[(11)] = inst_48729);

(statearr_48778[(12)] = inst_48752);

return statearr_48778;
})();
var statearr_48779_48816 = state_48775__$1;
(statearr_48779_48816[(2)] = null);

(statearr_48779_48816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (1))){
var state_48775__$1 = state_48775;
var statearr_48780_48817 = state_48775__$1;
(statearr_48780_48817[(2)] = null);

(statearr_48780_48817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (4))){
var inst_48716 = (state_48775[(13)]);
var inst_48716__$1 = (state_48775[(2)]);
var inst_48717 = (inst_48716__$1 == null);
var state_48775__$1 = (function (){var statearr_48781 = state_48775;
(statearr_48781[(13)] = inst_48716__$1);

return statearr_48781;
})();
if(cljs.core.truth_(inst_48717)){
var statearr_48782_48818 = state_48775__$1;
(statearr_48782_48818[(1)] = (5));

} else {
var statearr_48783_48819 = state_48775__$1;
(statearr_48783_48819[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (15))){
var state_48775__$1 = state_48775;
var statearr_48787_48820 = state_48775__$1;
(statearr_48787_48820[(2)] = null);

(statearr_48787_48820[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (21))){
var state_48775__$1 = state_48775;
var statearr_48788_48821 = state_48775__$1;
(statearr_48788_48821[(2)] = null);

(statearr_48788_48821[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (13))){
var inst_48730 = (state_48775[(8)]);
var inst_48727 = (state_48775[(9)]);
var inst_48728 = (state_48775[(10)]);
var inst_48729 = (state_48775[(11)]);
var inst_48737 = (state_48775[(2)]);
var inst_48738 = (inst_48730 + (1));
var tmp48784 = inst_48727;
var tmp48785 = inst_48728;
var tmp48786 = inst_48729;
var inst_48727__$1 = tmp48784;
var inst_48728__$1 = tmp48785;
var inst_48729__$1 = tmp48786;
var inst_48730__$1 = inst_48738;
var state_48775__$1 = (function (){var statearr_48789 = state_48775;
(statearr_48789[(8)] = inst_48730__$1);

(statearr_48789[(9)] = inst_48727__$1);

(statearr_48789[(10)] = inst_48728__$1);

(statearr_48789[(11)] = inst_48729__$1);

(statearr_48789[(14)] = inst_48737);

return statearr_48789;
})();
var statearr_48790_48822 = state_48775__$1;
(statearr_48790_48822[(2)] = null);

(statearr_48790_48822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (22))){
var state_48775__$1 = state_48775;
var statearr_48791_48823 = state_48775__$1;
(statearr_48791_48823[(2)] = null);

(statearr_48791_48823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (6))){
var inst_48716 = (state_48775[(13)]);
var inst_48725 = f.call(null,inst_48716);
var inst_48726 = cljs.core.seq.call(null,inst_48725);
var inst_48727 = inst_48726;
var inst_48728 = null;
var inst_48729 = (0);
var inst_48730 = (0);
var state_48775__$1 = (function (){var statearr_48792 = state_48775;
(statearr_48792[(8)] = inst_48730);

(statearr_48792[(9)] = inst_48727);

(statearr_48792[(10)] = inst_48728);

(statearr_48792[(11)] = inst_48729);

return statearr_48792;
})();
var statearr_48793_48824 = state_48775__$1;
(statearr_48793_48824[(2)] = null);

(statearr_48793_48824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (17))){
var inst_48741 = (state_48775[(7)]);
var inst_48745 = cljs.core.chunk_first.call(null,inst_48741);
var inst_48746 = cljs.core.chunk_rest.call(null,inst_48741);
var inst_48747 = cljs.core.count.call(null,inst_48745);
var inst_48727 = inst_48746;
var inst_48728 = inst_48745;
var inst_48729 = inst_48747;
var inst_48730 = (0);
var state_48775__$1 = (function (){var statearr_48794 = state_48775;
(statearr_48794[(8)] = inst_48730);

(statearr_48794[(9)] = inst_48727);

(statearr_48794[(10)] = inst_48728);

(statearr_48794[(11)] = inst_48729);

return statearr_48794;
})();
var statearr_48795_48825 = state_48775__$1;
(statearr_48795_48825[(2)] = null);

(statearr_48795_48825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (3))){
var inst_48773 = (state_48775[(2)]);
var state_48775__$1 = state_48775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48775__$1,inst_48773);
} else {
if((state_val_48776 === (12))){
var inst_48761 = (state_48775[(2)]);
var state_48775__$1 = state_48775;
var statearr_48796_48826 = state_48775__$1;
(statearr_48796_48826[(2)] = inst_48761);

(statearr_48796_48826[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (2))){
var state_48775__$1 = state_48775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48775__$1,(4),in$);
} else {
if((state_val_48776 === (23))){
var inst_48769 = (state_48775[(2)]);
var state_48775__$1 = state_48775;
var statearr_48797_48827 = state_48775__$1;
(statearr_48797_48827[(2)] = inst_48769);

(statearr_48797_48827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (19))){
var inst_48756 = (state_48775[(2)]);
var state_48775__$1 = state_48775;
var statearr_48798_48828 = state_48775__$1;
(statearr_48798_48828[(2)] = inst_48756);

(statearr_48798_48828[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (11))){
var inst_48727 = (state_48775[(9)]);
var inst_48741 = (state_48775[(7)]);
var inst_48741__$1 = cljs.core.seq.call(null,inst_48727);
var state_48775__$1 = (function (){var statearr_48799 = state_48775;
(statearr_48799[(7)] = inst_48741__$1);

return statearr_48799;
})();
if(inst_48741__$1){
var statearr_48800_48829 = state_48775__$1;
(statearr_48800_48829[(1)] = (14));

} else {
var statearr_48801_48830 = state_48775__$1;
(statearr_48801_48830[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (9))){
var inst_48763 = (state_48775[(2)]);
var inst_48764 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_48775__$1 = (function (){var statearr_48802 = state_48775;
(statearr_48802[(15)] = inst_48763);

return statearr_48802;
})();
if(cljs.core.truth_(inst_48764)){
var statearr_48803_48831 = state_48775__$1;
(statearr_48803_48831[(1)] = (21));

} else {
var statearr_48804_48832 = state_48775__$1;
(statearr_48804_48832[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (5))){
var inst_48719 = cljs.core.async.close_BANG_.call(null,out);
var state_48775__$1 = state_48775;
var statearr_48805_48833 = state_48775__$1;
(statearr_48805_48833[(2)] = inst_48719);

(statearr_48805_48833[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (14))){
var inst_48741 = (state_48775[(7)]);
var inst_48743 = cljs.core.chunked_seq_QMARK_.call(null,inst_48741);
var state_48775__$1 = state_48775;
if(inst_48743){
var statearr_48806_48834 = state_48775__$1;
(statearr_48806_48834[(1)] = (17));

} else {
var statearr_48807_48835 = state_48775__$1;
(statearr_48807_48835[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (16))){
var inst_48759 = (state_48775[(2)]);
var state_48775__$1 = state_48775;
var statearr_48808_48836 = state_48775__$1;
(statearr_48808_48836[(2)] = inst_48759);

(statearr_48808_48836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48776 === (10))){
var inst_48730 = (state_48775[(8)]);
var inst_48728 = (state_48775[(10)]);
var inst_48735 = cljs.core._nth.call(null,inst_48728,inst_48730);
var state_48775__$1 = state_48775;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48775__$1,(13),out,inst_48735);
} else {
if((state_val_48776 === (18))){
var inst_48741 = (state_48775[(7)]);
var inst_48750 = cljs.core.first.call(null,inst_48741);
var state_48775__$1 = state_48775;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48775__$1,(20),out,inst_48750);
} else {
if((state_val_48776 === (8))){
var inst_48730 = (state_48775[(8)]);
var inst_48729 = (state_48775[(11)]);
var inst_48732 = (inst_48730 < inst_48729);
var inst_48733 = inst_48732;
var state_48775__$1 = state_48775;
if(cljs.core.truth_(inst_48733)){
var statearr_48809_48837 = state_48775__$1;
(statearr_48809_48837[(1)] = (10));

} else {
var statearr_48810_48838 = state_48775__$1;
(statearr_48810_48838[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_48811 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48811[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__);

(statearr_48811[(1)] = (1));

return statearr_48811;
});
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1 = (function (state_48775){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48812){if((e48812 instanceof Object)){
var ex__47089__auto__ = e48812;
var statearr_48813_48839 = state_48775;
(statearr_48813_48839[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48775);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48812;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48840 = state_48775;
state_48775 = G__48840;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__ = function(state_48775){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1.call(this,state_48775);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_48814 = f__47174__auto__.call(null);
(statearr_48814[(6)] = c__47173__auto__);

return statearr_48814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__48842 = arguments.length;
switch (G__48842) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__48845 = arguments.length;
switch (G__48845) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__48848 = arguments.length;
switch (G__48848) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___48895 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___48895,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___48895,out){
return (function (state_48872){
var state_val_48873 = (state_48872[(1)]);
if((state_val_48873 === (7))){
var inst_48867 = (state_48872[(2)]);
var state_48872__$1 = state_48872;
var statearr_48874_48896 = state_48872__$1;
(statearr_48874_48896[(2)] = inst_48867);

(statearr_48874_48896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48873 === (1))){
var inst_48849 = null;
var state_48872__$1 = (function (){var statearr_48875 = state_48872;
(statearr_48875[(7)] = inst_48849);

return statearr_48875;
})();
var statearr_48876_48897 = state_48872__$1;
(statearr_48876_48897[(2)] = null);

(statearr_48876_48897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48873 === (4))){
var inst_48852 = (state_48872[(8)]);
var inst_48852__$1 = (state_48872[(2)]);
var inst_48853 = (inst_48852__$1 == null);
var inst_48854 = cljs.core.not.call(null,inst_48853);
var state_48872__$1 = (function (){var statearr_48877 = state_48872;
(statearr_48877[(8)] = inst_48852__$1);

return statearr_48877;
})();
if(inst_48854){
var statearr_48878_48898 = state_48872__$1;
(statearr_48878_48898[(1)] = (5));

} else {
var statearr_48879_48899 = state_48872__$1;
(statearr_48879_48899[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48873 === (6))){
var state_48872__$1 = state_48872;
var statearr_48880_48900 = state_48872__$1;
(statearr_48880_48900[(2)] = null);

(statearr_48880_48900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48873 === (3))){
var inst_48869 = (state_48872[(2)]);
var inst_48870 = cljs.core.async.close_BANG_.call(null,out);
var state_48872__$1 = (function (){var statearr_48881 = state_48872;
(statearr_48881[(9)] = inst_48869);

return statearr_48881;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48872__$1,inst_48870);
} else {
if((state_val_48873 === (2))){
var state_48872__$1 = state_48872;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48872__$1,(4),ch);
} else {
if((state_val_48873 === (11))){
var inst_48852 = (state_48872[(8)]);
var inst_48861 = (state_48872[(2)]);
var inst_48849 = inst_48852;
var state_48872__$1 = (function (){var statearr_48882 = state_48872;
(statearr_48882[(7)] = inst_48849);

(statearr_48882[(10)] = inst_48861);

return statearr_48882;
})();
var statearr_48883_48901 = state_48872__$1;
(statearr_48883_48901[(2)] = null);

(statearr_48883_48901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48873 === (9))){
var inst_48852 = (state_48872[(8)]);
var state_48872__$1 = state_48872;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48872__$1,(11),out,inst_48852);
} else {
if((state_val_48873 === (5))){
var inst_48849 = (state_48872[(7)]);
var inst_48852 = (state_48872[(8)]);
var inst_48856 = cljs.core._EQ_.call(null,inst_48852,inst_48849);
var state_48872__$1 = state_48872;
if(inst_48856){
var statearr_48885_48902 = state_48872__$1;
(statearr_48885_48902[(1)] = (8));

} else {
var statearr_48886_48903 = state_48872__$1;
(statearr_48886_48903[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48873 === (10))){
var inst_48864 = (state_48872[(2)]);
var state_48872__$1 = state_48872;
var statearr_48887_48904 = state_48872__$1;
(statearr_48887_48904[(2)] = inst_48864);

(statearr_48887_48904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48873 === (8))){
var inst_48849 = (state_48872[(7)]);
var tmp48884 = inst_48849;
var inst_48849__$1 = tmp48884;
var state_48872__$1 = (function (){var statearr_48888 = state_48872;
(statearr_48888[(7)] = inst_48849__$1);

return statearr_48888;
})();
var statearr_48889_48905 = state_48872__$1;
(statearr_48889_48905[(2)] = null);

(statearr_48889_48905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___48895,out))
;
return ((function (switch__47085__auto__,c__47173__auto___48895,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_48890 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48890[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_48890[(1)] = (1));

return statearr_48890;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_48872){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48872);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48891){if((e48891 instanceof Object)){
var ex__47089__auto__ = e48891;
var statearr_48892_48906 = state_48872;
(statearr_48892_48906[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48872);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48891;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48907 = state_48872;
state_48872 = G__48907;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_48872){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_48872);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___48895,out))
})();
var state__47175__auto__ = (function (){var statearr_48893 = f__47174__auto__.call(null);
(statearr_48893[(6)] = c__47173__auto___48895);

return statearr_48893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___48895,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__48909 = arguments.length;
switch (G__48909) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___48975 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___48975,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___48975,out){
return (function (state_48947){
var state_val_48948 = (state_48947[(1)]);
if((state_val_48948 === (7))){
var inst_48943 = (state_48947[(2)]);
var state_48947__$1 = state_48947;
var statearr_48949_48976 = state_48947__$1;
(statearr_48949_48976[(2)] = inst_48943);

(statearr_48949_48976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (1))){
var inst_48910 = (new Array(n));
var inst_48911 = inst_48910;
var inst_48912 = (0);
var state_48947__$1 = (function (){var statearr_48950 = state_48947;
(statearr_48950[(7)] = inst_48911);

(statearr_48950[(8)] = inst_48912);

return statearr_48950;
})();
var statearr_48951_48977 = state_48947__$1;
(statearr_48951_48977[(2)] = null);

(statearr_48951_48977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (4))){
var inst_48915 = (state_48947[(9)]);
var inst_48915__$1 = (state_48947[(2)]);
var inst_48916 = (inst_48915__$1 == null);
var inst_48917 = cljs.core.not.call(null,inst_48916);
var state_48947__$1 = (function (){var statearr_48952 = state_48947;
(statearr_48952[(9)] = inst_48915__$1);

return statearr_48952;
})();
if(inst_48917){
var statearr_48953_48978 = state_48947__$1;
(statearr_48953_48978[(1)] = (5));

} else {
var statearr_48954_48979 = state_48947__$1;
(statearr_48954_48979[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (15))){
var inst_48937 = (state_48947[(2)]);
var state_48947__$1 = state_48947;
var statearr_48955_48980 = state_48947__$1;
(statearr_48955_48980[(2)] = inst_48937);

(statearr_48955_48980[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (13))){
var state_48947__$1 = state_48947;
var statearr_48956_48981 = state_48947__$1;
(statearr_48956_48981[(2)] = null);

(statearr_48956_48981[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (6))){
var inst_48912 = (state_48947[(8)]);
var inst_48933 = (inst_48912 > (0));
var state_48947__$1 = state_48947;
if(cljs.core.truth_(inst_48933)){
var statearr_48957_48982 = state_48947__$1;
(statearr_48957_48982[(1)] = (12));

} else {
var statearr_48958_48983 = state_48947__$1;
(statearr_48958_48983[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (3))){
var inst_48945 = (state_48947[(2)]);
var state_48947__$1 = state_48947;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48947__$1,inst_48945);
} else {
if((state_val_48948 === (12))){
var inst_48911 = (state_48947[(7)]);
var inst_48935 = cljs.core.vec.call(null,inst_48911);
var state_48947__$1 = state_48947;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48947__$1,(15),out,inst_48935);
} else {
if((state_val_48948 === (2))){
var state_48947__$1 = state_48947;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48947__$1,(4),ch);
} else {
if((state_val_48948 === (11))){
var inst_48927 = (state_48947[(2)]);
var inst_48928 = (new Array(n));
var inst_48911 = inst_48928;
var inst_48912 = (0);
var state_48947__$1 = (function (){var statearr_48959 = state_48947;
(statearr_48959[(7)] = inst_48911);

(statearr_48959[(10)] = inst_48927);

(statearr_48959[(8)] = inst_48912);

return statearr_48959;
})();
var statearr_48960_48984 = state_48947__$1;
(statearr_48960_48984[(2)] = null);

(statearr_48960_48984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (9))){
var inst_48911 = (state_48947[(7)]);
var inst_48925 = cljs.core.vec.call(null,inst_48911);
var state_48947__$1 = state_48947;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48947__$1,(11),out,inst_48925);
} else {
if((state_val_48948 === (5))){
var inst_48911 = (state_48947[(7)]);
var inst_48915 = (state_48947[(9)]);
var inst_48912 = (state_48947[(8)]);
var inst_48920 = (state_48947[(11)]);
var inst_48919 = (inst_48911[inst_48912] = inst_48915);
var inst_48920__$1 = (inst_48912 + (1));
var inst_48921 = (inst_48920__$1 < n);
var state_48947__$1 = (function (){var statearr_48961 = state_48947;
(statearr_48961[(12)] = inst_48919);

(statearr_48961[(11)] = inst_48920__$1);

return statearr_48961;
})();
if(cljs.core.truth_(inst_48921)){
var statearr_48962_48985 = state_48947__$1;
(statearr_48962_48985[(1)] = (8));

} else {
var statearr_48963_48986 = state_48947__$1;
(statearr_48963_48986[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (14))){
var inst_48940 = (state_48947[(2)]);
var inst_48941 = cljs.core.async.close_BANG_.call(null,out);
var state_48947__$1 = (function (){var statearr_48965 = state_48947;
(statearr_48965[(13)] = inst_48940);

return statearr_48965;
})();
var statearr_48966_48987 = state_48947__$1;
(statearr_48966_48987[(2)] = inst_48941);

(statearr_48966_48987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (10))){
var inst_48931 = (state_48947[(2)]);
var state_48947__$1 = state_48947;
var statearr_48967_48988 = state_48947__$1;
(statearr_48967_48988[(2)] = inst_48931);

(statearr_48967_48988[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48948 === (8))){
var inst_48911 = (state_48947[(7)]);
var inst_48920 = (state_48947[(11)]);
var tmp48964 = inst_48911;
var inst_48911__$1 = tmp48964;
var inst_48912 = inst_48920;
var state_48947__$1 = (function (){var statearr_48968 = state_48947;
(statearr_48968[(7)] = inst_48911__$1);

(statearr_48968[(8)] = inst_48912);

return statearr_48968;
})();
var statearr_48969_48989 = state_48947__$1;
(statearr_48969_48989[(2)] = null);

(statearr_48969_48989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___48975,out))
;
return ((function (switch__47085__auto__,c__47173__auto___48975,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_48970 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48970[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_48970[(1)] = (1));

return statearr_48970;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_48947){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_48947);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e48971){if((e48971 instanceof Object)){
var ex__47089__auto__ = e48971;
var statearr_48972_48990 = state_48947;
(statearr_48972_48990[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48947);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48971;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48991 = state_48947;
state_48947 = G__48991;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_48947){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_48947);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___48975,out))
})();
var state__47175__auto__ = (function (){var statearr_48973 = f__47174__auto__.call(null);
(statearr_48973[(6)] = c__47173__auto___48975);

return statearr_48973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___48975,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__48993 = arguments.length;
switch (G__48993) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___49063 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___49063,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___49063,out){
return (function (state_49035){
var state_val_49036 = (state_49035[(1)]);
if((state_val_49036 === (7))){
var inst_49031 = (state_49035[(2)]);
var state_49035__$1 = state_49035;
var statearr_49037_49064 = state_49035__$1;
(statearr_49037_49064[(2)] = inst_49031);

(statearr_49037_49064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (1))){
var inst_48994 = [];
var inst_48995 = inst_48994;
var inst_48996 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_49035__$1 = (function (){var statearr_49038 = state_49035;
(statearr_49038[(7)] = inst_48996);

(statearr_49038[(8)] = inst_48995);

return statearr_49038;
})();
var statearr_49039_49065 = state_49035__$1;
(statearr_49039_49065[(2)] = null);

(statearr_49039_49065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (4))){
var inst_48999 = (state_49035[(9)]);
var inst_48999__$1 = (state_49035[(2)]);
var inst_49000 = (inst_48999__$1 == null);
var inst_49001 = cljs.core.not.call(null,inst_49000);
var state_49035__$1 = (function (){var statearr_49040 = state_49035;
(statearr_49040[(9)] = inst_48999__$1);

return statearr_49040;
})();
if(inst_49001){
var statearr_49041_49066 = state_49035__$1;
(statearr_49041_49066[(1)] = (5));

} else {
var statearr_49042_49067 = state_49035__$1;
(statearr_49042_49067[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (15))){
var inst_49025 = (state_49035[(2)]);
var state_49035__$1 = state_49035;
var statearr_49043_49068 = state_49035__$1;
(statearr_49043_49068[(2)] = inst_49025);

(statearr_49043_49068[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (13))){
var state_49035__$1 = state_49035;
var statearr_49044_49069 = state_49035__$1;
(statearr_49044_49069[(2)] = null);

(statearr_49044_49069[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (6))){
var inst_48995 = (state_49035[(8)]);
var inst_49020 = inst_48995.length;
var inst_49021 = (inst_49020 > (0));
var state_49035__$1 = state_49035;
if(cljs.core.truth_(inst_49021)){
var statearr_49045_49070 = state_49035__$1;
(statearr_49045_49070[(1)] = (12));

} else {
var statearr_49046_49071 = state_49035__$1;
(statearr_49046_49071[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (3))){
var inst_49033 = (state_49035[(2)]);
var state_49035__$1 = state_49035;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49035__$1,inst_49033);
} else {
if((state_val_49036 === (12))){
var inst_48995 = (state_49035[(8)]);
var inst_49023 = cljs.core.vec.call(null,inst_48995);
var state_49035__$1 = state_49035;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49035__$1,(15),out,inst_49023);
} else {
if((state_val_49036 === (2))){
var state_49035__$1 = state_49035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49035__$1,(4),ch);
} else {
if((state_val_49036 === (11))){
var inst_48999 = (state_49035[(9)]);
var inst_49003 = (state_49035[(10)]);
var inst_49013 = (state_49035[(2)]);
var inst_49014 = [];
var inst_49015 = inst_49014.push(inst_48999);
var inst_48995 = inst_49014;
var inst_48996 = inst_49003;
var state_49035__$1 = (function (){var statearr_49047 = state_49035;
(statearr_49047[(11)] = inst_49015);

(statearr_49047[(7)] = inst_48996);

(statearr_49047[(8)] = inst_48995);

(statearr_49047[(12)] = inst_49013);

return statearr_49047;
})();
var statearr_49048_49072 = state_49035__$1;
(statearr_49048_49072[(2)] = null);

(statearr_49048_49072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (9))){
var inst_48995 = (state_49035[(8)]);
var inst_49011 = cljs.core.vec.call(null,inst_48995);
var state_49035__$1 = state_49035;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49035__$1,(11),out,inst_49011);
} else {
if((state_val_49036 === (5))){
var inst_48999 = (state_49035[(9)]);
var inst_49003 = (state_49035[(10)]);
var inst_48996 = (state_49035[(7)]);
var inst_49003__$1 = f.call(null,inst_48999);
var inst_49004 = cljs.core._EQ_.call(null,inst_49003__$1,inst_48996);
var inst_49005 = cljs.core.keyword_identical_QMARK_.call(null,inst_48996,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_49006 = (inst_49004) || (inst_49005);
var state_49035__$1 = (function (){var statearr_49049 = state_49035;
(statearr_49049[(10)] = inst_49003__$1);

return statearr_49049;
})();
if(cljs.core.truth_(inst_49006)){
var statearr_49050_49073 = state_49035__$1;
(statearr_49050_49073[(1)] = (8));

} else {
var statearr_49051_49074 = state_49035__$1;
(statearr_49051_49074[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (14))){
var inst_49028 = (state_49035[(2)]);
var inst_49029 = cljs.core.async.close_BANG_.call(null,out);
var state_49035__$1 = (function (){var statearr_49053 = state_49035;
(statearr_49053[(13)] = inst_49028);

return statearr_49053;
})();
var statearr_49054_49075 = state_49035__$1;
(statearr_49054_49075[(2)] = inst_49029);

(statearr_49054_49075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (10))){
var inst_49018 = (state_49035[(2)]);
var state_49035__$1 = state_49035;
var statearr_49055_49076 = state_49035__$1;
(statearr_49055_49076[(2)] = inst_49018);

(statearr_49055_49076[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49036 === (8))){
var inst_48999 = (state_49035[(9)]);
var inst_49003 = (state_49035[(10)]);
var inst_48995 = (state_49035[(8)]);
var inst_49008 = inst_48995.push(inst_48999);
var tmp49052 = inst_48995;
var inst_48995__$1 = tmp49052;
var inst_48996 = inst_49003;
var state_49035__$1 = (function (){var statearr_49056 = state_49035;
(statearr_49056[(7)] = inst_48996);

(statearr_49056[(8)] = inst_48995__$1);

(statearr_49056[(14)] = inst_49008);

return statearr_49056;
})();
var statearr_49057_49077 = state_49035__$1;
(statearr_49057_49077[(2)] = null);

(statearr_49057_49077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___49063,out))
;
return ((function (switch__47085__auto__,c__47173__auto___49063,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_49058 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49058[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_49058[(1)] = (1));

return statearr_49058;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_49035){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_49035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e49059){if((e49059 instanceof Object)){
var ex__47089__auto__ = e49059;
var statearr_49060_49078 = state_49035;
(statearr_49060_49078[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49035);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49059;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49079 = state_49035;
state_49035 = G__49079;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_49035){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_49035);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___49063,out))
})();
var state__47175__auto__ = (function (){var statearr_49061 = f__47174__auto__.call(null);
(statearr_49061[(6)] = c__47173__auto___49063);

return statearr_49061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___49063,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1511229459273
