// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e55022){if((e55022 instanceof Error)){
var e = e55022;
return "Error: Unable to stringify";
} else {
throw e55022;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__55025 = arguments.length;
switch (G__55025) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__55023_SHARP_){
if(typeof p1__55023_SHARP_ === 'string'){
return p1__55023_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__55023_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___55028 = arguments.length;
var i__29313__auto___55029 = (0);
while(true){
if((i__29313__auto___55029 < len__29312__auto___55028)){
args__29319__auto__.push((arguments[i__29313__auto___55029]));

var G__55030 = (i__29313__auto___55029 + (1));
i__29313__auto___55029 = G__55030;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq55027){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55027));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___55032 = arguments.length;
var i__29313__auto___55033 = (0);
while(true){
if((i__29313__auto___55033 < len__29312__auto___55032)){
args__29319__auto__.push((arguments[i__29313__auto___55033]));

var G__55034 = (i__29313__auto___55033 + (1));
i__29313__auto___55033 = G__55034;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq55031){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55031));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__55035){
var map__55036 = p__55035;
var map__55036__$1 = ((((!((map__55036 == null)))?((((map__55036.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55036.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55036):map__55036);
var message = cljs.core.get.call(null,map__55036__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__55036__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28141__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28129__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28129__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28129__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__42036__auto___55115 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___55115,ch){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___55115,ch){
return (function (state_55087){
var state_val_55088 = (state_55087[(1)]);
if((state_val_55088 === (7))){
var inst_55083 = (state_55087[(2)]);
var state_55087__$1 = state_55087;
var statearr_55089_55116 = state_55087__$1;
(statearr_55089_55116[(2)] = inst_55083);

(statearr_55089_55116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (1))){
var state_55087__$1 = state_55087;
var statearr_55090_55117 = state_55087__$1;
(statearr_55090_55117[(2)] = null);

(statearr_55090_55117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (4))){
var inst_55040 = (state_55087[(7)]);
var inst_55040__$1 = (state_55087[(2)]);
var state_55087__$1 = (function (){var statearr_55091 = state_55087;
(statearr_55091[(7)] = inst_55040__$1);

return statearr_55091;
})();
if(cljs.core.truth_(inst_55040__$1)){
var statearr_55092_55118 = state_55087__$1;
(statearr_55092_55118[(1)] = (5));

} else {
var statearr_55093_55119 = state_55087__$1;
(statearr_55093_55119[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (15))){
var inst_55047 = (state_55087[(8)]);
var inst_55062 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_55047);
var inst_55063 = cljs.core.first.call(null,inst_55062);
var inst_55064 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_55063);
var inst_55065 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_55064)].join('');
var inst_55066 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_55065);
var state_55087__$1 = state_55087;
var statearr_55094_55120 = state_55087__$1;
(statearr_55094_55120[(2)] = inst_55066);

(statearr_55094_55120[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (13))){
var inst_55071 = (state_55087[(2)]);
var state_55087__$1 = state_55087;
var statearr_55095_55121 = state_55087__$1;
(statearr_55095_55121[(2)] = inst_55071);

(statearr_55095_55121[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (6))){
var state_55087__$1 = state_55087;
var statearr_55096_55122 = state_55087__$1;
(statearr_55096_55122[(2)] = null);

(statearr_55096_55122[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (17))){
var inst_55069 = (state_55087[(2)]);
var state_55087__$1 = state_55087;
var statearr_55097_55123 = state_55087__$1;
(statearr_55097_55123[(2)] = inst_55069);

(statearr_55097_55123[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (3))){
var inst_55085 = (state_55087[(2)]);
var state_55087__$1 = state_55087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55087__$1,inst_55085);
} else {
if((state_val_55088 === (12))){
var inst_55046 = (state_55087[(9)]);
var inst_55060 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_55046,opts);
var state_55087__$1 = state_55087;
if(cljs.core.truth_(inst_55060)){
var statearr_55098_55124 = state_55087__$1;
(statearr_55098_55124[(1)] = (15));

} else {
var statearr_55099_55125 = state_55087__$1;
(statearr_55099_55125[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (2))){
var state_55087__$1 = state_55087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55087__$1,(4),ch);
} else {
if((state_val_55088 === (11))){
var inst_55047 = (state_55087[(8)]);
var inst_55052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55053 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_55047);
var inst_55054 = cljs.core.async.timeout.call(null,(1000));
var inst_55055 = [inst_55053,inst_55054];
var inst_55056 = (new cljs.core.PersistentVector(null,2,(5),inst_55052,inst_55055,null));
var state_55087__$1 = state_55087;
return cljs.core.async.ioc_alts_BANG_.call(null,state_55087__$1,(14),inst_55056);
} else {
if((state_val_55088 === (9))){
var inst_55047 = (state_55087[(8)]);
var inst_55073 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_55074 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_55047);
var inst_55075 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_55074);
var inst_55076 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_55075)].join('');
var inst_55077 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_55076);
var state_55087__$1 = (function (){var statearr_55100 = state_55087;
(statearr_55100[(10)] = inst_55073);

return statearr_55100;
})();
var statearr_55101_55126 = state_55087__$1;
(statearr_55101_55126[(2)] = inst_55077);

(statearr_55101_55126[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (5))){
var inst_55040 = (state_55087[(7)]);
var inst_55042 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_55043 = (new cljs.core.PersistentArrayMap(null,2,inst_55042,null));
var inst_55044 = (new cljs.core.PersistentHashSet(null,inst_55043,null));
var inst_55045 = figwheel.client.focus_msgs.call(null,inst_55044,inst_55040);
var inst_55046 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_55045);
var inst_55047 = cljs.core.first.call(null,inst_55045);
var inst_55048 = figwheel.client.autoload_QMARK_.call(null);
var state_55087__$1 = (function (){var statearr_55102 = state_55087;
(statearr_55102[(8)] = inst_55047);

(statearr_55102[(9)] = inst_55046);

return statearr_55102;
})();
if(cljs.core.truth_(inst_55048)){
var statearr_55103_55127 = state_55087__$1;
(statearr_55103_55127[(1)] = (8));

} else {
var statearr_55104_55128 = state_55087__$1;
(statearr_55104_55128[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (14))){
var inst_55058 = (state_55087[(2)]);
var state_55087__$1 = state_55087;
var statearr_55105_55129 = state_55087__$1;
(statearr_55105_55129[(2)] = inst_55058);

(statearr_55105_55129[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (16))){
var state_55087__$1 = state_55087;
var statearr_55106_55130 = state_55087__$1;
(statearr_55106_55130[(2)] = null);

(statearr_55106_55130[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (10))){
var inst_55079 = (state_55087[(2)]);
var state_55087__$1 = (function (){var statearr_55107 = state_55087;
(statearr_55107[(11)] = inst_55079);

return statearr_55107;
})();
var statearr_55108_55131 = state_55087__$1;
(statearr_55108_55131[(2)] = null);

(statearr_55108_55131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55088 === (8))){
var inst_55046 = (state_55087[(9)]);
var inst_55050 = figwheel.client.reload_file_state_QMARK_.call(null,inst_55046,opts);
var state_55087__$1 = state_55087;
if(cljs.core.truth_(inst_55050)){
var statearr_55109_55132 = state_55087__$1;
(statearr_55109_55132[(1)] = (11));

} else {
var statearr_55110_55133 = state_55087__$1;
(statearr_55110_55133[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___55115,ch))
;
return ((function (switch__42015__auto__,c__42036__auto___55115,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____0 = (function (){
var statearr_55111 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55111[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__);

(statearr_55111[(1)] = (1));

return statearr_55111;
});
var figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____1 = (function (state_55087){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_55087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e55112){if((e55112 instanceof Object)){
var ex__42019__auto__ = e55112;
var statearr_55113_55134 = state_55087;
(statearr_55113_55134[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55087);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55135 = state_55087;
state_55087 = G__55135;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__ = function(state_55087){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____1.call(this,state_55087);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__42016__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___55115,ch))
})();
var state__42038__auto__ = (function (){var statearr_55114 = f__42037__auto__.call(null);
(statearr_55114[(6)] = c__42036__auto___55115);

return statearr_55114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___55115,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__55136_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__55136_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_55138 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_55138){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e55137){if((e55137 instanceof Error)){
var e = e55137;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_55138], null));
} else {
var e = e55137;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_55138))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__55139){
var map__55140 = p__55139;
var map__55140__$1 = ((((!((map__55140 == null)))?((((map__55140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55140.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55140):map__55140);
var opts = map__55140__$1;
var build_id = cljs.core.get.call(null,map__55140__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__55140,map__55140__$1,opts,build_id){
return (function (p__55142){
var vec__55143 = p__55142;
var seq__55144 = cljs.core.seq.call(null,vec__55143);
var first__55145 = cljs.core.first.call(null,seq__55144);
var seq__55144__$1 = cljs.core.next.call(null,seq__55144);
var map__55146 = first__55145;
var map__55146__$1 = ((((!((map__55146 == null)))?((((map__55146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55146.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55146):map__55146);
var msg = map__55146__$1;
var msg_name = cljs.core.get.call(null,map__55146__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__55144__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__55143,seq__55144,first__55145,seq__55144__$1,map__55146,map__55146__$1,msg,msg_name,_,map__55140,map__55140__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__55143,seq__55144,first__55145,seq__55144__$1,map__55146,map__55146__$1,msg,msg_name,_,map__55140,map__55140__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__55140,map__55140__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__55148){
var vec__55149 = p__55148;
var seq__55150 = cljs.core.seq.call(null,vec__55149);
var first__55151 = cljs.core.first.call(null,seq__55150);
var seq__55150__$1 = cljs.core.next.call(null,seq__55150);
var map__55152 = first__55151;
var map__55152__$1 = ((((!((map__55152 == null)))?((((map__55152.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55152.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55152):map__55152);
var msg = map__55152__$1;
var msg_name = cljs.core.get.call(null,map__55152__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__55150__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__55154){
var map__55155 = p__55154;
var map__55155__$1 = ((((!((map__55155 == null)))?((((map__55155.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55155.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55155):map__55155);
var on_compile_warning = cljs.core.get.call(null,map__55155__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__55155__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__55155,map__55155__$1,on_compile_warning,on_compile_fail){
return (function (p__55157){
var vec__55158 = p__55157;
var seq__55159 = cljs.core.seq.call(null,vec__55158);
var first__55160 = cljs.core.first.call(null,seq__55159);
var seq__55159__$1 = cljs.core.next.call(null,seq__55159);
var map__55161 = first__55160;
var map__55161__$1 = ((((!((map__55161 == null)))?((((map__55161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55161):map__55161);
var msg = map__55161__$1;
var msg_name = cljs.core.get.call(null,map__55161__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__55159__$1;
var pred__55163 = cljs.core._EQ_;
var expr__55164 = msg_name;
if(cljs.core.truth_(pred__55163.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__55164))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__55163.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__55164))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__55155,map__55155__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,msg_hist,msg_names,msg){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,msg_hist,msg_names,msg){
return (function (state_55253){
var state_val_55254 = (state_55253[(1)]);
if((state_val_55254 === (7))){
var inst_55173 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
if(cljs.core.truth_(inst_55173)){
var statearr_55255_55302 = state_55253__$1;
(statearr_55255_55302[(1)] = (8));

} else {
var statearr_55256_55303 = state_55253__$1;
(statearr_55256_55303[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (20))){
var inst_55247 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55257_55304 = state_55253__$1;
(statearr_55257_55304[(2)] = inst_55247);

(statearr_55257_55304[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (27))){
var inst_55243 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55258_55305 = state_55253__$1;
(statearr_55258_55305[(2)] = inst_55243);

(statearr_55258_55305[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (1))){
var inst_55166 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_55253__$1 = state_55253;
if(cljs.core.truth_(inst_55166)){
var statearr_55259_55306 = state_55253__$1;
(statearr_55259_55306[(1)] = (2));

} else {
var statearr_55260_55307 = state_55253__$1;
(statearr_55260_55307[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (24))){
var inst_55245 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55261_55308 = state_55253__$1;
(statearr_55261_55308[(2)] = inst_55245);

(statearr_55261_55308[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (4))){
var inst_55251 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55253__$1,inst_55251);
} else {
if((state_val_55254 === (15))){
var inst_55249 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55262_55309 = state_55253__$1;
(statearr_55262_55309[(2)] = inst_55249);

(statearr_55262_55309[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (21))){
var inst_55202 = (state_55253[(2)]);
var inst_55203 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55204 = figwheel.client.auto_jump_to_error.call(null,opts,inst_55203);
var state_55253__$1 = (function (){var statearr_55263 = state_55253;
(statearr_55263[(7)] = inst_55202);

return statearr_55263;
})();
var statearr_55264_55310 = state_55253__$1;
(statearr_55264_55310[(2)] = inst_55204);

(statearr_55264_55310[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (31))){
var inst_55232 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_55253__$1 = state_55253;
if(cljs.core.truth_(inst_55232)){
var statearr_55265_55311 = state_55253__$1;
(statearr_55265_55311[(1)] = (34));

} else {
var statearr_55266_55312 = state_55253__$1;
(statearr_55266_55312[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (32))){
var inst_55241 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55267_55313 = state_55253__$1;
(statearr_55267_55313[(2)] = inst_55241);

(statearr_55267_55313[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (33))){
var inst_55228 = (state_55253[(2)]);
var inst_55229 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55230 = figwheel.client.auto_jump_to_error.call(null,opts,inst_55229);
var state_55253__$1 = (function (){var statearr_55268 = state_55253;
(statearr_55268[(8)] = inst_55228);

return statearr_55268;
})();
var statearr_55269_55314 = state_55253__$1;
(statearr_55269_55314[(2)] = inst_55230);

(statearr_55269_55314[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (13))){
var inst_55187 = figwheel.client.heads_up.clear.call(null);
var state_55253__$1 = state_55253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(16),inst_55187);
} else {
if((state_val_55254 === (22))){
var inst_55208 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55209 = figwheel.client.heads_up.append_warning_message.call(null,inst_55208);
var state_55253__$1 = state_55253;
var statearr_55270_55315 = state_55253__$1;
(statearr_55270_55315[(2)] = inst_55209);

(statearr_55270_55315[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (36))){
var inst_55239 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55271_55316 = state_55253__$1;
(statearr_55271_55316[(2)] = inst_55239);

(statearr_55271_55316[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (29))){
var inst_55219 = (state_55253[(2)]);
var inst_55220 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55221 = figwheel.client.auto_jump_to_error.call(null,opts,inst_55220);
var state_55253__$1 = (function (){var statearr_55272 = state_55253;
(statearr_55272[(9)] = inst_55219);

return statearr_55272;
})();
var statearr_55273_55317 = state_55253__$1;
(statearr_55273_55317[(2)] = inst_55221);

(statearr_55273_55317[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (6))){
var inst_55168 = (state_55253[(10)]);
var state_55253__$1 = state_55253;
var statearr_55274_55318 = state_55253__$1;
(statearr_55274_55318[(2)] = inst_55168);

(statearr_55274_55318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (28))){
var inst_55215 = (state_55253[(2)]);
var inst_55216 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55217 = figwheel.client.heads_up.display_warning.call(null,inst_55216);
var state_55253__$1 = (function (){var statearr_55275 = state_55253;
(statearr_55275[(11)] = inst_55215);

return statearr_55275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(29),inst_55217);
} else {
if((state_val_55254 === (25))){
var inst_55213 = figwheel.client.heads_up.clear.call(null);
var state_55253__$1 = state_55253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(28),inst_55213);
} else {
if((state_val_55254 === (34))){
var inst_55234 = figwheel.client.heads_up.flash_loaded.call(null);
var state_55253__$1 = state_55253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(37),inst_55234);
} else {
if((state_val_55254 === (17))){
var inst_55193 = (state_55253[(2)]);
var inst_55194 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55195 = figwheel.client.auto_jump_to_error.call(null,opts,inst_55194);
var state_55253__$1 = (function (){var statearr_55276 = state_55253;
(statearr_55276[(12)] = inst_55193);

return statearr_55276;
})();
var statearr_55277_55319 = state_55253__$1;
(statearr_55277_55319[(2)] = inst_55195);

(statearr_55277_55319[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (3))){
var inst_55185 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_55253__$1 = state_55253;
if(cljs.core.truth_(inst_55185)){
var statearr_55278_55320 = state_55253__$1;
(statearr_55278_55320[(1)] = (13));

} else {
var statearr_55279_55321 = state_55253__$1;
(statearr_55279_55321[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (12))){
var inst_55181 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55280_55322 = state_55253__$1;
(statearr_55280_55322[(2)] = inst_55181);

(statearr_55280_55322[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (2))){
var inst_55168 = (state_55253[(10)]);
var inst_55168__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_55253__$1 = (function (){var statearr_55281 = state_55253;
(statearr_55281[(10)] = inst_55168__$1);

return statearr_55281;
})();
if(cljs.core.truth_(inst_55168__$1)){
var statearr_55282_55323 = state_55253__$1;
(statearr_55282_55323[(1)] = (5));

} else {
var statearr_55283_55324 = state_55253__$1;
(statearr_55283_55324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (23))){
var inst_55211 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_55253__$1 = state_55253;
if(cljs.core.truth_(inst_55211)){
var statearr_55284_55325 = state_55253__$1;
(statearr_55284_55325[(1)] = (25));

} else {
var statearr_55285_55326 = state_55253__$1;
(statearr_55285_55326[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (35))){
var state_55253__$1 = state_55253;
var statearr_55286_55327 = state_55253__$1;
(statearr_55286_55327[(2)] = null);

(statearr_55286_55327[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (19))){
var inst_55206 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_55253__$1 = state_55253;
if(cljs.core.truth_(inst_55206)){
var statearr_55287_55328 = state_55253__$1;
(statearr_55287_55328[(1)] = (22));

} else {
var statearr_55288_55329 = state_55253__$1;
(statearr_55288_55329[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (11))){
var inst_55177 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55289_55330 = state_55253__$1;
(statearr_55289_55330[(2)] = inst_55177);

(statearr_55289_55330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (9))){
var inst_55179 = figwheel.client.heads_up.clear.call(null);
var state_55253__$1 = state_55253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(12),inst_55179);
} else {
if((state_val_55254 === (5))){
var inst_55170 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_55253__$1 = state_55253;
var statearr_55290_55331 = state_55253__$1;
(statearr_55290_55331[(2)] = inst_55170);

(statearr_55290_55331[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (14))){
var inst_55197 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_55253__$1 = state_55253;
if(cljs.core.truth_(inst_55197)){
var statearr_55291_55332 = state_55253__$1;
(statearr_55291_55332[(1)] = (18));

} else {
var statearr_55292_55333 = state_55253__$1;
(statearr_55292_55333[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (26))){
var inst_55223 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_55253__$1 = state_55253;
if(cljs.core.truth_(inst_55223)){
var statearr_55293_55334 = state_55253__$1;
(statearr_55293_55334[(1)] = (30));

} else {
var statearr_55294_55335 = state_55253__$1;
(statearr_55294_55335[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (16))){
var inst_55189 = (state_55253[(2)]);
var inst_55190 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55191 = figwheel.client.heads_up.display_exception.call(null,inst_55190);
var state_55253__$1 = (function (){var statearr_55295 = state_55253;
(statearr_55295[(13)] = inst_55189);

return statearr_55295;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(17),inst_55191);
} else {
if((state_val_55254 === (30))){
var inst_55225 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55226 = figwheel.client.heads_up.display_warning.call(null,inst_55225);
var state_55253__$1 = state_55253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(33),inst_55226);
} else {
if((state_val_55254 === (10))){
var inst_55183 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55296_55336 = state_55253__$1;
(statearr_55296_55336[(2)] = inst_55183);

(statearr_55296_55336[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (18))){
var inst_55199 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_55200 = figwheel.client.heads_up.display_exception.call(null,inst_55199);
var state_55253__$1 = state_55253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(21),inst_55200);
} else {
if((state_val_55254 === (37))){
var inst_55236 = (state_55253[(2)]);
var state_55253__$1 = state_55253;
var statearr_55297_55337 = state_55253__$1;
(statearr_55297_55337[(2)] = inst_55236);

(statearr_55297_55337[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55254 === (8))){
var inst_55175 = figwheel.client.heads_up.flash_loaded.call(null);
var state_55253__$1 = state_55253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55253__$1,(11),inst_55175);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__42015__auto__,c__42036__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____0 = (function (){
var statearr_55298 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55298[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__);

(statearr_55298[(1)] = (1));

return statearr_55298;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____1 = (function (state_55253){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_55253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e55299){if((e55299 instanceof Object)){
var ex__42019__auto__ = e55299;
var statearr_55300_55338 = state_55253;
(statearr_55300_55338[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55253);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55299;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55339 = state_55253;
state_55253 = G__55339;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__ = function(state_55253){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____1.call(this,state_55253);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,msg_hist,msg_names,msg))
})();
var state__42038__auto__ = (function (){var statearr_55301 = f__42037__auto__.call(null);
(statearr_55301[(6)] = c__42036__auto__);

return statearr_55301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,msg_hist,msg_names,msg))
);

return c__42036__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__42036__auto___55368 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___55368,ch){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___55368,ch){
return (function (state_55354){
var state_val_55355 = (state_55354[(1)]);
if((state_val_55355 === (1))){
var state_55354__$1 = state_55354;
var statearr_55356_55369 = state_55354__$1;
(statearr_55356_55369[(2)] = null);

(statearr_55356_55369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (2))){
var state_55354__$1 = state_55354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55354__$1,(4),ch);
} else {
if((state_val_55355 === (3))){
var inst_55352 = (state_55354[(2)]);
var state_55354__$1 = state_55354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55354__$1,inst_55352);
} else {
if((state_val_55355 === (4))){
var inst_55342 = (state_55354[(7)]);
var inst_55342__$1 = (state_55354[(2)]);
var state_55354__$1 = (function (){var statearr_55357 = state_55354;
(statearr_55357[(7)] = inst_55342__$1);

return statearr_55357;
})();
if(cljs.core.truth_(inst_55342__$1)){
var statearr_55358_55370 = state_55354__$1;
(statearr_55358_55370[(1)] = (5));

} else {
var statearr_55359_55371 = state_55354__$1;
(statearr_55359_55371[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (5))){
var inst_55342 = (state_55354[(7)]);
var inst_55344 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_55342);
var state_55354__$1 = state_55354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55354__$1,(8),inst_55344);
} else {
if((state_val_55355 === (6))){
var state_55354__$1 = state_55354;
var statearr_55360_55372 = state_55354__$1;
(statearr_55360_55372[(2)] = null);

(statearr_55360_55372[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (7))){
var inst_55350 = (state_55354[(2)]);
var state_55354__$1 = state_55354;
var statearr_55361_55373 = state_55354__$1;
(statearr_55361_55373[(2)] = inst_55350);

(statearr_55361_55373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55355 === (8))){
var inst_55346 = (state_55354[(2)]);
var state_55354__$1 = (function (){var statearr_55362 = state_55354;
(statearr_55362[(8)] = inst_55346);

return statearr_55362;
})();
var statearr_55363_55374 = state_55354__$1;
(statearr_55363_55374[(2)] = null);

(statearr_55363_55374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__42036__auto___55368,ch))
;
return ((function (switch__42015__auto__,c__42036__auto___55368,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__42016__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__42016__auto____0 = (function (){
var statearr_55364 = [null,null,null,null,null,null,null,null,null];
(statearr_55364[(0)] = figwheel$client$heads_up_plugin_$_state_machine__42016__auto__);

(statearr_55364[(1)] = (1));

return statearr_55364;
});
var figwheel$client$heads_up_plugin_$_state_machine__42016__auto____1 = (function (state_55354){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_55354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e55365){if((e55365 instanceof Object)){
var ex__42019__auto__ = e55365;
var statearr_55366_55375 = state_55354;
(statearr_55366_55375[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55354);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55365;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55376 = state_55354;
state_55354 = G__55376;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__42016__auto__ = function(state_55354){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__42016__auto____1.call(this,state_55354);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__42016__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__42016__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___55368,ch))
})();
var state__42038__auto__ = (function (){var statearr_55367 = f__42037__auto__.call(null);
(statearr_55367[(6)] = c__42036__auto___55368);

return statearr_55367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___55368,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_55382){
var state_val_55383 = (state_55382[(1)]);
if((state_val_55383 === (1))){
var inst_55377 = cljs.core.async.timeout.call(null,(3000));
var state_55382__$1 = state_55382;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55382__$1,(2),inst_55377);
} else {
if((state_val_55383 === (2))){
var inst_55379 = (state_55382[(2)]);
var inst_55380 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_55382__$1 = (function (){var statearr_55384 = state_55382;
(statearr_55384[(7)] = inst_55379);

return statearr_55384;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55382__$1,inst_55380);
} else {
return null;
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____0 = (function (){
var statearr_55385 = [null,null,null,null,null,null,null,null];
(statearr_55385[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__);

(statearr_55385[(1)] = (1));

return statearr_55385;
});
var figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____1 = (function (state_55382){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_55382);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e55386){if((e55386 instanceof Object)){
var ex__42019__auto__ = e55386;
var statearr_55387_55389 = state_55382;
(statearr_55387_55389[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55382);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55386;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55390 = state_55382;
state_55382 = G__55390;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__ = function(state_55382){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____1.call(this,state_55382);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__42016__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_55388 = f__42037__auto__.call(null);
(statearr_55388[(6)] = c__42036__auto__);

return statearr_55388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,figwheel_version,temp__4657__auto__){
return (function (state_55397){
var state_val_55398 = (state_55397[(1)]);
if((state_val_55398 === (1))){
var inst_55391 = cljs.core.async.timeout.call(null,(2000));
var state_55397__$1 = state_55397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55397__$1,(2),inst_55391);
} else {
if((state_val_55398 === (2))){
var inst_55393 = (state_55397[(2)]);
var inst_55394 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_55395 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_55394);
var state_55397__$1 = (function (){var statearr_55399 = state_55397;
(statearr_55399[(7)] = inst_55393);

return statearr_55399;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55397__$1,inst_55395);
} else {
return null;
}
}
});})(c__42036__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____0 = (function (){
var statearr_55400 = [null,null,null,null,null,null,null,null];
(statearr_55400[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__);

(statearr_55400[(1)] = (1));

return statearr_55400;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____1 = (function (state_55397){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_55397);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e55401){if((e55401 instanceof Object)){
var ex__42019__auto__ = e55401;
var statearr_55402_55404 = state_55397;
(statearr_55402_55404[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55397);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55401;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55405 = state_55397;
state_55397 = G__55405;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__ = function(state_55397){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____1.call(this,state_55397);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,figwheel_version,temp__4657__auto__))
})();
var state__42038__auto__ = (function (){var statearr_55403 = f__42037__auto__.call(null);
(statearr_55403[(6)] = c__42036__auto__);

return statearr_55403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,figwheel_version,temp__4657__auto__))
);

return c__42036__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__55406){
var map__55407 = p__55406;
var map__55407__$1 = ((((!((map__55407 == null)))?((((map__55407.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55407.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55407):map__55407);
var file = cljs.core.get.call(null,map__55407__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__55407__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__55407__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__55409 = "";
var G__55409__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55409),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__55409);
var G__55409__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55409__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__55409__$1);
if(cljs.core.truth_((function (){var and__28129__auto__ = line;
if(cljs.core.truth_(and__28129__auto__)){
return column;
} else {
return and__28129__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55409__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__55409__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__55410){
var map__55411 = p__55410;
var map__55411__$1 = ((((!((map__55411 == null)))?((((map__55411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55411.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55411):map__55411);
var ed = map__55411__$1;
var formatted_exception = cljs.core.get.call(null,map__55411__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__55411__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__55411__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__55413_55417 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__55414_55418 = null;
var count__55415_55419 = (0);
var i__55416_55420 = (0);
while(true){
if((i__55416_55420 < count__55415_55419)){
var msg_55421 = cljs.core._nth.call(null,chunk__55414_55418,i__55416_55420);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_55421);

var G__55422 = seq__55413_55417;
var G__55423 = chunk__55414_55418;
var G__55424 = count__55415_55419;
var G__55425 = (i__55416_55420 + (1));
seq__55413_55417 = G__55422;
chunk__55414_55418 = G__55423;
count__55415_55419 = G__55424;
i__55416_55420 = G__55425;
continue;
} else {
var temp__4657__auto___55426 = cljs.core.seq.call(null,seq__55413_55417);
if(temp__4657__auto___55426){
var seq__55413_55427__$1 = temp__4657__auto___55426;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55413_55427__$1)){
var c__28980__auto___55428 = cljs.core.chunk_first.call(null,seq__55413_55427__$1);
var G__55429 = cljs.core.chunk_rest.call(null,seq__55413_55427__$1);
var G__55430 = c__28980__auto___55428;
var G__55431 = cljs.core.count.call(null,c__28980__auto___55428);
var G__55432 = (0);
seq__55413_55417 = G__55429;
chunk__55414_55418 = G__55430;
count__55415_55419 = G__55431;
i__55416_55420 = G__55432;
continue;
} else {
var msg_55433 = cljs.core.first.call(null,seq__55413_55427__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_55433);

var G__55434 = cljs.core.next.call(null,seq__55413_55427__$1);
var G__55435 = null;
var G__55436 = (0);
var G__55437 = (0);
seq__55413_55417 = G__55434;
chunk__55414_55418 = G__55435;
count__55415_55419 = G__55436;
i__55416_55420 = G__55437;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__55438){
var map__55439 = p__55438;
var map__55439__$1 = ((((!((map__55439 == null)))?((((map__55439.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55439.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55439):map__55439);
var w = map__55439__$1;
var message = cljs.core.get.call(null,map__55439__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/compiled/test/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/compiled/test/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28129__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28129__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28129__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__55441 = cljs.core.seq.call(null,plugins);
var chunk__55442 = null;
var count__55443 = (0);
var i__55444 = (0);
while(true){
if((i__55444 < count__55443)){
var vec__55445 = cljs.core._nth.call(null,chunk__55442,i__55444);
var k = cljs.core.nth.call(null,vec__55445,(0),null);
var plugin = cljs.core.nth.call(null,vec__55445,(1),null);
if(cljs.core.truth_(plugin)){
var pl_55451 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__55441,chunk__55442,count__55443,i__55444,pl_55451,vec__55445,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_55451.call(null,msg_hist);
});})(seq__55441,chunk__55442,count__55443,i__55444,pl_55451,vec__55445,k,plugin))
);
} else {
}

var G__55452 = seq__55441;
var G__55453 = chunk__55442;
var G__55454 = count__55443;
var G__55455 = (i__55444 + (1));
seq__55441 = G__55452;
chunk__55442 = G__55453;
count__55443 = G__55454;
i__55444 = G__55455;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__55441);
if(temp__4657__auto__){
var seq__55441__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55441__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__55441__$1);
var G__55456 = cljs.core.chunk_rest.call(null,seq__55441__$1);
var G__55457 = c__28980__auto__;
var G__55458 = cljs.core.count.call(null,c__28980__auto__);
var G__55459 = (0);
seq__55441 = G__55456;
chunk__55442 = G__55457;
count__55443 = G__55458;
i__55444 = G__55459;
continue;
} else {
var vec__55448 = cljs.core.first.call(null,seq__55441__$1);
var k = cljs.core.nth.call(null,vec__55448,(0),null);
var plugin = cljs.core.nth.call(null,vec__55448,(1),null);
if(cljs.core.truth_(plugin)){
var pl_55460 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__55441,chunk__55442,count__55443,i__55444,pl_55460,vec__55448,k,plugin,seq__55441__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_55460.call(null,msg_hist);
});})(seq__55441,chunk__55442,count__55443,i__55444,pl_55460,vec__55448,k,plugin,seq__55441__$1,temp__4657__auto__))
);
} else {
}

var G__55461 = cljs.core.next.call(null,seq__55441__$1);
var G__55462 = null;
var G__55463 = (0);
var G__55464 = (0);
seq__55441 = G__55461;
chunk__55442 = G__55462;
count__55443 = G__55463;
i__55444 = G__55464;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__55466 = arguments.length;
switch (G__55466) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__55467_55472 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__55468_55473 = null;
var count__55469_55474 = (0);
var i__55470_55475 = (0);
while(true){
if((i__55470_55475 < count__55469_55474)){
var msg_55476 = cljs.core._nth.call(null,chunk__55468_55473,i__55470_55475);
figwheel.client.socket.handle_incoming_message.call(null,msg_55476);

var G__55477 = seq__55467_55472;
var G__55478 = chunk__55468_55473;
var G__55479 = count__55469_55474;
var G__55480 = (i__55470_55475 + (1));
seq__55467_55472 = G__55477;
chunk__55468_55473 = G__55478;
count__55469_55474 = G__55479;
i__55470_55475 = G__55480;
continue;
} else {
var temp__4657__auto___55481 = cljs.core.seq.call(null,seq__55467_55472);
if(temp__4657__auto___55481){
var seq__55467_55482__$1 = temp__4657__auto___55481;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55467_55482__$1)){
var c__28980__auto___55483 = cljs.core.chunk_first.call(null,seq__55467_55482__$1);
var G__55484 = cljs.core.chunk_rest.call(null,seq__55467_55482__$1);
var G__55485 = c__28980__auto___55483;
var G__55486 = cljs.core.count.call(null,c__28980__auto___55483);
var G__55487 = (0);
seq__55467_55472 = G__55484;
chunk__55468_55473 = G__55485;
count__55469_55474 = G__55486;
i__55470_55475 = G__55487;
continue;
} else {
var msg_55488 = cljs.core.first.call(null,seq__55467_55482__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_55488);

var G__55489 = cljs.core.next.call(null,seq__55467_55482__$1);
var G__55490 = null;
var G__55491 = (0);
var G__55492 = (0);
seq__55467_55472 = G__55489;
chunk__55468_55473 = G__55490;
count__55469_55474 = G__55491;
i__55470_55475 = G__55492;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29319__auto__ = [];
var len__29312__auto___55497 = arguments.length;
var i__29313__auto___55498 = (0);
while(true){
if((i__29313__auto___55498 < len__29312__auto___55497)){
args__29319__auto__.push((arguments[i__29313__auto___55498]));

var G__55499 = (i__29313__auto___55498 + (1));
i__29313__auto___55498 = G__55499;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__55494){
var map__55495 = p__55494;
var map__55495__$1 = ((((!((map__55495 == null)))?((((map__55495.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55495.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55495):map__55495);
var opts = map__55495__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq55493){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq55493));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e55500){if((e55500 instanceof Error)){
var e = e55500;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e55500;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__55501){
var map__55502 = p__55501;
var map__55502__$1 = ((((!((map__55502 == null)))?((((map__55502.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55502.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55502):map__55502);
var msg_name = cljs.core.get.call(null,map__55502__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1511229556076
