// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28141__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28141__auto__){
return or__28141__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28141__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__54204_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__54204_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__54205 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__54206 = null;
var count__54207 = (0);
var i__54208 = (0);
while(true){
if((i__54208 < count__54207)){
var n = cljs.core._nth.call(null,chunk__54206,i__54208);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__54209 = seq__54205;
var G__54210 = chunk__54206;
var G__54211 = count__54207;
var G__54212 = (i__54208 + (1));
seq__54205 = G__54209;
chunk__54206 = G__54210;
count__54207 = G__54211;
i__54208 = G__54212;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__54205);
if(temp__4657__auto__){
var seq__54205__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54205__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__54205__$1);
var G__54213 = cljs.core.chunk_rest.call(null,seq__54205__$1);
var G__54214 = c__28980__auto__;
var G__54215 = cljs.core.count.call(null,c__28980__auto__);
var G__54216 = (0);
seq__54205 = G__54213;
chunk__54206 = G__54214;
count__54207 = G__54215;
i__54208 = G__54216;
continue;
} else {
var n = cljs.core.first.call(null,seq__54205__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__54217 = cljs.core.next.call(null,seq__54205__$1);
var G__54218 = null;
var G__54219 = (0);
var G__54220 = (0);
seq__54205 = G__54217;
chunk__54206 = G__54218;
count__54207 = G__54219;
i__54208 = G__54220;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__54230_54238 = cljs.core.seq.call(null,deps);
var chunk__54231_54239 = null;
var count__54232_54240 = (0);
var i__54233_54241 = (0);
while(true){
if((i__54233_54241 < count__54232_54240)){
var dep_54242 = cljs.core._nth.call(null,chunk__54231_54239,i__54233_54241);
topo_sort_helper_STAR_.call(null,dep_54242,(depth + (1)),state);

var G__54243 = seq__54230_54238;
var G__54244 = chunk__54231_54239;
var G__54245 = count__54232_54240;
var G__54246 = (i__54233_54241 + (1));
seq__54230_54238 = G__54243;
chunk__54231_54239 = G__54244;
count__54232_54240 = G__54245;
i__54233_54241 = G__54246;
continue;
} else {
var temp__4657__auto___54247 = cljs.core.seq.call(null,seq__54230_54238);
if(temp__4657__auto___54247){
var seq__54230_54248__$1 = temp__4657__auto___54247;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54230_54248__$1)){
var c__28980__auto___54249 = cljs.core.chunk_first.call(null,seq__54230_54248__$1);
var G__54250 = cljs.core.chunk_rest.call(null,seq__54230_54248__$1);
var G__54251 = c__28980__auto___54249;
var G__54252 = cljs.core.count.call(null,c__28980__auto___54249);
var G__54253 = (0);
seq__54230_54238 = G__54250;
chunk__54231_54239 = G__54251;
count__54232_54240 = G__54252;
i__54233_54241 = G__54253;
continue;
} else {
var dep_54254 = cljs.core.first.call(null,seq__54230_54248__$1);
topo_sort_helper_STAR_.call(null,dep_54254,(depth + (1)),state);

var G__54255 = cljs.core.next.call(null,seq__54230_54248__$1);
var G__54256 = null;
var G__54257 = (0);
var G__54258 = (0);
seq__54230_54238 = G__54255;
chunk__54231_54239 = G__54256;
count__54232_54240 = G__54257;
i__54233_54241 = G__54258;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__54234){
var vec__54235 = p__54234;
var seq__54236 = cljs.core.seq.call(null,vec__54235);
var first__54237 = cljs.core.first.call(null,seq__54236);
var seq__54236__$1 = cljs.core.next.call(null,seq__54236);
var x = first__54237;
var xs = seq__54236__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__54235,seq__54236,first__54237,seq__54236__$1,x,xs,get_deps__$1){
return (function (p1__54221_SHARP_){
return clojure.set.difference.call(null,p1__54221_SHARP_,x);
});})(vec__54235,seq__54236,first__54237,seq__54236__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__54259 = cljs.core.seq.call(null,provides);
var chunk__54260 = null;
var count__54261 = (0);
var i__54262 = (0);
while(true){
if((i__54262 < count__54261)){
var prov = cljs.core._nth.call(null,chunk__54260,i__54262);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__54263_54271 = cljs.core.seq.call(null,requires);
var chunk__54264_54272 = null;
var count__54265_54273 = (0);
var i__54266_54274 = (0);
while(true){
if((i__54266_54274 < count__54265_54273)){
var req_54275 = cljs.core._nth.call(null,chunk__54264_54272,i__54266_54274);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_54275,prov);

var G__54276 = seq__54263_54271;
var G__54277 = chunk__54264_54272;
var G__54278 = count__54265_54273;
var G__54279 = (i__54266_54274 + (1));
seq__54263_54271 = G__54276;
chunk__54264_54272 = G__54277;
count__54265_54273 = G__54278;
i__54266_54274 = G__54279;
continue;
} else {
var temp__4657__auto___54280 = cljs.core.seq.call(null,seq__54263_54271);
if(temp__4657__auto___54280){
var seq__54263_54281__$1 = temp__4657__auto___54280;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54263_54281__$1)){
var c__28980__auto___54282 = cljs.core.chunk_first.call(null,seq__54263_54281__$1);
var G__54283 = cljs.core.chunk_rest.call(null,seq__54263_54281__$1);
var G__54284 = c__28980__auto___54282;
var G__54285 = cljs.core.count.call(null,c__28980__auto___54282);
var G__54286 = (0);
seq__54263_54271 = G__54283;
chunk__54264_54272 = G__54284;
count__54265_54273 = G__54285;
i__54266_54274 = G__54286;
continue;
} else {
var req_54287 = cljs.core.first.call(null,seq__54263_54281__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_54287,prov);

var G__54288 = cljs.core.next.call(null,seq__54263_54281__$1);
var G__54289 = null;
var G__54290 = (0);
var G__54291 = (0);
seq__54263_54271 = G__54288;
chunk__54264_54272 = G__54289;
count__54265_54273 = G__54290;
i__54266_54274 = G__54291;
continue;
}
} else {
}
}
break;
}

var G__54292 = seq__54259;
var G__54293 = chunk__54260;
var G__54294 = count__54261;
var G__54295 = (i__54262 + (1));
seq__54259 = G__54292;
chunk__54260 = G__54293;
count__54261 = G__54294;
i__54262 = G__54295;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__54259);
if(temp__4657__auto__){
var seq__54259__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54259__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__54259__$1);
var G__54296 = cljs.core.chunk_rest.call(null,seq__54259__$1);
var G__54297 = c__28980__auto__;
var G__54298 = cljs.core.count.call(null,c__28980__auto__);
var G__54299 = (0);
seq__54259 = G__54296;
chunk__54260 = G__54297;
count__54261 = G__54298;
i__54262 = G__54299;
continue;
} else {
var prov = cljs.core.first.call(null,seq__54259__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__54267_54300 = cljs.core.seq.call(null,requires);
var chunk__54268_54301 = null;
var count__54269_54302 = (0);
var i__54270_54303 = (0);
while(true){
if((i__54270_54303 < count__54269_54302)){
var req_54304 = cljs.core._nth.call(null,chunk__54268_54301,i__54270_54303);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_54304,prov);

var G__54305 = seq__54267_54300;
var G__54306 = chunk__54268_54301;
var G__54307 = count__54269_54302;
var G__54308 = (i__54270_54303 + (1));
seq__54267_54300 = G__54305;
chunk__54268_54301 = G__54306;
count__54269_54302 = G__54307;
i__54270_54303 = G__54308;
continue;
} else {
var temp__4657__auto___54309__$1 = cljs.core.seq.call(null,seq__54267_54300);
if(temp__4657__auto___54309__$1){
var seq__54267_54310__$1 = temp__4657__auto___54309__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54267_54310__$1)){
var c__28980__auto___54311 = cljs.core.chunk_first.call(null,seq__54267_54310__$1);
var G__54312 = cljs.core.chunk_rest.call(null,seq__54267_54310__$1);
var G__54313 = c__28980__auto___54311;
var G__54314 = cljs.core.count.call(null,c__28980__auto___54311);
var G__54315 = (0);
seq__54267_54300 = G__54312;
chunk__54268_54301 = G__54313;
count__54269_54302 = G__54314;
i__54270_54303 = G__54315;
continue;
} else {
var req_54316 = cljs.core.first.call(null,seq__54267_54310__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_54316,prov);

var G__54317 = cljs.core.next.call(null,seq__54267_54310__$1);
var G__54318 = null;
var G__54319 = (0);
var G__54320 = (0);
seq__54267_54300 = G__54317;
chunk__54268_54301 = G__54318;
count__54269_54302 = G__54319;
i__54270_54303 = G__54320;
continue;
}
} else {
}
}
break;
}

var G__54321 = cljs.core.next.call(null,seq__54259__$1);
var G__54322 = null;
var G__54323 = (0);
var G__54324 = (0);
seq__54259 = G__54321;
chunk__54260 = G__54322;
count__54261 = G__54323;
i__54262 = G__54324;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__54325_54329 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__54326_54330 = null;
var count__54327_54331 = (0);
var i__54328_54332 = (0);
while(true){
if((i__54328_54332 < count__54327_54331)){
var ns_54333 = cljs.core._nth.call(null,chunk__54326_54330,i__54328_54332);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_54333);

var G__54334 = seq__54325_54329;
var G__54335 = chunk__54326_54330;
var G__54336 = count__54327_54331;
var G__54337 = (i__54328_54332 + (1));
seq__54325_54329 = G__54334;
chunk__54326_54330 = G__54335;
count__54327_54331 = G__54336;
i__54328_54332 = G__54337;
continue;
} else {
var temp__4657__auto___54338 = cljs.core.seq.call(null,seq__54325_54329);
if(temp__4657__auto___54338){
var seq__54325_54339__$1 = temp__4657__auto___54338;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54325_54339__$1)){
var c__28980__auto___54340 = cljs.core.chunk_first.call(null,seq__54325_54339__$1);
var G__54341 = cljs.core.chunk_rest.call(null,seq__54325_54339__$1);
var G__54342 = c__28980__auto___54340;
var G__54343 = cljs.core.count.call(null,c__28980__auto___54340);
var G__54344 = (0);
seq__54325_54329 = G__54341;
chunk__54326_54330 = G__54342;
count__54327_54331 = G__54343;
i__54328_54332 = G__54344;
continue;
} else {
var ns_54345 = cljs.core.first.call(null,seq__54325_54339__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_54345);

var G__54346 = cljs.core.next.call(null,seq__54325_54339__$1);
var G__54347 = null;
var G__54348 = (0);
var G__54349 = (0);
seq__54325_54329 = G__54346;
chunk__54326_54330 = G__54347;
count__54327_54331 = G__54348;
i__54328_54332 = G__54349;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28141__auto__ = goog.require__;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__54350__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__54350 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__54351__i = 0, G__54351__a = new Array(arguments.length -  0);
while (G__54351__i < G__54351__a.length) {G__54351__a[G__54351__i] = arguments[G__54351__i + 0]; ++G__54351__i;}
  args = new cljs.core.IndexedSeq(G__54351__a,0,null);
} 
return G__54350__delegate.call(this,args);};
G__54350.cljs$lang$maxFixedArity = 0;
G__54350.cljs$lang$applyTo = (function (arglist__54352){
var args = cljs.core.seq(arglist__54352);
return G__54350__delegate(args);
});
G__54350.cljs$core$IFn$_invoke$arity$variadic = G__54350__delegate;
return G__54350;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__54353_SHARP_,p2__54354_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__54353_SHARP_)].join('')),p2__54354_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__54355_SHARP_,p2__54356_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__54355_SHARP_)].join(''),p2__54356_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__54357 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__54357.addCallback(((function (G__54357){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__54357))
);

G__54357.addErrback(((function (G__54357){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__54357))
);

return G__54357;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__54358 = cljs.core._EQ_;
var expr__54359 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__54358.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__54359))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__54358,expr__54359){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__54358,expr__54359))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__54358,expr__54359){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e54361){if((e54361 instanceof Error)){
var e = e54361;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e54361;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__54358,expr__54359))
} else {
if(cljs.core.truth_(pred__54358.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__54359))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__54358.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__54359))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__54358.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__54359))){
return ((function (pred__54358,expr__54359){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e54362){if((e54362 instanceof Error)){
var e = e54362;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e54362;

}
}})());
});
;})(pred__54358,expr__54359))
} else {
return ((function (pred__54358,expr__54359){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__54358,expr__54359))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__54363,callback){
var map__54364 = p__54363;
var map__54364__$1 = ((((!((map__54364 == null)))?((((map__54364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54364.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54364):map__54364);
var file_msg = map__54364__$1;
var request_url = cljs.core.get.call(null,map__54364__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__54364,map__54364__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__54364,map__54364__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_54388){
var state_val_54389 = (state_54388[(1)]);
if((state_val_54389 === (7))){
var inst_54384 = (state_54388[(2)]);
var state_54388__$1 = state_54388;
var statearr_54390_54407 = state_54388__$1;
(statearr_54390_54407[(2)] = inst_54384);

(statearr_54390_54407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54389 === (1))){
var state_54388__$1 = state_54388;
var statearr_54391_54408 = state_54388__$1;
(statearr_54391_54408[(2)] = null);

(statearr_54391_54408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54389 === (4))){
var inst_54368 = (state_54388[(7)]);
var inst_54368__$1 = (state_54388[(2)]);
var state_54388__$1 = (function (){var statearr_54392 = state_54388;
(statearr_54392[(7)] = inst_54368__$1);

return statearr_54392;
})();
if(cljs.core.truth_(inst_54368__$1)){
var statearr_54393_54409 = state_54388__$1;
(statearr_54393_54409[(1)] = (5));

} else {
var statearr_54394_54410 = state_54388__$1;
(statearr_54394_54410[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54389 === (6))){
var state_54388__$1 = state_54388;
var statearr_54395_54411 = state_54388__$1;
(statearr_54395_54411[(2)] = null);

(statearr_54395_54411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54389 === (3))){
var inst_54386 = (state_54388[(2)]);
var state_54388__$1 = state_54388;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54388__$1,inst_54386);
} else {
if((state_val_54389 === (2))){
var state_54388__$1 = state_54388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54388__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_54389 === (11))){
var inst_54380 = (state_54388[(2)]);
var state_54388__$1 = (function (){var statearr_54396 = state_54388;
(statearr_54396[(8)] = inst_54380);

return statearr_54396;
})();
var statearr_54397_54412 = state_54388__$1;
(statearr_54397_54412[(2)] = null);

(statearr_54397_54412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54389 === (9))){
var inst_54374 = (state_54388[(9)]);
var inst_54372 = (state_54388[(10)]);
var inst_54376 = inst_54374.call(null,inst_54372);
var state_54388__$1 = state_54388;
var statearr_54398_54413 = state_54388__$1;
(statearr_54398_54413[(2)] = inst_54376);

(statearr_54398_54413[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54389 === (5))){
var inst_54368 = (state_54388[(7)]);
var inst_54370 = figwheel.client.file_reloading.blocking_load.call(null,inst_54368);
var state_54388__$1 = state_54388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54388__$1,(8),inst_54370);
} else {
if((state_val_54389 === (10))){
var inst_54372 = (state_54388[(10)]);
var inst_54378 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_54372);
var state_54388__$1 = state_54388;
var statearr_54399_54414 = state_54388__$1;
(statearr_54399_54414[(2)] = inst_54378);

(statearr_54399_54414[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54389 === (8))){
var inst_54374 = (state_54388[(9)]);
var inst_54368 = (state_54388[(7)]);
var inst_54372 = (state_54388[(2)]);
var inst_54373 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_54374__$1 = cljs.core.get.call(null,inst_54373,inst_54368);
var state_54388__$1 = (function (){var statearr_54400 = state_54388;
(statearr_54400[(9)] = inst_54374__$1);

(statearr_54400[(10)] = inst_54372);

return statearr_54400;
})();
if(cljs.core.truth_(inst_54374__$1)){
var statearr_54401_54415 = state_54388__$1;
(statearr_54401_54415[(1)] = (9));

} else {
var statearr_54402_54416 = state_54388__$1;
(statearr_54402_54416[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__42016__auto__ = null;
var figwheel$client$file_reloading$state_machine__42016__auto____0 = (function (){
var statearr_54403 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54403[(0)] = figwheel$client$file_reloading$state_machine__42016__auto__);

(statearr_54403[(1)] = (1));

return statearr_54403;
});
var figwheel$client$file_reloading$state_machine__42016__auto____1 = (function (state_54388){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_54388);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e54404){if((e54404 instanceof Object)){
var ex__42019__auto__ = e54404;
var statearr_54405_54417 = state_54388;
(statearr_54405_54417[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54388);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54404;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54418 = state_54388;
state_54388 = G__54418;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__42016__auto__ = function(state_54388){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__42016__auto____1.call(this,state_54388);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__42016__auto____0;
figwheel$client$file_reloading$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__42016__auto____1;
return figwheel$client$file_reloading$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_54406 = f__42037__auto__.call(null);
(statearr_54406[(6)] = c__42036__auto__);

return statearr_54406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__54419,callback){
var map__54420 = p__54419;
var map__54420__$1 = ((((!((map__54420 == null)))?((((map__54420.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54420.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54420):map__54420);
var file_msg = map__54420__$1;
var namespace = cljs.core.get.call(null,map__54420__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__54420,map__54420__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__54420,map__54420__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__54422){
var map__54423 = p__54422;
var map__54423__$1 = ((((!((map__54423 == null)))?((((map__54423.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54423.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54423):map__54423);
var file_msg = map__54423__$1;
var namespace = cljs.core.get.call(null,map__54423__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__54425){
var map__54426 = p__54425;
var map__54426__$1 = ((((!((map__54426 == null)))?((((map__54426.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54426.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54426):map__54426);
var file_msg = map__54426__$1;
var namespace = cljs.core.get.call(null,map__54426__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28129__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28129__auto__){
var or__28141__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28129__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__54428,callback){
var map__54429 = p__54428;
var map__54429__$1 = ((((!((map__54429 == null)))?((((map__54429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54429.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54429):map__54429);
var file_msg = map__54429__$1;
var request_url = cljs.core.get.call(null,map__54429__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__54429__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__42036__auto___54479 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___54479,out){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___54479,out){
return (function (state_54464){
var state_val_54465 = (state_54464[(1)]);
if((state_val_54465 === (1))){
var inst_54438 = cljs.core.seq.call(null,files);
var inst_54439 = cljs.core.first.call(null,inst_54438);
var inst_54440 = cljs.core.next.call(null,inst_54438);
var inst_54441 = files;
var state_54464__$1 = (function (){var statearr_54466 = state_54464;
(statearr_54466[(7)] = inst_54439);

(statearr_54466[(8)] = inst_54441);

(statearr_54466[(9)] = inst_54440);

return statearr_54466;
})();
var statearr_54467_54480 = state_54464__$1;
(statearr_54467_54480[(2)] = null);

(statearr_54467_54480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54465 === (2))){
var inst_54447 = (state_54464[(10)]);
var inst_54441 = (state_54464[(8)]);
var inst_54446 = cljs.core.seq.call(null,inst_54441);
var inst_54447__$1 = cljs.core.first.call(null,inst_54446);
var inst_54448 = cljs.core.next.call(null,inst_54446);
var inst_54449 = (inst_54447__$1 == null);
var inst_54450 = cljs.core.not.call(null,inst_54449);
var state_54464__$1 = (function (){var statearr_54468 = state_54464;
(statearr_54468[(10)] = inst_54447__$1);

(statearr_54468[(11)] = inst_54448);

return statearr_54468;
})();
if(inst_54450){
var statearr_54469_54481 = state_54464__$1;
(statearr_54469_54481[(1)] = (4));

} else {
var statearr_54470_54482 = state_54464__$1;
(statearr_54470_54482[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54465 === (3))){
var inst_54462 = (state_54464[(2)]);
var state_54464__$1 = state_54464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54464__$1,inst_54462);
} else {
if((state_val_54465 === (4))){
var inst_54447 = (state_54464[(10)]);
var inst_54452 = figwheel.client.file_reloading.reload_js_file.call(null,inst_54447);
var state_54464__$1 = state_54464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54464__$1,(7),inst_54452);
} else {
if((state_val_54465 === (5))){
var inst_54458 = cljs.core.async.close_BANG_.call(null,out);
var state_54464__$1 = state_54464;
var statearr_54471_54483 = state_54464__$1;
(statearr_54471_54483[(2)] = inst_54458);

(statearr_54471_54483[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54465 === (6))){
var inst_54460 = (state_54464[(2)]);
var state_54464__$1 = state_54464;
var statearr_54472_54484 = state_54464__$1;
(statearr_54472_54484[(2)] = inst_54460);

(statearr_54472_54484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54465 === (7))){
var inst_54448 = (state_54464[(11)]);
var inst_54454 = (state_54464[(2)]);
var inst_54455 = cljs.core.async.put_BANG_.call(null,out,inst_54454);
var inst_54441 = inst_54448;
var state_54464__$1 = (function (){var statearr_54473 = state_54464;
(statearr_54473[(8)] = inst_54441);

(statearr_54473[(12)] = inst_54455);

return statearr_54473;
})();
var statearr_54474_54485 = state_54464__$1;
(statearr_54474_54485[(2)] = null);

(statearr_54474_54485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__42036__auto___54479,out))
;
return ((function (switch__42015__auto__,c__42036__auto___54479,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____0 = (function (){
var statearr_54475 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54475[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__);

(statearr_54475[(1)] = (1));

return statearr_54475;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____1 = (function (state_54464){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_54464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e54476){if((e54476 instanceof Object)){
var ex__42019__auto__ = e54476;
var statearr_54477_54486 = state_54464;
(statearr_54477_54486[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54476;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54487 = state_54464;
state_54464 = G__54487;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__ = function(state_54464){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____1.call(this,state_54464);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___54479,out))
})();
var state__42038__auto__ = (function (){var statearr_54478 = f__42037__auto__.call(null);
(statearr_54478[(6)] = c__42036__auto___54479);

return statearr_54478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___54479,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__54488,opts){
var map__54489 = p__54488;
var map__54489__$1 = ((((!((map__54489 == null)))?((((map__54489.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54489.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54489):map__54489);
var eval_body = cljs.core.get.call(null,map__54489__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__54489__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28129__auto__ = eval_body;
if(cljs.core.truth_(and__28129__auto__)){
return typeof eval_body === 'string';
} else {
return and__28129__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e54491){var e = e54491;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__54492_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__54492_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__54493){
var vec__54494 = p__54493;
var k = cljs.core.nth.call(null,vec__54494,(0),null);
var v = cljs.core.nth.call(null,vec__54494,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__54497){
var vec__54498 = p__54497;
var k = cljs.core.nth.call(null,vec__54498,(0),null);
var v = cljs.core.nth.call(null,vec__54498,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__54504,p__54505){
var map__54506 = p__54504;
var map__54506__$1 = ((((!((map__54506 == null)))?((((map__54506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54506.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54506):map__54506);
var opts = map__54506__$1;
var before_jsload = cljs.core.get.call(null,map__54506__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__54506__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__54506__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__54507 = p__54505;
var map__54507__$1 = ((((!((map__54507 == null)))?((((map__54507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54507.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54507):map__54507);
var msg = map__54507__$1;
var files = cljs.core.get.call(null,map__54507__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__54507__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__54507__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_54661){
var state_val_54662 = (state_54661[(1)]);
if((state_val_54662 === (7))){
var inst_54524 = (state_54661[(7)]);
var inst_54521 = (state_54661[(8)]);
var inst_54522 = (state_54661[(9)]);
var inst_54523 = (state_54661[(10)]);
var inst_54529 = cljs.core._nth.call(null,inst_54522,inst_54524);
var inst_54530 = figwheel.client.file_reloading.eval_body.call(null,inst_54529,opts);
var inst_54531 = (inst_54524 + (1));
var tmp54663 = inst_54521;
var tmp54664 = inst_54522;
var tmp54665 = inst_54523;
var inst_54521__$1 = tmp54663;
var inst_54522__$1 = tmp54664;
var inst_54523__$1 = tmp54665;
var inst_54524__$1 = inst_54531;
var state_54661__$1 = (function (){var statearr_54666 = state_54661;
(statearr_54666[(7)] = inst_54524__$1);

(statearr_54666[(8)] = inst_54521__$1);

(statearr_54666[(9)] = inst_54522__$1);

(statearr_54666[(10)] = inst_54523__$1);

(statearr_54666[(11)] = inst_54530);

return statearr_54666;
})();
var statearr_54667_54750 = state_54661__$1;
(statearr_54667_54750[(2)] = null);

(statearr_54667_54750[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (20))){
var inst_54564 = (state_54661[(12)]);
var inst_54572 = figwheel.client.file_reloading.sort_files.call(null,inst_54564);
var state_54661__$1 = state_54661;
var statearr_54668_54751 = state_54661__$1;
(statearr_54668_54751[(2)] = inst_54572);

(statearr_54668_54751[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (27))){
var state_54661__$1 = state_54661;
var statearr_54669_54752 = state_54661__$1;
(statearr_54669_54752[(2)] = null);

(statearr_54669_54752[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (1))){
var inst_54513 = (state_54661[(13)]);
var inst_54510 = before_jsload.call(null,files);
var inst_54511 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_54512 = (function (){return ((function (inst_54513,inst_54510,inst_54511,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__54501_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__54501_SHARP_);
});
;})(inst_54513,inst_54510,inst_54511,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_54513__$1 = cljs.core.filter.call(null,inst_54512,files);
var inst_54514 = cljs.core.not_empty.call(null,inst_54513__$1);
var state_54661__$1 = (function (){var statearr_54670 = state_54661;
(statearr_54670[(13)] = inst_54513__$1);

(statearr_54670[(14)] = inst_54511);

(statearr_54670[(15)] = inst_54510);

return statearr_54670;
})();
if(cljs.core.truth_(inst_54514)){
var statearr_54671_54753 = state_54661__$1;
(statearr_54671_54753[(1)] = (2));

} else {
var statearr_54672_54754 = state_54661__$1;
(statearr_54672_54754[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (24))){
var state_54661__$1 = state_54661;
var statearr_54673_54755 = state_54661__$1;
(statearr_54673_54755[(2)] = null);

(statearr_54673_54755[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (39))){
var inst_54614 = (state_54661[(16)]);
var state_54661__$1 = state_54661;
var statearr_54674_54756 = state_54661__$1;
(statearr_54674_54756[(2)] = inst_54614);

(statearr_54674_54756[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (46))){
var inst_54656 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
var statearr_54675_54757 = state_54661__$1;
(statearr_54675_54757[(2)] = inst_54656);

(statearr_54675_54757[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (4))){
var inst_54558 = (state_54661[(2)]);
var inst_54559 = cljs.core.List.EMPTY;
var inst_54560 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_54559);
var inst_54561 = (function (){return ((function (inst_54558,inst_54559,inst_54560,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__54502_SHARP_){
var and__28129__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__54502_SHARP_);
if(cljs.core.truth_(and__28129__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__54502_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__54502_SHARP_)));
} else {
return and__28129__auto__;
}
});
;})(inst_54558,inst_54559,inst_54560,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_54562 = cljs.core.filter.call(null,inst_54561,files);
var inst_54563 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_54564 = cljs.core.concat.call(null,inst_54562,inst_54563);
var state_54661__$1 = (function (){var statearr_54676 = state_54661;
(statearr_54676[(17)] = inst_54558);

(statearr_54676[(18)] = inst_54560);

(statearr_54676[(12)] = inst_54564);

return statearr_54676;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_54677_54758 = state_54661__$1;
(statearr_54677_54758[(1)] = (16));

} else {
var statearr_54678_54759 = state_54661__$1;
(statearr_54678_54759[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (15))){
var inst_54548 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
var statearr_54679_54760 = state_54661__$1;
(statearr_54679_54760[(2)] = inst_54548);

(statearr_54679_54760[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (21))){
var inst_54574 = (state_54661[(19)]);
var inst_54574__$1 = (state_54661[(2)]);
var inst_54575 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_54574__$1);
var state_54661__$1 = (function (){var statearr_54680 = state_54661;
(statearr_54680[(19)] = inst_54574__$1);

return statearr_54680;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54661__$1,(22),inst_54575);
} else {
if((state_val_54662 === (31))){
var inst_54659 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54661__$1,inst_54659);
} else {
if((state_val_54662 === (32))){
var inst_54614 = (state_54661[(16)]);
var inst_54619 = inst_54614.cljs$lang$protocol_mask$partition0$;
var inst_54620 = (inst_54619 & (64));
var inst_54621 = inst_54614.cljs$core$ISeq$;
var inst_54622 = (cljs.core.PROTOCOL_SENTINEL === inst_54621);
var inst_54623 = (inst_54620) || (inst_54622);
var state_54661__$1 = state_54661;
if(cljs.core.truth_(inst_54623)){
var statearr_54681_54761 = state_54661__$1;
(statearr_54681_54761[(1)] = (35));

} else {
var statearr_54682_54762 = state_54661__$1;
(statearr_54682_54762[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (40))){
var inst_54636 = (state_54661[(20)]);
var inst_54635 = (state_54661[(2)]);
var inst_54636__$1 = cljs.core.get.call(null,inst_54635,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_54637 = cljs.core.get.call(null,inst_54635,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_54638 = cljs.core.not_empty.call(null,inst_54636__$1);
var state_54661__$1 = (function (){var statearr_54683 = state_54661;
(statearr_54683[(20)] = inst_54636__$1);

(statearr_54683[(21)] = inst_54637);

return statearr_54683;
})();
if(cljs.core.truth_(inst_54638)){
var statearr_54684_54763 = state_54661__$1;
(statearr_54684_54763[(1)] = (41));

} else {
var statearr_54685_54764 = state_54661__$1;
(statearr_54685_54764[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (33))){
var state_54661__$1 = state_54661;
var statearr_54686_54765 = state_54661__$1;
(statearr_54686_54765[(2)] = false);

(statearr_54686_54765[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (13))){
var inst_54534 = (state_54661[(22)]);
var inst_54538 = cljs.core.chunk_first.call(null,inst_54534);
var inst_54539 = cljs.core.chunk_rest.call(null,inst_54534);
var inst_54540 = cljs.core.count.call(null,inst_54538);
var inst_54521 = inst_54539;
var inst_54522 = inst_54538;
var inst_54523 = inst_54540;
var inst_54524 = (0);
var state_54661__$1 = (function (){var statearr_54687 = state_54661;
(statearr_54687[(7)] = inst_54524);

(statearr_54687[(8)] = inst_54521);

(statearr_54687[(9)] = inst_54522);

(statearr_54687[(10)] = inst_54523);

return statearr_54687;
})();
var statearr_54688_54766 = state_54661__$1;
(statearr_54688_54766[(2)] = null);

(statearr_54688_54766[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (22))){
var inst_54578 = (state_54661[(23)]);
var inst_54574 = (state_54661[(19)]);
var inst_54582 = (state_54661[(24)]);
var inst_54577 = (state_54661[(25)]);
var inst_54577__$1 = (state_54661[(2)]);
var inst_54578__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_54577__$1);
var inst_54579 = (function (){var all_files = inst_54574;
var res_SINGLEQUOTE_ = inst_54577__$1;
var res = inst_54578__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_54578,inst_54574,inst_54582,inst_54577,inst_54577__$1,inst_54578__$1,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__54503_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__54503_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_54578,inst_54574,inst_54582,inst_54577,inst_54577__$1,inst_54578__$1,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_54580 = cljs.core.filter.call(null,inst_54579,inst_54577__$1);
var inst_54581 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_54582__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_54581);
var inst_54583 = cljs.core.not_empty.call(null,inst_54582__$1);
var state_54661__$1 = (function (){var statearr_54689 = state_54661;
(statearr_54689[(23)] = inst_54578__$1);

(statearr_54689[(26)] = inst_54580);

(statearr_54689[(24)] = inst_54582__$1);

(statearr_54689[(25)] = inst_54577__$1);

return statearr_54689;
})();
if(cljs.core.truth_(inst_54583)){
var statearr_54690_54767 = state_54661__$1;
(statearr_54690_54767[(1)] = (23));

} else {
var statearr_54691_54768 = state_54661__$1;
(statearr_54691_54768[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (36))){
var state_54661__$1 = state_54661;
var statearr_54692_54769 = state_54661__$1;
(statearr_54692_54769[(2)] = false);

(statearr_54692_54769[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (41))){
var inst_54636 = (state_54661[(20)]);
var inst_54640 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_54641 = cljs.core.map.call(null,inst_54640,inst_54636);
var inst_54642 = cljs.core.pr_str.call(null,inst_54641);
var inst_54643 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54642)].join('');
var inst_54644 = figwheel.client.utils.log.call(null,inst_54643);
var state_54661__$1 = state_54661;
var statearr_54693_54770 = state_54661__$1;
(statearr_54693_54770[(2)] = inst_54644);

(statearr_54693_54770[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (43))){
var inst_54637 = (state_54661[(21)]);
var inst_54647 = (state_54661[(2)]);
var inst_54648 = cljs.core.not_empty.call(null,inst_54637);
var state_54661__$1 = (function (){var statearr_54694 = state_54661;
(statearr_54694[(27)] = inst_54647);

return statearr_54694;
})();
if(cljs.core.truth_(inst_54648)){
var statearr_54695_54771 = state_54661__$1;
(statearr_54695_54771[(1)] = (44));

} else {
var statearr_54696_54772 = state_54661__$1;
(statearr_54696_54772[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (29))){
var inst_54578 = (state_54661[(23)]);
var inst_54580 = (state_54661[(26)]);
var inst_54574 = (state_54661[(19)]);
var inst_54614 = (state_54661[(16)]);
var inst_54582 = (state_54661[(24)]);
var inst_54577 = (state_54661[(25)]);
var inst_54610 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_54613 = (function (){var all_files = inst_54574;
var res_SINGLEQUOTE_ = inst_54577;
var res = inst_54578;
var files_not_loaded = inst_54580;
var dependencies_that_loaded = inst_54582;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_54578,inst_54580,inst_54574,inst_54614,inst_54582,inst_54577,inst_54610,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__54612){
var map__54697 = p__54612;
var map__54697__$1 = ((((!((map__54697 == null)))?((((map__54697.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54697.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54697):map__54697);
var namespace = cljs.core.get.call(null,map__54697__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_54578,inst_54580,inst_54574,inst_54614,inst_54582,inst_54577,inst_54610,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_54614__$1 = cljs.core.group_by.call(null,inst_54613,inst_54580);
var inst_54616 = (inst_54614__$1 == null);
var inst_54617 = cljs.core.not.call(null,inst_54616);
var state_54661__$1 = (function (){var statearr_54699 = state_54661;
(statearr_54699[(16)] = inst_54614__$1);

(statearr_54699[(28)] = inst_54610);

return statearr_54699;
})();
if(inst_54617){
var statearr_54700_54773 = state_54661__$1;
(statearr_54700_54773[(1)] = (32));

} else {
var statearr_54701_54774 = state_54661__$1;
(statearr_54701_54774[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (44))){
var inst_54637 = (state_54661[(21)]);
var inst_54650 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_54637);
var inst_54651 = cljs.core.pr_str.call(null,inst_54650);
var inst_54652 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54651)].join('');
var inst_54653 = figwheel.client.utils.log.call(null,inst_54652);
var state_54661__$1 = state_54661;
var statearr_54702_54775 = state_54661__$1;
(statearr_54702_54775[(2)] = inst_54653);

(statearr_54702_54775[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (6))){
var inst_54555 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
var statearr_54703_54776 = state_54661__$1;
(statearr_54703_54776[(2)] = inst_54555);

(statearr_54703_54776[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (28))){
var inst_54580 = (state_54661[(26)]);
var inst_54607 = (state_54661[(2)]);
var inst_54608 = cljs.core.not_empty.call(null,inst_54580);
var state_54661__$1 = (function (){var statearr_54704 = state_54661;
(statearr_54704[(29)] = inst_54607);

return statearr_54704;
})();
if(cljs.core.truth_(inst_54608)){
var statearr_54705_54777 = state_54661__$1;
(statearr_54705_54777[(1)] = (29));

} else {
var statearr_54706_54778 = state_54661__$1;
(statearr_54706_54778[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (25))){
var inst_54578 = (state_54661[(23)]);
var inst_54594 = (state_54661[(2)]);
var inst_54595 = cljs.core.not_empty.call(null,inst_54578);
var state_54661__$1 = (function (){var statearr_54707 = state_54661;
(statearr_54707[(30)] = inst_54594);

return statearr_54707;
})();
if(cljs.core.truth_(inst_54595)){
var statearr_54708_54779 = state_54661__$1;
(statearr_54708_54779[(1)] = (26));

} else {
var statearr_54709_54780 = state_54661__$1;
(statearr_54709_54780[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (34))){
var inst_54630 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
if(cljs.core.truth_(inst_54630)){
var statearr_54710_54781 = state_54661__$1;
(statearr_54710_54781[(1)] = (38));

} else {
var statearr_54711_54782 = state_54661__$1;
(statearr_54711_54782[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (17))){
var state_54661__$1 = state_54661;
var statearr_54712_54783 = state_54661__$1;
(statearr_54712_54783[(2)] = recompile_dependents);

(statearr_54712_54783[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (3))){
var state_54661__$1 = state_54661;
var statearr_54713_54784 = state_54661__$1;
(statearr_54713_54784[(2)] = null);

(statearr_54713_54784[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (12))){
var inst_54551 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
var statearr_54714_54785 = state_54661__$1;
(statearr_54714_54785[(2)] = inst_54551);

(statearr_54714_54785[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (2))){
var inst_54513 = (state_54661[(13)]);
var inst_54520 = cljs.core.seq.call(null,inst_54513);
var inst_54521 = inst_54520;
var inst_54522 = null;
var inst_54523 = (0);
var inst_54524 = (0);
var state_54661__$1 = (function (){var statearr_54715 = state_54661;
(statearr_54715[(7)] = inst_54524);

(statearr_54715[(8)] = inst_54521);

(statearr_54715[(9)] = inst_54522);

(statearr_54715[(10)] = inst_54523);

return statearr_54715;
})();
var statearr_54716_54786 = state_54661__$1;
(statearr_54716_54786[(2)] = null);

(statearr_54716_54786[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (23))){
var inst_54578 = (state_54661[(23)]);
var inst_54580 = (state_54661[(26)]);
var inst_54574 = (state_54661[(19)]);
var inst_54582 = (state_54661[(24)]);
var inst_54577 = (state_54661[(25)]);
var inst_54585 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_54587 = (function (){var all_files = inst_54574;
var res_SINGLEQUOTE_ = inst_54577;
var res = inst_54578;
var files_not_loaded = inst_54580;
var dependencies_that_loaded = inst_54582;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_54578,inst_54580,inst_54574,inst_54582,inst_54577,inst_54585,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__54586){
var map__54717 = p__54586;
var map__54717__$1 = ((((!((map__54717 == null)))?((((map__54717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54717.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54717):map__54717);
var request_url = cljs.core.get.call(null,map__54717__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_54578,inst_54580,inst_54574,inst_54582,inst_54577,inst_54585,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_54588 = cljs.core.reverse.call(null,inst_54582);
var inst_54589 = cljs.core.map.call(null,inst_54587,inst_54588);
var inst_54590 = cljs.core.pr_str.call(null,inst_54589);
var inst_54591 = figwheel.client.utils.log.call(null,inst_54590);
var state_54661__$1 = (function (){var statearr_54719 = state_54661;
(statearr_54719[(31)] = inst_54585);

return statearr_54719;
})();
var statearr_54720_54787 = state_54661__$1;
(statearr_54720_54787[(2)] = inst_54591);

(statearr_54720_54787[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (35))){
var state_54661__$1 = state_54661;
var statearr_54721_54788 = state_54661__$1;
(statearr_54721_54788[(2)] = true);

(statearr_54721_54788[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (19))){
var inst_54564 = (state_54661[(12)]);
var inst_54570 = figwheel.client.file_reloading.expand_files.call(null,inst_54564);
var state_54661__$1 = state_54661;
var statearr_54722_54789 = state_54661__$1;
(statearr_54722_54789[(2)] = inst_54570);

(statearr_54722_54789[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (11))){
var state_54661__$1 = state_54661;
var statearr_54723_54790 = state_54661__$1;
(statearr_54723_54790[(2)] = null);

(statearr_54723_54790[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (9))){
var inst_54553 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
var statearr_54724_54791 = state_54661__$1;
(statearr_54724_54791[(2)] = inst_54553);

(statearr_54724_54791[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (5))){
var inst_54524 = (state_54661[(7)]);
var inst_54523 = (state_54661[(10)]);
var inst_54526 = (inst_54524 < inst_54523);
var inst_54527 = inst_54526;
var state_54661__$1 = state_54661;
if(cljs.core.truth_(inst_54527)){
var statearr_54725_54792 = state_54661__$1;
(statearr_54725_54792[(1)] = (7));

} else {
var statearr_54726_54793 = state_54661__$1;
(statearr_54726_54793[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (14))){
var inst_54534 = (state_54661[(22)]);
var inst_54543 = cljs.core.first.call(null,inst_54534);
var inst_54544 = figwheel.client.file_reloading.eval_body.call(null,inst_54543,opts);
var inst_54545 = cljs.core.next.call(null,inst_54534);
var inst_54521 = inst_54545;
var inst_54522 = null;
var inst_54523 = (0);
var inst_54524 = (0);
var state_54661__$1 = (function (){var statearr_54727 = state_54661;
(statearr_54727[(7)] = inst_54524);

(statearr_54727[(32)] = inst_54544);

(statearr_54727[(8)] = inst_54521);

(statearr_54727[(9)] = inst_54522);

(statearr_54727[(10)] = inst_54523);

return statearr_54727;
})();
var statearr_54728_54794 = state_54661__$1;
(statearr_54728_54794[(2)] = null);

(statearr_54728_54794[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (45))){
var state_54661__$1 = state_54661;
var statearr_54729_54795 = state_54661__$1;
(statearr_54729_54795[(2)] = null);

(statearr_54729_54795[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (26))){
var inst_54578 = (state_54661[(23)]);
var inst_54580 = (state_54661[(26)]);
var inst_54574 = (state_54661[(19)]);
var inst_54582 = (state_54661[(24)]);
var inst_54577 = (state_54661[(25)]);
var inst_54597 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_54599 = (function (){var all_files = inst_54574;
var res_SINGLEQUOTE_ = inst_54577;
var res = inst_54578;
var files_not_loaded = inst_54580;
var dependencies_that_loaded = inst_54582;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_54578,inst_54580,inst_54574,inst_54582,inst_54577,inst_54597,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__54598){
var map__54730 = p__54598;
var map__54730__$1 = ((((!((map__54730 == null)))?((((map__54730.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54730.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54730):map__54730);
var namespace = cljs.core.get.call(null,map__54730__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__54730__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_54578,inst_54580,inst_54574,inst_54582,inst_54577,inst_54597,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_54600 = cljs.core.map.call(null,inst_54599,inst_54578);
var inst_54601 = cljs.core.pr_str.call(null,inst_54600);
var inst_54602 = figwheel.client.utils.log.call(null,inst_54601);
var inst_54603 = (function (){var all_files = inst_54574;
var res_SINGLEQUOTE_ = inst_54577;
var res = inst_54578;
var files_not_loaded = inst_54580;
var dependencies_that_loaded = inst_54582;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_54578,inst_54580,inst_54574,inst_54582,inst_54577,inst_54597,inst_54599,inst_54600,inst_54601,inst_54602,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_54578,inst_54580,inst_54574,inst_54582,inst_54577,inst_54597,inst_54599,inst_54600,inst_54601,inst_54602,state_val_54662,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_54604 = setTimeout(inst_54603,(10));
var state_54661__$1 = (function (){var statearr_54732 = state_54661;
(statearr_54732[(33)] = inst_54597);

(statearr_54732[(34)] = inst_54602);

return statearr_54732;
})();
var statearr_54733_54796 = state_54661__$1;
(statearr_54733_54796[(2)] = inst_54604);

(statearr_54733_54796[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (16))){
var state_54661__$1 = state_54661;
var statearr_54734_54797 = state_54661__$1;
(statearr_54734_54797[(2)] = reload_dependents);

(statearr_54734_54797[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (38))){
var inst_54614 = (state_54661[(16)]);
var inst_54632 = cljs.core.apply.call(null,cljs.core.hash_map,inst_54614);
var state_54661__$1 = state_54661;
var statearr_54735_54798 = state_54661__$1;
(statearr_54735_54798[(2)] = inst_54632);

(statearr_54735_54798[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (30))){
var state_54661__$1 = state_54661;
var statearr_54736_54799 = state_54661__$1;
(statearr_54736_54799[(2)] = null);

(statearr_54736_54799[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (10))){
var inst_54534 = (state_54661[(22)]);
var inst_54536 = cljs.core.chunked_seq_QMARK_.call(null,inst_54534);
var state_54661__$1 = state_54661;
if(inst_54536){
var statearr_54737_54800 = state_54661__$1;
(statearr_54737_54800[(1)] = (13));

} else {
var statearr_54738_54801 = state_54661__$1;
(statearr_54738_54801[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (18))){
var inst_54568 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
if(cljs.core.truth_(inst_54568)){
var statearr_54739_54802 = state_54661__$1;
(statearr_54739_54802[(1)] = (19));

} else {
var statearr_54740_54803 = state_54661__$1;
(statearr_54740_54803[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (42))){
var state_54661__$1 = state_54661;
var statearr_54741_54804 = state_54661__$1;
(statearr_54741_54804[(2)] = null);

(statearr_54741_54804[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (37))){
var inst_54627 = (state_54661[(2)]);
var state_54661__$1 = state_54661;
var statearr_54742_54805 = state_54661__$1;
(statearr_54742_54805[(2)] = inst_54627);

(statearr_54742_54805[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54662 === (8))){
var inst_54534 = (state_54661[(22)]);
var inst_54521 = (state_54661[(8)]);
var inst_54534__$1 = cljs.core.seq.call(null,inst_54521);
var state_54661__$1 = (function (){var statearr_54743 = state_54661;
(statearr_54743[(22)] = inst_54534__$1);

return statearr_54743;
})();
if(inst_54534__$1){
var statearr_54744_54806 = state_54661__$1;
(statearr_54744_54806[(1)] = (10));

} else {
var statearr_54745_54807 = state_54661__$1;
(statearr_54745_54807[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__42015__auto__,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____0 = (function (){
var statearr_54746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54746[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__);

(statearr_54746[(1)] = (1));

return statearr_54746;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____1 = (function (state_54661){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_54661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e54747){if((e54747 instanceof Object)){
var ex__42019__auto__ = e54747;
var statearr_54748_54808 = state_54661;
(statearr_54748_54808[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54661);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54809 = state_54661;
state_54661 = G__54809;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__ = function(state_54661){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____1.call(this,state_54661);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__42038__auto__ = (function (){var statearr_54749 = f__42037__auto__.call(null);
(statearr_54749[(6)] = c__42036__auto__);

return statearr_54749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,map__54506,map__54506__$1,opts,before_jsload,on_jsload,reload_dependents,map__54507,map__54507__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__42036__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__54812,link){
var map__54813 = p__54812;
var map__54813__$1 = ((((!((map__54813 == null)))?((((map__54813.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54813.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54813):map__54813);
var file = cljs.core.get.call(null,map__54813__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__54813,map__54813__$1,file){
return (function (p1__54810_SHARP_,p2__54811_SHARP_){
if(cljs.core._EQ_.call(null,p1__54810_SHARP_,p2__54811_SHARP_)){
return p1__54810_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__54813,map__54813__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__54816){
var map__54817 = p__54816;
var map__54817__$1 = ((((!((map__54817 == null)))?((((map__54817.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54817.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54817):map__54817);
var match_length = cljs.core.get.call(null,map__54817__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__54817__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__54815_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__54815_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__54819_SHARP_,p2__54820_SHARP_){
return cljs.core.assoc.call(null,p1__54819_SHARP_,cljs.core.get.call(null,p2__54820_SHARP_,key),p2__54820_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_54821 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_54821);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_54821);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__54822,p__54823){
var map__54824 = p__54822;
var map__54824__$1 = ((((!((map__54824 == null)))?((((map__54824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54824.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54824):map__54824);
var on_cssload = cljs.core.get.call(null,map__54824__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__54825 = p__54823;
var map__54825__$1 = ((((!((map__54825 == null)))?((((map__54825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54825.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54825):map__54825);
var files_msg = map__54825__$1;
var files = cljs.core.get.call(null,map__54825__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1511229555523
