// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.core');
goog.require('cljs.core');
goog.require('om.next');
goog.require('fulcro.client.impl.application');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.network');
goog.require('fulcro.client.logging');
goog.require('cljs.core.async');
goog.require('om.next.protocols');
goog.require('fulcro.client.util');
goog.require('fulcro.client.impl.om_plumbing');
goog.require('clojure.set');
goog.require('om.next.cache');
goog.require('goog.dom');
goog.require('cljs.spec.alpha');
goog.require('goog.Uri');





if(typeof fulcro.client.core.fulcro_tools !== 'undefined'){
} else {
fulcro.client.core.fulcro_tools = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","namespace","cljs.core/namespace",1653264270,null)),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","namespace","cljs.core/namespace",1653264270,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.core.namespace], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.client.core","tx-listen","fulcro.client.core/tx-listen",1705588470),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"tx-info","tx-info",74571515),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"tx-info","tx-info",74571515),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Keyword(null,"tx-info","tx-info",74571515)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"tx-info","tx-info",74571515),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.client.core","network-wrapper","fulcro.client.core/network-wrapper",472324112),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"networks","networks",1319553937),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"networks","networks",1319553937),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networks","networks",1319553937)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"networks","networks",1319553937),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_,null,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),null,null,null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.client.core","app-started","fulcro.client.core/app-started",309026560),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fulcro-app","fulcro-app",1931237579),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fulcro-app","fulcro-app",1931237579),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fulcro-app","fulcro-app",1931237579)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fulcro-app","fulcro-app",1931237579),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.client.core","tool-registry","fulcro.client.core/tool-registry",-1291086564),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.core","tx-listen","fulcro.client.core/tx-listen",1705588470),new cljs.core.Keyword("fulcro.client.core","network-wrapper","fulcro.client.core/network-wrapper",472324112),new cljs.core.Keyword("fulcro.client.core","app-started","fulcro.client.core/app-started",309026560)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__58500){
return cljs.core.map_QMARK_.call(null,G__58500);
}),(function (G__58500){
return cljs.core.contains_QMARK_.call(null,G__58500,new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817));
})], null),(function (G__58500){
return (cljs.core.map_QMARK_.call(null,G__58500)) && (cljs.core.contains_QMARK_.call(null,G__58500,new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817)));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.core","tx-listen","fulcro.client.core/tx-listen",1705588470),new cljs.core.Keyword("fulcro.client.core","network-wrapper","fulcro.client.core/network-wrapper",472324112),new cljs.core.Keyword("fulcro.client.core","app-started","fulcro.client.core/app-started",309026560)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.core","tx-listen","fulcro.client.core/tx-listen",1705588470),new cljs.core.Keyword("fulcro.client.core","network-wrapper","fulcro.client.core/network-wrapper",472324112),new cljs.core.Keyword("fulcro.client.core","app-started","fulcro.client.core/app-started",309026560)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817)))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.core","tx-listen","fulcro.client.core/tx-listen",1705588470),new cljs.core.Keyword("fulcro.client.core","network-wrapper","fulcro.client.core/network-wrapper",472324112),new cljs.core.Keyword("fulcro.client.core","app-started","fulcro.client.core/app-started",309026560)], null)])));
/**
 * Register a debug tool. When an app starts, the debug tool can have several hooks that are notified:
 * 
 *   ::tool-id some identifier to place the tool into the tool map
 *   ::tx-listen is a (fn [tx info] ...) that will be called on every `transact!` of the app. Return value is ignored.
 *   ::network-wrapper is (fn [network-map] network-map') that will be given the networking config BEFORE it is initialized. You can wrap
 *   them, but you MUST return a compatible map out or you'll disable networking.
 *   ::app-started (fn [app] ...) that will be called once the app is mounted, just like started-callback. Return value ignored.
 */
fulcro.client.core.register_tool = (function fulcro$client$core$register_tool(p__58501){
var map__58502 = p__58501;
var map__58502__$1 = ((((!((map__58502 == null)))?((((map__58502.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58502.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58502):map__58502);
var tool_registry = map__58502__$1;
var tool_id = cljs.core.get.call(null,map__58502__$1,new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817));
return cljs.core.swap_BANG_.call(null,fulcro.client.core.fulcro_tools,cljs.core.assoc,tool_id,tool_registry);
});
fulcro.client.core.normalize_network = (function fulcro$client$core$normalize_network(networking){
if(((!((networking == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === networking.fulcro$client$network$FulcroNetwork$)))?true:false):false)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),networking], null);
} else {
return networking;
}
});
fulcro.client.core.add_tools = (function fulcro$client$core$add_tools(original_start,original_net,original_tx_listen){
var net = fulcro.client.core.normalize_network.call(null,original_net);
var listen = (function (){var or__28141__auto__ = original_tx_listen;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.constantly.call(null,null);
}
})();
var started = (function (){var or__28141__auto__ = original_start;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.constantly.call(null,null);
}
})();
return cljs.core.reduce.call(null,((function (net,listen,started){
return (function (p__58505,p__58506){
var vec__58507 = p__58505;
var start = cljs.core.nth.call(null,vec__58507,(0),null);
var net__$1 = cljs.core.nth.call(null,vec__58507,(1),null);
var listen__$1 = cljs.core.nth.call(null,vec__58507,(2),null);
var map__58510 = p__58506;
var map__58510__$1 = ((((!((map__58510 == null)))?((((map__58510.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58510.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58510):map__58510);
var tool_id = cljs.core.get.call(null,map__58510__$1,new cljs.core.Keyword("fulcro.client.core","tool-id","fulcro.client.core/tool-id",-599732817));
var tx_listen = cljs.core.get.call(null,map__58510__$1,new cljs.core.Keyword("fulcro.client.core","tx-listen","fulcro.client.core/tx-listen",1705588470));
var network_wrapper = cljs.core.get.call(null,map__58510__$1,new cljs.core.Keyword("fulcro.client.core","network-wrapper","fulcro.client.core/network-wrapper",472324112));
var app_started = cljs.core.get.call(null,map__58510__$1,new cljs.core.Keyword("fulcro.client.core","app-started","fulcro.client.core/app-started",309026560));
var start__$1 = (cljs.core.truth_(app_started)?((function (vec__58507,start,net__$1,listen__$1,map__58510,map__58510__$1,tool_id,tx_listen,network_wrapper,app_started,net,listen,started){
return (function (app){
app_started.call(null,app);

return start.call(null,app);
});})(vec__58507,start,net__$1,listen__$1,map__58510,map__58510__$1,tool_id,tx_listen,network_wrapper,app_started,net,listen,started))
:start);
var net__$2 = (cljs.core.truth_(network_wrapper)?network_wrapper.call(null,net__$1):net__$1);
var listen__$2 = (cljs.core.truth_(tx_listen)?((function (start__$1,net__$2,vec__58507,start,net__$1,listen__$1,map__58510,map__58510__$1,tool_id,tx_listen,network_wrapper,app_started,net,listen,started){
return (function (env,info){
return tx_listen.call(null,env,info);
});})(start__$1,net__$2,vec__58507,start,net__$1,listen__$1,map__58510,map__58510__$1,tool_id,tx_listen,network_wrapper,app_started,net,listen,started))
:listen__$1);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start__$1,net__$2,listen__$2], null);
});})(net,listen,started))
,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [started,net,listen], null),cljs.core.vals.call(null,cljs.core.deref.call(null,fulcro.client.core.fulcro_tools)));
});
/**
 * Returns true if the class has the static InitialAppState protocol.
 */
fulcro.client.core.iinitial_app_state_QMARK_ = (function fulcro$client$core$iinitial_app_state_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.fulcro$client$core$InitialAppState$))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Returns true if the class has the stati Ident protocol.
 */
fulcro.client.core.iident_QMARK_ = (function fulcro$client$core$iident_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.om$next$Ident$))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Entrypoint for creating a new fulcro client. Instantiates an Application with default values, unless
 *   overridden by the parameters. If you do not supply a networking object, one will be provided that connects to the
 *   same server the application was served from, at `/api`.
 * 
 *   If you supply a `:request-transform` it must be a function:
 * 
 *   ```
 *  (fn [{:keys [body headers]}] {:body body' :headers headers'})
 *   ```
 * 
 *   it can replace the outgoing EDN of body or headers (returning both as a vector). NOTE: Both of these are clojurescript types.
 *   The edn will be encoded with transit, and the headers will be converted to a js map. IMPORTANT: Only supported
 *   when using the default built-in single-remote networking.
 * 
 *   `:initial-state` is your applications initial state. If it is an atom, it *must* be normalized. Fulcro databases
 *   always have normalization turned on (for server data merging). If it is not an atom, it will be auto-normalized.
 * 
 *   `:started-callback` is an optional function that will receive the intiailized fulcro application after it is
 *   mounted in the DOM, and is useful for triggering initial loads, routing mutations, etc. The Om reconciler is available
 *   under the `:reconciler` key (and you can access the app state, root node, etc from there.)
 * 
 *   `:network-error-callback` is a function of two arguments, the app state atom and the error, which will be invoked for
 *   every network error (status code >= 400, or no network found), should you choose to use the default built-in
 *   networking.
 * 
 *   `:migrate` is optional. It is a (fn [state tid->rid] ... state') that should return a new state where all tempids
 *   (the keys of `tid->rid`) are rewritten to real ids (the values of tid->rid). This defaults to a full recursive
 *   algorithm against all data in the app-state, which is correct but possibly slow).  Note that tempids will have an Om tempid data type.
 *   See Om reconciler documentation for further information.
 * 
 *   `:transit-handlers` (optional). A map with keys for `:read` and `:write`, which contain maps to be used for the read
 *   and write side of transit to extend the supported data types. See `make-fulcro-network` in network.cljs. Only used
 *   when you default to the built-in networking.
 * 
 *   `:shared` (optional). A map of arbitrary values to be shared across all components, accessible to them via (om/shared this)
 * 
 *   `:read-local` (optional). An Om read function for the Om Parser. (fn [env k params] ...). If supplied,
 *   it will be called once for each root-level query key. If it returns `nil` or `false` for that key then the built-in Fulcro read will handle that
 *   branch of the root query. If it returns a map with the shape `{:value ...}`, then that will be used for the response. This is *not*
 *   recursive. If you begin handling a *branch* (e.g. a join), you must finish doing so (though if using recursion, you can technically handle just
 *   the properties that need your custom handling). At any time you can use `om/db->tree` to get raw graph data from the database for a branch.
 *   NOTE: *it will be allowed* to trigger remote reads. This is not recommended, as you will probably have to augment the networking layer to
 *   get it to do what you mean. Use `load` instead. You have been warned. Triggering remote reads is allowed, but discouraged and unsupported.
 * 
 *   `:networking` (optional). An instance of FulcroNetwork that will act as the default remote (named :remote). If
 *   you want to support multiple remotes, then this should be a map whose keys are the keyword names of the remotes
 *   and whose values are FulcroNetwork instances.
 * 
 *   `:mutation-merge (optional). A function `(fn [state mutation-symbol return-value])` that receives the app state as a
 *   map (NOT an atom) and should return the new state as a map. This function is run when network results are being merged,
 *   and is called once for each mutation that had a return value on the server. Returning nil from this function is safe, and will be ignored
 *   with a console message for debugging. If you need information about the original mutation arguments then you must reflect
 *   them back from the server in your return value. By default such values are discarded.
 *   
 *   `:reconciler-options (optional). A map that will be merged into the reconciler options for Om.next. Currently it's mostly
 *   useful to override things like :root-render and :root-unmount for React Native Apps.`
 * 
 *   There is currently no way to circumvent the encoding of the body into transit. If you want to talk to other endpoints
 *   via alternate protocols you must currently implement that outside of the framework (e.g. global functions/state).
 *   
 */
fulcro.client.core.new_fulcro_client = (function fulcro$client$core$new_fulcro_client(var_args){
var args__29319__auto__ = [];
var len__29312__auto___58522 = arguments.length;
var i__29313__auto___58523 = (0);
while(true){
if((i__29313__auto___58523 < len__29312__auto___58522)){
args__29319__auto__.push((arguments[i__29313__auto___58523]));

var G__58524 = (i__29313__auto___58523 + (1));
i__29313__auto___58523 = G__58524;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return fulcro.client.core.new_fulcro_client.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

fulcro.client.core.new_fulcro_client.cljs$core$IFn$_invoke$arity$variadic = (function (p__58515){
var map__58516 = p__58515;
var map__58516__$1 = ((((!((map__58516 == null)))?((((map__58516.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58516.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58516):map__58516);
var started_callback = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),cljs.core.constantly.call(null,null));
var initial_state = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),cljs.core.PersistentArrayMap.EMPTY);
var reconciler_options = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035));
var read_local = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"read-local","read-local",811906273),cljs.core.constantly.call(null,false));
var network_error_callback = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"network-error-callback","network-error-callback",93849635),cljs.core.constantly.call(null,null));
var networking = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var mutation_merge = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var transit_handlers = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"transit-handlers","transit-handlers",-1206080791));
var migrate = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),null);
var request_transform = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"request-transform","request-transform",170337297));
var shared = cljs.core.get.call(null,map__58516__$1,new cljs.core.Keyword(null,"shared","shared",-384145993),null);
var networking__$1 = (function (){var or__28141__auto__ = networking;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro.client.network.make_fulcro_network.call(null,"/api",new cljs.core.Keyword(null,"request-transform","request-transform",170337297),request_transform,new cljs.core.Keyword(null,"transit-handlers","transit-handlers",-1206080791),transit_handlers,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),network_error_callback);
}
})();
var vec__58518 = fulcro.client.core.add_tools.call(null,started_callback,networking__$1,new cljs.core.Keyword(null,"tx-listen","tx-listen",119130367).cljs$core$IFn$_invoke$arity$1(reconciler_options));
var started_callback__$1 = cljs.core.nth.call(null,vec__58518,(0),null);
var networking__$2 = cljs.core.nth.call(null,vec__58518,(1),null);
var tx_listen = cljs.core.nth.call(null,vec__58518,(2),null);
return fulcro.client.core.map__GT_Application.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),initial_state,new cljs.core.Keyword(null,"read-local","read-local",811906273),read_local,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322),mutation_merge,new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),started_callback__$1,new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035),cljs.core.merge.call(null,(function (){var G__58521 = cljs.core.PersistentArrayMap.EMPTY;
var G__58521__$1 = (cljs.core.truth_(tx_listen)?cljs.core.assoc.call(null,G__58521,new cljs.core.Keyword(null,"tx-listen","tx-listen",119130367),tx_listen):G__58521);
var G__58521__$2 = (cljs.core.truth_(migrate)?cljs.core.assoc.call(null,G__58521__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),migrate):G__58521__$1);
if(cljs.core.truth_(shared)){
return cljs.core.assoc.call(null,G__58521__$2,new cljs.core.Keyword(null,"shared","shared",-384145993),shared);
} else {
return G__58521__$2;
}
})(),reconciler_options),new cljs.core.Keyword(null,"networking","networking",586110628),networking__$2], null));
});

fulcro.client.core.new_fulcro_client.cljs$lang$maxFixedArity = (0);

fulcro.client.core.new_fulcro_client.cljs$lang$applyTo = (function (seq58514){
return fulcro.client.core.new_fulcro_client.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq58514));
});


/**
 * @interface
 */
fulcro.client.core.InitialAppState = function(){};

/**
 * Get the initial state to be used for this component in app state. You are responsible for composing these together.
 */
fulcro.client.core.initial_state = (function fulcro$client$core$initial_state(clz,params){
if((!((clz == null))) && (!((clz.fulcro$client$core$InitialAppState$initial_state$arity$2 == null)))){
return clz.fulcro$client$core$InitialAppState$initial_state$arity$2(clz,params);
} else {
var x__28824__auto__ = (((clz == null))?null:clz);
var m__28825__auto__ = (fulcro.client.core.initial_state[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,clz,params);
} else {
var m__28825__auto____$1 = (fulcro.client.core.initial_state["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,clz,params);
} else {
throw cljs.core.missing_protocol.call(null,"InitialAppState.initial-state",clz);
}
}
}
});

/**
 * Get the initial state of a component. Needed because calling the protocol method from a defui component in clj will not work as expected.
 */
fulcro.client.core.get_initial_state = (function fulcro$client$core$get_initial_state(class$,params){
if(((!((class$ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === class$.fulcro$client$core$InitialAppState$)))?true:false):false)){
return fulcro.client.core.initial_state.call(null,class$,params);
} else {
return null;
}
});

/**
 * @interface
 */
fulcro.client.core.FulcroApplication = function(){};

/**
 * Start/replace the webapp on the given DOM ID or DOM Node.
 */
fulcro.client.core.mount = (function fulcro$client$core$mount(this$,root_component,target_dom_id){
if((!((this$ == null))) && (!((this$.fulcro$client$core$FulcroApplication$mount$arity$3 == null)))){
return this$.fulcro$client$core$FulcroApplication$mount$arity$3(this$,root_component,target_dom_id);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.client.core.mount[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,root_component,target_dom_id);
} else {
var m__28825__auto____$1 = (fulcro.client.core.mount["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,root_component,target_dom_id);
} else {
throw cljs.core.missing_protocol.call(null,"FulcroApplication.mount",this$);
}
}
}
});

/**
 * Replace the entire app state with the given (pre-normalized) state.
 */
fulcro.client.core.reset_state_BANG_ = (function fulcro$client$core$reset_state_BANG_(this$,new_state){
if((!((this$ == null))) && (!((this$.fulcro$client$core$FulcroApplication$reset_state_BANG_$arity$2 == null)))){
return this$.fulcro$client$core$FulcroApplication$reset_state_BANG_$arity$2(this$,new_state);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.client.core.reset_state_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,new_state);
} else {
var m__28825__auto____$1 = (fulcro.client.core.reset_state_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,new_state);
} else {
throw cljs.core.missing_protocol.call(null,"FulcroApplication.reset-state!",this$);
}
}
}
});

/**
 * Replace the entire app state with the initial app state defined on the root component (includes auto-merging of unions). callback can be nil, a function, or :original (to call original started-callback).
 */
fulcro.client.core.reset_app_BANG_ = (function fulcro$client$core$reset_app_BANG_(this$,root_component,callback){
if((!((this$ == null))) && (!((this$.fulcro$client$core$FulcroApplication$reset_app_BANG_$arity$3 == null)))){
return this$.fulcro$client$core$FulcroApplication$reset_app_BANG_$arity$3(this$,root_component,callback);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.client.core.reset_app_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,root_component,callback);
} else {
var m__28825__auto____$1 = (fulcro.client.core.reset_app_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,root_component,callback);
} else {
throw cljs.core.missing_protocol.call(null,"FulcroApplication.reset-app!",this$);
}
}
}
});

/**
 * Remove all pending network requests on the given remote(s). Useful on failures to eliminate cascading failures. Remote can be a keyword, set, or nil. `nil` means all remotes.
 */
fulcro.client.core.clear_pending_remote_requests_BANG_ = (function fulcro$client$core$clear_pending_remote_requests_BANG_(this$,remotes){
if((!((this$ == null))) && (!((this$.fulcro$client$core$FulcroApplication$clear_pending_remote_requests_BANG_$arity$2 == null)))){
return this$.fulcro$client$core$FulcroApplication$clear_pending_remote_requests_BANG_$arity$2(this$,remotes);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.client.core.clear_pending_remote_requests_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,remotes);
} else {
var m__28825__auto____$1 = (fulcro.client.core.clear_pending_remote_requests_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,remotes);
} else {
throw cljs.core.missing_protocol.call(null,"FulcroApplication.clear-pending-remote-requests!",this$);
}
}
}
});

/**
 * Refresh the UI (force re-render). NOTE: You MUST support :key on your root DOM element with the :ui/react-key value from app state for this to work.
 */
fulcro.client.core.refresh = (function fulcro$client$core$refresh(this$){
if((!((this$ == null))) && (!((this$.fulcro$client$core$FulcroApplication$refresh$arity$1 == null)))){
return this$.fulcro$client$core$FulcroApplication$refresh$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.client.core.refresh[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro.client.core.refresh["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"FulcroApplication.refresh",this$);
}
}
}
});

/**
 * Return a serialized version of the current history of the application, suitable for network transfer
 */
fulcro.client.core.history = (function fulcro$client$core$history(this$){
if((!((this$ == null))) && (!((this$.fulcro$client$core$FulcroApplication$history$arity$1 == null)))){
return this$.fulcro$client$core$FulcroApplication$history$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.client.core.history[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro.client.core.history["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"FulcroApplication.history",this$);
}
}
}
});

/**
 * Returns the application with history reset to its initial, empty state. Resets application history to its initial, empty state. Suitable for resetting the app for situations such as user log out.
 */
fulcro.client.core.reset_history_BANG_ = (function fulcro$client$core$reset_history_BANG_(this$){
if((!((this$ == null))) && (!((this$.fulcro$client$core$FulcroApplication$reset_history_BANG_$arity$1 == null)))){
return this$.fulcro$client$core$FulcroApplication$reset_history_BANG_$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.client.core.reset_history_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro.client.core.reset_history_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"FulcroApplication.reset-history!",this$);
}
}
}
});

/**
 * Given a state map of the application database, a component, and a tree of component-data: normalizes
 * the tree of data and merges the component table entries into the state, returning a new state map.
 * Since there is not an implied root, the component itself won't be linked into your graph (though it will
 * remain correctly linked for its own consistency).
 * Therefore, this function is just for dropping normalized things into tables
 * when they themselves have a recursive nature. This function is useful when you want to create a new component instance
 * and put it in the database, but the component instance has recursive normalized state. This is a basically a
 * thin wrapper around `om/tree->db`.
 */
fulcro.client.core.merge_component = (function fulcro$client$core$merge_component(state_map,component,component_data){
var temp__4655__auto__ = fulcro.client.util.get_ident.call(null,component,component_data);
if(cljs.core.truth_(temp__4655__auto__)){
var top_ident = temp__4655__auto__;
var query = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([top_ident,om.next.get_query.call(null,component)])], null);
var state_to_merge = cljs.core.PersistentArrayMap.createAsIfByAssoc([top_ident,component_data]);
var table_entries = cljs.core.dissoc.call(null,om.next.tree__GT_db.call(null,query,state_to_merge,true),new cljs.core.Keyword("om.next","tables","om.next/tables",1677536335),top_ident);
return fulcro.client.util.deep_merge.call(null,state_map,table_entries);
} else {
return state_map;
}
});
/**
 * Walks the given query and calls (merge-fn parent-union-component union-child-initial-state) for each non-default element of a union that has initial app state.
 *   You probably want to use merge-alternate-union-elements[!] on a state map or app.
 */
fulcro.client.core.merge_alternate_unions = (function fulcro$client$core$merge_alternate_unions(merge_fn,root_component){
var walk_ast = (function() {
var fulcro$client$core$merge_alternate_unions_$_walk_ast = null;
var fulcro$client$core$merge_alternate_unions_$_walk_ast__2 = (function (ast,visitor){
return fulcro$client$core$merge_alternate_unions_$_walk_ast.call(null,ast,visitor,null);
});
var fulcro$client$core$merge_alternate_unions_$_walk_ast__3 = (function (p__58533,visitor,parent_union){
var map__58534 = p__58533;
var map__58534__$1 = ((((!((map__58534 == null)))?((((map__58534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58534.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58534):map__58534);
var parent_ast = map__58534__$1;
var children = cljs.core.get.call(null,map__58534__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var component = cljs.core.get.call(null,map__58534__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var type = cljs.core.get.call(null,map__58534__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var dispatch_key = cljs.core.get.call(null,map__58534__$1,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510));
var union_key = cljs.core.get.call(null,map__58534__$1,new cljs.core.Keyword(null,"union-key","union-key",1529707234));
var key = cljs.core.get.call(null,map__58534__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
if(cljs.core.truth_((function (){var and__28129__auto__ = component;
if(cljs.core.truth_(and__28129__auto__)){
var and__28129__auto____$1 = parent_union;
if(cljs.core.truth_(and__28129__auto____$1)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"union-entry","union-entry",223335750),type);
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})())){
visitor.call(null,component,parent_union);
} else {
}

if(cljs.core.truth_(children)){
var seq__58536 = cljs.core.seq.call(null,children);
var chunk__58537 = null;
var count__58538 = (0);
var i__58539 = (0);
while(true){
if((i__58539 < count__58538)){
var ast = cljs.core._nth.call(null,chunk__58537,i__58539);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"union","union",2142937499))){
fulcro$client$core$merge_alternate_unions_$_walk_ast.call(null,ast,visitor,component);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"union-entry","union-entry",223335750))){
fulcro$client$core$merge_alternate_unions_$_walk_ast.call(null,ast,visitor,parent_union);
} else {
if(cljs.core.truth_(ast)){
fulcro$client$core$merge_alternate_unions_$_walk_ast.call(null,ast,visitor,null);
} else {
}
}
}

var G__58540 = seq__58536;
var G__58541 = chunk__58537;
var G__58542 = count__58538;
var G__58543 = (i__58539 + (1));
seq__58536 = G__58540;
chunk__58537 = G__58541;
count__58538 = G__58542;
i__58539 = G__58543;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__58536);
if(temp__4657__auto__){
var seq__58536__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58536__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__58536__$1);
var G__58544 = cljs.core.chunk_rest.call(null,seq__58536__$1);
var G__58545 = c__28980__auto__;
var G__58546 = cljs.core.count.call(null,c__28980__auto__);
var G__58547 = (0);
seq__58536 = G__58544;
chunk__58537 = G__58545;
count__58538 = G__58546;
i__58539 = G__58547;
continue;
} else {
var ast = cljs.core.first.call(null,seq__58536__$1);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"union","union",2142937499))){
fulcro$client$core$merge_alternate_unions_$_walk_ast.call(null,ast,visitor,component);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"union-entry","union-entry",223335750))){
fulcro$client$core$merge_alternate_unions_$_walk_ast.call(null,ast,visitor,parent_union);
} else {
if(cljs.core.truth_(ast)){
fulcro$client$core$merge_alternate_unions_$_walk_ast.call(null,ast,visitor,null);
} else {
}
}
}

var G__58548 = cljs.core.next.call(null,seq__58536__$1);
var G__58549 = null;
var G__58550 = (0);
var G__58551 = (0);
seq__58536 = G__58548;
chunk__58537 = G__58549;
count__58538 = G__58550;
i__58539 = G__58551;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
fulcro$client$core$merge_alternate_unions_$_walk_ast = function(p__58533,visitor,parent_union){
switch(arguments.length){
case 2:
return fulcro$client$core$merge_alternate_unions_$_walk_ast__2.call(this,p__58533,visitor);
case 3:
return fulcro$client$core$merge_alternate_unions_$_walk_ast__3.call(this,p__58533,visitor,parent_union);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$core$merge_alternate_unions_$_walk_ast.cljs$core$IFn$_invoke$arity$2 = fulcro$client$core$merge_alternate_unions_$_walk_ast__2;
fulcro$client$core$merge_alternate_unions_$_walk_ast.cljs$core$IFn$_invoke$arity$3 = fulcro$client$core$merge_alternate_unions_$_walk_ast__3;
return fulcro$client$core$merge_alternate_unions_$_walk_ast;
})()
;
var merge_union = (function fulcro$client$core$merge_alternate_unions_$_merge_union(component,parent_union){
var default_initial_state = (function (){var and__28129__auto__ = parent_union;
if(cljs.core.truth_(and__28129__auto__)){
var and__28129__auto____$1 = fulcro.client.core.iinitial_app_state_QMARK_.call(null,parent_union);
if(and__28129__auto____$1){
return fulcro.client.core.get_initial_state.call(null,parent_union,cljs.core.PersistentArrayMap.EMPTY);
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})();
var to_many_QMARK_ = cljs.core.vector_QMARK_.call(null,default_initial_state);
var component_initial_state = (function (){var and__28129__auto__ = component;
if(cljs.core.truth_(and__28129__auto__)){
var and__28129__auto____$1 = fulcro.client.core.iinitial_app_state_QMARK_.call(null,component);
if(and__28129__auto____$1){
return fulcro.client.core.get_initial_state.call(null,component,cljs.core.PersistentArrayMap.EMPTY);
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(default_initial_state)){
} else {
fulcro.client.logging.warn.call(null,"Subelements of union ",parent_union.displayName," have initial state, but the union itself has no initial state. Your app state may suffer.");
}

if(cljs.core.truth_((function (){var and__28129__auto__ = component;
if(cljs.core.truth_(and__28129__auto__)){
var and__28129__auto____$1 = component_initial_state;
if(cljs.core.truth_(and__28129__auto____$1)){
var and__28129__auto____$2 = parent_union;
if(cljs.core.truth_(and__28129__auto____$2)){
return (!(to_many_QMARK_)) && (cljs.core.not_EQ_.call(null,default_initial_state,component_initial_state));
} else {
return and__28129__auto____$2;
}
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})())){
return merge_fn.call(null,parent_union,component_initial_state);
} else {
return null;
}
});
return walk_ast.call(null,om.next.query__GT_ast.call(null,om.next.get_query.call(null,root_component)),merge_union);
});
/**
 * Walks the query and initial state of root-component and merges the alternate sides of unions with initial state into
 *   the application state database. See also `merge-alternate-union-elements`, which can be used on a state map and
 *   is handy for server-side rendering. This function side-effects on your app, and returns nothing.
 */
fulcro.client.core.merge_alternate_union_elements_BANG_ = (function fulcro$client$core$merge_alternate_union_elements_BANG_(app,root_component){
return fulcro.client.core.merge_alternate_unions.call(null,cljs.core.partial.call(null,fulcro.client.core.merge_state_BANG_,app),root_component);
});
/**
 * Just like merge-alternate-union-elements!, but usable from within mutations and on server-side rendering. Ensures
 *   that when a component has initial state it will end up in the state map, even if it isn't currently in the
 *   initial state of the union component (which can only point to one at a time).
 */
fulcro.client.core.merge_alternate_union_elements = (function fulcro$client$core$merge_alternate_union_elements(state_map,root_component){
var initial_state = fulcro.client.core.get_initial_state.call(null,root_component,null);
var state_map_atom = cljs.core.atom.call(null,state_map);
var merge_to_state = ((function (initial_state,state_map_atom){
return (function (comp,tree){
return cljs.core.swap_BANG_.call(null,state_map_atom,fulcro.client.core.merge_component,comp,tree);
});})(initial_state,state_map_atom))
;
var _ = fulcro.client.core.merge_alternate_unions.call(null,merge_to_state,root_component);
var new_state = cljs.core.deref.call(null,state_map_atom);
return new_state;
});
/**
 * Starts all remotes in a map. If a remote's `start` returns something that implements `FulcroNetwork`,
 *   update the network map with this value. Returns possibly updated `network-map`.
 */
fulcro.client.core.start_networking = (function fulcro$client$core$start_networking(network_map){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__28949__auto__ = (function fulcro$client$core$start_networking_$_iter__58552(s__58553){
return (new cljs.core.LazySeq(null,(function (){
var s__58553__$1 = s__58553;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__58553__$1);
if(temp__4657__auto__){
var s__58553__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__58553__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__58553__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__58555 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__58554 = (0);
while(true){
if((i__58554 < size__28948__auto__)){
var vec__58556 = cljs.core._nth.call(null,c__28947__auto__,i__58554);
var k = cljs.core.nth.call(null,vec__58556,(0),null);
var remote = cljs.core.nth.call(null,vec__58556,(1),null);
var started = fulcro.client.network.start.call(null,remote);
var valid = ((((!((started == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === started.fulcro$client$network$FulcroNetwork$)))?true:false):false))?started:remote);
cljs.core.chunk_append.call(null,b__58555,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,valid], null));

var G__58564 = (i__58554 + (1));
i__58554 = G__58564;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__58555),fulcro$client$core$start_networking_$_iter__58552.call(null,cljs.core.chunk_rest.call(null,s__58553__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__58555),null);
}
} else {
var vec__58560 = cljs.core.first.call(null,s__58553__$2);
var k = cljs.core.nth.call(null,vec__58560,(0),null);
var remote = cljs.core.nth.call(null,vec__58560,(1),null);
var started = fulcro.client.network.start.call(null,remote);
var valid = ((((!((started == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === started.fulcro$client$network$FulcroNetwork$)))?true:false):false))?started:remote);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,valid], null),fulcro$client$core$start_networking_$_iter__58552.call(null,cljs.core.rest.call(null,s__58553__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,network_map);
})());
});
/**
 * Initialize the fulcro Application. Creates network queue, sets up i18n, creates reconciler, mounts it, and returns
 *   the initialized app
 */
fulcro.client.core.initialize = (function fulcro$client$core$initialize(p__58565,initial_state,root_component,dom_id_or_node,reconciler_options){
var map__58566 = p__58565;
var map__58566__$1 = ((((!((map__58566 == null)))?((((map__58566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58566.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58566):map__58566);
var app = map__58566__$1;
var networking = cljs.core.get.call(null,map__58566__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var read_local = cljs.core.get.call(null,map__58566__$1,new cljs.core.Keyword(null,"read-local","read-local",811906273));
var started_callback = cljs.core.get.call(null,map__58566__$1,new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951));
var network_map = fulcro.client.core.normalize_network.call(null,networking);
var remotes = cljs.core.keys.call(null,network_map);
var send_queues = cljs.core.zipmap.call(null,remotes,cljs.core.map.call(null,((function (network_map,remotes,map__58566,map__58566__$1,app,networking,read_local,started_callback){
return (function (){
return cljs.core.async.chan.call(null,(1024));
});})(network_map,remotes,map__58566,map__58566__$1,app,networking,read_local,started_callback))
,remotes));
var response_channels = cljs.core.zipmap.call(null,remotes,cljs.core.map.call(null,((function (network_map,remotes,send_queues,map__58566,map__58566__$1,app,networking,read_local,started_callback){
return (function (){
return cljs.core.async.chan.call(null);
});})(network_map,remotes,send_queues,map__58566,map__58566__$1,app,networking,read_local,started_callback))
,remotes));
var parser = om.next.parser.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read","read",1140058661),cljs.core.partial.call(null,fulcro.client.impl.om_plumbing.read_local,read_local),new cljs.core.Keyword(null,"mutate","mutate",1422419038),fulcro.client.impl.om_plumbing.write_entry_point], null));
var initial_app = cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330),send_queues,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128),response_channels,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser,new cljs.core.Keyword(null,"mounted?","mounted?",712114760),true);
var app_with_networking = cljs.core.assoc.call(null,initial_app,new cljs.core.Keyword(null,"networking","networking",586110628),fulcro.client.core.start_networking.call(null,network_map));
var rec = fulcro.client.impl.application.generate_reconciler.call(null,app_with_networking,initial_state,parser,reconciler_options);
var completed_app = cljs.core.assoc.call(null,app_with_networking,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),rec);
var node = ((typeof dom_id_or_node === 'string')?goog.dom.getElement(dom_id_or_node):dom_id_or_node);
fulcro.client.impl.application.initialize_internationalization.call(null,rec);

fulcro.client.impl.application.initialize_global_error_callbacks.call(null,completed_app);

fulcro.client.impl.application.start_network_sequential_processing.call(null,completed_app);

fulcro.client.core.merge_alternate_union_elements_BANG_.call(null,completed_app,root_component);

om.next.add_root_BANG_.call(null,rec,root_component,node);

if(cljs.core.truth_(started_callback)){
started_callback.call(null,completed_app);
} else {
}

return completed_app;
});
/**
 * Needed for mocking in tests. Do not use directly. Use FulcroApplication protocol methods instead.
 */
fulcro.client.core.clear_queue = (function fulcro$client$core$clear_queue(queue){
var element = cljs.core.async.poll_BANG_.call(null,queue);
while(true){
if(cljs.core.truth_(element)){
var G__58568 = cljs.core.async.poll_BANG_.call(null,queue);
element = G__58568;
continue;
} else {
return null;
}
break;
}
});
/**
 * Needed for mocking in tests. Use FulcroApplication protocol methods instead.
 */
fulcro.client.core.reset_history_impl = (function fulcro$client$core$reset_history_impl(app){
return cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.update_in.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"history","history",-247395220)], null),(function (p1__58569_SHARP_){
return om.next.cache.cache.call(null,p1__58569_SHARP_.size);
})));
});
fulcro.client.core.refresh_STAR_ = (function fulcro$client$core$refresh_STAR_(p__58570,root,target){
var map__58571 = p__58570;
var map__58571__$1 = ((((!((map__58571 == null)))?((((map__58571.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58571.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58571):map__58571);
var app = map__58571__$1;
var reconciler = cljs.core.get.call(null,map__58571__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var old_target_58573 = new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(reconciler)));
var target_58574__$1 = ((typeof target === 'string')?goog.dom.getElement(target):target);
if(cljs.core.truth_((function (){var and__28129__auto__ = old_target_58573;
if(cljs.core.truth_(and__28129__auto__)){
return !((old_target_58573 === target_58574__$1));
} else {
return and__28129__auto__;
}
})())){
fulcro.client.logging.info.call(null,"Mounting on newly supplied target.");

om.next.remove_root_BANG_.call(null,reconciler,old_target_58573);

om.next.add_root_BANG_.call(null,reconciler,root,target_58574__$1);
} else {
}

fulcro.client.logging.info.call(null,"RERENDER: NOTE: If your UI doesn't change, make sure you query for :ui/react-key on your Root and embed that as :key in your top-level DOM element");

return fulcro.client.util.force_render.call(null,reconciler);
});
fulcro.client.core.mount_STAR_ = (function fulcro$client$core$mount_STAR_(p__58575,root_component,dom_id_or_node){
var map__58576 = p__58575;
var map__58576__$1 = ((((!((map__58576 == null)))?((((map__58576.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58576.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58576):map__58576);
var app = map__58576__$1;
var mounted_QMARK_ = cljs.core.get.call(null,map__58576__$1,new cljs.core.Keyword(null,"mounted?","mounted?",712114760));
var initial_state = cljs.core.get.call(null,map__58576__$1,new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806));
var reconciler_options = cljs.core.get.call(null,map__58576__$1,new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035));
if(cljs.core.truth_(mounted_QMARK_)){
fulcro.client.core.refresh_STAR_.call(null,app,root_component,dom_id_or_node);

return app;
} else {
var uses_initial_app_state_QMARK_ = fulcro.client.core.iinitial_app_state_QMARK_.call(null,root_component);
var ui_declared_state = (function (){var and__28129__auto__ = uses_initial_app_state_QMARK_;
if(and__28129__auto__){
return fulcro.client.core.initial_state.call(null,root_component,null);
} else {
return and__28129__auto__;
}
})();
var explicit_state_QMARK_ = (function (){var or__28141__auto__ = fulcro.client.util.atom_QMARK_.call(null,initial_state);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return (cljs.core.seq.call(null,initial_state)) && (cljs.core.map_QMARK_.call(null,initial_state));
}
})();
var init_conflict_QMARK_ = (function (){var and__28129__auto__ = explicit_state_QMARK_;
if(cljs.core.truth_(and__28129__auto__)){
return fulcro.client.core.iinitial_app_state_QMARK_.call(null,root_component);
} else {
return and__28129__auto__;
}
})();
var state = (cljs.core.truth_(explicit_state_QMARK_)?(cljs.core.truth_(initial_state)?initial_state:cljs.core.PersistentArrayMap.EMPTY):(cljs.core.truth_(ui_declared_state)?ui_declared_state:cljs.core.PersistentArrayMap.EMPTY
));
if(cljs.core.truth_(init_conflict_QMARK_)){
fulcro.client.logging.debug.call(null,"NOTE: You supplied an initial state AND a root component with initial state. Using explicit state over InitialAppState!");
} else {
}

return fulcro.client.core.initialize.call(null,app,state,root_component,dom_id_or_node,reconciler_options);
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {fulcro.client.core.FulcroApplication}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro.client.core.Application = (function (initial_state,mutation_merge,started_callback,remotes,networking,send_queues,response_channels,reconciler,read_local,parser,mounted_QMARK_,reconciler_options,__meta,__extmap,__hash){
this.initial_state = initial_state;
this.mutation_merge = mutation_merge;
this.started_callback = started_callback;
this.remotes = remotes;
this.networking = networking;
this.send_queues = send_queues;
this.response_channels = response_channels;
this.reconciler = reconciler;
this.read_local = read_local;
this.parser = parser;
this.mounted_QMARK_ = mounted_QMARK_;
this.reconciler_options = reconciler_options;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});

fulcro.client.core.Application.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28781__auto__,k__28782__auto__){
var self__ = this;
var this__28781__auto____$1 = this;
return this__28781__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28782__auto__,null);
});


fulcro.client.core.Application.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28783__auto__,k58579,else__28784__auto__){
var self__ = this;
var this__28783__auto____$1 = this;
var G__58583 = k58579;
var G__58583__$1 = (((G__58583 instanceof cljs.core.Keyword))?G__58583.fqn:null);
switch (G__58583__$1) {
case "initial-state":
return self__.initial_state;

break;
case "mutation-merge":
return self__.mutation_merge;

break;
case "started-callback":
return self__.started_callback;

break;
case "remotes":
return self__.remotes;

break;
case "networking":
return self__.networking;

break;
case "send-queues":
return self__.send_queues;

break;
case "response-channels":
return self__.response_channels;

break;
case "reconciler":
return self__.reconciler;

break;
case "read-local":
return self__.read_local;

break;
case "parser":
return self__.parser;

break;
case "mounted?":
return self__.mounted_QMARK_;

break;
case "reconciler-options":
return self__.reconciler_options;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k58579,else__28784__auto__);

}
});


fulcro.client.core.Application.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28795__auto__,writer__28796__auto__,opts__28797__auto__){
var self__ = this;
var this__28795__auto____$1 = this;
var pr_pair__28798__auto__ = ((function (this__28795__auto____$1){
return (function (keyval__28799__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,cljs.core.pr_writer,""," ","",opts__28797__auto__,keyval__28799__auto__);
});})(this__28795__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,pr_pair__28798__auto__,"#fulcro.client.core.Application{",", ","}",opts__28797__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),self__.initial_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322),self__.mutation_merge],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),self__.started_callback],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remotes","remotes",1132366312),self__.remotes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"networking","networking",586110628),self__.networking],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-queues","send-queues",-212336330),self__.send_queues],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128),self__.response_channels],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),self__.reconciler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-local","read-local",811906273),self__.read_local],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parser","parser",-1543495310),self__.parser],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"mounted?","mounted?",712114760),self__.mounted_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035),self__.reconciler_options],null))], null),self__.__extmap));
});


fulcro.client.core.Application.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__58578){
var self__ = this;
var G__58578__$1 = this;
return (new cljs.core.RecordIter((0),G__58578__$1,12,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322),new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),new cljs.core.Keyword(null,"remotes","remotes",1132366312),new cljs.core.Keyword(null,"networking","networking",586110628),new cljs.core.Keyword(null,"send-queues","send-queues",-212336330),new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),new cljs.core.Keyword(null,"read-local","read-local",811906273),new cljs.core.Keyword(null,"parser","parser",-1543495310),new cljs.core.Keyword(null,"mounted?","mounted?",712114760),new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


fulcro.client.core.Application.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28779__auto__){
var self__ = this;
var this__28779__auto____$1 = this;
return self__.__meta;
});


fulcro.client.core.Application.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28776__auto__){
var self__ = this;
var this__28776__auto____$1 = this;
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,self__.__hash));
});


fulcro.client.core.Application.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28785__auto__){
var self__ = this;
var this__28785__auto____$1 = this;
return (12 + cljs.core.count.call(null,self__.__extmap));
});


fulcro.client.core.Application.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28777__auto__){
var self__ = this;
var this__28777__auto____$1 = this;
var h__28595__auto__ = self__.__hash;
if(!((h__28595__auto__ == null))){
return h__28595__auto__;
} else {
var h__28595__auto____$1 = ((function (h__28595__auto__,this__28777__auto____$1){
return (function (coll__28778__auto__){
return (1262984183 ^ cljs.core.hash_unordered_coll.call(null,coll__28778__auto__));
});})(h__28595__auto__,this__28777__auto____$1))
.call(null,this__28777__auto____$1);
self__.__hash = h__28595__auto____$1;

return h__28595__auto____$1;
}
});


fulcro.client.core.Application.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this58580,other58581){
var self__ = this;
var this58580__$1 = this;
return (!((other58581 == null))) && ((this58580__$1.constructor === other58581.constructor)) && (cljs.core._EQ_.call(null,this58580__$1.initial_state,other58581.initial_state)) && (cljs.core._EQ_.call(null,this58580__$1.mutation_merge,other58581.mutation_merge)) && (cljs.core._EQ_.call(null,this58580__$1.started_callback,other58581.started_callback)) && (cljs.core._EQ_.call(null,this58580__$1.remotes,other58581.remotes)) && (cljs.core._EQ_.call(null,this58580__$1.networking,other58581.networking)) && (cljs.core._EQ_.call(null,this58580__$1.send_queues,other58581.send_queues)) && (cljs.core._EQ_.call(null,this58580__$1.response_channels,other58581.response_channels)) && (cljs.core._EQ_.call(null,this58580__$1.reconciler,other58581.reconciler)) && (cljs.core._EQ_.call(null,this58580__$1.read_local,other58581.read_local)) && (cljs.core._EQ_.call(null,this58580__$1.parser,other58581.parser)) && (cljs.core._EQ_.call(null,this58580__$1.mounted_QMARK_,other58581.mounted_QMARK_)) && (cljs.core._EQ_.call(null,this58580__$1.reconciler_options,other58581.reconciler_options)) && (cljs.core._EQ_.call(null,this58580__$1.__extmap,other58581.__extmap));
});


fulcro.client.core.Application.prototype.fulcro$client$core$FulcroApplication$ = cljs.core.PROTOCOL_SENTINEL;


fulcro.client.core.Application.prototype.fulcro$client$core$FulcroApplication$mount$arity$3 = (function (this$,root_component,dom_id_or_node){
var self__ = this;
var this$__$1 = this;
return fulcro.client.core.mount_STAR_.call(null,this$__$1,root_component,dom_id_or_node);
});


fulcro.client.core.Application.prototype.fulcro$client$core$FulcroApplication$reset_state_BANG_$arity$2 = (function (this$,new_state){
var self__ = this;
var this$__$1 = this;
return cljs.core.reset_BANG_.call(null,om.next.app_state.call(null,self__.reconciler),new_state);
});


fulcro.client.core.Application.prototype.fulcro$client$core$FulcroApplication$reset_app_BANG_$arity$3 = (function (this$,root_component,callback){
var self__ = this;
var this$__$1 = this;
if(!(fulcro.client.core.iinitial_app_state_QMARK_.call(null,root_component))){
return fulcro.client.logging.error.call(null,"The specified root component does not implement InitialAppState!");
} else {
var base_state = om.next.tree__GT_db.call(null,root_component,fulcro.client.core.initial_state.call(null,root_component,null),true);
this$__$1.fulcro$client$core$FulcroApplication$clear_pending_remote_requests_BANG_$arity$2(null,null);

cljs.core.reset_BANG_.call(null,om.next.app_state.call(null,self__.reconciler),base_state);

this$__$1.fulcro$client$core$FulcroApplication$reset_history_BANG_$arity$1(null);

fulcro.client.core.merge_alternate_union_elements_BANG_.call(null,this$__$1,root_component);

fulcro.client.logging.info.call(null,"updated app state to original ",om.next.app_state.call(null,self__.reconciler));

if(cljs.core._EQ_.call(null,callback,new cljs.core.Keyword(null,"original","original",-445386197))){
self__.started_callback.call(null,this$__$1);
} else {
if(cljs.core.truth_(callback)){
callback.call(null,this$__$1);
} else {
}
}

return this$__$1.fulcro$client$core$FulcroApplication$refresh$arity$1(null);
}
});


fulcro.client.core.Application.prototype.fulcro$client$core$FulcroApplication$clear_pending_remote_requests_BANG_$arity$2 = (function (this$,remotes__$1){
var self__ = this;
var this$__$1 = this;
var remotes__$2 = (((remotes__$1 == null))?cljs.core.keys.call(null,self__.send_queues):(((remotes__$1 instanceof cljs.core.Keyword))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [remotes__$1], null):remotes__$1
));
var seq__58584 = cljs.core.seq.call(null,remotes__$2);
var chunk__58585 = null;
var count__58586 = (0);
var i__58587 = (0);
while(true){
if((i__58587 < count__58586)){
var r = cljs.core._nth.call(null,chunk__58585,i__58587);
fulcro.client.core.clear_queue.call(null,cljs.core.get.call(null,self__.send_queues,r));

var G__58596 = seq__58584;
var G__58597 = chunk__58585;
var G__58598 = count__58586;
var G__58599 = (i__58587 + (1));
seq__58584 = G__58596;
chunk__58585 = G__58597;
count__58586 = G__58598;
i__58587 = G__58599;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__58584);
if(temp__4657__auto__){
var seq__58584__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58584__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__58584__$1);
var G__58600 = cljs.core.chunk_rest.call(null,seq__58584__$1);
var G__58601 = c__28980__auto__;
var G__58602 = cljs.core.count.call(null,c__28980__auto__);
var G__58603 = (0);
seq__58584 = G__58600;
chunk__58585 = G__58601;
count__58586 = G__58602;
i__58587 = G__58603;
continue;
} else {
var r = cljs.core.first.call(null,seq__58584__$1);
fulcro.client.core.clear_queue.call(null,cljs.core.get.call(null,self__.send_queues,r));

var G__58604 = cljs.core.next.call(null,seq__58584__$1);
var G__58605 = null;
var G__58606 = (0);
var G__58607 = (0);
seq__58584 = G__58604;
chunk__58585 = G__58605;
count__58586 = G__58606;
i__58587 = G__58607;
continue;
}
} else {
return null;
}
}
break;
}
});


fulcro.client.core.Application.prototype.fulcro$client$core$FulcroApplication$history$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var history_steps = new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(self__.reconciler)).arr;
var history_map = cljs.core.deref.call(null,new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(self__.reconciler)).index);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"steps","steps",-128433302),history_steps,new cljs.core.Keyword(null,"history","history",-247395220),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (history_steps,history_map,this$__$1){
return (function (p__58588){
var vec__58589 = p__58588;
var k = cljs.core.nth.call(null,vec__58589,(0),null);
var v = cljs.core.nth.call(null,vec__58589,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.assoc.call(null,v,new cljs.core.Keyword("fulcro","meta","fulcro/meta",-1900968057),cljs.core.meta.call(null,v))], null);
});})(history_steps,history_map,this$__$1))
,history_map))], null);
});


fulcro.client.core.Application.prototype.fulcro$client$core$FulcroApplication$reset_history_BANG_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fulcro.client.core.reset_history_impl.call(null,this$__$1);
});


fulcro.client.core.Application.prototype.fulcro$client$core$FulcroApplication$refresh$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
fulcro.client.logging.info.call(null,"RERENDER: NOTE: If your UI doesn't change, make sure you query for :ui/react-key on your Root and embed that as :key in your top-level DOM element");

return fulcro.client.util.force_render.call(null,self__.reconciler);
});


fulcro.client.core.Application.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28790__auto__,k__28791__auto__){
var self__ = this;
var this__28790__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [new cljs.core.Keyword(null,"read-local","read-local",811906273),null,new cljs.core.Keyword(null,"networking","networking",586110628),null,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322),null,new cljs.core.Keyword(null,"remotes","remotes",1132366312),null,new cljs.core.Keyword(null,"mounted?","mounted?",712114760),null,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128),null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),null,new cljs.core.Keyword(null,"parser","parser",-1543495310),null,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330),null,new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),null,new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),null,new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035),null], null), null),k__28791__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28790__auto____$1),self__.__meta),k__28791__auto__);
} else {
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28791__auto__)),null));
}
});


fulcro.client.core.Application.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28788__auto__,k__28789__auto__,G__58578){
var self__ = this;
var this__28788__auto____$1 = this;
var pred__58592 = cljs.core.keyword_identical_QMARK_;
var expr__58593 = k__28789__auto__;
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),expr__58593))){
return (new fulcro.client.core.Application(G__58578,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,G__58578,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,G__58578,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"remotes","remotes",1132366312),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,G__58578,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"networking","networking",586110628),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,G__58578,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,G__58578,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,G__58578,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,G__58578,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"read-local","read-local",811906273),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,G__58578,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"parser","parser",-1543495310),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,G__58578,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"mounted?","mounted?",712114760),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,G__58578,self__.reconciler_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__58592.call(null,new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035),expr__58593))){
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,G__58578,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28789__auto__,G__58578),null));
}
}
}
}
}
}
}
}
}
}
}
}
});


fulcro.client.core.Application.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28793__auto__){
var self__ = this;
var this__28793__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),self__.initial_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322),self__.mutation_merge],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),self__.started_callback],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remotes","remotes",1132366312),self__.remotes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"networking","networking",586110628),self__.networking],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-queues","send-queues",-212336330),self__.send_queues],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128),self__.response_channels],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),self__.reconciler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-local","read-local",811906273),self__.read_local],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parser","parser",-1543495310),self__.parser],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"mounted?","mounted?",712114760),self__.mounted_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035),self__.reconciler_options],null))], null),self__.__extmap));
});


fulcro.client.core.Application.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28780__auto__,G__58578){
var self__ = this;
var this__28780__auto____$1 = this;
return (new fulcro.client.core.Application(self__.initial_state,self__.mutation_merge,self__.started_callback,self__.remotes,self__.networking,self__.send_queues,self__.response_channels,self__.reconciler,self__.read_local,self__.parser,self__.mounted_QMARK_,self__.reconciler_options,G__58578,self__.__extmap,self__.__hash));
});


fulcro.client.core.Application.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28786__auto__,entry__28787__auto__){
var self__ = this;
var this__28786__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28787__auto__)){
return this__28786__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28787__auto__,(0)),cljs.core._nth.call(null,entry__28787__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28786__auto____$1,entry__28787__auto__);
}
});

fulcro.client.core.Application.getBasis = (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"initial-state","initial-state",-381085279,null),new cljs.core.Symbol(null,"mutation-merge","mutation-merge",-491211795,null),new cljs.core.Symbol(null,"started-callback","started-callback",-158055424,null),new cljs.core.Symbol(null,"remotes","remotes",-1522069457,null),new cljs.core.Symbol(null,"networking","networking",-2068325141,null),new cljs.core.Symbol(null,"send-queues","send-queues",1428195197,null),new cljs.core.Symbol(null,"response-channels","response-channels",-230527601,null),new cljs.core.Symbol(null,"reconciler","reconciler",-192295439,null),new cljs.core.Symbol(null,"read-local","read-local",-1842529496,null),new cljs.core.Symbol(null,"parser","parser",97036217,null),new cljs.core.Symbol(null,"mounted?","mounted?",-1942321009,null),new cljs.core.Symbol(null,"reconciler-options","reconciler-options",-1005320734,null)], null);
});

fulcro.client.core.Application.cljs$lang$type = true;

fulcro.client.core.Application.cljs$lang$ctorPrSeq = (function (this__28817__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"fulcro.client.core/Application");
});

fulcro.client.core.Application.cljs$lang$ctorPrWriter = (function (this__28817__auto__,writer__28818__auto__){
return cljs.core._write.call(null,writer__28818__auto__,"fulcro.client.core/Application");
});

fulcro.client.core.__GT_Application = (function fulcro$client$core$__GT_Application(initial_state,mutation_merge,started_callback,remotes,networking,send_queues,response_channels,reconciler,read_local,parser,mounted_QMARK_,reconciler_options){
return (new fulcro.client.core.Application(initial_state,mutation_merge,started_callback,remotes,networking,send_queues,response_channels,reconciler,read_local,parser,mounted_QMARK_,reconciler_options,null,null,null));
});

fulcro.client.core.map__GT_Application = (function fulcro$client$core$map__GT_Application(G__58582){
return (new fulcro.client.core.Application(new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"remotes","remotes",1132366312).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"networking","networking",586110628).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"send-queues","send-queues",-212336330).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"read-local","read-local",811906273).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"parser","parser",-1543495310).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"mounted?","mounted?",712114760).cljs$core$IFn$_invoke$arity$1(G__58582),new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035).cljs$core$IFn$_invoke$arity$1(G__58582),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__58582,new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322),new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),new cljs.core.Keyword(null,"remotes","remotes",1132366312),new cljs.core.Keyword(null,"networking","networking",586110628),new cljs.core.Keyword(null,"send-queues","send-queues",-212336330),new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128),new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),new cljs.core.Keyword(null,"read-local","read-local",811906273),new cljs.core.Keyword(null,"parser","parser",-1543495310),new cljs.core.Keyword(null,"mounted?","mounted?",712114760),new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035))),null));
});

/**
 * Create a test client that has no networking. Useful for UI testing with a real Fulcro app container.
 */
fulcro.client.core.new_fulcro_test_client = (function fulcro$client$core$new_fulcro_test_client(var_args){
var args__29319__auto__ = [];
var len__29312__auto___58612 = arguments.length;
var i__29313__auto___58613 = (0);
while(true){
if((i__29313__auto___58613 < len__29312__auto___58612)){
args__29319__auto__.push((arguments[i__29313__auto___58613]));

var G__58614 = (i__29313__auto___58613 + (1));
i__29313__auto___58613 = G__58614;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return fulcro.client.core.new_fulcro_test_client.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

fulcro.client.core.new_fulcro_test_client.cljs$core$IFn$_invoke$arity$variadic = (function (p__58609){
var map__58610 = p__58609;
var map__58610__$1 = ((((!((map__58610 == null)))?((((map__58610.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58610.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58610):map__58610);
var initial_state = cljs.core.get.call(null,map__58610__$1,new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),cljs.core.PersistentArrayMap.EMPTY);
var started_callback = cljs.core.get.call(null,map__58610__$1,new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),null);
var reconciler_options = cljs.core.get.call(null,map__58610__$1,new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035));
return fulcro.client.core.map__GT_Application.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"initial-state","initial-state",-2021616806),initial_state,new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),started_callback,new cljs.core.Keyword(null,"reconciler-options","reconciler-options",1649115035),reconciler_options,new cljs.core.Keyword(null,"networking","networking",586110628),fulcro.client.network.mock_network.call(null)], null));
});

fulcro.client.core.new_fulcro_test_client.cljs$lang$maxFixedArity = (0);

fulcro.client.core.new_fulcro_test_client.cljs$lang$applyTo = (function (seq58608){
return fulcro.client.core.new_fulcro_test_client.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq58608));
});

/**
 * Get the current window location from the browser
 */
fulcro.client.core.get_url = (function fulcro$client$core$get_url(){
return window.location.href;
});
/**
 * Get the current URI parameters from the browser url or one you supply
 */
fulcro.client.core.uri_params = (function fulcro$client$core$uri_params(var_args){
var G__58616 = arguments.length;
switch (G__58616) {
case 0:
return fulcro.client.core.uri_params.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fulcro.client.core.uri_params.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.core.uri_params.cljs$core$IFn$_invoke$arity$0 = (function (){
return fulcro.client.core.uri_params.call(null,fulcro.client.core.get_url.call(null));
});

fulcro.client.core.uri_params.cljs$core$IFn$_invoke$arity$1 = (function (url){
var query_data = (new goog.Uri(url)).getQueryData();
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__28949__auto__ = ((function (query_data){
return (function fulcro$client$core$iter__58617(s__58618){
return (new cljs.core.LazySeq(null,((function (query_data){
return (function (){
var s__58618__$1 = s__58618;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__58618__$1);
if(temp__4657__auto__){
var s__58618__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__58618__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__58618__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__58620 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__58619 = (0);
while(true){
if((i__58619 < size__28948__auto__)){
var k = cljs.core._nth.call(null,c__28947__auto__,i__58619);
cljs.core.chunk_append.call(null,b__58620,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,query_data.get(k)], null));

var G__58622 = (i__58619 + (1));
i__58619 = G__58622;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__58620),fulcro$client$core$iter__58617.call(null,cljs.core.chunk_rest.call(null,s__58618__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__58620),null);
}
} else {
var k = cljs.core.first.call(null,s__58618__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,query_data.get(k)], null),fulcro$client$core$iter__58617.call(null,cljs.core.rest.call(null,s__58618__$2)));
}
} else {
return null;
}
break;
}
});})(query_data))
,null,null));
});})(query_data))
;
return iter__28949__auto__.call(null,query_data.getKeys());
})());
});

fulcro.client.core.uri_params.cljs$lang$maxFixedArity = 1;

/**
 * Get the value of the named parameter from the browser URL (or an explicit one)
 */
fulcro.client.core.get_url_param = (function fulcro$client$core$get_url_param(var_args){
var G__58624 = arguments.length;
switch (G__58624) {
case 1:
return fulcro.client.core.get_url_param.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.core.get_url_param.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.core.get_url_param.cljs$core$IFn$_invoke$arity$1 = (function (param_name){
return fulcro.client.core.get_url_param.call(null,fulcro.client.core.get_url.call(null),param_name);
});

fulcro.client.core.get_url_param.cljs$core$IFn$_invoke$arity$2 = (function (url,param_name){
return cljs.core.get.call(null,fulcro.client.core.uri_params.call(null,url),param_name);
});

fulcro.client.core.get_url_param.cljs$lang$maxFixedArity = 2;

/**
 * Calculates the query that can be used to pull (or merge) a component with an ident
 *   to/from a normalized app database. Requires a tree of data that represents the instance of
 *   the component in question (e.g. ident will work on it)
 */
fulcro.client.core.component_merge_query = (function fulcro$client$core$component_merge_query(component,object_data){
var ident = om.next.ident.call(null,component,object_data);
var object_query = om.next.get_query.call(null,component);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([ident,object_query])], null);
});
/**
 * Does the steps necessary to honor the data merge technique defined by Fulcro with respect
 *   to data overwrites in the app database.
 */
fulcro.client.core.preprocess_merge = (function fulcro$client$core$preprocess_merge(state_atom,component,object_data){
var ident = fulcro.client.util.get_ident.call(null,component,object_data);
var object_query = om.next.get_query.call(null,component);
var object_query__$1 = ((cljs.core.map_QMARK_.call(null,object_query))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [object_query], null):object_query);
var base_query = fulcro.client.core.component_merge_query.call(null,component,object_data);
var merge_query = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro","merge","fulcro/merge",-1037375858),base_query], null)], null);
var existing_data = cljs.core.get.call(null,om.next.db__GT_tree.call(null,base_query,cljs.core.deref.call(null,state_atom),cljs.core.deref.call(null,state_atom)),ident,cljs.core.PersistentArrayMap.EMPTY);
var marked_data = fulcro.client.impl.om_plumbing.mark_missing.call(null,object_data,object_query__$1);
var merge_data = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro","merge","fulcro/merge",-1037375858),cljs.core.PersistentArrayMap.createAsIfByAssoc([ident,fulcro.client.util.deep_merge.call(null,existing_data,marked_data)])], null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"merge-query","merge-query",610171663),merge_query,new cljs.core.Keyword(null,"merge-data","merge-data",1760143734),merge_data], null);
});
/**
 * Returns TRUE when x is an atom.
 */
fulcro.client.core.is_atom_QMARK_ = (function fulcro$client$core$is_atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
/**
 * Integrate an ident into any number of places in the app state. This function is safe to use within mutation
 *   implementations as a general helper function.
 * 
 *   The named parameters can be specified any number of times. They are:
 * 
 *   - append:  A vector (path) to a list in your app state where this new object's ident should be appended. Will not append
 *   the ident if that ident is already in the list.
 *   - prepend: A vector (path) to a list in your app state where this new object's ident should be prepended. Will not append
 *   the ident if that ident is already in the list.
 *   - replace: A vector (path) to a specific location in app-state where this object's ident should be placed. Can target a to-one or to-many.
 * If the target is a vector element then that element must already exist in the vector.
 */
fulcro.client.core.integrate_ident = (function fulcro$client$core$integrate_ident(var_args){
var args__29319__auto__ = [];
var len__29312__auto___58636 = arguments.length;
var i__29313__auto___58637 = (0);
while(true){
if((i__29313__auto___58637 < len__29312__auto___58636)){
args__29319__auto__.push((arguments[i__29313__auto___58637]));

var G__58638 = (i__29313__auto___58637 + (1));
i__29313__auto___58637 = G__58638;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return fulcro.client.core.integrate_ident.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

fulcro.client.core.integrate_ident.cljs$core$IFn$_invoke$arity$variadic = (function (state,ident,named_parameters){
if(cljs.core.map_QMARK_.call(null,state)){
} else {
throw (new Error("Assert failed: (map? state)"));
}

var actions = cljs.core.partition.call(null,(2),named_parameters);
return cljs.core.reduce.call(null,((function (actions){
return (function (state__$1,p__58631){
var vec__58632 = p__58631;
var command = cljs.core.nth.call(null,vec__58632,(0),null);
var data_path = cljs.core.nth.call(null,vec__58632,(1),null);
var already_has_ident_at_path_QMARK_ = ((function (vec__58632,command,data_path,actions){
return (function (data_path__$1){
return cljs.core.some.call(null,((function (vec__58632,command,data_path,actions){
return (function (p1__58626_SHARP_){
return cljs.core._EQ_.call(null,p1__58626_SHARP_,ident);
});})(vec__58632,command,data_path,actions))
,cljs.core.get_in.call(null,state__$1,data_path__$1));
});})(vec__58632,command,data_path,actions))
;
var G__58635 = command;
var G__58635__$1 = (((G__58635 instanceof cljs.core.Keyword))?G__58635.fqn:null);
switch (G__58635__$1) {
case "prepend":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_.call(null,data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for prepend must target an app-state vector."].join('')),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,((function (G__58635,G__58635__$1,already_has_ident_at_path_QMARK_,vec__58632,command,data_path,actions){
return (function (p1__58627_SHARP_){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ident], null),p1__58627_SHARP_);
});})(G__58635,G__58635__$1,already_has_ident_at_path_QMARK_,vec__58632,command,data_path,actions))
);
}

break;
case "append":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_.call(null,data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for append must target an app-state vector."].join('')),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,cljs.core.conj,ident);
}

break;
case "replace":
var path_to_vector = cljs.core.butlast.call(null,data_path);
var to_many_QMARK_ = (cljs.core.seq.call(null,path_to_vector)) && (cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,path_to_vector)));
var index = cljs.core.last.call(null,data_path);
var vector = cljs.core.get_in.call(null,state__$1,path_to_vector);
if(cljs.core.vector_QMARK_.call(null,data_path)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Replacement path must be a vector. You passed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)].join('')),"\n","(vector? data-path)"].join('')));
}

if(to_many_QMARK_){
if(cljs.core.vector_QMARK_.call(null,vector)){
} else {
throw (new Error(["Assert failed: ","Path for replacement must be a vector","\n","(vector? vector)"].join('')));
}

if(typeof index === 'number'){
} else {
throw (new Error(["Assert failed: ","Path for replacement must end in a vector index","\n","(number? index)"].join('')));
}

if(cljs.core.contains_QMARK_.call(null,vector,index)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Target vector for replacement does not have an item at index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index)].join('')),"\n","(contains? vector index)"].join('')));
}
} else {
}

return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
default:
throw cljs.core.ex_info.call(null,"Unknown post-op to merge-state!: ",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"command","command",-894540724),command,new cljs.core.Keyword(null,"arg","arg",-1747261837),data_path], null));

}
});})(actions))
,state,actions);
});

fulcro.client.core.integrate_ident.cljs$lang$maxFixedArity = (2);

fulcro.client.core.integrate_ident.cljs$lang$applyTo = (function (seq58628){
var G__58629 = cljs.core.first.call(null,seq58628);
var seq58628__$1 = cljs.core.next.call(null,seq58628);
var G__58630 = cljs.core.first.call(null,seq58628__$1);
var seq58628__$2 = cljs.core.next.call(null,seq58628__$1);
return fulcro.client.core.integrate_ident.cljs$core$IFn$_invoke$arity$variadic(G__58629,G__58630,seq58628__$2);
});

/**
 * Integrate an ident into any number of places in the app state. This function is safe to use within mutation
 *   implementations as a general helper function.
 * 
 *   The named parameters can be specified any number of times. They are:
 * 
 *   - append:  A vector (path) to a list in your app state where this new object's ident should be appended. Will not append
 *   the ident if that ident is already in the list.
 *   - prepend: A vector (path) to a list in your app state where this new object's ident should be prepended. Will not append
 *   the ident if that ident is already in the list.
 *   - replace: A vector (path) to a specific location in app-state where this object's ident should be placed. Can target a to-one or to-many.
 * If the target is a vector element then that element must already exist in the vector.
 *   
 */
fulcro.client.core.integrate_ident_BANG_ = (function fulcro$client$core$integrate_ident_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___58643 = arguments.length;
var i__29313__auto___58644 = (0);
while(true){
if((i__29313__auto___58644 < len__29312__auto___58643)){
args__29319__auto__.push((arguments[i__29313__auto___58644]));

var G__58645 = (i__29313__auto___58644 + (1));
i__29313__auto___58644 = G__58645;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return fulcro.client.core.integrate_ident_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

fulcro.client.core.integrate_ident_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,ident,named_parameters){
if(cljs.core.truth_(fulcro.client.core.is_atom_QMARK_.call(null,state))){
} else {
throw (new Error(["Assert failed: ","The state has to be an atom. Use 'integrate-ident' instead.","\n","(is-atom? state)"].join('')));
}

return cljs.core.apply.call(null,cljs.core.swap_BANG_,state,fulcro.client.core.integrate_ident,ident,named_parameters);
});

fulcro.client.core.integrate_ident_BANG_.cljs$lang$maxFixedArity = (2);

fulcro.client.core.integrate_ident_BANG_.cljs$lang$applyTo = (function (seq58640){
var G__58641 = cljs.core.first.call(null,seq58640);
var seq58640__$1 = cljs.core.next.call(null,seq58640);
var G__58642 = cljs.core.first.call(null,seq58640__$1);
var seq58640__$2 = cljs.core.next.call(null,seq58640__$1);
return fulcro.client.core.integrate_ident_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__58641,G__58642,seq58640__$2);
});

/**
 * Normalize and merge a (sub)tree of application state into the application using a known UI component's query and ident.
 * 
 *   This utility function obtains the ident of the incoming object-data using the UI component's ident function. Once obtained,
 *   it uses the component's query and ident to normalize the data and place the resulting objects in the correct tables.
 *   It is also quite common to want those new objects to be linked into lists in other spot in app state, so this function
 *   supports optional named parameters for doing this. These named parameters can be repeated as many times as you like in order
 *   to place the ident of the new object into other data structures of app state.
 * 
 *   This function honors the data merge story for Fulcro: attributes that are queried for but do not appear in the
 *   data will be removed from the application. This function also uses the initial state for the component as a base
 *   for merge if there was no state for the object already in the database.
 * 
 *   This function will also trigger re-renders of components that directly render object merged, as well as any components
 *   into which you integrate that data via the named-parameters.
 * 
 *   This function is primarily meant to be used from things like server push and setTimeout/setInterval, where you're outside
 *   of the normal mutation story. Do not use this function within abstract mutations.
 * 
 *   - app-or-reconciler: The Fulcro application or Om reconciler
 *   - component: The class of the component that corresponsds to the data. Must have an ident.
 *   - object-data: A map (tree) of data to merge. Will be normalized for you.
 *   - named-parameter: Post-processing ident integration steps. see integrate-ident!
 * 
 *   Any keywords that appear in ident integration steps will be added to the re-render queue.
 *   
 */
fulcro.client.core.merge_state_BANG_ = (function fulcro$client$core$merge_state_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___58653 = arguments.length;
var i__29313__auto___58654 = (0);
while(true){
if((i__29313__auto___58654 < len__29312__auto___58653)){
args__29319__auto__.push((arguments[i__29313__auto___58654]));

var G__58655 = (i__29313__auto___58654 + (1));
i__29313__auto___58654 = G__58655;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return fulcro.client.core.merge_state_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

fulcro.client.core.merge_state_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_or_reconciler,component,object_data,named_parameters){
if(fulcro.client.core.iident_QMARK_.call(null,component)){
} else {
fulcro.client.logging.warn.call(null,"merge-state!: component must implement Ident");
}

var ident = fulcro.client.util.get_ident.call(null,component,object_data);
var reconciler = ((((!((app_or_reconciler == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === app_or_reconciler.fulcro$client$core$FulcroApplication$)))?true:false):false))?new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app_or_reconciler):app_or_reconciler);
var state = om.next.app_state.call(null,reconciler);
var data_path_keys = cljs.core.vec.call(null,cljs.core.set.call(null,cljs.core.filter.call(null,cljs.core.keyword_QMARK_,cljs.core.flatten.call(null,cljs.core.map.call(null,cljs.core.second,cljs.core.partition.call(null,(2),named_parameters))))));
var map__58650 = fulcro.client.core.preprocess_merge.call(null,state,component,object_data);
var map__58650__$1 = ((((!((map__58650 == null)))?((((map__58650.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58650.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58650):map__58650);
var merge_data = cljs.core.get.call(null,map__58650__$1,new cljs.core.Keyword(null,"merge-data","merge-data",1760143734));
var merge_query = cljs.core.get.call(null,map__58650__$1,new cljs.core.Keyword(null,"merge-query","merge-query",610171663));
om.next.merge_BANG_.call(null,reconciler,merge_data,merge_query);

cljs.core.swap_BANG_.call(null,state,cljs.core.dissoc,new cljs.core.Keyword("fulcro","merge","fulcro/merge",-1037375858));

cljs.core.apply.call(null,fulcro.client.core.integrate_ident_BANG_,state,ident,named_parameters);

om.next.protocols.queue_BANG_.call(null,reconciler,data_path_keys);

return cljs.core.deref.call(null,state);
});

fulcro.client.core.merge_state_BANG_.cljs$lang$maxFixedArity = (3);

fulcro.client.core.merge_state_BANG_.cljs$lang$applyTo = (function (seq58646){
var G__58647 = cljs.core.first.call(null,seq58646);
var seq58646__$1 = cljs.core.next.call(null,seq58646);
var G__58648 = cljs.core.first.call(null,seq58646__$1);
var seq58646__$2 = cljs.core.next.call(null,seq58646__$1);
var G__58649 = cljs.core.first.call(null,seq58646__$2);
var seq58646__$3 = cljs.core.next.call(null,seq58646__$2);
return fulcro.client.core.merge_state_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__58647,G__58648,G__58649,seq58646__$3);
});

/**
 * Build a component's initial state using the defsc initial-state-data from
 *   options, the children from options, and the params from the invocation of get-initial-state.
 */
fulcro.client.core.make_state_map = (function fulcro$client$core$make_state_map(initial_state,children,params){
var join_keys = cljs.core.set.call(null,cljs.core.keys.call(null,children));
var init_keys = cljs.core.set.call(null,cljs.core.keys.call(null,initial_state));
var is_child_QMARK_ = ((function (join_keys,init_keys){
return (function (k){
return cljs.core.contains_QMARK_.call(null,join_keys,k);
});})(join_keys,init_keys))
;
var value_of = ((function (join_keys,init_keys,is_child_QMARK_){
return (function fulcro$client$core$make_state_map_$_value_of_STAR_(p__58658){
var vec__58659 = p__58658;
var k = cljs.core.nth.call(null,vec__58659,(0),null);
var v = cljs.core.nth.call(null,vec__58659,(1),null);
var param_name = ((function (vec__58659,k,v,join_keys,init_keys,is_child_QMARK_){
return (function (v__$1){
var and__28129__auto__ = (v__$1 instanceof cljs.core.Keyword);
if(and__28129__auto__){
var and__28129__auto____$1 = cljs.core._EQ_.call(null,"param",cljs.core.namespace.call(null,v__$1));
if(and__28129__auto____$1){
return cljs.core.keyword.call(null,cljs.core.name.call(null,v__$1));
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
});})(vec__58659,k,v,join_keys,init_keys,is_child_QMARK_))
;
var substitute = ((function (param_name,vec__58659,k,v,join_keys,init_keys,is_child_QMARK_){
return (function (ele){
var temp__4655__auto__ = param_name.call(null,ele);
if(cljs.core.truth_(temp__4655__auto__)){
var k__$1 = temp__4655__auto__;
return cljs.core.get.call(null,params,k__$1);
} else {
return ele;
}
});})(param_name,vec__58659,k,v,join_keys,init_keys,is_child_QMARK_))
;
var param_key = param_name.call(null,v);
var param_exists_QMARK_ = cljs.core.contains_QMARK_.call(null,params,param_key);
var param_value = cljs.core.get.call(null,params,param_key);
var child_class = cljs.core.get.call(null,children,k);
if(cljs.core.truth_((function (){var and__28129__auto__ = param_key;
if(cljs.core.truth_(and__28129__auto__)){
return !(param_exists_QMARK_);
} else {
return and__28129__auto__;
}
})())){
return null;
} else {
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.map_QMARK_.call(null,v);
if(and__28129__auto__){
return is_child_QMARK_.call(null,k);
} else {
return and__28129__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fulcro.client.core.get_initial_state.call(null,child_class,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,fulcro$client$core$make_state_map_$_value_of_STAR_,v)))], null);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,fulcro$client$core$make_state_map_$_value_of_STAR_,v))], null);
} else {
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.vector_QMARK_.call(null,v);
if(and__28129__auto__){
return is_child_QMARK_.call(null,k);
} else {
return and__28129__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.mapv.call(null,((function (param_name,substitute,param_key,param_exists_QMARK_,param_value,child_class,vec__58659,k,v,join_keys,init_keys,is_child_QMARK_){
return (function (m){
return fulcro.client.core.get_initial_state.call(null,child_class,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,fulcro$client$core$make_state_map_$_value_of_STAR_,m)));
});})(param_name,substitute,param_key,param_exists_QMARK_,param_value,child_class,vec__58659,k,v,join_keys,init_keys,is_child_QMARK_))
,v)], null);
} else {
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.vector_QMARK_.call(null,param_value);
if(and__28129__auto__){
return is_child_QMARK_.call(null,k);
} else {
return and__28129__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.mapv.call(null,((function (param_name,substitute,param_key,param_exists_QMARK_,param_value,child_class,vec__58659,k,v,join_keys,init_keys,is_child_QMARK_){
return (function (params__$1){
return fulcro.client.core.get_initial_state.call(null,child_class,params__$1);
});})(param_name,substitute,param_key,param_exists_QMARK_,param_value,child_class,vec__58659,k,v,join_keys,init_keys,is_child_QMARK_))
,param_value)], null);
} else {
if(cljs.core.vector_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.mapv.call(null,((function (param_name,substitute,param_key,param_exists_QMARK_,param_value,child_class,vec__58659,k,v,join_keys,init_keys,is_child_QMARK_){
return (function (ele){
return substitute.call(null,ele);
});})(param_name,substitute,param_key,param_exists_QMARK_,param_value,child_class,vec__58659,k,v,join_keys,init_keys,is_child_QMARK_))
,v)], null);
} else {
if(cljs.core.truth_((function (){var and__28129__auto__ = param_key;
if(cljs.core.truth_(and__28129__auto__)){
var and__28129__auto____$1 = is_child_QMARK_.call(null,k);
if(cljs.core.truth_(and__28129__auto____$1)){
return param_exists_QMARK_;
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fulcro.client.core.get_initial_state.call(null,child_class,param_value)], null);
} else {
if(cljs.core.truth_(param_key)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,param_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null);

}
}
}
}
}
}
}
}
});})(join_keys,init_keys,is_child_QMARK_))
;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,value_of,initial_state));
});

//# sourceMappingURL=core.js.map?rel=1511229562058
