// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.inspect.helpers');
goog.require('cljs.core');
goog.require('fulcro.client.core');
goog.require('om.next');
/**
 * Integrate an ident into any number of places in the app state. This function is safe to use within mutation
 *   implementations as a general helper function.
 * 
 *   The named parameters can be specified any number of times. They are:
 * 
 *   - set: A vector (path) to a list in your app state where this new object's ident should be set.
 *   - append:  A vector (path) to a list in your app state where this new object's ident should be appended. Will not append
 *   the ident if that ident is already in the list.
 *   - prepend: A vector (path) to a list in your app state where this new object's ident should be prepended. Will not append
 *   the ident if that ident is already in the list.
 *   - replace: A vector (path) to a specific location in app-state where this object's ident should be placed. Can target a to-one or to-many.
 * If the target is a vector element then that element must already exist in the vector.
 */
fulcro.inspect.helpers.integrate_ident = (function fulcro$inspect$helpers$integrate_ident(var_args){
var args__29319__auto__ = [];
var len__29312__auto___306490 = arguments.length;
var i__29313__auto___306491 = (0);
while(true){
if((i__29313__auto___306491 < len__29312__auto___306490)){
args__29319__auto__.push((arguments[i__29313__auto___306491]));

var G__306492 = (i__29313__auto___306491 + (1));
i__29313__auto___306491 = G__306492;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return fulcro.inspect.helpers.integrate_ident.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

fulcro.inspect.helpers.integrate_ident.cljs$core$IFn$_invoke$arity$variadic = (function (state,ident,named_parameters){
if(cljs.core.map_QMARK_.call(null,state)){
} else {
throw (new Error("Assert failed: (map? state)"));
}

var actions = cljs.core.partition.call(null,(2),named_parameters);
return cljs.core.reduce.call(null,((function (actions){
return (function (state__$1,p__306485){
var vec__306486 = p__306485;
var command = cljs.core.nth.call(null,vec__306486,(0),null);
var data_path = cljs.core.nth.call(null,vec__306486,(1),null);
var already_has_ident_at_path_QMARK_ = ((function (vec__306486,command,data_path,actions){
return (function (data_path__$1){
return cljs.core.some.call(null,((function (vec__306486,command,data_path,actions){
return (function (p1__306480_SHARP_){
return cljs.core._EQ_.call(null,p1__306480_SHARP_,ident);
});})(vec__306486,command,data_path,actions))
,cljs.core.get_in.call(null,state__$1,data_path__$1));
});})(vec__306486,command,data_path,actions))
;
var G__306489 = command;
var G__306489__$1 = (((G__306489 instanceof cljs.core.Keyword))?G__306489.fqn:null);
switch (G__306489__$1) {
case "set":
return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
case "prepend":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_.call(null,data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for prepend must target an app-state vector."].join('')),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,((function (G__306489,G__306489__$1,already_has_ident_at_path_QMARK_,vec__306486,command,data_path,actions){
return (function (p1__306481_SHARP_){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ident], null),p1__306481_SHARP_);
});})(G__306489,G__306489__$1,already_has_ident_at_path_QMARK_,vec__306486,command,data_path,actions))
);
}

break;
case "append":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_.call(null,data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for append must target an app-state vector."].join('')),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,cljs.core.conj,ident);
}

break;
case "replace":
var path_to_vector = cljs.core.butlast.call(null,data_path);
var to_many_QMARK_ = (cljs.core.seq.call(null,path_to_vector)) && (cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,path_to_vector)));
var index = cljs.core.last.call(null,data_path);
var vector = cljs.core.get_in.call(null,state__$1,path_to_vector);
if(cljs.core.vector_QMARK_.call(null,data_path)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Replacement path must be a vector. You passed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)].join('')),"\n","(vector? data-path)"].join('')));
}

if(to_many_QMARK_){
if(cljs.core.vector_QMARK_.call(null,vector)){
} else {
throw (new Error(["Assert failed: ","Path for replacement must be a vector","\n","(vector? vector)"].join('')));
}

if(typeof index === 'number'){
} else {
throw (new Error(["Assert failed: ","Path for replacement must end in a vector index","\n","(number? index)"].join('')));
}

if(cljs.core.contains_QMARK_.call(null,vector,index)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Target vector for replacement does not have an item at index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index)].join('')),"\n","(contains? vector index)"].join('')));
}
} else {
}

return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
default:
throw cljs.core.ex_info.call(null,"Unknown post-op to merge-state!: ",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"command","command",-894540724),command,new cljs.core.Keyword(null,"arg","arg",-1747261837),data_path], null));

}
});})(actions))
,state,actions);
});

fulcro.inspect.helpers.integrate_ident.cljs$lang$maxFixedArity = (2);

fulcro.inspect.helpers.integrate_ident.cljs$lang$applyTo = (function (seq306482){
var G__306483 = cljs.core.first.call(null,seq306482);
var seq306482__$1 = cljs.core.next.call(null,seq306482);
var G__306484 = cljs.core.first.call(null,seq306482__$1);
var seq306482__$2 = cljs.core.next.call(null,seq306482__$1);
return fulcro.inspect.helpers.integrate_ident.cljs$core$IFn$_invoke$arity$variadic(G__306483,G__306484,seq306482__$2);
});

fulcro.inspect.helpers.merge_entity = (function fulcro$inspect$helpers$merge_entity(var_args){
var args__29319__auto__ = [];
var len__29312__auto___306503 = arguments.length;
var i__29313__auto___306504 = (0);
while(true){
if((i__29313__auto___306504 < len__29312__auto___306503)){
args__29319__auto__.push((arguments[i__29313__auto___306504]));

var G__306505 = (i__29313__auto___306504 + (1));
i__29313__auto___306504 = G__306505;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return fulcro.inspect.helpers.merge_entity.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

fulcro.inspect.helpers.merge_entity.cljs$core$IFn$_invoke$arity$variadic = (function (state,x,data,named_parameters){

var map__306498 = om.next.tree__GT_db.call(null,(function (){
if(typeof fulcro.inspect.helpers.t_fulcro$inspect$helpers306499 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {om.next.IQuery}
 * @implements {cljs.core.IWithMeta}
*/
fulcro.inspect.helpers.t_fulcro$inspect$helpers306499 = (function (state,x,data,named_parameters,meta306500){
this.state = state;
this.x = x;
this.data = data;
this.named_parameters = named_parameters;
this.meta306500 = meta306500;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers306499.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_306501,meta306500__$1){
var self__ = this;
var _306501__$1 = this;
return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers306499(self__.state,self__.x,self__.data,self__.named_parameters,meta306500__$1));
});


fulcro.inspect.helpers.t_fulcro$inspect$helpers306499.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_306501){
var self__ = this;
var _306501__$1 = this;
return self__.meta306500;
});


fulcro.inspect.helpers.t_fulcro$inspect$helpers306499.prototype.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


fulcro.inspect.helpers.t_fulcro$inspect$helpers306499.prototype.om$next$IQuery$query$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),om.next.get_query.call(null,self__.x)], null)], null);
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers306499.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"named-parameters","named-parameters",2053922585,null),new cljs.core.Symbol(null,"meta306500","meta306500",494622199,null)], null);
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers306499.cljs$lang$type = true;

fulcro.inspect.helpers.t_fulcro$inspect$helpers306499.cljs$lang$ctorStr = "fulcro.inspect.helpers/t_fulcro$inspect$helpers306499";

fulcro.inspect.helpers.t_fulcro$inspect$helpers306499.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"fulcro.inspect.helpers/t_fulcro$inspect$helpers306499");
});

fulcro.inspect.helpers.__GT_t_fulcro$inspect$helpers306499 = (function fulcro$inspect$helpers$__GT_t_fulcro$inspect$helpers306499(state__$1,x__$1,data__$1,named_parameters__$1,meta306500){
return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers306499(state__$1,x__$1,data__$1,named_parameters__$1,meta306500));
});

}

return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers306499(state,x,data,named_parameters,cljs.core.PersistentArrayMap.EMPTY));
})()
,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),data], null),true);
var map__306498__$1 = ((((!((map__306498 == null)))?((((map__306498.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__306498.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__306498):map__306498);
var idents = map__306498__$1;
var root = cljs.core.get.call(null,map__306498__$1,new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925));
var root_ident = om.next.ident.call(null,x,data);
var idents__$1 = cljs.core.dissoc.call(null,idents,new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),new cljs.core.Keyword("om.next","tables","om.next/tables",1677536335));
var state__$1 = cljs.core.merge_with.call(null,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state,idents__$1);
if(cljs.core.seq.call(null,named_parameters)){
return cljs.core.apply.call(null,fulcro.inspect.helpers.integrate_ident,state__$1,root_ident,named_parameters);
} else {
return state__$1;
}
});

fulcro.inspect.helpers.merge_entity.cljs$lang$maxFixedArity = (3);

fulcro.inspect.helpers.merge_entity.cljs$lang$applyTo = (function (seq306494){
var G__306495 = cljs.core.first.call(null,seq306494);
var seq306494__$1 = cljs.core.next.call(null,seq306494);
var G__306496 = cljs.core.first.call(null,seq306494__$1);
var seq306494__$2 = cljs.core.next.call(null,seq306494__$1);
var G__306497 = cljs.core.first.call(null,seq306494__$2);
var seq306494__$3 = cljs.core.next.call(null,seq306494__$2);
return fulcro.inspect.helpers.merge_entity.cljs$core$IFn$_invoke$arity$variadic(G__306495,G__306496,G__306497,seq306494__$3);
});

fulcro.inspect.helpers.create_entity_BANG_ = (function fulcro$inspect$helpers$create_entity_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___306517 = arguments.length;
var i__29313__auto___306518 = (0);
while(true){
if((i__29313__auto___306518 < len__29312__auto___306517)){
args__29319__auto__.push((arguments[i__29313__auto___306518]));

var G__306519 = (i__29313__auto___306518 + (1));
i__29313__auto___306518 = G__306519;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return fulcro.inspect.helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

fulcro.inspect.helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__306510,x,data,named_parameters){
var map__306511 = p__306510;
var map__306511__$1 = ((((!((map__306511 == null)))?((((map__306511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__306511.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__306511):map__306511);
var state = cljs.core.get.call(null,map__306511__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__306511__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var named_parameters__$1 = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,((function (map__306511,map__306511__$1,state,ref){
return (function (p__306513){
var vec__306514 = p__306513;
var op = cljs.core.nth.call(null,vec__306514,(0),null);
var path = cljs.core.nth.call(null,vec__306514,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [op,cljs.core.conj.call(null,ref,path)], null);
});})(map__306511,map__306511__$1,state,ref))
,cljs.core.partition.call(null,(2),named_parameters)));
return cljs.core.apply.call(null,cljs.core.swap_BANG_,state,fulcro.inspect.helpers.merge_entity,x,fulcro.client.core.get_initial_state.call(null,x,data),named_parameters__$1);
});

fulcro.inspect.helpers.create_entity_BANG_.cljs$lang$maxFixedArity = (3);

fulcro.inspect.helpers.create_entity_BANG_.cljs$lang$applyTo = (function (seq306506){
var G__306507 = cljs.core.first.call(null,seq306506);
var seq306506__$1 = cljs.core.next.call(null,seq306506);
var G__306508 = cljs.core.first.call(null,seq306506__$1);
var seq306506__$2 = cljs.core.next.call(null,seq306506__$1);
var G__306509 = cljs.core.first.call(null,seq306506__$2);
var seq306506__$3 = cljs.core.next.call(null,seq306506__$2);
return fulcro.inspect.helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__306507,G__306508,G__306509,seq306506__$3);
});

fulcro.inspect.helpers.dissoc_in = (function fulcro$inspect$helpers$dissoc_in(m,path){
var G__306520 = m;
if(cljs.core.truth_(cljs.core.get_in.call(null,m,cljs.core.butlast.call(null,path)))){
return cljs.core.update_in.call(null,G__306520,cljs.core.butlast.call(null,path),cljs.core.dissoc,cljs.core.last.call(null,path));
} else {
return G__306520;
}
});
fulcro.inspect.helpers.om_ident_QMARK_ = (function fulcro$inspect$helpers$om_ident_QMARK_(x){
return (cljs.core.vector_QMARK_.call(null,x)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,x))) && ((cljs.core.first.call(null,x) instanceof cljs.core.Keyword));
});
fulcro.inspect.helpers.deep_remove_ref = (function fulcro$inspect$helpers$deep_remove_ref(state,ref){

var item = cljs.core.get_in.call(null,state,ref);
var idents = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.comp.call(null,cljs.core.keep.call(null,((function (item){
return (function (v){
if(cljs.core.truth_(fulcro.inspect.helpers.om_ident_QMARK_.call(null,v))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null);
} else {
if((cljs.core.vector_QMARK_.call(null,v)) && (cljs.core.every_QMARK_.call(null,fulcro.inspect.helpers.om_ident_QMARK_,v))){
return v;
} else {
return null;
}
}
});})(item))
),cljs.core.cat),cljs.core.vals.call(null,item));
return cljs.core.reduce.call(null,((function (item,idents){
return (function (s,i){
return fulcro.inspect.helpers.deep_remove_ref.call(null,s,i);
});})(item,idents))
,fulcro.inspect.helpers.dissoc_in.call(null,state,ref),idents);
});
fulcro.inspect.helpers.vec_remove_index = (function fulcro$inspect$helpers$vec_remove_index(i,v){

return cljs.core.vec.call(null,cljs.core.concat.call(null,cljs.core.subvec.call(null,v,(0),i),cljs.core.subvec.call(null,v,(i + (1)),cljs.core.count.call(null,v))));
});

//# sourceMappingURL=helpers.js.map?rel=1511304480506
