// Compiled by ClojureScript 1.9.946 {}
goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_.call(null,path)){
return cljs.core.every_QMARK_.call(null,com.rpl.specter.static_path_QMARK_,path);
} else {
return cljs.core.not.call(null,com.rpl.specter.impl.dynamic_param_QMARK_.call(null,path));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__96815__delegate = function (args){
var ret = cljs.core.apply.call(null,f,args);
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.sequential_QMARK_.call(null,ret);
if(and__28129__auto__){
return com.rpl.specter.static_path_QMARK_.call(null,ret);
} else {
return and__28129__auto__;
}
})())){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,ret);
} else {
if((cljs.core.sequential_QMARK_.call(null,ret)) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,ret)))){
return cljs.core.first.call(null,ret);
} else {
return ret;

}
}
};
var G__96815 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__96816__i = 0, G__96816__a = new Array(arguments.length -  0);
while (G__96816__i < G__96816__a.length) {G__96816__a[G__96816__i] = arguments[G__96816__i + 0]; ++G__96816__i;}
  args = new cljs.core.IndexedSeq(G__96816__a,0,null);
} 
return G__96815__delegate.call(this,args);};
G__96815.cljs$lang$maxFixedArity = 0;
G__96815.cljs$lang$applyTo = (function (arglist__96818){
var args = cljs.core.seq(arglist__96818);
return G__96815__delegate(args);
});
G__96815.cljs$core$IFn$_invoke$arity$variadic = G__96815__delegate;
return G__96815;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__29319__auto__ = [];
var len__29312__auto___96839 = arguments.length;
var i__29313__auto___96841 = (0);
while(true){
if((i__29313__auto___96841 < len__29312__auto___96839)){
args__29319__auto__.push((arguments[i__29313__auto___96841]));

var G__96842 = (i__29313__auto___96841 + (1));
i__29313__auto___96841 = G__96842;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,cljs.core.vec.call(null,apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq96837){
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq96837));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
return com.rpl.specter.compiled_select.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
return com.rpl.specter.compiled_select_one.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
return com.rpl.specter.compiled_select_one_BANG_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
return com.rpl.specter.compiled_select_first.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
return com.rpl.specter.compiled_select_any.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
return com.rpl.specter.compiled_selected_any_QMARK_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
return com.rpl.specter.compiled_traverse.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath),structure);
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
return com.rpl.specter.compiled_traverse_all.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
return com.rpl.specter.compiled_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure);
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal`. Error is thrown if navigation finishes
 * at a non-`terminal` navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
return com.rpl.specter.compiled_multi_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
return com.rpl.specter.compiled_setval.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),val,structure);
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___96868 = arguments.length;
var i__29313__auto___96869 = (0);
while(true){
if((i__29313__auto___96869 < len__29312__auto___96868)){
args__29319__auto__.push((arguments[i__29313__auto___96869]));

var G__96871 = (i__29313__auto___96869 + (1));
i__29313__auto___96869 = G__96871;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__96865){
var map__96866 = p__96865;
var map__96866__$1 = ((((!((map__96866 == null)))?((((map__96866.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__96866.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__96866):map__96866);
var merge_fn = cljs.core.get.call(null,map__96866__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
return com.rpl.specter.compiled_replace_in.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),merge_fn);
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq96859){
var G__96860 = cljs.core.first.call(null,seq96859);
var seq96859__$1 = cljs.core.next.call(null,seq96859);
var G__96861 = cljs.core.first.call(null,seq96859__$1);
var seq96859__$2 = cljs.core.next.call(null,seq96859__$1);
var G__96862 = cljs.core.first.call(null,seq96859__$2);
var seq96859__$3 = cljs.core.next.call(null,seq96859__$2);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__96860,G__96861,G__96862,seq96859__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (navfn){
var latenavfn = com.rpl.specter.late_resolved_fn.call(null,navfn);
return cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,((function (latenavfn){
return (function() { 
var G__96876__delegate = function (args){
return cljs.core.map.call(null,latenavfn,args);
};
var G__96876 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__96877__i = 0, G__96877__a = new Array(arguments.length -  0);
while (G__96877__i < G__96877__a.length) {G__96877__a[G__96877__i] = arguments[G__96877__i + 0]; ++G__96877__i;}
  args = new cljs.core.IndexedSeq(G__96877__a,0,null);
} 
return G__96876__delegate.call(this,args);};
G__96876.cljs$lang$maxFixedArity = 0;
G__96876.cljs$lang$applyTo = (function (arglist__96880){
var args = cljs.core.seq(arglist__96880);
return G__96876__delegate(args);
});
G__96876.cljs$core$IFn$_invoke$arity$variadic = G__96876__delegate;
return G__96876;
})()
;})(latenavfn))
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter96881 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter96881 = (function (meta96882){
this.meta96882 = meta96882;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter96881.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_96883,meta96882__$1){
var self__ = this;
var _96883__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter96881(meta96882__$1));
});


com.rpl.specter.t_com$rpl$specter96881.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_96883){
var self__ = this;
var _96883__$1 = this;
return self__.meta96882;
});


com.rpl.specter.t_com$rpl$specter96881.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter96881.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.NONE;
});


com.rpl.specter.t_com$rpl$specter96881.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter96881.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta96882","meta96882",1932329805,null)], null);
});

com.rpl.specter.t_com$rpl$specter96881.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter96881.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter96881";

com.rpl.specter.t_com$rpl$specter96881.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter96881");
});

com.rpl.specter.__GT_t_com$rpl$specter96881 = (function com$rpl$specter$__GT_t_com$rpl$specter96881(meta96882){
return (new com.rpl.specter.t_com$rpl$specter96881(meta96882));
});

}

return (new com.rpl.specter.t_com$rpl$specter96881(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * For usage with `multi-transform`, defines an endpoint in the navigation
 *        that will have the parameterized transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter96895 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter96895 = (function (afn,meta96896){
this.afn = afn;
this.meta96896 = meta96896;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter96895.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_96897,meta96896__$1){
var self__ = this;
var _96897__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter96895(self__.afn,meta96896__$1));
});


com.rpl.specter.t_com$rpl$specter96895.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_96897){
var self__ = this;
var _96897__$1 = this;
return self__.meta96896;
});


com.rpl.specter.t_com$rpl$specter96895.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter96895.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"'terminal' should only be used in multi-transform")));
});


com.rpl.specter.t_com$rpl$specter96895.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_.call(null,self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter96895.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta96896","meta96896",-540957823,null)], null);
});

com.rpl.specter.t_com$rpl$specter96895.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter96895.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter96895";

com.rpl.specter.t_com$rpl$specter96895.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter96895");
});

com.rpl.specter.__GT_t_com$rpl$specter96895 = (function com$rpl$specter$__GT_t_com$rpl$specter96895(afn__$1,meta96896){
return (new com.rpl.specter.t_com$rpl$specter96895(afn__$1,meta96896));
});

}

return (new com.rpl.specter.t_com$rpl$specter96895(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
return com.rpl.specter.terminal.call(null,com.rpl.specter.impl.fast_constantly.call(null,v));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter96937 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter96937 = (function (meta96938){
this.meta96938 = meta96938;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter96937.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_96939,meta96938__$1){
var self__ = this;
var _96939__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter96937(meta96938__$1));
});


com.rpl.specter.t_com$rpl$specter96937.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_96939){
var self__ = this;
var _96939__$1 = this;
return self__.meta96938;
});


com.rpl.specter.t_com$rpl$specter96937.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter96937.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});


com.rpl.specter.t_com$rpl$specter96937.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter96937.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta96938","meta96938",1369413477,null)], null);
});

com.rpl.specter.t_com$rpl$specter96937.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter96937.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter96937";

com.rpl.specter.t_com$rpl$specter96937.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter96937");
});

com.rpl.specter.__GT_t_com$rpl$specter96937 = (function com$rpl$specter$__GT_t_com$rpl$specter96937(meta96938){
return (new com.rpl.specter.t_com$rpl$specter96937(meta96938));
});

}

return (new com.rpl.specter.t_com$rpl$specter96937(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta.call(null,structure);
var res = com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta.call(null,res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter96950 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter96950 = (function (meta96951){
this.meta96951 = meta96951;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter96950.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_96952,meta96951__$1){
var self__ = this;
var _96952__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter96950(meta96951__$1));
});


com.rpl.specter.t_com$rpl$specter96950.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_96952){
var self__ = this;
var _96952__$1 = this;
return self__.meta96951;
});


com.rpl.specter.t_com$rpl$specter96950.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter96950.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});


com.rpl.specter.t_com$rpl$specter96950.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var m = cljs.core.meta.call(null,structure);
var res = com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta.call(null,res,m);
} else {
return null;
}
});

com.rpl.specter.t_com$rpl$specter96950.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta96951","meta96951",-825861034,null)], null);
});

com.rpl.specter.t_com$rpl$specter96950.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter96950.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter96950";

com.rpl.specter.t_com$rpl$specter96950.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter96950");
});

com.rpl.specter.__GT_t_com$rpl$specter96950 = (function com$rpl$specter$__GT_t_com$rpl$specter96950(meta96951){
return (new com.rpl.specter.t_com$rpl$specter96950(meta96951));
});

}

return (new com.rpl.specter.t_com$rpl$specter96950(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__32276__auto__,v){
var ret__32277__auto__ = next_fn.call(null,v);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter96986 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter96986 = (function (meta96987){
this.meta96987 = meta96987;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter96986.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_96988,meta96987__$1){
var self__ = this;
var _96988__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter96986(meta96987__$1));
});


com.rpl.specter.t_com$rpl$specter96986.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_96988){
var self__ = this;
var _96988__$1 = this;
return self__.meta96987;
});


com.rpl.specter.t_com$rpl$specter96986.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter96986.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__34062__auto____$1){
return (function (curr__32276__auto__,v){
var ret__32277__auto__ = next_fn.call(null,v);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
});})(next_fn,this__34062__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter96986.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter96986.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta96987","meta96987",949887078,null)], null);
});

com.rpl.specter.t_com$rpl$specter96986.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter96986.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter96986";

com.rpl.specter.t_com$rpl$specter96986.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter96986");
});

com.rpl.specter.__GT_t_com$rpl$specter96986 = (function com$rpl$specter$__GT_t_com$rpl$specter96986(meta96987){
return (new com.rpl.specter.t_com$rpl$specter96986(meta96987));
});

}

return (new com.rpl.specter.t_com$rpl$specter96986(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__32276__auto__,k){
var ret__32277__auto__ = next_fn.call(null,k);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys.call(null,structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97010 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97010 = (function (meta97011){
this.meta97011 = meta97011;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97010.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97012,meta97011__$1){
var self__ = this;
var _97012__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97010(meta97011__$1));
});


com.rpl.specter.t_com$rpl$specter97010.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97012){
var self__ = this;
var _97012__$1 = this;
return self__.meta97011;
});


com.rpl.specter.t_com$rpl$specter97010.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97010.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__34062__auto____$1){
return (function (curr__32276__auto__,k){
var ret__32277__auto__ = next_fn.call(null,k);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
});})(next_fn,this__34062__auto____$1))
,com.rpl.specter.NONE,cljs.core.keys.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter97010.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.map_keys_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter97010.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97011","meta97011",689765795,null)], null);
});

com.rpl.specter.t_com$rpl$specter97010.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97010.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97010";

com.rpl.specter.t_com$rpl$specter97010.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97010");
});

com.rpl.specter.__GT_t_com$rpl$specter97010 = (function com$rpl$specter$__GT_t_com$rpl$specter97010(meta97011){
return (new com.rpl.specter.t_com$rpl$specter97010(meta97011));
});

}

return (new com.rpl.specter.t_com$rpl$specter97010(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97027 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97027 = (function (meta97028){
this.meta97028 = meta97028;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97027.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97029,meta97028__$1){
var self__ = this;
var _97029__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97027(meta97028__$1));
});


com.rpl.specter.t_com$rpl$specter97027.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97029){
var self__ = this;
var _97029__$1 = this;
return self__.meta97028;
});


com.rpl.specter.t_com$rpl$specter97027.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97027.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,structure),structure);
});


com.rpl.specter.t_com$rpl$specter97027.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter97027.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97028","meta97028",193685428,null)], null);
});

com.rpl.specter.t_com$rpl$specter97027.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97027.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97027";

com.rpl.specter.t_com$rpl$specter97027.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97027");
});

com.rpl.specter.__GT_t_com$rpl$specter97027 = (function com$rpl$specter$__GT_t_com$rpl$specter97027(meta97028){
return (new com.rpl.specter.t_com$rpl$specter97027(meta97028));
});

}

return (new com.rpl.specter.t_com$rpl$specter97027(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last);
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first);


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_select.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_transform.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,end_index_fn,structure,s),next_fn);
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start_index_fn,end_index_fn){
if(typeof com.rpl.specter.t_com$rpl$specter97037 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97037 = (function (start_index_fn,end_index_fn,meta97038){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta97038 = meta97038;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97037.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97039,meta97038__$1){
var self__ = this;
var _97039__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97037(self__.start_index_fn,self__.end_index_fn,meta97038__$1));
});


com.rpl.specter.t_com$rpl$specter97037.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97039){
var self__ = this;
var _97039__$1 = this;
return self__.meta97038;
});


com.rpl.specter.t_com$rpl$specter97037.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97037.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var s = self__.start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_select.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,self__.end_index_fn,structure,s),next_fn);
});


com.rpl.specter.t_com$rpl$specter97037.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var s = self__.start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_transform.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,self__.end_index_fn,structure,s),next_fn);
});

com.rpl.specter.t_com$rpl$specter97037.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta97038","meta97038",-1465288237,null)], null);
});

com.rpl.specter.t_com$rpl$specter97037.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97037.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97037";

com.rpl.specter.t_com$rpl$specter97037.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97037");
});

com.rpl.specter.__GT_t_com$rpl$specter97037 = (function com$rpl$specter$__GT_t_com$rpl$specter97037(start_index_fn__$1,end_index_fn__$1,meta97038){
return (new com.rpl.specter.t_com$rpl$specter97037(start_index_fn__$1,end_index_fn__$1,meta97038));
});

}

return (new com.rpl.specter.t_com$rpl$specter97037(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn);
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter97087 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97087 = (function (start,end,meta97088){
this.start = start;
this.end = end;
this.meta97088 = meta97088;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97089,meta97088__$1){
var self__ = this;
var _97089__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97087(self__.start,self__.end,meta97088__$1));
});


com.rpl.specter.t_com$rpl$specter97087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97089){
var self__ = this;
var _97089__$1 = this;
return self__.meta97088;
});


com.rpl.specter.t_com$rpl$specter97087.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97087.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start,self__.end,next_fn);
});


com.rpl.specter.t_com$rpl$specter97087.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter97087.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta97088","meta97088",1389039520,null)], null);
});

com.rpl.specter.t_com$rpl$specter97087.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97087.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97087";

com.rpl.specter.t_com$rpl$specter97087.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97087");
});

com.rpl.specter.__GT_t_com$rpl$specter97087 = (function com$rpl$specter$__GT_t_com$rpl$specter97087(start__$1,end__$1,meta97088){
return (new com.rpl.specter.t_com$rpl$specter97087(start__$1,end__$1,meta97088));
});

}

return (new com.rpl.specter.t_com$rpl$specter97087(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__32276__auto__,p__97104){
var vec__97105 = p__97104;
var s = cljs.core.nth.call(null,vec__97105,(0),null);
var e = cljs.core.nth.call(null,vec__97105,(1),null);
var ret__32277__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj.call(null,(function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter97108 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97108 = (function (pred,meta97109){
this.pred = pred;
this.meta97109 = meta97109;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97108.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97110,meta97109__$1){
var self__ = this;
var _97110__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97108(self__.pred,meta97109__$1));
});


com.rpl.specter.t_com$rpl$specter97108.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97110){
var self__ = this;
var _97110__$1 = this;
return self__.meta97109;
});


com.rpl.specter.t_com$rpl$specter97108.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97108.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__34062__auto____$1){
return (function (curr__32276__auto__,p__97113){
var vec__97114 = p__97113;
var s = cljs.core.nth.call(null,vec__97114,(0),null);
var e = cljs.core.nth.call(null,vec__97114,(1),null);
var ret__32277__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
});})(next_fn,this__34062__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,self__.pred));
});


com.rpl.specter.t_com$rpl$specter97108.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter97108.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta97109","meta97109",1461626521,null)], null);
});

com.rpl.specter.t_com$rpl$specter97108.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97108.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97108";

com.rpl.specter.t_com$rpl$specter97108.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97108");
});

com.rpl.specter.__GT_t_com$rpl$specter97108 = (function com$rpl$specter$__GT_t_com$rpl$specter97108(pred__$1,meta97109){
return (new com.rpl.specter.t_com$rpl$specter97108(pred__$1,meta97109));
});

}

return (new com.rpl.specter.t_com$rpl$specter97108(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97117 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97117 = (function (meta97118){
this.meta97118 = meta97118;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97117.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97119,meta97118__$1){
var self__ = this;
var _97119__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97117(meta97118__$1));
});


com.rpl.specter.t_com$rpl$specter97117.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97119){
var self__ = this;
var _97119__$1 = this;
return self__.meta97118;
});


com.rpl.specter.t_com$rpl$specter97117.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97117.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});


com.rpl.specter.t_com$rpl$specter97117.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
}
});

com.rpl.specter.t_com$rpl$specter97117.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97118","meta97118",-1515951753,null)], null);
});

com.rpl.specter.t_com$rpl$specter97117.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97117.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97117";

com.rpl.specter.t_com$rpl$specter97117.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97117");
});

com.rpl.specter.__GT_t_com$rpl$specter97117 = (function com$rpl$specter$__GT_t_com$rpl$specter97117(meta97118){
return (new com.rpl.specter.t_com$rpl$specter97117(meta97118));
});

}

return (new com.rpl.specter.t_com$rpl$specter97117(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,""))].join('');
} else {
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97216 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97216 = (function (meta97217){
this.meta97217 = meta97217;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97216.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97218,meta97217__$1){
var self__ = this;
var _97218__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97216(meta97217__$1));
});


com.rpl.specter.t_com$rpl$specter97216.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97218){
var self__ = this;
var _97218__$1 = this;
return self__.meta97217;
});


com.rpl.specter.t_com$rpl$specter97216.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97216.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});


com.rpl.specter.t_com$rpl$specter97216.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,""))].join('');
} else {
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
}
});

com.rpl.specter.t_com$rpl$specter97216.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97217","meta97217",475547603,null)], null);
});

com.rpl.specter.t_com$rpl$specter97216.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97216.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97216";

com.rpl.specter.t_com$rpl$specter97216.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97216");
});

com.rpl.specter.__GT_t_com$rpl$specter97216 = (function com$rpl$specter$__GT_t_com$rpl$specter97216(meta97217){
return (new com.rpl.specter.t_com$rpl$specter97216(meta97217));
});

}

return (new com.rpl.specter.t_com$rpl$specter97216(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.call(null,structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97294 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97294 = (function (meta97295){
this.meta97295 = meta97295;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97294.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97296,meta97295__$1){
var self__ = this;
var _97296__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97294(meta97295__$1));
});


com.rpl.specter.t_com$rpl$specter97294.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97296){
var self__ = this;
var _97296__$1 = this;
return self__.meta97295;
});


com.rpl.specter.t_com$rpl$specter97294.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97294.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter97294.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.call(null,structure,newe);
}
}
});

com.rpl.specter.t_com$rpl$specter97294.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97295","meta97295",-569415054,null)], null);
});

com.rpl.specter.t_com$rpl$specter97294.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97294.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97294";

com.rpl.specter.t_com$rpl$specter97294.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97294");
});

com.rpl.specter.__GT_t_com$rpl$specter97294 = (function com$rpl$specter$__GT_t_com$rpl$specter97294(meta97295){
return (new com.rpl.specter.t_com$rpl$specter97294(meta97295));
});

}

return (new com.rpl.specter.t_com$rpl$specter97294(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one.call(null,structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97324 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97324 = (function (meta97325){
this.meta97325 = meta97325;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97324.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97326,meta97325__$1){
var self__ = this;
var _97326__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97324(meta97325__$1));
});


com.rpl.specter.t_com$rpl$specter97324.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97326){
var self__ = this;
var _97326__$1 = this;
return self__.meta97325;
});


com.rpl.specter.t_com$rpl$specter97324.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97324.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter97324.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one.call(null,structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter97324.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97325","meta97325",-827731150,null)], null);
});

com.rpl.specter.t_com$rpl$specter97324.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97324.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97324";

com.rpl.specter.t_com$rpl$specter97324.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97324");
});

com.rpl.specter.__GT_t_com$rpl$specter97324 = (function com$rpl$specter$__GT_t_com$rpl$specter97324(meta97325){
return (new com.rpl.specter.t_com$rpl$specter97324(meta97325));
});

}

return (new com.rpl.specter.t_com$rpl$specter97324(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one.call(null,structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97351 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97351 = (function (meta97352){
this.meta97352 = meta97352;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97351.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97353,meta97352__$1){
var self__ = this;
var _97353__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97351(meta97352__$1));
});


com.rpl.specter.t_com$rpl$specter97351.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97353){
var self__ = this;
var _97353__$1 = this;
return self__.meta97352;
});


com.rpl.specter.t_com$rpl$specter97351.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97351.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter97351.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one.call(null,structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter97351.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97352","meta97352",566819371,null)], null);
});

com.rpl.specter.t_com$rpl$specter97351.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97351.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97351";

com.rpl.specter.t_com$rpl$specter97351.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97351");
});

com.rpl.specter.__GT_t_com$rpl$specter97351 = (function com$rpl$specter$__GT_t_com$rpl$specter97351(meta97352){
return (new com.rpl.specter.t_com$rpl$specter97351(meta97352));
});

}

return (new com.rpl.specter.t_com$rpl$specter97351(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
return next_fn.call(null,clojure.set.intersection.call(null,structure,aset));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.call(null,structure,aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj.call(null,(function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter97361 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97361 = (function (aset,meta97362){
this.aset = aset;
this.meta97362 = meta97362;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97361.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97363,meta97362__$1){
var self__ = this;
var _97363__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97361(self__.aset,meta97362__$1));
});


com.rpl.specter.t_com$rpl$specter97361.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97363){
var self__ = this;
var _97363__$1 = this;
return self__.meta97362;
});


com.rpl.specter.t_com$rpl$specter97361.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97361.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,clojure.set.intersection.call(null,structure,self__.aset));
});


com.rpl.specter.t_com$rpl$specter97361.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var subset = clojure.set.intersection.call(null,structure,self__.aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter97361.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta97362","meta97362",94372252,null)], null);
});

com.rpl.specter.t_com$rpl$specter97361.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97361.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97361";

com.rpl.specter.t_com$rpl$specter97361.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97361");
});

com.rpl.specter.__GT_t_com$rpl$specter97361 = (function com$rpl$specter$__GT_t_com$rpl$specter97361(aset__$1,meta97362){
return (new com.rpl.specter.t_com$rpl$specter97361(aset__$1,meta97362));
});

}

return (new com.rpl.specter.t_com$rpl$specter97361(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
return next_fn.call(null,cljs.core.select_keys.call(null,structure,m_keys));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys.call(null,structure,m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,m_keys),newmap);
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj.call(null,(function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter97373 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97373 = (function (m_keys,meta97374){
this.m_keys = m_keys;
this.meta97374 = meta97374;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97373.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97375,meta97374__$1){
var self__ = this;
var _97375__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97373(self__.m_keys,meta97374__$1));
});


com.rpl.specter.t_com$rpl$specter97373.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97375){
var self__ = this;
var _97375__$1 = this;
return self__.meta97374;
});


com.rpl.specter.t_com$rpl$specter97373.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97373.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.select_keys.call(null,structure,self__.m_keys));
});


com.rpl.specter.t_com$rpl$specter97373.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var submap = cljs.core.select_keys.call(null,structure,self__.m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,self__.m_keys),newmap);
});

com.rpl.specter.t_com$rpl$specter97373.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta97374","meta97374",-1681700594,null)], null);
});

com.rpl.specter.t_com$rpl$specter97373.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97373.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97373";

com.rpl.specter.t_com$rpl$specter97373.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97373");
});

com.rpl.specter.__GT_t_com$rpl$specter97373 = (function com$rpl$specter$__GT_t_com$rpl$specter97373(m_keys__$1,meta97374){
return (new com.rpl.specter.t_com$rpl$specter97373(m_keys__$1,meta97374));
});

}

return (new com.rpl.specter.t_com$rpl$specter97373(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97395__delegate = function (path){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter97385 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97385 = (function (path,late,meta97386){
this.path = path;
this.late = late;
this.meta97386 = meta97386;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97385.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97387,meta97386__$1){
var self__ = this;
var _97387__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97385(self__.path,self__.late,meta97386__$1));
});


com.rpl.specter.t_com$rpl$specter97385.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97387){
var self__ = this;
var _97387__$1 = this;
return self__.meta97386;
});


com.rpl.specter.t_com$rpl$specter97385.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97385.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_select.call(null,self__.late,structure));
});


com.rpl.specter.t_com$rpl$specter97385.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var select_result = com.rpl.specter.compiled_select.call(null,self__.late,structure);
var transformed = next_fn.call(null,select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.call(null,transformed);
return com.rpl.specter.compiled_transform.call(null,self__.late,((function (select_result,transformed,values_to_insert,next_fn,this__34062__auto____$1){
return (function (_){
var vs = com.rpl.specter.impl.get_cell.call(null,values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_.call(null,values_to_insert,cljs.core.next);

return cljs.core.first.call(null,vs);
} else {
return com.rpl.specter.NONE;
}
});})(select_result,transformed,values_to_insert,next_fn,this__34062__auto____$1))
,structure);
});

com.rpl.specter.t_com$rpl$specter97385.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta97386","meta97386",782047675,null)], null);
});

com.rpl.specter.t_com$rpl$specter97385.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97385.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97385";

com.rpl.specter.t_com$rpl$specter97385.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97385");
});

com.rpl.specter.__GT_t_com$rpl$specter97385 = (function com$rpl$specter$__GT_t_com$rpl$specter97385(path__$1,late__$1,meta97386){
return (new com.rpl.specter.t_com$rpl$specter97385(path__$1,late__$1,meta97386));
});

}

return (new com.rpl.specter.t_com$rpl$specter97385(path,late,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
};
var G__97395 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97403__i = 0, G__97403__a = new Array(arguments.length -  0);
while (G__97403__i < G__97403__a.length) {G__97403__a[G__97403__i] = arguments[G__97403__i + 0]; ++G__97403__i;}
  path = new cljs.core.IndexedSeq(G__97403__a,0,null);
} 
return G__97395__delegate.call(this,path);};
G__97395.cljs$lang$maxFixedArity = 0;
G__97395.cljs$lang$applyTo = (function (arglist__97404){
var path = cljs.core.seq(arglist__97404);
return G__97395__delegate(path);
});
G__97395.cljs$core$IFn$_invoke$arity$variadic = G__97395__delegate;
return G__97395;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj.call(null,(function (key){
if(typeof com.rpl.specter.t_com$rpl$specter97406 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97406 = (function (key,meta97407){
this.key = key;
this.meta97407 = meta97407;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97406.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97408,meta97407__$1){
var self__ = this;
var _97408__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97406(self__.key,meta97407__$1));
});


com.rpl.specter.t_com$rpl$specter97406.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97408){
var self__ = this;
var _97408__$1 = this;
return self__.meta97407;
});


com.rpl.specter.t_com$rpl$specter97406.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97406.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.key)){
return next_fn.call(null,vals,self__.key);
} else {
return com.rpl.specter.NONE;
}
});


com.rpl.specter.t_com$rpl$specter97406.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.key)){
var newkey = next_fn.call(null,vals,self__.key);
var dissoced = cljs.core.dissoc.call(null,structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.call(null,dissoced,newkey,cljs.core.get.call(null,structure,self__.key));
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter97406.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta97407","meta97407",-1805817124,null)], null);
});

com.rpl.specter.t_com$rpl$specter97406.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97406.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97406";

com.rpl.specter.t_com$rpl$specter97406.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97406");
});

com.rpl.specter.__GT_t_com$rpl$specter97406 = (function com$rpl$specter$__GT_t_com$rpl$specter97406(key__$1,meta97407){
return (new com.rpl.specter.t_com$rpl$specter97406(key__$1,meta97407));
});

}

return (new com.rpl.specter.t_com$rpl$specter97406(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj.call(null,(function (elem){
if(typeof com.rpl.specter.t_com$rpl$specter97422 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97422 = (function (elem,meta97423){
this.elem = elem;
this.meta97423 = meta97423;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97422.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97424,meta97423__$1){
var self__ = this;
var _97424__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97422(self__.elem,meta97423__$1));
});


com.rpl.specter.t_com$rpl$specter97422.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97424){
var self__ = this;
var _97424__$1 = this;
return self__.meta97423;
});


com.rpl.specter.t_com$rpl$specter97422.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97422.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.elem)){
return next_fn.call(null,vals,self__.elem);
} else {
return com.rpl.specter.NONE;
}
});


com.rpl.specter.t_com$rpl$specter97422.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.elem)){
var newelem = next_fn.call(null,vals,self__.elem);
var removed = cljs.core.disj.call(null,structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.call(null,removed,newelem);
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter97422.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta97423","meta97423",-1087887057,null)], null);
});

com.rpl.specter.t_com$rpl$specter97422.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97422.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97422";

com.rpl.specter.t_com$rpl$specter97422.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97422");
});

com.rpl.specter.__GT_t_com$rpl$specter97422 = (function com$rpl$specter$__GT_t_com$rpl$specter97422(elem__$1,meta97423){
return (new com.rpl.specter.t_com$rpl$specter97422(elem__$1,meta97423));
});

}

return (new com.rpl.specter.t_com$rpl$specter97422(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_);
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_);
/**
 * Navigate to the specified indices one after another.If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_);
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter97432 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97432 = (function (afn,meta97433){
this.afn = afn;
this.meta97433 = meta97433;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97434,meta97433__$1){
var self__ = this;
var _97434__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97432(self__.afn,meta97433__$1));
});


com.rpl.specter.t_com$rpl$specter97432.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97434){
var self__ = this;
var _97434__$1 = this;
return self__.meta97433;
});


com.rpl.specter.t_com$rpl$specter97432.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97432.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter97432.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter97432.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta97433","meta97433",-1552184842,null)], null);
});

com.rpl.specter.t_com$rpl$specter97432.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97432.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97432";

com.rpl.specter.t_com$rpl$specter97432.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97432");
});

com.rpl.specter.__GT_t_com$rpl$specter97432 = (function com$rpl$specter$__GT_t_com$rpl$specter97432(afn__$1,meta97433){
return (new com.rpl.specter.t_com$rpl$specter97432(afn__$1,meta97433));
});

}

return (new com.rpl.specter.t_com$rpl$specter97432(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
return next_fn.call(null,parse_fn.call(null,structure));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
return unparse_fn.call(null,next_fn.call(null,parse_fn.call(null,structure)));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj.call(null,(function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter97435 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97435 = (function (parse_fn,unparse_fn,meta97436){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta97436 = meta97436;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97435.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97437,meta97436__$1){
var self__ = this;
var _97437__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97435(self__.parse_fn,self__.unparse_fn,meta97436__$1));
});


com.rpl.specter.t_com$rpl$specter97435.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97437){
var self__ = this;
var _97437__$1 = this;
return self__.meta97436;
});


com.rpl.specter.t_com$rpl$specter97435.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97435.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,self__.parse_fn.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter97435.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return self__.unparse_fn.call(null,next_fn.call(null,self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter97435.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta97436","meta97436",-107798708,null)], null);
});

com.rpl.specter.t_com$rpl$specter97435.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97435.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97435";

com.rpl.specter.t_com$rpl$specter97435.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97435");
});

com.rpl.specter.__GT_t_com$rpl$specter97435 = (function com$rpl$specter$__GT_t_com$rpl$specter97435(parse_fn__$1,unparse_fn__$1,meta97436){
return (new com.rpl.specter.t_com$rpl$specter97435(parse_fn__$1,unparse_fn__$1,meta97436));
});

}

return (new com.rpl.specter.t_com$rpl$specter97435(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97445 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97445 = (function (meta97446){
this.meta97446 = meta97446;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97445.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97447,meta97446__$1){
var self__ = this;
var _97447__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97445(meta97446__$1));
});


com.rpl.specter.t_com$rpl$specter97445.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97447){
var self__ = this;
var _97447__$1 = this;
return self__.meta97446;
});


com.rpl.specter.t_com$rpl$specter97445.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97445.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.deref.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter97445.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter97445.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97446","meta97446",172736912,null)], null);
});

com.rpl.specter.t_com$rpl$specter97445.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97445.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97445";

com.rpl.specter.t_com$rpl$specter97445.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97445");
});

com.rpl.specter.__GT_t_com$rpl$specter97445 = (function com$rpl$specter$__GT_t_com$rpl$specter97445(meta97446){
return (new com.rpl.specter.t_com$rpl$specter97445(meta97446));
});

}

return (new com.rpl.specter.t_com$rpl$specter97445(null));
})()
;
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97465__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return afn;
} else {
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter97459 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97459 = (function (path,temp__4655__auto__,late,meta97460){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta97460 = meta97460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_97461,meta97460__$1){
var self__ = this;
var _97461__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97459(self__.path,self__.temp__4655__auto__,self__.late,meta97460__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97459.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_97461){
var self__ = this;
var _97461__$1 = this;
return self__.meta97460;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97459.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97459.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__97457_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,vals,p1__97457_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97459.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__97458_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,vals,p1__97458_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter97459.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta97460","meta97460",-761919564,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter97459.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97459.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97459";

com.rpl.specter.t_com$rpl$specter97459.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97459");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter97459 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter97459(path__$1,temp__4655__auto____$1,late__$1,meta97460){
return (new com.rpl.specter.t_com$rpl$specter97459(path__$1,temp__4655__auto____$1,late__$1,meta97460));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter97459(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
}
};
var G__97465 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97567__i = 0, G__97567__a = new Array(arguments.length -  0);
while (G__97567__i < G__97567__a.length) {G__97567__a[G__97567__i] = arguments[G__97567__i + 0]; ++G__97567__i;}
  path = new cljs.core.IndexedSeq(G__97567__a,0,null);
} 
return G__97465__delegate.call(this,path);};
G__97465.cljs$lang$maxFixedArity = 0;
G__97465.cljs$lang$applyTo = (function (arglist__97569){
var path = cljs.core.seq(arglist__97569);
return G__97465__delegate(path);
});
G__97465.cljs$core$IFn$_invoke$arity$variadic = G__97465__delegate;
return G__97465;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97592__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return ((function (afn,temp__4655__auto__){
return (function (s){
return cljs.core.not.call(null,afn.call(null,s));
});
;})(afn,temp__4655__auto__))
} else {
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter97575 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97575 = (function (path,temp__4655__auto__,late,meta97576){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta97576 = meta97576;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97575.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_97577,meta97576__$1){
var self__ = this;
var _97577__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97575(self__.path,self__.temp__4655__auto__,self__.late,meta97576__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97575.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_97577){
var self__ = this;
var _97577__$1 = this;
return self__.meta97576;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97575.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97575.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__97571_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,vals,p1__97571_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97575.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__97572_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,vals,p1__97572_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter97575.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta97576","meta97576",-438523754,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter97575.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97575.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97575";

com.rpl.specter.t_com$rpl$specter97575.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97575");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter97575 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter97575(path__$1,temp__4655__auto____$1,late__$1,meta97576){
return (new com.rpl.specter.t_com$rpl$specter97575(path__$1,temp__4655__auto____$1,late__$1,meta97576));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter97575(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
}
};
var G__97592 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97616__i = 0, G__97616__a = new Array(arguments.length -  0);
while (G__97616__i < G__97616__a.length) {G__97616__a[G__97616__i] = arguments[G__97616__i + 0]; ++G__97616__i;}
  path = new cljs.core.IndexedSeq(G__97616__a,0,null);
} 
return G__97592__delegate.call(this,path);};
G__97592.cljs$lang$maxFixedArity = 0;
G__97592.cljs$lang$applyTo = (function (arglist__97618){
var path = cljs.core.seq(arglist__97618);
return G__97592__delegate(path);
});
G__97592.cljs$core$IFn$_invoke$arity$variadic = G__97592__delegate;
return G__97592;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97623__delegate = function (path){
return com.rpl.specter.subselect.call(null,com.rpl.specter.ALL,com.rpl.specter.selected_QMARK_.call(null,path));
};
var G__97623 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97625__i = 0, G__97625__a = new Array(arguments.length -  0);
while (G__97625__i < G__97625__a.length) {G__97625__a[G__97625__i] = arguments[G__97625__i + 0]; ++G__97625__i;}
  path = new cljs.core.IndexedSeq(G__97625__a,0,null);
} 
return G__97623__delegate.call(this,path);};
G__97623.cljs$lang$maxFixedArity = 0;
G__97623.cljs$lang$applyTo = (function (arglist__97627){
var path = cljs.core.seq(arglist__97627);
return G__97623__delegate(path);
});
G__97623.cljs$core$IFn$_invoke$arity$variadic = G__97623__delegate;
return G__97623;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (path,update_fn){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter97630 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97630 = (function (path,update_fn,late,late_fn,meta97631){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta97631 = meta97631;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97630.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97632,meta97631__$1){
var self__ = this;
var _97632__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97630(self__.path,self__.update_fn,self__.late,self__.late_fn,meta97631__$1));
});


com.rpl.specter.t_com$rpl$specter97630.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97632){
var self__ = this;
var _97632__$1 = this;
return self__.meta97631;
});


com.rpl.specter.t_com$rpl$specter97630.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97630.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});


com.rpl.specter.t_com$rpl$specter97630.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter97630.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta97631","meta97631",-1176363655,null)], null);
});

com.rpl.specter.t_com$rpl$specter97630.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97630.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97630";

com.rpl.specter.t_com$rpl$specter97630.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97630");
});

com.rpl.specter.__GT_t_com$rpl$specter97630 = (function com$rpl$specter$__GT_t_com$rpl$specter97630(path__$1,update_fn__$1,late__$1,late_fn__$1,meta97631){
return (new com.rpl.specter.t_com$rpl$specter97630(path__$1,update_fn__$1,late__$1,late_fn__$1,meta97631));
});

}

return (new com.rpl.specter.t_com$rpl$specter97630(path,update_fn,late,late_fn,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),update_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (path,reduce_fn){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter97643 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97643 = (function (path,reduce_fn,late,late_fn,meta97644){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta97644 = meta97644;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97643.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97645,meta97644__$1){
var self__ = this;
var _97645__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97643(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta97644__$1));
});


com.rpl.specter.t_com$rpl$specter97643.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97645){
var self__ = this;
var _97645__$1 = this;
return self__.meta97644;
});


com.rpl.specter.t_com$rpl$specter97643.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97643.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});


com.rpl.specter.t_com$rpl$specter97643.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter97643.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta97644","meta97644",-465937487,null)], null);
});

com.rpl.specter.t_com$rpl$specter97643.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97643.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97643";

com.rpl.specter.t_com$rpl$specter97643.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97643");
});

com.rpl.specter.__GT_t_com$rpl$specter97643 = (function com$rpl$specter$__GT_t_com$rpl$specter97643(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta97644){
return (new com.rpl.specter.t_com$rpl$specter97643(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta97644));
});

}

return (new com.rpl.specter.t_com$rpl$specter97643(path,reduce_fn,late,late_fn,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),reduce_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. This is the
 *        late-bound parameterized version of using a function directly in a path.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__97647_SHARP_){
return cljs.core._EQ_.call(null,p1__97647_SHARP_,v);
}));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
return com.rpl.specter.pred.call(null,(function (p1__97648_SHARP_){
return (p1__97648_SHARP_ < v);
}));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
return com.rpl.specter.pred.call(null,(function (p1__97651_SHARP_){
return (p1__97651_SHARP_ > v);
}));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__97653_SHARP_){
return (p1__97653_SHARP_ <= v);
}));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__97654_SHARP_){
return (p1__97654_SHARP_ >= v);
}));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1);
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return com.rpl.specter.pred.call(null,this$);
}));

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.pred.call(null,this$__$1);
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj.call(null,(function (v){
if(typeof com.rpl.specter.t_com$rpl$specter97663 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97663 = (function (v,meta97664){
this.v = v;
this.meta97664 = meta97664;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97663.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97665,meta97664__$1){
var self__ = this;
var _97665__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97663(self__.v,meta97664__$1));
});


com.rpl.specter.t_com$rpl$specter97663.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97665){
var self__ = this;
var _97665__$1 = this;
return self__.meta97664;
});


com.rpl.specter.t_com$rpl$specter97663.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97663.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});


com.rpl.specter.t_com$rpl$specter97663.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter97663.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta97664","meta97664",-679922034,null)], null);
});

com.rpl.specter.t_com$rpl$specter97663.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97663.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97663";

com.rpl.specter.t_com$rpl$specter97663.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97663");
});

com.rpl.specter.__GT_t_com$rpl$specter97663 = (function com$rpl$specter$__GT_t_com$rpl$specter97663(v__$1,meta97664){
return (new com.rpl.specter.t_com$rpl$specter97663(v__$1,meta97664));
});

}

return (new com.rpl.specter.t_com$rpl$specter97663(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentHashSet.EMPTY);
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = com.rpl.specter.nil__GT_val.call(null,cljs.core.List.EMPTY);
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentVector.EMPTY);


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97678 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97678 = (function (meta97679){
this.meta97679 = meta97679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97680,meta97679__$1){
var self__ = this;
var _97680__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97678(meta97679__$1));
});


com.rpl.specter.t_com$rpl$specter97678.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97680){
var self__ = this;
var _97680__$1 = this;
return self__.meta97679;
});


com.rpl.specter.t_com$rpl$specter97678.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97678.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.meta.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter97678.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter97678.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97679","meta97679",579063785,null)], null);
});

com.rpl.specter.t_com$rpl$specter97678.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97678.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97678";

com.rpl.specter.t_com$rpl$specter97678.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97678");
});

com.rpl.specter.__GT_t_com$rpl$specter97678 = (function com$rpl$specter$__GT_t_com$rpl$specter97678(meta97679){
return (new com.rpl.specter.t_com$rpl$specter97678(meta97679));
});

}

return (new com.rpl.specter.t_com$rpl$specter97678(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.name.call(null,structure));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = next_fn.call(null,cljs.core.name.call(null,structure));
var ns = cljs.core.namespace.call(null,structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAME can only be used on symbols or keywords - ",structure)));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97697 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97697 = (function (meta97698){
this.meta97698 = meta97698;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97697.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97699,meta97698__$1){
var self__ = this;
var _97699__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97697(meta97698__$1));
});


com.rpl.specter.t_com$rpl$specter97697.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97699){
var self__ = this;
var _97699__$1 = this;
return self__.meta97698;
});


com.rpl.specter.t_com$rpl$specter97697.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97697.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.name.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter97697.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var new_name = next_fn.call(null,cljs.core.name.call(null,structure));
var ns = cljs.core.namespace.call(null,structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAME can only be used on symbols or keywords - ",structure)));

}
}
});

com.rpl.specter.t_com$rpl$specter97697.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97698","meta97698",-767977799,null)], null);
});

com.rpl.specter.t_com$rpl$specter97697.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97697.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97697";

com.rpl.specter.t_com$rpl$specter97697.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97697");
});

com.rpl.specter.__GT_t_com$rpl$specter97697 = (function com$rpl$specter$__GT_t_com$rpl$specter97697(meta97698){
return (new com.rpl.specter.t_com$rpl$specter97697(meta97698));
});

}

return (new com.rpl.specter.t_com$rpl$specter97697(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.namespace.call(null,structure));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name.call(null,structure);
var new_ns = next_fn.call(null,cljs.core.namespace.call(null,structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAMESPACE can only be used on symbols or keywords - ",structure)));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97709 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97709 = (function (meta97710){
this.meta97710 = meta97710;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97709.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97711,meta97710__$1){
var self__ = this;
var _97711__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97709(meta97710__$1));
});


com.rpl.specter.t_com$rpl$specter97709.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97711){
var self__ = this;
var _97711__$1 = this;
return self__.meta97710;
});


com.rpl.specter.t_com$rpl$specter97709.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97709.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.namespace.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter97709.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var name = cljs.core.name.call(null,structure);
var new_ns = next_fn.call(null,cljs.core.namespace.call(null,structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAMESPACE can only be used on symbols or keywords - ",structure)));

}
}
});

com.rpl.specter.t_com$rpl$specter97709.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97710","meta97710",411301089,null)], null);
});

com.rpl.specter.t_com$rpl$specter97709.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97709.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97709";

com.rpl.specter.t_com$rpl$specter97709.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97709");
});

com.rpl.specter.__GT_t_com$rpl$specter97709 = (function com$rpl$specter$__GT_t_com$rpl$specter97709(meta97710){
return (new com.rpl.specter.t_com$rpl$specter97709(meta97710));
});

}

return (new com.rpl.specter.t_com$rpl$specter97709(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97718__delegate = function (path){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter97714 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97714 = (function (path,late,meta97715){
this.path = path;
this.late = late;
this.meta97715 = meta97715;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97714.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97716,meta97715__$1){
var self__ = this;
var _97716__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97714(self__.path,self__.late,meta97715__$1));
});


com.rpl.specter.t_com$rpl$specter97714.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97716){
var self__ = this;
var _97716__$1 = this;
return self__.meta97715;
});


com.rpl.specter.t_com$rpl$specter97714.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97714.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});


com.rpl.specter.t_com$rpl$specter97714.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter97714.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta97715","meta97715",-2052244507,null)], null);
});

com.rpl.specter.t_com$rpl$specter97714.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97714.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97714";

com.rpl.specter.t_com$rpl$specter97714.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97714");
});

com.rpl.specter.__GT_t_com$rpl$specter97714 = (function com$rpl$specter$__GT_t_com$rpl$specter97714(path__$1,late__$1,meta97715){
return (new com.rpl.specter.t_com$rpl$specter97714(path__$1,late__$1,meta97715));
});

}

return (new com.rpl.specter.t_com$rpl$specter97714(path,late,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
};
var G__97718 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97725__i = 0, G__97725__a = new Array(arguments.length -  0);
while (G__97725__i < G__97725__a.length) {G__97725__a[G__97725__i] = arguments[G__97725__i + 0]; ++G__97725__i;}
  path = new cljs.core.IndexedSeq(G__97725__a,0,null);
} 
return G__97718__delegate.call(this,path);};
G__97718.cljs$lang$maxFixedArity = 0;
G__97718.cljs$lang$applyTo = (function (arglist__97726){
var path = cljs.core.seq(arglist__97726);
return G__97718__delegate(path);
});
G__97718.cljs$core$IFn$_invoke$arity$variadic = G__97718__delegate;
return G__97718;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97803__delegate = function (path){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter97727 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97727 = (function (path,late,meta97728){
this.path = path;
this.late = late;
this.meta97728 = meta97728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97729,meta97728__$1){
var self__ = this;
var _97729__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97727(self__.path,self__.late,meta97728__$1));
});


com.rpl.specter.t_com$rpl$specter97727.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97729){
var self__ = this;
var _97729__$1 = this;
return self__.meta97728;
});


com.rpl.specter.t_com$rpl$specter97727.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97727.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});


com.rpl.specter.t_com$rpl$specter97727.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter97727.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta97728","meta97728",-747625923,null)], null);
});

com.rpl.specter.t_com$rpl$specter97727.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97727.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97727";

com.rpl.specter.t_com$rpl$specter97727.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97727");
});

com.rpl.specter.__GT_t_com$rpl$specter97727 = (function com$rpl$specter$__GT_t_com$rpl$specter97727(path__$1,late__$1,meta97728){
return (new com.rpl.specter.t_com$rpl$specter97727(path__$1,late__$1,meta97728));
});

}

return (new com.rpl.specter.t_com$rpl$specter97727(path,late,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
};
var G__97803 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97819__i = 0, G__97819__a = new Array(arguments.length -  0);
while (G__97819__i < G__97819__a.length) {G__97819__a[G__97819__i] = arguments[G__97819__i + 0]; ++G__97819__i;}
  path = new cljs.core.IndexedSeq(G__97819__a,0,null);
} 
return G__97803__delegate.call(this,path);};
G__97803.cljs$lang$maxFixedArity = 0;
G__97803.cljs$lang$applyTo = (function (arglist__97822){
var path = cljs.core.seq(arglist__97822);
return G__97803__delegate(path);
});
G__97803.cljs$core$IFn$_invoke$arity$variadic = G__97803__delegate;
return G__97803;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj.call(null,(function (val){
if(typeof com.rpl.specter.t_com$rpl$specter97824 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97824 = (function (val,meta97825){
this.val = val;
this.meta97825 = meta97825;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97824.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97826,meta97825__$1){
var self__ = this;
var _97826__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97824(self__.val,meta97825__$1));
});


com.rpl.specter.t_com$rpl$specter97824.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97826){
var self__ = this;
var _97826__$1 = this;
return self__.meta97825;
});


com.rpl.specter.t_com$rpl$specter97824.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97824.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,self__.val),structure);
});


com.rpl.specter.t_com$rpl$specter97824.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter97824.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta97825","meta97825",1405203876,null)], null);
});

com.rpl.specter.t_com$rpl$specter97824.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97824.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97824";

com.rpl.specter.t_com$rpl$specter97824.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97824");
});

com.rpl.specter.__GT_t_com$rpl$specter97824 = (function com$rpl$specter$__GT_t_com$rpl$specter97824(val__$1,meta97825){
return (new com.rpl.specter.t_com$rpl$specter97824(val__$1,meta97825));
});

}

return (new com.rpl.specter.t_com$rpl$specter97824(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97858__delegate = function (path){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter97848 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97848 = (function (path,late,meta97849){
this.path = path;
this.late = late;
this.meta97849 = meta97849;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97848.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97850,meta97849__$1){
var self__ = this;
var _97850__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97848(self__.path,self__.late,meta97849__$1));
});


com.rpl.specter.t_com$rpl$specter97848.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97850){
var self__ = this;
var _97850__$1 = this;
return self__.meta97849;
});


com.rpl.specter.t_com$rpl$specter97848.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97848.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_.call(null,self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return next_fn.call(null,vals,structure__$1);
});})(this$__$1))
);
});


com.rpl.specter.t_com$rpl$specter97848.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return next_fn.call(null,vals,structure__$1);
});})(this$__$1))
);
});

com.rpl.specter.t_com$rpl$specter97848.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta97849","meta97849",560919828,null)], null);
});

com.rpl.specter.t_com$rpl$specter97848.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97848.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97848";

com.rpl.specter.t_com$rpl$specter97848.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97848");
});

com.rpl.specter.__GT_t_com$rpl$specter97848 = (function com$rpl$specter$__GT_t_com$rpl$specter97848(path__$1,late__$1,meta97849){
return (new com.rpl.specter.t_com$rpl$specter97848(path__$1,late__$1,meta97849));
});

}

return (new com.rpl.specter.t_com$rpl$specter97848(path,late,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
};
var G__97858 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97859__i = 0, G__97859__a = new Array(arguments.length -  0);
while (G__97859__i < G__97859__a.length) {G__97859__a[G__97859__i] = arguments[G__97859__i + 0]; ++G__97859__i;}
  path = new cljs.core.IndexedSeq(G__97859__a,0,null);
} 
return G__97858__delegate.call(this,path);};
G__97858.cljs$lang$maxFixedArity = 0;
G__97858.cljs$lang$applyTo = (function (arglist__97860){
var path = cljs.core.seq(arglist__97860);
return G__97858__delegate(path);
});
G__97858.cljs$core$IFn$_invoke$arity$variadic = G__97858__delegate;
return G__97858;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter97861 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97861 = (function (meta97862){
this.meta97862 = meta97862;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97861.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97863,meta97862__$1){
var self__ = this;
var _97863__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97861(meta97862__$1));
});


com.rpl.specter.t_com$rpl$specter97861.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97863){
var self__ = this;
var _97863__$1 = this;
return self__.meta97862;
});


com.rpl.specter.t_com$rpl$specter97861.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97861.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});


com.rpl.specter.t_com$rpl$specter97861.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter97861.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta97862","meta97862",-1716966196,null)], null);
});

com.rpl.specter.t_com$rpl$specter97861.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97861.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97861";

com.rpl.specter.t_com$rpl$specter97861.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97861");
});

com.rpl.specter.__GT_t_com$rpl$specter97861 = (function com$rpl$specter$__GT_t_com$rpl$specter97861(meta97862){
return (new com.rpl.specter.t_com$rpl$specter97861(meta97862));
});

}

return (new com.rpl.specter.t_com$rpl$specter97861(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() {
var G__97888 = null;
var G__97888__2 = (function (cond_p,then_path){
return com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP);
});
var G__97888__3 = (function (cond_p,then_path,else_path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,cond_p);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (afn,temp__4655__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter97871 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97871 = (function (cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,meta97872){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta97872 = meta97872;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97871.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__4655__auto__){
return (function (_97873,meta97872__$1){
var self__ = this;
var _97873__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97871(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.afn,self__.late_then,self__.late_else,meta97872__$1));
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97871.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__4655__auto__){
return (function (_97873){
var self__ = this;
var _97873__$1 = this;
return self__.meta97872;
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97871.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97871.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97871.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter97871.getBasis = ((function (afn,temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta97872","meta97872",-658140317,null)], null);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter97871.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97871.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97871";

com.rpl.specter.t_com$rpl$specter97871.cljs$lang$ctorPrWriter = ((function (afn,temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97871");
});})(afn,temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter97871 = ((function (afn,temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter97871(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta97872){
return (new com.rpl.specter.t_com$rpl$specter97871(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta97872));
});})(afn,temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter97871(cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,null));
});})(afn,temp__4655__auto__))
);
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
} else {
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter97880 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97880 = (function (cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,meta97881){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta97881 = meta97881;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97880.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_97882,meta97881__$1){
var self__ = this;
var _97882__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97880(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.late_cond,self__.late_then,self__.late_else,meta97881__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97880.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_97882){
var self__ = this;
var _97882__$1 = this;
return self__.meta97881;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97880.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97880.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__97869_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,vals,p1__97869_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter97880.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__97870_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,vals,p1__97870_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter97880.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta97881","meta97881",-1148100067,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter97880.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97880.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97880";

com.rpl.specter.t_com$rpl$specter97880.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97880");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter97880 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter97880(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta97881){
return (new com.rpl.specter.t_com$rpl$specter97880(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta97881));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter97880(cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,null));
});})(temp__4655__auto__))
);
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,cond_p),com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
}
});
G__97888 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__97888__2.call(this,cond_p,then_path);
case 3:
return G__97888__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__97888.cljs$core$IFn$_invoke$arity$2 = G__97888__2;
G__97888.cljs$core$IFn$_invoke$arity$3 = G__97888__3;
return G__97888;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 * 
 * The input paths may be parameterized, in which case the result of cond-path
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97907__delegate = function (conds){
var pairs = cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),conds));
return cljs.core.reduce.call(null,((function (pairs){
return (function (p,p__97902){
var vec__97903 = p__97902;
var tester = cljs.core.nth.call(null,vec__97903,(0),null);
var apath = cljs.core.nth.call(null,vec__97903,(1),null);
return com.rpl.specter.if_path.call(null,tester,apath,p);
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__97907 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__97909__i = 0, G__97909__a = new Array(arguments.length -  0);
while (G__97909__i < G__97909__a.length) {G__97909__a[G__97909__i] = arguments[G__97909__i + 0]; ++G__97909__i;}
  conds = new cljs.core.IndexedSeq(G__97909__a,0,null);
} 
return G__97907__delegate.call(this,conds);};
G__97907.cljs$lang$maxFixedArity = 0;
G__97907.cljs$lang$applyTo = (function (arglist__97911){
var conds = cljs.core.seq(arglist__97911);
return G__97907__delegate(conds);
});
G__97907.cljs$core$IFn$_invoke$arity$variadic = G__97907__delegate;
return G__97907;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() {
var G__97923 = null;
var G__97923__0 = (function (){
return com.rpl.specter.STAY;
});
var G__97923__1 = (function (path){
return path;
});
var G__97923__2 = (function (path1,path2){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter97913 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter97913 = (function (path1,path2,late1,late2,meta97914){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta97914 = meta97914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter97913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_97915,meta97914__$1){
var self__ = this;
var _97915__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter97913(self__.path1,self__.path2,self__.late1,self__.late2,meta97914__$1));
});


com.rpl.specter.t_com$rpl$specter97913.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_97915){
var self__ = this;
var _97915__$1 = this;
return self__.meta97914;
});


com.rpl.specter.t_com$rpl$specter97913.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter97913.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_.call(null,res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
});


com.rpl.specter.t_com$rpl$specter97913.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_.call(null,self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late2,vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter97913.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta97914","meta97914",1901909328,null)], null);
});

com.rpl.specter.t_com$rpl$specter97913.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter97913.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter97913";

com.rpl.specter.t_com$rpl$specter97913.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter97913");
});

com.rpl.specter.__GT_t_com$rpl$specter97913 = (function com$rpl$specter$__GT_t_com$rpl$specter97913(path1__$1,path2__$1,late1__$1,late2__$1,meta97914){
return (new com.rpl.specter.t_com$rpl$specter97913(path1__$1,path2__$1,late1__$1,late2__$1,meta97914));
});

}

return (new com.rpl.specter.t_com$rpl$specter97913(path1,path2,late1,late2,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path1),com.rpl.specter.late_path.call(null,path2)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
});
var G__97923__3 = (function() { 
var G__97967__delegate = function (path1,path2,paths){
return cljs.core.reduce.call(null,com.rpl.specter.multi_path,com.rpl.specter.multi_path.call(null,path1,path2),paths);
};
var G__97967 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__97968__i = 0, G__97968__a = new Array(arguments.length -  2);
while (G__97968__i < G__97968__a.length) {G__97968__a[G__97968__i] = arguments[G__97968__i + 2]; ++G__97968__i;}
  paths = new cljs.core.IndexedSeq(G__97968__a,0,null);
} 
return G__97967__delegate.call(this,path1,path2,paths);};
G__97967.cljs$lang$maxFixedArity = 2;
G__97967.cljs$lang$applyTo = (function (arglist__97970){
var path1 = cljs.core.first(arglist__97970);
arglist__97970 = cljs.core.next(arglist__97970);
var path2 = cljs.core.first(arglist__97970);
var paths = cljs.core.rest(arglist__97970);
return G__97967__delegate(path1,path2,paths);
});
G__97967.cljs$core$IFn$_invoke$arity$variadic = G__97967__delegate;
return G__97967;
})()
;
G__97923 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__97923__0.call(this);
case 1:
return G__97923__1.call(this,path1);
case 2:
return G__97923__2.call(this,path1,path2);
default:
var G__97974 = null;
if (arguments.length > 2) {
var G__97975__i = 0, G__97975__a = new Array(arguments.length -  2);
while (G__97975__i < G__97975__a.length) {G__97975__a[G__97975__i] = arguments[G__97975__i + 2]; ++G__97975__i;}
G__97974 = new cljs.core.IndexedSeq(G__97975__a,0,null);
}
return G__97923__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__97974);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__97923.cljs$lang$maxFixedArity = 2;
G__97923.cljs$lang$applyTo = G__97923__3.cljs$lang$applyTo;
G__97923.cljs$core$IFn$_invoke$arity$0 = G__97923__0;
G__97923.cljs$core$IFn$_invoke$arity$1 = G__97923__1;
G__97923.cljs$core$IFn$_invoke$arity$2 = G__97923__2;
G__97923.cljs$core$IFn$_invoke$arity$variadic = G__97923__3.cljs$core$IFn$_invoke$arity$variadic;
return G__97923;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97980__delegate = function (path){
return com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path);
};
var G__97980 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97983__i = 0, G__97983__a = new Array(arguments.length -  0);
while (G__97983__i < G__97983__a.length) {G__97983__a[G__97983__i] = arguments[G__97983__i + 0]; ++G__97983__i;}
  path = new cljs.core.IndexedSeq(G__97983__a,0,null);
} 
return G__97980__delegate.call(this,path);};
G__97980.cljs$lang$maxFixedArity = 0;
G__97980.cljs$lang$applyTo = (function (arglist__97984){
var path = cljs.core.seq(arglist__97984);
return G__97980__delegate(path);
});
G__97980.cljs$core$IFn$_invoke$arity$variadic = G__97980__delegate;
return G__97980;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__97989__delegate = function (path){
return com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY);
};
var G__97989 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__97992__i = 0, G__97992__a = new Array(arguments.length -  0);
while (G__97992__i < G__97992__a.length) {G__97992__a[G__97992__i] = arguments[G__97992__i + 0]; ++G__97992__i;}
  path = new cljs.core.IndexedSeq(G__97992__a,0,null);
} 
return G__97989__delegate.call(this,path);};
G__97989.cljs$lang$maxFixedArity = 0;
G__97989.cljs$lang$applyTo = (function (arglist__97993){
var path = cljs.core.seq(arglist__97993);
return G__97989__delegate(path);
});
G__97989.cljs$core$IFn$_invoke$arity$variadic = G__97989__delegate;
return G__97989;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
var p = com.rpl.specter.impl.local_declarepath.call(null);
com.rpl.specter.impl.providepath_STAR_.call(null,p,(function (){var info__34833__auto__ = com.rpl.specter.pathcache97998;
var info__34833__auto____$1 = (((info__34833__auto__ == null))?(function (){var info97999 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",25,1,1237,1237,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.\n\n   The input paths may be parameterized, in which case the result of cond-path\n   will be parameterized in the order of which the parameterized navigators\n   were declared.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",7,1,true,1042,1046,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. This is the\n          late-bound parameterized version of using a function directly in a path.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym.call(null,afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",7,1,626,628,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse.call(null,cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",21,1,2086,2086,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",6,1,650,653,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym.call(null,p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache97998 = info97999;

return info97999;
})():info__34833__auto__);
var precompiled98000 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__34833__auto____$1);
var dynamic_QMARK___34834__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__34833__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___34834__auto__)){
return precompiled98000.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null));
} else {
return precompiled98000;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
var p = com.rpl.specter.impl.local_declarepath.call(null);
com.rpl.specter.impl.providepath_STAR_.call(null,p,(function (){var info__34833__auto__ = com.rpl.specter.pathcache98017;
var info__34833__auto____$1 = (((info__34833__auto__ == null))?(function (){var info98018 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",25,1,1237,1237,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.\n\n   The input paths may be parameterized, in which case the result of cond-path\n   will be parameterized in the order of which the parameterized navigators\n   were declared.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",7,1,true,1042,1046,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. This is the\n          late-bound parameterized version of using a function directly in a path.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym.call(null,afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",7,1,626,628,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse.call(null,cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",21,1,2086,2086,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",16,1,660,662,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym.call(null,p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache98017 = info98018;

return info98018;
})():info__34833__auto__);
var precompiled98019 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__34833__auto____$1);
var dynamic_QMARK___34834__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__34833__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___34834__auto__)){
return precompiled98019.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null));
} else {
return precompiled98019;
}
})());

return p;
}));

//# sourceMappingURL=specter.js.map?rel=1511404581862
