// Compiled by ClojureScript 1.9.946 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__86321__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__86315 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__86316 = cljs.core.seq.call(null,vec__86315);
var first__86317 = cljs.core.first.call(null,seq__86316);
var seq__86316__$1 = cljs.core.next.call(null,seq__86316);
var tag = first__86317;
var body = seq__86316__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__86321 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__86323__i = 0, G__86323__a = new Array(arguments.length -  0);
while (G__86323__i < G__86323__a.length) {G__86323__a[G__86323__i] = arguments[G__86323__i + 0]; ++G__86323__i;}
  args = new cljs.core.IndexedSeq(G__86323__a,0,null);
} 
return G__86321__delegate.call(this,args);};
G__86321.cljs$lang$maxFixedArity = 0;
G__86321.cljs$lang$applyTo = (function (arglist__86324){
var args = cljs.core.seq(arglist__86324);
return G__86321__delegate(args);
});
G__86321.cljs$core$IFn$_invoke$arity$variadic = G__86321__delegate;
return G__86321;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__28949__auto__ = (function sablono$core$update_arglists_$_iter__86328(s__86329){
return (new cljs.core.LazySeq(null,(function (){
var s__86329__$1 = s__86329;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__86329__$1);
if(temp__4657__auto__){
var s__86329__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__86329__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__86329__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__86331 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__86330 = (0);
while(true){
if((i__86330 < size__28948__auto__)){
var args = cljs.core._nth.call(null,c__28947__auto__,i__86330);
cljs.core.chunk_append.call(null,b__86331,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__86332 = (i__86330 + (1));
i__86330 = G__86332;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86331),sablono$core$update_arglists_$_iter__86328.call(null,cljs.core.chunk_rest.call(null,s__86329__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86331),null);
}
} else {
var args = cljs.core.first.call(null,s__86329__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__86328.call(null,cljs.core.rest.call(null,s__86329__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__29319__auto__ = [];
var len__29312__auto___86339 = arguments.length;
var i__29313__auto___86340 = (0);
while(true){
if((i__29313__auto___86340 < len__29312__auto___86339)){
args__29319__auto__.push((arguments[i__29313__auto___86340]));

var G__86341 = (i__29313__auto___86340 + (1));
i__29313__auto___86340 = G__86341;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__28949__auto__ = (function sablono$core$iter__86334(s__86335){
return (new cljs.core.LazySeq(null,(function (){
var s__86335__$1 = s__86335;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__86335__$1);
if(temp__4657__auto__){
var s__86335__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__86335__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__86335__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__86337 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__86336 = (0);
while(true){
if((i__86336 < size__28948__auto__)){
var style = cljs.core._nth.call(null,c__28947__auto__,i__86336);
cljs.core.chunk_append.call(null,b__86337,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__86348 = (i__86336 + (1));
i__86336 = G__86348;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86337),sablono$core$iter__86334.call(null,cljs.core.chunk_rest.call(null,s__86335__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86337),null);
}
} else {
var style = cljs.core.first.call(null,s__86335__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__86334.call(null,cljs.core.rest.call(null,s__86335__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq86333){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq86333));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to86354 = (function sablono$core$link_to86354(var_args){
var args__29319__auto__ = [];
var len__29312__auto___86363 = arguments.length;
var i__29313__auto___86366 = (0);
while(true){
if((i__29313__auto___86366 < len__29312__auto___86363)){
args__29319__auto__.push((arguments[i__29313__auto___86366]));

var G__86369 = (i__29313__auto___86366 + (1));
i__29313__auto___86366 = G__86369;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to86354.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

sablono.core.link_to86354.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to86354.cljs$lang$maxFixedArity = (1);

sablono.core.link_to86354.cljs$lang$applyTo = (function (seq86355){
var G__86356 = cljs.core.first.call(null,seq86355);
var seq86355__$1 = cljs.core.next.call(null,seq86355);
return sablono.core.link_to86354.cljs$core$IFn$_invoke$arity$variadic(G__86356,seq86355__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to86354);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to86379 = (function sablono$core$mail_to86379(var_args){
var args__29319__auto__ = [];
var len__29312__auto___86390 = arguments.length;
var i__29313__auto___86391 = (0);
while(true){
if((i__29313__auto___86391 < len__29312__auto___86390)){
args__29319__auto__.push((arguments[i__29313__auto___86391]));

var G__86393 = (i__29313__auto___86391 + (1));
i__29313__auto___86391 = G__86393;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to86379.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

sablono.core.mail_to86379.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__86383){
var vec__86384 = p__86383;
var content = cljs.core.nth.call(null,vec__86384,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__28141__auto__ = content;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to86379.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to86379.cljs$lang$applyTo = (function (seq86380){
var G__86381 = cljs.core.first.call(null,seq86380);
var seq86380__$1 = cljs.core.next.call(null,seq86380);
return sablono.core.mail_to86379.cljs$core$IFn$_invoke$arity$variadic(G__86381,seq86380__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to86379);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list86394 = (function sablono$core$unordered_list86394(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__28949__auto__ = (function sablono$core$unordered_list86394_$_iter__86395(s__86396){
return (new cljs.core.LazySeq(null,(function (){
var s__86396__$1 = s__86396;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__86396__$1);
if(temp__4657__auto__){
var s__86396__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__86396__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__86396__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__86398 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__86397 = (0);
while(true){
if((i__86397 < size__28948__auto__)){
var x = cljs.core._nth.call(null,c__28947__auto__,i__86397);
cljs.core.chunk_append.call(null,b__86398,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__86402 = (i__86397 + (1));
i__86397 = G__86402;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86398),sablono$core$unordered_list86394_$_iter__86395.call(null,cljs.core.chunk_rest.call(null,s__86396__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86398),null);
}
} else {
var x = cljs.core.first.call(null,s__86396__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list86394_$_iter__86395.call(null,cljs.core.rest.call(null,s__86396__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list86394);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list86406 = (function sablono$core$ordered_list86406(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__28949__auto__ = (function sablono$core$ordered_list86406_$_iter__86407(s__86408){
return (new cljs.core.LazySeq(null,(function (){
var s__86408__$1 = s__86408;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__86408__$1);
if(temp__4657__auto__){
var s__86408__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__86408__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__86408__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__86410 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__86409 = (0);
while(true){
if((i__86409 < size__28948__auto__)){
var x = cljs.core._nth.call(null,c__28947__auto__,i__86409);
cljs.core.chunk_append.call(null,b__86410,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__86419 = (i__86409 + (1));
i__86409 = G__86419;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86410),sablono$core$ordered_list86406_$_iter__86407.call(null,cljs.core.chunk_rest.call(null,s__86408__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86410),null);
}
} else {
var x = cljs.core.first.call(null,s__86408__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list86406_$_iter__86407.call(null,cljs.core.rest.call(null,s__86408__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list86406);
/**
 * Create an image element.
 */
sablono.core.image86421 = (function sablono$core$image86421(var_args){
var G__86423 = arguments.length;
switch (G__86423) {
case 1:
return sablono.core.image86421.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image86421.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.image86421.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image86421.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image86421.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image86421);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__86427_SHARP_,p2__86428_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__86427_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__86428_SHARP_),"]"].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__86429_SHARP_,p2__86430_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__86429_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__86430_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__28141__auto__ = value;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field86435 = (function sablono$core$color_field86435(var_args){
var G__86437 = arguments.length;
switch (G__86437) {
case 1:
return sablono.core.color_field86435.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field86435.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.color_field86435.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.color_field86435.call(null,name__86300__auto__,null);
});

sablono.core.color_field86435.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.color_field86435.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field86435);

/**
 * Creates a date input field.
 */
sablono.core.date_field86438 = (function sablono$core$date_field86438(var_args){
var G__86440 = arguments.length;
switch (G__86440) {
case 1:
return sablono.core.date_field86438.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field86438.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.date_field86438.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.date_field86438.call(null,name__86300__auto__,null);
});

sablono.core.date_field86438.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.date_field86438.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field86438);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field86443 = (function sablono$core$datetime_field86443(var_args){
var G__86445 = arguments.length;
switch (G__86445) {
case 1:
return sablono.core.datetime_field86443.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field86443.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_field86443.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.datetime_field86443.call(null,name__86300__auto__,null);
});

sablono.core.datetime_field86443.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.datetime_field86443.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field86443);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field86451 = (function sablono$core$datetime_local_field86451(var_args){
var G__86454 = arguments.length;
switch (G__86454) {
case 1:
return sablono.core.datetime_local_field86451.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field86451.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_local_field86451.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.datetime_local_field86451.call(null,name__86300__auto__,null);
});

sablono.core.datetime_local_field86451.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.datetime_local_field86451.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field86451);

/**
 * Creates a email input field.
 */
sablono.core.email_field86462 = (function sablono$core$email_field86462(var_args){
var G__86464 = arguments.length;
switch (G__86464) {
case 1:
return sablono.core.email_field86462.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field86462.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.email_field86462.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.email_field86462.call(null,name__86300__auto__,null);
});

sablono.core.email_field86462.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.email_field86462.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field86462);

/**
 * Creates a file input field.
 */
sablono.core.file_field86468 = (function sablono$core$file_field86468(var_args){
var G__86470 = arguments.length;
switch (G__86470) {
case 1:
return sablono.core.file_field86468.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field86468.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.file_field86468.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.file_field86468.call(null,name__86300__auto__,null);
});

sablono.core.file_field86468.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.file_field86468.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field86468);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field86472 = (function sablono$core$hidden_field86472(var_args){
var G__86475 = arguments.length;
switch (G__86475) {
case 1:
return sablono.core.hidden_field86472.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field86472.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.hidden_field86472.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.hidden_field86472.call(null,name__86300__auto__,null);
});

sablono.core.hidden_field86472.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.hidden_field86472.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field86472);

/**
 * Creates a month input field.
 */
sablono.core.month_field86481 = (function sablono$core$month_field86481(var_args){
var G__86484 = arguments.length;
switch (G__86484) {
case 1:
return sablono.core.month_field86481.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field86481.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.month_field86481.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.month_field86481.call(null,name__86300__auto__,null);
});

sablono.core.month_field86481.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.month_field86481.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field86481);

/**
 * Creates a number input field.
 */
sablono.core.number_field86486 = (function sablono$core$number_field86486(var_args){
var G__86491 = arguments.length;
switch (G__86491) {
case 1:
return sablono.core.number_field86486.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field86486.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.number_field86486.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.number_field86486.call(null,name__86300__auto__,null);
});

sablono.core.number_field86486.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.number_field86486.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field86486);

/**
 * Creates a password input field.
 */
sablono.core.password_field86492 = (function sablono$core$password_field86492(var_args){
var G__86498 = arguments.length;
switch (G__86498) {
case 1:
return sablono.core.password_field86492.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field86492.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.password_field86492.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.password_field86492.call(null,name__86300__auto__,null);
});

sablono.core.password_field86492.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.password_field86492.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field86492);

/**
 * Creates a range input field.
 */
sablono.core.range_field86500 = (function sablono$core$range_field86500(var_args){
var G__86502 = arguments.length;
switch (G__86502) {
case 1:
return sablono.core.range_field86500.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field86500.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.range_field86500.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.range_field86500.call(null,name__86300__auto__,null);
});

sablono.core.range_field86500.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.range_field86500.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field86500);

/**
 * Creates a search input field.
 */
sablono.core.search_field86508 = (function sablono$core$search_field86508(var_args){
var G__86512 = arguments.length;
switch (G__86512) {
case 1:
return sablono.core.search_field86508.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field86508.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.search_field86508.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.search_field86508.call(null,name__86300__auto__,null);
});

sablono.core.search_field86508.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.search_field86508.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field86508);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field86517 = (function sablono$core$tel_field86517(var_args){
var G__86520 = arguments.length;
switch (G__86520) {
case 1:
return sablono.core.tel_field86517.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field86517.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.tel_field86517.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.tel_field86517.call(null,name__86300__auto__,null);
});

sablono.core.tel_field86517.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.tel_field86517.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field86517);

/**
 * Creates a text input field.
 */
sablono.core.text_field86528 = (function sablono$core$text_field86528(var_args){
var G__86531 = arguments.length;
switch (G__86531) {
case 1:
return sablono.core.text_field86528.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field86528.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_field86528.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.text_field86528.call(null,name__86300__auto__,null);
});

sablono.core.text_field86528.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.text_field86528.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field86528);

/**
 * Creates a time input field.
 */
sablono.core.time_field86535 = (function sablono$core$time_field86535(var_args){
var G__86537 = arguments.length;
switch (G__86537) {
case 1:
return sablono.core.time_field86535.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field86535.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.time_field86535.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.time_field86535.call(null,name__86300__auto__,null);
});

sablono.core.time_field86535.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.time_field86535.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field86535);

/**
 * Creates a url input field.
 */
sablono.core.url_field86539 = (function sablono$core$url_field86539(var_args){
var G__86541 = arguments.length;
switch (G__86541) {
case 1:
return sablono.core.url_field86539.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field86539.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.url_field86539.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.url_field86539.call(null,name__86300__auto__,null);
});

sablono.core.url_field86539.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.url_field86539.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field86539);

/**
 * Creates a week input field.
 */
sablono.core.week_field86546 = (function sablono$core$week_field86546(var_args){
var G__86549 = arguments.length;
switch (G__86549) {
case 1:
return sablono.core.week_field86546.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field86546.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.week_field86546.cljs$core$IFn$_invoke$arity$1 = (function (name__86300__auto__){
return sablono.core.week_field86546.call(null,name__86300__auto__,null);
});

sablono.core.week_field86546.cljs$core$IFn$_invoke$arity$2 = (function (name__86300__auto__,value__86301__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__86300__auto__,value__86301__auto__);
});

sablono.core.week_field86546.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field86546);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box86637 = (function sablono$core$check_box86637(var_args){
var G__86639 = arguments.length;
switch (G__86639) {
case 1:
return sablono.core.check_box86637.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box86637.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box86637.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.check_box86637.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box86637.call(null,name,null);
});

sablono.core.check_box86637.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box86637.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box86637.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__28141__auto__ = value;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box86637.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box86637);
/**
 * Creates a radio button.
 */
sablono.core.radio_button86646 = (function sablono$core$radio_button86646(var_args){
var G__86648 = arguments.length;
switch (G__86648) {
case 1:
return sablono.core.radio_button86646.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button86646.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button86646.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.radio_button86646.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button86646.call(null,group,null);
});

sablono.core.radio_button86646.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button86646.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button86646.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__28141__auto__ = value;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button86646.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button86646);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options86655 = (function sablono$core$select_options86655(coll){
var iter__28949__auto__ = (function sablono$core$select_options86655_$_iter__86656(s__86657){
return (new cljs.core.LazySeq(null,(function (){
var s__86657__$1 = s__86657;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__86657__$1);
if(temp__4657__auto__){
var s__86657__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__86657__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__86657__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__86659 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__86658 = (0);
while(true){
if((i__86658 < size__28948__auto__)){
var x = cljs.core._nth.call(null,c__28947__auto__,i__86658);
cljs.core.chunk_append.call(null,b__86659,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__86660 = x;
var text = cljs.core.nth.call(null,vec__86660,(0),null);
var val = cljs.core.nth.call(null,vec__86660,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__86660,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options86655.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__86672 = (i__86658 + (1));
i__86658 = G__86672;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86659),sablono$core$select_options86655_$_iter__86656.call(null,cljs.core.chunk_rest.call(null,s__86657__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__86659),null);
}
} else {
var x = cljs.core.first.call(null,s__86657__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__86669 = x;
var text = cljs.core.nth.call(null,vec__86669,(0),null);
var val = cljs.core.nth.call(null,vec__86669,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__86669,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options86655.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options86655_$_iter__86656.call(null,cljs.core.rest.call(null,s__86657__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options86655);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down86681 = (function sablono$core$drop_down86681(var_args){
var G__86683 = arguments.length;
switch (G__86683) {
case 2:
return sablono.core.drop_down86681.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down86681.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.drop_down86681.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down86681.call(null,name,options,null);
});

sablono.core.drop_down86681.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down86681.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down86681);
/**
 * Creates a text area element.
 */
sablono.core.text_area86688 = (function sablono$core$text_area86688(var_args){
var G__86690 = arguments.length;
switch (G__86690) {
case 1:
return sablono.core.text_area86688.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area86688.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_area86688.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area86688.call(null,name,null);
});

sablono.core.text_area86688.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__28141__auto__ = value;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area86688.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area86688);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label86692 = (function sablono$core$label86692(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label86692);
/**
 * Creates a submit button.
 */
sablono.core.submit_button86693 = (function sablono$core$submit_button86693(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button86693);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button86695 = (function sablono$core$reset_button86695(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button86695);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to86696 = (function sablono$core$form_to86696(var_args){
var args__29319__auto__ = [];
var len__29312__auto___86703 = arguments.length;
var i__29313__auto___86704 = (0);
while(true){
if((i__29313__auto___86704 < len__29312__auto___86703)){
args__29319__auto__.push((arguments[i__29313__auto___86704]));

var G__86705 = (i__29313__auto___86704 + (1));
i__29313__auto___86704 = G__86705;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to86696.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

sablono.core.form_to86696.cljs$core$IFn$_invoke$arity$variadic = (function (p__86699,body){
var vec__86700 = p__86699;
var method = cljs.core.nth.call(null,vec__86700,(0),null);
var action = cljs.core.nth.call(null,vec__86700,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to86696.cljs$lang$maxFixedArity = (1);

sablono.core.form_to86696.cljs$lang$applyTo = (function (seq86697){
var G__86698 = cljs.core.first.call(null,seq86697);
var seq86697__$1 = cljs.core.next.call(null,seq86697);
return sablono.core.form_to86696.cljs$core$IFn$_invoke$arity$variadic(G__86698,seq86697__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to86696);

//# sourceMappingURL=core.js.map?rel=1511404572395
