// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__71531 = arguments.length;
switch (G__71531) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async71532 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71532 = (function (f,blockable,meta71533){
this.f = f;
this.blockable = blockable;
this.meta71533 = meta71533;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async71532.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71534,meta71533__$1){
var self__ = this;
var _71534__$1 = this;
return (new cljs.core.async.t_cljs$core$async71532(self__.f,self__.blockable,meta71533__$1));
});


cljs.core.async.t_cljs$core$async71532.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71534){
var self__ = this;
var _71534__$1 = this;
return self__.meta71533;
});


cljs.core.async.t_cljs$core$async71532.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async71532.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async71532.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async71532.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async71532.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta71533","meta71533",268702782,null)], null);
});

cljs.core.async.t_cljs$core$async71532.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async71532.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71532";

cljs.core.async.t_cljs$core$async71532.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async71532");
});

cljs.core.async.__GT_t_cljs$core$async71532 = (function cljs$core$async$__GT_t_cljs$core$async71532(f__$1,blockable__$1,meta71533){
return (new cljs.core.async.t_cljs$core$async71532(f__$1,blockable__$1,meta71533));
});

}

return (new cljs.core.async.t_cljs$core$async71532(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__71538 = arguments.length;
switch (G__71538) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__71541 = arguments.length;
switch (G__71541) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__71544 = arguments.length;
switch (G__71544) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_71546 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_71546);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_71546,ret){
return (function (){
return fn1.call(null,val_71546);
});})(val_71546,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__71548 = arguments.length;
switch (G__71548) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29088__auto___71550 = n;
var x_71551 = (0);
while(true){
if((x_71551 < n__29088__auto___71550)){
(a[x_71551] = (0));

var G__71552 = (x_71551 + (1));
x_71551 = G__71552;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__71553 = (i + (1));
i = G__71553;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async71554 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71554 = (function (flag,meta71555){
this.flag = flag;
this.meta71555 = meta71555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async71554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_71556,meta71555__$1){
var self__ = this;
var _71556__$1 = this;
return (new cljs.core.async.t_cljs$core$async71554(self__.flag,meta71555__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async71554.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_71556){
var self__ = this;
var _71556__$1 = this;
return self__.meta71555;
});})(flag))
;


cljs.core.async.t_cljs$core$async71554.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async71554.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async71554.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async71554.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async71554.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta71555","meta71555",-1021384627,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async71554.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async71554.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71554";

cljs.core.async.t_cljs$core$async71554.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async71554");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async71554 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async71554(flag__$1,meta71555){
return (new cljs.core.async.t_cljs$core$async71554(flag__$1,meta71555));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async71554(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async71557 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71557 = (function (flag,cb,meta71558){
this.flag = flag;
this.cb = cb;
this.meta71558 = meta71558;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async71557.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71559,meta71558__$1){
var self__ = this;
var _71559__$1 = this;
return (new cljs.core.async.t_cljs$core$async71557(self__.flag,self__.cb,meta71558__$1));
});


cljs.core.async.t_cljs$core$async71557.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71559){
var self__ = this;
var _71559__$1 = this;
return self__.meta71558;
});


cljs.core.async.t_cljs$core$async71557.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async71557.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async71557.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async71557.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async71557.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta71558","meta71558",-1651246082,null)], null);
});

cljs.core.async.t_cljs$core$async71557.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async71557.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71557";

cljs.core.async.t_cljs$core$async71557.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async71557");
});

cljs.core.async.__GT_t_cljs$core$async71557 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async71557(flag__$1,cb__$1,meta71558){
return (new cljs.core.async.t_cljs$core$async71557(flag__$1,cb__$1,meta71558));
});

}

return (new cljs.core.async.t_cljs$core$async71557(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71560_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71560_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71561_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71561_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28141__auto__ = wport;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return port;
}
})()], null));
} else {
var G__71562 = (i + (1));
i = G__71562;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28141__auto__ = ret;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28129__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___71568 = arguments.length;
var i__29313__auto___71569 = (0);
while(true){
if((i__29313__auto___71569 < len__29312__auto___71568)){
args__29319__auto__.push((arguments[i__29313__auto___71569]));

var G__71570 = (i__29313__auto___71569 + (1));
i__29313__auto___71569 = G__71570;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__71565){
var map__71566 = p__71565;
var map__71566__$1 = ((((!((map__71566 == null)))?((((map__71566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71566.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71566):map__71566);
var opts = map__71566__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq71563){
var G__71564 = cljs.core.first.call(null,seq71563);
var seq71563__$1 = cljs.core.next.call(null,seq71563);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__71564,seq71563__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__71572 = arguments.length;
switch (G__71572) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__47173__auto___71618 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___71618){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___71618){
return (function (state_71596){
var state_val_71597 = (state_71596[(1)]);
if((state_val_71597 === (7))){
var inst_71592 = (state_71596[(2)]);
var state_71596__$1 = state_71596;
var statearr_71598_71619 = state_71596__$1;
(statearr_71598_71619[(2)] = inst_71592);

(statearr_71598_71619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (1))){
var state_71596__$1 = state_71596;
var statearr_71599_71620 = state_71596__$1;
(statearr_71599_71620[(2)] = null);

(statearr_71599_71620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (4))){
var inst_71575 = (state_71596[(7)]);
var inst_71575__$1 = (state_71596[(2)]);
var inst_71576 = (inst_71575__$1 == null);
var state_71596__$1 = (function (){var statearr_71600 = state_71596;
(statearr_71600[(7)] = inst_71575__$1);

return statearr_71600;
})();
if(cljs.core.truth_(inst_71576)){
var statearr_71601_71621 = state_71596__$1;
(statearr_71601_71621[(1)] = (5));

} else {
var statearr_71602_71622 = state_71596__$1;
(statearr_71602_71622[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (13))){
var state_71596__$1 = state_71596;
var statearr_71603_71623 = state_71596__$1;
(statearr_71603_71623[(2)] = null);

(statearr_71603_71623[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (6))){
var inst_71575 = (state_71596[(7)]);
var state_71596__$1 = state_71596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71596__$1,(11),to,inst_71575);
} else {
if((state_val_71597 === (3))){
var inst_71594 = (state_71596[(2)]);
var state_71596__$1 = state_71596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71596__$1,inst_71594);
} else {
if((state_val_71597 === (12))){
var state_71596__$1 = state_71596;
var statearr_71604_71624 = state_71596__$1;
(statearr_71604_71624[(2)] = null);

(statearr_71604_71624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (2))){
var state_71596__$1 = state_71596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71596__$1,(4),from);
} else {
if((state_val_71597 === (11))){
var inst_71585 = (state_71596[(2)]);
var state_71596__$1 = state_71596;
if(cljs.core.truth_(inst_71585)){
var statearr_71605_71625 = state_71596__$1;
(statearr_71605_71625[(1)] = (12));

} else {
var statearr_71606_71626 = state_71596__$1;
(statearr_71606_71626[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (9))){
var state_71596__$1 = state_71596;
var statearr_71607_71627 = state_71596__$1;
(statearr_71607_71627[(2)] = null);

(statearr_71607_71627[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (5))){
var state_71596__$1 = state_71596;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71608_71628 = state_71596__$1;
(statearr_71608_71628[(1)] = (8));

} else {
var statearr_71609_71629 = state_71596__$1;
(statearr_71609_71629[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (14))){
var inst_71590 = (state_71596[(2)]);
var state_71596__$1 = state_71596;
var statearr_71610_71630 = state_71596__$1;
(statearr_71610_71630[(2)] = inst_71590);

(statearr_71610_71630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (10))){
var inst_71582 = (state_71596[(2)]);
var state_71596__$1 = state_71596;
var statearr_71611_71631 = state_71596__$1;
(statearr_71611_71631[(2)] = inst_71582);

(statearr_71611_71631[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71597 === (8))){
var inst_71579 = cljs.core.async.close_BANG_.call(null,to);
var state_71596__$1 = state_71596;
var statearr_71612_71632 = state_71596__$1;
(statearr_71612_71632[(2)] = inst_71579);

(statearr_71612_71632[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___71618))
;
return ((function (switch__47085__auto__,c__47173__auto___71618){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_71613 = [null,null,null,null,null,null,null,null];
(statearr_71613[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_71613[(1)] = (1));

return statearr_71613;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_71596){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71614){if((e71614 instanceof Object)){
var ex__47089__auto__ = e71614;
var statearr_71615_71633 = state_71596;
(statearr_71615_71633[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71614;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71634 = state_71596;
state_71596 = G__71634;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_71596){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_71596);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___71618))
})();
var state__47175__auto__ = (function (){var statearr_71616 = f__47174__auto__.call(null);
(statearr_71616[(6)] = c__47173__auto___71618);

return statearr_71616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___71618))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__71635){
var vec__71636 = p__71635;
var v = cljs.core.nth.call(null,vec__71636,(0),null);
var p = cljs.core.nth.call(null,vec__71636,(1),null);
var job = vec__71636;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__47173__auto___71807 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___71807,res,vec__71636,v,p,job,jobs,results){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___71807,res,vec__71636,v,p,job,jobs,results){
return (function (state_71643){
var state_val_71644 = (state_71643[(1)]);
if((state_val_71644 === (1))){
var state_71643__$1 = state_71643;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71643__$1,(2),res,v);
} else {
if((state_val_71644 === (2))){
var inst_71640 = (state_71643[(2)]);
var inst_71641 = cljs.core.async.close_BANG_.call(null,res);
var state_71643__$1 = (function (){var statearr_71645 = state_71643;
(statearr_71645[(7)] = inst_71640);

return statearr_71645;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71643__$1,inst_71641);
} else {
return null;
}
}
});})(c__47173__auto___71807,res,vec__71636,v,p,job,jobs,results))
;
return ((function (switch__47085__auto__,c__47173__auto___71807,res,vec__71636,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_71646 = [null,null,null,null,null,null,null,null];
(statearr_71646[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_71646[(1)] = (1));

return statearr_71646;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_71643){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71647){if((e71647 instanceof Object)){
var ex__47089__auto__ = e71647;
var statearr_71648_71808 = state_71643;
(statearr_71648_71808[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71643);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71647;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71809 = state_71643;
state_71643 = G__71809;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_71643){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_71643);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___71807,res,vec__71636,v,p,job,jobs,results))
})();
var state__47175__auto__ = (function (){var statearr_71649 = f__47174__auto__.call(null);
(statearr_71649[(6)] = c__47173__auto___71807);

return statearr_71649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___71807,res,vec__71636,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__71650){
var vec__71651 = p__71650;
var v = cljs.core.nth.call(null,vec__71651,(0),null);
var p = cljs.core.nth.call(null,vec__71651,(1),null);
var job = vec__71651;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29088__auto___71810 = n;
var __71811 = (0);
while(true){
if((__71811 < n__29088__auto___71810)){
var G__71654_71812 = type;
var G__71654_71813__$1 = (((G__71654_71812 instanceof cljs.core.Keyword))?G__71654_71812.fqn:null);
switch (G__71654_71813__$1) {
case "compute":
var c__47173__auto___71815 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__71811,c__47173__auto___71815,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (__71811,c__47173__auto___71815,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async){
return (function (state_71667){
var state_val_71668 = (state_71667[(1)]);
if((state_val_71668 === (1))){
var state_71667__$1 = state_71667;
var statearr_71669_71816 = state_71667__$1;
(statearr_71669_71816[(2)] = null);

(statearr_71669_71816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71668 === (2))){
var state_71667__$1 = state_71667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71667__$1,(4),jobs);
} else {
if((state_val_71668 === (3))){
var inst_71665 = (state_71667[(2)]);
var state_71667__$1 = state_71667;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71667__$1,inst_71665);
} else {
if((state_val_71668 === (4))){
var inst_71657 = (state_71667[(2)]);
var inst_71658 = process.call(null,inst_71657);
var state_71667__$1 = state_71667;
if(cljs.core.truth_(inst_71658)){
var statearr_71670_71817 = state_71667__$1;
(statearr_71670_71817[(1)] = (5));

} else {
var statearr_71671_71818 = state_71667__$1;
(statearr_71671_71818[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71668 === (5))){
var state_71667__$1 = state_71667;
var statearr_71672_71819 = state_71667__$1;
(statearr_71672_71819[(2)] = null);

(statearr_71672_71819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71668 === (6))){
var state_71667__$1 = state_71667;
var statearr_71673_71820 = state_71667__$1;
(statearr_71673_71820[(2)] = null);

(statearr_71673_71820[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71668 === (7))){
var inst_71663 = (state_71667[(2)]);
var state_71667__$1 = state_71667;
var statearr_71674_71821 = state_71667__$1;
(statearr_71674_71821[(2)] = inst_71663);

(statearr_71674_71821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__71811,c__47173__auto___71815,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async))
;
return ((function (__71811,switch__47085__auto__,c__47173__auto___71815,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_71675 = [null,null,null,null,null,null,null];
(statearr_71675[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_71675[(1)] = (1));

return statearr_71675;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_71667){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71676){if((e71676 instanceof Object)){
var ex__47089__auto__ = e71676;
var statearr_71677_71822 = state_71667;
(statearr_71677_71822[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71667);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71676;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71823 = state_71667;
state_71667 = G__71823;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_71667){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_71667);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(__71811,switch__47085__auto__,c__47173__auto___71815,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_71678 = f__47174__auto__.call(null);
(statearr_71678[(6)] = c__47173__auto___71815);

return statearr_71678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(__71811,c__47173__auto___71815,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async))
);


break;
case "async":
var c__47173__auto___71824 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__71811,c__47173__auto___71824,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (__71811,c__47173__auto___71824,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async){
return (function (state_71691){
var state_val_71692 = (state_71691[(1)]);
if((state_val_71692 === (1))){
var state_71691__$1 = state_71691;
var statearr_71693_71825 = state_71691__$1;
(statearr_71693_71825[(2)] = null);

(statearr_71693_71825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71692 === (2))){
var state_71691__$1 = state_71691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71691__$1,(4),jobs);
} else {
if((state_val_71692 === (3))){
var inst_71689 = (state_71691[(2)]);
var state_71691__$1 = state_71691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71691__$1,inst_71689);
} else {
if((state_val_71692 === (4))){
var inst_71681 = (state_71691[(2)]);
var inst_71682 = async.call(null,inst_71681);
var state_71691__$1 = state_71691;
if(cljs.core.truth_(inst_71682)){
var statearr_71694_71826 = state_71691__$1;
(statearr_71694_71826[(1)] = (5));

} else {
var statearr_71695_71827 = state_71691__$1;
(statearr_71695_71827[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71692 === (5))){
var state_71691__$1 = state_71691;
var statearr_71696_71828 = state_71691__$1;
(statearr_71696_71828[(2)] = null);

(statearr_71696_71828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71692 === (6))){
var state_71691__$1 = state_71691;
var statearr_71697_71829 = state_71691__$1;
(statearr_71697_71829[(2)] = null);

(statearr_71697_71829[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71692 === (7))){
var inst_71687 = (state_71691[(2)]);
var state_71691__$1 = state_71691;
var statearr_71698_71830 = state_71691__$1;
(statearr_71698_71830[(2)] = inst_71687);

(statearr_71698_71830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__71811,c__47173__auto___71824,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async))
;
return ((function (__71811,switch__47085__auto__,c__47173__auto___71824,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_71699 = [null,null,null,null,null,null,null];
(statearr_71699[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_71699[(1)] = (1));

return statearr_71699;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_71691){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71700){if((e71700 instanceof Object)){
var ex__47089__auto__ = e71700;
var statearr_71701_71831 = state_71691;
(statearr_71701_71831[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71700;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71832 = state_71691;
state_71691 = G__71832;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_71691){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_71691);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(__71811,switch__47085__auto__,c__47173__auto___71824,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_71702 = f__47174__auto__.call(null);
(statearr_71702[(6)] = c__47173__auto___71824);

return statearr_71702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(__71811,c__47173__auto___71824,G__71654_71812,G__71654_71813__$1,n__29088__auto___71810,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__71654_71813__$1)].join('')));

}

var G__71833 = (__71811 + (1));
__71811 = G__71833;
continue;
} else {
}
break;
}

var c__47173__auto___71834 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___71834,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___71834,jobs,results,process,async){
return (function (state_71724){
var state_val_71725 = (state_71724[(1)]);
if((state_val_71725 === (1))){
var state_71724__$1 = state_71724;
var statearr_71726_71835 = state_71724__$1;
(statearr_71726_71835[(2)] = null);

(statearr_71726_71835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71725 === (2))){
var state_71724__$1 = state_71724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71724__$1,(4),from);
} else {
if((state_val_71725 === (3))){
var inst_71722 = (state_71724[(2)]);
var state_71724__$1 = state_71724;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71724__$1,inst_71722);
} else {
if((state_val_71725 === (4))){
var inst_71705 = (state_71724[(7)]);
var inst_71705__$1 = (state_71724[(2)]);
var inst_71706 = (inst_71705__$1 == null);
var state_71724__$1 = (function (){var statearr_71727 = state_71724;
(statearr_71727[(7)] = inst_71705__$1);

return statearr_71727;
})();
if(cljs.core.truth_(inst_71706)){
var statearr_71728_71836 = state_71724__$1;
(statearr_71728_71836[(1)] = (5));

} else {
var statearr_71729_71837 = state_71724__$1;
(statearr_71729_71837[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71725 === (5))){
var inst_71708 = cljs.core.async.close_BANG_.call(null,jobs);
var state_71724__$1 = state_71724;
var statearr_71730_71838 = state_71724__$1;
(statearr_71730_71838[(2)] = inst_71708);

(statearr_71730_71838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71725 === (6))){
var inst_71705 = (state_71724[(7)]);
var inst_71710 = (state_71724[(8)]);
var inst_71710__$1 = cljs.core.async.chan.call(null,(1));
var inst_71711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71712 = [inst_71705,inst_71710__$1];
var inst_71713 = (new cljs.core.PersistentVector(null,2,(5),inst_71711,inst_71712,null));
var state_71724__$1 = (function (){var statearr_71731 = state_71724;
(statearr_71731[(8)] = inst_71710__$1);

return statearr_71731;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71724__$1,(8),jobs,inst_71713);
} else {
if((state_val_71725 === (7))){
var inst_71720 = (state_71724[(2)]);
var state_71724__$1 = state_71724;
var statearr_71732_71839 = state_71724__$1;
(statearr_71732_71839[(2)] = inst_71720);

(statearr_71732_71839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71725 === (8))){
var inst_71710 = (state_71724[(8)]);
var inst_71715 = (state_71724[(2)]);
var state_71724__$1 = (function (){var statearr_71733 = state_71724;
(statearr_71733[(9)] = inst_71715);

return statearr_71733;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71724__$1,(9),results,inst_71710);
} else {
if((state_val_71725 === (9))){
var inst_71717 = (state_71724[(2)]);
var state_71724__$1 = (function (){var statearr_71734 = state_71724;
(statearr_71734[(10)] = inst_71717);

return statearr_71734;
})();
var statearr_71735_71840 = state_71724__$1;
(statearr_71735_71840[(2)] = null);

(statearr_71735_71840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___71834,jobs,results,process,async))
;
return ((function (switch__47085__auto__,c__47173__auto___71834,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_71736 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71736[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_71736[(1)] = (1));

return statearr_71736;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_71724){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71737){if((e71737 instanceof Object)){
var ex__47089__auto__ = e71737;
var statearr_71738_71841 = state_71724;
(statearr_71738_71841[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71842 = state_71724;
state_71724 = G__71842;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_71724){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_71724);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___71834,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_71739 = f__47174__auto__.call(null);
(statearr_71739[(6)] = c__47173__auto___71834);

return statearr_71739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___71834,jobs,results,process,async))
);


var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,jobs,results,process,async){
return (function (state_71777){
var state_val_71778 = (state_71777[(1)]);
if((state_val_71778 === (7))){
var inst_71773 = (state_71777[(2)]);
var state_71777__$1 = state_71777;
var statearr_71779_71843 = state_71777__$1;
(statearr_71779_71843[(2)] = inst_71773);

(statearr_71779_71843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (20))){
var state_71777__$1 = state_71777;
var statearr_71780_71844 = state_71777__$1;
(statearr_71780_71844[(2)] = null);

(statearr_71780_71844[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (1))){
var state_71777__$1 = state_71777;
var statearr_71781_71845 = state_71777__$1;
(statearr_71781_71845[(2)] = null);

(statearr_71781_71845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (4))){
var inst_71742 = (state_71777[(7)]);
var inst_71742__$1 = (state_71777[(2)]);
var inst_71743 = (inst_71742__$1 == null);
var state_71777__$1 = (function (){var statearr_71782 = state_71777;
(statearr_71782[(7)] = inst_71742__$1);

return statearr_71782;
})();
if(cljs.core.truth_(inst_71743)){
var statearr_71783_71846 = state_71777__$1;
(statearr_71783_71846[(1)] = (5));

} else {
var statearr_71784_71847 = state_71777__$1;
(statearr_71784_71847[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (15))){
var inst_71755 = (state_71777[(8)]);
var state_71777__$1 = state_71777;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71777__$1,(18),to,inst_71755);
} else {
if((state_val_71778 === (21))){
var inst_71768 = (state_71777[(2)]);
var state_71777__$1 = state_71777;
var statearr_71785_71848 = state_71777__$1;
(statearr_71785_71848[(2)] = inst_71768);

(statearr_71785_71848[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (13))){
var inst_71770 = (state_71777[(2)]);
var state_71777__$1 = (function (){var statearr_71786 = state_71777;
(statearr_71786[(9)] = inst_71770);

return statearr_71786;
})();
var statearr_71787_71849 = state_71777__$1;
(statearr_71787_71849[(2)] = null);

(statearr_71787_71849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (6))){
var inst_71742 = (state_71777[(7)]);
var state_71777__$1 = state_71777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71777__$1,(11),inst_71742);
} else {
if((state_val_71778 === (17))){
var inst_71763 = (state_71777[(2)]);
var state_71777__$1 = state_71777;
if(cljs.core.truth_(inst_71763)){
var statearr_71788_71850 = state_71777__$1;
(statearr_71788_71850[(1)] = (19));

} else {
var statearr_71789_71851 = state_71777__$1;
(statearr_71789_71851[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (3))){
var inst_71775 = (state_71777[(2)]);
var state_71777__$1 = state_71777;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71777__$1,inst_71775);
} else {
if((state_val_71778 === (12))){
var inst_71752 = (state_71777[(10)]);
var state_71777__$1 = state_71777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71777__$1,(14),inst_71752);
} else {
if((state_val_71778 === (2))){
var state_71777__$1 = state_71777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71777__$1,(4),results);
} else {
if((state_val_71778 === (19))){
var state_71777__$1 = state_71777;
var statearr_71790_71852 = state_71777__$1;
(statearr_71790_71852[(2)] = null);

(statearr_71790_71852[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (11))){
var inst_71752 = (state_71777[(2)]);
var state_71777__$1 = (function (){var statearr_71791 = state_71777;
(statearr_71791[(10)] = inst_71752);

return statearr_71791;
})();
var statearr_71792_71853 = state_71777__$1;
(statearr_71792_71853[(2)] = null);

(statearr_71792_71853[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (9))){
var state_71777__$1 = state_71777;
var statearr_71793_71854 = state_71777__$1;
(statearr_71793_71854[(2)] = null);

(statearr_71793_71854[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (5))){
var state_71777__$1 = state_71777;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71794_71855 = state_71777__$1;
(statearr_71794_71855[(1)] = (8));

} else {
var statearr_71795_71856 = state_71777__$1;
(statearr_71795_71856[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (14))){
var inst_71755 = (state_71777[(8)]);
var inst_71757 = (state_71777[(11)]);
var inst_71755__$1 = (state_71777[(2)]);
var inst_71756 = (inst_71755__$1 == null);
var inst_71757__$1 = cljs.core.not.call(null,inst_71756);
var state_71777__$1 = (function (){var statearr_71796 = state_71777;
(statearr_71796[(8)] = inst_71755__$1);

(statearr_71796[(11)] = inst_71757__$1);

return statearr_71796;
})();
if(inst_71757__$1){
var statearr_71797_71857 = state_71777__$1;
(statearr_71797_71857[(1)] = (15));

} else {
var statearr_71798_71858 = state_71777__$1;
(statearr_71798_71858[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (16))){
var inst_71757 = (state_71777[(11)]);
var state_71777__$1 = state_71777;
var statearr_71799_71859 = state_71777__$1;
(statearr_71799_71859[(2)] = inst_71757);

(statearr_71799_71859[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (10))){
var inst_71749 = (state_71777[(2)]);
var state_71777__$1 = state_71777;
var statearr_71800_71860 = state_71777__$1;
(statearr_71800_71860[(2)] = inst_71749);

(statearr_71800_71860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (18))){
var inst_71760 = (state_71777[(2)]);
var state_71777__$1 = state_71777;
var statearr_71801_71861 = state_71777__$1;
(statearr_71801_71861[(2)] = inst_71760);

(statearr_71801_71861[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71778 === (8))){
var inst_71746 = cljs.core.async.close_BANG_.call(null,to);
var state_71777__$1 = state_71777;
var statearr_71802_71862 = state_71777__$1;
(statearr_71802_71862[(2)] = inst_71746);

(statearr_71802_71862[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__,jobs,results,process,async))
;
return ((function (switch__47085__auto__,c__47173__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_71803 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71803[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_71803[(1)] = (1));

return statearr_71803;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_71777){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71777);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71804){if((e71804 instanceof Object)){
var ex__47089__auto__ = e71804;
var statearr_71805_71863 = state_71777;
(statearr_71805_71863[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71777);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71804;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71864 = state_71777;
state_71777 = G__71864;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_71777){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_71777);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_71806 = f__47174__auto__.call(null);
(statearr_71806[(6)] = c__47173__auto__);

return statearr_71806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,jobs,results,process,async))
);

return c__47173__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__71866 = arguments.length;
switch (G__71866) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__71869 = arguments.length;
switch (G__71869) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__71872 = arguments.length;
switch (G__71872) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__47173__auto___71921 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___71921,tc,fc){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___71921,tc,fc){
return (function (state_71898){
var state_val_71899 = (state_71898[(1)]);
if((state_val_71899 === (7))){
var inst_71894 = (state_71898[(2)]);
var state_71898__$1 = state_71898;
var statearr_71900_71922 = state_71898__$1;
(statearr_71900_71922[(2)] = inst_71894);

(statearr_71900_71922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (1))){
var state_71898__$1 = state_71898;
var statearr_71901_71923 = state_71898__$1;
(statearr_71901_71923[(2)] = null);

(statearr_71901_71923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (4))){
var inst_71875 = (state_71898[(7)]);
var inst_71875__$1 = (state_71898[(2)]);
var inst_71876 = (inst_71875__$1 == null);
var state_71898__$1 = (function (){var statearr_71902 = state_71898;
(statearr_71902[(7)] = inst_71875__$1);

return statearr_71902;
})();
if(cljs.core.truth_(inst_71876)){
var statearr_71903_71924 = state_71898__$1;
(statearr_71903_71924[(1)] = (5));

} else {
var statearr_71904_71925 = state_71898__$1;
(statearr_71904_71925[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (13))){
var state_71898__$1 = state_71898;
var statearr_71905_71926 = state_71898__$1;
(statearr_71905_71926[(2)] = null);

(statearr_71905_71926[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (6))){
var inst_71875 = (state_71898[(7)]);
var inst_71881 = p.call(null,inst_71875);
var state_71898__$1 = state_71898;
if(cljs.core.truth_(inst_71881)){
var statearr_71906_71927 = state_71898__$1;
(statearr_71906_71927[(1)] = (9));

} else {
var statearr_71907_71928 = state_71898__$1;
(statearr_71907_71928[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (3))){
var inst_71896 = (state_71898[(2)]);
var state_71898__$1 = state_71898;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71898__$1,inst_71896);
} else {
if((state_val_71899 === (12))){
var state_71898__$1 = state_71898;
var statearr_71908_71929 = state_71898__$1;
(statearr_71908_71929[(2)] = null);

(statearr_71908_71929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (2))){
var state_71898__$1 = state_71898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71898__$1,(4),ch);
} else {
if((state_val_71899 === (11))){
var inst_71875 = (state_71898[(7)]);
var inst_71885 = (state_71898[(2)]);
var state_71898__$1 = state_71898;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71898__$1,(8),inst_71885,inst_71875);
} else {
if((state_val_71899 === (9))){
var state_71898__$1 = state_71898;
var statearr_71909_71930 = state_71898__$1;
(statearr_71909_71930[(2)] = tc);

(statearr_71909_71930[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (5))){
var inst_71878 = cljs.core.async.close_BANG_.call(null,tc);
var inst_71879 = cljs.core.async.close_BANG_.call(null,fc);
var state_71898__$1 = (function (){var statearr_71910 = state_71898;
(statearr_71910[(8)] = inst_71878);

return statearr_71910;
})();
var statearr_71911_71931 = state_71898__$1;
(statearr_71911_71931[(2)] = inst_71879);

(statearr_71911_71931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (14))){
var inst_71892 = (state_71898[(2)]);
var state_71898__$1 = state_71898;
var statearr_71912_71932 = state_71898__$1;
(statearr_71912_71932[(2)] = inst_71892);

(statearr_71912_71932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (10))){
var state_71898__$1 = state_71898;
var statearr_71913_71933 = state_71898__$1;
(statearr_71913_71933[(2)] = fc);

(statearr_71913_71933[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71899 === (8))){
var inst_71887 = (state_71898[(2)]);
var state_71898__$1 = state_71898;
if(cljs.core.truth_(inst_71887)){
var statearr_71914_71934 = state_71898__$1;
(statearr_71914_71934[(1)] = (12));

} else {
var statearr_71915_71935 = state_71898__$1;
(statearr_71915_71935[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___71921,tc,fc))
;
return ((function (switch__47085__auto__,c__47173__auto___71921,tc,fc){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_71916 = [null,null,null,null,null,null,null,null,null];
(statearr_71916[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_71916[(1)] = (1));

return statearr_71916;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_71898){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71898);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71917){if((e71917 instanceof Object)){
var ex__47089__auto__ = e71917;
var statearr_71918_71936 = state_71898;
(statearr_71918_71936[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71898);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71917;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71937 = state_71898;
state_71898 = G__71937;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_71898){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_71898);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___71921,tc,fc))
})();
var state__47175__auto__ = (function (){var statearr_71919 = f__47174__auto__.call(null);
(statearr_71919[(6)] = c__47173__auto___71921);

return statearr_71919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___71921,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_71958){
var state_val_71959 = (state_71958[(1)]);
if((state_val_71959 === (7))){
var inst_71954 = (state_71958[(2)]);
var state_71958__$1 = state_71958;
var statearr_71960_71978 = state_71958__$1;
(statearr_71960_71978[(2)] = inst_71954);

(statearr_71960_71978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71959 === (1))){
var inst_71938 = init;
var state_71958__$1 = (function (){var statearr_71961 = state_71958;
(statearr_71961[(7)] = inst_71938);

return statearr_71961;
})();
var statearr_71962_71979 = state_71958__$1;
(statearr_71962_71979[(2)] = null);

(statearr_71962_71979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71959 === (4))){
var inst_71941 = (state_71958[(8)]);
var inst_71941__$1 = (state_71958[(2)]);
var inst_71942 = (inst_71941__$1 == null);
var state_71958__$1 = (function (){var statearr_71963 = state_71958;
(statearr_71963[(8)] = inst_71941__$1);

return statearr_71963;
})();
if(cljs.core.truth_(inst_71942)){
var statearr_71964_71980 = state_71958__$1;
(statearr_71964_71980[(1)] = (5));

} else {
var statearr_71965_71981 = state_71958__$1;
(statearr_71965_71981[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71959 === (6))){
var inst_71941 = (state_71958[(8)]);
var inst_71945 = (state_71958[(9)]);
var inst_71938 = (state_71958[(7)]);
var inst_71945__$1 = f.call(null,inst_71938,inst_71941);
var inst_71946 = cljs.core.reduced_QMARK_.call(null,inst_71945__$1);
var state_71958__$1 = (function (){var statearr_71966 = state_71958;
(statearr_71966[(9)] = inst_71945__$1);

return statearr_71966;
})();
if(inst_71946){
var statearr_71967_71982 = state_71958__$1;
(statearr_71967_71982[(1)] = (8));

} else {
var statearr_71968_71983 = state_71958__$1;
(statearr_71968_71983[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71959 === (3))){
var inst_71956 = (state_71958[(2)]);
var state_71958__$1 = state_71958;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71958__$1,inst_71956);
} else {
if((state_val_71959 === (2))){
var state_71958__$1 = state_71958;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71958__$1,(4),ch);
} else {
if((state_val_71959 === (9))){
var inst_71945 = (state_71958[(9)]);
var inst_71938 = inst_71945;
var state_71958__$1 = (function (){var statearr_71969 = state_71958;
(statearr_71969[(7)] = inst_71938);

return statearr_71969;
})();
var statearr_71970_71984 = state_71958__$1;
(statearr_71970_71984[(2)] = null);

(statearr_71970_71984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71959 === (5))){
var inst_71938 = (state_71958[(7)]);
var state_71958__$1 = state_71958;
var statearr_71971_71985 = state_71958__$1;
(statearr_71971_71985[(2)] = inst_71938);

(statearr_71971_71985[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71959 === (10))){
var inst_71952 = (state_71958[(2)]);
var state_71958__$1 = state_71958;
var statearr_71972_71986 = state_71958__$1;
(statearr_71972_71986[(2)] = inst_71952);

(statearr_71972_71986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71959 === (8))){
var inst_71945 = (state_71958[(9)]);
var inst_71948 = cljs.core.deref.call(null,inst_71945);
var state_71958__$1 = state_71958;
var statearr_71973_71987 = state_71958__$1;
(statearr_71973_71987[(2)] = inst_71948);

(statearr_71973_71987[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__47086__auto__ = null;
var cljs$core$async$reduce_$_state_machine__47086__auto____0 = (function (){
var statearr_71974 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71974[(0)] = cljs$core$async$reduce_$_state_machine__47086__auto__);

(statearr_71974[(1)] = (1));

return statearr_71974;
});
var cljs$core$async$reduce_$_state_machine__47086__auto____1 = (function (state_71958){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71958);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71975){if((e71975 instanceof Object)){
var ex__47089__auto__ = e71975;
var statearr_71976_71988 = state_71958;
(statearr_71976_71988[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71975;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71989 = state_71958;
state_71958 = G__71989;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__47086__auto__ = function(state_71958){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__47086__auto____1.call(this,state_71958);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__47086__auto____0;
cljs$core$async$reduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__47086__auto____1;
return cljs$core$async$reduce_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_71977 = f__47174__auto__.call(null);
(statearr_71977[(6)] = c__47173__auto__);

return statearr_71977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,f__$1){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,f__$1){
return (function (state_71995){
var state_val_71996 = (state_71995[(1)]);
if((state_val_71996 === (1))){
var inst_71990 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_71995__$1 = state_71995;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71995__$1,(2),inst_71990);
} else {
if((state_val_71996 === (2))){
var inst_71992 = (state_71995[(2)]);
var inst_71993 = f__$1.call(null,inst_71992);
var state_71995__$1 = state_71995;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71995__$1,inst_71993);
} else {
return null;
}
}
});})(c__47173__auto__,f__$1))
;
return ((function (switch__47085__auto__,c__47173__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__47086__auto__ = null;
var cljs$core$async$transduce_$_state_machine__47086__auto____0 = (function (){
var statearr_71997 = [null,null,null,null,null,null,null];
(statearr_71997[(0)] = cljs$core$async$transduce_$_state_machine__47086__auto__);

(statearr_71997[(1)] = (1));

return statearr_71997;
});
var cljs$core$async$transduce_$_state_machine__47086__auto____1 = (function (state_71995){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_71995);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e71998){if((e71998 instanceof Object)){
var ex__47089__auto__ = e71998;
var statearr_71999_72001 = state_71995;
(statearr_71999_72001[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71995);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71998;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72002 = state_71995;
state_71995 = G__72002;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__47086__auto__ = function(state_71995){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__47086__auto____1.call(this,state_71995);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__47086__auto____0;
cljs$core$async$transduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__47086__auto____1;
return cljs$core$async$transduce_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,f__$1))
})();
var state__47175__auto__ = (function (){var statearr_72000 = f__47174__auto__.call(null);
(statearr_72000[(6)] = c__47173__auto__);

return statearr_72000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,f__$1))
);

return c__47173__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__72004 = arguments.length;
switch (G__72004) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_72029){
var state_val_72030 = (state_72029[(1)]);
if((state_val_72030 === (7))){
var inst_72011 = (state_72029[(2)]);
var state_72029__$1 = state_72029;
var statearr_72031_72052 = state_72029__$1;
(statearr_72031_72052[(2)] = inst_72011);

(statearr_72031_72052[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (1))){
var inst_72005 = cljs.core.seq.call(null,coll);
var inst_72006 = inst_72005;
var state_72029__$1 = (function (){var statearr_72032 = state_72029;
(statearr_72032[(7)] = inst_72006);

return statearr_72032;
})();
var statearr_72033_72053 = state_72029__$1;
(statearr_72033_72053[(2)] = null);

(statearr_72033_72053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (4))){
var inst_72006 = (state_72029[(7)]);
var inst_72009 = cljs.core.first.call(null,inst_72006);
var state_72029__$1 = state_72029;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72029__$1,(7),ch,inst_72009);
} else {
if((state_val_72030 === (13))){
var inst_72023 = (state_72029[(2)]);
var state_72029__$1 = state_72029;
var statearr_72034_72054 = state_72029__$1;
(statearr_72034_72054[(2)] = inst_72023);

(statearr_72034_72054[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (6))){
var inst_72014 = (state_72029[(2)]);
var state_72029__$1 = state_72029;
if(cljs.core.truth_(inst_72014)){
var statearr_72035_72055 = state_72029__$1;
(statearr_72035_72055[(1)] = (8));

} else {
var statearr_72036_72056 = state_72029__$1;
(statearr_72036_72056[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (3))){
var inst_72027 = (state_72029[(2)]);
var state_72029__$1 = state_72029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72029__$1,inst_72027);
} else {
if((state_val_72030 === (12))){
var state_72029__$1 = state_72029;
var statearr_72037_72057 = state_72029__$1;
(statearr_72037_72057[(2)] = null);

(statearr_72037_72057[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (2))){
var inst_72006 = (state_72029[(7)]);
var state_72029__$1 = state_72029;
if(cljs.core.truth_(inst_72006)){
var statearr_72038_72058 = state_72029__$1;
(statearr_72038_72058[(1)] = (4));

} else {
var statearr_72039_72059 = state_72029__$1;
(statearr_72039_72059[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (11))){
var inst_72020 = cljs.core.async.close_BANG_.call(null,ch);
var state_72029__$1 = state_72029;
var statearr_72040_72060 = state_72029__$1;
(statearr_72040_72060[(2)] = inst_72020);

(statearr_72040_72060[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (9))){
var state_72029__$1 = state_72029;
if(cljs.core.truth_(close_QMARK_)){
var statearr_72041_72061 = state_72029__$1;
(statearr_72041_72061[(1)] = (11));

} else {
var statearr_72042_72062 = state_72029__$1;
(statearr_72042_72062[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (5))){
var inst_72006 = (state_72029[(7)]);
var state_72029__$1 = state_72029;
var statearr_72043_72063 = state_72029__$1;
(statearr_72043_72063[(2)] = inst_72006);

(statearr_72043_72063[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (10))){
var inst_72025 = (state_72029[(2)]);
var state_72029__$1 = state_72029;
var statearr_72044_72064 = state_72029__$1;
(statearr_72044_72064[(2)] = inst_72025);

(statearr_72044_72064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (8))){
var inst_72006 = (state_72029[(7)]);
var inst_72016 = cljs.core.next.call(null,inst_72006);
var inst_72006__$1 = inst_72016;
var state_72029__$1 = (function (){var statearr_72045 = state_72029;
(statearr_72045[(7)] = inst_72006__$1);

return statearr_72045;
})();
var statearr_72046_72065 = state_72029__$1;
(statearr_72046_72065[(2)] = null);

(statearr_72046_72065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_72047 = [null,null,null,null,null,null,null,null];
(statearr_72047[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_72047[(1)] = (1));

return statearr_72047;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_72029){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_72029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e72048){if((e72048 instanceof Object)){
var ex__47089__auto__ = e72048;
var statearr_72049_72066 = state_72029;
(statearr_72049_72066[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72029);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72048;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72067 = state_72029;
state_72029 = G__72067;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_72029){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_72029);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_72050 = f__47174__auto__.call(null);
(statearr_72050[(6)] = c__47173__auto__);

return statearr_72050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28824__auto__ = (((_ == null))?null:_);
var m__28825__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,_);
} else {
var m__28825__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28825__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m);
} else {
var m__28825__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async72068 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72068 = (function (ch,cs,meta72069){
this.ch = ch;
this.cs = cs;
this.meta72069 = meta72069;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async72068.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_72070,meta72069__$1){
var self__ = this;
var _72070__$1 = this;
return (new cljs.core.async.t_cljs$core$async72068(self__.ch,self__.cs,meta72069__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async72068.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_72070){
var self__ = this;
var _72070__$1 = this;
return self__.meta72069;
});})(cs))
;


cljs.core.async.t_cljs$core$async72068.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72068.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async72068.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72068.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async72068.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async72068.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async72068.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta72069","meta72069",140253984,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async72068.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72068.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72068";

cljs.core.async.t_cljs$core$async72068.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async72068");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async72068 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async72068(ch__$1,cs__$1,meta72069){
return (new cljs.core.async.t_cljs$core$async72068(ch__$1,cs__$1,meta72069));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async72068(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__47173__auto___72290 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___72290,cs,m,dchan,dctr,done){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___72290,cs,m,dchan,dctr,done){
return (function (state_72205){
var state_val_72206 = (state_72205[(1)]);
if((state_val_72206 === (7))){
var inst_72201 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72207_72291 = state_72205__$1;
(statearr_72207_72291[(2)] = inst_72201);

(statearr_72207_72291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (20))){
var inst_72104 = (state_72205[(7)]);
var inst_72116 = cljs.core.first.call(null,inst_72104);
var inst_72117 = cljs.core.nth.call(null,inst_72116,(0),null);
var inst_72118 = cljs.core.nth.call(null,inst_72116,(1),null);
var state_72205__$1 = (function (){var statearr_72208 = state_72205;
(statearr_72208[(8)] = inst_72117);

return statearr_72208;
})();
if(cljs.core.truth_(inst_72118)){
var statearr_72209_72292 = state_72205__$1;
(statearr_72209_72292[(1)] = (22));

} else {
var statearr_72210_72293 = state_72205__$1;
(statearr_72210_72293[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (27))){
var inst_72146 = (state_72205[(9)]);
var inst_72153 = (state_72205[(10)]);
var inst_72148 = (state_72205[(11)]);
var inst_72073 = (state_72205[(12)]);
var inst_72153__$1 = cljs.core._nth.call(null,inst_72146,inst_72148);
var inst_72154 = cljs.core.async.put_BANG_.call(null,inst_72153__$1,inst_72073,done);
var state_72205__$1 = (function (){var statearr_72211 = state_72205;
(statearr_72211[(10)] = inst_72153__$1);

return statearr_72211;
})();
if(cljs.core.truth_(inst_72154)){
var statearr_72212_72294 = state_72205__$1;
(statearr_72212_72294[(1)] = (30));

} else {
var statearr_72213_72295 = state_72205__$1;
(statearr_72213_72295[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (1))){
var state_72205__$1 = state_72205;
var statearr_72214_72296 = state_72205__$1;
(statearr_72214_72296[(2)] = null);

(statearr_72214_72296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (24))){
var inst_72104 = (state_72205[(7)]);
var inst_72123 = (state_72205[(2)]);
var inst_72124 = cljs.core.next.call(null,inst_72104);
var inst_72082 = inst_72124;
var inst_72083 = null;
var inst_72084 = (0);
var inst_72085 = (0);
var state_72205__$1 = (function (){var statearr_72215 = state_72205;
(statearr_72215[(13)] = inst_72082);

(statearr_72215[(14)] = inst_72085);

(statearr_72215[(15)] = inst_72123);

(statearr_72215[(16)] = inst_72083);

(statearr_72215[(17)] = inst_72084);

return statearr_72215;
})();
var statearr_72216_72297 = state_72205__$1;
(statearr_72216_72297[(2)] = null);

(statearr_72216_72297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (39))){
var state_72205__$1 = state_72205;
var statearr_72220_72298 = state_72205__$1;
(statearr_72220_72298[(2)] = null);

(statearr_72220_72298[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (4))){
var inst_72073 = (state_72205[(12)]);
var inst_72073__$1 = (state_72205[(2)]);
var inst_72074 = (inst_72073__$1 == null);
var state_72205__$1 = (function (){var statearr_72221 = state_72205;
(statearr_72221[(12)] = inst_72073__$1);

return statearr_72221;
})();
if(cljs.core.truth_(inst_72074)){
var statearr_72222_72299 = state_72205__$1;
(statearr_72222_72299[(1)] = (5));

} else {
var statearr_72223_72300 = state_72205__$1;
(statearr_72223_72300[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (15))){
var inst_72082 = (state_72205[(13)]);
var inst_72085 = (state_72205[(14)]);
var inst_72083 = (state_72205[(16)]);
var inst_72084 = (state_72205[(17)]);
var inst_72100 = (state_72205[(2)]);
var inst_72101 = (inst_72085 + (1));
var tmp72217 = inst_72082;
var tmp72218 = inst_72083;
var tmp72219 = inst_72084;
var inst_72082__$1 = tmp72217;
var inst_72083__$1 = tmp72218;
var inst_72084__$1 = tmp72219;
var inst_72085__$1 = inst_72101;
var state_72205__$1 = (function (){var statearr_72224 = state_72205;
(statearr_72224[(13)] = inst_72082__$1);

(statearr_72224[(14)] = inst_72085__$1);

(statearr_72224[(18)] = inst_72100);

(statearr_72224[(16)] = inst_72083__$1);

(statearr_72224[(17)] = inst_72084__$1);

return statearr_72224;
})();
var statearr_72225_72301 = state_72205__$1;
(statearr_72225_72301[(2)] = null);

(statearr_72225_72301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (21))){
var inst_72127 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72229_72302 = state_72205__$1;
(statearr_72229_72302[(2)] = inst_72127);

(statearr_72229_72302[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (31))){
var inst_72153 = (state_72205[(10)]);
var inst_72157 = done.call(null,null);
var inst_72158 = cljs.core.async.untap_STAR_.call(null,m,inst_72153);
var state_72205__$1 = (function (){var statearr_72230 = state_72205;
(statearr_72230[(19)] = inst_72157);

return statearr_72230;
})();
var statearr_72231_72303 = state_72205__$1;
(statearr_72231_72303[(2)] = inst_72158);

(statearr_72231_72303[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (32))){
var inst_72146 = (state_72205[(9)]);
var inst_72147 = (state_72205[(20)]);
var inst_72145 = (state_72205[(21)]);
var inst_72148 = (state_72205[(11)]);
var inst_72160 = (state_72205[(2)]);
var inst_72161 = (inst_72148 + (1));
var tmp72226 = inst_72146;
var tmp72227 = inst_72147;
var tmp72228 = inst_72145;
var inst_72145__$1 = tmp72228;
var inst_72146__$1 = tmp72226;
var inst_72147__$1 = tmp72227;
var inst_72148__$1 = inst_72161;
var state_72205__$1 = (function (){var statearr_72232 = state_72205;
(statearr_72232[(9)] = inst_72146__$1);

(statearr_72232[(22)] = inst_72160);

(statearr_72232[(20)] = inst_72147__$1);

(statearr_72232[(21)] = inst_72145__$1);

(statearr_72232[(11)] = inst_72148__$1);

return statearr_72232;
})();
var statearr_72233_72304 = state_72205__$1;
(statearr_72233_72304[(2)] = null);

(statearr_72233_72304[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (40))){
var inst_72173 = (state_72205[(23)]);
var inst_72177 = done.call(null,null);
var inst_72178 = cljs.core.async.untap_STAR_.call(null,m,inst_72173);
var state_72205__$1 = (function (){var statearr_72234 = state_72205;
(statearr_72234[(24)] = inst_72177);

return statearr_72234;
})();
var statearr_72235_72305 = state_72205__$1;
(statearr_72235_72305[(2)] = inst_72178);

(statearr_72235_72305[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (33))){
var inst_72164 = (state_72205[(25)]);
var inst_72166 = cljs.core.chunked_seq_QMARK_.call(null,inst_72164);
var state_72205__$1 = state_72205;
if(inst_72166){
var statearr_72236_72306 = state_72205__$1;
(statearr_72236_72306[(1)] = (36));

} else {
var statearr_72237_72307 = state_72205__$1;
(statearr_72237_72307[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (13))){
var inst_72094 = (state_72205[(26)]);
var inst_72097 = cljs.core.async.close_BANG_.call(null,inst_72094);
var state_72205__$1 = state_72205;
var statearr_72238_72308 = state_72205__$1;
(statearr_72238_72308[(2)] = inst_72097);

(statearr_72238_72308[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (22))){
var inst_72117 = (state_72205[(8)]);
var inst_72120 = cljs.core.async.close_BANG_.call(null,inst_72117);
var state_72205__$1 = state_72205;
var statearr_72239_72309 = state_72205__$1;
(statearr_72239_72309[(2)] = inst_72120);

(statearr_72239_72309[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (36))){
var inst_72164 = (state_72205[(25)]);
var inst_72168 = cljs.core.chunk_first.call(null,inst_72164);
var inst_72169 = cljs.core.chunk_rest.call(null,inst_72164);
var inst_72170 = cljs.core.count.call(null,inst_72168);
var inst_72145 = inst_72169;
var inst_72146 = inst_72168;
var inst_72147 = inst_72170;
var inst_72148 = (0);
var state_72205__$1 = (function (){var statearr_72240 = state_72205;
(statearr_72240[(9)] = inst_72146);

(statearr_72240[(20)] = inst_72147);

(statearr_72240[(21)] = inst_72145);

(statearr_72240[(11)] = inst_72148);

return statearr_72240;
})();
var statearr_72241_72310 = state_72205__$1;
(statearr_72241_72310[(2)] = null);

(statearr_72241_72310[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (41))){
var inst_72164 = (state_72205[(25)]);
var inst_72180 = (state_72205[(2)]);
var inst_72181 = cljs.core.next.call(null,inst_72164);
var inst_72145 = inst_72181;
var inst_72146 = null;
var inst_72147 = (0);
var inst_72148 = (0);
var state_72205__$1 = (function (){var statearr_72242 = state_72205;
(statearr_72242[(9)] = inst_72146);

(statearr_72242[(20)] = inst_72147);

(statearr_72242[(27)] = inst_72180);

(statearr_72242[(21)] = inst_72145);

(statearr_72242[(11)] = inst_72148);

return statearr_72242;
})();
var statearr_72243_72311 = state_72205__$1;
(statearr_72243_72311[(2)] = null);

(statearr_72243_72311[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (43))){
var state_72205__$1 = state_72205;
var statearr_72244_72312 = state_72205__$1;
(statearr_72244_72312[(2)] = null);

(statearr_72244_72312[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (29))){
var inst_72189 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72245_72313 = state_72205__$1;
(statearr_72245_72313[(2)] = inst_72189);

(statearr_72245_72313[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (44))){
var inst_72198 = (state_72205[(2)]);
var state_72205__$1 = (function (){var statearr_72246 = state_72205;
(statearr_72246[(28)] = inst_72198);

return statearr_72246;
})();
var statearr_72247_72314 = state_72205__$1;
(statearr_72247_72314[(2)] = null);

(statearr_72247_72314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (6))){
var inst_72137 = (state_72205[(29)]);
var inst_72136 = cljs.core.deref.call(null,cs);
var inst_72137__$1 = cljs.core.keys.call(null,inst_72136);
var inst_72138 = cljs.core.count.call(null,inst_72137__$1);
var inst_72139 = cljs.core.reset_BANG_.call(null,dctr,inst_72138);
var inst_72144 = cljs.core.seq.call(null,inst_72137__$1);
var inst_72145 = inst_72144;
var inst_72146 = null;
var inst_72147 = (0);
var inst_72148 = (0);
var state_72205__$1 = (function (){var statearr_72248 = state_72205;
(statearr_72248[(29)] = inst_72137__$1);

(statearr_72248[(9)] = inst_72146);

(statearr_72248[(20)] = inst_72147);

(statearr_72248[(21)] = inst_72145);

(statearr_72248[(11)] = inst_72148);

(statearr_72248[(30)] = inst_72139);

return statearr_72248;
})();
var statearr_72249_72315 = state_72205__$1;
(statearr_72249_72315[(2)] = null);

(statearr_72249_72315[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (28))){
var inst_72145 = (state_72205[(21)]);
var inst_72164 = (state_72205[(25)]);
var inst_72164__$1 = cljs.core.seq.call(null,inst_72145);
var state_72205__$1 = (function (){var statearr_72250 = state_72205;
(statearr_72250[(25)] = inst_72164__$1);

return statearr_72250;
})();
if(inst_72164__$1){
var statearr_72251_72316 = state_72205__$1;
(statearr_72251_72316[(1)] = (33));

} else {
var statearr_72252_72317 = state_72205__$1;
(statearr_72252_72317[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (25))){
var inst_72147 = (state_72205[(20)]);
var inst_72148 = (state_72205[(11)]);
var inst_72150 = (inst_72148 < inst_72147);
var inst_72151 = inst_72150;
var state_72205__$1 = state_72205;
if(cljs.core.truth_(inst_72151)){
var statearr_72253_72318 = state_72205__$1;
(statearr_72253_72318[(1)] = (27));

} else {
var statearr_72254_72319 = state_72205__$1;
(statearr_72254_72319[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (34))){
var state_72205__$1 = state_72205;
var statearr_72255_72320 = state_72205__$1;
(statearr_72255_72320[(2)] = null);

(statearr_72255_72320[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (17))){
var state_72205__$1 = state_72205;
var statearr_72256_72321 = state_72205__$1;
(statearr_72256_72321[(2)] = null);

(statearr_72256_72321[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (3))){
var inst_72203 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72205__$1,inst_72203);
} else {
if((state_val_72206 === (12))){
var inst_72132 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72257_72322 = state_72205__$1;
(statearr_72257_72322[(2)] = inst_72132);

(statearr_72257_72322[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (2))){
var state_72205__$1 = state_72205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72205__$1,(4),ch);
} else {
if((state_val_72206 === (23))){
var state_72205__$1 = state_72205;
var statearr_72258_72323 = state_72205__$1;
(statearr_72258_72323[(2)] = null);

(statearr_72258_72323[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (35))){
var inst_72187 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72259_72324 = state_72205__$1;
(statearr_72259_72324[(2)] = inst_72187);

(statearr_72259_72324[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (19))){
var inst_72104 = (state_72205[(7)]);
var inst_72108 = cljs.core.chunk_first.call(null,inst_72104);
var inst_72109 = cljs.core.chunk_rest.call(null,inst_72104);
var inst_72110 = cljs.core.count.call(null,inst_72108);
var inst_72082 = inst_72109;
var inst_72083 = inst_72108;
var inst_72084 = inst_72110;
var inst_72085 = (0);
var state_72205__$1 = (function (){var statearr_72260 = state_72205;
(statearr_72260[(13)] = inst_72082);

(statearr_72260[(14)] = inst_72085);

(statearr_72260[(16)] = inst_72083);

(statearr_72260[(17)] = inst_72084);

return statearr_72260;
})();
var statearr_72261_72325 = state_72205__$1;
(statearr_72261_72325[(2)] = null);

(statearr_72261_72325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (11))){
var inst_72104 = (state_72205[(7)]);
var inst_72082 = (state_72205[(13)]);
var inst_72104__$1 = cljs.core.seq.call(null,inst_72082);
var state_72205__$1 = (function (){var statearr_72262 = state_72205;
(statearr_72262[(7)] = inst_72104__$1);

return statearr_72262;
})();
if(inst_72104__$1){
var statearr_72263_72326 = state_72205__$1;
(statearr_72263_72326[(1)] = (16));

} else {
var statearr_72264_72327 = state_72205__$1;
(statearr_72264_72327[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (9))){
var inst_72134 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72265_72328 = state_72205__$1;
(statearr_72265_72328[(2)] = inst_72134);

(statearr_72265_72328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (5))){
var inst_72080 = cljs.core.deref.call(null,cs);
var inst_72081 = cljs.core.seq.call(null,inst_72080);
var inst_72082 = inst_72081;
var inst_72083 = null;
var inst_72084 = (0);
var inst_72085 = (0);
var state_72205__$1 = (function (){var statearr_72266 = state_72205;
(statearr_72266[(13)] = inst_72082);

(statearr_72266[(14)] = inst_72085);

(statearr_72266[(16)] = inst_72083);

(statearr_72266[(17)] = inst_72084);

return statearr_72266;
})();
var statearr_72267_72329 = state_72205__$1;
(statearr_72267_72329[(2)] = null);

(statearr_72267_72329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (14))){
var state_72205__$1 = state_72205;
var statearr_72268_72330 = state_72205__$1;
(statearr_72268_72330[(2)] = null);

(statearr_72268_72330[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (45))){
var inst_72195 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72269_72331 = state_72205__$1;
(statearr_72269_72331[(2)] = inst_72195);

(statearr_72269_72331[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (26))){
var inst_72137 = (state_72205[(29)]);
var inst_72191 = (state_72205[(2)]);
var inst_72192 = cljs.core.seq.call(null,inst_72137);
var state_72205__$1 = (function (){var statearr_72270 = state_72205;
(statearr_72270[(31)] = inst_72191);

return statearr_72270;
})();
if(inst_72192){
var statearr_72271_72332 = state_72205__$1;
(statearr_72271_72332[(1)] = (42));

} else {
var statearr_72272_72333 = state_72205__$1;
(statearr_72272_72333[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (16))){
var inst_72104 = (state_72205[(7)]);
var inst_72106 = cljs.core.chunked_seq_QMARK_.call(null,inst_72104);
var state_72205__$1 = state_72205;
if(inst_72106){
var statearr_72273_72334 = state_72205__$1;
(statearr_72273_72334[(1)] = (19));

} else {
var statearr_72274_72335 = state_72205__$1;
(statearr_72274_72335[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (38))){
var inst_72184 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72275_72336 = state_72205__$1;
(statearr_72275_72336[(2)] = inst_72184);

(statearr_72275_72336[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (30))){
var state_72205__$1 = state_72205;
var statearr_72276_72337 = state_72205__$1;
(statearr_72276_72337[(2)] = null);

(statearr_72276_72337[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (10))){
var inst_72085 = (state_72205[(14)]);
var inst_72083 = (state_72205[(16)]);
var inst_72093 = cljs.core._nth.call(null,inst_72083,inst_72085);
var inst_72094 = cljs.core.nth.call(null,inst_72093,(0),null);
var inst_72095 = cljs.core.nth.call(null,inst_72093,(1),null);
var state_72205__$1 = (function (){var statearr_72277 = state_72205;
(statearr_72277[(26)] = inst_72094);

return statearr_72277;
})();
if(cljs.core.truth_(inst_72095)){
var statearr_72278_72338 = state_72205__$1;
(statearr_72278_72338[(1)] = (13));

} else {
var statearr_72279_72339 = state_72205__$1;
(statearr_72279_72339[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (18))){
var inst_72130 = (state_72205[(2)]);
var state_72205__$1 = state_72205;
var statearr_72280_72340 = state_72205__$1;
(statearr_72280_72340[(2)] = inst_72130);

(statearr_72280_72340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (42))){
var state_72205__$1 = state_72205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72205__$1,(45),dchan);
} else {
if((state_val_72206 === (37))){
var inst_72173 = (state_72205[(23)]);
var inst_72073 = (state_72205[(12)]);
var inst_72164 = (state_72205[(25)]);
var inst_72173__$1 = cljs.core.first.call(null,inst_72164);
var inst_72174 = cljs.core.async.put_BANG_.call(null,inst_72173__$1,inst_72073,done);
var state_72205__$1 = (function (){var statearr_72281 = state_72205;
(statearr_72281[(23)] = inst_72173__$1);

return statearr_72281;
})();
if(cljs.core.truth_(inst_72174)){
var statearr_72282_72341 = state_72205__$1;
(statearr_72282_72341[(1)] = (39));

} else {
var statearr_72283_72342 = state_72205__$1;
(statearr_72283_72342[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72206 === (8))){
var inst_72085 = (state_72205[(14)]);
var inst_72084 = (state_72205[(17)]);
var inst_72087 = (inst_72085 < inst_72084);
var inst_72088 = inst_72087;
var state_72205__$1 = state_72205;
if(cljs.core.truth_(inst_72088)){
var statearr_72284_72343 = state_72205__$1;
(statearr_72284_72343[(1)] = (10));

} else {
var statearr_72285_72344 = state_72205__$1;
(statearr_72285_72344[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___72290,cs,m,dchan,dctr,done))
;
return ((function (switch__47085__auto__,c__47173__auto___72290,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__47086__auto__ = null;
var cljs$core$async$mult_$_state_machine__47086__auto____0 = (function (){
var statearr_72286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72286[(0)] = cljs$core$async$mult_$_state_machine__47086__auto__);

(statearr_72286[(1)] = (1));

return statearr_72286;
});
var cljs$core$async$mult_$_state_machine__47086__auto____1 = (function (state_72205){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_72205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e72287){if((e72287 instanceof Object)){
var ex__47089__auto__ = e72287;
var statearr_72288_72345 = state_72205;
(statearr_72288_72345[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72205);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72287;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72346 = state_72205;
state_72205 = G__72346;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__47086__auto__ = function(state_72205){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__47086__auto____1.call(this,state_72205);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__47086__auto____0;
cljs$core$async$mult_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__47086__auto____1;
return cljs$core$async$mult_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___72290,cs,m,dchan,dctr,done))
})();
var state__47175__auto__ = (function (){var statearr_72289 = f__47174__auto__.call(null);
(statearr_72289[(6)] = c__47173__auto___72290);

return statearr_72289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___72290,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__72348 = arguments.length;
switch (G__72348) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m);
} else {
var m__28825__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,state_map);
} else {
var m__28825__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,mode);
} else {
var m__28825__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___72360 = arguments.length;
var i__29313__auto___72361 = (0);
while(true){
if((i__29313__auto___72361 < len__29312__auto___72360)){
args__29319__auto__.push((arguments[i__29313__auto___72361]));

var G__72362 = (i__29313__auto___72361 + (1));
i__29313__auto___72361 = G__72362;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__72354){
var map__72355 = p__72354;
var map__72355__$1 = ((((!((map__72355 == null)))?((((map__72355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72355.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72355):map__72355);
var opts = map__72355__$1;
var statearr_72357_72363 = state;
(statearr_72357_72363[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__72355,map__72355__$1,opts){
return (function (val){
var statearr_72358_72364 = state;
(statearr_72358_72364[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__72355,map__72355__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_72359_72365 = state;
(statearr_72359_72365[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq72350){
var G__72351 = cljs.core.first.call(null,seq72350);
var seq72350__$1 = cljs.core.next.call(null,seq72350);
var G__72352 = cljs.core.first.call(null,seq72350__$1);
var seq72350__$2 = cljs.core.next.call(null,seq72350__$1);
var G__72353 = cljs.core.first.call(null,seq72350__$2);
var seq72350__$3 = cljs.core.next.call(null,seq72350__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__72351,G__72352,G__72353,seq72350__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async72366 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72366 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta72367){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta72367 = meta72367;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_72368,meta72367__$1){
var self__ = this;
var _72368__$1 = this;
return (new cljs.core.async.t_cljs$core$async72366(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta72367__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_72368){
var self__ = this;
var _72368__$1 = this;
return self__.meta72367;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async72366.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72366.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta72367","meta72367",1123473381,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72366.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72366.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72366";

cljs.core.async.t_cljs$core$async72366.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async72366");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async72366 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async72366(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta72367){
return (new cljs.core.async.t_cljs$core$async72366(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta72367));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async72366(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47173__auto___72530 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___72530,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___72530,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_72470){
var state_val_72471 = (state_72470[(1)]);
if((state_val_72471 === (7))){
var inst_72385 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
var statearr_72472_72531 = state_72470__$1;
(statearr_72472_72531[(2)] = inst_72385);

(statearr_72472_72531[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (20))){
var inst_72397 = (state_72470[(7)]);
var state_72470__$1 = state_72470;
var statearr_72473_72532 = state_72470__$1;
(statearr_72473_72532[(2)] = inst_72397);

(statearr_72473_72532[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (27))){
var state_72470__$1 = state_72470;
var statearr_72474_72533 = state_72470__$1;
(statearr_72474_72533[(2)] = null);

(statearr_72474_72533[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (1))){
var inst_72372 = (state_72470[(8)]);
var inst_72372__$1 = calc_state.call(null);
var inst_72374 = (inst_72372__$1 == null);
var inst_72375 = cljs.core.not.call(null,inst_72374);
var state_72470__$1 = (function (){var statearr_72475 = state_72470;
(statearr_72475[(8)] = inst_72372__$1);

return statearr_72475;
})();
if(inst_72375){
var statearr_72476_72534 = state_72470__$1;
(statearr_72476_72534[(1)] = (2));

} else {
var statearr_72477_72535 = state_72470__$1;
(statearr_72477_72535[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (24))){
var inst_72430 = (state_72470[(9)]);
var inst_72421 = (state_72470[(10)]);
var inst_72444 = (state_72470[(11)]);
var inst_72444__$1 = inst_72421.call(null,inst_72430);
var state_72470__$1 = (function (){var statearr_72478 = state_72470;
(statearr_72478[(11)] = inst_72444__$1);

return statearr_72478;
})();
if(cljs.core.truth_(inst_72444__$1)){
var statearr_72479_72536 = state_72470__$1;
(statearr_72479_72536[(1)] = (29));

} else {
var statearr_72480_72537 = state_72470__$1;
(statearr_72480_72537[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (4))){
var inst_72388 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
if(cljs.core.truth_(inst_72388)){
var statearr_72481_72538 = state_72470__$1;
(statearr_72481_72538[(1)] = (8));

} else {
var statearr_72482_72539 = state_72470__$1;
(statearr_72482_72539[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (15))){
var inst_72415 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
if(cljs.core.truth_(inst_72415)){
var statearr_72483_72540 = state_72470__$1;
(statearr_72483_72540[(1)] = (19));

} else {
var statearr_72484_72541 = state_72470__$1;
(statearr_72484_72541[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (21))){
var inst_72420 = (state_72470[(12)]);
var inst_72420__$1 = (state_72470[(2)]);
var inst_72421 = cljs.core.get.call(null,inst_72420__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_72422 = cljs.core.get.call(null,inst_72420__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_72423 = cljs.core.get.call(null,inst_72420__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_72470__$1 = (function (){var statearr_72485 = state_72470;
(statearr_72485[(12)] = inst_72420__$1);

(statearr_72485[(10)] = inst_72421);

(statearr_72485[(13)] = inst_72422);

return statearr_72485;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_72470__$1,(22),inst_72423);
} else {
if((state_val_72471 === (31))){
var inst_72452 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
if(cljs.core.truth_(inst_72452)){
var statearr_72486_72542 = state_72470__$1;
(statearr_72486_72542[(1)] = (32));

} else {
var statearr_72487_72543 = state_72470__$1;
(statearr_72487_72543[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (32))){
var inst_72429 = (state_72470[(14)]);
var state_72470__$1 = state_72470;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72470__$1,(35),out,inst_72429);
} else {
if((state_val_72471 === (33))){
var inst_72420 = (state_72470[(12)]);
var inst_72397 = inst_72420;
var state_72470__$1 = (function (){var statearr_72488 = state_72470;
(statearr_72488[(7)] = inst_72397);

return statearr_72488;
})();
var statearr_72489_72544 = state_72470__$1;
(statearr_72489_72544[(2)] = null);

(statearr_72489_72544[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (13))){
var inst_72397 = (state_72470[(7)]);
var inst_72404 = inst_72397.cljs$lang$protocol_mask$partition0$;
var inst_72405 = (inst_72404 & (64));
var inst_72406 = inst_72397.cljs$core$ISeq$;
var inst_72407 = (cljs.core.PROTOCOL_SENTINEL === inst_72406);
var inst_72408 = (inst_72405) || (inst_72407);
var state_72470__$1 = state_72470;
if(cljs.core.truth_(inst_72408)){
var statearr_72490_72545 = state_72470__$1;
(statearr_72490_72545[(1)] = (16));

} else {
var statearr_72491_72546 = state_72470__$1;
(statearr_72491_72546[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (22))){
var inst_72430 = (state_72470[(9)]);
var inst_72429 = (state_72470[(14)]);
var inst_72428 = (state_72470[(2)]);
var inst_72429__$1 = cljs.core.nth.call(null,inst_72428,(0),null);
var inst_72430__$1 = cljs.core.nth.call(null,inst_72428,(1),null);
var inst_72431 = (inst_72429__$1 == null);
var inst_72432 = cljs.core._EQ_.call(null,inst_72430__$1,change);
var inst_72433 = (inst_72431) || (inst_72432);
var state_72470__$1 = (function (){var statearr_72492 = state_72470;
(statearr_72492[(9)] = inst_72430__$1);

(statearr_72492[(14)] = inst_72429__$1);

return statearr_72492;
})();
if(cljs.core.truth_(inst_72433)){
var statearr_72493_72547 = state_72470__$1;
(statearr_72493_72547[(1)] = (23));

} else {
var statearr_72494_72548 = state_72470__$1;
(statearr_72494_72548[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (36))){
var inst_72420 = (state_72470[(12)]);
var inst_72397 = inst_72420;
var state_72470__$1 = (function (){var statearr_72495 = state_72470;
(statearr_72495[(7)] = inst_72397);

return statearr_72495;
})();
var statearr_72496_72549 = state_72470__$1;
(statearr_72496_72549[(2)] = null);

(statearr_72496_72549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (29))){
var inst_72444 = (state_72470[(11)]);
var state_72470__$1 = state_72470;
var statearr_72497_72550 = state_72470__$1;
(statearr_72497_72550[(2)] = inst_72444);

(statearr_72497_72550[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (6))){
var state_72470__$1 = state_72470;
var statearr_72498_72551 = state_72470__$1;
(statearr_72498_72551[(2)] = false);

(statearr_72498_72551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (28))){
var inst_72440 = (state_72470[(2)]);
var inst_72441 = calc_state.call(null);
var inst_72397 = inst_72441;
var state_72470__$1 = (function (){var statearr_72499 = state_72470;
(statearr_72499[(7)] = inst_72397);

(statearr_72499[(15)] = inst_72440);

return statearr_72499;
})();
var statearr_72500_72552 = state_72470__$1;
(statearr_72500_72552[(2)] = null);

(statearr_72500_72552[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (25))){
var inst_72466 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
var statearr_72501_72553 = state_72470__$1;
(statearr_72501_72553[(2)] = inst_72466);

(statearr_72501_72553[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (34))){
var inst_72464 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
var statearr_72502_72554 = state_72470__$1;
(statearr_72502_72554[(2)] = inst_72464);

(statearr_72502_72554[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (17))){
var state_72470__$1 = state_72470;
var statearr_72503_72555 = state_72470__$1;
(statearr_72503_72555[(2)] = false);

(statearr_72503_72555[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (3))){
var state_72470__$1 = state_72470;
var statearr_72504_72556 = state_72470__$1;
(statearr_72504_72556[(2)] = false);

(statearr_72504_72556[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (12))){
var inst_72468 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72470__$1,inst_72468);
} else {
if((state_val_72471 === (2))){
var inst_72372 = (state_72470[(8)]);
var inst_72377 = inst_72372.cljs$lang$protocol_mask$partition0$;
var inst_72378 = (inst_72377 & (64));
var inst_72379 = inst_72372.cljs$core$ISeq$;
var inst_72380 = (cljs.core.PROTOCOL_SENTINEL === inst_72379);
var inst_72381 = (inst_72378) || (inst_72380);
var state_72470__$1 = state_72470;
if(cljs.core.truth_(inst_72381)){
var statearr_72505_72557 = state_72470__$1;
(statearr_72505_72557[(1)] = (5));

} else {
var statearr_72506_72558 = state_72470__$1;
(statearr_72506_72558[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (23))){
var inst_72429 = (state_72470[(14)]);
var inst_72435 = (inst_72429 == null);
var state_72470__$1 = state_72470;
if(cljs.core.truth_(inst_72435)){
var statearr_72507_72559 = state_72470__$1;
(statearr_72507_72559[(1)] = (26));

} else {
var statearr_72508_72560 = state_72470__$1;
(statearr_72508_72560[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (35))){
var inst_72455 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
if(cljs.core.truth_(inst_72455)){
var statearr_72509_72561 = state_72470__$1;
(statearr_72509_72561[(1)] = (36));

} else {
var statearr_72510_72562 = state_72470__$1;
(statearr_72510_72562[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (19))){
var inst_72397 = (state_72470[(7)]);
var inst_72417 = cljs.core.apply.call(null,cljs.core.hash_map,inst_72397);
var state_72470__$1 = state_72470;
var statearr_72511_72563 = state_72470__$1;
(statearr_72511_72563[(2)] = inst_72417);

(statearr_72511_72563[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (11))){
var inst_72397 = (state_72470[(7)]);
var inst_72401 = (inst_72397 == null);
var inst_72402 = cljs.core.not.call(null,inst_72401);
var state_72470__$1 = state_72470;
if(inst_72402){
var statearr_72512_72564 = state_72470__$1;
(statearr_72512_72564[(1)] = (13));

} else {
var statearr_72513_72565 = state_72470__$1;
(statearr_72513_72565[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (9))){
var inst_72372 = (state_72470[(8)]);
var state_72470__$1 = state_72470;
var statearr_72514_72566 = state_72470__$1;
(statearr_72514_72566[(2)] = inst_72372);

(statearr_72514_72566[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (5))){
var state_72470__$1 = state_72470;
var statearr_72515_72567 = state_72470__$1;
(statearr_72515_72567[(2)] = true);

(statearr_72515_72567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (14))){
var state_72470__$1 = state_72470;
var statearr_72516_72568 = state_72470__$1;
(statearr_72516_72568[(2)] = false);

(statearr_72516_72568[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (26))){
var inst_72430 = (state_72470[(9)]);
var inst_72437 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_72430);
var state_72470__$1 = state_72470;
var statearr_72517_72569 = state_72470__$1;
(statearr_72517_72569[(2)] = inst_72437);

(statearr_72517_72569[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (16))){
var state_72470__$1 = state_72470;
var statearr_72518_72570 = state_72470__$1;
(statearr_72518_72570[(2)] = true);

(statearr_72518_72570[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (38))){
var inst_72460 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
var statearr_72519_72571 = state_72470__$1;
(statearr_72519_72571[(2)] = inst_72460);

(statearr_72519_72571[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (30))){
var inst_72430 = (state_72470[(9)]);
var inst_72421 = (state_72470[(10)]);
var inst_72422 = (state_72470[(13)]);
var inst_72447 = cljs.core.empty_QMARK_.call(null,inst_72421);
var inst_72448 = inst_72422.call(null,inst_72430);
var inst_72449 = cljs.core.not.call(null,inst_72448);
var inst_72450 = (inst_72447) && (inst_72449);
var state_72470__$1 = state_72470;
var statearr_72520_72572 = state_72470__$1;
(statearr_72520_72572[(2)] = inst_72450);

(statearr_72520_72572[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (10))){
var inst_72372 = (state_72470[(8)]);
var inst_72393 = (state_72470[(2)]);
var inst_72394 = cljs.core.get.call(null,inst_72393,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_72395 = cljs.core.get.call(null,inst_72393,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_72396 = cljs.core.get.call(null,inst_72393,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_72397 = inst_72372;
var state_72470__$1 = (function (){var statearr_72521 = state_72470;
(statearr_72521[(16)] = inst_72395);

(statearr_72521[(17)] = inst_72394);

(statearr_72521[(18)] = inst_72396);

(statearr_72521[(7)] = inst_72397);

return statearr_72521;
})();
var statearr_72522_72573 = state_72470__$1;
(statearr_72522_72573[(2)] = null);

(statearr_72522_72573[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (18))){
var inst_72412 = (state_72470[(2)]);
var state_72470__$1 = state_72470;
var statearr_72523_72574 = state_72470__$1;
(statearr_72523_72574[(2)] = inst_72412);

(statearr_72523_72574[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (37))){
var state_72470__$1 = state_72470;
var statearr_72524_72575 = state_72470__$1;
(statearr_72524_72575[(2)] = null);

(statearr_72524_72575[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72471 === (8))){
var inst_72372 = (state_72470[(8)]);
var inst_72390 = cljs.core.apply.call(null,cljs.core.hash_map,inst_72372);
var state_72470__$1 = state_72470;
var statearr_72525_72576 = state_72470__$1;
(statearr_72525_72576[(2)] = inst_72390);

(statearr_72525_72576[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___72530,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__47085__auto__,c__47173__auto___72530,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__47086__auto__ = null;
var cljs$core$async$mix_$_state_machine__47086__auto____0 = (function (){
var statearr_72526 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72526[(0)] = cljs$core$async$mix_$_state_machine__47086__auto__);

(statearr_72526[(1)] = (1));

return statearr_72526;
});
var cljs$core$async$mix_$_state_machine__47086__auto____1 = (function (state_72470){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_72470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e72527){if((e72527 instanceof Object)){
var ex__47089__auto__ = e72527;
var statearr_72528_72577 = state_72470;
(statearr_72528_72577[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72527;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72578 = state_72470;
state_72470 = G__72578;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__47086__auto__ = function(state_72470){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__47086__auto____1.call(this,state_72470);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__47086__auto____0;
cljs$core$async$mix_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__47086__auto____1;
return cljs$core$async$mix_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___72530,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__47175__auto__ = (function (){var statearr_72529 = f__47174__auto__.call(null);
(statearr_72529[(6)] = c__47173__auto___72530);

return statearr_72529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___72530,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28825__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__72580 = arguments.length;
switch (G__72580) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__72584 = arguments.length;
switch (G__72584) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28141__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28141__auto__,mults){
return (function (p1__72582_SHARP_){
if(cljs.core.truth_(p1__72582_SHARP_.call(null,topic))){
return p1__72582_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__72582_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28141__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async72585 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72585 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta72586){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta72586 = meta72586;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_72587,meta72586__$1){
var self__ = this;
var _72587__$1 = this;
return (new cljs.core.async.t_cljs$core$async72585(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta72586__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_72587){
var self__ = this;
var _72587__$1 = this;
return self__.meta72586;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async72585.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72585.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta72586","meta72586",-2030540201,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72585.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72585.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72585";

cljs.core.async.t_cljs$core$async72585.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async72585");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async72585 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async72585(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta72586){
return (new cljs.core.async.t_cljs$core$async72585(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta72586));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async72585(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47173__auto___72705 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___72705,mults,ensure_mult,p){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___72705,mults,ensure_mult,p){
return (function (state_72659){
var state_val_72660 = (state_72659[(1)]);
if((state_val_72660 === (7))){
var inst_72655 = (state_72659[(2)]);
var state_72659__$1 = state_72659;
var statearr_72661_72706 = state_72659__$1;
(statearr_72661_72706[(2)] = inst_72655);

(statearr_72661_72706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (20))){
var state_72659__$1 = state_72659;
var statearr_72662_72707 = state_72659__$1;
(statearr_72662_72707[(2)] = null);

(statearr_72662_72707[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (1))){
var state_72659__$1 = state_72659;
var statearr_72663_72708 = state_72659__$1;
(statearr_72663_72708[(2)] = null);

(statearr_72663_72708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (24))){
var inst_72638 = (state_72659[(7)]);
var inst_72647 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_72638);
var state_72659__$1 = state_72659;
var statearr_72664_72709 = state_72659__$1;
(statearr_72664_72709[(2)] = inst_72647);

(statearr_72664_72709[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (4))){
var inst_72590 = (state_72659[(8)]);
var inst_72590__$1 = (state_72659[(2)]);
var inst_72591 = (inst_72590__$1 == null);
var state_72659__$1 = (function (){var statearr_72665 = state_72659;
(statearr_72665[(8)] = inst_72590__$1);

return statearr_72665;
})();
if(cljs.core.truth_(inst_72591)){
var statearr_72666_72710 = state_72659__$1;
(statearr_72666_72710[(1)] = (5));

} else {
var statearr_72667_72711 = state_72659__$1;
(statearr_72667_72711[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (15))){
var inst_72632 = (state_72659[(2)]);
var state_72659__$1 = state_72659;
var statearr_72668_72712 = state_72659__$1;
(statearr_72668_72712[(2)] = inst_72632);

(statearr_72668_72712[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (21))){
var inst_72652 = (state_72659[(2)]);
var state_72659__$1 = (function (){var statearr_72669 = state_72659;
(statearr_72669[(9)] = inst_72652);

return statearr_72669;
})();
var statearr_72670_72713 = state_72659__$1;
(statearr_72670_72713[(2)] = null);

(statearr_72670_72713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (13))){
var inst_72614 = (state_72659[(10)]);
var inst_72616 = cljs.core.chunked_seq_QMARK_.call(null,inst_72614);
var state_72659__$1 = state_72659;
if(inst_72616){
var statearr_72671_72714 = state_72659__$1;
(statearr_72671_72714[(1)] = (16));

} else {
var statearr_72672_72715 = state_72659__$1;
(statearr_72672_72715[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (22))){
var inst_72644 = (state_72659[(2)]);
var state_72659__$1 = state_72659;
if(cljs.core.truth_(inst_72644)){
var statearr_72673_72716 = state_72659__$1;
(statearr_72673_72716[(1)] = (23));

} else {
var statearr_72674_72717 = state_72659__$1;
(statearr_72674_72717[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (6))){
var inst_72640 = (state_72659[(11)]);
var inst_72590 = (state_72659[(8)]);
var inst_72638 = (state_72659[(7)]);
var inst_72638__$1 = topic_fn.call(null,inst_72590);
var inst_72639 = cljs.core.deref.call(null,mults);
var inst_72640__$1 = cljs.core.get.call(null,inst_72639,inst_72638__$1);
var state_72659__$1 = (function (){var statearr_72675 = state_72659;
(statearr_72675[(11)] = inst_72640__$1);

(statearr_72675[(7)] = inst_72638__$1);

return statearr_72675;
})();
if(cljs.core.truth_(inst_72640__$1)){
var statearr_72676_72718 = state_72659__$1;
(statearr_72676_72718[(1)] = (19));

} else {
var statearr_72677_72719 = state_72659__$1;
(statearr_72677_72719[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (25))){
var inst_72649 = (state_72659[(2)]);
var state_72659__$1 = state_72659;
var statearr_72678_72720 = state_72659__$1;
(statearr_72678_72720[(2)] = inst_72649);

(statearr_72678_72720[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (17))){
var inst_72614 = (state_72659[(10)]);
var inst_72623 = cljs.core.first.call(null,inst_72614);
var inst_72624 = cljs.core.async.muxch_STAR_.call(null,inst_72623);
var inst_72625 = cljs.core.async.close_BANG_.call(null,inst_72624);
var inst_72626 = cljs.core.next.call(null,inst_72614);
var inst_72600 = inst_72626;
var inst_72601 = null;
var inst_72602 = (0);
var inst_72603 = (0);
var state_72659__$1 = (function (){var statearr_72679 = state_72659;
(statearr_72679[(12)] = inst_72602);

(statearr_72679[(13)] = inst_72601);

(statearr_72679[(14)] = inst_72625);

(statearr_72679[(15)] = inst_72600);

(statearr_72679[(16)] = inst_72603);

return statearr_72679;
})();
var statearr_72680_72721 = state_72659__$1;
(statearr_72680_72721[(2)] = null);

(statearr_72680_72721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (3))){
var inst_72657 = (state_72659[(2)]);
var state_72659__$1 = state_72659;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72659__$1,inst_72657);
} else {
if((state_val_72660 === (12))){
var inst_72634 = (state_72659[(2)]);
var state_72659__$1 = state_72659;
var statearr_72681_72722 = state_72659__$1;
(statearr_72681_72722[(2)] = inst_72634);

(statearr_72681_72722[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (2))){
var state_72659__$1 = state_72659;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72659__$1,(4),ch);
} else {
if((state_val_72660 === (23))){
var state_72659__$1 = state_72659;
var statearr_72682_72723 = state_72659__$1;
(statearr_72682_72723[(2)] = null);

(statearr_72682_72723[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (19))){
var inst_72640 = (state_72659[(11)]);
var inst_72590 = (state_72659[(8)]);
var inst_72642 = cljs.core.async.muxch_STAR_.call(null,inst_72640);
var state_72659__$1 = state_72659;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72659__$1,(22),inst_72642,inst_72590);
} else {
if((state_val_72660 === (11))){
var inst_72600 = (state_72659[(15)]);
var inst_72614 = (state_72659[(10)]);
var inst_72614__$1 = cljs.core.seq.call(null,inst_72600);
var state_72659__$1 = (function (){var statearr_72683 = state_72659;
(statearr_72683[(10)] = inst_72614__$1);

return statearr_72683;
})();
if(inst_72614__$1){
var statearr_72684_72724 = state_72659__$1;
(statearr_72684_72724[(1)] = (13));

} else {
var statearr_72685_72725 = state_72659__$1;
(statearr_72685_72725[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (9))){
var inst_72636 = (state_72659[(2)]);
var state_72659__$1 = state_72659;
var statearr_72686_72726 = state_72659__$1;
(statearr_72686_72726[(2)] = inst_72636);

(statearr_72686_72726[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (5))){
var inst_72597 = cljs.core.deref.call(null,mults);
var inst_72598 = cljs.core.vals.call(null,inst_72597);
var inst_72599 = cljs.core.seq.call(null,inst_72598);
var inst_72600 = inst_72599;
var inst_72601 = null;
var inst_72602 = (0);
var inst_72603 = (0);
var state_72659__$1 = (function (){var statearr_72687 = state_72659;
(statearr_72687[(12)] = inst_72602);

(statearr_72687[(13)] = inst_72601);

(statearr_72687[(15)] = inst_72600);

(statearr_72687[(16)] = inst_72603);

return statearr_72687;
})();
var statearr_72688_72727 = state_72659__$1;
(statearr_72688_72727[(2)] = null);

(statearr_72688_72727[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (14))){
var state_72659__$1 = state_72659;
var statearr_72692_72728 = state_72659__$1;
(statearr_72692_72728[(2)] = null);

(statearr_72692_72728[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (16))){
var inst_72614 = (state_72659[(10)]);
var inst_72618 = cljs.core.chunk_first.call(null,inst_72614);
var inst_72619 = cljs.core.chunk_rest.call(null,inst_72614);
var inst_72620 = cljs.core.count.call(null,inst_72618);
var inst_72600 = inst_72619;
var inst_72601 = inst_72618;
var inst_72602 = inst_72620;
var inst_72603 = (0);
var state_72659__$1 = (function (){var statearr_72693 = state_72659;
(statearr_72693[(12)] = inst_72602);

(statearr_72693[(13)] = inst_72601);

(statearr_72693[(15)] = inst_72600);

(statearr_72693[(16)] = inst_72603);

return statearr_72693;
})();
var statearr_72694_72729 = state_72659__$1;
(statearr_72694_72729[(2)] = null);

(statearr_72694_72729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (10))){
var inst_72602 = (state_72659[(12)]);
var inst_72601 = (state_72659[(13)]);
var inst_72600 = (state_72659[(15)]);
var inst_72603 = (state_72659[(16)]);
var inst_72608 = cljs.core._nth.call(null,inst_72601,inst_72603);
var inst_72609 = cljs.core.async.muxch_STAR_.call(null,inst_72608);
var inst_72610 = cljs.core.async.close_BANG_.call(null,inst_72609);
var inst_72611 = (inst_72603 + (1));
var tmp72689 = inst_72602;
var tmp72690 = inst_72601;
var tmp72691 = inst_72600;
var inst_72600__$1 = tmp72691;
var inst_72601__$1 = tmp72690;
var inst_72602__$1 = tmp72689;
var inst_72603__$1 = inst_72611;
var state_72659__$1 = (function (){var statearr_72695 = state_72659;
(statearr_72695[(12)] = inst_72602__$1);

(statearr_72695[(13)] = inst_72601__$1);

(statearr_72695[(15)] = inst_72600__$1);

(statearr_72695[(17)] = inst_72610);

(statearr_72695[(16)] = inst_72603__$1);

return statearr_72695;
})();
var statearr_72696_72730 = state_72659__$1;
(statearr_72696_72730[(2)] = null);

(statearr_72696_72730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (18))){
var inst_72629 = (state_72659[(2)]);
var state_72659__$1 = state_72659;
var statearr_72697_72731 = state_72659__$1;
(statearr_72697_72731[(2)] = inst_72629);

(statearr_72697_72731[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72660 === (8))){
var inst_72602 = (state_72659[(12)]);
var inst_72603 = (state_72659[(16)]);
var inst_72605 = (inst_72603 < inst_72602);
var inst_72606 = inst_72605;
var state_72659__$1 = state_72659;
if(cljs.core.truth_(inst_72606)){
var statearr_72698_72732 = state_72659__$1;
(statearr_72698_72732[(1)] = (10));

} else {
var statearr_72699_72733 = state_72659__$1;
(statearr_72699_72733[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___72705,mults,ensure_mult,p))
;
return ((function (switch__47085__auto__,c__47173__auto___72705,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_72700 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72700[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_72700[(1)] = (1));

return statearr_72700;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_72659){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_72659);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e72701){if((e72701 instanceof Object)){
var ex__47089__auto__ = e72701;
var statearr_72702_72734 = state_72659;
(statearr_72702_72734[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72659);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72701;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72735 = state_72659;
state_72659 = G__72735;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_72659){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_72659);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___72705,mults,ensure_mult,p))
})();
var state__47175__auto__ = (function (){var statearr_72703 = f__47174__auto__.call(null);
(statearr_72703[(6)] = c__47173__auto___72705);

return statearr_72703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___72705,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__72737 = arguments.length;
switch (G__72737) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__72740 = arguments.length;
switch (G__72740) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__72743 = arguments.length;
switch (G__72743) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__47173__auto___72810 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___72810,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___72810,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_72782){
var state_val_72783 = (state_72782[(1)]);
if((state_val_72783 === (7))){
var state_72782__$1 = state_72782;
var statearr_72784_72811 = state_72782__$1;
(statearr_72784_72811[(2)] = null);

(statearr_72784_72811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (1))){
var state_72782__$1 = state_72782;
var statearr_72785_72812 = state_72782__$1;
(statearr_72785_72812[(2)] = null);

(statearr_72785_72812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (4))){
var inst_72746 = (state_72782[(7)]);
var inst_72748 = (inst_72746 < cnt);
var state_72782__$1 = state_72782;
if(cljs.core.truth_(inst_72748)){
var statearr_72786_72813 = state_72782__$1;
(statearr_72786_72813[(1)] = (6));

} else {
var statearr_72787_72814 = state_72782__$1;
(statearr_72787_72814[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (15))){
var inst_72778 = (state_72782[(2)]);
var state_72782__$1 = state_72782;
var statearr_72788_72815 = state_72782__$1;
(statearr_72788_72815[(2)] = inst_72778);

(statearr_72788_72815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (13))){
var inst_72771 = cljs.core.async.close_BANG_.call(null,out);
var state_72782__$1 = state_72782;
var statearr_72789_72816 = state_72782__$1;
(statearr_72789_72816[(2)] = inst_72771);

(statearr_72789_72816[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (6))){
var state_72782__$1 = state_72782;
var statearr_72790_72817 = state_72782__$1;
(statearr_72790_72817[(2)] = null);

(statearr_72790_72817[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (3))){
var inst_72780 = (state_72782[(2)]);
var state_72782__$1 = state_72782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72782__$1,inst_72780);
} else {
if((state_val_72783 === (12))){
var inst_72768 = (state_72782[(8)]);
var inst_72768__$1 = (state_72782[(2)]);
var inst_72769 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_72768__$1);
var state_72782__$1 = (function (){var statearr_72791 = state_72782;
(statearr_72791[(8)] = inst_72768__$1);

return statearr_72791;
})();
if(cljs.core.truth_(inst_72769)){
var statearr_72792_72818 = state_72782__$1;
(statearr_72792_72818[(1)] = (13));

} else {
var statearr_72793_72819 = state_72782__$1;
(statearr_72793_72819[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (2))){
var inst_72745 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_72746 = (0);
var state_72782__$1 = (function (){var statearr_72794 = state_72782;
(statearr_72794[(9)] = inst_72745);

(statearr_72794[(7)] = inst_72746);

return statearr_72794;
})();
var statearr_72795_72820 = state_72782__$1;
(statearr_72795_72820[(2)] = null);

(statearr_72795_72820[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (11))){
var inst_72746 = (state_72782[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_72782,(10),Object,null,(9));
var inst_72755 = chs__$1.call(null,inst_72746);
var inst_72756 = done.call(null,inst_72746);
var inst_72757 = cljs.core.async.take_BANG_.call(null,inst_72755,inst_72756);
var state_72782__$1 = state_72782;
var statearr_72796_72821 = state_72782__$1;
(statearr_72796_72821[(2)] = inst_72757);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72782__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (9))){
var inst_72746 = (state_72782[(7)]);
var inst_72759 = (state_72782[(2)]);
var inst_72760 = (inst_72746 + (1));
var inst_72746__$1 = inst_72760;
var state_72782__$1 = (function (){var statearr_72797 = state_72782;
(statearr_72797[(10)] = inst_72759);

(statearr_72797[(7)] = inst_72746__$1);

return statearr_72797;
})();
var statearr_72798_72822 = state_72782__$1;
(statearr_72798_72822[(2)] = null);

(statearr_72798_72822[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (5))){
var inst_72766 = (state_72782[(2)]);
var state_72782__$1 = (function (){var statearr_72799 = state_72782;
(statearr_72799[(11)] = inst_72766);

return statearr_72799;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72782__$1,(12),dchan);
} else {
if((state_val_72783 === (14))){
var inst_72768 = (state_72782[(8)]);
var inst_72773 = cljs.core.apply.call(null,f,inst_72768);
var state_72782__$1 = state_72782;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72782__$1,(16),out,inst_72773);
} else {
if((state_val_72783 === (16))){
var inst_72775 = (state_72782[(2)]);
var state_72782__$1 = (function (){var statearr_72800 = state_72782;
(statearr_72800[(12)] = inst_72775);

return statearr_72800;
})();
var statearr_72801_72823 = state_72782__$1;
(statearr_72801_72823[(2)] = null);

(statearr_72801_72823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (10))){
var inst_72750 = (state_72782[(2)]);
var inst_72751 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_72782__$1 = (function (){var statearr_72802 = state_72782;
(statearr_72802[(13)] = inst_72750);

return statearr_72802;
})();
var statearr_72803_72824 = state_72782__$1;
(statearr_72803_72824[(2)] = inst_72751);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72782__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72783 === (8))){
var inst_72764 = (state_72782[(2)]);
var state_72782__$1 = state_72782;
var statearr_72804_72825 = state_72782__$1;
(statearr_72804_72825[(2)] = inst_72764);

(statearr_72804_72825[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___72810,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__47085__auto__,c__47173__auto___72810,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_72805 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72805[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_72805[(1)] = (1));

return statearr_72805;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_72782){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_72782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e72806){if((e72806 instanceof Object)){
var ex__47089__auto__ = e72806;
var statearr_72807_72826 = state_72782;
(statearr_72807_72826[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72782);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72827 = state_72782;
state_72782 = G__72827;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_72782){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_72782);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___72810,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__47175__auto__ = (function (){var statearr_72808 = f__47174__auto__.call(null);
(statearr_72808[(6)] = c__47173__auto___72810);

return statearr_72808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___72810,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__72830 = arguments.length;
switch (G__72830) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___72884 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___72884,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___72884,out){
return (function (state_72862){
var state_val_72863 = (state_72862[(1)]);
if((state_val_72863 === (7))){
var inst_72841 = (state_72862[(7)]);
var inst_72842 = (state_72862[(8)]);
var inst_72841__$1 = (state_72862[(2)]);
var inst_72842__$1 = cljs.core.nth.call(null,inst_72841__$1,(0),null);
var inst_72843 = cljs.core.nth.call(null,inst_72841__$1,(1),null);
var inst_72844 = (inst_72842__$1 == null);
var state_72862__$1 = (function (){var statearr_72864 = state_72862;
(statearr_72864[(9)] = inst_72843);

(statearr_72864[(7)] = inst_72841__$1);

(statearr_72864[(8)] = inst_72842__$1);

return statearr_72864;
})();
if(cljs.core.truth_(inst_72844)){
var statearr_72865_72885 = state_72862__$1;
(statearr_72865_72885[(1)] = (8));

} else {
var statearr_72866_72886 = state_72862__$1;
(statearr_72866_72886[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72863 === (1))){
var inst_72831 = cljs.core.vec.call(null,chs);
var inst_72832 = inst_72831;
var state_72862__$1 = (function (){var statearr_72867 = state_72862;
(statearr_72867[(10)] = inst_72832);

return statearr_72867;
})();
var statearr_72868_72887 = state_72862__$1;
(statearr_72868_72887[(2)] = null);

(statearr_72868_72887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72863 === (4))){
var inst_72832 = (state_72862[(10)]);
var state_72862__$1 = state_72862;
return cljs.core.async.ioc_alts_BANG_.call(null,state_72862__$1,(7),inst_72832);
} else {
if((state_val_72863 === (6))){
var inst_72858 = (state_72862[(2)]);
var state_72862__$1 = state_72862;
var statearr_72869_72888 = state_72862__$1;
(statearr_72869_72888[(2)] = inst_72858);

(statearr_72869_72888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72863 === (3))){
var inst_72860 = (state_72862[(2)]);
var state_72862__$1 = state_72862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72862__$1,inst_72860);
} else {
if((state_val_72863 === (2))){
var inst_72832 = (state_72862[(10)]);
var inst_72834 = cljs.core.count.call(null,inst_72832);
var inst_72835 = (inst_72834 > (0));
var state_72862__$1 = state_72862;
if(cljs.core.truth_(inst_72835)){
var statearr_72871_72889 = state_72862__$1;
(statearr_72871_72889[(1)] = (4));

} else {
var statearr_72872_72890 = state_72862__$1;
(statearr_72872_72890[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72863 === (11))){
var inst_72832 = (state_72862[(10)]);
var inst_72851 = (state_72862[(2)]);
var tmp72870 = inst_72832;
var inst_72832__$1 = tmp72870;
var state_72862__$1 = (function (){var statearr_72873 = state_72862;
(statearr_72873[(10)] = inst_72832__$1);

(statearr_72873[(11)] = inst_72851);

return statearr_72873;
})();
var statearr_72874_72891 = state_72862__$1;
(statearr_72874_72891[(2)] = null);

(statearr_72874_72891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72863 === (9))){
var inst_72842 = (state_72862[(8)]);
var state_72862__$1 = state_72862;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72862__$1,(11),out,inst_72842);
} else {
if((state_val_72863 === (5))){
var inst_72856 = cljs.core.async.close_BANG_.call(null,out);
var state_72862__$1 = state_72862;
var statearr_72875_72892 = state_72862__$1;
(statearr_72875_72892[(2)] = inst_72856);

(statearr_72875_72892[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72863 === (10))){
var inst_72854 = (state_72862[(2)]);
var state_72862__$1 = state_72862;
var statearr_72876_72893 = state_72862__$1;
(statearr_72876_72893[(2)] = inst_72854);

(statearr_72876_72893[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72863 === (8))){
var inst_72843 = (state_72862[(9)]);
var inst_72832 = (state_72862[(10)]);
var inst_72841 = (state_72862[(7)]);
var inst_72842 = (state_72862[(8)]);
var inst_72846 = (function (){var cs = inst_72832;
var vec__72837 = inst_72841;
var v = inst_72842;
var c = inst_72843;
return ((function (cs,vec__72837,v,c,inst_72843,inst_72832,inst_72841,inst_72842,state_val_72863,c__47173__auto___72884,out){
return (function (p1__72828_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__72828_SHARP_);
});
;})(cs,vec__72837,v,c,inst_72843,inst_72832,inst_72841,inst_72842,state_val_72863,c__47173__auto___72884,out))
})();
var inst_72847 = cljs.core.filterv.call(null,inst_72846,inst_72832);
var inst_72832__$1 = inst_72847;
var state_72862__$1 = (function (){var statearr_72877 = state_72862;
(statearr_72877[(10)] = inst_72832__$1);

return statearr_72877;
})();
var statearr_72878_72894 = state_72862__$1;
(statearr_72878_72894[(2)] = null);

(statearr_72878_72894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___72884,out))
;
return ((function (switch__47085__auto__,c__47173__auto___72884,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_72879 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72879[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_72879[(1)] = (1));

return statearr_72879;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_72862){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_72862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e72880){if((e72880 instanceof Object)){
var ex__47089__auto__ = e72880;
var statearr_72881_72895 = state_72862;
(statearr_72881_72895[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72862);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72880;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72896 = state_72862;
state_72862 = G__72896;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_72862){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_72862);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___72884,out))
})();
var state__47175__auto__ = (function (){var statearr_72882 = f__47174__auto__.call(null);
(statearr_72882[(6)] = c__47173__auto___72884);

return statearr_72882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___72884,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__72898 = arguments.length;
switch (G__72898) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___72943 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___72943,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___72943,out){
return (function (state_72922){
var state_val_72923 = (state_72922[(1)]);
if((state_val_72923 === (7))){
var inst_72904 = (state_72922[(7)]);
var inst_72904__$1 = (state_72922[(2)]);
var inst_72905 = (inst_72904__$1 == null);
var inst_72906 = cljs.core.not.call(null,inst_72905);
var state_72922__$1 = (function (){var statearr_72924 = state_72922;
(statearr_72924[(7)] = inst_72904__$1);

return statearr_72924;
})();
if(inst_72906){
var statearr_72925_72944 = state_72922__$1;
(statearr_72925_72944[(1)] = (8));

} else {
var statearr_72926_72945 = state_72922__$1;
(statearr_72926_72945[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72923 === (1))){
var inst_72899 = (0);
var state_72922__$1 = (function (){var statearr_72927 = state_72922;
(statearr_72927[(8)] = inst_72899);

return statearr_72927;
})();
var statearr_72928_72946 = state_72922__$1;
(statearr_72928_72946[(2)] = null);

(statearr_72928_72946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72923 === (4))){
var state_72922__$1 = state_72922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72922__$1,(7),ch);
} else {
if((state_val_72923 === (6))){
var inst_72917 = (state_72922[(2)]);
var state_72922__$1 = state_72922;
var statearr_72929_72947 = state_72922__$1;
(statearr_72929_72947[(2)] = inst_72917);

(statearr_72929_72947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72923 === (3))){
var inst_72919 = (state_72922[(2)]);
var inst_72920 = cljs.core.async.close_BANG_.call(null,out);
var state_72922__$1 = (function (){var statearr_72930 = state_72922;
(statearr_72930[(9)] = inst_72919);

return statearr_72930;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72922__$1,inst_72920);
} else {
if((state_val_72923 === (2))){
var inst_72899 = (state_72922[(8)]);
var inst_72901 = (inst_72899 < n);
var state_72922__$1 = state_72922;
if(cljs.core.truth_(inst_72901)){
var statearr_72931_72948 = state_72922__$1;
(statearr_72931_72948[(1)] = (4));

} else {
var statearr_72932_72949 = state_72922__$1;
(statearr_72932_72949[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72923 === (11))){
var inst_72899 = (state_72922[(8)]);
var inst_72909 = (state_72922[(2)]);
var inst_72910 = (inst_72899 + (1));
var inst_72899__$1 = inst_72910;
var state_72922__$1 = (function (){var statearr_72933 = state_72922;
(statearr_72933[(10)] = inst_72909);

(statearr_72933[(8)] = inst_72899__$1);

return statearr_72933;
})();
var statearr_72934_72950 = state_72922__$1;
(statearr_72934_72950[(2)] = null);

(statearr_72934_72950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72923 === (9))){
var state_72922__$1 = state_72922;
var statearr_72935_72951 = state_72922__$1;
(statearr_72935_72951[(2)] = null);

(statearr_72935_72951[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72923 === (5))){
var state_72922__$1 = state_72922;
var statearr_72936_72952 = state_72922__$1;
(statearr_72936_72952[(2)] = null);

(statearr_72936_72952[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72923 === (10))){
var inst_72914 = (state_72922[(2)]);
var state_72922__$1 = state_72922;
var statearr_72937_72953 = state_72922__$1;
(statearr_72937_72953[(2)] = inst_72914);

(statearr_72937_72953[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72923 === (8))){
var inst_72904 = (state_72922[(7)]);
var state_72922__$1 = state_72922;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72922__$1,(11),out,inst_72904);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___72943,out))
;
return ((function (switch__47085__auto__,c__47173__auto___72943,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_72938 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72938[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_72938[(1)] = (1));

return statearr_72938;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_72922){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_72922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e72939){if((e72939 instanceof Object)){
var ex__47089__auto__ = e72939;
var statearr_72940_72954 = state_72922;
(statearr_72940_72954[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72922);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72939;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72955 = state_72922;
state_72922 = G__72955;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_72922){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_72922);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___72943,out))
})();
var state__47175__auto__ = (function (){var statearr_72941 = f__47174__auto__.call(null);
(statearr_72941[(6)] = c__47173__auto___72943);

return statearr_72941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___72943,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async72957 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72957 = (function (f,ch,meta72958){
this.f = f;
this.ch = ch;
this.meta72958 = meta72958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72959,meta72958__$1){
var self__ = this;
var _72959__$1 = this;
return (new cljs.core.async.t_cljs$core$async72957(self__.f,self__.ch,meta72958__$1));
});


cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72959){
var self__ = this;
var _72959__$1 = this;
return self__.meta72958;
});


cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async72960 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72960 = (function (f,ch,meta72958,_,fn1,meta72961){
this.f = f;
this.ch = ch;
this.meta72958 = meta72958;
this._ = _;
this.fn1 = fn1;
this.meta72961 = meta72961;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async72960.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_72962,meta72961__$1){
var self__ = this;
var _72962__$1 = this;
return (new cljs.core.async.t_cljs$core$async72960(self__.f,self__.ch,self__.meta72958,self__._,self__.fn1,meta72961__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async72960.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_72962){
var self__ = this;
var _72962__$1 = this;
return self__.meta72961;
});})(___$1))
;


cljs.core.async.t_cljs$core$async72960.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72960.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async72960.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async72960.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__72956_SHARP_){
return f1.call(null,(((p1__72956_SHARP_ == null))?null:self__.f.call(null,p1__72956_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async72960.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72958","meta72958",746453676,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async72957","cljs.core.async/t_cljs$core$async72957",1028988395,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta72961","meta72961",-1982622809,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async72960.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72960.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72960";

cljs.core.async.t_cljs$core$async72960.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async72960");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async72960 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async72960(f__$1,ch__$1,meta72958__$1,___$2,fn1__$1,meta72961){
return (new cljs.core.async.t_cljs$core$async72960(f__$1,ch__$1,meta72958__$1,___$2,fn1__$1,meta72961));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async72960(self__.f,self__.ch,self__.meta72958,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28129__auto__ = ret;
if(cljs.core.truth_(and__28129__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28129__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72957.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async72957.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72958","meta72958",746453676,null)], null);
});

cljs.core.async.t_cljs$core$async72957.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72957.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72957";

cljs.core.async.t_cljs$core$async72957.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async72957");
});

cljs.core.async.__GT_t_cljs$core$async72957 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async72957(f__$1,ch__$1,meta72958){
return (new cljs.core.async.t_cljs$core$async72957(f__$1,ch__$1,meta72958));
});

}

return (new cljs.core.async.t_cljs$core$async72957(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async72963 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72963 = (function (f,ch,meta72964){
this.f = f;
this.ch = ch;
this.meta72964 = meta72964;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async72963.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72965,meta72964__$1){
var self__ = this;
var _72965__$1 = this;
return (new cljs.core.async.t_cljs$core$async72963(self__.f,self__.ch,meta72964__$1));
});


cljs.core.async.t_cljs$core$async72963.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72965){
var self__ = this;
var _72965__$1 = this;
return self__.meta72964;
});


cljs.core.async.t_cljs$core$async72963.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72963.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async72963.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72963.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async72963.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72963.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async72963.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72964","meta72964",210188429,null)], null);
});

cljs.core.async.t_cljs$core$async72963.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72963.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72963";

cljs.core.async.t_cljs$core$async72963.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async72963");
});

cljs.core.async.__GT_t_cljs$core$async72963 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async72963(f__$1,ch__$1,meta72964){
return (new cljs.core.async.t_cljs$core$async72963(f__$1,ch__$1,meta72964));
});

}

return (new cljs.core.async.t_cljs$core$async72963(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async72966 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72966 = (function (p,ch,meta72967){
this.p = p;
this.ch = ch;
this.meta72967 = meta72967;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_72968,meta72967__$1){
var self__ = this;
var _72968__$1 = this;
return (new cljs.core.async.t_cljs$core$async72966(self__.p,self__.ch,meta72967__$1));
});


cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_72968){
var self__ = this;
var _72968__$1 = this;
return self__.meta72967;
});


cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async72966.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async72966.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta72967","meta72967",-933456976,null)], null);
});

cljs.core.async.t_cljs$core$async72966.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72966.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72966";

cljs.core.async.t_cljs$core$async72966.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async72966");
});

cljs.core.async.__GT_t_cljs$core$async72966 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async72966(p__$1,ch__$1,meta72967){
return (new cljs.core.async.t_cljs$core$async72966(p__$1,ch__$1,meta72967));
});

}

return (new cljs.core.async.t_cljs$core$async72966(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__72970 = arguments.length;
switch (G__72970) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___73010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___73010,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___73010,out){
return (function (state_72991){
var state_val_72992 = (state_72991[(1)]);
if((state_val_72992 === (7))){
var inst_72987 = (state_72991[(2)]);
var state_72991__$1 = state_72991;
var statearr_72993_73011 = state_72991__$1;
(statearr_72993_73011[(2)] = inst_72987);

(statearr_72993_73011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72992 === (1))){
var state_72991__$1 = state_72991;
var statearr_72994_73012 = state_72991__$1;
(statearr_72994_73012[(2)] = null);

(statearr_72994_73012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72992 === (4))){
var inst_72973 = (state_72991[(7)]);
var inst_72973__$1 = (state_72991[(2)]);
var inst_72974 = (inst_72973__$1 == null);
var state_72991__$1 = (function (){var statearr_72995 = state_72991;
(statearr_72995[(7)] = inst_72973__$1);

return statearr_72995;
})();
if(cljs.core.truth_(inst_72974)){
var statearr_72996_73013 = state_72991__$1;
(statearr_72996_73013[(1)] = (5));

} else {
var statearr_72997_73014 = state_72991__$1;
(statearr_72997_73014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72992 === (6))){
var inst_72973 = (state_72991[(7)]);
var inst_72978 = p.call(null,inst_72973);
var state_72991__$1 = state_72991;
if(cljs.core.truth_(inst_72978)){
var statearr_72998_73015 = state_72991__$1;
(statearr_72998_73015[(1)] = (8));

} else {
var statearr_72999_73016 = state_72991__$1;
(statearr_72999_73016[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72992 === (3))){
var inst_72989 = (state_72991[(2)]);
var state_72991__$1 = state_72991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72991__$1,inst_72989);
} else {
if((state_val_72992 === (2))){
var state_72991__$1 = state_72991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72991__$1,(4),ch);
} else {
if((state_val_72992 === (11))){
var inst_72981 = (state_72991[(2)]);
var state_72991__$1 = state_72991;
var statearr_73000_73017 = state_72991__$1;
(statearr_73000_73017[(2)] = inst_72981);

(statearr_73000_73017[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72992 === (9))){
var state_72991__$1 = state_72991;
var statearr_73001_73018 = state_72991__$1;
(statearr_73001_73018[(2)] = null);

(statearr_73001_73018[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72992 === (5))){
var inst_72976 = cljs.core.async.close_BANG_.call(null,out);
var state_72991__$1 = state_72991;
var statearr_73002_73019 = state_72991__$1;
(statearr_73002_73019[(2)] = inst_72976);

(statearr_73002_73019[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72992 === (10))){
var inst_72984 = (state_72991[(2)]);
var state_72991__$1 = (function (){var statearr_73003 = state_72991;
(statearr_73003[(8)] = inst_72984);

return statearr_73003;
})();
var statearr_73004_73020 = state_72991__$1;
(statearr_73004_73020[(2)] = null);

(statearr_73004_73020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72992 === (8))){
var inst_72973 = (state_72991[(7)]);
var state_72991__$1 = state_72991;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72991__$1,(11),out,inst_72973);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___73010,out))
;
return ((function (switch__47085__auto__,c__47173__auto___73010,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_73005 = [null,null,null,null,null,null,null,null,null];
(statearr_73005[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_73005[(1)] = (1));

return statearr_73005;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_72991){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_72991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73006){if((e73006 instanceof Object)){
var ex__47089__auto__ = e73006;
var statearr_73007_73021 = state_72991;
(statearr_73007_73021[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72991);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73022 = state_72991;
state_72991 = G__73022;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_72991){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_72991);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___73010,out))
})();
var state__47175__auto__ = (function (){var statearr_73008 = f__47174__auto__.call(null);
(statearr_73008[(6)] = c__47173__auto___73010);

return statearr_73008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___73010,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__73024 = arguments.length;
switch (G__73024) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_73087){
var state_val_73088 = (state_73087[(1)]);
if((state_val_73088 === (7))){
var inst_73083 = (state_73087[(2)]);
var state_73087__$1 = state_73087;
var statearr_73089_73127 = state_73087__$1;
(statearr_73089_73127[(2)] = inst_73083);

(statearr_73089_73127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (20))){
var inst_73053 = (state_73087[(7)]);
var inst_73064 = (state_73087[(2)]);
var inst_73065 = cljs.core.next.call(null,inst_73053);
var inst_73039 = inst_73065;
var inst_73040 = null;
var inst_73041 = (0);
var inst_73042 = (0);
var state_73087__$1 = (function (){var statearr_73090 = state_73087;
(statearr_73090[(8)] = inst_73041);

(statearr_73090[(9)] = inst_73040);

(statearr_73090[(10)] = inst_73064);

(statearr_73090[(11)] = inst_73042);

(statearr_73090[(12)] = inst_73039);

return statearr_73090;
})();
var statearr_73091_73128 = state_73087__$1;
(statearr_73091_73128[(2)] = null);

(statearr_73091_73128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (1))){
var state_73087__$1 = state_73087;
var statearr_73092_73129 = state_73087__$1;
(statearr_73092_73129[(2)] = null);

(statearr_73092_73129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (4))){
var inst_73028 = (state_73087[(13)]);
var inst_73028__$1 = (state_73087[(2)]);
var inst_73029 = (inst_73028__$1 == null);
var state_73087__$1 = (function (){var statearr_73093 = state_73087;
(statearr_73093[(13)] = inst_73028__$1);

return statearr_73093;
})();
if(cljs.core.truth_(inst_73029)){
var statearr_73094_73130 = state_73087__$1;
(statearr_73094_73130[(1)] = (5));

} else {
var statearr_73095_73131 = state_73087__$1;
(statearr_73095_73131[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (15))){
var state_73087__$1 = state_73087;
var statearr_73099_73132 = state_73087__$1;
(statearr_73099_73132[(2)] = null);

(statearr_73099_73132[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (21))){
var state_73087__$1 = state_73087;
var statearr_73100_73133 = state_73087__$1;
(statearr_73100_73133[(2)] = null);

(statearr_73100_73133[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (13))){
var inst_73041 = (state_73087[(8)]);
var inst_73040 = (state_73087[(9)]);
var inst_73042 = (state_73087[(11)]);
var inst_73039 = (state_73087[(12)]);
var inst_73049 = (state_73087[(2)]);
var inst_73050 = (inst_73042 + (1));
var tmp73096 = inst_73041;
var tmp73097 = inst_73040;
var tmp73098 = inst_73039;
var inst_73039__$1 = tmp73098;
var inst_73040__$1 = tmp73097;
var inst_73041__$1 = tmp73096;
var inst_73042__$1 = inst_73050;
var state_73087__$1 = (function (){var statearr_73101 = state_73087;
(statearr_73101[(8)] = inst_73041__$1);

(statearr_73101[(9)] = inst_73040__$1);

(statearr_73101[(14)] = inst_73049);

(statearr_73101[(11)] = inst_73042__$1);

(statearr_73101[(12)] = inst_73039__$1);

return statearr_73101;
})();
var statearr_73102_73134 = state_73087__$1;
(statearr_73102_73134[(2)] = null);

(statearr_73102_73134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (22))){
var state_73087__$1 = state_73087;
var statearr_73103_73135 = state_73087__$1;
(statearr_73103_73135[(2)] = null);

(statearr_73103_73135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (6))){
var inst_73028 = (state_73087[(13)]);
var inst_73037 = f.call(null,inst_73028);
var inst_73038 = cljs.core.seq.call(null,inst_73037);
var inst_73039 = inst_73038;
var inst_73040 = null;
var inst_73041 = (0);
var inst_73042 = (0);
var state_73087__$1 = (function (){var statearr_73104 = state_73087;
(statearr_73104[(8)] = inst_73041);

(statearr_73104[(9)] = inst_73040);

(statearr_73104[(11)] = inst_73042);

(statearr_73104[(12)] = inst_73039);

return statearr_73104;
})();
var statearr_73105_73136 = state_73087__$1;
(statearr_73105_73136[(2)] = null);

(statearr_73105_73136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (17))){
var inst_73053 = (state_73087[(7)]);
var inst_73057 = cljs.core.chunk_first.call(null,inst_73053);
var inst_73058 = cljs.core.chunk_rest.call(null,inst_73053);
var inst_73059 = cljs.core.count.call(null,inst_73057);
var inst_73039 = inst_73058;
var inst_73040 = inst_73057;
var inst_73041 = inst_73059;
var inst_73042 = (0);
var state_73087__$1 = (function (){var statearr_73106 = state_73087;
(statearr_73106[(8)] = inst_73041);

(statearr_73106[(9)] = inst_73040);

(statearr_73106[(11)] = inst_73042);

(statearr_73106[(12)] = inst_73039);

return statearr_73106;
})();
var statearr_73107_73137 = state_73087__$1;
(statearr_73107_73137[(2)] = null);

(statearr_73107_73137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (3))){
var inst_73085 = (state_73087[(2)]);
var state_73087__$1 = state_73087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73087__$1,inst_73085);
} else {
if((state_val_73088 === (12))){
var inst_73073 = (state_73087[(2)]);
var state_73087__$1 = state_73087;
var statearr_73108_73138 = state_73087__$1;
(statearr_73108_73138[(2)] = inst_73073);

(statearr_73108_73138[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (2))){
var state_73087__$1 = state_73087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73087__$1,(4),in$);
} else {
if((state_val_73088 === (23))){
var inst_73081 = (state_73087[(2)]);
var state_73087__$1 = state_73087;
var statearr_73109_73139 = state_73087__$1;
(statearr_73109_73139[(2)] = inst_73081);

(statearr_73109_73139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (19))){
var inst_73068 = (state_73087[(2)]);
var state_73087__$1 = state_73087;
var statearr_73110_73140 = state_73087__$1;
(statearr_73110_73140[(2)] = inst_73068);

(statearr_73110_73140[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (11))){
var inst_73053 = (state_73087[(7)]);
var inst_73039 = (state_73087[(12)]);
var inst_73053__$1 = cljs.core.seq.call(null,inst_73039);
var state_73087__$1 = (function (){var statearr_73111 = state_73087;
(statearr_73111[(7)] = inst_73053__$1);

return statearr_73111;
})();
if(inst_73053__$1){
var statearr_73112_73141 = state_73087__$1;
(statearr_73112_73141[(1)] = (14));

} else {
var statearr_73113_73142 = state_73087__$1;
(statearr_73113_73142[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (9))){
var inst_73075 = (state_73087[(2)]);
var inst_73076 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_73087__$1 = (function (){var statearr_73114 = state_73087;
(statearr_73114[(15)] = inst_73075);

return statearr_73114;
})();
if(cljs.core.truth_(inst_73076)){
var statearr_73115_73143 = state_73087__$1;
(statearr_73115_73143[(1)] = (21));

} else {
var statearr_73116_73144 = state_73087__$1;
(statearr_73116_73144[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (5))){
var inst_73031 = cljs.core.async.close_BANG_.call(null,out);
var state_73087__$1 = state_73087;
var statearr_73117_73145 = state_73087__$1;
(statearr_73117_73145[(2)] = inst_73031);

(statearr_73117_73145[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (14))){
var inst_73053 = (state_73087[(7)]);
var inst_73055 = cljs.core.chunked_seq_QMARK_.call(null,inst_73053);
var state_73087__$1 = state_73087;
if(inst_73055){
var statearr_73118_73146 = state_73087__$1;
(statearr_73118_73146[(1)] = (17));

} else {
var statearr_73119_73147 = state_73087__$1;
(statearr_73119_73147[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (16))){
var inst_73071 = (state_73087[(2)]);
var state_73087__$1 = state_73087;
var statearr_73120_73148 = state_73087__$1;
(statearr_73120_73148[(2)] = inst_73071);

(statearr_73120_73148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73088 === (10))){
var inst_73040 = (state_73087[(9)]);
var inst_73042 = (state_73087[(11)]);
var inst_73047 = cljs.core._nth.call(null,inst_73040,inst_73042);
var state_73087__$1 = state_73087;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73087__$1,(13),out,inst_73047);
} else {
if((state_val_73088 === (18))){
var inst_73053 = (state_73087[(7)]);
var inst_73062 = cljs.core.first.call(null,inst_73053);
var state_73087__$1 = state_73087;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73087__$1,(20),out,inst_73062);
} else {
if((state_val_73088 === (8))){
var inst_73041 = (state_73087[(8)]);
var inst_73042 = (state_73087[(11)]);
var inst_73044 = (inst_73042 < inst_73041);
var inst_73045 = inst_73044;
var state_73087__$1 = state_73087;
if(cljs.core.truth_(inst_73045)){
var statearr_73121_73149 = state_73087__$1;
(statearr_73121_73149[(1)] = (10));

} else {
var statearr_73122_73150 = state_73087__$1;
(statearr_73122_73150[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_73123 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73123[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__);

(statearr_73123[(1)] = (1));

return statearr_73123;
});
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1 = (function (state_73087){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73124){if((e73124 instanceof Object)){
var ex__47089__auto__ = e73124;
var statearr_73125_73151 = state_73087;
(statearr_73125_73151[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73087);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73124;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73152 = state_73087;
state_73087 = G__73152;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__ = function(state_73087){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1.call(this,state_73087);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_73126 = f__47174__auto__.call(null);
(statearr_73126[(6)] = c__47173__auto__);

return statearr_73126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__73154 = arguments.length;
switch (G__73154) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__73157 = arguments.length;
switch (G__73157) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__73160 = arguments.length;
switch (G__73160) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___73207 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___73207,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___73207,out){
return (function (state_73184){
var state_val_73185 = (state_73184[(1)]);
if((state_val_73185 === (7))){
var inst_73179 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
var statearr_73186_73208 = state_73184__$1;
(statearr_73186_73208[(2)] = inst_73179);

(statearr_73186_73208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (1))){
var inst_73161 = null;
var state_73184__$1 = (function (){var statearr_73187 = state_73184;
(statearr_73187[(7)] = inst_73161);

return statearr_73187;
})();
var statearr_73188_73209 = state_73184__$1;
(statearr_73188_73209[(2)] = null);

(statearr_73188_73209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (4))){
var inst_73164 = (state_73184[(8)]);
var inst_73164__$1 = (state_73184[(2)]);
var inst_73165 = (inst_73164__$1 == null);
var inst_73166 = cljs.core.not.call(null,inst_73165);
var state_73184__$1 = (function (){var statearr_73189 = state_73184;
(statearr_73189[(8)] = inst_73164__$1);

return statearr_73189;
})();
if(inst_73166){
var statearr_73190_73210 = state_73184__$1;
(statearr_73190_73210[(1)] = (5));

} else {
var statearr_73191_73211 = state_73184__$1;
(statearr_73191_73211[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (6))){
var state_73184__$1 = state_73184;
var statearr_73192_73212 = state_73184__$1;
(statearr_73192_73212[(2)] = null);

(statearr_73192_73212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (3))){
var inst_73181 = (state_73184[(2)]);
var inst_73182 = cljs.core.async.close_BANG_.call(null,out);
var state_73184__$1 = (function (){var statearr_73193 = state_73184;
(statearr_73193[(9)] = inst_73181);

return statearr_73193;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73184__$1,inst_73182);
} else {
if((state_val_73185 === (2))){
var state_73184__$1 = state_73184;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73184__$1,(4),ch);
} else {
if((state_val_73185 === (11))){
var inst_73164 = (state_73184[(8)]);
var inst_73173 = (state_73184[(2)]);
var inst_73161 = inst_73164;
var state_73184__$1 = (function (){var statearr_73194 = state_73184;
(statearr_73194[(7)] = inst_73161);

(statearr_73194[(10)] = inst_73173);

return statearr_73194;
})();
var statearr_73195_73213 = state_73184__$1;
(statearr_73195_73213[(2)] = null);

(statearr_73195_73213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (9))){
var inst_73164 = (state_73184[(8)]);
var state_73184__$1 = state_73184;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73184__$1,(11),out,inst_73164);
} else {
if((state_val_73185 === (5))){
var inst_73161 = (state_73184[(7)]);
var inst_73164 = (state_73184[(8)]);
var inst_73168 = cljs.core._EQ_.call(null,inst_73164,inst_73161);
var state_73184__$1 = state_73184;
if(inst_73168){
var statearr_73197_73214 = state_73184__$1;
(statearr_73197_73214[(1)] = (8));

} else {
var statearr_73198_73215 = state_73184__$1;
(statearr_73198_73215[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (10))){
var inst_73176 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
var statearr_73199_73216 = state_73184__$1;
(statearr_73199_73216[(2)] = inst_73176);

(statearr_73199_73216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (8))){
var inst_73161 = (state_73184[(7)]);
var tmp73196 = inst_73161;
var inst_73161__$1 = tmp73196;
var state_73184__$1 = (function (){var statearr_73200 = state_73184;
(statearr_73200[(7)] = inst_73161__$1);

return statearr_73200;
})();
var statearr_73201_73217 = state_73184__$1;
(statearr_73201_73217[(2)] = null);

(statearr_73201_73217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___73207,out))
;
return ((function (switch__47085__auto__,c__47173__auto___73207,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_73202 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73202[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_73202[(1)] = (1));

return statearr_73202;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_73184){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73203){if((e73203 instanceof Object)){
var ex__47089__auto__ = e73203;
var statearr_73204_73218 = state_73184;
(statearr_73204_73218[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73184);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73203;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73219 = state_73184;
state_73184 = G__73219;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_73184){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_73184);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___73207,out))
})();
var state__47175__auto__ = (function (){var statearr_73205 = f__47174__auto__.call(null);
(statearr_73205[(6)] = c__47173__auto___73207);

return statearr_73205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___73207,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__73221 = arguments.length;
switch (G__73221) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___73287 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___73287,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___73287,out){
return (function (state_73259){
var state_val_73260 = (state_73259[(1)]);
if((state_val_73260 === (7))){
var inst_73255 = (state_73259[(2)]);
var state_73259__$1 = state_73259;
var statearr_73261_73288 = state_73259__$1;
(statearr_73261_73288[(2)] = inst_73255);

(statearr_73261_73288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (1))){
var inst_73222 = (new Array(n));
var inst_73223 = inst_73222;
var inst_73224 = (0);
var state_73259__$1 = (function (){var statearr_73262 = state_73259;
(statearr_73262[(7)] = inst_73224);

(statearr_73262[(8)] = inst_73223);

return statearr_73262;
})();
var statearr_73263_73289 = state_73259__$1;
(statearr_73263_73289[(2)] = null);

(statearr_73263_73289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (4))){
var inst_73227 = (state_73259[(9)]);
var inst_73227__$1 = (state_73259[(2)]);
var inst_73228 = (inst_73227__$1 == null);
var inst_73229 = cljs.core.not.call(null,inst_73228);
var state_73259__$1 = (function (){var statearr_73264 = state_73259;
(statearr_73264[(9)] = inst_73227__$1);

return statearr_73264;
})();
if(inst_73229){
var statearr_73265_73290 = state_73259__$1;
(statearr_73265_73290[(1)] = (5));

} else {
var statearr_73266_73291 = state_73259__$1;
(statearr_73266_73291[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (15))){
var inst_73249 = (state_73259[(2)]);
var state_73259__$1 = state_73259;
var statearr_73267_73292 = state_73259__$1;
(statearr_73267_73292[(2)] = inst_73249);

(statearr_73267_73292[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (13))){
var state_73259__$1 = state_73259;
var statearr_73268_73293 = state_73259__$1;
(statearr_73268_73293[(2)] = null);

(statearr_73268_73293[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (6))){
var inst_73224 = (state_73259[(7)]);
var inst_73245 = (inst_73224 > (0));
var state_73259__$1 = state_73259;
if(cljs.core.truth_(inst_73245)){
var statearr_73269_73294 = state_73259__$1;
(statearr_73269_73294[(1)] = (12));

} else {
var statearr_73270_73295 = state_73259__$1;
(statearr_73270_73295[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (3))){
var inst_73257 = (state_73259[(2)]);
var state_73259__$1 = state_73259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73259__$1,inst_73257);
} else {
if((state_val_73260 === (12))){
var inst_73223 = (state_73259[(8)]);
var inst_73247 = cljs.core.vec.call(null,inst_73223);
var state_73259__$1 = state_73259;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73259__$1,(15),out,inst_73247);
} else {
if((state_val_73260 === (2))){
var state_73259__$1 = state_73259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73259__$1,(4),ch);
} else {
if((state_val_73260 === (11))){
var inst_73239 = (state_73259[(2)]);
var inst_73240 = (new Array(n));
var inst_73223 = inst_73240;
var inst_73224 = (0);
var state_73259__$1 = (function (){var statearr_73271 = state_73259;
(statearr_73271[(7)] = inst_73224);

(statearr_73271[(8)] = inst_73223);

(statearr_73271[(10)] = inst_73239);

return statearr_73271;
})();
var statearr_73272_73296 = state_73259__$1;
(statearr_73272_73296[(2)] = null);

(statearr_73272_73296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (9))){
var inst_73223 = (state_73259[(8)]);
var inst_73237 = cljs.core.vec.call(null,inst_73223);
var state_73259__$1 = state_73259;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73259__$1,(11),out,inst_73237);
} else {
if((state_val_73260 === (5))){
var inst_73227 = (state_73259[(9)]);
var inst_73224 = (state_73259[(7)]);
var inst_73223 = (state_73259[(8)]);
var inst_73232 = (state_73259[(11)]);
var inst_73231 = (inst_73223[inst_73224] = inst_73227);
var inst_73232__$1 = (inst_73224 + (1));
var inst_73233 = (inst_73232__$1 < n);
var state_73259__$1 = (function (){var statearr_73273 = state_73259;
(statearr_73273[(12)] = inst_73231);

(statearr_73273[(11)] = inst_73232__$1);

return statearr_73273;
})();
if(cljs.core.truth_(inst_73233)){
var statearr_73274_73297 = state_73259__$1;
(statearr_73274_73297[(1)] = (8));

} else {
var statearr_73275_73298 = state_73259__$1;
(statearr_73275_73298[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (14))){
var inst_73252 = (state_73259[(2)]);
var inst_73253 = cljs.core.async.close_BANG_.call(null,out);
var state_73259__$1 = (function (){var statearr_73277 = state_73259;
(statearr_73277[(13)] = inst_73252);

return statearr_73277;
})();
var statearr_73278_73299 = state_73259__$1;
(statearr_73278_73299[(2)] = inst_73253);

(statearr_73278_73299[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (10))){
var inst_73243 = (state_73259[(2)]);
var state_73259__$1 = state_73259;
var statearr_73279_73300 = state_73259__$1;
(statearr_73279_73300[(2)] = inst_73243);

(statearr_73279_73300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73260 === (8))){
var inst_73223 = (state_73259[(8)]);
var inst_73232 = (state_73259[(11)]);
var tmp73276 = inst_73223;
var inst_73223__$1 = tmp73276;
var inst_73224 = inst_73232;
var state_73259__$1 = (function (){var statearr_73280 = state_73259;
(statearr_73280[(7)] = inst_73224);

(statearr_73280[(8)] = inst_73223__$1);

return statearr_73280;
})();
var statearr_73281_73301 = state_73259__$1;
(statearr_73281_73301[(2)] = null);

(statearr_73281_73301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___73287,out))
;
return ((function (switch__47085__auto__,c__47173__auto___73287,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_73282 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73282[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_73282[(1)] = (1));

return statearr_73282;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_73259){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73283){if((e73283 instanceof Object)){
var ex__47089__auto__ = e73283;
var statearr_73284_73302 = state_73259;
(statearr_73284_73302[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73259);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73283;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73303 = state_73259;
state_73259 = G__73303;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_73259){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_73259);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___73287,out))
})();
var state__47175__auto__ = (function (){var statearr_73285 = f__47174__auto__.call(null);
(statearr_73285[(6)] = c__47173__auto___73287);

return statearr_73285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___73287,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__73305 = arguments.length;
switch (G__73305) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___73375 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___73375,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___73375,out){
return (function (state_73347){
var state_val_73348 = (state_73347[(1)]);
if((state_val_73348 === (7))){
var inst_73343 = (state_73347[(2)]);
var state_73347__$1 = state_73347;
var statearr_73349_73376 = state_73347__$1;
(statearr_73349_73376[(2)] = inst_73343);

(statearr_73349_73376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (1))){
var inst_73306 = [];
var inst_73307 = inst_73306;
var inst_73308 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_73347__$1 = (function (){var statearr_73350 = state_73347;
(statearr_73350[(7)] = inst_73307);

(statearr_73350[(8)] = inst_73308);

return statearr_73350;
})();
var statearr_73351_73377 = state_73347__$1;
(statearr_73351_73377[(2)] = null);

(statearr_73351_73377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (4))){
var inst_73311 = (state_73347[(9)]);
var inst_73311__$1 = (state_73347[(2)]);
var inst_73312 = (inst_73311__$1 == null);
var inst_73313 = cljs.core.not.call(null,inst_73312);
var state_73347__$1 = (function (){var statearr_73352 = state_73347;
(statearr_73352[(9)] = inst_73311__$1);

return statearr_73352;
})();
if(inst_73313){
var statearr_73353_73378 = state_73347__$1;
(statearr_73353_73378[(1)] = (5));

} else {
var statearr_73354_73379 = state_73347__$1;
(statearr_73354_73379[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (15))){
var inst_73337 = (state_73347[(2)]);
var state_73347__$1 = state_73347;
var statearr_73355_73380 = state_73347__$1;
(statearr_73355_73380[(2)] = inst_73337);

(statearr_73355_73380[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (13))){
var state_73347__$1 = state_73347;
var statearr_73356_73381 = state_73347__$1;
(statearr_73356_73381[(2)] = null);

(statearr_73356_73381[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (6))){
var inst_73307 = (state_73347[(7)]);
var inst_73332 = inst_73307.length;
var inst_73333 = (inst_73332 > (0));
var state_73347__$1 = state_73347;
if(cljs.core.truth_(inst_73333)){
var statearr_73357_73382 = state_73347__$1;
(statearr_73357_73382[(1)] = (12));

} else {
var statearr_73358_73383 = state_73347__$1;
(statearr_73358_73383[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (3))){
var inst_73345 = (state_73347[(2)]);
var state_73347__$1 = state_73347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73347__$1,inst_73345);
} else {
if((state_val_73348 === (12))){
var inst_73307 = (state_73347[(7)]);
var inst_73335 = cljs.core.vec.call(null,inst_73307);
var state_73347__$1 = state_73347;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73347__$1,(15),out,inst_73335);
} else {
if((state_val_73348 === (2))){
var state_73347__$1 = state_73347;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73347__$1,(4),ch);
} else {
if((state_val_73348 === (11))){
var inst_73315 = (state_73347[(10)]);
var inst_73311 = (state_73347[(9)]);
var inst_73325 = (state_73347[(2)]);
var inst_73326 = [];
var inst_73327 = inst_73326.push(inst_73311);
var inst_73307 = inst_73326;
var inst_73308 = inst_73315;
var state_73347__$1 = (function (){var statearr_73359 = state_73347;
(statearr_73359[(11)] = inst_73327);

(statearr_73359[(12)] = inst_73325);

(statearr_73359[(7)] = inst_73307);

(statearr_73359[(8)] = inst_73308);

return statearr_73359;
})();
var statearr_73360_73384 = state_73347__$1;
(statearr_73360_73384[(2)] = null);

(statearr_73360_73384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (9))){
var inst_73307 = (state_73347[(7)]);
var inst_73323 = cljs.core.vec.call(null,inst_73307);
var state_73347__$1 = state_73347;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73347__$1,(11),out,inst_73323);
} else {
if((state_val_73348 === (5))){
var inst_73315 = (state_73347[(10)]);
var inst_73311 = (state_73347[(9)]);
var inst_73308 = (state_73347[(8)]);
var inst_73315__$1 = f.call(null,inst_73311);
var inst_73316 = cljs.core._EQ_.call(null,inst_73315__$1,inst_73308);
var inst_73317 = cljs.core.keyword_identical_QMARK_.call(null,inst_73308,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_73318 = (inst_73316) || (inst_73317);
var state_73347__$1 = (function (){var statearr_73361 = state_73347;
(statearr_73361[(10)] = inst_73315__$1);

return statearr_73361;
})();
if(cljs.core.truth_(inst_73318)){
var statearr_73362_73385 = state_73347__$1;
(statearr_73362_73385[(1)] = (8));

} else {
var statearr_73363_73386 = state_73347__$1;
(statearr_73363_73386[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (14))){
var inst_73340 = (state_73347[(2)]);
var inst_73341 = cljs.core.async.close_BANG_.call(null,out);
var state_73347__$1 = (function (){var statearr_73365 = state_73347;
(statearr_73365[(13)] = inst_73340);

return statearr_73365;
})();
var statearr_73366_73387 = state_73347__$1;
(statearr_73366_73387[(2)] = inst_73341);

(statearr_73366_73387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (10))){
var inst_73330 = (state_73347[(2)]);
var state_73347__$1 = state_73347;
var statearr_73367_73388 = state_73347__$1;
(statearr_73367_73388[(2)] = inst_73330);

(statearr_73367_73388[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73348 === (8))){
var inst_73315 = (state_73347[(10)]);
var inst_73307 = (state_73347[(7)]);
var inst_73311 = (state_73347[(9)]);
var inst_73320 = inst_73307.push(inst_73311);
var tmp73364 = inst_73307;
var inst_73307__$1 = tmp73364;
var inst_73308 = inst_73315;
var state_73347__$1 = (function (){var statearr_73368 = state_73347;
(statearr_73368[(7)] = inst_73307__$1);

(statearr_73368[(8)] = inst_73308);

(statearr_73368[(14)] = inst_73320);

return statearr_73368;
})();
var statearr_73369_73389 = state_73347__$1;
(statearr_73369_73389[(2)] = null);

(statearr_73369_73389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___73375,out))
;
return ((function (switch__47085__auto__,c__47173__auto___73375,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_73370 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73370[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_73370[(1)] = (1));

return statearr_73370;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_73347){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73371){if((e73371 instanceof Object)){
var ex__47089__auto__ = e73371;
var statearr_73372_73390 = state_73347;
(statearr_73372_73390[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73347);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73371;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73391 = state_73347;
state_73347 = G__73391;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_73347){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_73347);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___73375,out))
})();
var state__47175__auto__ = (function (){var statearr_73373 = f__47174__auto__.call(null);
(statearr_73373[(6)] = c__47173__auto___73375);

return statearr_73373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___73375,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1511404541211
