// Compiled by ClojureScript 1.9.946 {}
goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_.call(null,path)){
return cljs.core.every_QMARK_.call(null,com.rpl.specter.static_path_QMARK_,path);
} else {
return cljs.core.not.call(null,com.rpl.specter.impl.dynamic_param_QMARK_.call(null,path));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__67063__delegate = function (args){
var ret = cljs.core.apply.call(null,f,args);
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.sequential_QMARK_.call(null,ret);
if(and__28129__auto__){
return com.rpl.specter.static_path_QMARK_.call(null,ret);
} else {
return and__28129__auto__;
}
})())){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,ret);
} else {
if((cljs.core.sequential_QMARK_.call(null,ret)) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,ret)))){
return cljs.core.first.call(null,ret);
} else {
return ret;

}
}
};
var G__67063 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__67064__i = 0, G__67064__a = new Array(arguments.length -  0);
while (G__67064__i < G__67064__a.length) {G__67064__a[G__67064__i] = arguments[G__67064__i + 0]; ++G__67064__i;}
  args = new cljs.core.IndexedSeq(G__67064__a,0,null);
} 
return G__67063__delegate.call(this,args);};
G__67063.cljs$lang$maxFixedArity = 0;
G__67063.cljs$lang$applyTo = (function (arglist__67065){
var args = cljs.core.seq(arglist__67065);
return G__67063__delegate(args);
});
G__67063.cljs$core$IFn$_invoke$arity$variadic = G__67063__delegate;
return G__67063;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__29319__auto__ = [];
var len__29312__auto___67082 = arguments.length;
var i__29313__auto___67083 = (0);
while(true){
if((i__29313__auto___67083 < len__29312__auto___67082)){
args__29319__auto__.push((arguments[i__29313__auto___67083]));

var G__67084 = (i__29313__auto___67083 + (1));
i__29313__auto___67083 = G__67084;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,cljs.core.vec.call(null,apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq67081){
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67081));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
return com.rpl.specter.compiled_select.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
return com.rpl.specter.compiled_select_one.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
return com.rpl.specter.compiled_select_one_BANG_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
return com.rpl.specter.compiled_select_first.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
return com.rpl.specter.compiled_select_any.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
return com.rpl.specter.compiled_selected_any_QMARK_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
return com.rpl.specter.compiled_traverse.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath),structure);
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
return com.rpl.specter.compiled_traverse_all.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
return com.rpl.specter.compiled_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure);
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal`. Error is thrown if navigation finishes
 * at a non-`terminal` navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
return com.rpl.specter.compiled_multi_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
return com.rpl.specter.compiled_setval.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),val,structure);
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___67092 = arguments.length;
var i__29313__auto___67093 = (0);
while(true){
if((i__29313__auto___67093 < len__29312__auto___67092)){
args__29319__auto__.push((arguments[i__29313__auto___67093]));

var G__67094 = (i__29313__auto___67093 + (1));
i__29313__auto___67093 = G__67094;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__67089){
var map__67090 = p__67089;
var map__67090__$1 = ((((!((map__67090 == null)))?((((map__67090.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67090.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67090):map__67090);
var merge_fn = cljs.core.get.call(null,map__67090__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
return com.rpl.specter.compiled_replace_in.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),merge_fn);
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq67085){
var G__67086 = cljs.core.first.call(null,seq67085);
var seq67085__$1 = cljs.core.next.call(null,seq67085);
var G__67087 = cljs.core.first.call(null,seq67085__$1);
var seq67085__$2 = cljs.core.next.call(null,seq67085__$1);
var G__67088 = cljs.core.first.call(null,seq67085__$2);
var seq67085__$3 = cljs.core.next.call(null,seq67085__$2);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__67086,G__67087,G__67088,seq67085__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (navfn){
var latenavfn = com.rpl.specter.late_resolved_fn.call(null,navfn);
return cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,((function (latenavfn){
return (function() { 
var G__67095__delegate = function (args){
return cljs.core.map.call(null,latenavfn,args);
};
var G__67095 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__67096__i = 0, G__67096__a = new Array(arguments.length -  0);
while (G__67096__i < G__67096__a.length) {G__67096__a[G__67096__i] = arguments[G__67096__i + 0]; ++G__67096__i;}
  args = new cljs.core.IndexedSeq(G__67096__a,0,null);
} 
return G__67095__delegate.call(this,args);};
G__67095.cljs$lang$maxFixedArity = 0;
G__67095.cljs$lang$applyTo = (function (arglist__67097){
var args = cljs.core.seq(arglist__67097);
return G__67095__delegate(args);
});
G__67095.cljs$core$IFn$_invoke$arity$variadic = G__67095__delegate;
return G__67095;
})()
;})(latenavfn))
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67098 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67098 = (function (meta67099){
this.meta67099 = meta67099;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67098.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67100,meta67099__$1){
var self__ = this;
var _67100__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67098(meta67099__$1));
});


com.rpl.specter.t_com$rpl$specter67098.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67100){
var self__ = this;
var _67100__$1 = this;
return self__.meta67099;
});


com.rpl.specter.t_com$rpl$specter67098.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67098.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.NONE;
});


com.rpl.specter.t_com$rpl$specter67098.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter67098.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67099","meta67099",-617655769,null)], null);
});

com.rpl.specter.t_com$rpl$specter67098.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67098.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67098";

com.rpl.specter.t_com$rpl$specter67098.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67098");
});

com.rpl.specter.__GT_t_com$rpl$specter67098 = (function com$rpl$specter$__GT_t_com$rpl$specter67098(meta67099){
return (new com.rpl.specter.t_com$rpl$specter67098(meta67099));
});

}

return (new com.rpl.specter.t_com$rpl$specter67098(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * For usage with `multi-transform`, defines an endpoint in the navigation
 *        that will have the parameterized transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter67101 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67101 = (function (afn,meta67102){
this.afn = afn;
this.meta67102 = meta67102;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67101.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67103,meta67102__$1){
var self__ = this;
var _67103__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67101(self__.afn,meta67102__$1));
});


com.rpl.specter.t_com$rpl$specter67101.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67103){
var self__ = this;
var _67103__$1 = this;
return self__.meta67102;
});


com.rpl.specter.t_com$rpl$specter67101.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67101.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"'terminal' should only be used in multi-transform")));
});


com.rpl.specter.t_com$rpl$specter67101.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_.call(null,self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter67101.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta67102","meta67102",-882666583,null)], null);
});

com.rpl.specter.t_com$rpl$specter67101.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67101.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67101";

com.rpl.specter.t_com$rpl$specter67101.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67101");
});

com.rpl.specter.__GT_t_com$rpl$specter67101 = (function com$rpl$specter$__GT_t_com$rpl$specter67101(afn__$1,meta67102){
return (new com.rpl.specter.t_com$rpl$specter67101(afn__$1,meta67102));
});

}

return (new com.rpl.specter.t_com$rpl$specter67101(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
return com.rpl.specter.terminal.call(null,com.rpl.specter.impl.fast_constantly.call(null,v));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67104 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67104 = (function (meta67105){
this.meta67105 = meta67105;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67104.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67106,meta67105__$1){
var self__ = this;
var _67106__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67104(meta67105__$1));
});


com.rpl.specter.t_com$rpl$specter67104.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67106){
var self__ = this;
var _67106__$1 = this;
return self__.meta67105;
});


com.rpl.specter.t_com$rpl$specter67104.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67104.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});


com.rpl.specter.t_com$rpl$specter67104.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter67104.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67105","meta67105",-831234603,null)], null);
});

com.rpl.specter.t_com$rpl$specter67104.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67104.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67104";

com.rpl.specter.t_com$rpl$specter67104.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67104");
});

com.rpl.specter.__GT_t_com$rpl$specter67104 = (function com$rpl$specter$__GT_t_com$rpl$specter67104(meta67105){
return (new com.rpl.specter.t_com$rpl$specter67104(meta67105));
});

}

return (new com.rpl.specter.t_com$rpl$specter67104(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta.call(null,structure);
var res = com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta.call(null,res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67107 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67107 = (function (meta67108){
this.meta67108 = meta67108;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67107.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67109,meta67108__$1){
var self__ = this;
var _67109__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67107(meta67108__$1));
});


com.rpl.specter.t_com$rpl$specter67107.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67109){
var self__ = this;
var _67109__$1 = this;
return self__.meta67108;
});


com.rpl.specter.t_com$rpl$specter67107.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67107.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});


com.rpl.specter.t_com$rpl$specter67107.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var m = cljs.core.meta.call(null,structure);
var res = com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta.call(null,res,m);
} else {
return null;
}
});

com.rpl.specter.t_com$rpl$specter67107.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67108","meta67108",1730032867,null)], null);
});

com.rpl.specter.t_com$rpl$specter67107.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67107.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67107";

com.rpl.specter.t_com$rpl$specter67107.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67107");
});

com.rpl.specter.__GT_t_com$rpl$specter67107 = (function com$rpl$specter$__GT_t_com$rpl$specter67107(meta67108){
return (new com.rpl.specter.t_com$rpl$specter67107(meta67108));
});

}

return (new com.rpl.specter.t_com$rpl$specter67107(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__32276__auto__,v){
var ret__32277__auto__ = next_fn.call(null,v);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67110 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67110 = (function (meta67111){
this.meta67111 = meta67111;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67110.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67112,meta67111__$1){
var self__ = this;
var _67112__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67110(meta67111__$1));
});


com.rpl.specter.t_com$rpl$specter67110.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67112){
var self__ = this;
var _67112__$1 = this;
return self__.meta67111;
});


com.rpl.specter.t_com$rpl$specter67110.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67110.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__34062__auto____$1){
return (function (curr__32276__auto__,v){
var ret__32277__auto__ = next_fn.call(null,v);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
});})(next_fn,this__34062__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter67110.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter67110.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67111","meta67111",1997343968,null)], null);
});

com.rpl.specter.t_com$rpl$specter67110.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67110.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67110";

com.rpl.specter.t_com$rpl$specter67110.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67110");
});

com.rpl.specter.__GT_t_com$rpl$specter67110 = (function com$rpl$specter$__GT_t_com$rpl$specter67110(meta67111){
return (new com.rpl.specter.t_com$rpl$specter67110(meta67111));
});

}

return (new com.rpl.specter.t_com$rpl$specter67110(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__32276__auto__,k){
var ret__32277__auto__ = next_fn.call(null,k);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys.call(null,structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67113 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67113 = (function (meta67114){
this.meta67114 = meta67114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67115,meta67114__$1){
var self__ = this;
var _67115__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67113(meta67114__$1));
});


com.rpl.specter.t_com$rpl$specter67113.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67115){
var self__ = this;
var _67115__$1 = this;
return self__.meta67114;
});


com.rpl.specter.t_com$rpl$specter67113.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67113.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__34062__auto____$1){
return (function (curr__32276__auto__,k){
var ret__32277__auto__ = next_fn.call(null,k);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
});})(next_fn,this__34062__auto____$1))
,com.rpl.specter.NONE,cljs.core.keys.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter67113.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.map_keys_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter67113.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67114","meta67114",-1859298622,null)], null);
});

com.rpl.specter.t_com$rpl$specter67113.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67113.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67113";

com.rpl.specter.t_com$rpl$specter67113.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67113");
});

com.rpl.specter.__GT_t_com$rpl$specter67113 = (function com$rpl$specter$__GT_t_com$rpl$specter67113(meta67114){
return (new com.rpl.specter.t_com$rpl$specter67113(meta67114));
});

}

return (new com.rpl.specter.t_com$rpl$specter67113(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67116 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67116 = (function (meta67117){
this.meta67117 = meta67117;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67116.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67118,meta67117__$1){
var self__ = this;
var _67118__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67116(meta67117__$1));
});


com.rpl.specter.t_com$rpl$specter67116.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67118){
var self__ = this;
var _67118__$1 = this;
return self__.meta67117;
});


com.rpl.specter.t_com$rpl$specter67116.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67116.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,structure),structure);
});


com.rpl.specter.t_com$rpl$specter67116.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter67116.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67117","meta67117",1321618646,null)], null);
});

com.rpl.specter.t_com$rpl$specter67116.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67116.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67116";

com.rpl.specter.t_com$rpl$specter67116.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67116");
});

com.rpl.specter.__GT_t_com$rpl$specter67116 = (function com$rpl$specter$__GT_t_com$rpl$specter67116(meta67117){
return (new com.rpl.specter.t_com$rpl$specter67116(meta67117));
});

}

return (new com.rpl.specter.t_com$rpl$specter67116(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last);
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first);


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_select.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_transform.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,end_index_fn,structure,s),next_fn);
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start_index_fn,end_index_fn){
if(typeof com.rpl.specter.t_com$rpl$specter67119 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67119 = (function (start_index_fn,end_index_fn,meta67120){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta67120 = meta67120;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67119.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67121,meta67120__$1){
var self__ = this;
var _67121__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67119(self__.start_index_fn,self__.end_index_fn,meta67120__$1));
});


com.rpl.specter.t_com$rpl$specter67119.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67121){
var self__ = this;
var _67121__$1 = this;
return self__.meta67120;
});


com.rpl.specter.t_com$rpl$specter67119.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67119.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var s = self__.start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_select.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,self__.end_index_fn,structure,s),next_fn);
});


com.rpl.specter.t_com$rpl$specter67119.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var s = self__.start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_transform.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,self__.end_index_fn,structure,s),next_fn);
});

com.rpl.specter.t_com$rpl$specter67119.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta67120","meta67120",1235228974,null)], null);
});

com.rpl.specter.t_com$rpl$specter67119.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67119.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67119";

com.rpl.specter.t_com$rpl$specter67119.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67119");
});

com.rpl.specter.__GT_t_com$rpl$specter67119 = (function com$rpl$specter$__GT_t_com$rpl$specter67119(start_index_fn__$1,end_index_fn__$1,meta67120){
return (new com.rpl.specter.t_com$rpl$specter67119(start_index_fn__$1,end_index_fn__$1,meta67120));
});

}

return (new com.rpl.specter.t_com$rpl$specter67119(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn);
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter67122 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67122 = (function (start,end,meta67123){
this.start = start;
this.end = end;
this.meta67123 = meta67123;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67122.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67124,meta67123__$1){
var self__ = this;
var _67124__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67122(self__.start,self__.end,meta67123__$1));
});


com.rpl.specter.t_com$rpl$specter67122.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67124){
var self__ = this;
var _67124__$1 = this;
return self__.meta67123;
});


com.rpl.specter.t_com$rpl$specter67122.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67122.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start,self__.end,next_fn);
});


com.rpl.specter.t_com$rpl$specter67122.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter67122.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta67123","meta67123",1816742206,null)], null);
});

com.rpl.specter.t_com$rpl$specter67122.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67122.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67122";

com.rpl.specter.t_com$rpl$specter67122.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67122");
});

com.rpl.specter.__GT_t_com$rpl$specter67122 = (function com$rpl$specter$__GT_t_com$rpl$specter67122(start__$1,end__$1,meta67123){
return (new com.rpl.specter.t_com$rpl$specter67122(start__$1,end__$1,meta67123));
});

}

return (new com.rpl.specter.t_com$rpl$specter67122(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__32276__auto__,p__67125){
var vec__67126 = p__67125;
var s = cljs.core.nth.call(null,vec__67126,(0),null);
var e = cljs.core.nth.call(null,vec__67126,(1),null);
var ret__32277__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj.call(null,(function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter67129 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67129 = (function (pred,meta67130){
this.pred = pred;
this.meta67130 = meta67130;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67129.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67131,meta67130__$1){
var self__ = this;
var _67131__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67129(self__.pred,meta67130__$1));
});


com.rpl.specter.t_com$rpl$specter67129.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67131){
var self__ = this;
var _67131__$1 = this;
return self__.meta67130;
});


com.rpl.specter.t_com$rpl$specter67129.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67129.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__34062__auto____$1){
return (function (curr__32276__auto__,p__67132){
var vec__67133 = p__67132;
var s = cljs.core.nth.call(null,vec__67133,(0),null);
var e = cljs.core.nth.call(null,vec__67133,(1),null);
var ret__32277__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__32277__auto__ === com.rpl.specter.NONE)){
return curr__32276__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__32277__auto__)){
return cljs.core.reduced.call(null,ret__32277__auto__);
} else {
return ret__32277__auto__;
}
}
});})(next_fn,this__34062__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,self__.pred));
});


com.rpl.specter.t_com$rpl$specter67129.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter67129.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta67130","meta67130",-2013264804,null)], null);
});

com.rpl.specter.t_com$rpl$specter67129.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67129.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67129";

com.rpl.specter.t_com$rpl$specter67129.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67129");
});

com.rpl.specter.__GT_t_com$rpl$specter67129 = (function com$rpl$specter$__GT_t_com$rpl$specter67129(pred__$1,meta67130){
return (new com.rpl.specter.t_com$rpl$specter67129(pred__$1,meta67130));
});

}

return (new com.rpl.specter.t_com$rpl$specter67129(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67136 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67136 = (function (meta67137){
this.meta67137 = meta67137;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67136.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67138,meta67137__$1){
var self__ = this;
var _67138__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67136(meta67137__$1));
});


com.rpl.specter.t_com$rpl$specter67136.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67138){
var self__ = this;
var _67138__$1 = this;
return self__.meta67137;
});


com.rpl.specter.t_com$rpl$specter67136.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67136.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});


com.rpl.specter.t_com$rpl$specter67136.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
}
});

com.rpl.specter.t_com$rpl$specter67136.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67137","meta67137",-865506050,null)], null);
});

com.rpl.specter.t_com$rpl$specter67136.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67136.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67136";

com.rpl.specter.t_com$rpl$specter67136.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67136");
});

com.rpl.specter.__GT_t_com$rpl$specter67136 = (function com$rpl$specter$__GT_t_com$rpl$specter67136(meta67137){
return (new com.rpl.specter.t_com$rpl$specter67136(meta67137));
});

}

return (new com.rpl.specter.t_com$rpl$specter67136(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,""))].join('');
} else {
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67139 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67139 = (function (meta67140){
this.meta67140 = meta67140;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67139.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67141,meta67140__$1){
var self__ = this;
var _67141__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67139(meta67140__$1));
});


com.rpl.specter.t_com$rpl$specter67139.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67141){
var self__ = this;
var _67141__$1 = this;
return self__.meta67140;
});


com.rpl.specter.t_com$rpl$specter67139.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67139.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});


com.rpl.specter.t_com$rpl$specter67139.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,""))].join('');
} else {
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
}
});

com.rpl.specter.t_com$rpl$specter67139.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67140","meta67140",-81281447,null)], null);
});

com.rpl.specter.t_com$rpl$specter67139.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67139.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67139";

com.rpl.specter.t_com$rpl$specter67139.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67139");
});

com.rpl.specter.__GT_t_com$rpl$specter67139 = (function com$rpl$specter$__GT_t_com$rpl$specter67139(meta67140){
return (new com.rpl.specter.t_com$rpl$specter67139(meta67140));
});

}

return (new com.rpl.specter.t_com$rpl$specter67139(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.call(null,structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67142 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67142 = (function (meta67143){
this.meta67143 = meta67143;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67142.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67144,meta67143__$1){
var self__ = this;
var _67144__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67142(meta67143__$1));
});


com.rpl.specter.t_com$rpl$specter67142.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67144){
var self__ = this;
var _67144__$1 = this;
return self__.meta67143;
});


com.rpl.specter.t_com$rpl$specter67142.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67142.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter67142.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.call(null,structure,newe);
}
}
});

com.rpl.specter.t_com$rpl$specter67142.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67143","meta67143",1146444861,null)], null);
});

com.rpl.specter.t_com$rpl$specter67142.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67142.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67142";

com.rpl.specter.t_com$rpl$specter67142.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67142");
});

com.rpl.specter.__GT_t_com$rpl$specter67142 = (function com$rpl$specter$__GT_t_com$rpl$specter67142(meta67143){
return (new com.rpl.specter.t_com$rpl$specter67142(meta67143));
});

}

return (new com.rpl.specter.t_com$rpl$specter67142(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one.call(null,structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67145 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67145 = (function (meta67146){
this.meta67146 = meta67146;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67145.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67147,meta67146__$1){
var self__ = this;
var _67147__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67145(meta67146__$1));
});


com.rpl.specter.t_com$rpl$specter67145.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67147){
var self__ = this;
var _67147__$1 = this;
return self__.meta67146;
});


com.rpl.specter.t_com$rpl$specter67145.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67145.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter67145.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one.call(null,structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter67145.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67146","meta67146",971975392,null)], null);
});

com.rpl.specter.t_com$rpl$specter67145.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67145.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67145";

com.rpl.specter.t_com$rpl$specter67145.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67145");
});

com.rpl.specter.__GT_t_com$rpl$specter67145 = (function com$rpl$specter$__GT_t_com$rpl$specter67145(meta67146){
return (new com.rpl.specter.t_com$rpl$specter67145(meta67146));
});

}

return (new com.rpl.specter.t_com$rpl$specter67145(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one.call(null,structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67148 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67148 = (function (meta67149){
this.meta67149 = meta67149;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67148.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67150,meta67149__$1){
var self__ = this;
var _67150__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67148(meta67149__$1));
});


com.rpl.specter.t_com$rpl$specter67148.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67150){
var self__ = this;
var _67150__$1 = this;
return self__.meta67149;
});


com.rpl.specter.t_com$rpl$specter67148.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67148.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter67148.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one.call(null,structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter67148.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67149","meta67149",-1767823520,null)], null);
});

com.rpl.specter.t_com$rpl$specter67148.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67148.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67148";

com.rpl.specter.t_com$rpl$specter67148.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67148");
});

com.rpl.specter.__GT_t_com$rpl$specter67148 = (function com$rpl$specter$__GT_t_com$rpl$specter67148(meta67149){
return (new com.rpl.specter.t_com$rpl$specter67148(meta67149));
});

}

return (new com.rpl.specter.t_com$rpl$specter67148(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
return next_fn.call(null,clojure.set.intersection.call(null,structure,aset));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.call(null,structure,aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj.call(null,(function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter67151 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67151 = (function (aset,meta67152){
this.aset = aset;
this.meta67152 = meta67152;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67151.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67153,meta67152__$1){
var self__ = this;
var _67153__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67151(self__.aset,meta67152__$1));
});


com.rpl.specter.t_com$rpl$specter67151.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67153){
var self__ = this;
var _67153__$1 = this;
return self__.meta67152;
});


com.rpl.specter.t_com$rpl$specter67151.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67151.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,clojure.set.intersection.call(null,structure,self__.aset));
});


com.rpl.specter.t_com$rpl$specter67151.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var subset = clojure.set.intersection.call(null,structure,self__.aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter67151.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta67152","meta67152",1858204209,null)], null);
});

com.rpl.specter.t_com$rpl$specter67151.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67151.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67151";

com.rpl.specter.t_com$rpl$specter67151.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67151");
});

com.rpl.specter.__GT_t_com$rpl$specter67151 = (function com$rpl$specter$__GT_t_com$rpl$specter67151(aset__$1,meta67152){
return (new com.rpl.specter.t_com$rpl$specter67151(aset__$1,meta67152));
});

}

return (new com.rpl.specter.t_com$rpl$specter67151(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
return next_fn.call(null,cljs.core.select_keys.call(null,structure,m_keys));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys.call(null,structure,m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,m_keys),newmap);
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj.call(null,(function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter67154 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67154 = (function (m_keys,meta67155){
this.m_keys = m_keys;
this.meta67155 = meta67155;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67154.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67156,meta67155__$1){
var self__ = this;
var _67156__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67154(self__.m_keys,meta67155__$1));
});


com.rpl.specter.t_com$rpl$specter67154.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67156){
var self__ = this;
var _67156__$1 = this;
return self__.meta67155;
});


com.rpl.specter.t_com$rpl$specter67154.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67154.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.select_keys.call(null,structure,self__.m_keys));
});


com.rpl.specter.t_com$rpl$specter67154.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var submap = cljs.core.select_keys.call(null,structure,self__.m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,self__.m_keys),newmap);
});

com.rpl.specter.t_com$rpl$specter67154.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta67155","meta67155",495756506,null)], null);
});

com.rpl.specter.t_com$rpl$specter67154.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67154.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67154";

com.rpl.specter.t_com$rpl$specter67154.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67154");
});

com.rpl.specter.__GT_t_com$rpl$specter67154 = (function com$rpl$specter$__GT_t_com$rpl$specter67154(m_keys__$1,meta67155){
return (new com.rpl.specter.t_com$rpl$specter67154(m_keys__$1,meta67155));
});

}

return (new com.rpl.specter.t_com$rpl$specter67154(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67160__delegate = function (path){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter67157 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67157 = (function (path,late,meta67158){
this.path = path;
this.late = late;
this.meta67158 = meta67158;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67157.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67159,meta67158__$1){
var self__ = this;
var _67159__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67157(self__.path,self__.late,meta67158__$1));
});


com.rpl.specter.t_com$rpl$specter67157.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67159){
var self__ = this;
var _67159__$1 = this;
return self__.meta67158;
});


com.rpl.specter.t_com$rpl$specter67157.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67157.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_select.call(null,self__.late,structure));
});


com.rpl.specter.t_com$rpl$specter67157.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var select_result = com.rpl.specter.compiled_select.call(null,self__.late,structure);
var transformed = next_fn.call(null,select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.call(null,transformed);
return com.rpl.specter.compiled_transform.call(null,self__.late,((function (select_result,transformed,values_to_insert,next_fn,this__34062__auto____$1){
return (function (_){
var vs = com.rpl.specter.impl.get_cell.call(null,values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_.call(null,values_to_insert,cljs.core.next);

return cljs.core.first.call(null,vs);
} else {
return com.rpl.specter.NONE;
}
});})(select_result,transformed,values_to_insert,next_fn,this__34062__auto____$1))
,structure);
});

com.rpl.specter.t_com$rpl$specter67157.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta67158","meta67158",1168662587,null)], null);
});

com.rpl.specter.t_com$rpl$specter67157.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67157.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67157";

com.rpl.specter.t_com$rpl$specter67157.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67157");
});

com.rpl.specter.__GT_t_com$rpl$specter67157 = (function com$rpl$specter$__GT_t_com$rpl$specter67157(path__$1,late__$1,meta67158){
return (new com.rpl.specter.t_com$rpl$specter67157(path__$1,late__$1,meta67158));
});

}

return (new com.rpl.specter.t_com$rpl$specter67157(path,late,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
};
var G__67160 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67161__i = 0, G__67161__a = new Array(arguments.length -  0);
while (G__67161__i < G__67161__a.length) {G__67161__a[G__67161__i] = arguments[G__67161__i + 0]; ++G__67161__i;}
  path = new cljs.core.IndexedSeq(G__67161__a,0,null);
} 
return G__67160__delegate.call(this,path);};
G__67160.cljs$lang$maxFixedArity = 0;
G__67160.cljs$lang$applyTo = (function (arglist__67162){
var path = cljs.core.seq(arglist__67162);
return G__67160__delegate(path);
});
G__67160.cljs$core$IFn$_invoke$arity$variadic = G__67160__delegate;
return G__67160;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj.call(null,(function (key){
if(typeof com.rpl.specter.t_com$rpl$specter67163 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67163 = (function (key,meta67164){
this.key = key;
this.meta67164 = meta67164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67165,meta67164__$1){
var self__ = this;
var _67165__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67163(self__.key,meta67164__$1));
});


com.rpl.specter.t_com$rpl$specter67163.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67165){
var self__ = this;
var _67165__$1 = this;
return self__.meta67164;
});


com.rpl.specter.t_com$rpl$specter67163.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67163.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.key)){
return next_fn.call(null,vals,self__.key);
} else {
return com.rpl.specter.NONE;
}
});


com.rpl.specter.t_com$rpl$specter67163.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.key)){
var newkey = next_fn.call(null,vals,self__.key);
var dissoced = cljs.core.dissoc.call(null,structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.call(null,dissoced,newkey,cljs.core.get.call(null,structure,self__.key));
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter67163.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta67164","meta67164",-1852500919,null)], null);
});

com.rpl.specter.t_com$rpl$specter67163.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67163.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67163";

com.rpl.specter.t_com$rpl$specter67163.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67163");
});

com.rpl.specter.__GT_t_com$rpl$specter67163 = (function com$rpl$specter$__GT_t_com$rpl$specter67163(key__$1,meta67164){
return (new com.rpl.specter.t_com$rpl$specter67163(key__$1,meta67164));
});

}

return (new com.rpl.specter.t_com$rpl$specter67163(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj.call(null,(function (elem){
if(typeof com.rpl.specter.t_com$rpl$specter67166 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67166 = (function (elem,meta67167){
this.elem = elem;
this.meta67167 = meta67167;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67166.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67168,meta67167__$1){
var self__ = this;
var _67168__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67166(self__.elem,meta67167__$1));
});


com.rpl.specter.t_com$rpl$specter67166.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67168){
var self__ = this;
var _67168__$1 = this;
return self__.meta67167;
});


com.rpl.specter.t_com$rpl$specter67166.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67166.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.elem)){
return next_fn.call(null,vals,self__.elem);
} else {
return com.rpl.specter.NONE;
}
});


com.rpl.specter.t_com$rpl$specter67166.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.elem)){
var newelem = next_fn.call(null,vals,self__.elem);
var removed = cljs.core.disj.call(null,structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.call(null,removed,newelem);
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter67166.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta67167","meta67167",-418369925,null)], null);
});

com.rpl.specter.t_com$rpl$specter67166.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67166.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67166";

com.rpl.specter.t_com$rpl$specter67166.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67166");
});

com.rpl.specter.__GT_t_com$rpl$specter67166 = (function com$rpl$specter$__GT_t_com$rpl$specter67166(elem__$1,meta67167){
return (new com.rpl.specter.t_com$rpl$specter67166(elem__$1,meta67167));
});

}

return (new com.rpl.specter.t_com$rpl$specter67166(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_);
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_);
/**
 * Navigate to the specified indices one after another.If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_);
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter67169 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67169 = (function (afn,meta67170){
this.afn = afn;
this.meta67170 = meta67170;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67169.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67171,meta67170__$1){
var self__ = this;
var _67171__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67169(self__.afn,meta67170__$1));
});


com.rpl.specter.t_com$rpl$specter67169.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67171){
var self__ = this;
var _67171__$1 = this;
return self__.meta67170;
});


com.rpl.specter.t_com$rpl$specter67169.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67169.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter67169.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter67169.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta67170","meta67170",-926072892,null)], null);
});

com.rpl.specter.t_com$rpl$specter67169.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67169.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67169";

com.rpl.specter.t_com$rpl$specter67169.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67169");
});

com.rpl.specter.__GT_t_com$rpl$specter67169 = (function com$rpl$specter$__GT_t_com$rpl$specter67169(afn__$1,meta67170){
return (new com.rpl.specter.t_com$rpl$specter67169(afn__$1,meta67170));
});

}

return (new com.rpl.specter.t_com$rpl$specter67169(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
return next_fn.call(null,parse_fn.call(null,structure));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
return unparse_fn.call(null,next_fn.call(null,parse_fn.call(null,structure)));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj.call(null,(function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter67172 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67172 = (function (parse_fn,unparse_fn,meta67173){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta67173 = meta67173;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67172.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67174,meta67173__$1){
var self__ = this;
var _67174__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67172(self__.parse_fn,self__.unparse_fn,meta67173__$1));
});


com.rpl.specter.t_com$rpl$specter67172.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67174){
var self__ = this;
var _67174__$1 = this;
return self__.meta67173;
});


com.rpl.specter.t_com$rpl$specter67172.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67172.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,self__.parse_fn.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter67172.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return self__.unparse_fn.call(null,next_fn.call(null,self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter67172.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta67173","meta67173",390452771,null)], null);
});

com.rpl.specter.t_com$rpl$specter67172.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67172.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67172";

com.rpl.specter.t_com$rpl$specter67172.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67172");
});

com.rpl.specter.__GT_t_com$rpl$specter67172 = (function com$rpl$specter$__GT_t_com$rpl$specter67172(parse_fn__$1,unparse_fn__$1,meta67173){
return (new com.rpl.specter.t_com$rpl$specter67172(parse_fn__$1,unparse_fn__$1,meta67173));
});

}

return (new com.rpl.specter.t_com$rpl$specter67172(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67175 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67175 = (function (meta67176){
this.meta67176 = meta67176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67177,meta67176__$1){
var self__ = this;
var _67177__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67175(meta67176__$1));
});


com.rpl.specter.t_com$rpl$specter67175.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67177){
var self__ = this;
var _67177__$1 = this;
return self__.meta67176;
});


com.rpl.specter.t_com$rpl$specter67175.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67175.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.deref.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter67175.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter67175.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67176","meta67176",1588498066,null)], null);
});

com.rpl.specter.t_com$rpl$specter67175.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67175.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67175";

com.rpl.specter.t_com$rpl$specter67175.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67175");
});

com.rpl.specter.__GT_t_com$rpl$specter67175 = (function com$rpl$specter$__GT_t_com$rpl$specter67175(meta67176){
return (new com.rpl.specter.t_com$rpl$specter67175(meta67176));
});

}

return (new com.rpl.specter.t_com$rpl$specter67175(null));
})()
;
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67183__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return afn;
} else {
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter67180 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67180 = (function (path,temp__4655__auto__,late,meta67181){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta67181 = meta67181;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67180.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_67182,meta67181__$1){
var self__ = this;
var _67182__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67180(self__.path,self__.temp__4655__auto__,self__.late,meta67181__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67180.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_67182){
var self__ = this;
var _67182__$1 = this;
return self__.meta67181;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67180.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67180.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__67178_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,vals,p1__67178_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67180.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__67179_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,vals,p1__67179_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter67180.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta67181","meta67181",197696777,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter67180.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67180.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67180";

com.rpl.specter.t_com$rpl$specter67180.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67180");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter67180 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter67180(path__$1,temp__4655__auto____$1,late__$1,meta67181){
return (new com.rpl.specter.t_com$rpl$specter67180(path__$1,temp__4655__auto____$1,late__$1,meta67181));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter67180(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
}
};
var G__67183 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67184__i = 0, G__67184__a = new Array(arguments.length -  0);
while (G__67184__i < G__67184__a.length) {G__67184__a[G__67184__i] = arguments[G__67184__i + 0]; ++G__67184__i;}
  path = new cljs.core.IndexedSeq(G__67184__a,0,null);
} 
return G__67183__delegate.call(this,path);};
G__67183.cljs$lang$maxFixedArity = 0;
G__67183.cljs$lang$applyTo = (function (arglist__67185){
var path = cljs.core.seq(arglist__67185);
return G__67183__delegate(path);
});
G__67183.cljs$core$IFn$_invoke$arity$variadic = G__67183__delegate;
return G__67183;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67191__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return ((function (afn,temp__4655__auto__){
return (function (s){
return cljs.core.not.call(null,afn.call(null,s));
});
;})(afn,temp__4655__auto__))
} else {
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter67188 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67188 = (function (path,temp__4655__auto__,late,meta67189){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta67189 = meta67189;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67188.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_67190,meta67189__$1){
var self__ = this;
var _67190__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67188(self__.path,self__.temp__4655__auto__,self__.late,meta67189__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67188.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_67190){
var self__ = this;
var _67190__$1 = this;
return self__.meta67189;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67188.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67188.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__67186_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,vals,p1__67186_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67188.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__67187_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,vals,p1__67187_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter67188.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta67189","meta67189",539771304,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter67188.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67188.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67188";

com.rpl.specter.t_com$rpl$specter67188.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67188");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter67188 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter67188(path__$1,temp__4655__auto____$1,late__$1,meta67189){
return (new com.rpl.specter.t_com$rpl$specter67188(path__$1,temp__4655__auto____$1,late__$1,meta67189));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter67188(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
}
};
var G__67191 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67192__i = 0, G__67192__a = new Array(arguments.length -  0);
while (G__67192__i < G__67192__a.length) {G__67192__a[G__67192__i] = arguments[G__67192__i + 0]; ++G__67192__i;}
  path = new cljs.core.IndexedSeq(G__67192__a,0,null);
} 
return G__67191__delegate.call(this,path);};
G__67191.cljs$lang$maxFixedArity = 0;
G__67191.cljs$lang$applyTo = (function (arglist__67193){
var path = cljs.core.seq(arglist__67193);
return G__67191__delegate(path);
});
G__67191.cljs$core$IFn$_invoke$arity$variadic = G__67191__delegate;
return G__67191;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67194__delegate = function (path){
return com.rpl.specter.subselect.call(null,com.rpl.specter.ALL,com.rpl.specter.selected_QMARK_.call(null,path));
};
var G__67194 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67195__i = 0, G__67195__a = new Array(arguments.length -  0);
while (G__67195__i < G__67195__a.length) {G__67195__a[G__67195__i] = arguments[G__67195__i + 0]; ++G__67195__i;}
  path = new cljs.core.IndexedSeq(G__67195__a,0,null);
} 
return G__67194__delegate.call(this,path);};
G__67194.cljs$lang$maxFixedArity = 0;
G__67194.cljs$lang$applyTo = (function (arglist__67196){
var path = cljs.core.seq(arglist__67196);
return G__67194__delegate(path);
});
G__67194.cljs$core$IFn$_invoke$arity$variadic = G__67194__delegate;
return G__67194;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (path,update_fn){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter67197 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67197 = (function (path,update_fn,late,late_fn,meta67198){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta67198 = meta67198;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67197.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67199,meta67198__$1){
var self__ = this;
var _67199__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67197(self__.path,self__.update_fn,self__.late,self__.late_fn,meta67198__$1));
});


com.rpl.specter.t_com$rpl$specter67197.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67199){
var self__ = this;
var _67199__$1 = this;
return self__.meta67198;
});


com.rpl.specter.t_com$rpl$specter67197.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67197.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});


com.rpl.specter.t_com$rpl$specter67197.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter67197.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta67198","meta67198",720501250,null)], null);
});

com.rpl.specter.t_com$rpl$specter67197.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67197.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67197";

com.rpl.specter.t_com$rpl$specter67197.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67197");
});

com.rpl.specter.__GT_t_com$rpl$specter67197 = (function com$rpl$specter$__GT_t_com$rpl$specter67197(path__$1,update_fn__$1,late__$1,late_fn__$1,meta67198){
return (new com.rpl.specter.t_com$rpl$specter67197(path__$1,update_fn__$1,late__$1,late_fn__$1,meta67198));
});

}

return (new com.rpl.specter.t_com$rpl$specter67197(path,update_fn,late,late_fn,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),update_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (path,reduce_fn){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter67200 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67200 = (function (path,reduce_fn,late,late_fn,meta67201){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta67201 = meta67201;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67200.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67202,meta67201__$1){
var self__ = this;
var _67202__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67200(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta67201__$1));
});


com.rpl.specter.t_com$rpl$specter67200.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67202){
var self__ = this;
var _67202__$1 = this;
return self__.meta67201;
});


com.rpl.specter.t_com$rpl$specter67200.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67200.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});


com.rpl.specter.t_com$rpl$specter67200.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter67200.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta67201","meta67201",1338628729,null)], null);
});

com.rpl.specter.t_com$rpl$specter67200.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67200.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67200";

com.rpl.specter.t_com$rpl$specter67200.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67200");
});

com.rpl.specter.__GT_t_com$rpl$specter67200 = (function com$rpl$specter$__GT_t_com$rpl$specter67200(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta67201){
return (new com.rpl.specter.t_com$rpl$specter67200(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta67201));
});

}

return (new com.rpl.specter.t_com$rpl$specter67200(path,reduce_fn,late,late_fn,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),reduce_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. This is the
 *        late-bound parameterized version of using a function directly in a path.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__67203_SHARP_){
return cljs.core._EQ_.call(null,p1__67203_SHARP_,v);
}));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
return com.rpl.specter.pred.call(null,(function (p1__67204_SHARP_){
return (p1__67204_SHARP_ < v);
}));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
return com.rpl.specter.pred.call(null,(function (p1__67205_SHARP_){
return (p1__67205_SHARP_ > v);
}));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__67206_SHARP_){
return (p1__67206_SHARP_ <= v);
}));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__67207_SHARP_){
return (p1__67207_SHARP_ >= v);
}));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1);
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return com.rpl.specter.pred.call(null,this$);
}));

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.pred.call(null,this$__$1);
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj.call(null,(function (v){
if(typeof com.rpl.specter.t_com$rpl$specter67208 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67208 = (function (v,meta67209){
this.v = v;
this.meta67209 = meta67209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67210,meta67209__$1){
var self__ = this;
var _67210__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67208(self__.v,meta67209__$1));
});


com.rpl.specter.t_com$rpl$specter67208.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67210){
var self__ = this;
var _67210__$1 = this;
return self__.meta67209;
});


com.rpl.specter.t_com$rpl$specter67208.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67208.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});


com.rpl.specter.t_com$rpl$specter67208.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter67208.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta67209","meta67209",281221237,null)], null);
});

com.rpl.specter.t_com$rpl$specter67208.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67208.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67208";

com.rpl.specter.t_com$rpl$specter67208.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67208");
});

com.rpl.specter.__GT_t_com$rpl$specter67208 = (function com$rpl$specter$__GT_t_com$rpl$specter67208(v__$1,meta67209){
return (new com.rpl.specter.t_com$rpl$specter67208(v__$1,meta67209));
});

}

return (new com.rpl.specter.t_com$rpl$specter67208(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentHashSet.EMPTY);
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = com.rpl.specter.nil__GT_val.call(null,cljs.core.List.EMPTY);
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentVector.EMPTY);


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67211 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67211 = (function (meta67212){
this.meta67212 = meta67212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67213,meta67212__$1){
var self__ = this;
var _67213__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67211(meta67212__$1));
});


com.rpl.specter.t_com$rpl$specter67211.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67213){
var self__ = this;
var _67213__$1 = this;
return self__.meta67212;
});


com.rpl.specter.t_com$rpl$specter67211.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67211.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.meta.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter67211.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter67211.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67212","meta67212",-40695617,null)], null);
});

com.rpl.specter.t_com$rpl$specter67211.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67211.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67211";

com.rpl.specter.t_com$rpl$specter67211.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67211");
});

com.rpl.specter.__GT_t_com$rpl$specter67211 = (function com$rpl$specter$__GT_t_com$rpl$specter67211(meta67212){
return (new com.rpl.specter.t_com$rpl$specter67211(meta67212));
});

}

return (new com.rpl.specter.t_com$rpl$specter67211(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.name.call(null,structure));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = next_fn.call(null,cljs.core.name.call(null,structure));
var ns = cljs.core.namespace.call(null,structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAME can only be used on symbols or keywords - ",structure)));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67214 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67214 = (function (meta67215){
this.meta67215 = meta67215;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67214.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67216,meta67215__$1){
var self__ = this;
var _67216__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67214(meta67215__$1));
});


com.rpl.specter.t_com$rpl$specter67214.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67216){
var self__ = this;
var _67216__$1 = this;
return self__.meta67215;
});


com.rpl.specter.t_com$rpl$specter67214.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67214.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.name.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter67214.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var new_name = next_fn.call(null,cljs.core.name.call(null,structure));
var ns = cljs.core.namespace.call(null,structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAME can only be used on symbols or keywords - ",structure)));

}
}
});

com.rpl.specter.t_com$rpl$specter67214.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67215","meta67215",-1500117064,null)], null);
});

com.rpl.specter.t_com$rpl$specter67214.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67214.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67214";

com.rpl.specter.t_com$rpl$specter67214.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67214");
});

com.rpl.specter.__GT_t_com$rpl$specter67214 = (function com$rpl$specter$__GT_t_com$rpl$specter67214(meta67215){
return (new com.rpl.specter.t_com$rpl$specter67214(meta67215));
});

}

return (new com.rpl.specter.t_com$rpl$specter67214(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.namespace.call(null,structure));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name.call(null,structure);
var new_ns = next_fn.call(null,cljs.core.namespace.call(null,structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAMESPACE can only be used on symbols or keywords - ",structure)));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67217 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67217 = (function (meta67218){
this.meta67218 = meta67218;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67217.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67219,meta67218__$1){
var self__ = this;
var _67219__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67217(meta67218__$1));
});


com.rpl.specter.t_com$rpl$specter67217.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67219){
var self__ = this;
var _67219__$1 = this;
return self__.meta67218;
});


com.rpl.specter.t_com$rpl$specter67217.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67217.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
return next_fn.call(null,cljs.core.namespace.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter67217.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34062__auto__,vals__34063__auto__,structure,next_fn__34064__auto__){
var self__ = this;
var this__34062__auto____$1 = this;
var next_fn = ((function (this__34062__auto____$1){
return (function (s__34065__auto__){
return next_fn__34064__auto__.call(null,vals__34063__auto__,s__34065__auto__);
});})(this__34062__auto____$1))
;
var name = cljs.core.name.call(null,structure);
var new_ns = next_fn.call(null,cljs.core.namespace.call(null,structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAMESPACE can only be used on symbols or keywords - ",structure)));

}
}
});

com.rpl.specter.t_com$rpl$specter67217.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67218","meta67218",162097078,null)], null);
});

com.rpl.specter.t_com$rpl$specter67217.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67217.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67217";

com.rpl.specter.t_com$rpl$specter67217.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67217");
});

com.rpl.specter.__GT_t_com$rpl$specter67217 = (function com$rpl$specter$__GT_t_com$rpl$specter67217(meta67218){
return (new com.rpl.specter.t_com$rpl$specter67217(meta67218));
});

}

return (new com.rpl.specter.t_com$rpl$specter67217(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67223__delegate = function (path){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter67220 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67220 = (function (path,late,meta67221){
this.path = path;
this.late = late;
this.meta67221 = meta67221;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67220.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67222,meta67221__$1){
var self__ = this;
var _67222__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67220(self__.path,self__.late,meta67221__$1));
});


com.rpl.specter.t_com$rpl$specter67220.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67222){
var self__ = this;
var _67222__$1 = this;
return self__.meta67221;
});


com.rpl.specter.t_com$rpl$specter67220.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67220.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});


com.rpl.specter.t_com$rpl$specter67220.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter67220.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta67221","meta67221",-1309983923,null)], null);
});

com.rpl.specter.t_com$rpl$specter67220.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67220.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67220";

com.rpl.specter.t_com$rpl$specter67220.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67220");
});

com.rpl.specter.__GT_t_com$rpl$specter67220 = (function com$rpl$specter$__GT_t_com$rpl$specter67220(path__$1,late__$1,meta67221){
return (new com.rpl.specter.t_com$rpl$specter67220(path__$1,late__$1,meta67221));
});

}

return (new com.rpl.specter.t_com$rpl$specter67220(path,late,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
};
var G__67223 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67224__i = 0, G__67224__a = new Array(arguments.length -  0);
while (G__67224__i < G__67224__a.length) {G__67224__a[G__67224__i] = arguments[G__67224__i + 0]; ++G__67224__i;}
  path = new cljs.core.IndexedSeq(G__67224__a,0,null);
} 
return G__67223__delegate.call(this,path);};
G__67223.cljs$lang$maxFixedArity = 0;
G__67223.cljs$lang$applyTo = (function (arglist__67225){
var path = cljs.core.seq(arglist__67225);
return G__67223__delegate(path);
});
G__67223.cljs$core$IFn$_invoke$arity$variadic = G__67223__delegate;
return G__67223;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67229__delegate = function (path){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter67226 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67226 = (function (path,late,meta67227){
this.path = path;
this.late = late;
this.meta67227 = meta67227;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67226.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67228,meta67227__$1){
var self__ = this;
var _67228__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67226(self__.path,self__.late,meta67227__$1));
});


com.rpl.specter.t_com$rpl$specter67226.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67228){
var self__ = this;
var _67228__$1 = this;
return self__.meta67227;
});


com.rpl.specter.t_com$rpl$specter67226.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67226.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});


com.rpl.specter.t_com$rpl$specter67226.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter67226.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta67227","meta67227",2008522459,null)], null);
});

com.rpl.specter.t_com$rpl$specter67226.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67226.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67226";

com.rpl.specter.t_com$rpl$specter67226.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67226");
});

com.rpl.specter.__GT_t_com$rpl$specter67226 = (function com$rpl$specter$__GT_t_com$rpl$specter67226(path__$1,late__$1,meta67227){
return (new com.rpl.specter.t_com$rpl$specter67226(path__$1,late__$1,meta67227));
});

}

return (new com.rpl.specter.t_com$rpl$specter67226(path,late,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
};
var G__67229 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67230__i = 0, G__67230__a = new Array(arguments.length -  0);
while (G__67230__i < G__67230__a.length) {G__67230__a[G__67230__i] = arguments[G__67230__i + 0]; ++G__67230__i;}
  path = new cljs.core.IndexedSeq(G__67230__a,0,null);
} 
return G__67229__delegate.call(this,path);};
G__67229.cljs$lang$maxFixedArity = 0;
G__67229.cljs$lang$applyTo = (function (arglist__67231){
var path = cljs.core.seq(arglist__67231);
return G__67229__delegate(path);
});
G__67229.cljs$core$IFn$_invoke$arity$variadic = G__67229__delegate;
return G__67229;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj.call(null,(function (val){
if(typeof com.rpl.specter.t_com$rpl$specter67232 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67232 = (function (val,meta67233){
this.val = val;
this.meta67233 = meta67233;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67232.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67234,meta67233__$1){
var self__ = this;
var _67234__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67232(self__.val,meta67233__$1));
});


com.rpl.specter.t_com$rpl$specter67232.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67234){
var self__ = this;
var _67234__$1 = this;
return self__.meta67233;
});


com.rpl.specter.t_com$rpl$specter67232.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67232.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,self__.val),structure);
});


com.rpl.specter.t_com$rpl$specter67232.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__34823__auto__,vals__34824__auto__,structure,next_fn__34825__auto__){
var self__ = this;
var this__34823__auto____$1 = this;
return next_fn__34825__auto__.call(null,cljs.core.conj.call(null,vals__34824__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter67232.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta67233","meta67233",175581814,null)], null);
});

com.rpl.specter.t_com$rpl$specter67232.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67232.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67232";

com.rpl.specter.t_com$rpl$specter67232.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67232");
});

com.rpl.specter.__GT_t_com$rpl$specter67232 = (function com$rpl$specter$__GT_t_com$rpl$specter67232(val__$1,meta67233){
return (new com.rpl.specter.t_com$rpl$specter67232(val__$1,meta67233));
});

}

return (new com.rpl.specter.t_com$rpl$specter67232(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67240__delegate = function (path){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter67235 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67235 = (function (path,late,meta67236){
this.path = path;
this.late = late;
this.meta67236 = meta67236;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67235.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67237,meta67236__$1){
var self__ = this;
var _67237__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67235(self__.path,self__.late,meta67236__$1));
});


com.rpl.specter.t_com$rpl$specter67235.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67237){
var self__ = this;
var _67237__$1 = this;
return self__.meta67236;
});


com.rpl.specter.t_com$rpl$specter67235.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67235.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_.call(null,self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return next_fn.call(null,vals,structure__$1);
});})(this$__$1))
);
});


com.rpl.specter.t_com$rpl$specter67235.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return next_fn.call(null,vals,structure__$1);
});})(this$__$1))
);
});

com.rpl.specter.t_com$rpl$specter67235.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta67236","meta67236",2090508154,null)], null);
});

com.rpl.specter.t_com$rpl$specter67235.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67235.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67235";

com.rpl.specter.t_com$rpl$specter67235.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67235");
});

com.rpl.specter.__GT_t_com$rpl$specter67235 = (function com$rpl$specter$__GT_t_com$rpl$specter67235(path__$1,late__$1,meta67236){
return (new com.rpl.specter.t_com$rpl$specter67235(path__$1,late__$1,meta67236));
});

}

return (new com.rpl.specter.t_com$rpl$specter67235(path,late,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
};
var G__67240 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67241__i = 0, G__67241__a = new Array(arguments.length -  0);
while (G__67241__i < G__67241__a.length) {G__67241__a[G__67241__i] = arguments[G__67241__i + 0]; ++G__67241__i;}
  path = new cljs.core.IndexedSeq(G__67241__a,0,null);
} 
return G__67240__delegate.call(this,path);};
G__67240.cljs$lang$maxFixedArity = 0;
G__67240.cljs$lang$applyTo = (function (arglist__67242){
var path = cljs.core.seq(arglist__67242);
return G__67240__delegate(path);
});
G__67240.cljs$core$IFn$_invoke$arity$variadic = G__67240__delegate;
return G__67240;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter67243 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67243 = (function (meta67244){
this.meta67244 = meta67244;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67243.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67245,meta67244__$1){
var self__ = this;
var _67245__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67243(meta67244__$1));
});


com.rpl.specter.t_com$rpl$specter67243.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67245){
var self__ = this;
var _67245__$1 = this;
return self__.meta67244;
});


com.rpl.specter.t_com$rpl$specter67243.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67243.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});


com.rpl.specter.t_com$rpl$specter67243.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter67243.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta67244","meta67244",-1873136014,null)], null);
});

com.rpl.specter.t_com$rpl$specter67243.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67243.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67243";

com.rpl.specter.t_com$rpl$specter67243.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67243");
});

com.rpl.specter.__GT_t_com$rpl$specter67243 = (function com$rpl$specter$__GT_t_com$rpl$specter67243(meta67244){
return (new com.rpl.specter.t_com$rpl$specter67243(meta67244));
});

}

return (new com.rpl.specter.t_com$rpl$specter67243(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() {
var G__67254 = null;
var G__67254__2 = (function (cond_p,then_path){
return com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP);
});
var G__67254__3 = (function (cond_p,then_path,else_path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,cond_p);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (afn,temp__4655__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter67248 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67248 = (function (cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,meta67249){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta67249 = meta67249;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67248.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__4655__auto__){
return (function (_67250,meta67249__$1){
var self__ = this;
var _67250__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67248(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.afn,self__.late_then,self__.late_else,meta67249__$1));
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67248.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__4655__auto__){
return (function (_67250){
var self__ = this;
var _67250__$1 = this;
return self__.meta67249;
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67248.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67248.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67248.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter67248.getBasis = ((function (afn,temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta67249","meta67249",-1209588922,null)], null);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter67248.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67248.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67248";

com.rpl.specter.t_com$rpl$specter67248.cljs$lang$ctorPrWriter = ((function (afn,temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67248");
});})(afn,temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter67248 = ((function (afn,temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter67248(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta67249){
return (new com.rpl.specter.t_com$rpl$specter67248(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta67249));
});})(afn,temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter67248(cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,null));
});})(afn,temp__4655__auto__))
);
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
} else {
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter67251 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67251 = (function (cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,meta67252){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta67252 = meta67252;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67251.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_67253,meta67252__$1){
var self__ = this;
var _67253__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67251(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.late_cond,self__.late_then,self__.late_else,meta67252__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67251.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_67253){
var self__ = this;
var _67253__$1 = this;
return self__.meta67252;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67251.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67251.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__67246_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,vals,p1__67246_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter67251.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__67247_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,vals,p1__67247_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter67251.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta67252","meta67252",-1350105304,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter67251.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67251.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67251";

com.rpl.specter.t_com$rpl$specter67251.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67251");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter67251 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter67251(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta67252){
return (new com.rpl.specter.t_com$rpl$specter67251(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta67252));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter67251(cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,null));
});})(temp__4655__auto__))
);
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,cond_p),com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
}
});
G__67254 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__67254__2.call(this,cond_p,then_path);
case 3:
return G__67254__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__67254.cljs$core$IFn$_invoke$arity$2 = G__67254__2;
G__67254.cljs$core$IFn$_invoke$arity$3 = G__67254__3;
return G__67254;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 * 
 * The input paths may be parameterized, in which case the result of cond-path
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67259__delegate = function (conds){
var pairs = cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),conds));
return cljs.core.reduce.call(null,((function (pairs){
return (function (p,p__67255){
var vec__67256 = p__67255;
var tester = cljs.core.nth.call(null,vec__67256,(0),null);
var apath = cljs.core.nth.call(null,vec__67256,(1),null);
return com.rpl.specter.if_path.call(null,tester,apath,p);
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__67259 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__67260__i = 0, G__67260__a = new Array(arguments.length -  0);
while (G__67260__i < G__67260__a.length) {G__67260__a[G__67260__i] = arguments[G__67260__i + 0]; ++G__67260__i;}
  conds = new cljs.core.IndexedSeq(G__67260__a,0,null);
} 
return G__67259__delegate.call(this,conds);};
G__67259.cljs$lang$maxFixedArity = 0;
G__67259.cljs$lang$applyTo = (function (arglist__67261){
var conds = cljs.core.seq(arglist__67261);
return G__67259__delegate(conds);
});
G__67259.cljs$core$IFn$_invoke$arity$variadic = G__67259__delegate;
return G__67259;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() {
var G__67269 = null;
var G__67269__0 = (function (){
return com.rpl.specter.STAY;
});
var G__67269__1 = (function (path){
return path;
});
var G__67269__2 = (function (path1,path2){
var builder__34826__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter67262 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter67262 = (function (path1,path2,late1,late2,meta67263){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta67263 = meta67263;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter67262.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67264,meta67263__$1){
var self__ = this;
var _67264__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter67262(self__.path1,self__.path2,self__.late1,self__.late2,meta67263__$1));
});


com.rpl.specter.t_com$rpl$specter67262.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67264){
var self__ = this;
var _67264__$1 = this;
return self__.meta67263;
});


com.rpl.specter.t_com$rpl$specter67262.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter67262.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_.call(null,res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
});


com.rpl.specter.t_com$rpl$specter67262.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_.call(null,self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late2,vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter67262.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta67263","meta67263",1801690689,null)], null);
});

com.rpl.specter.t_com$rpl$specter67262.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter67262.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter67262";

com.rpl.specter.t_com$rpl$specter67262.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter67262");
});

com.rpl.specter.__GT_t_com$rpl$specter67262 = (function com$rpl$specter$__GT_t_com$rpl$specter67262(path1__$1,path2__$1,late1__$1,late2__$1,meta67263){
return (new com.rpl.specter.t_com$rpl$specter67262(path1__$1,path2__$1,late1__$1,late2__$1,meta67263));
});

}

return (new com.rpl.specter.t_com$rpl$specter67262(path1,path2,late1,late2,null));
}));
var curr_params__34827__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path1),com.rpl.specter.late_path.call(null,path2)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__34827__auto__)){
return cljs.core.apply.call(null,builder__34826__auto__,curr_params__34827__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__34826__auto__,curr_params__34827__auto__,null);
}
});
var G__67269__3 = (function() { 
var G__67270__delegate = function (path1,path2,paths){
return cljs.core.reduce.call(null,com.rpl.specter.multi_path,com.rpl.specter.multi_path.call(null,path1,path2),paths);
};
var G__67270 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__67271__i = 0, G__67271__a = new Array(arguments.length -  2);
while (G__67271__i < G__67271__a.length) {G__67271__a[G__67271__i] = arguments[G__67271__i + 2]; ++G__67271__i;}
  paths = new cljs.core.IndexedSeq(G__67271__a,0,null);
} 
return G__67270__delegate.call(this,path1,path2,paths);};
G__67270.cljs$lang$maxFixedArity = 2;
G__67270.cljs$lang$applyTo = (function (arglist__67272){
var path1 = cljs.core.first(arglist__67272);
arglist__67272 = cljs.core.next(arglist__67272);
var path2 = cljs.core.first(arglist__67272);
var paths = cljs.core.rest(arglist__67272);
return G__67270__delegate(path1,path2,paths);
});
G__67270.cljs$core$IFn$_invoke$arity$variadic = G__67270__delegate;
return G__67270;
})()
;
G__67269 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__67269__0.call(this);
case 1:
return G__67269__1.call(this,path1);
case 2:
return G__67269__2.call(this,path1,path2);
default:
var G__67273 = null;
if (arguments.length > 2) {
var G__67274__i = 0, G__67274__a = new Array(arguments.length -  2);
while (G__67274__i < G__67274__a.length) {G__67274__a[G__67274__i] = arguments[G__67274__i + 2]; ++G__67274__i;}
G__67273 = new cljs.core.IndexedSeq(G__67274__a,0,null);
}
return G__67269__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__67273);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__67269.cljs$lang$maxFixedArity = 2;
G__67269.cljs$lang$applyTo = G__67269__3.cljs$lang$applyTo;
G__67269.cljs$core$IFn$_invoke$arity$0 = G__67269__0;
G__67269.cljs$core$IFn$_invoke$arity$1 = G__67269__1;
G__67269.cljs$core$IFn$_invoke$arity$2 = G__67269__2;
G__67269.cljs$core$IFn$_invoke$arity$variadic = G__67269__3.cljs$core$IFn$_invoke$arity$variadic;
return G__67269;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67275__delegate = function (path){
return com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path);
};
var G__67275 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67276__i = 0, G__67276__a = new Array(arguments.length -  0);
while (G__67276__i < G__67276__a.length) {G__67276__a[G__67276__i] = arguments[G__67276__i + 0]; ++G__67276__i;}
  path = new cljs.core.IndexedSeq(G__67276__a,0,null);
} 
return G__67275__delegate.call(this,path);};
G__67275.cljs$lang$maxFixedArity = 0;
G__67275.cljs$lang$applyTo = (function (arglist__67277){
var path = cljs.core.seq(arglist__67277);
return G__67275__delegate(path);
});
G__67275.cljs$core$IFn$_invoke$arity$variadic = G__67275__delegate;
return G__67275;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__67278__delegate = function (path){
return com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY);
};
var G__67278 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__67279__i = 0, G__67279__a = new Array(arguments.length -  0);
while (G__67279__i < G__67279__a.length) {G__67279__a[G__67279__i] = arguments[G__67279__i + 0]; ++G__67279__i;}
  path = new cljs.core.IndexedSeq(G__67279__a,0,null);
} 
return G__67278__delegate.call(this,path);};
G__67278.cljs$lang$maxFixedArity = 0;
G__67278.cljs$lang$applyTo = (function (arglist__67280){
var path = cljs.core.seq(arglist__67280);
return G__67278__delegate(path);
});
G__67278.cljs$core$IFn$_invoke$arity$variadic = G__67278__delegate;
return G__67278;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
var p = com.rpl.specter.impl.local_declarepath.call(null);
com.rpl.specter.impl.providepath_STAR_.call(null,p,(function (){var info__34833__auto__ = com.rpl.specter.pathcache67281;
var info__34833__auto____$1 = (((info__34833__auto__ == null))?(function (){var info67282 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",25,1,1237,1237,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.\n\n   The input paths may be parameterized, in which case the result of cond-path\n   will be parameterized in the order of which the parameterized navigators\n   were declared.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",7,1,true,1042,1046,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. This is the\n          late-bound parameterized version of using a function directly in a path.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym.call(null,afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",7,1,626,628,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse.call(null,cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",21,1,2086,2086,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",6,1,650,653,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym.call(null,p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache67281 = info67282;

return info67282;
})():info__34833__auto__);
var precompiled67283 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__34833__auto____$1);
var dynamic_QMARK___34834__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__34833__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___34834__auto__)){
return precompiled67283.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null));
} else {
return precompiled67283;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
var p = com.rpl.specter.impl.local_declarepath.call(null);
com.rpl.specter.impl.providepath_STAR_.call(null,p,(function (){var info__34833__auto__ = com.rpl.specter.pathcache67284;
var info__34833__auto____$1 = (((info__34833__auto__ == null))?(function (){var info67285 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",25,1,1237,1237,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.\n\n   The input paths may be parameterized, in which case the result of cond-path\n   will be parameterized in the order of which the parameterized navigators\n   were declared.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",7,1,true,1042,1046,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. This is the\n          late-bound parameterized version of using a function directly in a path.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym.call(null,afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",7,1,626,628,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse.call(null,cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",21,1,2086,2086,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",16,1,660,662,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym.call(null,p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache67284 = info67285;

return info67285;
})():info__34833__auto__);
var precompiled67286 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__34833__auto____$1);
var dynamic_QMARK___34834__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__34833__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___34834__auto__)){
return precompiled67286.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null));
} else {
return precompiled67286;
}
})());

return p;
}));

//# sourceMappingURL=specter.js.map?rel=1511404516842
