// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28141__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28141__auto__){
return or__28141__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28141__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__61965_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__61965_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__61966 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__61967 = null;
var count__61968 = (0);
var i__61969 = (0);
while(true){
if((i__61969 < count__61968)){
var n = cljs.core._nth.call(null,chunk__61967,i__61969);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__61970 = seq__61966;
var G__61971 = chunk__61967;
var G__61972 = count__61968;
var G__61973 = (i__61969 + (1));
seq__61966 = G__61970;
chunk__61967 = G__61971;
count__61968 = G__61972;
i__61969 = G__61973;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__61966);
if(temp__4657__auto__){
var seq__61966__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61966__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__61966__$1);
var G__61974 = cljs.core.chunk_rest.call(null,seq__61966__$1);
var G__61975 = c__28980__auto__;
var G__61976 = cljs.core.count.call(null,c__28980__auto__);
var G__61977 = (0);
seq__61966 = G__61974;
chunk__61967 = G__61975;
count__61968 = G__61976;
i__61969 = G__61977;
continue;
} else {
var n = cljs.core.first.call(null,seq__61966__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__61978 = cljs.core.next.call(null,seq__61966__$1);
var G__61979 = null;
var G__61980 = (0);
var G__61981 = (0);
seq__61966 = G__61978;
chunk__61967 = G__61979;
count__61968 = G__61980;
i__61969 = G__61981;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__61991_61999 = cljs.core.seq.call(null,deps);
var chunk__61992_62000 = null;
var count__61993_62001 = (0);
var i__61994_62002 = (0);
while(true){
if((i__61994_62002 < count__61993_62001)){
var dep_62003 = cljs.core._nth.call(null,chunk__61992_62000,i__61994_62002);
topo_sort_helper_STAR_.call(null,dep_62003,(depth + (1)),state);

var G__62004 = seq__61991_61999;
var G__62005 = chunk__61992_62000;
var G__62006 = count__61993_62001;
var G__62007 = (i__61994_62002 + (1));
seq__61991_61999 = G__62004;
chunk__61992_62000 = G__62005;
count__61993_62001 = G__62006;
i__61994_62002 = G__62007;
continue;
} else {
var temp__4657__auto___62008 = cljs.core.seq.call(null,seq__61991_61999);
if(temp__4657__auto___62008){
var seq__61991_62009__$1 = temp__4657__auto___62008;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61991_62009__$1)){
var c__28980__auto___62010 = cljs.core.chunk_first.call(null,seq__61991_62009__$1);
var G__62011 = cljs.core.chunk_rest.call(null,seq__61991_62009__$1);
var G__62012 = c__28980__auto___62010;
var G__62013 = cljs.core.count.call(null,c__28980__auto___62010);
var G__62014 = (0);
seq__61991_61999 = G__62011;
chunk__61992_62000 = G__62012;
count__61993_62001 = G__62013;
i__61994_62002 = G__62014;
continue;
} else {
var dep_62015 = cljs.core.first.call(null,seq__61991_62009__$1);
topo_sort_helper_STAR_.call(null,dep_62015,(depth + (1)),state);

var G__62016 = cljs.core.next.call(null,seq__61991_62009__$1);
var G__62017 = null;
var G__62018 = (0);
var G__62019 = (0);
seq__61991_61999 = G__62016;
chunk__61992_62000 = G__62017;
count__61993_62001 = G__62018;
i__61994_62002 = G__62019;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__61995){
var vec__61996 = p__61995;
var seq__61997 = cljs.core.seq.call(null,vec__61996);
var first__61998 = cljs.core.first.call(null,seq__61997);
var seq__61997__$1 = cljs.core.next.call(null,seq__61997);
var x = first__61998;
var xs = seq__61997__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__61996,seq__61997,first__61998,seq__61997__$1,x,xs,get_deps__$1){
return (function (p1__61982_SHARP_){
return clojure.set.difference.call(null,p1__61982_SHARP_,x);
});})(vec__61996,seq__61997,first__61998,seq__61997__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__62020 = cljs.core.seq.call(null,provides);
var chunk__62021 = null;
var count__62022 = (0);
var i__62023 = (0);
while(true){
if((i__62023 < count__62022)){
var prov = cljs.core._nth.call(null,chunk__62021,i__62023);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__62024_62032 = cljs.core.seq.call(null,requires);
var chunk__62025_62033 = null;
var count__62026_62034 = (0);
var i__62027_62035 = (0);
while(true){
if((i__62027_62035 < count__62026_62034)){
var req_62036 = cljs.core._nth.call(null,chunk__62025_62033,i__62027_62035);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_62036,prov);

var G__62037 = seq__62024_62032;
var G__62038 = chunk__62025_62033;
var G__62039 = count__62026_62034;
var G__62040 = (i__62027_62035 + (1));
seq__62024_62032 = G__62037;
chunk__62025_62033 = G__62038;
count__62026_62034 = G__62039;
i__62027_62035 = G__62040;
continue;
} else {
var temp__4657__auto___62041 = cljs.core.seq.call(null,seq__62024_62032);
if(temp__4657__auto___62041){
var seq__62024_62042__$1 = temp__4657__auto___62041;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62024_62042__$1)){
var c__28980__auto___62043 = cljs.core.chunk_first.call(null,seq__62024_62042__$1);
var G__62044 = cljs.core.chunk_rest.call(null,seq__62024_62042__$1);
var G__62045 = c__28980__auto___62043;
var G__62046 = cljs.core.count.call(null,c__28980__auto___62043);
var G__62047 = (0);
seq__62024_62032 = G__62044;
chunk__62025_62033 = G__62045;
count__62026_62034 = G__62046;
i__62027_62035 = G__62047;
continue;
} else {
var req_62048 = cljs.core.first.call(null,seq__62024_62042__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_62048,prov);

var G__62049 = cljs.core.next.call(null,seq__62024_62042__$1);
var G__62050 = null;
var G__62051 = (0);
var G__62052 = (0);
seq__62024_62032 = G__62049;
chunk__62025_62033 = G__62050;
count__62026_62034 = G__62051;
i__62027_62035 = G__62052;
continue;
}
} else {
}
}
break;
}

var G__62053 = seq__62020;
var G__62054 = chunk__62021;
var G__62055 = count__62022;
var G__62056 = (i__62023 + (1));
seq__62020 = G__62053;
chunk__62021 = G__62054;
count__62022 = G__62055;
i__62023 = G__62056;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__62020);
if(temp__4657__auto__){
var seq__62020__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62020__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__62020__$1);
var G__62057 = cljs.core.chunk_rest.call(null,seq__62020__$1);
var G__62058 = c__28980__auto__;
var G__62059 = cljs.core.count.call(null,c__28980__auto__);
var G__62060 = (0);
seq__62020 = G__62057;
chunk__62021 = G__62058;
count__62022 = G__62059;
i__62023 = G__62060;
continue;
} else {
var prov = cljs.core.first.call(null,seq__62020__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__62028_62061 = cljs.core.seq.call(null,requires);
var chunk__62029_62062 = null;
var count__62030_62063 = (0);
var i__62031_62064 = (0);
while(true){
if((i__62031_62064 < count__62030_62063)){
var req_62065 = cljs.core._nth.call(null,chunk__62029_62062,i__62031_62064);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_62065,prov);

var G__62066 = seq__62028_62061;
var G__62067 = chunk__62029_62062;
var G__62068 = count__62030_62063;
var G__62069 = (i__62031_62064 + (1));
seq__62028_62061 = G__62066;
chunk__62029_62062 = G__62067;
count__62030_62063 = G__62068;
i__62031_62064 = G__62069;
continue;
} else {
var temp__4657__auto___62070__$1 = cljs.core.seq.call(null,seq__62028_62061);
if(temp__4657__auto___62070__$1){
var seq__62028_62071__$1 = temp__4657__auto___62070__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62028_62071__$1)){
var c__28980__auto___62072 = cljs.core.chunk_first.call(null,seq__62028_62071__$1);
var G__62073 = cljs.core.chunk_rest.call(null,seq__62028_62071__$1);
var G__62074 = c__28980__auto___62072;
var G__62075 = cljs.core.count.call(null,c__28980__auto___62072);
var G__62076 = (0);
seq__62028_62061 = G__62073;
chunk__62029_62062 = G__62074;
count__62030_62063 = G__62075;
i__62031_62064 = G__62076;
continue;
} else {
var req_62077 = cljs.core.first.call(null,seq__62028_62071__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_62077,prov);

var G__62078 = cljs.core.next.call(null,seq__62028_62071__$1);
var G__62079 = null;
var G__62080 = (0);
var G__62081 = (0);
seq__62028_62061 = G__62078;
chunk__62029_62062 = G__62079;
count__62030_62063 = G__62080;
i__62031_62064 = G__62081;
continue;
}
} else {
}
}
break;
}

var G__62082 = cljs.core.next.call(null,seq__62020__$1);
var G__62083 = null;
var G__62084 = (0);
var G__62085 = (0);
seq__62020 = G__62082;
chunk__62021 = G__62083;
count__62022 = G__62084;
i__62023 = G__62085;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__62086_62090 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__62087_62091 = null;
var count__62088_62092 = (0);
var i__62089_62093 = (0);
while(true){
if((i__62089_62093 < count__62088_62092)){
var ns_62094 = cljs.core._nth.call(null,chunk__62087_62091,i__62089_62093);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_62094);

var G__62095 = seq__62086_62090;
var G__62096 = chunk__62087_62091;
var G__62097 = count__62088_62092;
var G__62098 = (i__62089_62093 + (1));
seq__62086_62090 = G__62095;
chunk__62087_62091 = G__62096;
count__62088_62092 = G__62097;
i__62089_62093 = G__62098;
continue;
} else {
var temp__4657__auto___62099 = cljs.core.seq.call(null,seq__62086_62090);
if(temp__4657__auto___62099){
var seq__62086_62100__$1 = temp__4657__auto___62099;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62086_62100__$1)){
var c__28980__auto___62101 = cljs.core.chunk_first.call(null,seq__62086_62100__$1);
var G__62102 = cljs.core.chunk_rest.call(null,seq__62086_62100__$1);
var G__62103 = c__28980__auto___62101;
var G__62104 = cljs.core.count.call(null,c__28980__auto___62101);
var G__62105 = (0);
seq__62086_62090 = G__62102;
chunk__62087_62091 = G__62103;
count__62088_62092 = G__62104;
i__62089_62093 = G__62105;
continue;
} else {
var ns_62106 = cljs.core.first.call(null,seq__62086_62100__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_62106);

var G__62107 = cljs.core.next.call(null,seq__62086_62100__$1);
var G__62108 = null;
var G__62109 = (0);
var G__62110 = (0);
seq__62086_62090 = G__62107;
chunk__62087_62091 = G__62108;
count__62088_62092 = G__62109;
i__62089_62093 = G__62110;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28141__auto__ = goog.require__;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__62111__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__62111 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__62112__i = 0, G__62112__a = new Array(arguments.length -  0);
while (G__62112__i < G__62112__a.length) {G__62112__a[G__62112__i] = arguments[G__62112__i + 0]; ++G__62112__i;}
  args = new cljs.core.IndexedSeq(G__62112__a,0,null);
} 
return G__62111__delegate.call(this,args);};
G__62111.cljs$lang$maxFixedArity = 0;
G__62111.cljs$lang$applyTo = (function (arglist__62113){
var args = cljs.core.seq(arglist__62113);
return G__62111__delegate(args);
});
G__62111.cljs$core$IFn$_invoke$arity$variadic = G__62111__delegate;
return G__62111;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__62114_SHARP_,p2__62115_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__62114_SHARP_)].join('')),p2__62115_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__62116_SHARP_,p2__62117_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__62116_SHARP_)].join(''),p2__62117_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__62118 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__62118.addCallback(((function (G__62118){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__62118))
);

G__62118.addErrback(((function (G__62118){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__62118))
);

return G__62118;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__62119 = cljs.core._EQ_;
var expr__62120 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__62119.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__62120))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__62119,expr__62120){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__62119,expr__62120))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__62119,expr__62120){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e62122){if((e62122 instanceof Error)){
var e = e62122;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e62122;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__62119,expr__62120))
} else {
if(cljs.core.truth_(pred__62119.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__62120))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__62119.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__62120))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__62119.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__62120))){
return ((function (pred__62119,expr__62120){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e62123){if((e62123 instanceof Error)){
var e = e62123;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e62123;

}
}})());
});
;})(pred__62119,expr__62120))
} else {
return ((function (pred__62119,expr__62120){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__62119,expr__62120))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__62124,callback){
var map__62125 = p__62124;
var map__62125__$1 = ((((!((map__62125 == null)))?((((map__62125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62125.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62125):map__62125);
var file_msg = map__62125__$1;
var request_url = cljs.core.get.call(null,map__62125__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__62125,map__62125__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__62125,map__62125__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_62149){
var state_val_62150 = (state_62149[(1)]);
if((state_val_62150 === (7))){
var inst_62145 = (state_62149[(2)]);
var state_62149__$1 = state_62149;
var statearr_62151_62168 = state_62149__$1;
(statearr_62151_62168[(2)] = inst_62145);

(statearr_62151_62168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62150 === (1))){
var state_62149__$1 = state_62149;
var statearr_62152_62169 = state_62149__$1;
(statearr_62152_62169[(2)] = null);

(statearr_62152_62169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62150 === (4))){
var inst_62129 = (state_62149[(7)]);
var inst_62129__$1 = (state_62149[(2)]);
var state_62149__$1 = (function (){var statearr_62153 = state_62149;
(statearr_62153[(7)] = inst_62129__$1);

return statearr_62153;
})();
if(cljs.core.truth_(inst_62129__$1)){
var statearr_62154_62170 = state_62149__$1;
(statearr_62154_62170[(1)] = (5));

} else {
var statearr_62155_62171 = state_62149__$1;
(statearr_62155_62171[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62150 === (6))){
var state_62149__$1 = state_62149;
var statearr_62156_62172 = state_62149__$1;
(statearr_62156_62172[(2)] = null);

(statearr_62156_62172[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62150 === (3))){
var inst_62147 = (state_62149[(2)]);
var state_62149__$1 = state_62149;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62149__$1,inst_62147);
} else {
if((state_val_62150 === (2))){
var state_62149__$1 = state_62149;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62149__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_62150 === (11))){
var inst_62141 = (state_62149[(2)]);
var state_62149__$1 = (function (){var statearr_62157 = state_62149;
(statearr_62157[(8)] = inst_62141);

return statearr_62157;
})();
var statearr_62158_62173 = state_62149__$1;
(statearr_62158_62173[(2)] = null);

(statearr_62158_62173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62150 === (9))){
var inst_62135 = (state_62149[(9)]);
var inst_62133 = (state_62149[(10)]);
var inst_62137 = inst_62135.call(null,inst_62133);
var state_62149__$1 = state_62149;
var statearr_62159_62174 = state_62149__$1;
(statearr_62159_62174[(2)] = inst_62137);

(statearr_62159_62174[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62150 === (5))){
var inst_62129 = (state_62149[(7)]);
var inst_62131 = figwheel.client.file_reloading.blocking_load.call(null,inst_62129);
var state_62149__$1 = state_62149;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62149__$1,(8),inst_62131);
} else {
if((state_val_62150 === (10))){
var inst_62133 = (state_62149[(10)]);
var inst_62139 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_62133);
var state_62149__$1 = state_62149;
var statearr_62160_62175 = state_62149__$1;
(statearr_62160_62175[(2)] = inst_62139);

(statearr_62160_62175[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62150 === (8))){
var inst_62129 = (state_62149[(7)]);
var inst_62135 = (state_62149[(9)]);
var inst_62133 = (state_62149[(2)]);
var inst_62134 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_62135__$1 = cljs.core.get.call(null,inst_62134,inst_62129);
var state_62149__$1 = (function (){var statearr_62161 = state_62149;
(statearr_62161[(9)] = inst_62135__$1);

(statearr_62161[(10)] = inst_62133);

return statearr_62161;
})();
if(cljs.core.truth_(inst_62135__$1)){
var statearr_62162_62176 = state_62149__$1;
(statearr_62162_62176[(1)] = (9));

} else {
var statearr_62163_62177 = state_62149__$1;
(statearr_62163_62177[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__47086__auto__ = null;
var figwheel$client$file_reloading$state_machine__47086__auto____0 = (function (){
var statearr_62164 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_62164[(0)] = figwheel$client$file_reloading$state_machine__47086__auto__);

(statearr_62164[(1)] = (1));

return statearr_62164;
});
var figwheel$client$file_reloading$state_machine__47086__auto____1 = (function (state_62149){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_62149);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e62165){if((e62165 instanceof Object)){
var ex__47089__auto__ = e62165;
var statearr_62166_62178 = state_62149;
(statearr_62166_62178[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62149);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62165;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62179 = state_62149;
state_62149 = G__62179;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__47086__auto__ = function(state_62149){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__47086__auto____1.call(this,state_62149);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__47086__auto____0;
figwheel$client$file_reloading$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__47086__auto____1;
return figwheel$client$file_reloading$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_62167 = f__47174__auto__.call(null);
(statearr_62167[(6)] = c__47173__auto__);

return statearr_62167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__62180,callback){
var map__62181 = p__62180;
var map__62181__$1 = ((((!((map__62181 == null)))?((((map__62181.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62181.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62181):map__62181);
var file_msg = map__62181__$1;
var namespace = cljs.core.get.call(null,map__62181__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__62181,map__62181__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__62181,map__62181__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__62183){
var map__62184 = p__62183;
var map__62184__$1 = ((((!((map__62184 == null)))?((((map__62184.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62184.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62184):map__62184);
var file_msg = map__62184__$1;
var namespace = cljs.core.get.call(null,map__62184__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__62186){
var map__62187 = p__62186;
var map__62187__$1 = ((((!((map__62187 == null)))?((((map__62187.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62187.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62187):map__62187);
var file_msg = map__62187__$1;
var namespace = cljs.core.get.call(null,map__62187__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28129__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28129__auto__){
var or__28141__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28129__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__62189,callback){
var map__62190 = p__62189;
var map__62190__$1 = ((((!((map__62190 == null)))?((((map__62190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62190.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62190):map__62190);
var file_msg = map__62190__$1;
var request_url = cljs.core.get.call(null,map__62190__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__62190__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__47173__auto___62240 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___62240,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___62240,out){
return (function (state_62225){
var state_val_62226 = (state_62225[(1)]);
if((state_val_62226 === (1))){
var inst_62199 = cljs.core.seq.call(null,files);
var inst_62200 = cljs.core.first.call(null,inst_62199);
var inst_62201 = cljs.core.next.call(null,inst_62199);
var inst_62202 = files;
var state_62225__$1 = (function (){var statearr_62227 = state_62225;
(statearr_62227[(7)] = inst_62201);

(statearr_62227[(8)] = inst_62200);

(statearr_62227[(9)] = inst_62202);

return statearr_62227;
})();
var statearr_62228_62241 = state_62225__$1;
(statearr_62228_62241[(2)] = null);

(statearr_62228_62241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62226 === (2))){
var inst_62208 = (state_62225[(10)]);
var inst_62202 = (state_62225[(9)]);
var inst_62207 = cljs.core.seq.call(null,inst_62202);
var inst_62208__$1 = cljs.core.first.call(null,inst_62207);
var inst_62209 = cljs.core.next.call(null,inst_62207);
var inst_62210 = (inst_62208__$1 == null);
var inst_62211 = cljs.core.not.call(null,inst_62210);
var state_62225__$1 = (function (){var statearr_62229 = state_62225;
(statearr_62229[(10)] = inst_62208__$1);

(statearr_62229[(11)] = inst_62209);

return statearr_62229;
})();
if(inst_62211){
var statearr_62230_62242 = state_62225__$1;
(statearr_62230_62242[(1)] = (4));

} else {
var statearr_62231_62243 = state_62225__$1;
(statearr_62231_62243[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62226 === (3))){
var inst_62223 = (state_62225[(2)]);
var state_62225__$1 = state_62225;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62225__$1,inst_62223);
} else {
if((state_val_62226 === (4))){
var inst_62208 = (state_62225[(10)]);
var inst_62213 = figwheel.client.file_reloading.reload_js_file.call(null,inst_62208);
var state_62225__$1 = state_62225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62225__$1,(7),inst_62213);
} else {
if((state_val_62226 === (5))){
var inst_62219 = cljs.core.async.close_BANG_.call(null,out);
var state_62225__$1 = state_62225;
var statearr_62232_62244 = state_62225__$1;
(statearr_62232_62244[(2)] = inst_62219);

(statearr_62232_62244[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62226 === (6))){
var inst_62221 = (state_62225[(2)]);
var state_62225__$1 = state_62225;
var statearr_62233_62245 = state_62225__$1;
(statearr_62233_62245[(2)] = inst_62221);

(statearr_62233_62245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62226 === (7))){
var inst_62209 = (state_62225[(11)]);
var inst_62215 = (state_62225[(2)]);
var inst_62216 = cljs.core.async.put_BANG_.call(null,out,inst_62215);
var inst_62202 = inst_62209;
var state_62225__$1 = (function (){var statearr_62234 = state_62225;
(statearr_62234[(12)] = inst_62216);

(statearr_62234[(9)] = inst_62202);

return statearr_62234;
})();
var statearr_62235_62246 = state_62225__$1;
(statearr_62235_62246[(2)] = null);

(statearr_62235_62246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__47173__auto___62240,out))
;
return ((function (switch__47085__auto__,c__47173__auto___62240,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____0 = (function (){
var statearr_62236 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62236[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__);

(statearr_62236[(1)] = (1));

return statearr_62236;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____1 = (function (state_62225){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_62225);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e62237){if((e62237 instanceof Object)){
var ex__47089__auto__ = e62237;
var statearr_62238_62247 = state_62225;
(statearr_62238_62247[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62225);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62237;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62248 = state_62225;
state_62225 = G__62248;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__ = function(state_62225){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____1.call(this,state_62225);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___62240,out))
})();
var state__47175__auto__ = (function (){var statearr_62239 = f__47174__auto__.call(null);
(statearr_62239[(6)] = c__47173__auto___62240);

return statearr_62239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___62240,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__62249,opts){
var map__62250 = p__62249;
var map__62250__$1 = ((((!((map__62250 == null)))?((((map__62250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62250.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62250):map__62250);
var eval_body = cljs.core.get.call(null,map__62250__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__62250__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28129__auto__ = eval_body;
if(cljs.core.truth_(and__28129__auto__)){
return typeof eval_body === 'string';
} else {
return and__28129__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e62252){var e = e62252;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__62253_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__62253_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__62254){
var vec__62255 = p__62254;
var k = cljs.core.nth.call(null,vec__62255,(0),null);
var v = cljs.core.nth.call(null,vec__62255,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__62258){
var vec__62259 = p__62258;
var k = cljs.core.nth.call(null,vec__62259,(0),null);
var v = cljs.core.nth.call(null,vec__62259,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__62265,p__62266){
var map__62267 = p__62265;
var map__62267__$1 = ((((!((map__62267 == null)))?((((map__62267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62267.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62267):map__62267);
var opts = map__62267__$1;
var before_jsload = cljs.core.get.call(null,map__62267__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__62267__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__62267__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__62268 = p__62266;
var map__62268__$1 = ((((!((map__62268 == null)))?((((map__62268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62268.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62268):map__62268);
var msg = map__62268__$1;
var files = cljs.core.get.call(null,map__62268__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__62268__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__62268__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_62422){
var state_val_62423 = (state_62422[(1)]);
if((state_val_62423 === (7))){
var inst_62285 = (state_62422[(7)]);
var inst_62284 = (state_62422[(8)]);
var inst_62283 = (state_62422[(9)]);
var inst_62282 = (state_62422[(10)]);
var inst_62290 = cljs.core._nth.call(null,inst_62283,inst_62285);
var inst_62291 = figwheel.client.file_reloading.eval_body.call(null,inst_62290,opts);
var inst_62292 = (inst_62285 + (1));
var tmp62424 = inst_62284;
var tmp62425 = inst_62283;
var tmp62426 = inst_62282;
var inst_62282__$1 = tmp62426;
var inst_62283__$1 = tmp62425;
var inst_62284__$1 = tmp62424;
var inst_62285__$1 = inst_62292;
var state_62422__$1 = (function (){var statearr_62427 = state_62422;
(statearr_62427[(7)] = inst_62285__$1);

(statearr_62427[(8)] = inst_62284__$1);

(statearr_62427[(9)] = inst_62283__$1);

(statearr_62427[(10)] = inst_62282__$1);

(statearr_62427[(11)] = inst_62291);

return statearr_62427;
})();
var statearr_62428_62511 = state_62422__$1;
(statearr_62428_62511[(2)] = null);

(statearr_62428_62511[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (20))){
var inst_62325 = (state_62422[(12)]);
var inst_62333 = figwheel.client.file_reloading.sort_files.call(null,inst_62325);
var state_62422__$1 = state_62422;
var statearr_62429_62512 = state_62422__$1;
(statearr_62429_62512[(2)] = inst_62333);

(statearr_62429_62512[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (27))){
var state_62422__$1 = state_62422;
var statearr_62430_62513 = state_62422__$1;
(statearr_62430_62513[(2)] = null);

(statearr_62430_62513[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (1))){
var inst_62274 = (state_62422[(13)]);
var inst_62271 = before_jsload.call(null,files);
var inst_62272 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_62273 = (function (){return ((function (inst_62274,inst_62271,inst_62272,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__62262_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__62262_SHARP_);
});
;})(inst_62274,inst_62271,inst_62272,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62274__$1 = cljs.core.filter.call(null,inst_62273,files);
var inst_62275 = cljs.core.not_empty.call(null,inst_62274__$1);
var state_62422__$1 = (function (){var statearr_62431 = state_62422;
(statearr_62431[(14)] = inst_62271);

(statearr_62431[(13)] = inst_62274__$1);

(statearr_62431[(15)] = inst_62272);

return statearr_62431;
})();
if(cljs.core.truth_(inst_62275)){
var statearr_62432_62514 = state_62422__$1;
(statearr_62432_62514[(1)] = (2));

} else {
var statearr_62433_62515 = state_62422__$1;
(statearr_62433_62515[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (24))){
var state_62422__$1 = state_62422;
var statearr_62434_62516 = state_62422__$1;
(statearr_62434_62516[(2)] = null);

(statearr_62434_62516[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (39))){
var inst_62375 = (state_62422[(16)]);
var state_62422__$1 = state_62422;
var statearr_62435_62517 = state_62422__$1;
(statearr_62435_62517[(2)] = inst_62375);

(statearr_62435_62517[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (46))){
var inst_62417 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
var statearr_62436_62518 = state_62422__$1;
(statearr_62436_62518[(2)] = inst_62417);

(statearr_62436_62518[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (4))){
var inst_62319 = (state_62422[(2)]);
var inst_62320 = cljs.core.List.EMPTY;
var inst_62321 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_62320);
var inst_62322 = (function (){return ((function (inst_62319,inst_62320,inst_62321,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__62263_SHARP_){
var and__28129__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__62263_SHARP_);
if(cljs.core.truth_(and__28129__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__62263_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__62263_SHARP_)));
} else {
return and__28129__auto__;
}
});
;})(inst_62319,inst_62320,inst_62321,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62323 = cljs.core.filter.call(null,inst_62322,files);
var inst_62324 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_62325 = cljs.core.concat.call(null,inst_62323,inst_62324);
var state_62422__$1 = (function (){var statearr_62437 = state_62422;
(statearr_62437[(17)] = inst_62321);

(statearr_62437[(12)] = inst_62325);

(statearr_62437[(18)] = inst_62319);

return statearr_62437;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_62438_62519 = state_62422__$1;
(statearr_62438_62519[(1)] = (16));

} else {
var statearr_62439_62520 = state_62422__$1;
(statearr_62439_62520[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (15))){
var inst_62309 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
var statearr_62440_62521 = state_62422__$1;
(statearr_62440_62521[(2)] = inst_62309);

(statearr_62440_62521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (21))){
var inst_62335 = (state_62422[(19)]);
var inst_62335__$1 = (state_62422[(2)]);
var inst_62336 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_62335__$1);
var state_62422__$1 = (function (){var statearr_62441 = state_62422;
(statearr_62441[(19)] = inst_62335__$1);

return statearr_62441;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62422__$1,(22),inst_62336);
} else {
if((state_val_62423 === (31))){
var inst_62420 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62422__$1,inst_62420);
} else {
if((state_val_62423 === (32))){
var inst_62375 = (state_62422[(16)]);
var inst_62380 = inst_62375.cljs$lang$protocol_mask$partition0$;
var inst_62381 = (inst_62380 & (64));
var inst_62382 = inst_62375.cljs$core$ISeq$;
var inst_62383 = (cljs.core.PROTOCOL_SENTINEL === inst_62382);
var inst_62384 = (inst_62381) || (inst_62383);
var state_62422__$1 = state_62422;
if(cljs.core.truth_(inst_62384)){
var statearr_62442_62522 = state_62422__$1;
(statearr_62442_62522[(1)] = (35));

} else {
var statearr_62443_62523 = state_62422__$1;
(statearr_62443_62523[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (40))){
var inst_62397 = (state_62422[(20)]);
var inst_62396 = (state_62422[(2)]);
var inst_62397__$1 = cljs.core.get.call(null,inst_62396,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_62398 = cljs.core.get.call(null,inst_62396,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_62399 = cljs.core.not_empty.call(null,inst_62397__$1);
var state_62422__$1 = (function (){var statearr_62444 = state_62422;
(statearr_62444[(20)] = inst_62397__$1);

(statearr_62444[(21)] = inst_62398);

return statearr_62444;
})();
if(cljs.core.truth_(inst_62399)){
var statearr_62445_62524 = state_62422__$1;
(statearr_62445_62524[(1)] = (41));

} else {
var statearr_62446_62525 = state_62422__$1;
(statearr_62446_62525[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (33))){
var state_62422__$1 = state_62422;
var statearr_62447_62526 = state_62422__$1;
(statearr_62447_62526[(2)] = false);

(statearr_62447_62526[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (13))){
var inst_62295 = (state_62422[(22)]);
var inst_62299 = cljs.core.chunk_first.call(null,inst_62295);
var inst_62300 = cljs.core.chunk_rest.call(null,inst_62295);
var inst_62301 = cljs.core.count.call(null,inst_62299);
var inst_62282 = inst_62300;
var inst_62283 = inst_62299;
var inst_62284 = inst_62301;
var inst_62285 = (0);
var state_62422__$1 = (function (){var statearr_62448 = state_62422;
(statearr_62448[(7)] = inst_62285);

(statearr_62448[(8)] = inst_62284);

(statearr_62448[(9)] = inst_62283);

(statearr_62448[(10)] = inst_62282);

return statearr_62448;
})();
var statearr_62449_62527 = state_62422__$1;
(statearr_62449_62527[(2)] = null);

(statearr_62449_62527[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (22))){
var inst_62343 = (state_62422[(23)]);
var inst_62338 = (state_62422[(24)]);
var inst_62339 = (state_62422[(25)]);
var inst_62335 = (state_62422[(19)]);
var inst_62338__$1 = (state_62422[(2)]);
var inst_62339__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_62338__$1);
var inst_62340 = (function (){var all_files = inst_62335;
var res_SINGLEQUOTE_ = inst_62338__$1;
var res = inst_62339__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_62343,inst_62338,inst_62339,inst_62335,inst_62338__$1,inst_62339__$1,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__62264_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__62264_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_62343,inst_62338,inst_62339,inst_62335,inst_62338__$1,inst_62339__$1,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62341 = cljs.core.filter.call(null,inst_62340,inst_62338__$1);
var inst_62342 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_62343__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_62342);
var inst_62344 = cljs.core.not_empty.call(null,inst_62343__$1);
var state_62422__$1 = (function (){var statearr_62450 = state_62422;
(statearr_62450[(26)] = inst_62341);

(statearr_62450[(23)] = inst_62343__$1);

(statearr_62450[(24)] = inst_62338__$1);

(statearr_62450[(25)] = inst_62339__$1);

return statearr_62450;
})();
if(cljs.core.truth_(inst_62344)){
var statearr_62451_62528 = state_62422__$1;
(statearr_62451_62528[(1)] = (23));

} else {
var statearr_62452_62529 = state_62422__$1;
(statearr_62452_62529[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (36))){
var state_62422__$1 = state_62422;
var statearr_62453_62530 = state_62422__$1;
(statearr_62453_62530[(2)] = false);

(statearr_62453_62530[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (41))){
var inst_62397 = (state_62422[(20)]);
var inst_62401 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_62402 = cljs.core.map.call(null,inst_62401,inst_62397);
var inst_62403 = cljs.core.pr_str.call(null,inst_62402);
var inst_62404 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62403)].join('');
var inst_62405 = figwheel.client.utils.log.call(null,inst_62404);
var state_62422__$1 = state_62422;
var statearr_62454_62531 = state_62422__$1;
(statearr_62454_62531[(2)] = inst_62405);

(statearr_62454_62531[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (43))){
var inst_62398 = (state_62422[(21)]);
var inst_62408 = (state_62422[(2)]);
var inst_62409 = cljs.core.not_empty.call(null,inst_62398);
var state_62422__$1 = (function (){var statearr_62455 = state_62422;
(statearr_62455[(27)] = inst_62408);

return statearr_62455;
})();
if(cljs.core.truth_(inst_62409)){
var statearr_62456_62532 = state_62422__$1;
(statearr_62456_62532[(1)] = (44));

} else {
var statearr_62457_62533 = state_62422__$1;
(statearr_62457_62533[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (29))){
var inst_62375 = (state_62422[(16)]);
var inst_62341 = (state_62422[(26)]);
var inst_62343 = (state_62422[(23)]);
var inst_62338 = (state_62422[(24)]);
var inst_62339 = (state_62422[(25)]);
var inst_62335 = (state_62422[(19)]);
var inst_62371 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_62374 = (function (){var all_files = inst_62335;
var res_SINGLEQUOTE_ = inst_62338;
var res = inst_62339;
var files_not_loaded = inst_62341;
var dependencies_that_loaded = inst_62343;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62375,inst_62341,inst_62343,inst_62338,inst_62339,inst_62335,inst_62371,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__62373){
var map__62458 = p__62373;
var map__62458__$1 = ((((!((map__62458 == null)))?((((map__62458.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62458.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62458):map__62458);
var namespace = cljs.core.get.call(null,map__62458__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62375,inst_62341,inst_62343,inst_62338,inst_62339,inst_62335,inst_62371,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62375__$1 = cljs.core.group_by.call(null,inst_62374,inst_62341);
var inst_62377 = (inst_62375__$1 == null);
var inst_62378 = cljs.core.not.call(null,inst_62377);
var state_62422__$1 = (function (){var statearr_62460 = state_62422;
(statearr_62460[(16)] = inst_62375__$1);

(statearr_62460[(28)] = inst_62371);

return statearr_62460;
})();
if(inst_62378){
var statearr_62461_62534 = state_62422__$1;
(statearr_62461_62534[(1)] = (32));

} else {
var statearr_62462_62535 = state_62422__$1;
(statearr_62462_62535[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (44))){
var inst_62398 = (state_62422[(21)]);
var inst_62411 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_62398);
var inst_62412 = cljs.core.pr_str.call(null,inst_62411);
var inst_62413 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62412)].join('');
var inst_62414 = figwheel.client.utils.log.call(null,inst_62413);
var state_62422__$1 = state_62422;
var statearr_62463_62536 = state_62422__$1;
(statearr_62463_62536[(2)] = inst_62414);

(statearr_62463_62536[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (6))){
var inst_62316 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
var statearr_62464_62537 = state_62422__$1;
(statearr_62464_62537[(2)] = inst_62316);

(statearr_62464_62537[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (28))){
var inst_62341 = (state_62422[(26)]);
var inst_62368 = (state_62422[(2)]);
var inst_62369 = cljs.core.not_empty.call(null,inst_62341);
var state_62422__$1 = (function (){var statearr_62465 = state_62422;
(statearr_62465[(29)] = inst_62368);

return statearr_62465;
})();
if(cljs.core.truth_(inst_62369)){
var statearr_62466_62538 = state_62422__$1;
(statearr_62466_62538[(1)] = (29));

} else {
var statearr_62467_62539 = state_62422__$1;
(statearr_62467_62539[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (25))){
var inst_62339 = (state_62422[(25)]);
var inst_62355 = (state_62422[(2)]);
var inst_62356 = cljs.core.not_empty.call(null,inst_62339);
var state_62422__$1 = (function (){var statearr_62468 = state_62422;
(statearr_62468[(30)] = inst_62355);

return statearr_62468;
})();
if(cljs.core.truth_(inst_62356)){
var statearr_62469_62540 = state_62422__$1;
(statearr_62469_62540[(1)] = (26));

} else {
var statearr_62470_62541 = state_62422__$1;
(statearr_62470_62541[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (34))){
var inst_62391 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
if(cljs.core.truth_(inst_62391)){
var statearr_62471_62542 = state_62422__$1;
(statearr_62471_62542[(1)] = (38));

} else {
var statearr_62472_62543 = state_62422__$1;
(statearr_62472_62543[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (17))){
var state_62422__$1 = state_62422;
var statearr_62473_62544 = state_62422__$1;
(statearr_62473_62544[(2)] = recompile_dependents);

(statearr_62473_62544[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (3))){
var state_62422__$1 = state_62422;
var statearr_62474_62545 = state_62422__$1;
(statearr_62474_62545[(2)] = null);

(statearr_62474_62545[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (12))){
var inst_62312 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
var statearr_62475_62546 = state_62422__$1;
(statearr_62475_62546[(2)] = inst_62312);

(statearr_62475_62546[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (2))){
var inst_62274 = (state_62422[(13)]);
var inst_62281 = cljs.core.seq.call(null,inst_62274);
var inst_62282 = inst_62281;
var inst_62283 = null;
var inst_62284 = (0);
var inst_62285 = (0);
var state_62422__$1 = (function (){var statearr_62476 = state_62422;
(statearr_62476[(7)] = inst_62285);

(statearr_62476[(8)] = inst_62284);

(statearr_62476[(9)] = inst_62283);

(statearr_62476[(10)] = inst_62282);

return statearr_62476;
})();
var statearr_62477_62547 = state_62422__$1;
(statearr_62477_62547[(2)] = null);

(statearr_62477_62547[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (23))){
var inst_62341 = (state_62422[(26)]);
var inst_62343 = (state_62422[(23)]);
var inst_62338 = (state_62422[(24)]);
var inst_62339 = (state_62422[(25)]);
var inst_62335 = (state_62422[(19)]);
var inst_62346 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_62348 = (function (){var all_files = inst_62335;
var res_SINGLEQUOTE_ = inst_62338;
var res = inst_62339;
var files_not_loaded = inst_62341;
var dependencies_that_loaded = inst_62343;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62341,inst_62343,inst_62338,inst_62339,inst_62335,inst_62346,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__62347){
var map__62478 = p__62347;
var map__62478__$1 = ((((!((map__62478 == null)))?((((map__62478.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62478.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62478):map__62478);
var request_url = cljs.core.get.call(null,map__62478__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62341,inst_62343,inst_62338,inst_62339,inst_62335,inst_62346,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62349 = cljs.core.reverse.call(null,inst_62343);
var inst_62350 = cljs.core.map.call(null,inst_62348,inst_62349);
var inst_62351 = cljs.core.pr_str.call(null,inst_62350);
var inst_62352 = figwheel.client.utils.log.call(null,inst_62351);
var state_62422__$1 = (function (){var statearr_62480 = state_62422;
(statearr_62480[(31)] = inst_62346);

return statearr_62480;
})();
var statearr_62481_62548 = state_62422__$1;
(statearr_62481_62548[(2)] = inst_62352);

(statearr_62481_62548[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (35))){
var state_62422__$1 = state_62422;
var statearr_62482_62549 = state_62422__$1;
(statearr_62482_62549[(2)] = true);

(statearr_62482_62549[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (19))){
var inst_62325 = (state_62422[(12)]);
var inst_62331 = figwheel.client.file_reloading.expand_files.call(null,inst_62325);
var state_62422__$1 = state_62422;
var statearr_62483_62550 = state_62422__$1;
(statearr_62483_62550[(2)] = inst_62331);

(statearr_62483_62550[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (11))){
var state_62422__$1 = state_62422;
var statearr_62484_62551 = state_62422__$1;
(statearr_62484_62551[(2)] = null);

(statearr_62484_62551[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (9))){
var inst_62314 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
var statearr_62485_62552 = state_62422__$1;
(statearr_62485_62552[(2)] = inst_62314);

(statearr_62485_62552[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (5))){
var inst_62285 = (state_62422[(7)]);
var inst_62284 = (state_62422[(8)]);
var inst_62287 = (inst_62285 < inst_62284);
var inst_62288 = inst_62287;
var state_62422__$1 = state_62422;
if(cljs.core.truth_(inst_62288)){
var statearr_62486_62553 = state_62422__$1;
(statearr_62486_62553[(1)] = (7));

} else {
var statearr_62487_62554 = state_62422__$1;
(statearr_62487_62554[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (14))){
var inst_62295 = (state_62422[(22)]);
var inst_62304 = cljs.core.first.call(null,inst_62295);
var inst_62305 = figwheel.client.file_reloading.eval_body.call(null,inst_62304,opts);
var inst_62306 = cljs.core.next.call(null,inst_62295);
var inst_62282 = inst_62306;
var inst_62283 = null;
var inst_62284 = (0);
var inst_62285 = (0);
var state_62422__$1 = (function (){var statearr_62488 = state_62422;
(statearr_62488[(32)] = inst_62305);

(statearr_62488[(7)] = inst_62285);

(statearr_62488[(8)] = inst_62284);

(statearr_62488[(9)] = inst_62283);

(statearr_62488[(10)] = inst_62282);

return statearr_62488;
})();
var statearr_62489_62555 = state_62422__$1;
(statearr_62489_62555[(2)] = null);

(statearr_62489_62555[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (45))){
var state_62422__$1 = state_62422;
var statearr_62490_62556 = state_62422__$1;
(statearr_62490_62556[(2)] = null);

(statearr_62490_62556[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (26))){
var inst_62341 = (state_62422[(26)]);
var inst_62343 = (state_62422[(23)]);
var inst_62338 = (state_62422[(24)]);
var inst_62339 = (state_62422[(25)]);
var inst_62335 = (state_62422[(19)]);
var inst_62358 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_62360 = (function (){var all_files = inst_62335;
var res_SINGLEQUOTE_ = inst_62338;
var res = inst_62339;
var files_not_loaded = inst_62341;
var dependencies_that_loaded = inst_62343;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62341,inst_62343,inst_62338,inst_62339,inst_62335,inst_62358,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__62359){
var map__62491 = p__62359;
var map__62491__$1 = ((((!((map__62491 == null)))?((((map__62491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62491.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62491):map__62491);
var namespace = cljs.core.get.call(null,map__62491__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__62491__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62341,inst_62343,inst_62338,inst_62339,inst_62335,inst_62358,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62361 = cljs.core.map.call(null,inst_62360,inst_62339);
var inst_62362 = cljs.core.pr_str.call(null,inst_62361);
var inst_62363 = figwheel.client.utils.log.call(null,inst_62362);
var inst_62364 = (function (){var all_files = inst_62335;
var res_SINGLEQUOTE_ = inst_62338;
var res = inst_62339;
var files_not_loaded = inst_62341;
var dependencies_that_loaded = inst_62343;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62341,inst_62343,inst_62338,inst_62339,inst_62335,inst_62358,inst_62360,inst_62361,inst_62362,inst_62363,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_62341,inst_62343,inst_62338,inst_62339,inst_62335,inst_62358,inst_62360,inst_62361,inst_62362,inst_62363,state_val_62423,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_62365 = setTimeout(inst_62364,(10));
var state_62422__$1 = (function (){var statearr_62493 = state_62422;
(statearr_62493[(33)] = inst_62358);

(statearr_62493[(34)] = inst_62363);

return statearr_62493;
})();
var statearr_62494_62557 = state_62422__$1;
(statearr_62494_62557[(2)] = inst_62365);

(statearr_62494_62557[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (16))){
var state_62422__$1 = state_62422;
var statearr_62495_62558 = state_62422__$1;
(statearr_62495_62558[(2)] = reload_dependents);

(statearr_62495_62558[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (38))){
var inst_62375 = (state_62422[(16)]);
var inst_62393 = cljs.core.apply.call(null,cljs.core.hash_map,inst_62375);
var state_62422__$1 = state_62422;
var statearr_62496_62559 = state_62422__$1;
(statearr_62496_62559[(2)] = inst_62393);

(statearr_62496_62559[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (30))){
var state_62422__$1 = state_62422;
var statearr_62497_62560 = state_62422__$1;
(statearr_62497_62560[(2)] = null);

(statearr_62497_62560[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (10))){
var inst_62295 = (state_62422[(22)]);
var inst_62297 = cljs.core.chunked_seq_QMARK_.call(null,inst_62295);
var state_62422__$1 = state_62422;
if(inst_62297){
var statearr_62498_62561 = state_62422__$1;
(statearr_62498_62561[(1)] = (13));

} else {
var statearr_62499_62562 = state_62422__$1;
(statearr_62499_62562[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (18))){
var inst_62329 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
if(cljs.core.truth_(inst_62329)){
var statearr_62500_62563 = state_62422__$1;
(statearr_62500_62563[(1)] = (19));

} else {
var statearr_62501_62564 = state_62422__$1;
(statearr_62501_62564[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (42))){
var state_62422__$1 = state_62422;
var statearr_62502_62565 = state_62422__$1;
(statearr_62502_62565[(2)] = null);

(statearr_62502_62565[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (37))){
var inst_62388 = (state_62422[(2)]);
var state_62422__$1 = state_62422;
var statearr_62503_62566 = state_62422__$1;
(statearr_62503_62566[(2)] = inst_62388);

(statearr_62503_62566[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62423 === (8))){
var inst_62282 = (state_62422[(10)]);
var inst_62295 = (state_62422[(22)]);
var inst_62295__$1 = cljs.core.seq.call(null,inst_62282);
var state_62422__$1 = (function (){var statearr_62504 = state_62422;
(statearr_62504[(22)] = inst_62295__$1);

return statearr_62504;
})();
if(inst_62295__$1){
var statearr_62505_62567 = state_62422__$1;
(statearr_62505_62567[(1)] = (10));

} else {
var statearr_62506_62568 = state_62422__$1;
(statearr_62506_62568[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__47085__auto__,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____0 = (function (){
var statearr_62507 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62507[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__);

(statearr_62507[(1)] = (1));

return statearr_62507;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____1 = (function (state_62422){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_62422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e62508){if((e62508 instanceof Object)){
var ex__47089__auto__ = e62508;
var statearr_62509_62569 = state_62422;
(statearr_62509_62569[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62422);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62570 = state_62422;
state_62422 = G__62570;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__ = function(state_62422){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____1.call(this,state_62422);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__47175__auto__ = (function (){var statearr_62510 = f__47174__auto__.call(null);
(statearr_62510[(6)] = c__47173__auto__);

return statearr_62510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,map__62267,map__62267__$1,opts,before_jsload,on_jsload,reload_dependents,map__62268,map__62268__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__47173__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__62573,link){
var map__62574 = p__62573;
var map__62574__$1 = ((((!((map__62574 == null)))?((((map__62574.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62574.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62574):map__62574);
var file = cljs.core.get.call(null,map__62574__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__62574,map__62574__$1,file){
return (function (p1__62571_SHARP_,p2__62572_SHARP_){
if(cljs.core._EQ_.call(null,p1__62571_SHARP_,p2__62572_SHARP_)){
return p1__62571_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__62574,map__62574__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__62577){
var map__62578 = p__62577;
var map__62578__$1 = ((((!((map__62578 == null)))?((((map__62578.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62578.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62578):map__62578);
var match_length = cljs.core.get.call(null,map__62578__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__62578__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__62576_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__62576_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__62580_SHARP_,p2__62581_SHARP_){
return cljs.core.assoc.call(null,p1__62580_SHARP_,cljs.core.get.call(null,p2__62581_SHARP_,key),p2__62581_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_62582 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_62582);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_62582);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__62583,p__62584){
var map__62585 = p__62583;
var map__62585__$1 = ((((!((map__62585 == null)))?((((map__62585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62585.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62585):map__62585);
var on_cssload = cljs.core.get.call(null,map__62585__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__62586 = p__62584;
var map__62586__$1 = ((((!((map__62586 == null)))?((((map__62586.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62586.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62586):map__62586);
var files_msg = map__62586__$1;
var files = cljs.core.get.call(null,map__62586__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1511404507917
