// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.impl.application');
goog.require('cljs.core');
goog.require('fulcro.client.logging');
goog.require('om.next');
goog.require('om.util');
goog.require('fulcro.i18n');
goog.require('fulcro.client.impl.data_fetch');
goog.require('fulcro.client.util');
goog.require('cljs.core.async');
goog.require('fulcro.client.network');
goog.require('fulcro.client.impl.om_plumbing');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
fulcro.client.impl.application.fallback_handler = (function fulcro$client$impl$application$fallback_handler(p__73622,query){
var map__73623 = p__73622;
var map__73623__$1 = ((((!((map__73623 == null)))?((((map__73623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73623.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73623):map__73623);
var reconciler = cljs.core.get.call(null,map__73623__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__73623,map__73623__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("fulcro","server-error","fulcro/server-error",-1254037316),error);

var temp__4655__auto__ = fulcro.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__4655__auto__)){
var q = temp__4655__auto__;
fulcro.client.logging.warn.call(null,fulcro.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return fulcro.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__73623,map__73623__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
fulcro.client.impl.application.enqueue = (function fulcro$client$impl$application$enqueue(q,v){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_73628){
var state_val_73629 = (state_73628[(1)]);
if((state_val_73629 === (1))){
var state_73628__$1 = state_73628;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73628__$1,(2),q,v);
} else {
if((state_val_73629 === (2))){
var inst_73626 = (state_73628[(2)]);
var state_73628__$1 = state_73628;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73628__$1,inst_73626);
} else {
return null;
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____0 = (function (){
var statearr_73630 = [null,null,null,null,null,null,null];
(statearr_73630[(0)] = fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__);

(statearr_73630[(1)] = (1));

return statearr_73630;
});
var fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____1 = (function (state_73628){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73631){if((e73631 instanceof Object)){
var ex__47089__auto__ = e73631;
var statearr_73632_73634 = state_73628;
(statearr_73632_73634[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73628);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73631;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73635 = state_73628;
state_73628 = G__73635;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__ = function(state_73628){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____1.call(this,state_73628);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____0;
fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_73633 = f__47174__auto__.call(null);
(statearr_73633[(6)] = c__47173__auto__);

return statearr_73633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
fulcro.client.impl.application.real_send = (function fulcro$client$impl$application$real_send(net,tx,on_done,on_error,on_load){
if(((!((net == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === net.fulcro$client$network$ProgressiveTransfer$)))?true:false):false)){
return fulcro.client.network.updating_send.call(null,net,fulcro.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error,on_load);
} else {
return fulcro.client.network.send.call(null,net,fulcro.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error);
}
});
/**
 * Split a tx that contains mutations. Returns a vector that contains at least one tx (the original).
 * 
 * Examples:
 * [(f) (g)] => [[(f) (g)]]
 * [(f) (g) (f) (k)] => [[(f) (g)] [(f) (k)]]
 * [(f) (g) (f) (k) (g)] => [[(f) (g)] [(f) (k) (g)]]
 * 
 */
fulcro.client.impl.application.split_mutations = (function fulcro$client$impl$application$split_mutations(tx){
if(!((cljs.core.vector_QMARK_.call(null,tx)) && (cljs.core.every_QMARK_.call(null,(function (t){
return (cljs.core.list_QMARK_.call(null,t)) && ((cljs.core.first.call(null,t) instanceof cljs.core.Symbol));
}),tx)))){
fulcro.client.logging.error.call(null,"INTERNAL ERROR: split-mutations was asked to split a tx that contained things other than mutations.",tx);

return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tx], null);
} else {
if(cljs.core.empty_QMARK_.call(null,tx)){
return cljs.core.PersistentVector.EMPTY;
} else {
var mutation_name = (function (m){
return cljs.core.first.call(null,m);
});
var map__73637 = cljs.core.reduce.call(null,((function (mutation_name){
return (function (p__73638,mutation){
var map__73639 = p__73638;
var map__73639__$1 = ((((!((map__73639 == null)))?((((map__73639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73639.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73639):map__73639);
var seen = cljs.core.get.call(null,map__73639__$1,new cljs.core.Keyword(null,"seen","seen",-518999789));
var accumulator = cljs.core.get.call(null,map__73639__$1,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501));
var current_tx = cljs.core.get.call(null,map__73639__$1,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374));
if(cljs.core.contains_QMARK_.call(null,seen,mutation_name.call(null,mutation))){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),cljs.core.conj.call(null,accumulator,current_tx),new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [mutation], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.conj.call(null,seen,mutation_name.call(null,mutation)),new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),accumulator,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),cljs.core.conj.call(null,current_tx,mutation)], null);
}
});})(mutation_name))
,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),cljs.core.PersistentVector.EMPTY], null),tx);
var map__73637__$1 = ((((!((map__73637 == null)))?((((map__73637.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73637.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73637):map__73637);
var accumulator = cljs.core.get.call(null,map__73637__$1,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501));
var current_tx = cljs.core.get.call(null,map__73637__$1,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374));
return cljs.core.conj.call(null,accumulator,current_tx);
}
}
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue. If duplicate mutation names
 * appear, then they will be separated into separate network requests.
 * 
 * NOTE: If the mutation in the tx has duplicates, then the same fallback will be used for the
 * resulting split tx. See `split-mutations` (which is used by this function to split dupes out of txes).
 */
fulcro.client.impl.application.enqueue_mutations = (function fulcro$client$impl$application$enqueue_mutations(p__73643,remote_tx_map,cb){
var map__73644 = p__73643;
var map__73644__$1 = ((((!((map__73644 == null)))?((((map__73644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73644.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73644):map__73644);
var app = map__73644__$1;
var send_queues = cljs.core.get.call(null,map__73644__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var seq__73646 = cljs.core.seq.call(null,cljs.core.keys.call(null,remote_tx_map));
var chunk__73647 = null;
var count__73648 = (0);
var i__73649 = (0);
while(true){
if((i__73649 < count__73648)){
var remote = cljs.core._nth.call(null,chunk__73647,i__73649);
var queue_73658 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_73659 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_73660 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_73659);
var desired_remote_mutations_73661 = fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_73659);
var tx_list_73662 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_73661);
var has_mutations_QMARK__73663 = ((function (seq__73646,chunk__73647,count__73648,i__73649,queue_73658,full_remote_transaction_73659,fallback_73660,desired_remote_mutations_73661,tx_list_73662,remote,map__73644,map__73644__$1,app,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__73646,chunk__73647,count__73648,i__73649,queue_73658,full_remote_transaction_73659,fallback_73660,desired_remote_mutations_73661,tx_list_73662,remote,map__73644,map__73644__$1,app,send_queues))
;
var payload_73664 = ((function (seq__73646,chunk__73647,count__73648,i__73649,queue_73658,full_remote_transaction_73659,fallback_73660,desired_remote_mutations_73661,tx_list_73662,has_mutations_QMARK__73663,remote,map__73644,map__73644__$1,app,send_queues){
return (function (tx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),tx,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__73646,chunk__73647,count__73648,i__73649,queue_73658,full_remote_transaction_73659,fallback_73660,desired_remote_mutations_73661,tx_list_73662,has_mutations_QMARK__73663,remote,map__73644,map__73644__$1,app,send_queues){
return (function (p1__73642_SHARP_){
return fallback_73660.call(null,p1__73642_SHARP_);
});})(seq__73646,chunk__73647,count__73648,i__73649,queue_73658,full_remote_transaction_73659,fallback_73660,desired_remote_mutations_73661,tx_list_73662,has_mutations_QMARK__73663,remote,map__73644,map__73644__$1,app,send_queues))
], null);
});})(seq__73646,chunk__73647,count__73648,i__73649,queue_73658,full_remote_transaction_73659,fallback_73660,desired_remote_mutations_73661,tx_list_73662,has_mutations_QMARK__73663,remote,map__73644,map__73644__$1,app,send_queues))
;
var seq__73650_73665 = cljs.core.seq.call(null,tx_list_73662);
var chunk__73651_73666 = null;
var count__73652_73667 = (0);
var i__73653_73668 = (0);
while(true){
if((i__73653_73668 < count__73652_73667)){
var tx_73669 = cljs.core._nth.call(null,chunk__73651_73666,i__73653_73668);
if(cljs.core.truth_(has_mutations_QMARK__73663.call(null,tx_73669))){
fulcro.client.impl.application.enqueue.call(null,queue_73658,payload_73664.call(null,tx_73669));
} else {
}

var G__73670 = seq__73650_73665;
var G__73671 = chunk__73651_73666;
var G__73672 = count__73652_73667;
var G__73673 = (i__73653_73668 + (1));
seq__73650_73665 = G__73670;
chunk__73651_73666 = G__73671;
count__73652_73667 = G__73672;
i__73653_73668 = G__73673;
continue;
} else {
var temp__4657__auto___73674 = cljs.core.seq.call(null,seq__73650_73665);
if(temp__4657__auto___73674){
var seq__73650_73675__$1 = temp__4657__auto___73674;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73650_73675__$1)){
var c__28980__auto___73676 = cljs.core.chunk_first.call(null,seq__73650_73675__$1);
var G__73677 = cljs.core.chunk_rest.call(null,seq__73650_73675__$1);
var G__73678 = c__28980__auto___73676;
var G__73679 = cljs.core.count.call(null,c__28980__auto___73676);
var G__73680 = (0);
seq__73650_73665 = G__73677;
chunk__73651_73666 = G__73678;
count__73652_73667 = G__73679;
i__73653_73668 = G__73680;
continue;
} else {
var tx_73681 = cljs.core.first.call(null,seq__73650_73675__$1);
if(cljs.core.truth_(has_mutations_QMARK__73663.call(null,tx_73681))){
fulcro.client.impl.application.enqueue.call(null,queue_73658,payload_73664.call(null,tx_73681));
} else {
}

var G__73682 = cljs.core.next.call(null,seq__73650_73675__$1);
var G__73683 = null;
var G__73684 = (0);
var G__73685 = (0);
seq__73650_73665 = G__73682;
chunk__73651_73666 = G__73683;
count__73652_73667 = G__73684;
i__73653_73668 = G__73685;
continue;
}
} else {
}
}
break;
}

var G__73686 = seq__73646;
var G__73687 = chunk__73647;
var G__73688 = count__73648;
var G__73689 = (i__73649 + (1));
seq__73646 = G__73686;
chunk__73647 = G__73687;
count__73648 = G__73688;
i__73649 = G__73689;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__73646);
if(temp__4657__auto__){
var seq__73646__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73646__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__73646__$1);
var G__73690 = cljs.core.chunk_rest.call(null,seq__73646__$1);
var G__73691 = c__28980__auto__;
var G__73692 = cljs.core.count.call(null,c__28980__auto__);
var G__73693 = (0);
seq__73646 = G__73690;
chunk__73647 = G__73691;
count__73648 = G__73692;
i__73649 = G__73693;
continue;
} else {
var remote = cljs.core.first.call(null,seq__73646__$1);
var queue_73694 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_73695 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_73696 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_73695);
var desired_remote_mutations_73697 = fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_73695);
var tx_list_73698 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_73697);
var has_mutations_QMARK__73699 = ((function (seq__73646,chunk__73647,count__73648,i__73649,queue_73694,full_remote_transaction_73695,fallback_73696,desired_remote_mutations_73697,tx_list_73698,remote,seq__73646__$1,temp__4657__auto__,map__73644,map__73644__$1,app,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__73646,chunk__73647,count__73648,i__73649,queue_73694,full_remote_transaction_73695,fallback_73696,desired_remote_mutations_73697,tx_list_73698,remote,seq__73646__$1,temp__4657__auto__,map__73644,map__73644__$1,app,send_queues))
;
var payload_73700 = ((function (seq__73646,chunk__73647,count__73648,i__73649,queue_73694,full_remote_transaction_73695,fallback_73696,desired_remote_mutations_73697,tx_list_73698,has_mutations_QMARK__73699,remote,seq__73646__$1,temp__4657__auto__,map__73644,map__73644__$1,app,send_queues){
return (function (tx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),tx,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__73646,chunk__73647,count__73648,i__73649,queue_73694,full_remote_transaction_73695,fallback_73696,desired_remote_mutations_73697,tx_list_73698,has_mutations_QMARK__73699,remote,seq__73646__$1,temp__4657__auto__,map__73644,map__73644__$1,app,send_queues){
return (function (p1__73642_SHARP_){
return fallback_73696.call(null,p1__73642_SHARP_);
});})(seq__73646,chunk__73647,count__73648,i__73649,queue_73694,full_remote_transaction_73695,fallback_73696,desired_remote_mutations_73697,tx_list_73698,has_mutations_QMARK__73699,remote,seq__73646__$1,temp__4657__auto__,map__73644,map__73644__$1,app,send_queues))
], null);
});})(seq__73646,chunk__73647,count__73648,i__73649,queue_73694,full_remote_transaction_73695,fallback_73696,desired_remote_mutations_73697,tx_list_73698,has_mutations_QMARK__73699,remote,seq__73646__$1,temp__4657__auto__,map__73644,map__73644__$1,app,send_queues))
;
var seq__73654_73701 = cljs.core.seq.call(null,tx_list_73698);
var chunk__73655_73702 = null;
var count__73656_73703 = (0);
var i__73657_73704 = (0);
while(true){
if((i__73657_73704 < count__73656_73703)){
var tx_73705 = cljs.core._nth.call(null,chunk__73655_73702,i__73657_73704);
if(cljs.core.truth_(has_mutations_QMARK__73699.call(null,tx_73705))){
fulcro.client.impl.application.enqueue.call(null,queue_73694,payload_73700.call(null,tx_73705));
} else {
}

var G__73706 = seq__73654_73701;
var G__73707 = chunk__73655_73702;
var G__73708 = count__73656_73703;
var G__73709 = (i__73657_73704 + (1));
seq__73654_73701 = G__73706;
chunk__73655_73702 = G__73707;
count__73656_73703 = G__73708;
i__73657_73704 = G__73709;
continue;
} else {
var temp__4657__auto___73710__$1 = cljs.core.seq.call(null,seq__73654_73701);
if(temp__4657__auto___73710__$1){
var seq__73654_73711__$1 = temp__4657__auto___73710__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73654_73711__$1)){
var c__28980__auto___73712 = cljs.core.chunk_first.call(null,seq__73654_73711__$1);
var G__73713 = cljs.core.chunk_rest.call(null,seq__73654_73711__$1);
var G__73714 = c__28980__auto___73712;
var G__73715 = cljs.core.count.call(null,c__28980__auto___73712);
var G__73716 = (0);
seq__73654_73701 = G__73713;
chunk__73655_73702 = G__73714;
count__73656_73703 = G__73715;
i__73657_73704 = G__73716;
continue;
} else {
var tx_73717 = cljs.core.first.call(null,seq__73654_73711__$1);
if(cljs.core.truth_(has_mutations_QMARK__73699.call(null,tx_73717))){
fulcro.client.impl.application.enqueue.call(null,queue_73694,payload_73700.call(null,tx_73717));
} else {
}

var G__73718 = cljs.core.next.call(null,seq__73654_73711__$1);
var G__73719 = null;
var G__73720 = (0);
var G__73721 = (0);
seq__73654_73701 = G__73718;
chunk__73655_73702 = G__73719;
count__73656_73703 = G__73720;
i__73657_73704 = G__73721;
continue;
}
} else {
}
}
break;
}

var G__73722 = cljs.core.next.call(null,seq__73646__$1);
var G__73723 = null;
var G__73724 = (0);
var G__73725 = (0);
seq__73646 = G__73722;
chunk__73647 = G__73723;
count__73648 = G__73724;
i__73649 = G__73725;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
fulcro.client.impl.application.enqueue_reads = (function fulcro$client$impl$application$enqueue_reads(p__73728){
var map__73729 = p__73728;
var map__73729__$1 = ((((!((map__73729 == null)))?((((map__73729.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73729.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73729):map__73729);
var send_queues = cljs.core.get.call(null,map__73729__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var reconciler = cljs.core.get.call(null,map__73729__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__73729__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var seq__73731 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__73732 = null;
var count__73733 = (0);
var i__73734 = (0);
while(true){
if((i__73734 < count__73733)){
var remote = cljs.core._nth.call(null,chunk__73732,i__73734);
var queue_73751 = cljs.core.get.call(null,send_queues,remote);
var network_73752 = cljs.core.get.call(null,networking,remote);
var parallel_payload_73753 = fulcro.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__73735_73754 = cljs.core.seq.call(null,parallel_payload_73753);
var chunk__73736_73755 = null;
var count__73737_73756 = (0);
var i__73738_73757 = (0);
while(true){
if((i__73738_73757 < count__73737_73756)){
var map__73739_73758 = cljs.core._nth.call(null,chunk__73736_73755,i__73738_73757);
var map__73739_73759__$1 = ((((!((map__73739_73758 == null)))?((((map__73739_73758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73739_73758.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73739_73758):map__73739_73758);
var query_73760 = cljs.core.get.call(null,map__73739_73759__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_73761 = cljs.core.get.call(null,map__73739_73759__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_73762 = cljs.core.get.call(null,map__73739_73759__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_73763 = cljs.core.get.call(null,map__73739_73759__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__73764 = ((function (seq__73735_73754,chunk__73736_73755,count__73737_73756,i__73738_73757,seq__73731,chunk__73732,count__73733,i__73734,map__73739_73758,map__73739_73759__$1,query_73760,on_load_73761,on_error_73762,load_descriptors_73763,queue_73751,network_73752,parallel_payload_73753,remote,map__73729,map__73729__$1,send_queues,reconciler,networking){
return (function (p1__73726_SHARP_){
return on_load_73761.call(null,p1__73726_SHARP_,load_descriptors_73763);
});})(seq__73735_73754,chunk__73736_73755,count__73737_73756,i__73738_73757,seq__73731,chunk__73732,count__73733,i__73734,map__73739_73758,map__73739_73759__$1,query_73760,on_load_73761,on_error_73762,load_descriptors_73763,queue_73751,network_73752,parallel_payload_73753,remote,map__73729,map__73729__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__73765 = ((function (seq__73735_73754,chunk__73736_73755,count__73737_73756,i__73738_73757,seq__73731,chunk__73732,count__73733,i__73734,on_load_SINGLEQUOTE__73764,map__73739_73758,map__73739_73759__$1,query_73760,on_load_73761,on_error_73762,load_descriptors_73763,queue_73751,network_73752,parallel_payload_73753,remote,map__73729,map__73729__$1,send_queues,reconciler,networking){
return (function (p1__73727_SHARP_){
return on_error_73762.call(null,p1__73727_SHARP_,load_descriptors_73763);
});})(seq__73735_73754,chunk__73736_73755,count__73737_73756,i__73738_73757,seq__73731,chunk__73732,count__73733,i__73734,on_load_SINGLEQUOTE__73764,map__73739_73758,map__73739_73759__$1,query_73760,on_load_73761,on_error_73762,load_descriptors_73763,queue_73751,network_73752,parallel_payload_73753,remote,map__73729,map__73729__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_73752,query_73760,on_load_SINGLEQUOTE__73764,on_error_SINGLEQUOTE__73765,null);

var G__73766 = seq__73735_73754;
var G__73767 = chunk__73736_73755;
var G__73768 = count__73737_73756;
var G__73769 = (i__73738_73757 + (1));
seq__73735_73754 = G__73766;
chunk__73736_73755 = G__73767;
count__73737_73756 = G__73768;
i__73738_73757 = G__73769;
continue;
} else {
var temp__4657__auto___73770 = cljs.core.seq.call(null,seq__73735_73754);
if(temp__4657__auto___73770){
var seq__73735_73771__$1 = temp__4657__auto___73770;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73735_73771__$1)){
var c__28980__auto___73772 = cljs.core.chunk_first.call(null,seq__73735_73771__$1);
var G__73773 = cljs.core.chunk_rest.call(null,seq__73735_73771__$1);
var G__73774 = c__28980__auto___73772;
var G__73775 = cljs.core.count.call(null,c__28980__auto___73772);
var G__73776 = (0);
seq__73735_73754 = G__73773;
chunk__73736_73755 = G__73774;
count__73737_73756 = G__73775;
i__73738_73757 = G__73776;
continue;
} else {
var map__73741_73777 = cljs.core.first.call(null,seq__73735_73771__$1);
var map__73741_73778__$1 = ((((!((map__73741_73777 == null)))?((((map__73741_73777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73741_73777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73741_73777):map__73741_73777);
var query_73779 = cljs.core.get.call(null,map__73741_73778__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_73780 = cljs.core.get.call(null,map__73741_73778__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_73781 = cljs.core.get.call(null,map__73741_73778__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_73782 = cljs.core.get.call(null,map__73741_73778__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__73783 = ((function (seq__73735_73754,chunk__73736_73755,count__73737_73756,i__73738_73757,seq__73731,chunk__73732,count__73733,i__73734,map__73741_73777,map__73741_73778__$1,query_73779,on_load_73780,on_error_73781,load_descriptors_73782,seq__73735_73771__$1,temp__4657__auto___73770,queue_73751,network_73752,parallel_payload_73753,remote,map__73729,map__73729__$1,send_queues,reconciler,networking){
return (function (p1__73726_SHARP_){
return on_load_73780.call(null,p1__73726_SHARP_,load_descriptors_73782);
});})(seq__73735_73754,chunk__73736_73755,count__73737_73756,i__73738_73757,seq__73731,chunk__73732,count__73733,i__73734,map__73741_73777,map__73741_73778__$1,query_73779,on_load_73780,on_error_73781,load_descriptors_73782,seq__73735_73771__$1,temp__4657__auto___73770,queue_73751,network_73752,parallel_payload_73753,remote,map__73729,map__73729__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__73784 = ((function (seq__73735_73754,chunk__73736_73755,count__73737_73756,i__73738_73757,seq__73731,chunk__73732,count__73733,i__73734,on_load_SINGLEQUOTE__73783,map__73741_73777,map__73741_73778__$1,query_73779,on_load_73780,on_error_73781,load_descriptors_73782,seq__73735_73771__$1,temp__4657__auto___73770,queue_73751,network_73752,parallel_payload_73753,remote,map__73729,map__73729__$1,send_queues,reconciler,networking){
return (function (p1__73727_SHARP_){
return on_error_73781.call(null,p1__73727_SHARP_,load_descriptors_73782);
});})(seq__73735_73754,chunk__73736_73755,count__73737_73756,i__73738_73757,seq__73731,chunk__73732,count__73733,i__73734,on_load_SINGLEQUOTE__73783,map__73741_73777,map__73741_73778__$1,query_73779,on_load_73780,on_error_73781,load_descriptors_73782,seq__73735_73771__$1,temp__4657__auto___73770,queue_73751,network_73752,parallel_payload_73753,remote,map__73729,map__73729__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_73752,query_73779,on_load_SINGLEQUOTE__73783,on_error_SINGLEQUOTE__73784,null);

var G__73785 = cljs.core.next.call(null,seq__73735_73771__$1);
var G__73786 = null;
var G__73787 = (0);
var G__73788 = (0);
seq__73735_73754 = G__73785;
chunk__73736_73755 = G__73786;
count__73737_73756 = G__73787;
i__73738_73757 = G__73788;
continue;
}
} else {
}
}
break;
}

var fetch_payload_73789 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_73789)){
fulcro.client.impl.application.enqueue.call(null,queue_73751,cljs.core.assoc.call(null,fetch_payload_73789,new cljs.core.Keyword(null,"networking","networking",586110628),network_73752));

var G__73790 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_73789 = G__73790;
continue;
} else {
}
break;
}

var G__73791 = seq__73731;
var G__73792 = chunk__73732;
var G__73793 = count__73733;
var G__73794 = (i__73734 + (1));
seq__73731 = G__73791;
chunk__73732 = G__73792;
count__73733 = G__73793;
i__73734 = G__73794;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__73731);
if(temp__4657__auto__){
var seq__73731__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73731__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__73731__$1);
var G__73795 = cljs.core.chunk_rest.call(null,seq__73731__$1);
var G__73796 = c__28980__auto__;
var G__73797 = cljs.core.count.call(null,c__28980__auto__);
var G__73798 = (0);
seq__73731 = G__73795;
chunk__73732 = G__73796;
count__73733 = G__73797;
i__73734 = G__73798;
continue;
} else {
var remote = cljs.core.first.call(null,seq__73731__$1);
var queue_73799 = cljs.core.get.call(null,send_queues,remote);
var network_73800 = cljs.core.get.call(null,networking,remote);
var parallel_payload_73801 = fulcro.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__73743_73802 = cljs.core.seq.call(null,parallel_payload_73801);
var chunk__73744_73803 = null;
var count__73745_73804 = (0);
var i__73746_73805 = (0);
while(true){
if((i__73746_73805 < count__73745_73804)){
var map__73747_73806 = cljs.core._nth.call(null,chunk__73744_73803,i__73746_73805);
var map__73747_73807__$1 = ((((!((map__73747_73806 == null)))?((((map__73747_73806.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73747_73806.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73747_73806):map__73747_73806);
var query_73808 = cljs.core.get.call(null,map__73747_73807__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_73809 = cljs.core.get.call(null,map__73747_73807__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_73810 = cljs.core.get.call(null,map__73747_73807__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_73811 = cljs.core.get.call(null,map__73747_73807__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__73812 = ((function (seq__73743_73802,chunk__73744_73803,count__73745_73804,i__73746_73805,seq__73731,chunk__73732,count__73733,i__73734,map__73747_73806,map__73747_73807__$1,query_73808,on_load_73809,on_error_73810,load_descriptors_73811,queue_73799,network_73800,parallel_payload_73801,remote,seq__73731__$1,temp__4657__auto__,map__73729,map__73729__$1,send_queues,reconciler,networking){
return (function (p1__73726_SHARP_){
return on_load_73809.call(null,p1__73726_SHARP_,load_descriptors_73811);
});})(seq__73743_73802,chunk__73744_73803,count__73745_73804,i__73746_73805,seq__73731,chunk__73732,count__73733,i__73734,map__73747_73806,map__73747_73807__$1,query_73808,on_load_73809,on_error_73810,load_descriptors_73811,queue_73799,network_73800,parallel_payload_73801,remote,seq__73731__$1,temp__4657__auto__,map__73729,map__73729__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__73813 = ((function (seq__73743_73802,chunk__73744_73803,count__73745_73804,i__73746_73805,seq__73731,chunk__73732,count__73733,i__73734,on_load_SINGLEQUOTE__73812,map__73747_73806,map__73747_73807__$1,query_73808,on_load_73809,on_error_73810,load_descriptors_73811,queue_73799,network_73800,parallel_payload_73801,remote,seq__73731__$1,temp__4657__auto__,map__73729,map__73729__$1,send_queues,reconciler,networking){
return (function (p1__73727_SHARP_){
return on_error_73810.call(null,p1__73727_SHARP_,load_descriptors_73811);
});})(seq__73743_73802,chunk__73744_73803,count__73745_73804,i__73746_73805,seq__73731,chunk__73732,count__73733,i__73734,on_load_SINGLEQUOTE__73812,map__73747_73806,map__73747_73807__$1,query_73808,on_load_73809,on_error_73810,load_descriptors_73811,queue_73799,network_73800,parallel_payload_73801,remote,seq__73731__$1,temp__4657__auto__,map__73729,map__73729__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_73800,query_73808,on_load_SINGLEQUOTE__73812,on_error_SINGLEQUOTE__73813,null);

var G__73814 = seq__73743_73802;
var G__73815 = chunk__73744_73803;
var G__73816 = count__73745_73804;
var G__73817 = (i__73746_73805 + (1));
seq__73743_73802 = G__73814;
chunk__73744_73803 = G__73815;
count__73745_73804 = G__73816;
i__73746_73805 = G__73817;
continue;
} else {
var temp__4657__auto___73818__$1 = cljs.core.seq.call(null,seq__73743_73802);
if(temp__4657__auto___73818__$1){
var seq__73743_73819__$1 = temp__4657__auto___73818__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73743_73819__$1)){
var c__28980__auto___73820 = cljs.core.chunk_first.call(null,seq__73743_73819__$1);
var G__73821 = cljs.core.chunk_rest.call(null,seq__73743_73819__$1);
var G__73822 = c__28980__auto___73820;
var G__73823 = cljs.core.count.call(null,c__28980__auto___73820);
var G__73824 = (0);
seq__73743_73802 = G__73821;
chunk__73744_73803 = G__73822;
count__73745_73804 = G__73823;
i__73746_73805 = G__73824;
continue;
} else {
var map__73749_73825 = cljs.core.first.call(null,seq__73743_73819__$1);
var map__73749_73826__$1 = ((((!((map__73749_73825 == null)))?((((map__73749_73825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73749_73825.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73749_73825):map__73749_73825);
var query_73827 = cljs.core.get.call(null,map__73749_73826__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_73828 = cljs.core.get.call(null,map__73749_73826__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_73829 = cljs.core.get.call(null,map__73749_73826__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_73830 = cljs.core.get.call(null,map__73749_73826__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__73831 = ((function (seq__73743_73802,chunk__73744_73803,count__73745_73804,i__73746_73805,seq__73731,chunk__73732,count__73733,i__73734,map__73749_73825,map__73749_73826__$1,query_73827,on_load_73828,on_error_73829,load_descriptors_73830,seq__73743_73819__$1,temp__4657__auto___73818__$1,queue_73799,network_73800,parallel_payload_73801,remote,seq__73731__$1,temp__4657__auto__,map__73729,map__73729__$1,send_queues,reconciler,networking){
return (function (p1__73726_SHARP_){
return on_load_73828.call(null,p1__73726_SHARP_,load_descriptors_73830);
});})(seq__73743_73802,chunk__73744_73803,count__73745_73804,i__73746_73805,seq__73731,chunk__73732,count__73733,i__73734,map__73749_73825,map__73749_73826__$1,query_73827,on_load_73828,on_error_73829,load_descriptors_73830,seq__73743_73819__$1,temp__4657__auto___73818__$1,queue_73799,network_73800,parallel_payload_73801,remote,seq__73731__$1,temp__4657__auto__,map__73729,map__73729__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__73832 = ((function (seq__73743_73802,chunk__73744_73803,count__73745_73804,i__73746_73805,seq__73731,chunk__73732,count__73733,i__73734,on_load_SINGLEQUOTE__73831,map__73749_73825,map__73749_73826__$1,query_73827,on_load_73828,on_error_73829,load_descriptors_73830,seq__73743_73819__$1,temp__4657__auto___73818__$1,queue_73799,network_73800,parallel_payload_73801,remote,seq__73731__$1,temp__4657__auto__,map__73729,map__73729__$1,send_queues,reconciler,networking){
return (function (p1__73727_SHARP_){
return on_error_73829.call(null,p1__73727_SHARP_,load_descriptors_73830);
});})(seq__73743_73802,chunk__73744_73803,count__73745_73804,i__73746_73805,seq__73731,chunk__73732,count__73733,i__73734,on_load_SINGLEQUOTE__73831,map__73749_73825,map__73749_73826__$1,query_73827,on_load_73828,on_error_73829,load_descriptors_73830,seq__73743_73819__$1,temp__4657__auto___73818__$1,queue_73799,network_73800,parallel_payload_73801,remote,seq__73731__$1,temp__4657__auto__,map__73729,map__73729__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_73800,query_73827,on_load_SINGLEQUOTE__73831,on_error_SINGLEQUOTE__73832,null);

var G__73833 = cljs.core.next.call(null,seq__73743_73819__$1);
var G__73834 = null;
var G__73835 = (0);
var G__73836 = (0);
seq__73743_73802 = G__73833;
chunk__73744_73803 = G__73834;
count__73745_73804 = G__73835;
i__73746_73805 = G__73836;
continue;
}
} else {
}
}
break;
}

var fetch_payload_73837 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_73837)){
fulcro.client.impl.application.enqueue.call(null,queue_73799,cljs.core.assoc.call(null,fetch_payload_73837,new cljs.core.Keyword(null,"networking","networking",586110628),network_73800));

var G__73838 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_73837 = G__73838;
continue;
} else {
}
break;
}

var G__73839 = cljs.core.next.call(null,seq__73731__$1);
var G__73840 = null;
var G__73841 = (0);
var G__73842 = (0);
seq__73731 = G__73839;
chunk__73732 = G__73840;
count__73733 = G__73841;
i__73734 = G__73842;
continue;
}
} else {
return null;
}
}
break;
}
});
fulcro.client.impl.application.detect_errant_remotes = (function fulcro$client$impl$application$detect_errant_remotes(p__73843){
var map__73844 = p__73843;
var map__73844__$1 = ((((!((map__73844 == null)))?((((map__73844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73844.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73844):map__73844);
var app = map__73844__$1;
var reconciler = cljs.core.get.call(null,map__73844__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var send_queues = cljs.core.get.call(null,map__73844__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var state = om.next.app_state.call(null,reconciler);
var all_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var item_remotes = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.data_remote,all_items));
var all_remotes = cljs.core.set.call(null,cljs.core.keys.call(null,send_queues));
var invalid_remotes = clojure.set.difference.call(null,item_remotes,all_remotes);
if(cljs.core.truth_(cljs.core.not_empty.call(null,invalid_remotes))){
return fulcro.client.logging.error.call(null,["Use of invalid remote(s) detected! ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(invalid_remotes)].join(''));
} else {
return null;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
fulcro.client.impl.application.server_send = (function fulcro$client$impl$application$server_send(app,remote_tx_map,cb){
fulcro.client.impl.application.detect_errant_remotes.call(null,app);

fulcro.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return fulcro.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Sends a network payload. There are two kinds of payloads in Fulcro. The first is
 *   for reads, which are tracked by load descriptors in the app state. These load descriptors
 *   tell the plumbing how to handle the response, and expect to only be merged in once. Mutations
 *   do not have a payload, and can technically received progress updates from the network. The built-in
 *   networking does not (currently) give progress events, but plugin networking can. It is currently not
 *   supported to give an update on a load, so this function is careful to detect that a payload is a send
 *   and turns all but the last update into a no-op. The send-complete function comes from the
 *   network sequential processing loop, and when called unblocks the network processing to allow the
 *   next request to go. Be very careful with this code, as bugs will cause applications to stop responding
 *   to remote requests.
 */
fulcro.client.impl.application.send_payload = (function fulcro$client$impl$application$send_payload(network,payload,send_complete){
var map__73848 = payload;
var map__73848__$1 = ((((!((map__73848 == null)))?((((map__73848.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73848.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73848):map__73848);
var query = cljs.core.get.call(null,map__73848__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load = cljs.core.get.call(null,map__73848__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error = cljs.core.get.call(null,map__73848__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors = cljs.core.get.call(null,map__73848__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var merge_data = (cljs.core.truth_(load_descriptors)?((function (map__73848,map__73848__$1,query,on_load,on_error,load_descriptors){
return (function (p1__73846_SHARP_){
return on_load.call(null,p1__73846_SHARP_,load_descriptors);
});})(map__73848,map__73848__$1,query,on_load,on_error,load_descriptors))
:on_load);
var on_update = (cljs.core.truth_(load_descriptors)?cljs.core.identity:merge_data);
var on_error__$1 = (cljs.core.truth_(load_descriptors)?((function (map__73848,map__73848__$1,query,on_load,on_error,load_descriptors,merge_data,on_update){
return (function (p1__73847_SHARP_){
return on_error.call(null,p1__73847_SHARP_,load_descriptors);
});})(map__73848,map__73848__$1,query,on_load,on_error,load_descriptors,merge_data,on_update))
:on_error);
var on_error__$2 = cljs.core.comp.call(null,send_complete,on_error__$1);
var on_done = cljs.core.comp.call(null,send_complete,merge_data);
return fulcro.client.impl.application.real_send.call(null,network,query,on_done,on_error__$2,on_update);
});
fulcro.client.impl.application.is_sequential_QMARK_ = (function fulcro$client$impl$application$is_sequential_QMARK_(network){
if(((!((network == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === network.fulcro$client$network$NetworkBehavior$)))?true:false):false)){
return fulcro.client.network.serialize_requests_QMARK_.call(null,network);
} else {
return true;
}
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
fulcro.client.impl.application.start_network_sequential_processing = (function fulcro$client$impl$application$start_network_sequential_processing(p__73851){
var map__73852 = p__73851;
var map__73852__$1 = ((((!((map__73852 == null)))?((((map__73852.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73852.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73852):map__73852);
var networking = cljs.core.get.call(null,map__73852__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var send_queues = cljs.core.get.call(null,map__73852__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var response_channels = cljs.core.get.call(null,map__73852__$1,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128));
var seq__73854 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__73855 = null;
var count__73856 = (0);
var i__73857 = (0);
while(true){
if((i__73857 < count__73856)){
var remote = cljs.core._nth.call(null,chunk__73855,i__73857);
var queue_73942 = cljs.core.get.call(null,send_queues,remote);
var network_73943 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__73944 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_73943);
var response_channel_73945 = cljs.core.get.call(null,response_channels,remote);
var send_complete_73946 = (cljs.core.truth_(sequential_QMARK__73944)?((function (seq__73854,chunk__73855,count__73856,i__73857,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,remote,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto__,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,remote,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto__,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,remote,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (state_73861){
var state_val_73862 = (state_73861[(1)]);
if((state_val_73862 === (1))){
var state_73861__$1 = state_73861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73861__$1,(2),response_channel_73945,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_73862 === (2))){
var inst_73859 = (state_73861[(2)]);
var state_73861__$1 = state_73861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73861__$1,inst_73859);
} else {
return null;
}
}
});})(seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto__,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,remote,map__73852,map__73852__$1,networking,send_queues,response_channels))
;
return ((function (seq__73854,chunk__73855,count__73856,i__73857,switch__47085__auto__,c__47173__auto__,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,remote,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0 = (function (){
var statearr_73863 = [null,null,null,null,null,null,null];
(statearr_73863[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__);

(statearr_73863[(1)] = (1));

return statearr_73863;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1 = (function (state_73861){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73864){if((e73864 instanceof Object)){
var ex__47089__auto__ = e73864;
var statearr_73865_73947 = state_73861;
(statearr_73865_73947[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73861);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73864;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73948 = state_73861;
state_73861 = G__73948;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = function(state_73861){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1.call(this,state_73861);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__;
})()
;})(seq__73854,chunk__73855,count__73856,i__73857,switch__47085__auto__,c__47173__auto__,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,remote,map__73852,map__73852__$1,networking,send_queues,response_channels))
})();
var state__47175__auto__ = (function (){var statearr_73866 = f__47174__auto__.call(null);
(statearr_73866[(6)] = c__47173__auto__);

return statearr_73866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto__,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,remote,map__73852,map__73852__$1,networking,send_queues,response_channels))
);

return c__47173__auto__;
});})(seq__73854,chunk__73855,count__73856,i__73857,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,remote,map__73852,map__73852__$1,networking,send_queues,response_channels))
:cljs.core.identity);
var c__47173__auto___73949 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto___73949,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,send_complete_73946,remote,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto___73949,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,send_complete_73946,remote,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (state_73884){
var state_val_73885 = (state_73884[(1)]);
if((state_val_73885 === (1))){
var state_73884__$1 = state_73884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73884__$1,(2),queue_73942);
} else {
if((state_val_73885 === (2))){
var inst_73868 = (state_73884[(2)]);
var inst_73869 = inst_73868;
var state_73884__$1 = (function (){var statearr_73886 = state_73884;
(statearr_73886[(7)] = inst_73869);

return statearr_73886;
})();
var statearr_73887_73950 = state_73884__$1;
(statearr_73887_73950[(2)] = null);

(statearr_73887_73950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73885 === (3))){
var inst_73869 = (state_73884[(7)]);
var inst_73871 = fulcro.client.impl.application.send_payload.call(null,network_73943,inst_73869,send_complete_73946);
var state_73884__$1 = (function (){var statearr_73888 = state_73884;
(statearr_73888[(8)] = inst_73871);

return statearr_73888;
})();
if(cljs.core.truth_(sequential_QMARK__73944)){
var statearr_73889_73951 = state_73884__$1;
(statearr_73889_73951[(1)] = (5));

} else {
var statearr_73890_73952 = state_73884__$1;
(statearr_73890_73952[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73885 === (4))){
var inst_73882 = (state_73884[(2)]);
var state_73884__$1 = state_73884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73884__$1,inst_73882);
} else {
if((state_val_73885 === (5))){
var state_73884__$1 = state_73884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73884__$1,(8),response_channel_73945);
} else {
if((state_val_73885 === (6))){
var state_73884__$1 = state_73884;
var statearr_73891_73953 = state_73884__$1;
(statearr_73891_73953[(2)] = null);

(statearr_73891_73953[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73885 === (7))){
var inst_73877 = (state_73884[(2)]);
var state_73884__$1 = (function (){var statearr_73892 = state_73884;
(statearr_73892[(9)] = inst_73877);

return statearr_73892;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73884__$1,(9),queue_73942);
} else {
if((state_val_73885 === (8))){
var inst_73874 = (state_73884[(2)]);
var state_73884__$1 = state_73884;
var statearr_73893_73954 = state_73884__$1;
(statearr_73893_73954[(2)] = inst_73874);

(statearr_73893_73954[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73885 === (9))){
var inst_73879 = (state_73884[(2)]);
var inst_73869 = inst_73879;
var state_73884__$1 = (function (){var statearr_73894 = state_73884;
(statearr_73894[(7)] = inst_73869);

return statearr_73894;
})();
var statearr_73895_73955 = state_73884__$1;
(statearr_73895_73955[(2)] = null);

(statearr_73895_73955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto___73949,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,send_complete_73946,remote,map__73852,map__73852__$1,networking,send_queues,response_channels))
;
return ((function (seq__73854,chunk__73855,count__73856,i__73857,switch__47085__auto__,c__47173__auto___73949,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,send_complete_73946,remote,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0 = (function (){
var statearr_73896 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73896[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__);

(statearr_73896[(1)] = (1));

return statearr_73896;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1 = (function (state_73884){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73897){if((e73897 instanceof Object)){
var ex__47089__auto__ = e73897;
var statearr_73898_73956 = state_73884;
(statearr_73898_73956[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73884);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73897;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73957 = state_73884;
state_73884 = G__73957;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = function(state_73884){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1.call(this,state_73884);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__;
})()
;})(seq__73854,chunk__73855,count__73856,i__73857,switch__47085__auto__,c__47173__auto___73949,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,send_complete_73946,remote,map__73852,map__73852__$1,networking,send_queues,response_channels))
})();
var state__47175__auto__ = (function (){var statearr_73899 = f__47174__auto__.call(null);
(statearr_73899[(6)] = c__47173__auto___73949);

return statearr_73899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto___73949,queue_73942,network_73943,sequential_QMARK__73944,response_channel_73945,send_complete_73946,remote,map__73852,map__73852__$1,networking,send_queues,response_channels))
);


var G__73958 = seq__73854;
var G__73959 = chunk__73855;
var G__73960 = count__73856;
var G__73961 = (i__73857 + (1));
seq__73854 = G__73958;
chunk__73855 = G__73959;
count__73856 = G__73960;
i__73857 = G__73961;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__73854);
if(temp__4657__auto__){
var seq__73854__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73854__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__73854__$1);
var G__73962 = cljs.core.chunk_rest.call(null,seq__73854__$1);
var G__73963 = c__28980__auto__;
var G__73964 = cljs.core.count.call(null,c__28980__auto__);
var G__73965 = (0);
seq__73854 = G__73962;
chunk__73855 = G__73963;
count__73856 = G__73964;
i__73857 = G__73965;
continue;
} else {
var remote = cljs.core.first.call(null,seq__73854__$1);
var queue_73966 = cljs.core.get.call(null,send_queues,remote);
var network_73967 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__73968 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_73967);
var response_channel_73969 = cljs.core.get.call(null,response_channels,remote);
var send_complete_73970 = (cljs.core.truth_(sequential_QMARK__73968)?((function (seq__73854,chunk__73855,count__73856,i__73857,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto__,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto__,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (state_73903){
var state_val_73904 = (state_73903[(1)]);
if((state_val_73904 === (1))){
var state_73903__$1 = state_73903;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73903__$1,(2),response_channel_73969,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_73904 === (2))){
var inst_73901 = (state_73903[(2)]);
var state_73903__$1 = state_73903;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73903__$1,inst_73901);
} else {
return null;
}
}
});})(seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto__,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels))
;
return ((function (seq__73854,chunk__73855,count__73856,i__73857,switch__47085__auto__,c__47173__auto__,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0 = (function (){
var statearr_73905 = [null,null,null,null,null,null,null];
(statearr_73905[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__);

(statearr_73905[(1)] = (1));

return statearr_73905;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1 = (function (state_73903){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73906){if((e73906 instanceof Object)){
var ex__47089__auto__ = e73906;
var statearr_73907_73971 = state_73903;
(statearr_73907_73971[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73903);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73906;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73972 = state_73903;
state_73903 = G__73972;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = function(state_73903){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1.call(this,state_73903);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__;
})()
;})(seq__73854,chunk__73855,count__73856,i__73857,switch__47085__auto__,c__47173__auto__,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels))
})();
var state__47175__auto__ = (function (){var statearr_73908 = f__47174__auto__.call(null);
(statearr_73908[(6)] = c__47173__auto__);

return statearr_73908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto__,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels))
);

return c__47173__auto__;
});})(seq__73854,chunk__73855,count__73856,i__73857,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels))
:cljs.core.identity);
var c__47173__auto___73973 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto___73973,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,send_complete_73970,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto___73973,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,send_complete_73970,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function (state_73926){
var state_val_73927 = (state_73926[(1)]);
if((state_val_73927 === (1))){
var state_73926__$1 = state_73926;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73926__$1,(2),queue_73966);
} else {
if((state_val_73927 === (2))){
var inst_73910 = (state_73926[(2)]);
var inst_73911 = inst_73910;
var state_73926__$1 = (function (){var statearr_73928 = state_73926;
(statearr_73928[(7)] = inst_73911);

return statearr_73928;
})();
var statearr_73929_73974 = state_73926__$1;
(statearr_73929_73974[(2)] = null);

(statearr_73929_73974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73927 === (3))){
var inst_73911 = (state_73926[(7)]);
var inst_73913 = fulcro.client.impl.application.send_payload.call(null,network_73967,inst_73911,send_complete_73970);
var state_73926__$1 = (function (){var statearr_73930 = state_73926;
(statearr_73930[(8)] = inst_73913);

return statearr_73930;
})();
if(cljs.core.truth_(sequential_QMARK__73968)){
var statearr_73931_73975 = state_73926__$1;
(statearr_73931_73975[(1)] = (5));

} else {
var statearr_73932_73976 = state_73926__$1;
(statearr_73932_73976[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73927 === (4))){
var inst_73924 = (state_73926[(2)]);
var state_73926__$1 = state_73926;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73926__$1,inst_73924);
} else {
if((state_val_73927 === (5))){
var state_73926__$1 = state_73926;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73926__$1,(8),response_channel_73969);
} else {
if((state_val_73927 === (6))){
var state_73926__$1 = state_73926;
var statearr_73933_73977 = state_73926__$1;
(statearr_73933_73977[(2)] = null);

(statearr_73933_73977[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73927 === (7))){
var inst_73919 = (state_73926[(2)]);
var state_73926__$1 = (function (){var statearr_73934 = state_73926;
(statearr_73934[(9)] = inst_73919);

return statearr_73934;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73926__$1,(9),queue_73966);
} else {
if((state_val_73927 === (8))){
var inst_73916 = (state_73926[(2)]);
var state_73926__$1 = state_73926;
var statearr_73935_73978 = state_73926__$1;
(statearr_73935_73978[(2)] = inst_73916);

(statearr_73935_73978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73927 === (9))){
var inst_73921 = (state_73926[(2)]);
var inst_73911 = inst_73921;
var state_73926__$1 = (function (){var statearr_73936 = state_73926;
(statearr_73936[(7)] = inst_73911);

return statearr_73936;
})();
var statearr_73937_73979 = state_73926__$1;
(statearr_73937_73979[(2)] = null);

(statearr_73937_73979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto___73973,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,send_complete_73970,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels))
;
return ((function (seq__73854,chunk__73855,count__73856,i__73857,switch__47085__auto__,c__47173__auto___73973,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,send_complete_73970,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0 = (function (){
var statearr_73938 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73938[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__);

(statearr_73938[(1)] = (1));

return statearr_73938;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1 = (function (state_73926){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_73926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e73939){if((e73939 instanceof Object)){
var ex__47089__auto__ = e73939;
var statearr_73940_73980 = state_73926;
(statearr_73940_73980[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73926);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73939;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73981 = state_73926;
state_73926 = G__73981;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = function(state_73926){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1.call(this,state_73926);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__;
})()
;})(seq__73854,chunk__73855,count__73856,i__73857,switch__47085__auto__,c__47173__auto___73973,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,send_complete_73970,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels))
})();
var state__47175__auto__ = (function (){var statearr_73941 = f__47174__auto__.call(null);
(statearr_73941[(6)] = c__47173__auto___73973);

return statearr_73941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(seq__73854,chunk__73855,count__73856,i__73857,c__47173__auto___73973,queue_73966,network_73967,sequential_QMARK__73968,response_channel_73969,send_complete_73970,remote,seq__73854__$1,temp__4657__auto__,map__73852,map__73852__$1,networking,send_queues,response_channels))
);


var G__73982 = cljs.core.next.call(null,seq__73854__$1);
var G__73983 = null;
var G__73984 = (0);
var G__73985 = (0);
seq__73854 = G__73982;
chunk__73855 = G__73983;
count__73856 = G__73984;
i__73857 = G__73985;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Configure a re-render when the locale changes and also when the translations arrive from a module load.
 * During startup this function will be called once for each reconciler that is running on a page.
 */
fulcro.client.impl.application.initialize_internationalization = (function fulcro$client$impl$application$initialize_internationalization(reconciler){
var re_render = (function fulcro$client$impl$application$initialize_internationalization_$_re_render(k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
fulcro.client.logging.debug.call(null,"Forcing a UI refresh on locale change.");

return fulcro.client.util.force_render.call(null,reconciler);
} else {
return null;
}
});
cljs.core.remove_watch.call(null,fulcro.i18n._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

cljs.core.add_watch.call(null,fulcro.i18n._STAR_loaded_translations_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),re_render);

return cljs.core.add_watch.call(null,fulcro.i18n._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),re_render);
});
/**
 * Remove not-found keys from m (non-recursive)
 */
fulcro.client.impl.application.sweep_one = (function fulcro$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__73986){
var vec__73987 = p__73986;
var k = cljs.core.nth.call(null,vec__73987,(0),null);
var v = cljs.core.nth.call(null,vec__73987,(1),null);
if((cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),k)) || (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),v))){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,fulcro.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
fulcro.client.impl.application.sweep = (function fulcro$client$impl$application$sweep(m){
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return fulcro.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__73990){
var vec__73991 = p__73990;
var k = cljs.core.nth.call(null,vec__73991,(0),null);
var v = cljs.core.nth.call(null,vec__73991,(1),null);
if((cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),k)) || (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),v))){
return acc;
} else {
if((om.util.ident_QMARK_.call(null,v)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),cljs.core.second.call(null,v)))){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,fulcro.client.impl.application.sweep.call(null,v));

}
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,fulcro.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
fulcro.client.impl.application.sweep_merge = (function fulcro$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__73994){
var vec__73995 = p__73994;
var key = cljs.core.nth.call(null,vec__73995,(0),null);
var new_value = cljs.core.nth.call(null,vec__73995,(1),null);
var existing_value = cljs.core.get.call(null,acc,key);
if(cljs.core._EQ_.call(null,key,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951))){
return acc;
} else {
if(cljs.core._EQ_.call(null,new_value,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951))){
return cljs.core.dissoc.call(null,acc,key);
} else {
if((om.util.ident_QMARK_.call(null,new_value)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),cljs.core.second.call(null,new_value)))){
return acc;
} else {
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.leaf_QMARK_.call(null,new_value))){
return cljs.core.assoc.call(null,acc,key,fulcro.client.impl.application.sweep_one.call(null,new_value));
} else {
if((cljs.core.map_QMARK_.call(null,existing_value)) && (cljs.core.map_QMARK_.call(null,new_value))){
return cljs.core.update.call(null,acc,key,fulcro.client.impl.application.sweep_merge,new_value);
} else {
return cljs.core.assoc.call(null,acc,key,fulcro.client.impl.application.sweep.call(null,new_value));

}
}
}
}
}
}),target,source);
});
fulcro.client.impl.application.merge_handler = (function fulcro$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__73998){
var vec__73999 = p__73998;
var k = cljs.core.nth.call(null,vec__73999,(0),null);
var _ = cljs.core.nth.call(null,vec__73999,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = fulcro.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__74002){
var vec__74003 = p__74002;
var k = cljs.core.nth.call(null,vec__74003,(0),null);
var v = cljs.core.nth.call(null,vec__74003,(1),null);
if(cljs.core.truth_((function (){var and__28129__auto__ = mutation_merge;
if(cljs.core.truth_(and__28129__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__28129__auto__;
}
})())){
var temp__4655__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__4655__auto__)){
var updated_state = temp__4655__auto__;
return updated_state;
} else {
fulcro.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls FulcroApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
fulcro.client.impl.application.generate_reconciler = (function fulcro$client$impl$application$generate_reconciler(p__74006,initial_state,parser,p__74007){
var map__74008 = p__74006;
var map__74008__$1 = ((((!((map__74008 == null)))?((((map__74008.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74008.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74008):map__74008);
var app = map__74008__$1;
var send_queues = cljs.core.get.call(null,map__74008__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var mutation_merge = cljs.core.get.call(null,map__74008__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__74009 = p__74007;
var map__74009__$1 = ((((!((map__74009 == null)))?((((map__74009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74009):map__74009);
var reconciler_options = map__74009__$1;
var migrate = cljs.core.get.call(null,map__74009__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743));
var rec_atom = cljs.core.atom.call(null,null);
var remotes = cljs.core.keys.call(null,send_queues);
var tempid_migrate = ((function (rec_atom,remotes,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate){
return (function (pure,_,tempids,___$1){
var seq__74012_74016 = cljs.core.seq.call(null,cljs.core.vals.call(null,send_queues));
var chunk__74013_74017 = null;
var count__74014_74018 = (0);
var i__74015_74019 = (0);
while(true){
if((i__74015_74019 < count__74014_74018)){
var queue_74020 = cljs.core._nth.call(null,chunk__74013_74017,i__74015_74019);
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_74020,tempids);

var G__74021 = seq__74012_74016;
var G__74022 = chunk__74013_74017;
var G__74023 = count__74014_74018;
var G__74024 = (i__74015_74019 + (1));
seq__74012_74016 = G__74021;
chunk__74013_74017 = G__74022;
count__74014_74018 = G__74023;
i__74015_74019 = G__74024;
continue;
} else {
var temp__4657__auto___74025 = cljs.core.seq.call(null,seq__74012_74016);
if(temp__4657__auto___74025){
var seq__74012_74026__$1 = temp__4657__auto___74025;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74012_74026__$1)){
var c__28980__auto___74027 = cljs.core.chunk_first.call(null,seq__74012_74026__$1);
var G__74028 = cljs.core.chunk_rest.call(null,seq__74012_74026__$1);
var G__74029 = c__28980__auto___74027;
var G__74030 = cljs.core.count.call(null,c__28980__auto___74027);
var G__74031 = (0);
seq__74012_74016 = G__74028;
chunk__74013_74017 = G__74029;
count__74014_74018 = G__74030;
i__74015_74019 = G__74031;
continue;
} else {
var queue_74032 = cljs.core.first.call(null,seq__74012_74026__$1);
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_74032,tempids);

var G__74033 = cljs.core.next.call(null,seq__74012_74026__$1);
var G__74034 = null;
var G__74035 = (0);
var G__74036 = (0);
seq__74012_74016 = G__74033;
chunk__74013_74017 = G__74034;
count__74014_74018 = G__74035;
i__74015_74019 = G__74036;
continue;
}
} else {
}
}
break;
}

var state_migrate = (function (){var or__28141__auto__ = migrate;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro.client.impl.om_plumbing.resolve_tempids;
}
})();
return state_migrate.call(null,pure,tempids);
});})(rec_atom,remotes,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate))
;
var initial_state_with_locale = (function (){var set_default_locale = ((function (rec_atom,remotes,tempid_migrate,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate){
return (function (s){
return cljs.core.update.call(null,s,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),cljs.core.fnil.call(null,cljs.core.identity,new cljs.core.Keyword(null,"en","en",88457073)));
});})(rec_atom,remotes,tempid_migrate,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate))
;
var is_atom_QMARK_ = fulcro.client.util.atom_QMARK_.call(null,initial_state);
var incoming_locale = cljs.core.get.call(null,(cljs.core.truth_(is_atom_QMARK_)?cljs.core.deref.call(null,initial_state):initial_state),new cljs.core.Keyword("ui","locale","ui/locale",-2115717461));
if(cljs.core.truth_(incoming_locale)){
cljs.core.reset_BANG_.call(null,fulcro.i18n._STAR_current_locale_STAR_,incoming_locale);
} else {
}

if(cljs.core.truth_(is_atom_QMARK_)){
cljs.core.swap_BANG_.call(null,initial_state,set_default_locale);

return initial_state;
} else {
return set_default_locale.call(null,initial_state);
}
})();
var config = cljs.core.merge.call(null,cljs.core.PersistentArrayMap.EMPTY,reconciler_options,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"migrate","migrate",-207110743),tempid_migrate,new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate){
return (function (tx,cb){
return fulcro.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"remotes","remotes",1132366312),remotes,new cljs.core.Keyword(null,"merge-ident","merge-ident",1040841862),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate){
return (function (reconciler,app_state,ident,props){
return cljs.core.update_in.call(null,app_state,ident,cljs.core.comp.call(null,fulcro.client.impl.application.sweep_one,cljs.core.merge),props);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate){
return (function (target,source){
return fulcro.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__74008,map__74008__$1,app,send_queues,mutation_merge,map__74009,map__74009__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser], null));
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
fulcro.client.impl.application.initialize_global_error_callbacks = (function fulcro$client$impl$application$initialize_global_error_callbacks(app){
var seq__74038 = cljs.core.seq.call(null,cljs.core.keys.call(null,new cljs.core.Keyword(null,"networking","networking",586110628).cljs$core$IFn$_invoke$arity$1(app)));
var chunk__74039 = null;
var count__74040 = (0);
var i__74041 = (0);
while(true){
if((i__74041 < count__74040)){
var remote = cljs.core._nth.call(null,chunk__74039,i__74041);
var cb_atom_74042 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(fulcro.client.util.atom_QMARK_.call(null,cb_atom_74042))){
cljs.core.swap_BANG_.call(null,cb_atom_74042,((function (seq__74038,chunk__74039,count__74040,i__74041,cb_atom_74042,remote){
return (function (p1__74037_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__74037_SHARP_)){
return cljs.core.partial.call(null,p1__74037_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__74038,chunk__74039,count__74040,i__74041,cb_atom_74042,remote))
);
} else {
}

var G__74043 = seq__74038;
var G__74044 = chunk__74039;
var G__74045 = count__74040;
var G__74046 = (i__74041 + (1));
seq__74038 = G__74043;
chunk__74039 = G__74044;
count__74040 = G__74045;
i__74041 = G__74046;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__74038);
if(temp__4657__auto__){
var seq__74038__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74038__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__74038__$1);
var G__74047 = cljs.core.chunk_rest.call(null,seq__74038__$1);
var G__74048 = c__28980__auto__;
var G__74049 = cljs.core.count.call(null,c__28980__auto__);
var G__74050 = (0);
seq__74038 = G__74047;
chunk__74039 = G__74048;
count__74040 = G__74049;
i__74041 = G__74050;
continue;
} else {
var remote = cljs.core.first.call(null,seq__74038__$1);
var cb_atom_74051 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(fulcro.client.util.atom_QMARK_.call(null,cb_atom_74051))){
cljs.core.swap_BANG_.call(null,cb_atom_74051,((function (seq__74038,chunk__74039,count__74040,i__74041,cb_atom_74051,remote,seq__74038__$1,temp__4657__auto__){
return (function (p1__74037_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__74037_SHARP_)){
return cljs.core.partial.call(null,p1__74037_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__74038,chunk__74039,count__74040,i__74041,cb_atom_74051,remote,seq__74038__$1,temp__4657__auto__))
);
} else {
}

var G__74052 = cljs.core.next.call(null,seq__74038__$1);
var G__74053 = null;
var G__74054 = (0);
var G__74055 = (0);
seq__74038 = G__74052;
chunk__74039 = G__74053;
count__74040 = G__74054;
i__74041 = G__74055;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=application.js.map?rel=1511404542225
