// Compiled by ClojureScript 1.9.946 {}
goog.provide('pushy.core');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('clojure.string');
goog.require('goog.History');
goog.require('goog.history.Html5History');
goog.require('goog.history.Html5History.TokenTransformer');
goog.require('goog.history.EventType');
goog.require('goog.Uri');
pushy.core.on_click = (function pushy$core$on_click(funk){
return goog.events.listen(document,"click",funk);
});
pushy.core.update_history_BANG_ = (function pushy$core$update_history_BANG_(h){
var G__56159 = h;
G__56159.setUseFragment(false);

G__56159.setPathPrefix("");

G__56159.setEnabled(true);

return G__56159;
});
pushy.core.set_retrieve_token_BANG_ = (function pushy$core$set_retrieve_token_BANG_(t){
t.retrieveToken = (function (path_prefix,location){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.pathname),cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.search)].join('');
});

return t;
});
pushy.core.set_create_url_BANG_ = (function pushy$core$set_create_url_BANG_(t){
t.createUrl = (function (token,path_prefix,location){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join('');
});

return t;
});
pushy.core.new_history = (function pushy$core$new_history(var_args){
var G__56161 = arguments.length;
switch (G__56161) {
case 0:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.new_history.call(null,pushy.core.set_create_url_BANG_.call(null,pushy.core.set_retrieve_token_BANG_.call(null,(new goog.history.Html5History.TokenTransformer()))));
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$1 = (function (transformer){
return pushy.core.update_history_BANG_.call(null,(new goog.history.Html5History(window,transformer)));
});

pushy.core.new_history.cljs$lang$maxFixedArity = 1;


/**
 * @interface
 */
pushy.core.IHistory = function(){};

pushy.core.set_token_BANG_ = (function pushy$core$set_token_BANG_(var_args){
var G__56164 = arguments.length;
switch (G__56164) {
case 2:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$2(this$,token);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,token);
} else {
var m__28825__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$3(this$,token,title);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,token,title);
} else {
var m__28825__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.replace_token_BANG_ = (function pushy$core$replace_token_BANG_(var_args){
var G__56166 = arguments.length;
switch (G__56166) {
case 2:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$2(this$,token);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,token);
} else {
var m__28825__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$3(this$,token,title);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,token,title);
} else {
var m__28825__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.get_token = (function pushy$core$get_token(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$get_token$arity$1 == null)))){
return this$.pushy$core$IHistory$get_token$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (pushy.core.get_token[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (pushy.core.get_token["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.get-token",this$);
}
}
}
});

pushy.core.start_BANG_ = (function pushy$core$start_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$start_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$start_BANG_$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (pushy.core.start_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (pushy.core.start_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.start!",this$);
}
}
}
});

pushy.core.stop_BANG_ = (function pushy$core$stop_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$stop_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$stop_BANG_$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (pushy.core.stop_BANG_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (pushy.core.stop_BANG_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.stop!",this$);
}
}
}
});

pushy.core.processable_url_QMARK_ = (function pushy$core$processable_url_QMARK_(uri){
return (!(clojure.string.blank_QMARK_.call(null,uri))) && (((cljs.core.not.call(null,uri.hasScheme())) && (cljs.core.not.call(null,uri.hasDomain()))) || (!((cljs.core.re_matches.call(null,cljs.core.re_pattern.call(null,["^",cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.origin),".*$"].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(uri)].join('')) == null))));
});
pushy.core.get_token_from_uri = (function pushy$core$get_token_from_uri(uri){
var path = uri.getPath();
var query = uri.getQuery();
if(cljs.core.empty_QMARK_.call(null,query)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query)].join('');
}
});
/**
 * Takes in three functions:
 *  * dispatch-fn: the function that dispatches when a match is found
 *  * match-fn: the function used to check if a particular route exists
 *  * identity-fn: (optional) extract the route from value returned by match-fn
 */
pushy.core.pushy = (function pushy$core$pushy(var_args){
var args__29319__auto__ = [];
var len__29312__auto___56183 = arguments.length;
var i__29313__auto___56184 = (0);
while(true){
if((i__29313__auto___56184 < len__29312__auto___56183)){
args__29319__auto__.push((arguments[i__29313__auto___56184]));

var G__56185 = (i__29313__auto___56184 + (1));
i__29313__auto___56184 = G__56185;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic = (function (dispatch_fn,match_fn,p__56172){
var map__56173 = p__56172;
var map__56173__$1 = ((((!((map__56173 == null)))?((((map__56173.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56173.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56173):map__56173);
var processable_url_QMARK_ = cljs.core.get.call(null,map__56173__$1,new cljs.core.Keyword(null,"processable-url?","processable-url?",1865408336),pushy.core.processable_url_QMARK_);
var identity_fn = cljs.core.get.call(null,map__56173__$1,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),cljs.core.identity);
var prevent_default_when_no_match_QMARK_ = cljs.core.get.call(null,map__56173__$1,new cljs.core.Keyword(null,"prevent-default-when-no-match?","prevent-default-when-no-match?",-358623618),cljs.core.constantly.call(null,false));
var history = pushy.core.new_history.call(null);
var event_keys = cljs.core.atom.call(null,null);
if(typeof pushy.core.t_pushy$core56175 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {pushy.core.IHistory}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
pushy.core.t_pushy$core56175 = (function (dispatch_fn,match_fn,p__56172,map__56173,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_,history,event_keys,meta56176){
this.dispatch_fn = dispatch_fn;
this.match_fn = match_fn;
this.p__56172 = p__56172;
this.map__56173 = map__56173;
this.processable_url_QMARK_ = processable_url_QMARK_;
this.identity_fn = identity_fn;
this.prevent_default_when_no_match_QMARK_ = prevent_default_when_no_match_QMARK_;
this.history = history;
this.event_keys = event_keys;
this.meta56176 = meta56176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

pushy.core.t_pushy$core56175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (_56177,meta56176__$1){
var self__ = this;
var _56177__$1 = this;
return (new pushy.core.t_pushy$core56175(self__.dispatch_fn,self__.match_fn,self__.p__56172,self__.map__56173,self__.processable_url_QMARK_,self__.identity_fn,self__.prevent_default_when_no_match_QMARK_,self__.history,self__.event_keys,meta56176__$1));
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;


pushy.core.t_pushy$core56175.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (_56177){
var self__ = this;
var _56177__$1 = this;
return self__.meta56176;
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;


pushy.core.t_pushy$core56175.prototype.pushy$core$IHistory$ = cljs.core.PROTOCOL_SENTINEL;


pushy.core.t_pushy$core56175.prototype.pushy$core$IHistory$set_token_BANG_$arity$2 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token);
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;


pushy.core.t_pushy$core56175.prototype.pushy$core$IHistory$set_token_BANG_$arity$3 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token,title);
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;


pushy.core.t_pushy$core56175.prototype.pushy$core$IHistory$replace_token_BANG_$arity$2 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token);
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;


pushy.core.t_pushy$core56175.prototype.pushy$core$IHistory$replace_token_BANG_$arity$3 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token,title);
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;


pushy.core.t_pushy$core56175.prototype.pushy$core$IHistory$get_token$arity$1 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.history.getToken();
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;


pushy.core.t_pushy$core56175.prototype.pushy$core$IHistory$start_BANG_$arity$1 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (this$){
var self__ = this;
var this$__$1 = this;
pushy.core.stop_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,goog.events.listen(self__.history,goog.history.EventType.NAVIGATE,((function (this$__$1,history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (e){
var temp__4657__auto__ = self__.identity_fn.call(null,self__.match_fn.call(null,e.token));
if(cljs.core.truth_(temp__4657__auto__)){
var match = temp__4657__auto__;
return self__.dispatch_fn.call(null,match);
} else {
return null;
}
});})(this$__$1,history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
));

var temp__4657__auto___56186 = self__.identity_fn.call(null,self__.match_fn.call(null,pushy.core.get_token.call(null,this$__$1)));
if(cljs.core.truth_(temp__4657__auto___56186)){
var match_56187 = temp__4657__auto___56186;
self__.dispatch_fn.call(null,match_56187);
} else {
}

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,pushy.core.on_click.call(null,((function (this$__$1,history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (e){
var temp__4657__auto__ = (function (){var G__56178 = e;
var G__56178__$1 = (((G__56178 == null))?null:G__56178.target);
if((G__56178__$1 == null)){
return null;
} else {
return G__56178__$1.closest("a");
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var el = temp__4657__auto__;
var uri = goog.Uri.parse(el.href);
if(cljs.core.truth_((function (){var and__28129__auto__ = self__.processable_url_QMARK_.call(null,uri);
if(cljs.core.truth_(and__28129__auto__)){
return (cljs.core.not.call(null,e.altKey)) && (cljs.core.not.call(null,e.ctrlKey)) && (cljs.core.not.call(null,e.metaKey)) && (cljs.core.not.call(null,e.shiftKey)) && (cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["_self",null,"_blank",null], null), null),el.getAttribute("target")))) && ((cljs.core.not.call(null,el.hasAttribute("data-pushy-ignore"))) || (cljs.core._EQ_.call(null,el.getAttribute("data-pushy-ignore"),"false"))) && (cljs.core._EQ_.call(null,(0),e.button));
} else {
return and__28129__auto__;
}
})())){
var next_token = pushy.core.get_token_from_uri.call(null,uri);
if(cljs.core.truth_(self__.identity_fn.call(null,self__.match_fn.call(null,next_token)))){
var temp__4655__auto___56188 = el.title;
if(cljs.core.truth_(temp__4655__auto___56188)){
var title_56189 = temp__4655__auto___56188;
pushy.core.set_token_BANG_.call(null,this$__$1,next_token,title_56189);
} else {
pushy.core.set_token_BANG_.call(null,this$__$1,next_token);
}

return e.preventDefault();
} else {
if(cljs.core.truth_(self__.prevent_default_when_no_match_QMARK_.call(null,next_token))){
return e.preventDefault();
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});})(this$__$1,history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
));

return null;
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;


pushy.core.t_pushy$core56175.prototype.pushy$core$IHistory$stop_BANG_$arity$1 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (this$){
var self__ = this;
var this$__$1 = this;
var seq__56179_56190 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.event_keys));
var chunk__56180_56191 = null;
var count__56181_56192 = (0);
var i__56182_56193 = (0);
while(true){
if((i__56182_56193 < count__56181_56192)){
var key_56194 = cljs.core._nth.call(null,chunk__56180_56191,i__56182_56193);
goog.events.unlistenByKey(key_56194);

var G__56195 = seq__56179_56190;
var G__56196 = chunk__56180_56191;
var G__56197 = count__56181_56192;
var G__56198 = (i__56182_56193 + (1));
seq__56179_56190 = G__56195;
chunk__56180_56191 = G__56196;
count__56181_56192 = G__56197;
i__56182_56193 = G__56198;
continue;
} else {
var temp__4657__auto___56199 = cljs.core.seq.call(null,seq__56179_56190);
if(temp__4657__auto___56199){
var seq__56179_56200__$1 = temp__4657__auto___56199;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56179_56200__$1)){
var c__28980__auto___56201 = cljs.core.chunk_first.call(null,seq__56179_56200__$1);
var G__56202 = cljs.core.chunk_rest.call(null,seq__56179_56200__$1);
var G__56203 = c__28980__auto___56201;
var G__56204 = cljs.core.count.call(null,c__28980__auto___56201);
var G__56205 = (0);
seq__56179_56190 = G__56202;
chunk__56180_56191 = G__56203;
count__56181_56192 = G__56204;
i__56182_56193 = G__56205;
continue;
} else {
var key_56206 = cljs.core.first.call(null,seq__56179_56200__$1);
goog.events.unlistenByKey(key_56206);

var G__56207 = cljs.core.next.call(null,seq__56179_56200__$1);
var G__56208 = null;
var G__56209 = (0);
var G__56210 = (0);
seq__56179_56190 = G__56207;
chunk__56180_56191 = G__56208;
count__56181_56192 = G__56209;
i__56182_56193 = G__56210;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,self__.event_keys,null);
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;

pushy.core.t_pushy$core56175.getBasis = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dispatch-fn","dispatch-fn",-1401088155,null),new cljs.core.Symbol(null,"match-fn","match-fn",-795226853,null),new cljs.core.Symbol(null,"p__56172","p__56172",2128601255,null),new cljs.core.Symbol(null,"map__56173","map__56173",-1026673731,null),new cljs.core.Symbol(null,"processable-url?","processable-url?",-789027433,null),new cljs.core.Symbol(null,"identity-fn","identity-fn",756348900,null),new cljs.core.Symbol(null,"prevent-default-when-no-match?","prevent-default-when-no-match?",1281907909,null),new cljs.core.Symbol(null,"history","history",1393136307,null),new cljs.core.Symbol(null,"event-keys","event-keys",804564896,null),new cljs.core.Symbol(null,"meta56176","meta56176",266080525,null)], null);
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;

pushy.core.t_pushy$core56175.cljs$lang$type = true;

pushy.core.t_pushy$core56175.cljs$lang$ctorStr = "pushy.core/t_pushy$core56175";

pushy.core.t_pushy$core56175.cljs$lang$ctorPrWriter = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"pushy.core/t_pushy$core56175");
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;

pushy.core.__GT_t_pushy$core56175 = ((function (history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_){
return (function pushy$core$__GT_t_pushy$core56175(dispatch_fn__$1,match_fn__$1,p__56172__$1,map__56173__$2,processable_url_QMARK___$1,identity_fn__$1,prevent_default_when_no_match_QMARK___$1,history__$1,event_keys__$1,meta56176){
return (new pushy.core.t_pushy$core56175(dispatch_fn__$1,match_fn__$1,p__56172__$1,map__56173__$2,processable_url_QMARK___$1,identity_fn__$1,prevent_default_when_no_match_QMARK___$1,history__$1,event_keys__$1,meta56176));
});})(history,event_keys,map__56173,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_))
;

}

return (new pushy.core.t_pushy$core56175(dispatch_fn,match_fn,p__56172,map__56173__$1,processable_url_QMARK_,identity_fn,prevent_default_when_no_match_QMARK_,history,event_keys,cljs.core.PersistentArrayMap.EMPTY));
});

pushy.core.pushy.cljs$lang$maxFixedArity = (2);

pushy.core.pushy.cljs$lang$applyTo = (function (seq56169){
var G__56170 = cljs.core.first.call(null,seq56169);
var seq56169__$1 = cljs.core.next.call(null,seq56169);
var G__56171 = cljs.core.first.call(null,seq56169__$1);
var seq56169__$2 = cljs.core.next.call(null,seq56169__$1);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic(G__56170,G__56171,seq56169__$2);
});

/**
 * Returns whether Html5History is supported
 */
pushy.core.supported_QMARK_ = (function pushy$core$supported_QMARK_(var_args){
var G__56212 = arguments.length;
switch (G__56212) {
case 0:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.supported_QMARK_.call(null,window);
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (window){
return goog.history.Html5History.isSupported(window);
});

pushy.core.supported_QMARK_.cljs$lang$maxFixedArity = 1;

pushy.core.push_state_BANG_ = (function pushy$core$push_state_BANG_(var_args){
var G__56215 = arguments.length;
switch (G__56215) {
case 2:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (dispatch_fn,match_fn){
return pushy.core.push_state_BANG_.call(null,dispatch_fn,match_fn,cljs.core.identity);
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (dispatch_fn,match_fn,identity_fn){
var h = pushy.core.pushy.call(null,dispatch_fn,match_fn,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),identity_fn);
pushy.core.start_BANG_.call(null,h);

return h;
});

pushy.core.push_state_BANG_.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map?rel=1511404501157
