(ns fulcrologic.semantic-ui.factories
  (:require
    cljsjs.semantic-ui-react
    goog.object))

(defn factory-apply
  [class]
  (fn [props & children]
    (apply js/React.createElement
      class
      props
      children)))

(def semantic-ui js/semanticUIReact)

(defn get-sui
  ([cls]
   (goog.object/get semantic-ui cls))
  ([cls member]
   (goog.object/getValueByKeys semantic-ui cls member)))

(defn sui-factory
  ([cls] (factory-apply (get-sui cls)))
  ([cls member] (factory-apply (get-sui cls member))))

(def button
  "A button

  props (a javascript object)
  "
  (sui-factory "Button"))

(def button-content (sui-factory "Button" "Content"))
(def button-group (sui-factory "Button" "Group"))
(def button-or (sui-factory "Button" "Or"))
(def container (sui-factory "Container"))
(def divider (sui-factory "Divider"))
(def flag (sui-factory "Flag"))
(def header (sui-factory "Header"))
(def header-content (sui-factory "Header" "Content"))
(def header-subheader (sui-factory "Header" "Subheader"))
(def icon (sui-factory "Icon"))
(def icon-group (sui-factory "Icon" "Group"))
(def image (sui-factory "Image"))
(def image-group (sui-factory "Image" "Group"))
(def input (sui-factory "Input"))
(def label (sui-factory "Label"))
(def label-detail (sui-factory "Label" "Detail"))
(def label-group (sui-factory "Label" "Group"))
(def list (sui-factory "List"))
(def list-content (sui-factory "List" "Content"))
(def list-description (sui-factory "List" "Description"))
(def list-header (sui-factory "List" "Header"))
(def list-icon (sui-factory "List" "Icon"))
(def list-item (sui-factory "List" "Item"))
(def list-list (sui-factory "List" "List"))
(def loader (sui-factory "Loader"))
(def rail (sui-factory "Rail"))
(def reveal (sui-factory "Reveal"))
(def reveal-content (sui-factory "Reveal" "Content"))
(def segment (sui-factory "Segment"))
(def segment-group (sui-factory "Segment" "Group"))
(def step (sui-factory "Step"))
(def step-content (sui-factory "Step" "Content"))
(def step-description (sui-factory "Step" "Description"))
(def step-group (sui-factory "Step" "Group"))
(def step-title (sui-factory "Step" "Title"))
(def breadcrumb (sui-factory "Breadcrumb"))
(def breadcrumb-divider (sui-factory "Breadcrumb" "Divider"))
(def breadcrumb-section (sui-factory "Breadcrumb" "Section"))
(def form (sui-factory "Form"))
(def form-field (sui-factory "Form" "Field"))
(def form-button (sui-factory "Form" "Button"))
(def form-checkbox (sui-factory "Form" "Checkbox"))
(def form-dropdown (sui-factory "Form" "Dropdown"))
(def form-group (sui-factory "Form" "Group"))
(def form-input (sui-factory "Form" "Input"))
(def form-radio (sui-factory "Form" "Radio"))
(def form-select (sui-factory "Form" "Select"))
(def form-textarea (sui-factory "Form" "TextArea"))
(def grid (sui-factory "Grid"))
(def grid-row (sui-factory "Grid" "Row"))
(def grid-column (sui-factory "Grid" "Column"))
(def menu (sui-factory "Menu"))
(def menu-header (sui-factory "Menu" "Header"))
(def menu-item (sui-factory "Menu" "item"))
(def menu-menu (sui-factory "Menu" "Menu"))
(def message (sui-factory "Message"))
(def message-content (sui-factory "Message" "Content"))
(def message-header (sui-factory "Message" "Header"))
(def message-list (sui-factory "Message" "List"))
(def message-item (sui-factory "Message" "Item"))
(def table (sui-factory "Table"))
(def table-body (sui-factory "Table" "Body"))
(def table-cell (sui-factory "Table" "Cell"))
(def table-footer (sui-factory "Table" "Footer"))
(def table-header (sui-factory "Table" "Header"))
(def table-header-cell (sui-factory "Table" "HeaderCell"))
(def table-row (sui-factory "Table" "Row"))
(def advertisement (sui-factory "Advertisement"))
(def card (sui-factory "Card"))
(def card-content (sui-factory "Card" "Content"))
(def card-description (sui-factory "Card" "Description"))
(def card-group (sui-factory "Card" "Group"))
(def card-header (sui-factory "Card" "Header"))
(def card-meta (sui-factory "Card" "Meta"))
(def comment (sui-factory "Comment"))
(def comment-author (sui-factory "Comment" "Author"))
(def comment-action (sui-factory "Comment" "Action"))
(def comment-actions (sui-factory "Comment" "Actions"))
(def comment-avatar (sui-factory "Comment" "Avatar"))
(def comment-content (sui-factory "Comment" "Content"))
(def comment-group (sui-factory "Comment" "Group"))
(def comment-metadata (sui-factory "Comment" "Metadata"))
(def comment-text (sui-factory "Comment" "Text"))
(def feed (sui-factory "Feed"))
(def feed-content (sui-factory "Feed" "Content"))
(def feed-date (sui-factory "Feed" "Date"))
(def feed-event (sui-factory "Feed" "Event"))
(def feed-extra (sui-factory "Feed" "Extra"))
(def feed-label (sui-factory "Feed" "Label"))
(def feed-like (sui-factory "Feed" "Like"))
(def feed-meta (sui-factory "Feed" "Meta"))
(def feed-summary (sui-factory "Feed" "Summary"))
(def feed-user (sui-factory "Feed" "User"))
(def item (sui-factory "Item"))
(def item-content (sui-factory "Item" "Content"))
(def item-description (sui-factory "Item" "Description"))
(def item-extra (sui-factory "Item" "Extra"))
(def item-group (sui-factory "Item" "Group"))
(def item-header (sui-factory "Item" "Header"))
(def item-image (sui-factory "Item" "Image"))
(def item-meta (sui-factory "Item" "Meta"))
(def statistic (sui-factory "Statistic"))
(def statistic-group (sui-factory "Statistic" "Group"))
(def statistic-label (sui-factory "Statistic" "Label"))
(def statistic-value (sui-factory "Statistic" "Value"))
(def accordion (sui-factory "Accordion"))
(def accordion-accordion (sui-factory "Accordion" "Accordion"))
(def accordion-content (sui-factory "Accordion" "Content"))
(def accordion-title (sui-factory "Accordion" "Title"))
(def checkbox (sui-factory "Checkbox"))
(def dimmer (sui-factory "Dimmer"))
(def dimmer-dimmable (sui-factory "Dimmer" "Dimmable"))
(def dropdown (sui-factory "Dropdown"))
(def dropdown-divider (sui-factory "Dropdown" "Divider"))
(def dropdown-header (sui-factory "Dropdown" "Header"))
(def dropdown-item (sui-factory "Dropdown" "Item"))
(def dropdown-menu (sui-factory "Dropdown" "Menu"))
(def dropdown-search-input (sui-factory "Dropdown" "SearchInput"))
(def embed (sui-factory "Embed"))
(def modal (sui-factory "Modal"))
(def modal-header (sui-factory "Modal" "Header"))
(def modal-content (sui-factory "Modal" "Content"))
(def modal-description (sui-factory "Modal" "Description"))
(def modal-actions (sui-factory "Modal" "Actions"))
(def popup (sui-factory "Popup"))
(def popup-content (sui-factory "Popup" "Content"))
(def popup-header (sui-factory "Popup" "Header"))
(def progress (sui-factory "Progress"))
(def rating (sui-factory "Rating"))
(def rating-icon (sui-factory "Rating" "Icon"))
(def search (sui-factory "Search"))
(def search-category (sui-factory "Search" "Category"))
(def search-result (sui-factory "Search" "Result"))
(def search-results (sui-factory "Search" "Results"))
(def sidebar (sui-factory "Sidebar"))
(def sidebar-pushable (sui-factory "Sidebar" "Pushable"))
(def sidebar-pusher (sui-factory "Sidebar" "Pusher"))
(def sticky (sui-factory "Sticky"))
(def tab (sui-factory "Tab"))
(def tab-pane (sui-factory "Tab" "Pane"))
(def transition (sui-factory "Transition"))
(def transition-group (sui-factory "Transition" "Group"))
(def visibility (sui-factory "Visibility"))
(def confirm (sui-factory "Confirm"))
(def portal (sui-factory "Portal"))
(def responsive (sui-factory "Responsive"))
(def radio (sui-factory "Radio"))
(def select (sui-factory "Select"))
(def textarea (sui-factory "TextArea"))
