/*
 * Decompiled with CFR 0.152.
 */
package funcatron.devshim;

import com.fasterxml.jackson.databind.ObjectMapper;
import funcatron.intf.Context;
import funcatron.intf.Func;
import funcatron.intf.MetaResponse;
import funcatron.intf.impl.ContextImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.slf4j.LoggerFactory;

public class Register {
    static final Logger logger = Logger.getLogger("funcatron.devshim.Register");
    private static final Object syncObj = new Object();
    private static InputStream tronInput;
    private static OutputStream tronOutput;
    private static Socket tronSocket;
    private static final AtomicLong runCount;
    private static Thread fileWatcher;
    private static final ExecutorService executor;
    private static final HashMap<String, Function<Map, Void>> execMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String host, int port, File funcatronFile) throws IOException {
        Object object = syncObj;
        synchronized (object) {
            runCount.incrementAndGet();
            Register.shutdown();
            try {
                Socket sock = new Socket(host, port);
                InputStream is = sock.getInputStream();
                OutputStream os = sock.getOutputStream();
                tronSocket = sock;
                tronInput = is;
                tronOutput = os;
                Register.sayHello();
                fileWatcher = new Thread(() -> Register.startWatching(runCount.longValue(), funcatronFile), "Funcatron File Watcher");
                fileWatcher.start();
                Thread t = new Thread(() -> Register.processMessages(runCount.longValue()), "Funcatron Tron Message Processor");
                t.start();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, ioe, () -> "Failed to connect to Tron");
                Register.shutdown();
                throw ioe;
            }
        }
    }

    private static Void invoker(Map<String, Object> info) {
        String classname = (String)info.get("class");
        Map headers = (Map)info.get("headers");
        try {
            Class<?> c = Class.forName(classname);
            Func f = (Func)c.newInstance();
            Method meth = Arrays.stream(c.getMethods()).filter(m -> m.getName().equals("apply") && m.getParameterCount() == 2).findFirst().get();
            Class<?> paramType = meth.getParameterTypes()[0];
            Object theParam = null;
            if (null != info.get("body")) {
                theParam = new ObjectMapper().readValue((String)info.get("body"), paramType);
            }
            Object ret = f.apply(theParam, (Context)new ContextImpl(headers, LoggerFactory.getLogger((String)classname)));
            HashMap<String, Object> answer = new HashMap<String, Object>();
            HashMap<String, Object> response = new HashMap<String, Object>();
            HashMap<String, String> repHeaders = new HashMap<String, String>();
            answer.put("cmd", "reply");
            answer.put("replyTo", info.get("replyTo"));
            answer.put("response", response);
            response.put("status", 200);
            response.put("headers", repHeaders);
            if (null == ret) {
                repHeaders.put("Content-Type", "text/plain");
                response.put("body", "");
            } else if (ret instanceof MetaResponse) {
                MetaResponse mr = (MetaResponse)ret;
                response.put("headers", mr.getHeaders());
                response.put("status", mr.getResponseCode());
                response.put("body", Base64.getEncoder().encode(mr.getBody()));
                answer.put("decodeBody", true);
            } else {
                response.put("body", ret);
                repHeaders.put("Content-Type", "application/json");
            }
            Register.sendMessage(answer);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e, () -> "Unabled to invoke " + classname);
            HashMap<String, Object> answer = new HashMap<String, Object>();
            HashMap<String, Object> response = new HashMap<String, Object>();
            HashMap<String, String> repHeaders = new HashMap<String, String>();
            answer.put("response", response);
            response.put("headers", repHeaders);
            answer.put("cmd", "reply");
            answer.put("replyTo", info.get("replyTo"));
            response.put("status", 500);
            repHeaders.put("Content-Type", "text/plain");
            try {
                response.put("body", e.getMessage());
                Register.sendMessage(answer);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, ioe, () -> "Failed to send response");
            }
        }
        return null;
    }

    private static byte[] readBytes(InputStream is) throws IOException {
        byte[] ba = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int cnt = 0;
        do {
            if ((cnt = is.read(ba)) <= 0) continue;
            bos.write(ba, 0, cnt);
        } while (cnt >= 0);
        is.close();
        return bos.toByteArray();
    }

    private static void startWatching(long version, File funcatronFile) {
        String fileBytes = null;
        boolean first = true;
        while (version == runCount.longValue()) {
            try {
                if (!first) {
                    Thread.sleep(1000L);
                }
                first = false;
                byte[] ba = Register.readBytes(new FileInputStream(funcatronFile));
                String contents = new String(ba, "UTF-8");
                if (contents.equals(fileBytes)) continue;
                fileBytes = contents;
                HashMap<String, String> msg = new HashMap<String, String>();
                msg.put("cmd", "setSwagger");
                msg.put("swagger", contents);
                Register.sendMessage(msg);
            }
            catch (InterruptedException ba) {
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, ioe, () -> "Couldn't update");
            }
        }
    }

    private static void processMessages(long version) {
        try {
            InputStreamReader ios = new InputStreamReader(tronInput, "UTF-8");
            BufferedReader br = new BufferedReader(ios);
            while (version == runCount.longValue()) {
                Function<Map, Void> func;
                String line = br.readLine();
                byte[] bytes = Base64.getDecoder().decode(line);
                Map message = (Map)new ObjectMapper().reader().forType(Map.class).readValue(bytes);
                String cmd = (String)message.get("cmd");
                if (null == cmd || null == (func = execMap.get(cmd))) continue;
                executor.submit(() -> (Void)func.apply(message));
            }
        }
        catch (UnsupportedEncodingException uee) {
            logger.log(Level.WARNING, uee, () -> "Totally unexpected that UTF-8 isn't supported");
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe, () -> "Connection version " + version + " ended.");
        }
    }

    private static void sayHello() throws IOException {
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("cmd", "hello");
        Register.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendMessage(Map msg) throws IOException {
        byte[] bytes = new ObjectMapper().writer().writeValueAsBytes((Object)msg);
        String line = Base64.getEncoder().encodeToString(bytes);
        Object object = syncObj;
        synchronized (object) {
            BufferedWriter br = new BufferedWriter(new OutputStreamWriter(tronOutput, "UTF-8"));
            br.write(line);
            br.write("\n");
            br.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = syncObj;
        synchronized (object) {
            runCount.incrementAndGet();
            if (null != tronInput) {
                try {
                    InputStream is = tronInput;
                    tronInput = null;
                    is.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, ioe, () -> "Failed to close input stream.");
                }
            }
            if (null != tronOutput) {
                try {
                    OutputStream os = tronOutput;
                    tronOutput = null;
                    os.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, ioe, () -> "Failed to close output stream.");
                }
            }
            if (null != tronSocket) {
                try {
                    Socket sock = tronSocket;
                    tronSocket = null;
                    sock.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, ioe, () -> "Failed to close socket.");
                }
            }
            if (null != fileWatcher) {
                Thread t = fileWatcher;
                fileWatcher = null;
                t.interrupt();
            }
        }
    }

    public static void register(File funcatronFile) throws Exception {
        Register.register("localhost", 54657, funcatronFile);
    }

    public static void register(String host, File funcatronFile) throws Exception {
        Register.register(host, 54657, funcatronFile);
    }

    public static void register(int port, File funcatronFile) throws Exception {
        Register.register("localhost", port, funcatronFile);
    }

    public static void main(String[] argv) throws Exception {
        Register.register("localhost", 54657, new File("src/main/resources/funcatron.yml"));
        System.out.println("Funcatron registered");
    }

    static {
        runCount = new AtomicLong(0L);
        executor = Executors.newFixedThreadPool(5);
        execMap = new HashMap();
        execMap.put("invoke", Register::invoker);
    }

    static class Mooser
    implements Func<PetOwner, User> {
        Mooser() {
        }

        public User apply(PetOwner po, Context context) {
            User ret = null;
            if (null != po) {
                ret = po.getPet();
            }
            if (ret == null) {
                ret = new User();
                ret.setAge(52);
                ret.setName("David");
            }
            ret.setName("Hello: " + ret.getName());
            ret.setAge(1 + ret.getAge());
            return ret;
        }
    }

    public static class PetOwner
    implements Serializable {
        private User pet;

        public PetOwner(User pet) {
            this.pet = pet;
        }

        public PetOwner() {
        }

        public User getPet() {
            return this.pet;
        }

        public void setPet(User u) {
            this.pet = u;
        }
    }

    public static class User
    implements Serializable {
        private String name;
        private Integer age;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }
    }
}

