/*
 * Decompiled with CFR 0.152.
 */
package funcatron.intf.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import funcatron.intf.Accumulator;
import funcatron.intf.ServiceVendor;
import funcatron.intf.ServiceVendorBuilder;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class JDBCServiceVendorBuilder
implements ServiceVendorBuilder {
    @Override
    public String forType() {
        return "database";
    }

    private static String mapToString(Map map) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            sb.append(entry.getKey());
            sb.append('=').append('\"');
            sb.append(entry.getValue());
            sb.append('\"');
            if (!iter.hasNext()) continue;
            sb.append(',').append(' ');
        }
        return sb.toString();
    }

    @Override
    public Optional<ServiceVendor<?>> buildVendor(final String name, Map<String, Object> properties, Logger logger) {
        HashSet reserved = new HashSet();
        String[] ra = new String[]{"type", "url", "username", "password"};
        Collections.addAll(reserved, ra);
        Object url = properties.get("url");
        Object username = properties.get("username");
        Object password = properties.get("password");
        if (null != url && url instanceof String) {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl((String)url);
            if (null != username && username instanceof String) {
                config.setUsername((String)username);
            }
            if (null != password && password instanceof String) {
                config.setPassword((String)password);
            }
            properties.entrySet().stream().filter(a -> !reserved.contains(a.getKey())).filter(a -> a.getValue() instanceof String).forEach(a -> config.addDataSourceProperty((String)a.getKey(), a.getValue()));
            final HikariDataSource ds = new HikariDataSource(config);
            return Optional.of(new ServiceVendor<Connection>(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public Class<Connection> type() {
                    return Connection.class;
                }

                @Override
                public Connection vend(Accumulator acc) throws Exception {
                    return ds.getConnection();
                }

                @Override
                public void endLife() {
                    ds.close();
                }

                @Override
                public void release(Connection item, boolean success) throws Exception {
                    try {
                        if (success) {
                            item.commit();
                        } else {
                            item.rollback();
                        }
                    }
                    finally {
                        item.close();
                    }
                }
            });
        }
        logger.warning("Trying to build database connection, but " + JDBCServiceVendorBuilder.mapToString(properties) + " does not contain 'url' parameter");
        return Optional.empty();
    }
}

