/*
 * Decompiled with CFR 0.152.
 */
package funcatron.intf.impl;

import funcatron.intf.Accumulator;
import funcatron.intf.Context;
import funcatron.intf.ServiceVendor;
import funcatron.intf.ServiceVendorBuilder;
import funcatron.intf.impl.JDBCServiceVendorBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContextImpl
implements Context,
Accumulator {
    private final Map<Object, Object> data;
    private final Logger logger;
    private final CopyOnWriteArrayList<ReleasePair<?>> toTerminate = new CopyOnWriteArrayList();
    private static final ConcurrentHashMap<String, ServiceVendor<?>> services = new ConcurrentHashMap();
    private static Map<String, Object> props = new HashMap<String, Object>();

    public ContextImpl(Map<Object, Object> data, Logger logger) {
        this.data = data;
        this.logger = logger;
    }

    public static void initContext(Map<String, Object> props, ClassLoader loader, Logger logger) throws Exception {
        logger.log(Level.INFO, () -> "Setting up context with props " + props);
        ContextImpl.props = props;
        ServiceLoader<ServiceVendorBuilder> builders = ServiceLoader.load(ServiceVendorBuilder.class, loader);
        HashMap<String, JDBCServiceVendorBuilder> builderMap = new HashMap<String, JDBCServiceVendorBuilder>();
        builders.forEach(a -> builderMap.put(a.forType(), (JDBCServiceVendorBuilder)a));
        JDBCServiceVendorBuilder db = new JDBCServiceVendorBuilder();
        builderMap.put(db.forType(), db);
        props.forEach((k, v) -> {
            Map m;
            Object o;
            if (null != k && k instanceof String && null != v && v instanceof Map && null != (o = (m = (Map)v).get("type")) && o instanceof String) {
                logger.log(Level.FINER, () -> "Looking for builder for type: " + o);
                ServiceVendorBuilder b = (ServiceVendorBuilder)builderMap.get(o);
                if (null != b) {
                    logger.log(Level.FINER, () -> "Building with props " + m);
                    Optional<ServiceVendor<?>> opt = b.buildVendor((String)k, m, logger);
                    opt.map(vendor -> services.put((String)k, (ServiceVendor<?>)vendor));
                }
            }
        });
    }

    public static void endLife() {
        services.entrySet().forEach(a -> ((ServiceVendor)a.getValue()).endLife());
    }

    @Override
    public Map<Object, Object> getRequestInfo() {
        return this.data;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getURI() {
        return (String)this.data.get("uri");
    }

    @Override
    public Map<String, Map<String, Object>> getRequestParams() {
        return (Map)this.data.get("parameters");
    }

    @Override
    public Map<String, Object> getPathParams() {
        HashMap ret;
        HashMap parameters = (HashMap)this.data.get("parameters");
        if (null == parameters) {
            parameters = new HashMap();
        }
        if (null == (ret = (HashMap)parameters.get("path"))) {
            ret = new HashMap();
        }
        return ret;
    }

    @Override
    public Map<String, Object> getBodyParams() {
        HashMap ret;
        HashMap parameters = (HashMap)this.data.get("parameters");
        if (null == parameters) {
            parameters = new HashMap();
        }
        if (null == (ret = (HashMap)parameters.get("body"))) {
            ret = new HashMap();
        }
        return ret;
    }

    @Override
    public Map<String, Object> getMergedParams() {
        Map<String, Object> path = this.getPathParams();
        Map<String, Object> query = this.getQueryParams();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        path.forEach((k, v) -> ret.put((String)k, v));
        query.forEach((k, v) -> ret.put((String)k, v));
        return ret;
    }

    @Override
    public Map<String, Object> getQueryParams() {
        HashMap ret;
        HashMap parameters = (HashMap)this.data.get("parameters");
        if (null == parameters) {
            parameters = new HashMap();
        }
        if (null == (ret = (HashMap)parameters.get("query"))) {
            ret = new HashMap();
        }
        return ret;
    }

    @Override
    public String getScheme() {
        return (String)this.data.get("scheme");
    }

    @Override
    public String getHost() {
        return (String)this.data.get("host");
    }

    @Override
    public String getMethod() {
        return (String)this.data.get("request-method");
    }

    public static String getVersion() {
        return "1";
    }

    @Override
    public <T> void accumulate(T item, ServiceVendor<T> vendor) {
        this.getLogger().log(Level.FINER, () -> "Accumulating " + item);
        this.toTerminate.add(new ReleasePair<T>(item, vendor));
    }

    public void finished(boolean success) {
        this.getLogger().log(Level.FINER, () -> "Finished " + success + " Notifying " + this.toTerminate.size());
        this.toTerminate.forEach((Consumer<ReleasePair<?>>)((Consumer<ReleasePair>)a -> {
            ReleasePair b = a;
            try {
                this.getLogger().log(Level.FINER, () -> "Releasing " + b.item);
                b.vendor.release(b.item, success);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception releasing " + a.item, e);
            }
        }));
    }

    @Override
    public Set<String> services() {
        return services.keySet();
    }

    @Override
    public Optional<ServiceVendor<?>> serviceForName(String name) {
        if (!services.containsKey(name)) {
            return Optional.empty();
        }
        return Optional.of(services.get(name));
    }

    @Override
    public <T> Optional<T> vendForName(String name, Class<T> clz) throws Exception {
        Optional<ServiceVendor<T>> ov = this.serviceForName(name, clz);
        if (ov.isPresent()) {
            return Optional.of(ov.get().vend(this));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Object> properties() {
        return props;
    }

    private static class ReleasePair<T> {
        final T item;
        final ServiceVendor<T> vendor;

        ReleasePair(T item, ServiceVendor<T> vendor) {
            this.item = item;
            this.vendor = vendor;
        }
    }
}

