(ns octet.buffer
  "Buffer abstractions."
       
                              
                                  
                                            )

(defprotocol IBufferShort
  (read-short [_ pos] "Read short integer (16 bits) from buffer.")
  (write-short [_ pos value] "Write a short integer to the buffer."))

(defprotocol IBufferInt
  (read-int [_ pos] "Read an integer (32 bits) from buffer.")
  (write-int [_ pos value] "Write an integer to the buffer."))

(defprotocol IBufferLong
  (read-long [_ pos] "Read an long (64 bits) from buffer.")
  (write-long [_ pos value] "Write a long to the buffer."))

(defprotocol IBufferFloat
  (read-float [_ pos] "Read an float (32 bits) from buffer.")
  (write-float [_ pos value] "Write a float to the buffer."))

(defprotocol IBufferDouble
  (read-double [_ pos] "Read an double (64 bits) from buffer.")
  (write-double [_ pos value] "Write a double to the buffer."))

(defprotocol IBufferByte
  (read-byte [_ pos] "Read one byte from buffer.")
  (write-byte [_ pos value] "Write one byte to the buffer."))

(defprotocol IBufferBytes
  (read-bytes [_ pos size] "Read a byte array.")
  (write-bytes [_ pos size data] "Write byte array."))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; NIO & Netty Buffer implementations
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

     
                       
              
                        
                         
                               
                               

            
                      
                       
                             
                             

             
                       
                        
                              
                              

              
                        
                         
                               
                               

               
                         
                          
                                
                                

             
                       
                    
                              
                          

              
                             
                                  
                                  
                          
                        
                             
              
                                   
                                  
                          
                             
                                

     
                    
              
                        
                         
                               
                               

            
                      
                       
                             
                             

             
                       
                        
                              
                              

              
                        
                         
                               
                               

               
                         
                          
                                
                                

             
                       
                        
                              
                              

              
                             
                                   
                                 
              
                                   
                                      

      
(extend-type js/DataView
  IBufferShort
  (read-short [buff pos]
    (.getInt16 buff pos))
  (write-short [buff pos value]
    (.setInt16 buff pos value))

  IBufferInt
  (read-int [buff pos]
    (.getInt32 buff pos))
  (write-int [buff pos value]
    (.setInt32 buff pos value))

  IBufferFloat
  (read-float [buff pos]
    (.getFloat32 buff pos))
  (write-float [buff pos value]
    (.setFloat32 buff pos value))

  IBufferDouble
  (read-double [buff pos]
    (.getFloat64 buff pos))
  (write-double [buff pos value]
    (.setFloat64 buff pos value))

  IBufferByte
  (read-byte [buff pos]
    (.getInt8 buff pos))
  (write-byte [buff pos value]
    (.setInt8 buff pos value))

  IBufferBytes
  (read-bytes [buff pos size]
    (let [offset (.-byteOffset buff)
          buffer (.-buffer buff)]
      (js/Int8Array. buffer (+ offset pos) size)))
  (write-bytes [buff pos size data]
    (doseq [i (range (.-length data))]
      (.setInt8 buff (+ pos i) (aget data i)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Public Api
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

     
                     
                                       

(defmulti allocate
  (fn [size & [{:keys [type impl] :or {type :heap impl                   :es6}}]]
    [type impl]))

     
                                
            
                             

     
                                  
            
                                   

     
                                  
            
                               

     
                                    
            
                                 

      
(defmethod allocate [:heap :es6]
  [size & _]
  (let [bf (js/ArrayBuffer. size)]
    (js/DataView. bf)))

;; #+cljs
;; (defmethod allocate [:heap :node]
;;   [size & _]
;;   (let [bf (js/require "buffer")
;;         bf (.-Buffer bf)]
;;     (bf. size)))

;;;;;;;;;;;; This file autogenerated from src/octet/buffer.cljx
