(ns {{namespace}}.application
  (:require [{{namespace}}.config.system :refer [init-system start!]]
            [clojure.tools.logging :as log])
  (:gen-class))

(defn -main
  "The entry-point for 'lein run'"
  [& args]
  (log/info "Starting server...")
  (init-system)
  (start!))

(defn run-dev
  "The entry-point for 'lein run-dev'"
  [& args]
  (log/info "Starting [DEV] environment...")
  (init-system)
  (start!))