(ns {{namespace}}.config.http-server
  (:require [com.stuartsierra.component :as component]
            [{{namespace}}.entrypoint.http.router :as router]
            [aleph.http :as http]
            [clojure.tools.logging :as log])
  (:import (java.io Closeable)))

(defrecord HttpServer [server]

  component/Lifecycle

  (start [this]
    (log/info "starting server at port " (get-in this [:props :server-port]))
    (assoc this :server (http/start-server (router/bind-routes this) {:port (get-in this [:props :server-port])})))

  (stop [this]
    (log/info  "Stopping Server")
    (.close (:server this))
    (dissoc this :server)))

(defn make-server
  []
  (map->HttpServer {}))
