(ns {{namespace}}.entrypoint.http.router
  (:require [bidi.ring :refer [make-handler]]
            [ring.middleware.json :refer [wrap-json-response wrap-json-params]]
            [{{namespace}}.entrypoint.http.handler.health :as health]))

(defn routes
  [server]
  (make-handler ["/" {"ping"           {:get (partial health/pong-handler)}}]))

(defn bind-routes
  "Register application router"
  [server]
  (-> (routes (:props server))
      wrap-json-response
      wrap-json-params))
