(ns {{namespace}}.config.system
  (:require [com.stuartsierra.component :as component]
            [{{namespace}}.config.http-server :as server]
            [clojure.tools.logging :refer [error]]
            [clojure.tools.logging :as log]))

(def ^:redef system
  "Holds our system."
  nil)

(defn build-system
  "Defines our system map."
  []
  (try
    (component/system-using
      (component/system-map
        :props {:server-port 8080}
        :server (server/make-server))
      {:server [:props]})
    (catch Exception e
      (log/error "Failed to build system" e))))

(defn init-system
  []
  (let [sys (build-system)]
    (alter-var-root #'system (constantly sys))))

(defn stop!
  "Stop system"
  []
  (alter-var-root #'system component/stop-system))

(defn start!
  "Start system"
  []
  (alter-var-root #'system component/start-system)
  (log/info "System started"))