;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

(ns gabrielash.libmisc.core)


(defmacro rm<*
  ([f] `(~f))
  ([f a] `(~f ~a))
  ([f a b] `(~f ~b ~a))
  ([f a b c] `(~f ~c ~a ~b))
  ([f a b c d] `(~f ~d ~a ~b ~c))
  ([f a b c d & more] 
   (let [lst# (last more)
         more (butlast more)]
     `(apply ~f [ ~lst# ~a ~b ~c ~d ~@more]))))



(defmacro rm>*
  ([f] `(~f))
  ([f a] `(~f ~a))
  ([f a b] `(~f ~b ~a))
  ([f a b c] `(~f ~b ~c ~a))
  ([f a b c d] `(~f ~b ~c ~d ~a))
  ([f a b c d & more] `(apply ~f [~b ~c ~d ~@more ~a])))



(defn r<<*
  ([f] (f))
  ([f a] (f a))
  ([f a b] (f b a))
  ([f a b c] (f c a b))
  ([f a b c d] (f d a b c))
  ([f a b c d & more] 
   (apply f (cons (last more) (concat [a b c d] (butlast more))))))



(defn r>>*
  ([f] (f))
  ([f a] (f a))
  ([f a b] (f b a))
  ([f a b c] (f b c a))
  ([f a b c d] (f b c d a))
  ([f a b c d & more]
   (apply f  (apply f (concat [b c d] more [a])))))



(defn r<*
  [f]
  (fn
    ([] (f))
    ([a] (f a))
    ([a b] (f b a))
    ([a b c] (f c a b))
    ([a b c d] (f d a b c))

    ([a b c d & more]
     (apply f (cons (last more) (concat [a b c d] (butlast more)))))))


(defn r>*
  [f]
  (fn
    ([] (f))
    ([a]  (f a))
    ([a b] (f b a))
    ([a b c] (f b c a))
    ([a b c d] (f b c d a))
    ([a b c d & more]
     (apply f (concat [b c d] more [a])))))




(def *> #'partial)

(defn *< [f & argv]
  (fn [& args]
    (apply f (concat args argv))))
