;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

(ns gabrielash.libmisc.validation 
  (:require [clojure.spec.alpha :as s]))

(defn ex-valid?
 ([spec value ] (ex-valid? spec value false))
 
 ([spec value silent?]
  (if (not (s/valid? spec value))
    (do 
      (when (= silent? false) 
         (do (println "ex-valid? explains:")
             (s/explain spec value)))
      false)
    true)))

(defn ex-valid-? [spec value] (ex-valid? spec value true))