;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

(ns gabrielash.libmisc.validation 
  (:require [clojure.spec.alpha :as s]))

(def SILENT? nil)

(defn ex-valid?
  "s/valid? that also explains on fail, unless third argh = :silent"
  [spec value & [silent?]]
  
  (if (s/valid? spec value)
    true
    (do 
      (when-not (= silent? :silent)
        (println "ex-valid? explains:")
        (s/explain spec value))
      false)))

