(defproject galdolber/api-common-client "0.1.0"
  :plugins [[lein-cljsbuild "1.1.6"]
            [lein-figwheel "0.5.11"]
            [lein-npm "0.6.2"]
            [lein-doo "0.1.7"]
            [io.nervous/cljs-nodejs-externs "0.2.0"]
            [io.nervous/lein-cljs-lambda "0.6.4"]]
  :jvm-opts ["-Xss16m" "-Xmx1024m"]
  :target-path "../target"
  :clean-targets ^{:protect false} ["../target"]
  :source-paths ["." "../shared"]
  :dependencies
  [[org.clojure/clojure "1.9.0-alpha17"]
   [org.clojure/clojurescript "1.9.671"]
   [org.clojure/core.async "0.3.443"]
   [org.clojure/data.codec "0.1.0"]
   [org.clojure/test.check "0.10.0-alpha2"]
   [com.rpl/specter "1.0.2"]
   [com.cognitect/transit-cljs "0.8.239"]
   [com.cemerick/url "0.1.1"]
   [figwheel "0.5.11"]
   [bidi "2.1.1"]
   [reagent "0.7.0" :exclusions [cljsjs/react-dom cljsjs/react-dom-server]]
   [re-frame "0.9.4"]
   [hiccups "0.3.0"]
   ;;[com.andrewmcveigh/cljs-time "0.5.0-SNAPSHOT"]
   [galdolber/cljs-time "0.5.0-SNAPSHOT2"]
   [thi.ng/color "1.2.0"]
   [honeysql "0.9.0"]
   [cljsjs/react-input-mask "0.8.0-0" :exclusions [cljsjs/react]]
   [cljsjs/facebook "v20150729-0"]
   [cljsjs/react-input-mask "0.8.0-0"]
   [cljsjs/google-maps "3.18-1"]

   ;; TODO replace with manual implementation?
   [io.nervous/glossop "0.2.1"]
   [io.nervous/cljs-lambda "0.3.4" :exclusions [funcool/promesa]]
   [funcool/promesa "1.8.1"]
   [prismatic/schema "1.1.6"]
   [galdolber/hildebrand "0.4.4-1" :exclusions [prismatic/schema]]])
