(ns api.messages)

(def main-lang (atom :en))

(def messages (atom {}))

(defn lookup-key [messages k]
  (loop [v (messages k)]
    (if (or (string? v) (nil? v)) v (recur (messages v)))))

(defn with
  ([msg] (with @main-lang msg))
  ([lang msg]
   (lookup-key (@messages (or (:page/lang lang) lang)) msg)))

(defn ex-with
  ([msg] (ex-with @main-lang msg))
  ([lang msg]
   (ex-info (with lang msg) {:code msg})))
