(ns api.cookie
  (:refer-clojure :exclude [remove set get])
  (:require [goog.net.cookies :as cookies]
            [cljs.reader :as reader]))

(defn remove [n]
  (cookies/remove n "/"))

(defn set [n v]
  (cookies/set n v -1 "/"))

(defn get [k]
  (let [v (cookies/get (name k))]
    (if (empty? v) nil v)))

#_(defn get-edn [k]
  (reader/read-string (or (cookies/get (name k)) "nil")))

#_(defn set-edn! [k v]
  (cookies/set (name k) (pr-str v)))

#_(defn remove! [k]
  (cookies/remove (name k) "/"))
