// Compiled by ClojureScript 1.9.521 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_time.internal.parse');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs_time.internal.core');
goog.require('clojure.string');
goog.require('goog.date.Date');
goog.require('goog.date.DateTime');
goog.require('goog.date.UtcDateTime');
goog.require('goog.date.Interval');
cljs_time.internal.parse.replace = (function cljs_time$internal$parse$replace(s,match,replacement){
return clojure.string.replace(((typeof s === 'string')?s:clojure.string.join.cljs$core$IFn$_invoke$arity$1(s)),match,replacement);
});
cljs_time.internal.parse.token = (function cljs_time$internal$parse$token(s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$token,s], null);
});
cljs_time.internal.parse.quoted = (function cljs_time$internal$parse$quoted(s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quoted,s], null);
});
cljs_time.internal.parse.read_while = (function cljs_time$internal$parse$read_while(pred,s){
var G__14083 = s;
var vec__14084 = G__14083;
var seq__14085 = cljs.core.seq(vec__14084);
var first__14086 = cljs.core.first(seq__14085);
var seq__14085__$1 = cljs.core.next(seq__14085);
var h = first__14086;
var more = seq__14085__$1;
var s__$1 = vec__14084;
var out = cljs.core.PersistentVector.EMPTY;
var G__14083__$1 = G__14083;
var out__$1 = out;
while(true){
var vec__14087 = G__14083__$1;
var seq__14088 = cljs.core.seq(vec__14087);
var first__14089 = cljs.core.first(seq__14088);
var seq__14088__$1 = cljs.core.next(seq__14088);
var h__$1 = first__14089;
var more__$1 = seq__14088__$1;
var s__$2 = vec__14087;
var out__$2 = out__$1;
if(cljs.core.truth_((function (){var and__7717__auto__ = h__$1;
if(cljs.core.truth_(and__7717__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(h__$1) : pred.call(null,h__$1));
} else {
return and__7717__auto__;
}
})())){
var G__14090 = more__$1;
var G__14091 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out__$2,h__$1);
G__14083__$1 = G__14090;
out__$1 = G__14091;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [out__$2,s__$2], null);
}
break;
}
});
cljs_time.internal.parse.read_token = (function cljs_time$internal$parse$read_token(ch,s){
var vec__14095 = cljs_time.internal.parse.read_while(cljs.core.PersistentHashSet.createAsIfByAssoc([ch], true),s);
var end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14095,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14095,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.token(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.str,ch,end)),s__$1], null);
});
cljs_time.internal.parse.read_quoted = (function cljs_time$internal$parse$read_quoted(_,p__14098){
var vec__14105 = p__14098;
var seq__14106 = cljs.core.seq(vec__14105);
var first__14107 = cljs.core.first(seq__14106);
var seq__14106__$1 = cljs.core.next(seq__14106);
var h = first__14107;
var more = seq__14106__$1;
var s = vec__14105;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"'")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted("'"),more], null);
} else {
var vec__14108 = cljs_time.internal.parse.read_while(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["'",null], null), null)),s);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14108,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14108,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted(q),cljs.core.rest(s__$1)], null);
}
});
cljs_time.internal.parse.read_punctuation = (function cljs_time$internal$parse$read_punctuation(ch,s){
var vec__14115 = cljs_time.internal.parse.read_while((function (p1__14111_SHARP_){
return cljs.core.not(cljs.core.re_find(/[a-zA-Z']/,p1__14111_SHARP_));
}),s);
var end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14115,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14115,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.str,ch,end)),s__$1], null);
});
cljs_time.internal.parse.read_match = (function cljs_time$internal$parse$read_match(match,ch,s){
var c = (cljs.core.count(match) - (1));
var sub = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),c))].join('');
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(match,sub)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sub,cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,c,cljs.core.count(s))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('')], null);
}
});
cljs_time.internal.parse.alpha_QMARK_ = (function cljs_time$internal$parse$alpha_QMARK_(ch){
return cljs.core.re_find(/[a-zA-Z]/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch)].join(''));
});
cljs_time.internal.parse.read = (function cljs_time$internal$parse$read(s){
var vec__14121 = s;
var seq__14122 = cljs.core.seq(vec__14121);
var first__14123 = cljs.core.first(seq__14122);
var seq__14122__$1 = cljs.core.next(seq__14122);
var h = first__14123;
var more = seq__14122__$1;
var f = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"'"))?cljs_time.internal.parse.read_quoted:(cljs.core.truth_(cljs_time.internal.parse.alpha_QMARK_(h))?cljs_time.internal.parse.read_token:cljs_time.internal.parse.read_punctuation
));
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(h,more) : f.call(null,h,more));
});
cljs_time.internal.parse.read_pattern = (function cljs_time$internal$parse$read_pattern(s){
var s__$1 = s;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
var vec__14127 = cljs_time.internal.parse.read(s__$1);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14127,(0),null);
var s__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14127,(1),null);
var out__$1 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,h);
if(cljs.core.seq(s__$2)){
var G__14130 = s__$2;
var G__14131 = out__$1;
s__$1 = G__14130;
out = G__14131;
continue;
} else {
return out__$1;
}
break;
}
});
cljs_time.internal.parse.parse_match = (function cljs_time$internal$parse$parse_match(s,key,match){
var vec__14135 = cljs_time.internal.parse.read_match(match,cljs.core.first(s),clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.rest(s)));
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14135,(0),null);
var s_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14135,(1),null);
if(cljs.core.truth_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,m], null),s_SINGLEQUOTE_], null);
} else {
return null;
}
});
cljs_time.internal.parse.parse_number = (function cljs_time$internal$parse$parse_number(var_args){
var args14139 = [];
var len__8950__auto___14147 = arguments.length;
var i__8951__auto___14148 = (0);
while(true){
if((i__8951__auto___14148 < len__8950__auto___14147)){
args14139.push((arguments[i__8951__auto___14148]));

var G__14149 = (i__8951__auto___14148 + (1));
i__8951__auto___14148 = G__14149;
continue;
} else {
}
break;
}

var G__14141 = args14139.length;
switch (G__14141) {
case 2:
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14139.length)].join('')));

}
});

cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$2 = (function (s,limit){
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3(s,(1),limit);
});

cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3 = (function (s,lower,upper){
var vec__14142 = cljs_time.internal.parse.read_while((function (p1__14138_SHARP_){
return cljs.core.re_find(/\d/,p1__14138_SHARP_);
}),s);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14142,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14142,(1),null);
if((cljs.core.count(n) >= lower)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__14145 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take.cljs$core$IFn$_invoke$arity$2(upper,n));
return parseInt(G__14145);
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(upper,n),s__$1)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__14146 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,n);
return parseInt(G__14146);
})(),s__$1], null);
}
});

cljs_time.internal.parse.parse_number.cljs$lang$maxFixedArity = 3;

cljs_time.internal.parse.parse_period = (function cljs_time$internal$parse$parse_period(var_args){
var args14151 = [];
var len__8950__auto___14157 = arguments.length;
var i__8951__auto___14158 = (0);
while(true){
if((i__8951__auto___14158 < len__8950__auto___14157)){
args14151.push((arguments[i__8951__auto___14158]));

var G__14159 = (i__8951__auto___14158 + (1));
i__8951__auto___14158 = G__14159;
continue;
} else {
}
break;
}

var G__14153 = args14151.length;
switch (G__14153) {
case 3:
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14151.length)].join('')));

}
});

cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$3 = (function (s,period,limit){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,period,(1),limit);
});

cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4 = (function (s,period,lower,upper){
var vec__14154 = cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3(s,lower,upper);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14154,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14154,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [period,n], null),s__$1], null);
});

cljs_time.internal.parse.parse_period.cljs$lang$maxFixedArity = 4;

cljs_time.internal.parse.parse_year = (function cljs_time$internal$parse$parse_year(var_args){
var args14161 = [];
var len__8950__auto___14164 = arguments.length;
var i__8951__auto___14165 = (0);
while(true){
if((i__8951__auto___14165 < len__8950__auto___14164)){
args14161.push((arguments[i__8951__auto___14165]));

var G__14166 = (i__8951__auto___14165 + (1));
i__8951__auto___14165 = G__14166;
continue;
} else {
}
break;
}

var G__14163 = args14161.length;
switch (G__14163) {
case 1:
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14161.length)].join('')));

}
});

cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$years,lower,upper);
});
});

cljs_time.internal.parse.parse_year.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_weekyear = (function cljs_time$internal$parse$parse_weekyear(var_args){
var args14168 = [];
var len__8950__auto___14171 = arguments.length;
var i__8951__auto___14172 = (0);
while(true){
if((i__8951__auto___14172 < len__8950__auto___14171)){
args14168.push((arguments[i__8951__auto___14172]));

var G__14173 = (i__8951__auto___14172 + (1));
i__8951__auto___14172 = G__14173;
continue;
} else {
}
break;
}

var G__14170 = args14168.length;
switch (G__14170) {
case 1:
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14168.length)].join('')));

}
});

cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$weekyear,lower,upper);
});
});

cljs_time.internal.parse.parse_weekyear.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_weekyear_week = (function cljs_time$internal$parse$parse_weekyear_week(var_args){
var args14175 = [];
var len__8950__auto___14178 = arguments.length;
var i__8951__auto___14179 = (0);
while(true){
if((i__8951__auto___14179 < len__8950__auto___14178)){
args14175.push((arguments[i__8951__auto___14179]));

var G__14180 = (i__8951__auto___14179 + (1));
i__8951__auto___14179 = G__14180;
continue;
} else {
}
break;
}

var G__14177 = args14175.length;
switch (G__14177) {
case 1:
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14175.length)].join('')));

}
});

cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$weekyear_DASH_week,lower,upper);
});
});

cljs_time.internal.parse.parse_weekyear_week.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_month = (function cljs_time$internal$parse$parse_month(var_args){
var args14182 = [];
var len__8950__auto___14185 = arguments.length;
var i__8951__auto___14186 = (0);
while(true){
if((i__8951__auto___14186 < len__8950__auto___14185)){
args14182.push((arguments[i__8951__auto___14186]));

var G__14187 = (i__8951__auto___14186 + (1));
i__8951__auto___14186 = G__14187;
continue;
} else {
}
break;
}

var G__14184 = args14182.length;
switch (G__14184) {
case 1:
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14182.length)].join('')));

}
});

cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$months,lower,upper);
});
});

cljs_time.internal.parse.parse_month.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_day = (function cljs_time$internal$parse$parse_day(var_args){
var args14189 = [];
var len__8950__auto___14192 = arguments.length;
var i__8951__auto___14193 = (0);
while(true){
if((i__8951__auto___14193 < len__8950__auto___14192)){
args14189.push((arguments[i__8951__auto___14193]));

var G__14194 = (i__8951__auto___14193 + (1));
i__8951__auto___14193 = G__14194;
continue;
} else {
}
break;
}

var G__14191 = args14189.length;
switch (G__14191) {
case 1:
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14189.length)].join('')));

}
});

cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$days,lower,upper);
});
});

cljs_time.internal.parse.parse_day.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_hours = (function cljs_time$internal$parse$parse_hours(var_args){
var args14196 = [];
var len__8950__auto___14199 = arguments.length;
var i__8951__auto___14200 = (0);
while(true){
if((i__8951__auto___14200 < len__8950__auto___14199)){
args14196.push((arguments[i__8951__auto___14200]));

var G__14201 = (i__8951__auto___14200 + (1));
i__8951__auto___14200 = G__14201;
continue;
} else {
}
break;
}

var G__14198 = args14196.length;
switch (G__14198) {
case 1:
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14196.length)].join('')));

}
});

cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$hours,lower,upper);
});
});

cljs_time.internal.parse.parse_hours.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_HOURS = (function cljs_time$internal$parse$parse_HOURS(var_args){
var args14203 = [];
var len__8950__auto___14206 = arguments.length;
var i__8951__auto___14207 = (0);
while(true){
if((i__8951__auto___14207 < len__8950__auto___14206)){
args14203.push((arguments[i__8951__auto___14207]));

var G__14208 = (i__8951__auto___14207 + (1));
i__8951__auto___14207 = G__14208;
continue;
} else {
}
break;
}

var G__14205 = args14203.length;
switch (G__14205) {
case 1:
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14203.length)].join('')));

}
});

cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$HOURS,lower,upper);
});
});

cljs_time.internal.parse.parse_HOURS.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_minutes = (function cljs_time$internal$parse$parse_minutes(var_args){
var args14210 = [];
var len__8950__auto___14213 = arguments.length;
var i__8951__auto___14214 = (0);
while(true){
if((i__8951__auto___14214 < len__8950__auto___14213)){
args14210.push((arguments[i__8951__auto___14214]));

var G__14215 = (i__8951__auto___14214 + (1));
i__8951__auto___14214 = G__14215;
continue;
} else {
}
break;
}

var G__14212 = args14210.length;
switch (G__14212) {
case 1:
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14210.length)].join('')));

}
});

cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$minutes,lower,upper);
});
});

cljs_time.internal.parse.parse_minutes.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_seconds = (function cljs_time$internal$parse$parse_seconds(var_args){
var args14217 = [];
var len__8950__auto___14220 = arguments.length;
var i__8951__auto___14221 = (0);
while(true){
if((i__8951__auto___14221 < len__8950__auto___14220)){
args14217.push((arguments[i__8951__auto___14221]));

var G__14222 = (i__8951__auto___14221 + (1));
i__8951__auto___14221 = G__14222;
continue;
} else {
}
break;
}

var G__14219 = args14217.length;
switch (G__14219) {
case 1:
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14217.length)].join('')));

}
});

cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$seconds,lower,upper);
});
});

cljs_time.internal.parse.parse_seconds.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_millis = (function cljs_time$internal$parse$parse_millis(var_args){
var args14224 = [];
var len__8950__auto___14227 = arguments.length;
var i__8951__auto___14228 = (0);
while(true){
if((i__8951__auto___14228 < len__8950__auto___14227)){
args14224.push((arguments[i__8951__auto___14228]));

var G__14229 = (i__8951__auto___14228 + (1));
i__8951__auto___14228 = G__14229;
continue;
} else {
}
break;
}

var G__14226 = args14224.length;
switch (G__14226) {
case 1:
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14224.length)].join('')));

}
});

cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$millis,lower,upper);
});
});

cljs_time.internal.parse.parse_millis.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.timezone_adj = (function cljs_time$internal$parse$timezone_adj(sign,hh,mm){
var hh__$1 = parseInt(hh,(10));
var mm__$1 = parseInt(mm,(10));
var mins = ((hh__$1 * (60)) + mm__$1);
var adj_fn = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sign,"+"))?cljs.core._:cljs.core._PLUS_);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,(new goog.date.Interval(goog.date.Interval.MINUTES,(adj_fn.cljs$core$IFn$_invoke$arity$1 ? adj_fn.cljs$core$IFn$_invoke$arity$1(mins) : adj_fn.call(null,mins))))], null);
});
cljs_time.internal.parse.parse_timezone = (function cljs_time$internal$parse$parse_timezone(fmt){
return (function (s){
var vec__14248 = s;
var seq__14249 = cljs.core.seq(vec__14248);
var first__14250 = cljs.core.first(seq__14249);
var seq__14249__$1 = cljs.core.next(seq__14249);
var h = first__14250;
var more = seq__14249__$1;
var err = ((function (vec__14248,seq__14249,first__14250,seq__14249__$1,h,more){
return (function (){
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid timezone format: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error], null));
});})(vec__14248,seq__14249,first__14250,seq__14249__$1,h,more))
;
var dddd = ((function (vec__14248,seq__14249,first__14250,seq__14249__$1,h,more,err){
return (function (p1__14231_SHARP_){
var tz_QMARK_ = clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.take.cljs$core$IFn$_invoke$arity$2((4),more));
var temp__6738__auto__ = cljs.core.re_find(/^(\d{2})(\d{2})/,tz_QMARK_);
if(cljs.core.truth_(temp__6738__auto__)){
var vec__14251 = temp__6738__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14251,(0),null);
var hh = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14251,(1),null);
var mm = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14251,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.timezone_adj(p1__14231_SHARP_,hh,mm),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((4),more)], null);
} else {
return null;
}
});})(vec__14248,seq__14249,first__14250,seq__14249__$1,h,more,err))
;
var long$ = ((function (vec__14248,seq__14249,first__14250,seq__14249__$1,h,more,err,dddd){
return (function (p1__14232_SHARP_){
var tz_QMARK_ = clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.take.cljs$core$IFn$_invoke$arity$2((5),more));
var temp__6738__auto__ = cljs.core.re_find(/^(\d{2}):(\d{2})/,tz_QMARK_);
if(cljs.core.truth_(temp__6738__auto__)){
var vec__14254 = temp__6738__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14254,(0),null);
var hh = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14254,(1),null);
var mm = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14254,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.timezone_adj(p1__14232_SHARP_,hh,mm),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((5),more)], null);
} else {
return null;
}
});})(vec__14248,seq__14249,first__14250,seq__14249__$1,h,more,err,dddd))
;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["+",null,"-",null], null), null).call(null,h))){
var G__14257 = (((fmt instanceof cljs.core.Keyword))?fmt.fqn:null);
switch (G__14257) {
case "dddd":
var or__7729__auto__ = dddd(h);
if(cljs.core.truth_(or__7729__auto__)){
return or__7729__auto__;
} else {
var or__7729__auto____$1 = long$(h);
if(cljs.core.truth_(or__7729__auto____$1)){
return or__7729__auto____$1;
} else {
throw err();
}
}

break;
case "long":
var or__7729__auto__ = dddd(h);
if(cljs.core.truth_(or__7729__auto__)){
return or__7729__auto__;
} else {
var or__7729__auto____$1 = long$(h);
if(cljs.core.truth_(or__7729__auto____$1)){
return or__7729__auto____$1;
} else {
throw err();
}
}

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join('')));

}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"Z")){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,cljs_time.internal.parse.timezone_adj(cljs.core._PLUS_,"0","0")], null)], null);
} else {
var G__14258 = (((fmt instanceof cljs.core.Keyword))?fmt.fqn:null);
switch (G__14258) {
case "abbr":
var tz_QMARK_ = cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),s);
var vec__14259 = cljs_time.internal.parse.read_while(((function (tz_QMARK_,G__14258,vec__14248,seq__14249,first__14250,seq__14249__$1,h,more,err,dddd,long$){
return (function (p1__14233_SHARP_){
return cljs.core.re_find(/[A-Z]/,p1__14233_SHARP_);
});})(tz_QMARK_,G__14258,vec__14248,seq__14249,first__14250,seq__14249__$1,h,more,err,dddd,long$))
,tz_QMARK_);
var tz = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14259,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14259,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(tz),(3))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,clojure.string.join.cljs$core$IFn$_invoke$arity$1(tz)], null),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((3),s)], null);
} else {
throw err();
}

break;
case "full":
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot parse long form timezone:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error], null));

break;
default:
throw err();

}

}
}
});
});
cljs_time.internal.parse.parse_meridiem = (function cljs_time$internal$parse$parse_meridiem(){
return (function (s){
var vec__14273 = cljs.core.split_at((2),s);
var vec__14276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14273,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14276,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14276,(1),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14273,(1),null);
var meridiem = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(m),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('');
var vec__14279 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["AM",null,"am",null,"pm",null,"PM",null], null), null).call(null,meridiem))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [meridiem,s__$1], null):(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["a",null,"p",null], null), null).call(null,m))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, ["a","am","p","pm"], null).call(null,m),cljs.core.cons(n,s__$1)], null):(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["A",null,"P",null], null), null).call(null,m))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, ["A","am","P","pm"], null).call(null,m),cljs.core.cons(n,s__$1)], null):null)));
var meridiem__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14279,(0),null);
var s__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14279,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meridiem,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(meridiem__$1)], null),clojure.string.join.cljs$core$IFn$_invoke$arity$1(s__$2)], null);
});
});
cljs_time.internal.parse.parse_period_name = (function cljs_time$internal$parse$parse_period_name(s,period,periods,short_QMARK_){
var periods__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(periods,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14282_SHARP_){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(p1__14282_SHARP_,(0),(3));
}),periods));
var vec__14287 = cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,s),cljs.core.second),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (periods__$1){
return (function (p1__14283_SHARP_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14283_SHARP_,cljs_time.internal.parse.replace(s,cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__14283_SHARP_)].join('')),"")], null);
});})(periods__$1))
,periods__$1)));
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14287,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14287,(1),null);
if(cljs.core.truth_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [period,cljs.core.mod(cljs_time.internal.core.index_of(periods__$1,m),(12))], null),s__$1], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Could not parse "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(period)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" name")].join(''),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$sub_DASH_type,cljs.core.cst$kw$period_DASH_match_DASH_erroro,cljs.core.cst$kw$period,period,cljs.core.cst$kw$in,s__$1], null));
}
});
cljs_time.internal.parse.parse_month_name = (function cljs_time$internal$parse$parse_month_name(short_QMARK_){
return (function (s){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs_time.internal.parse.parse_period_name(s,cljs.core.cst$kw$months,cljs_time.internal.core.months,short_QMARK_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.inc);
});
});
cljs_time.internal.parse.parse_day_name = (function cljs_time$internal$parse$parse_day_name(short_QMARK_){
return (function (s){
return cljs_time.internal.parse.parse_period_name(s,cljs.core.cst$kw$days,cljs_time.internal.core.days,short_QMARK_);
});
});
cljs_time.internal.parse.parse_quoted = (function cljs_time$internal$parse$parse_quoted(quoted){
return (function (s){
var s_SINGLEQUOTE_ = cljs_time.internal.parse.replace(s,cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(quoted)].join('')),"");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s,s_SINGLEQUOTE_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Quoted text not found",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$where,cljs.core.cst$kw$parse_DASH_quoted], null));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quoted,quoted], null),s_SINGLEQUOTE_], null);
}
});
});
cljs_time.internal.parse.parse_ordinal_suffix = (function cljs_time$internal$parse$parse_ordinal_suffix(){
return (function (s){
var or__7729__auto__ = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"st");
if(cljs.core.truth_(or__7729__auto__)){
return or__7729__auto__;
} else {
var or__7729__auto____$1 = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"nd");
if(cljs.core.truth_(or__7729__auto____$1)){
return or__7729__auto____$1;
} else {
var or__7729__auto____$2 = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"rd");
if(cljs.core.truth_(or__7729__auto____$2)){
return or__7729__auto____$2;
} else {
return cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"th");
}
}
}
});
});
cljs_time.internal.parse.lookup = (function cljs_time$internal$parse$lookup(p__14290){
var vec__14295 = p__14290;
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14295,(0),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14295,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.cst$kw$token)){
var G__14298 = pattern;
switch (G__14298) {
case "S":
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "SSS":
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((3),(3));

break;
case "s":
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "ss":
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "m":
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "mm":
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "h":
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "hh":
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "H":
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "HH":
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "d":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "dd":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "D":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),(3));

break;
case "DD":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((2),(3));

break;
case "DDD":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((3),(3));

break;
case "M":
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "MM":
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "MMM":
return cljs_time.internal.parse.parse_month_name(true);

break;
case "MMMM":
return cljs_time.internal.parse.parse_month_name(false);

break;
case "y":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "yy":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "yyyy":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "Y":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "YY":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "YYYY":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "x":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "xx":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "xxxx":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "w":
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "ww":
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "E":
return cljs_time.internal.parse.parse_day_name(true);

break;
case "EEE":
return cljs_time.internal.parse.parse_day_name(true);

break;
case "EEEE":
return cljs_time.internal.parse.parse_day_name(false);

break;
case "a":
return cljs_time.internal.parse.parse_meridiem();

break;
case "A":
return cljs_time.internal.parse.parse_meridiem();

break;
case "Z":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$dddd);

break;
case "ZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$long);

break;
case "ZZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "ZZZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "z":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zzz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zzzz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$full);

break;
case "o":
return cljs_time.internal.parse.parse_ordinal_suffix();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Illegal pattern component: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(pattern)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$illegal_DASH_pattern], null));

}
} else {
return cljs_time.internal.parse.parse_quoted(pattern);
}
});
cljs_time.internal.parse.parse = (function cljs_time$internal$parse$parse(pattern,value){
var s = value;
var G__14316 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_time.internal.parse.lookup,cljs_time.internal.parse.read_pattern(pattern));
var vec__14317 = G__14316;
var seq__14318 = cljs.core.seq(vec__14317);
var first__14319 = cljs.core.first(seq__14318);
var seq__14318__$1 = cljs.core.next(seq__14318);
var parser = first__14319;
var more = seq__14318__$1;
var out = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
var G__14316__$1 = G__14316;
var out__$1 = out;
while(true){
var s__$2 = s__$1;
var vec__14320 = G__14316__$1;
var seq__14321 = cljs.core.seq(vec__14320);
var first__14322 = cljs.core.first(seq__14321);
var seq__14321__$1 = cljs.core.next(seq__14321);
var parser__$1 = first__14322;
var more__$1 = seq__14321__$1;
var out__$2 = out__$1;
var err = ((function (s__$1,G__14316__$1,out__$1,s__$2,vec__14320,seq__14321,first__14322,seq__14321__$1,parser__$1,more__$1,out__$2,s,G__14316,vec__14317,seq__14318,first__14319,seq__14318__$1,parser,more,out){
return (function (){
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid format: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is malformed at "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([s__$2], 0)))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$sub_DASH_type,cljs.core.cst$kw$invalid_DASH_format], null));
});})(s__$1,G__14316__$1,out__$1,s__$2,vec__14320,seq__14321,first__14322,seq__14321__$1,parser__$1,more__$1,out__$2,s,G__14316,vec__14317,seq__14318,first__14319,seq__14318__$1,parser,more,out))
;
if(cljs.core.seq(s__$2)){
if((parser__$1 == null)){
throw err();
} else {
var vec__14323 = (parser__$1.cljs$core$IFn$_invoke$arity$1 ? parser__$1.cljs$core$IFn$_invoke$arity$1(s__$2) : parser__$1.call(null,s__$2));
var value__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14323,(0),null);
var s__$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14323,(1),null);
var G__14326 = s__$3;
var G__14327 = more__$1;
var G__14328 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out__$2,value__$1);
s__$1 = G__14326;
G__14316__$1 = G__14327;
out__$1 = G__14328;
continue;
}
} else {
if(cljs.core.truth_(parser__$1)){
throw err();
} else {
return out__$2;
}
}
break;
}
});
cljs_time.internal.parse.compile = (function cljs_time$internal$parse$compile(class$,p__14329,values){
var map__14336 = p__14329;
var map__14336__$1 = ((((!((map__14336 == null)))?((((map__14336.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14336.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14336):map__14336);
var fmt = map__14336__$1;
var default_year = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14336__$1,cljs.core.cst$kw$default_DASH_year);
var map__14338 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$quoted,null], null), null),cljs.core.first),values));
var map__14338__$1 = ((((!((map__14338 == null)))?((((map__14338.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14338.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14338):map__14338);
var date_map = map__14338__$1;
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$minutes);
var HOURS = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$HOURS);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$millis);
var timezone = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$timezone);
var meridiem = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$meridiem);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$months);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$days);
var seconds = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$seconds);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$hours);
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14338__$1,cljs.core.cst$kw$years);
var years__$1 = (function (){var or__7729__auto__ = years;
if(cljs.core.truth_(or__7729__auto__)){
return or__7729__auto__;
} else {
var or__7729__auto____$1 = default_year;
if(cljs.core.truth_(or__7729__auto____$1)){
return or__7729__auto____$1;
} else {
return (0);
}
}
})();
var months__$1 = (cljs.core.truth_(months)?(months - (1)):null);
var hours__$1 = (cljs.core.truth_(meridiem)?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$PM,null,cljs.core.cst$kw$pm,null], null), null).call(null,meridiem))?(function (){var hours__$1 = (hours + (12));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hours__$1,(24))){
return (12);
} else {
return hours__$1;
}
})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hours,(12)))?(0):hours)):HOURS);
var date_map__$1 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(date_map,cljs.core.cst$kw$hours,hours__$1),cljs.core.cst$kw$HOURS,cljs.core.array_seq([cljs.core.cst$kw$meridiem], 0));
var timezone__$1 = (((timezone instanceof goog.date.Interval))?timezone:(new goog.date.Interval(goog.date.Interval.SECONDS,(0))));
cljs_time.internal.core.valid_date_QMARK_(date_map__$1);

var G__14340 = (function (){var G__14341 = (((class$ instanceof cljs.core.Keyword))?class$.fqn:null);
switch (G__14341) {
case "goog.date.Date":
return (new goog.date.Date(years__$1,months__$1,days));

break;
case "goog.date.DateTime":
return (new goog.date.DateTime(years__$1,months__$1,days,hours__$1,minutes,seconds,millis));

break;
case "goog.date.UtcDateTime":
return (new goog.date.UtcDateTime(years__$1,months__$1,days,hours__$1,minutes,seconds,millis));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)].join('')));

}
})();
G__14340.add(timezone__$1);

return G__14340;
});
