/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AReference;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.Map;

public abstract class ARef
extends AReference
implements IRef {
    protected volatile IFn validator = null;
    private volatile IPersistentMap watches = PersistentHashMap.EMPTY;

    public ARef() {
    }

    public ARef(IPersistentMap meta) {
        super(meta);
    }

    void validate(IFn vf, Object val) {
        try {
            if (vf != null && !RT.booleanCast(vf.invoke(val))) {
                throw new IllegalStateException("Invalid reference state");
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid reference state", e);
        }
    }

    void validate(Object val) {
        this.validate(this.validator, val);
    }

    @Override
    public void setValidator(IFn vf) {
        try {
            this.validate(vf, this.deref());
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
        this.validator = vf;
    }

    @Override
    public IFn getValidator() {
        return this.validator;
    }

    @Override
    public IPersistentMap getWatches() {
        return this.watches;
    }

    @Override
    public synchronized IRef addWatch(Object key, IFn callback) {
        this.watches = this.watches.assoc(key, callback);
        return this;
    }

    @Override
    public synchronized IRef removeWatch(Object key) {
        try {
            this.watches = this.watches.without(key);
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
        return this;
    }

    public void notifyWatches(Object oldval, Object newval) {
        IPersistentMap ws = this.watches;
        if (ws.count() > 0) {
            ISeq s = ws.seq();
            while (s != null) {
                Map.Entry e = (Map.Entry)s.first();
                IFn fn = (IFn)e.getValue();
                try {
                    if (fn != null) {
                        fn.invoke(e.getKey(), this, oldval, newval);
                    }
                }
                catch (Exception e1) {
                    throw Util.sneakyThrow(e1);
                }
                s = s.next();
            }
        }
    }
}

