/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Ref;
import clojure.lang.Util;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class TransactionalHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    final Ref[] bins;

    IPersistentMap mapAt(int bin) {
        return (IPersistentMap)this.bins[bin].deref();
    }

    final int binFor(Object k) {
        int h = k.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h % this.bins.length;
    }

    Map.Entry entryAt(Object k) {
        return this.mapAt(this.binFor(k)).entryAt(k);
    }

    public TransactionalHashMap() {
        this(421);
    }

    public TransactionalHashMap(int nBins) {
        this.bins = new Ref[nBins];
        int i = 0;
        while (i < nBins) {
            this.bins[i] = new Ref((Object)PersistentHashMap.EMPTY);
            ++i;
        }
    }

    public TransactionalHashMap(Map<? extends K, ? extends V> m) {
        this(m.size());
        this.putAll(m);
    }

    @Override
    public int size() {
        int n = 0;
        int i = 0;
        while (i < this.bins.length) {
            n += this.mapAt(i).count();
            ++i;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.entryAt(k) != null;
    }

    @Override
    public V get(Object k) {
        Map.Entry e = this.entryAt(k);
        if (e != null) {
            return e.getValue();
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        Object ret = map.valAt(k);
        r.set(map.assoc(k, v));
        return (V)ret;
    }

    @Override
    public V remove(Object k) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        Object ret = map.valAt(k);
        try {
            r.set(map.without(k));
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
        return (V)ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.bins.length) {
            Ref r = this.bins[i];
            IPersistentMap map = (IPersistentMap)r.deref();
            if (map.count() > 0) {
                r.set(PersistentHashMap.EMPTY);
            }
            ++i;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final ArrayList entries = new ArrayList(this.bins.length);
        int i = 0;
        while (i < this.bins.length) {
            IPersistentMap map = this.mapAt(i);
            if (map.count() > 0) {
                entries.addAll((Collection)((Object)RT.seq(map)));
            }
            ++i;
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator iterator() {
                return Collections.unmodifiableList(entries).iterator();
            }

            @Override
            public int size() {
                return entries.size();
            }
        };
    }

    @Override
    public V putIfAbsent(K k, V v) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        IMapEntry e = map.entryAt(k);
        if (e == null) {
            r.set(map.assoc(k, v));
            return null;
        }
        return e.getValue();
    }

    @Override
    public boolean remove(Object k, Object v) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        IMapEntry e = map.entryAt(k);
        if (e != null && e.getValue().equals(v)) {
            try {
                r.set(map.without(k));
            }
            catch (Exception ex) {
                throw Util.sneakyThrow(ex);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K k, V oldv, V newv) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        IMapEntry e = map.entryAt(k);
        if (e != null && e.getValue().equals(oldv)) {
            r.set(map.assoc(k, newv));
            return true;
        }
        return false;
    }

    @Override
    public V replace(K k, V v) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        IMapEntry e = map.entryAt(k);
        if (e != null) {
            r.set(map.assoc(k, v));
            return e.getValue();
        }
        return null;
    }
}

