/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.Keyword;
import clojure.lang.Namespace;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;
import java.util.IdentityHashMap;

public class CompilerClean {
    static final Symbol DEF = Symbol.intern("def");
    static final Symbol LOOP = Symbol.intern("loop*");
    static final Symbol RECUR = Symbol.intern("recur");
    static final Symbol IF = Symbol.intern("if");
    static final Symbol LET = Symbol.intern("let*");
    static final Symbol LETFN = Symbol.intern("letfn*");
    static final Symbol DO = Symbol.intern("do");
    static final Symbol FN = Symbol.intern("fn*");
    static final Symbol FNONCE = (Symbol)Symbol.intern("fn*").withMeta(RT.map(Keyword.intern(null, "once"), RT.T));
    static final Symbol QUOTE = Symbol.intern("quote");
    static final Symbol THE_VAR = Symbol.intern("var");
    static final Symbol DOT = Symbol.intern(".");
    static final Symbol ASSIGN = Symbol.intern("set!");
    static final Symbol TRY = Symbol.intern("try");
    static final Symbol CATCH = Symbol.intern("catch");
    static final Symbol FINALLY = Symbol.intern("finally");
    static final Symbol THROW = Symbol.intern("throw");
    static final Symbol MONITOR_ENTER = Symbol.intern("monitor-enter");
    static final Symbol MONITOR_EXIT = Symbol.intern("monitor-exit");
    static final Symbol IMPORT = Symbol.intern("clojure.core", "import*");
    static final Symbol DEFTYPE = Symbol.intern("deftype*");
    static final Symbol CASE = Symbol.intern("case*");
    static final Symbol CLASS = Symbol.intern("Class");
    static final Symbol NEW = Symbol.intern("new");
    static final Symbol THIS = Symbol.intern("this");
    static final Symbol REIFY = Symbol.intern("reify*");
    static final Symbol LIST = Symbol.intern("clojure.core", "list");
    static final Symbol HASHMAP = Symbol.intern("clojure.core", "hash-map");
    static final Symbol VECTOR = Symbol.intern("clojure.core", "vector");
    static final Symbol IDENTITY = Symbol.intern("clojure.core", "identity");
    static final Symbol _AMP_ = Symbol.intern("&");
    static final Symbol ISEQ = Symbol.intern("clojure.lang.ISeq");
    static final Keyword inlineKey = Keyword.intern(null, "inline");
    static final Keyword inlineAritiesKey = Keyword.intern(null, "inline-arities");
    static final Keyword staticKey = Keyword.intern(null, "static");
    static final Keyword arglistsKey = Keyword.intern(null, "arglists");
    static final Symbol INVOKE_STATIC = Symbol.intern("invokeStatic");
    static final Keyword volatileKey = Keyword.intern(null, "volatile");
    static final Keyword implementsKey = Keyword.intern(null, "implements");
    static final String COMPILE_STUB_PREFIX = "compile__stub";
    static final Keyword protocolKey = Keyword.intern(null, "protocol");
    static final Keyword onKey = Keyword.intern(null, "on");
    static Keyword dynamicKey = Keyword.intern("dynamic");
    static final Symbol NS = Symbol.intern("ns");
    static final Symbol IN_NS = Symbol.intern("in-ns");
    public static final Var LINE_BEFORE = Var.create(0).setDynamic();
    public static final Var COLUMN_BEFORE = Var.create(0).setDynamic();
    public static final Var LINE_AFTER = Var.create(0).setDynamic();
    public static final Var COLUMN_AFTER = Var.create(0).setDynamic();
    public static final Var NEXT_LOCAL_NUM = Var.create(0).setDynamic();
    public static final Var RET_LOCAL_NUM = Var.create().setDynamic();
    public static final Var COMPILE_STUB_SYM = Var.create(null).setDynamic();
    public static final Var COMPILE_STUB_CLASS = Var.create(null).setDynamic();
    public static final Var LOCAL_ENV = Var.create(null).setDynamic();
    public static final Var LOOP_LOCALS = Var.create().setDynamic();
    public static final Var LOOP_LABEL = Var.create().setDynamic();
    public static final Var CONSTANTS = Var.create().setDynamic();
    public static final Var CONSTANT_IDS = Var.create().setDynamic();
    public static final Var KEYWORD_CALLSITES = Var.create().setDynamic();
    public static final Var PROTOCOL_CALLSITES = Var.create().setDynamic();
    public static final Var VAR_CALLSITES = Var.create().setDynamic();
    public static final Var KEYWORDS = Var.create().setDynamic();
    public static final Var VARS = Var.create().setDynamic();
    public static final Var METHOD = Var.create(null).setDynamic();
    public static final Var IN_CATCH_FINALLY = Var.create(null).setDynamic();
    public static final Var NO_RECUR = Var.create(null).setDynamic();
    public static final Var LOADER = Var.create().setDynamic();
    public static final Var SOURCE = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*source-path*"), "NO_SOURCE_FILE").setDynamic();
    public static final Var SOURCE_PATH = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*file*"), "NO_SOURCE_PATH").setDynamic();
    public static final Var COMPILE_PATH = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compile-path*"), null).setDynamic();
    public static final Var COMPILE_FILES = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compile-files*"), Boolean.FALSE).setDynamic();
    public static final Var INSTANCE = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("instance?"));
    public static final Var ADD_ANNOTATIONS = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("add-annotations"));
    public static final Keyword disableLocalsClearingKey = Keyword.intern("disable-locals-clearing");
    public static final Keyword elideMetaKey = Keyword.intern("elide-meta");
    public static final Var COMPILER_OPTIONS = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compiler-options*"), null).setDynamic();
    public static final IPersistentSet specials = PersistentHashSet.create(DEF, LOOP, RECUR, IF, CASE, LET, LETFN, DO, FN, QUOTE, THE_VAR, IMPORT, DOT, ASSIGN, DEFTYPE, REIFY, TRY, THROW, MONITOR_ENTER, MONITOR_EXIT, CATCH, FINALLY, NEW, _AMP_);

    public static Object getCompilerOption(Keyword k) {
        return RT.get(COMPILER_OPTIONS.deref(), k);
    }

    static Object resolve(Symbol sym, boolean allowPrivate) {
        return CompilerClean.resolveIn(CompilerClean.currentNS(), sym, allowPrivate);
    }

    static Object resolve(Symbol sym) {
        return CompilerClean.resolveIn(CompilerClean.currentNS(), sym, false);
    }

    static Namespace namespaceFor(Symbol sym) {
        return CompilerClean.namespaceFor(CompilerClean.currentNS(), sym);
    }

    static Namespace namespaceFor(Namespace inns, Symbol sym) {
        Symbol nsSym = Symbol.intern(sym.ns);
        Namespace ns = inns.lookupAlias(nsSym);
        if (ns == null) {
            ns = Namespace.find(nsSym);
        }
        return ns;
    }

    public static Object resolveIn(Namespace n, Symbol sym, boolean allowPrivate) {
        if (sym.ns != null) {
            Namespace ns = CompilerClean.namespaceFor(n, sym);
            if (ns == null) {
                throw Util.runtimeException("No such namespace: " + sym.ns);
            }
            Var v = ns.findInternedVar(Symbol.intern(sym.name));
            if (v == null) {
                throw Util.runtimeException("No such var: " + sym);
            }
            if (v.ns != CompilerClean.currentNS() && !v.isPublic() && !allowPrivate) {
                throw new IllegalStateException("var: " + sym + " is not public");
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        if (Util.equals(sym, COMPILE_STUB_SYM.get())) {
            return COMPILE_STUB_CLASS.get();
        }
        Object o = n.getMapping(sym);
        if (o == null) {
            if (RT.booleanCast(RT.ALLOW_UNRESOLVED_VARS.deref())) {
                return sym;
            }
            throw Util.runtimeException("Unable to resolve symbol: " + sym + " in this context");
        }
        return o;
    }

    public static Object maybeResolveIn(Namespace n, Symbol sym) {
        if (sym.ns != null) {
            Namespace ns = CompilerClean.namespaceFor(n, sym);
            if (ns == null) {
                return null;
            }
            Var v = ns.findInternedVar(Symbol.intern(sym.name));
            if (v == null) {
                return null;
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 && !sym.name.endsWith(".") || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        Object o = n.getMapping(sym);
        return o;
    }

    static Var lookupVar(Symbol sym, boolean internNew, boolean registerMacro) {
        Var var = null;
        if (sym.ns != null) {
            Namespace ns = CompilerClean.namespaceFor(sym);
            if (ns == null) {
                return null;
            }
            Symbol name = Symbol.intern(sym.name);
            var = internNew && ns == CompilerClean.currentNS() ? CompilerClean.currentNS().intern(name) : ns.findInternedVar(name);
        } else if (sym.equals(NS)) {
            var = RT.NS_VAR;
        } else if (sym.equals(IN_NS)) {
            var = RT.IN_NS_VAR;
        } else {
            Object o = CompilerClean.currentNS().getMapping(sym);
            if (o == null) {
                if (internNew) {
                    var = CompilerClean.currentNS().intern(Symbol.intern(sym.name));
                }
            } else if (o instanceof Var) {
                var = (Var)o;
            } else {
                throw Util.runtimeException("Expecting var, but " + sym + " is mapped to " + o);
            }
        }
        if (var != null && (!var.isMacro() || registerMacro)) {
            CompilerClean.registerVar(var);
        }
        return var;
    }

    static Var lookupVar(Symbol sym, boolean internNew) {
        return CompilerClean.lookupVar(sym, internNew, true);
    }

    private static int registerConstant(Object o) {
        if (!CONSTANTS.isBound()) {
            return -1;
        }
        PersistentVector v = (PersistentVector)CONSTANTS.deref();
        IdentityHashMap ids = (IdentityHashMap)CONSTANT_IDS.deref();
        Integer i = (Integer)ids.get(o);
        if (i != null) {
            return i;
        }
        CONSTANTS.set(RT.conj(v, o));
        ids.put(o, v.count());
        return v.count();
    }

    private static void registerVar(Var var) {
        if (!VARS.isBound()) {
            return;
        }
        IPersistentMap varsMap = (IPersistentMap)VARS.deref();
        Object id = RT.get(varsMap, var);
        if (id == null) {
            VARS.set(RT.assoc(varsMap, var, CompilerClean.registerConstant(var)));
        }
    }

    static Namespace currentNS() {
        return (Namespace)RT.CURRENT_NS.deref();
    }

    static boolean isSpecial(Object sym) {
        return specials.contains(sym);
    }

    static Symbol resolveSymbol(Symbol sym) {
        if (sym.name.indexOf(46) > 0) {
            return sym;
        }
        if (sym.ns != null) {
            Namespace ns = CompilerClean.namespaceFor(sym);
            if (ns == null || ns.name.name == sym.ns) {
                return sym;
            }
            return Symbol.intern(ns.name.name, sym.name);
        }
        Object o = CompilerClean.currentNS().getMapping(sym);
        if (o == null) {
            return Symbol.intern(CompilerClean.currentNS().name.name, sym.name);
        }
        if (o instanceof Class) {
            return Symbol.intern(null, ((Class)o).getName());
        }
        if (o instanceof Var) {
            Var v = (Var)o;
            return Symbol.intern(v.ns.name.name, v.sym.name);
        }
        return null;
    }

    public static boolean namesStaticMember(Symbol sym) {
        return sym.ns != null && CompilerClean.namespaceFor(sym) == null;
    }

    public static void pushNSandLoader(ClassLoader loader) {
        Var.pushThreadBindings(RT.map(Var.intern(Symbol.intern("clojure.core"), Symbol.intern("*ns*")).setDynamic(), null, RT.FN_LOADER_VAR, loader, RT.READEVAL, RT.T));
    }
}

