/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Compiler;
import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Compile {
    private static final String PATH_PROP = "clojure.compile.path";
    private static final String REFLECTION_WARNING_PROP = "clojure.compile.warn-on-reflection";
    private static final String UNCHECKED_MATH_PROP = "clojure.compile.unchecked-math";
    private static final Var compile_path = RT.var("clojure.core", "*compile-path*");
    private static final Var compile = RT.var("clojure.core", "compile");
    private static final Var warn_on_reflection = RT.var("clojure.core", "*warn-on-reflection*");
    private static final Var unchecked_math = RT.var("clojure.core", "*unchecked-math*");
    private static Keyword sourceOutputKey = Keyword.intern("clojure.compiler.source-output");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        OutputStreamWriter out = (OutputStreamWriter)RT.OUT.deref();
        PrintWriter err = RT.errPrintWriter();
        String path = System.getProperty(PATH_PROP);
        int count = args.length;
        if (path == null) {
            err.println("ERROR: Must set system property clojure.compile.path\nto the location for compiled .class files.\nThis directory must also be on your CLASSPATH.");
            System.exit(1);
        }
        boolean warnOnReflection = System.getProperty(REFLECTION_WARNING_PROP, "false").equals("true");
        boolean uncheckedMath = System.getProperty(UNCHECKED_MATH_PROP, "false").equals("true");
        String sourceOutput = "target/gen";
        new File(sourceOutput).mkdirs();
        try {
            Var.pushThreadBindings(RT.map(Compiler.SOURCE_GEN_PATH, sourceOutput, compile_path, path, warn_on_reflection, warnOnReflection, unchecked_math, uncheckedMath));
            for (String lib : args) {
                out.write("Compiling " + lib + " to " + path + "\n");
                out.flush();
                compile.invoke(Symbol.intern(lib));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Var.popThreadBindings();
            try {
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace(err);
            }
            System.exit(0);
        }
    }
}

