/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IChunk;
import clojure.lang.IChunkedSeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Reduced;
import clojure.lang.Repeat;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongRange
extends ASeq
implements Counted,
IChunkedSeq,
IReduce {
    private static final int CHUNK_SIZE = 32;
    final long start;
    final long end;
    final long step;
    final BoundsCheck boundsCheck;
    private volatile LongChunk _chunk;
    private volatile ISeq _chunkNext;
    private volatile ISeq _next;

    private static BoundsCheck positiveStep(final long end) {
        return new BoundsCheck(){

            @Override
            public boolean exceededBounds(long val) {
                return val >= end;
            }
        };
    }

    private static BoundsCheck negativeStep(final long end) {
        return new BoundsCheck(){

            @Override
            public boolean exceededBounds(long val) {
                return val <= end;
            }
        };
    }

    private LongRange(long start, long end, long step, BoundsCheck boundsCheck) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.boundsCheck = boundsCheck;
    }

    private LongRange(long start, long end, long step, BoundsCheck boundsCheck, LongChunk chunk, ISeq chunkNext) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.boundsCheck = boundsCheck;
        this._chunk = chunk;
        this._chunkNext = chunkNext;
    }

    private LongRange(IPersistentMap meta, long start, long end, long step, BoundsCheck boundsCheck, LongChunk chunk, ISeq chunkNext) {
        super(meta);
        this.start = start;
        this.end = end;
        this.step = step;
        this.boundsCheck = boundsCheck;
        this._chunk = chunk;
        this._chunkNext = chunkNext;
    }

    public static ISeq create(long end) {
        if (end > 0L) {
            return new LongRange(0L, end, 1L, LongRange.positiveStep(end));
        }
        return PersistentList.EMPTY;
    }

    public static ISeq create(long start, long end) {
        if (start >= end) {
            return PersistentList.EMPTY;
        }
        return new LongRange(start, end, 1L, LongRange.positiveStep(end));
    }

    public static ISeq create(long start, long end, long step) {
        if (step > 0L) {
            if (end <= start) {
                return PersistentList.EMPTY;
            }
            return new LongRange(start, end, step, LongRange.positiveStep(end));
        }
        if (step < 0L) {
            if (end >= start) {
                return PersistentList.EMPTY;
            }
            return new LongRange(start, end, step, LongRange.negativeStep(end));
        }
        if (end == start) {
            return PersistentList.EMPTY;
        }
        return Repeat.create(start);
    }

    @Override
    public Obj withMeta(IPersistentMap meta) {
        if (meta == this._meta) {
            return this;
        }
        return new LongRange(meta, this.start, this.end, this.step, this.boundsCheck, this._chunk, this._chunkNext);
    }

    @Override
    public Object first() {
        return this.start;
    }

    public void forceChunk() {
        if (this._chunk != null) {
            return;
        }
        long nextStart = this.start + this.step * 32L;
        if (this.boundsCheck.exceededBounds(nextStart)) {
            int count = this.absCount(this.start, this.end, this.step);
            this._chunk = new LongChunk(this.start, this.step, count);
        } else {
            this._chunk = new LongChunk(this.start, this.step, 32);
            this._chunkNext = new LongRange(nextStart, this.end, this.step, this.boundsCheck);
        }
    }

    @Override
    public ISeq next() {
        if (this._next != null) {
            return this._next;
        }
        this.forceChunk();
        if (this._chunk.count() > 1) {
            LongChunk smallerChunk = this._chunk.dropFirst();
            this._next = new LongRange(smallerChunk.first(), this.end, this.step, this.boundsCheck, smallerChunk, this._chunkNext);
            return this._next;
        }
        return this.chunkedNext();
    }

    @Override
    public IChunk chunkedFirst() {
        this.forceChunk();
        return this._chunk;
    }

    @Override
    public ISeq chunkedNext() {
        return this.chunkedMore().seq();
    }

    @Override
    public ISeq chunkedMore() {
        this.forceChunk();
        if (this._chunkNext == null) {
            return PersistentList.EMPTY;
        }
        return this._chunkNext;
    }

    public int absCount(long start, long end, long step) {
        double c = (double)(end - start) / (double)step;
        int ic = (int)c;
        if (c > (double)ic) {
            return ic + 1;
        }
        return ic;
    }

    @Override
    public int count() {
        return this.absCount(this.start, this.end, this.step);
    }

    @Override
    public Object reduce(IFn f) {
        Object acc = this.start;
        long i = this.start + this.step;
        while (!this.boundsCheck.exceededBounds(i)) {
            if ((acc = f.invoke(acc, i)) instanceof Reduced) {
                return ((Reduced)acc).deref();
            }
            i += this.step;
        }
        return acc;
    }

    @Override
    public Object reduce(IFn f, Object val) {
        Object acc = val;
        long i = this.start;
        do {
            if (!RT.isReduced(acc = f.invoke(acc, i))) continue;
            return ((Reduced)acc).deref();
        } while (!this.boundsCheck.exceededBounds(i += this.step));
        return acc;
    }

    @Override
    public Iterator iterator() {
        return new LongRangeIterator();
    }

    private static class LongChunk
    implements IChunk,
    Serializable {
        final long start;
        final long step;
        final int count;

        public LongChunk(long start, long step, int count) {
            this.start = start;
            this.step = step;
            this.count = count;
        }

        public long first() {
            return this.start;
        }

        @Override
        public Object nth(int i) {
            return this.start + (long)i * this.step;
        }

        @Override
        public Object nth(int i, Object notFound) {
            if (i >= 0 && i < this.count) {
                return this.start + (long)i * this.step;
            }
            return notFound;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public LongChunk dropFirst() {
            if (this.count <= 1) {
                throw new IllegalStateException("dropFirst of empty chunk");
            }
            return new LongChunk(this.start + this.step, this.step, this.count - 1);
        }

        @Override
        public Object reduce(IFn f, Object init) {
            long x = this.start;
            Object ret = init;
            for (int i = 0; i < this.count; ++i) {
                if (RT.isReduced(ret = f.invoke(ret, x))) {
                    return ret;
                }
                x += this.step;
            }
            return ret;
        }
    }

    class LongRangeIterator
    implements Iterator {
        private long next;

        public LongRangeIterator() {
            this.next = LongRange.this.start;
        }

        @Override
        public boolean hasNext() {
            return !LongRange.this.boundsCheck.exceededBounds(this.next);
        }

        public Object next() {
            if (this.hasNext()) {
                long ret = this.next;
                this.next += LongRange.this.step;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface BoundsCheck
    extends Serializable {
        public boolean exceededBounds(long var1);
    }
}

