/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.gen.SourceBuilder;
import com.google.devtools.j2objc.gen.SourcePosition;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.IOSTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTNodeException;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import com.google.devtools.j2objc.util.UnicodeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

public class StatementGenerator
extends ErrorReportingASTVisitor {
    private final SourceBuilder buffer;
    private final Set<IVariableBinding> fieldHiders;
    private final boolean asFunction;
    private final boolean useReferenceCounting;
    private final Map<Expression, Boolean> needsCastNodes = Maps.newHashMap();
    private static final String EXPONENTIAL_FLOATING_POINT_REGEX = "[+-]?\\d*\\.?\\d*[eE][+-]?\\d+";
    private static final String FLOATING_POINT_SUFFIX_REGEX = ".*[fFdD]";
    private static final String HEX_LITERAL_REGEX = "0[xX].*";

    public static String generate(ASTNode aSTNode, Set<IVariableBinding> set, boolean bl, SourcePosition sourcePosition) throws ASTNodeException {
        StatementGenerator statementGenerator = new StatementGenerator(aSTNode, set, bl, sourcePosition);
        if (aSTNode == null) {
            throw new NullPointerException("cannot generate a null statement");
        }
        statementGenerator.run(aSTNode);
        return statementGenerator.getResult();
    }

    public static String generateArguments(IMethodBinding iMethodBinding, List<Expression> list, Set<IVariableBinding> set, SourcePosition sourcePosition) {
        StatementGenerator statementGenerator = new StatementGenerator(null, set, false, sourcePosition);
        if (IOSMethodBinding.hasVarArgsTarget(iMethodBinding)) {
            statementGenerator.printVarArgs(iMethodBinding, list);
        } else {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Expression expression = list.get(i);
                statementGenerator.printArgument(iMethodBinding, expression, i);
                if (i + 1 >= n) continue;
                statementGenerator.buffer.append(' ');
            }
        }
        return statementGenerator.getResult();
    }

    private StatementGenerator(ASTNode aSTNode, Set<IVariableBinding> set, boolean bl, SourcePosition sourcePosition) {
        CompilationUnit compilationUnit = null;
        if (aSTNode != null && aSTNode.getRoot() instanceof CompilationUnit) {
            compilationUnit = (CompilationUnit)aSTNode.getRoot();
        }
        this.buffer = new SourceBuilder(compilationUnit, Options.emitLineDirectives(), sourcePosition);
        this.fieldHiders = set;
        this.asFunction = bl;
        this.useReferenceCounting = !Options.useARC();
    }

    private String getResult() {
        return this.buffer.toString();
    }

    private void printArguments(IMethodBinding iMethodBinding, List<Expression> list) {
        if (IOSMethodBinding.hasVarArgsTarget(iMethodBinding)) {
            this.printVarArgs(iMethodBinding, list);
        } else if (!list.isEmpty()) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Expression expression = list.get(i);
                this.printArgument(iMethodBinding, expression, i);
                if (i + 1 >= n) continue;
                this.buffer.append(' ');
            }
        }
    }

    private void printArgument(IMethodBinding iMethodBinding, Expression expression, int n) {
        if (iMethodBinding != null) {
            IOSMethod iOSMethod = IOSMethodBinding.getIOSMethod(iMethodBinding);
            if (iOSMethod != null) {
                if (n > 0) {
                    this.buffer.append(iOSMethod.getParameters().get(n).getParameterName());
                }
            } else {
                iMethodBinding = BindingUtil.getOriginalMethodBinding(iMethodBinding.getMethodDeclaration());
                ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
                assert (n < iTypeBindingArray.length) : "method called with more parameters than declared";
                ITypeBinding iTypeBinding = iTypeBindingArray[n];
                String string = NameTable.parameterKeyword(iTypeBinding);
                if (n == 0) {
                    string = NameTable.capitalize(string);
                }
                this.buffer.append(string);
            }
        }
        this.buffer.append(':');
        expression.accept((ASTVisitor)this);
    }

    private void printVarArgs(IMethodBinding iMethodBinding, List<Expression> list) {
        iMethodBinding = iMethodBinding.getMethodDeclaration();
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        Iterator<Expression> iterator = list.iterator();
        for (int i = 0; i < iTypeBindingArray.length; ++i) {
            if (i < iTypeBindingArray.length - 1) {
                this.printArgument(iMethodBinding, iterator.next(), i);
                if (!iterator.hasNext() && i + 1 >= iTypeBindingArray.length) continue;
                this.buffer.append(' ');
                continue;
            }
            if (i == 0) {
                this.buffer.append(':');
                if (iterator.hasNext()) {
                    iterator.next().accept((ASTVisitor)this);
                }
            }
            while (iterator.hasNext()) {
                this.buffer.append(", ");
                iterator.next().accept((ASTVisitor)this);
            }
            this.buffer.append(", nil");
        }
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        assert (anonymousClassDeclaration.bodyDeclarations().size() == 1);
        assert (false) : "not implemented yet";
        return true;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        throw new AssertionError((Object)"ArrayAccess nodes are rewritten by ArrayRewriter.");
    }

    public boolean visit(ArrayCreation arrayCreation) {
        throw new AssertionError((Object)"ArrayCreation nodes are rewritten by ArrayRewriter.");
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(arrayInitializer);
        assert (iTypeBinding.isArray());
        ITypeBinding iTypeBinding2 = iTypeBinding.getComponentType();
        String string = iTypeBinding2.isPrimitive() ? NameTable.primitiveTypeToObjC(iTypeBinding2.getName()) : "id";
        this.buffer.append(String.format("(%s[]){ ", string));
        Iterator<Expression> iterator = ASTUtil.getExpressions(arrayInitializer).iterator();
        while (iterator.hasNext()) {
            iterator.next().accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(" }");
        return false;
    }

    public boolean visit(ArrayType arrayType) {
        ITypeBinding iTypeBinding = Types.mapType(Types.getTypeBinding(arrayType));
        if (iTypeBinding instanceof IOSTypeBinding) {
            this.buffer.append(iTypeBinding.getName());
        } else {
            arrayType.getComponentType().accept((ASTVisitor)this);
            this.buffer.append("[]");
        }
        return false;
    }

    public boolean visit(AssertStatement assertStatement) {
        this.buffer.append(this.asFunction ? "NSCAssert(" : "NSAssert(");
        assertStatement.getExpression().accept((ASTVisitor)this);
        this.buffer.append(", ");
        if (assertStatement.getMessage() != null) {
            Expression expression = assertStatement.getMessage();
            boolean bl = expression instanceof StringLiteral;
            if (!bl) {
                this.buffer.append('[');
            }
            int n = this.buffer.length();
            expression.accept((ASTVisitor)this);
            int n2 = this.buffer.length();
            String string = this.buffer.substring(n, n2);
            string = string.replaceAll(",", " J2OBJC_COMMA()");
            this.buffer.replace(n, n2, string);
            if (!bl) {
                this.buffer.append(" description]");
            }
        } else {
            String string = StatementGenerator.extractNodeCode(this.buffer.getSourcePosition().getSource(), (ASTNode)assertStatement);
            string = CharMatcher.WHITESPACE.trimFrom((CharSequence)string);
            string = StatementGenerator.makeQuotedString(string);
            this.buffer.append("@\"" + this.buffer.getSourcePosition().getFilename() + ":" + this.buffer.getLineNumber((ASTNode)assertStatement) + " condition failed: " + string + "\"");
        }
        this.buffer.append(");\n");
        return false;
    }

    public boolean visit(Assignment assignment) {
        if (Types.hasDeferredFieldSetter((Expression)assignment)) {
            this.printDeferredFieldSetter(assignment);
            return false;
        }
        assignment.getLeftHandSide().accept((ASTVisitor)this);
        this.buffer.append(' ');
        this.buffer.append(StatementGenerator.getOperatorStr(assignment.getOperator()));
        this.buffer.append(' ');
        assignment.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    private void printDeferredFieldSetter(Assignment assignment) {
        Expression expression = assignment.getLeftHandSide();
        IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
        ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass().getTypeDeclaration();
        String string = String.format("%s_set_%s", NameTable.getFullName(iTypeBinding), NameTable.javaFieldToObjC(NameTable.getName((IBinding)iVariableBinding)));
        this.buffer.append(string);
        this.buffer.append('(');
        if (expression instanceof QualifiedName) {
            ((QualifiedName)expression).getQualifier().accept((ASTVisitor)this);
        } else if (expression instanceof FieldAccess) {
            ((FieldAccess)expression).getExpression().accept((ASTVisitor)this);
        } else {
            this.buffer.append("self");
        }
        this.buffer.append(", ");
        assignment.getRightHandSide().accept((ASTVisitor)this);
        this.buffer.append(')');
    }

    private static String getOperatorStr(Assignment.Operator operator) {
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN)) {
            return ">>=";
        }
        return operator.toString();
    }

    private void printUnsignedRightShift(Expression expression, Expression expression2) {
        String string = this.getRightShiftType(expression);
        this.buffer.append("(");
        this.buffer.append(string);
        this.buffer.append(") (((unsigned ");
        this.buffer.append(string);
        this.buffer.append(") ");
        expression.accept((ASTVisitor)this);
        this.buffer.append(") >> ");
        expression2.accept((ASTVisitor)this);
        this.buffer.append(")");
    }

    private String getRightShiftType(Expression expression) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        assert (iTypeBinding != null);
        AST aST = expression.getAST();
        if (aST.resolveWellKnownType("int").equals(iTypeBinding)) {
            return "int";
        }
        if (aST.resolveWellKnownType("long").equals(iTypeBinding)) {
            return "long long";
        }
        if (aST.resolveWellKnownType("byte").equals(iTypeBinding)) {
            return "char";
        }
        if (aST.resolveWellKnownType("short").equals(iTypeBinding)) {
            return "short";
        }
        if (aST.resolveWellKnownType("char").equals(iTypeBinding)) {
            return "unichar";
        }
        throw new AssertionError((Object)("invalid right shift expression type: " + iTypeBinding.getName()));
    }

    public boolean visit(Block block) {
        Expression expression;
        if (Types.hasAutoreleasePool(block)) {
            this.buffer.append("{\n@autoreleasepool ");
        }
        this.buffer.append("{\n");
        List list = block.statements();
        int n = list.size();
        if (n > 0 && list.get(n - 1) instanceof ExpressionStatement && (expression = ((ExpressionStatement)list.get(n - 1)).getExpression()) instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expression;
            IMethodBinding iMethodBinding = Types.getMethodBinding(superMethodInvocation);
            String string = NameTable.getName((IBinding)iMethodBinding);
            if (Options.memoryDebug() && (string.equals("finalize") || string.equals("dealloc"))) {
                this.buffer.append("JreMemDebugRemove(self);\n");
            }
        }
        this.printStatements(list);
        this.buffer.append("}\n");
        if (Types.hasAutoreleasePool(block)) {
            this.buffer.append("}\n");
        }
        return false;
    }

    private void printStatements(List<?> list) {
        for (Statement statement : list) {
            this.buffer.syncLineNumbers((ASTNode)statement);
            statement.accept((ASTVisitor)this);
        }
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        this.buffer.append(booleanLiteral.booleanValue() ? "YES" : "NO");
        return false;
    }

    public boolean visit(BreakStatement breakStatement) {
        if (breakStatement.getLabel() != null) {
            this.buffer.append("goto ");
            breakStatement.getLabel().accept((ASTVisitor)this);
        } else {
            this.buffer.append("break");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(castExpression.getType());
        this.buffer.append("(");
        this.buffer.append(NameTable.getSpecificObjCType(iTypeBinding));
        this.buffer.append(") ");
        if (iTypeBinding.isInterface() && !iTypeBinding.isAnnotation()) {
            this.buffer.append("check_protocol_cast(");
            castExpression.getExpression().accept((ASTVisitor)this);
            this.buffer.append(", @protocol(");
            this.buffer.append(NameTable.getFullName(iTypeBinding));
            this.buffer.append("))");
        } else if (iTypeBinding.isClass() || iTypeBinding.isAnnotation()) {
            this.buffer.append("check_class_cast(");
            castExpression.getExpression().accept((ASTVisitor)this);
            this.buffer.append(", [");
            this.buffer.append(NameTable.getFullName(iTypeBinding));
            this.buffer.append(" class])");
        } else {
            castExpression.getExpression().accept((ASTVisitor)this);
        }
        return false;
    }

    private void printMultiCatch(CatchClause catchClause, boolean bl) {
        SingleVariableDeclaration singleVariableDeclaration = catchClause.getException();
        for (Type type : ASTUtil.getTypes((UnionType)singleVariableDeclaration.getType())) {
            this.buffer.syncLineNumbers((ASTNode)catchClause);
            this.buffer.append("@catch (");
            type.accept((ASTVisitor)this);
            this.buffer.append(' ');
            singleVariableDeclaration.getName().accept((ASTVisitor)this);
            this.buffer.append(") {\n");
            this.printMainExceptionStore(bl, catchClause);
            this.buffer.syncLineNumbers((ASTNode)catchClause);
            this.printStatements(ASTUtil.getStatements(catchClause.getBody()));
            this.buffer.append("}\n");
        }
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        this.buffer.append(UnicodeUtils.escapeCharLiteral(characterLiteral.charValue()));
        return false;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(classInstanceCreation.getType());
        boolean bl = this.maybePrintCastFromId((Expression)classInstanceCreation);
        this.buffer.append(this.useReferenceCounting ? "[[[" : "[[");
        ITypeBinding iTypeBinding2 = iTypeBinding.getDeclaringClass();
        this.buffer.append(NameTable.getFullName(iTypeBinding));
        this.buffer.append(" alloc] init");
        IMethodBinding iMethodBinding = Types.getMethodBinding(classInstanceCreation);
        ArrayList arrayList = ASTUtil.getArguments(classInstanceCreation);
        if (classInstanceCreation.getExpression() != null && iTypeBinding.isMember() && arrayList.size() > 0 && !Types.getTypeBinding(arrayList.get(0)).isEqualTo((IBinding)iTypeBinding2)) {
            GeneratedMethodBinding generatedMethodBinding = new GeneratedMethodBinding(iMethodBinding);
            generatedMethodBinding.addParameter(0, iTypeBinding2);
            iMethodBinding = generatedMethodBinding;
            arrayList = Lists.newArrayList(arrayList);
            arrayList.add(0, classInstanceCreation.getExpression());
        }
        this.printArguments(iMethodBinding, arrayList);
        this.buffer.append(']');
        if (this.useReferenceCounting) {
            this.buffer.append(" autorelease]");
        }
        if (bl) {
            this.buffer.append(")");
        }
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        ITypeBinding iTypeBinding;
        boolean bl = false;
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(conditionalExpression.getThenExpression());
        if (!(iTypeBinding2.equals(iTypeBinding = Types.getTypeBinding(conditionalExpression.getElseExpression())) || conditionalExpression.getThenExpression() instanceof NullLiteral || conditionalExpression.getElseExpression() instanceof NullLiteral)) {
            bl = true;
        }
        conditionalExpression.getExpression().accept((ASTVisitor)this);
        this.buffer.append(" ? ");
        if (bl && iTypeBinding2.isInterface()) {
            this.buffer.append("((id) ");
        }
        conditionalExpression.getThenExpression().accept((ASTVisitor)this);
        if (bl && iTypeBinding2.isInterface()) {
            this.buffer.append(')');
        }
        this.buffer.append(" : ");
        if (bl && iTypeBinding.isInterface()) {
            this.buffer.append("((id) ");
        }
        conditionalExpression.getElseExpression().accept((ASTVisitor)this);
        if (bl && iTypeBinding.isInterface()) {
            this.buffer.append(')');
        }
        return false;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(constructorInvocation);
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        List<Expression> list = ASTUtil.getArguments(constructorInvocation);
        this.buffer.append("[self init" + NameTable.getFullName(iTypeBinding));
        this.printArguments(iMethodBinding, list);
        if (iTypeBinding.isEnum()) {
            this.buffer.append((list.isEmpty() ? "W" : " w") + "ithNSString:__name withInt:__ordinal");
        }
        this.buffer.append("]");
        return false;
    }

    public boolean visit(ContinueStatement continueStatement) {
        if (continueStatement.getLabel() != null) {
            this.buffer.append("goto ");
            continueStatement.getLabel().accept((ASTVisitor)this);
        } else {
            this.buffer.append("continue");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        this.buffer.append("do ");
        doStatement.getBody().accept((ASTVisitor)this);
        this.buffer.append(" while (");
        doStatement.getExpression().accept((ASTVisitor)this);
        this.buffer.append(");\n");
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        this.buffer.append("for (");
        enhancedForStatement.getParameter().accept((ASTVisitor)this);
        this.buffer.append(" in ");
        enhancedForStatement.getExpression().accept((ASTVisitor)this);
        this.buffer.append(") ");
        enhancedForStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        Expression expression = expressionStatement.getExpression();
        IMethodBinding iMethodBinding = Types.getMethodBinding(expression);
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (iMethodBinding != null && !iTypeBinding.isPrimitive() && Options.useARC()) {
            this.buffer.append("(void) ");
        }
        expression.accept((ASTVisitor)this);
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        Expression expression = fieldAccess.getExpression();
        this.needsCastNodes.put(expression, true);
        if (!(expression instanceof ThisExpression) || !BindingUtil.isStatic((IBinding)Types.getVariableBinding(fieldAccess))) {
            expression.accept((ASTVisitor)this);
            this.buffer.append("->");
        }
        fieldAccess.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        this.buffer.append("for (");
        Iterator<Expression> iterator = ASTUtil.getInitializers(forStatement).iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            expression.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append("; ");
        if (forStatement.getExpression() != null) {
            forStatement.getExpression().accept((ASTVisitor)this);
        }
        this.buffer.append("; ");
        iterator = ASTUtil.getUpdaters(forStatement).iterator();
        while (iterator.hasNext()) {
            iterator.next().accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(") ");
        forStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        this.buffer.append("if (");
        ifStatement.getExpression().accept((ASTVisitor)this);
        this.buffer.append(") ");
        ifStatement.getThenStatement().accept((ASTVisitor)this);
        if (ifStatement.getElseStatement() != null) {
            this.buffer.append(" else ");
            ifStatement.getElseStatement().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        InfixExpression.Operator operator = infixExpression.getOperator();
        Expression expression = infixExpression.getLeftOperand();
        Expression expression2 = infixExpression.getRightOperand();
        List<Expression> list = ASTUtil.getExtendedOperands(infixExpression);
        ITypeBinding iTypeBinding = Types.getTypeBinding(infixExpression);
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(expression);
        if (Types.isJavaStringType(iTypeBinding) && operator.equals(InfixExpression.Operator.PLUS)) {
            this.printStringConcatenation(expression, expression2, list);
        } else if ((operator.equals(InfixExpression.Operator.EQUALS) || operator.equals(InfixExpression.Operator.NOT_EQUALS)) && (expression instanceof StringLiteral || expression2 instanceof StringLiteral)) {
            Expression expression3 = expression;
            Expression expression4 = expression2;
            if (!(expression instanceof StringLiteral)) {
                expression3 = expression2;
                expression4 = expression;
            }
            this.buffer.append(operator.equals(InfixExpression.Operator.NOT_EQUALS) ? "![" : "[");
            expression3.accept((ASTVisitor)this);
            this.buffer.append(" isEqual:");
            expression4.accept((ASTVisitor)this);
            this.buffer.append("]");
        } else if (operator.equals(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) && !iTypeBinding2.getName().equals("char")) {
            this.printUnsignedRightShift(expression, expression2);
        } else if (operator.equals(InfixExpression.Operator.LEFT_SHIFT) && iTypeBinding2.getName().equals("long")) {
            this.buffer.append("(long long) (((uint64_t) ");
            expression.accept((ASTVisitor)this);
            this.buffer.append(") << ");
            expression2.accept((ASTVisitor)this);
            this.buffer.append(')');
        } else {
            expression.accept((ASTVisitor)this);
            this.buffer.append(' ');
            this.buffer.append(StatementGenerator.getOperatorStr(operator));
            this.buffer.append(' ');
            expression2.accept((ASTVisitor)this);
            Iterator<Expression> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.buffer.append(' ').append(operator.toString()).append(' ');
                iterator.next().accept((ASTVisitor)this);
            }
        }
        return false;
    }

    private static String getOperatorStr(InfixExpression.Operator operator) {
        if (operator.equals(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED)) {
            return ">>";
        }
        return operator.toString();
    }

    private void printStringConcatenation(Expression expression, Expression expression2, List<Expression> list) {
        Object object2;
        ArrayList arrayList = Lists.newArrayList((Object[])new Expression[]{expression, expression2});
        arrayList.addAll(list);
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList arrayList2 = Lists.newArrayList();
        for (Object object2 : arrayList) {
            Object object3;
            Object object4;
            IBinding iBinding = Types.getBinding(object2);
            if (iBinding instanceof IVariableBinding) {
                object4 = (IVariableBinding)iBinding;
                object3 = (object4 = object4.getVariableDeclaration()).getConstantValue();
                if (object3 instanceof String) {
                    String string = (String)object3;
                    if (UnicodeUtils.hasValidCppCharacters(string)) {
                        stringBuilder.append(string.replace("%", "%%"));
                        continue;
                    }
                    J2ObjC.error((ASTNode)object2, "String constant has Unicode or octal escape sequences that are not valid in Objective-C.\nEither make string non-final, or remove characters.");
                    continue;
                }
                if (object3 != null) {
                    stringBuilder.append(object3.toString());
                    continue;
                }
            }
            if (object2 instanceof StringLiteral) {
                object4 = ((StringLiteral)object2).getLiteralValue();
                if (UnicodeUtils.hasValidCppCharacters((String)object4)) {
                    stringBuilder.append(((String)object4).replace("%", "%%"));
                    continue;
                }
                stringBuilder.append("%@");
                arrayList2.add(object2);
                continue;
            }
            if (object2 instanceof BooleanLiteral) {
                stringBuilder.append(String.valueOf(((BooleanLiteral)object2).booleanValue()));
                continue;
            }
            if (object2 instanceof CharacterLiteral) {
                stringBuilder.append(((CharacterLiteral)object2).charValue());
                continue;
            }
            if (object2 instanceof NumberLiteral) {
                stringBuilder.append(((NumberLiteral)object2).getToken());
                continue;
            }
            arrayList2.add(object2);
            object4 = Types.getTypeBinding(object2);
            if (object4.isPrimitive()) {
                object3 = object4.getBinaryName();
                assert (((String)object3).length() == 1);
                switch (((String)object3).charAt(0)) {
                    case 'B': 
                    case 'I': 
                    case 'S': {
                        stringBuilder.append("%d");
                        break;
                    }
                    case 'J': {
                        stringBuilder.append("%lld");
                        break;
                    }
                    case 'D': 
                    case 'F': {
                        stringBuilder.append("%f");
                        break;
                    }
                    case 'C': {
                        stringBuilder.append("%C");
                        break;
                    }
                    case 'Z': {
                        stringBuilder.append("%@");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown primitive type: " + (String)object3));
                    }
                }
                continue;
            }
            stringBuilder.append("%@");
        }
        String string = UnicodeUtils.escapeStringLiteral(stringBuilder.toString());
        if (arrayList2.isEmpty()) {
            this.buffer.append("@\"" + string.replace("%%", "%") + "\"");
            return;
        }
        this.buffer.append("[NSString stringWithFormat:@\"");
        this.buffer.append(string);
        this.buffer.append("\", ");
        object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            this.printStringConcatenationArg((Expression)object2.next());
            if (!object2.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(']');
    }

    private void printStringConcatenationArg(Expression expression) {
        if (Types.getTypeBinding(expression).isEqualTo((IBinding)expression.getAST().resolveWellKnownType("boolean"))) {
            this.buffer.append("[JavaLangBoolean toStringWithBoolean:");
            expression.accept((ASTVisitor)this);
            this.buffer.append(']');
            return;
        }
        if (expression instanceof StringLiteral) {
            this.buffer.append(StatementGenerator.buildStringFromChars(((StringLiteral)expression).getLiteralValue()));
            return;
        }
        if (expression instanceof NullLiteral) {
            this.buffer.append("@\"null\"");
            return;
        }
        if (this.stringConcatenationArgNeedsIntCast(expression)) {
            this.buffer.append("(int) ");
            expression.accept((ASTVisitor)this);
            return;
        }
        expression.accept((ASTVisitor)this);
    }

    private boolean stringConcatenationArgNeedsIntCast(Expression expression) {
        if (expression instanceof MethodInvocation) {
            ITypeBinding iTypeBinding;
            MethodInvocation methodInvocation = (MethodInvocation)expression;
            String string = Types.getMethodBinding(methodInvocation).getName();
            if (string.equals("hash")) {
                return true;
            }
            if (methodInvocation.getExpression() != null && (iTypeBinding = Types.mapType(Types.getTypeBinding(methodInvocation.getExpression()))).getName().equals("NSString") && string.equals("length")) {
                return true;
            }
        }
        return false;
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(instanceofExpression.getLeftOperand());
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(instanceofExpression.getRightOperand());
        this.buffer.append('[');
        if (iTypeBinding.isInterface()) {
            this.buffer.append("(id) ");
        }
        instanceofExpression.getLeftOperand().accept((ASTVisitor)this);
        if (iTypeBinding2.isInterface()) {
            this.buffer.append(" conformsToProtocol: @protocol(");
            instanceofExpression.getRightOperand().accept((ASTVisitor)this);
            this.buffer.append(")");
        } else {
            this.buffer.append(" isKindOfClass:[");
            instanceofExpression.getRightOperand().accept((ASTVisitor)this);
            this.buffer.append(" class]");
        }
        this.buffer.append(']');
        return false;
    }

    public boolean visit(LabeledStatement labeledStatement) {
        labeledStatement.getLabel().accept((ASTVisitor)this);
        this.buffer.append(": ");
        labeledStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        ITypeBinding iTypeBinding;
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodInvocation);
        String string = NameTable.getName((IBinding)iMethodBinding);
        assert (iMethodBinding != null);
        Expression expression = methodInvocation.getExpression();
        ITypeBinding iTypeBinding2 = iTypeBinding = expression != null ? Types.getTypeBinding(expression) : iMethodBinding.getDeclaringClass();
        if (string.equals("isAssignableFrom") && iMethodBinding.getDeclaringClass().equals(Types.getIOSClass())) {
            this.printIsAssignableFromExpression(methodInvocation);
        } else {
            IOSMethod iOSMethod = IOSMethodBinding.getIOSMethod(iMethodBinding);
            boolean bl = this.maybePrintCast((Expression)methodInvocation, StatementGenerator.getActualReturnType(iMethodBinding, iTypeBinding));
            if (iOSMethod != null && iOSMethod.isFunction()) {
                this.printFunctionInvocation(iOSMethod, ASTUtil.getArguments(methodInvocation));
            } else {
                this.printMethodInvocation(iMethodBinding, string, expression, ASTUtil.getArguments(methodInvocation));
            }
            if (bl) {
                this.buffer.append(')');
            }
        }
        return false;
    }

    private void printFunctionInvocation(IOSMethod iOSMethod, List<Expression> list) {
        if (iOSMethod == IOSMethod.DEREFERENCE) {
            this.buffer.append("(*");
            list.get(0).accept((ASTVisitor)this);
            this.buffer.append(')');
            return;
        }
        if (iOSMethod == IOSMethod.ADDRESS_OF) {
            this.buffer.append('&');
            list.get(0).accept((ASTVisitor)this);
            return;
        }
        this.buffer.append(iOSMethod.getName());
        this.buffer.append('(');
        boolean bl = true;
        for (Expression expression : list) {
            if (bl) {
                bl = false;
            } else {
                this.buffer.append(", ");
            }
            boolean bl2 = true;
            if (bl2) {
                this.buffer.append("nil_chk(");
            }
            expression.accept((ASTVisitor)this);
            if (!bl2) continue;
            this.buffer.append(')');
        }
        this.buffer.append(')');
    }

    private void printMethodInvocation(IMethodBinding iMethodBinding, String string, Expression expression, List<Expression> list) {
        this.buffer.append('[');
        if (BindingUtil.isStatic((IBinding)iMethodBinding)) {
            this.buffer.append(NameTable.getFullName(iMethodBinding.getDeclaringClass()));
        } else if (expression != null) {
            this.needsCastNodes.put(expression, true);
            boolean bl = false;
            boolean bl2 = true;
            if (bl2) {
                bl = this.maybePrintCastFromId(expression);
                this.needsCastNodes.remove(expression);
                this.buffer.append("nil_chk(");
            }
            expression.accept((ASTVisitor)this);
            if (bl2) {
                this.buffer.append(')');
                if (bl) {
                    this.buffer.append(')');
                }
            }
        } else {
            this.buffer.append("self");
        }
        this.buffer.append(' ');
        if (iMethodBinding instanceof IOSMethodBinding) {
            this.buffer.append(iMethodBinding.getName());
        } else {
            this.buffer.append(string);
        }
        this.printArguments(iMethodBinding, list);
        this.buffer.append(']');
    }

    private static ITypeBinding getActualReturnType(IMethodBinding iMethodBinding, ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2;
        IMethodBinding iMethodBinding2 = StatementGenerator.getFirstDeclaration(StatementGenerator.getObjCMethodSignature(iMethodBinding), iTypeBinding);
        if (iMethodBinding2 == null) {
            iMethodBinding2 = iMethodBinding.getMethodDeclaration();
        }
        if ((iTypeBinding2 = iMethodBinding2.getReturnType()).isTypeVariable()) {
            return Types.resolveIOSType("id");
        }
        return Types.mapType(iTypeBinding2.getErasure());
    }

    private static IMethodBinding getFirstDeclaration(String string, ITypeBinding iTypeBinding) {
        if (iTypeBinding == null) {
            return null;
        }
        iTypeBinding = iTypeBinding.getTypeDeclaration();
        for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
            if (!string.equals(StatementGenerator.getObjCMethodSignature(iMethodBinding))) continue;
            return iMethodBinding;
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(Arrays.asList(iTypeBinding.getInterfaces()));
        arrayList.add(iTypeBinding.isTypeVariable() ? 0 : arrayList.size(), iTypeBinding.getSuperclass());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IMethodBinding iMethodBinding;
            ITypeBinding iTypeBinding2 = (ITypeBinding)iterator.next();
            iMethodBinding = StatementGenerator.getFirstDeclaration(string, iTypeBinding2);
            if (iMethodBinding == null) continue;
            return iMethodBinding;
        }
        return null;
    }

    private static String getObjCMethodSignature(IMethodBinding iMethodBinding) {
        StringBuilder stringBuilder = new StringBuilder(iMethodBinding.getName());
        boolean bl = true;
        for (ITypeBinding iTypeBinding : iMethodBinding.getParameterTypes()) {
            String string = NameTable.parameterKeyword(iTypeBinding);
            if (bl) {
                bl = false;
                string = NameTable.capitalize(string);
            }
            stringBuilder.append(string + ":");
        }
        return stringBuilder.toString();
    }

    private void printIsAssignableFromExpression(MethodInvocation methodInvocation) {
        assert (!methodInvocation.arguments().isEmpty());
        Expression expression = methodInvocation.getExpression();
        Expression expression2 = (Expression)methodInvocation.arguments().get(0);
        this.buffer.append('[');
        expression.accept((ASTVisitor)this);
        this.buffer.append(" isAssignableFrom:");
        expression2.accept((ASTVisitor)this);
        this.buffer.append(']');
    }

    private boolean maybePrintCastFromId(Expression expression) {
        return this.maybePrintCast(expression, Types.resolveIOSType("id"));
    }

    private boolean maybePrintCast(Expression expression, ITypeBinding iTypeBinding) {
        Boolean bl = this.needsCastNodes.get(expression);
        if (bl == null) {
            return false;
        }
        ITypeBinding iTypeBinding2 = Types.mapType(Types.getTypeBinding(expression).getTypeDeclaration());
        if (iTypeBinding.isAssignmentCompatible(iTypeBinding2)) {
            return false;
        }
        if (iTypeBinding == Types.resolveIOSType("id") && !bl.booleanValue()) {
            return false;
        }
        ITypeBinding iTypeBinding3 = Types.getTypeBinding(expression);
        if (iTypeBinding3 == null || iTypeBinding3.isPrimitive() || Types.isVoidType(iTypeBinding3)) {
            return false;
        }
        String string = NameTable.getSpecificObjCType(iTypeBinding3);
        if (string.equals("id")) {
            return false;
        }
        this.buffer.append("((" + string + ") ");
        return true;
    }

    public boolean visit(NullLiteral nullLiteral) {
        this.buffer.append("nil");
        return false;
    }

    public boolean visit(NumberLiteral numberLiteral) {
        String string = numberLiteral.getToken();
        string = string.replace("_", "");
        ITypeBinding iTypeBinding = Types.getTypeBinding(numberLiteral);
        assert (iTypeBinding.isPrimitive());
        char c = iTypeBinding.getKey().charAt(0);
        if (c == 'D' || c == 'F') {
            if (string.matches(FLOATING_POINT_SUFFIX_REGEX)) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.matches(HEX_LITERAL_REGEX)) {
                string = Double.toString(Double.parseDouble(string));
            } else if (!string.matches(EXPONENTIAL_FLOATING_POINT_REGEX) && string.indexOf(46) == -1) {
                string = string + ".0";
            }
            if (c == 'F') {
                string = string + 'f';
            }
        } else if (c == 'J') {
            if (string.equals("0x8000000000000000L") || string.equals("-9223372036854775808L")) {
                string = "-0x7fffffffffffffffLL - 1";
            } else {
                if (string.startsWith("0x")) {
                    this.buffer.append("(long long) ");
                }
                int n = 0;
                for (int i = string.length() - 1; i > 0 && string.charAt(i) == 'L'; --i) {
                    ++n;
                }
                if (n == 1) {
                    string = string + 'L';
                }
            }
        } else if (c == 'I') {
            if (string.startsWith("0x")) {
                this.buffer.append("(int) ");
            }
            if (string.equals("0x80000000") || string.equals("-2147483648")) {
                string = "-0x7fffffff - 1";
            }
        }
        this.buffer.append(string);
        return false;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        this.buffer.append("(");
        parenthesizedExpression.getExpression().accept((ASTVisitor)this);
        this.buffer.append(")");
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        postfixExpression.getOperand().accept((ASTVisitor)this);
        this.buffer.append(postfixExpression.getOperator().toString());
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        this.buffer.append(prefixExpression.getOperator().toString());
        prefixExpression.getOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(PrimitiveType primitiveType) {
        this.buffer.append(NameTable.primitiveTypeToObjC(primitiveType));
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        IVariableBinding iVariableBinding;
        IBinding iBinding = Types.getBinding(qualifiedName);
        if (iBinding instanceof IVariableBinding) {
            iVariableBinding = (IVariableBinding)iBinding;
            if (BindingUtil.isPrimitiveConstant(iVariableBinding)) {
                this.buffer.append(NameTable.getPrimitiveConstantName(iVariableBinding));
                return false;
            }
            if (BindingUtil.isStatic((IBinding)iVariableBinding)) {
                this.buffer.append(NameTable.getStaticVarQualifiedName(iVariableBinding));
                return false;
            }
        }
        if (iBinding instanceof ITypeBinding) {
            this.buffer.append(NameTable.getFullName((ITypeBinding)iBinding));
            return false;
        }
        iVariableBinding = qualifiedName.getQualifier();
        this.needsCastNodes.put((Expression)iVariableBinding, true);
        iVariableBinding.accept((ASTVisitor)this);
        this.buffer.append("->");
        qualifiedName.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(QualifiedType qualifiedType) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(qualifiedType);
        if (iTypeBinding != null) {
            this.buffer.append(NameTable.getFullName(iTypeBinding));
            return false;
        }
        return true;
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.buffer.append("return");
        Expression expression = returnStatement.getExpression();
        if (expression != null) {
            this.buffer.append(' ');
            MethodDeclaration methodDeclaration = ASTUtil.getOwningMethod((ASTNode)returnStatement);
            boolean bl = false;
            if (methodDeclaration.getName().getIdentifier().equals("copyWithZone") && this.useReferenceCounting) {
                bl = true;
            }
            if (bl) {
                this.buffer.append("[");
            }
            this.needsCastNodes.put(expression, false);
            expression.accept((ASTVisitor)this);
            if (bl) {
                this.buffer.append(" retain]");
            }
        } else if (Types.getMethodBinding(ASTUtil.getOwningMethod((ASTNode)returnStatement)).isConstructor()) {
            this.buffer.append(" self");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(SimpleName simpleName) {
        IBinding iBinding = Types.getBinding(simpleName);
        if (iBinding instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            if (BindingUtil.isPrimitiveConstant(iVariableBinding)) {
                this.buffer.append(NameTable.getPrimitiveConstantName(iVariableBinding));
            } else if (BindingUtil.isStatic((IBinding)iVariableBinding)) {
                this.buffer.append(NameTable.getStaticVarQualifiedName(iVariableBinding));
            } else if (iVariableBinding.isField()) {
                this.buffer.append(NameTable.javaFieldToObjC(NameTable.getName((IBinding)iVariableBinding)));
            } else {
                String string = NameTable.getName((IBinding)iVariableBinding);
                this.buffer.append(string);
                if (!iVariableBinding.isField() && (this.fieldHiders.contains(iVariableBinding) || NameTable.isReservedName(string))) {
                    this.buffer.append("Arg");
                }
            }
            return false;
        }
        if (iBinding instanceof ITypeBinding) {
            if (iBinding instanceof IOSTypeBinding) {
                this.buffer.append(iBinding.getName());
            } else {
                this.buffer.append(NameTable.getFullName((ITypeBinding)iBinding));
            }
        } else {
            this.buffer.append(simpleName.getIdentifier());
        }
        return false;
    }

    public boolean visit(SimpleType simpleType) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(simpleType);
        if (iTypeBinding != null) {
            String string = NameTable.getFullName(iTypeBinding);
            this.buffer.append(string);
            return false;
        }
        return true;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        this.buffer.append(NameTable.getSpecificObjCType(Types.getVariableBinding(singleVariableDeclaration)));
        if (singleVariableDeclaration.isVarargs()) {
            this.buffer.append("...");
        }
        if (this.buffer.charAt(this.buffer.length() - 1) != '*') {
            this.buffer.append(" ");
        }
        singleVariableDeclaration.getName().accept((ASTVisitor)this);
        for (int i = 0; i < singleVariableDeclaration.getExtraDimensions(); ++i) {
            this.buffer.append("[]");
        }
        if (singleVariableDeclaration.getInitializer() != null) {
            this.buffer.append(" = ");
            singleVariableDeclaration.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(StringLiteral stringLiteral) {
        this.buffer.append(StatementGenerator.generateStringLiteral(stringLiteral));
        return false;
    }

    public static String generateStringLiteral(StringLiteral stringLiteral) {
        if (UnicodeUtils.hasValidCppCharacters(stringLiteral.getLiteralValue())) {
            return "@\"" + UnicodeUtils.escapeStringLiteral(stringLiteral.getLiteralValue()) + "\"";
        }
        return StatementGenerator.buildStringFromChars(stringLiteral.getLiteralValue());
    }

    @VisibleForTesting
    static String buildStringFromChars(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[NSString stringWithCharacters:(unichar[]) { ");
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            stringBuilder.append("(int) 0x");
            stringBuilder.append(Integer.toHexString(c));
            if (++n2 >= n) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" } length:");
        String string2 = Integer.toString(n);
        stringBuilder.append(string2);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        this.buffer.append("[super init");
        List<Expression> list = ASTUtil.getArguments(superConstructorInvocation);
        this.printArguments(Types.getMethodBinding(superConstructorInvocation), list);
        if (Types.getTypeBinding(superConstructorInvocation).isEnum() || Types.getTypeBinding(ASTUtil.getOwningType((ASTNode)superConstructorInvocation)).isEnum()) {
            this.buffer.append((list.isEmpty() ? "W" : " w") + "ithNSString:__name withInt:__ordinal");
        }
        this.buffer.append(']');
        return false;
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        this.buffer.append(NameTable.javaFieldToObjC(NameTable.getName(superFieldAccess.getName())));
        return false;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(superMethodInvocation);
        Name name = superMethodInvocation.getQualifier();
        if (name != null) {
            String string = NameTable.getFullName(Types.getTypeBinding(name).getSuperclass());
            String string2 = NameTable.getMethodSelector(iMethodBinding);
            ITypeBinding iTypeBinding = iMethodBinding.getReturnType();
            boolean bl = false;
            String string3 = "";
            if (iTypeBinding.isPrimitive()) {
                this.buffer.append(String.format("((%s (*)(id, SEL, ...))", NameTable.primitiveTypeToObjC(iTypeBinding.getName())));
                string3 = ")";
            } else {
                bl = this.maybePrintCastFromId((Expression)superMethodInvocation);
            }
            this.buffer.append(String.format("[%s instanceMethodForSelector:@selector(%s)]%s(", string, string2, string3));
            name.accept((ASTVisitor)this);
            this.buffer.append(String.format(", @selector(%s)", string2));
            for (Expression expression : ASTUtil.getArguments(superMethodInvocation)) {
                this.buffer.append(", ");
                expression.accept((ASTVisitor)this);
            }
            this.buffer.append(")");
            if (bl) {
                this.buffer.append(")");
            }
        } else {
            boolean bl = this.maybePrintCast((Expression)superMethodInvocation, StatementGenerator.getActualReturnType(iMethodBinding, Types.getTypeBinding(ASTUtil.getOwningType((ASTNode)superMethodInvocation)).getSuperclass()));
            if (BindingUtil.isStatic((IBinding)iMethodBinding)) {
                this.buffer.append("[[super class] ");
            } else {
                this.buffer.append("[super ");
            }
            this.buffer.append(NameTable.getName((IBinding)iMethodBinding));
            this.printArguments(iMethodBinding, ASTUtil.getArguments(superMethodInvocation));
            this.buffer.append(']');
            if (bl) {
                this.buffer.append(')');
            }
        }
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        if (switchCase.isDefault()) {
            this.buffer.append("  default:\n");
        } else {
            this.buffer.append("  case ");
            Expression expression = switchCase.getExpression();
            boolean bl = Types.getTypeBinding(expression).isEnum();
            if (bl) {
                String string = NameTable.getFullName(Types.getTypeBinding(expression));
                String string2 = string.endsWith("Enum") ? string.substring(0, string.length() - 4) : string;
                this.buffer.append(string2).append("_");
            }
            if (bl && expression instanceof SimpleName) {
                this.buffer.append(((SimpleName)expression).getIdentifier());
            } else if (bl && expression instanceof QualifiedName) {
                this.buffer.append(((QualifiedName)expression).getName().getIdentifier());
            } else {
                expression.accept((ASTVisitor)this);
            }
            this.buffer.append(":\n");
        }
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        Expression expression = switchStatement.getExpression();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (Types.isJavaStringType(iTypeBinding)) {
            this.printStringSwitchStatement(switchStatement);
            return false;
        }
        this.buffer.append("switch (");
        if (iTypeBinding.isEnum()) {
            this.buffer.append('[');
        }
        expression.accept((ASTVisitor)this);
        if (iTypeBinding.isEnum()) {
            this.buffer.append(" ordinal]");
        }
        this.buffer.append(") ");
        this.buffer.append("{\n");
        List<Statement> list = ASTUtil.getStatements(switchStatement);
        for (Statement statement : list) {
            this.buffer.syncLineNumbers((ASTNode)statement);
            statement.accept((ASTVisitor)this);
        }
        if (!list.isEmpty() && list.get(list.size() - 1) instanceof SwitchCase) {
            this.buffer.append(";\n");
        }
        this.buffer.append("}\n");
        return false;
    }

    private void printStringSwitchStatement(SwitchStatement switchStatement) {
        SwitchCase switchCase;
        this.buffer.append("{\n");
        ArrayList arrayList = Lists.newArrayList();
        List<Statement> list = ASTUtil.getStatements(switchStatement);
        for (Object object : list) {
            if (!(object instanceof SwitchCase) || (switchCase = (SwitchCase)object).isDefault()) continue;
            assert (switchCase.getExpression() instanceof StringLiteral);
            arrayList.add(((StringLiteral)switchCase.getExpression()).getEscapedValue());
        }
        this.buffer.syncLineNumbers((ASTNode)switchStatement);
        this.buffer.append("NSArray *__caseValues = [NSArray arrayWithObjects:");
        for (Object object : arrayList) {
            this.buffer.append("@" + (String)object + ", ");
        }
        this.buffer.append("nil];\n");
        this.buffer.syncLineNumbers((ASTNode)switchStatement);
        this.buffer.append("NSUInteger __index = [__caseValues indexOfObject:");
        switchStatement.getExpression().accept((ASTVisitor)this);
        this.buffer.append("];\n");
        this.buffer.syncLineNumbers((ASTNode)switchStatement);
        this.buffer.append("switch (__index) {\n");
        for (Object object : list) {
            this.buffer.syncLineNumbers((ASTNode)object);
            if (object instanceof SwitchCase) {
                switchCase = (SwitchCase)object;
                if (switchCase.isDefault()) {
                    object.accept((ASTVisitor)this);
                    continue;
                }
                int n = arrayList.indexOf(((StringLiteral)switchCase.getExpression()).getEscapedValue());
                assert (n >= 0);
                this.buffer.append("case ");
                this.buffer.append(n);
                this.buffer.append(":\n");
                continue;
            }
            object.accept((ASTVisitor)this);
        }
        this.buffer.append("}\n}\n");
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        this.buffer.append("@synchronized (");
        synchronizedStatement.getExpression().accept((ASTVisitor)this);
        this.buffer.append(") ");
        synchronizedStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ThisExpression thisExpression) {
        this.buffer.append("self");
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.buffer.append("@throw ");
        throwStatement.getExpression().accept((ASTVisitor)this);
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        boolean bl;
        List<VariableDeclarationExpression> list = ASTUtil.getResources(tryStatement);
        boolean bl2 = bl = !list.isEmpty();
        if (bl) {
            this.buffer.append("{\n");
            this.buffer.syncLineNumbers((ASTNode)tryStatement);
            this.buffer.append("JavaLangThrowable *__mainException = nil;\n");
        }
        for (VariableDeclarationExpression variableDeclarationExpression : list) {
            this.buffer.syncLineNumbers((ASTNode)variableDeclarationExpression);
            variableDeclarationExpression.accept((ASTVisitor)this);
            this.buffer.append(";\n");
        }
        this.buffer.append("@try ");
        tryStatement.getBody().accept((ASTVisitor)this);
        this.buffer.append(' ');
        for (VariableDeclarationExpression variableDeclarationExpression : tryStatement.catchClauses()) {
            if (variableDeclarationExpression.getException().getType().isUnionType()) {
                this.printMultiCatch((CatchClause)variableDeclarationExpression, bl);
            }
            this.buffer.syncLineNumbers((ASTNode)variableDeclarationExpression);
            this.buffer.append("@catch (");
            variableDeclarationExpression.getException().accept((ASTVisitor)this);
            this.buffer.append(") {\n");
            this.printMainExceptionStore(bl, (CatchClause)variableDeclarationExpression);
            this.buffer.syncLineNumbers((ASTNode)variableDeclarationExpression);
            this.printStatements(ASTUtil.getStatements(variableDeclarationExpression.getBody()));
            this.buffer.append("}\n");
        }
        if (tryStatement.getFinally() != null || list.size() > 0) {
            this.buffer.append(" @finally {\n");
            if (tryStatement.getFinally() != null) {
                this.printStatements(ASTUtil.getStatements(tryStatement.getFinally()));
            }
            for (VariableDeclarationExpression variableDeclarationExpression : list) {
                for (VariableDeclarationFragment variableDeclarationFragment : ASTUtil.getFragments(variableDeclarationExpression)) {
                    this.buffer.syncLineNumbers((ASTNode)variableDeclarationExpression);
                    this.buffer.append("@try {\n[");
                    this.buffer.append(variableDeclarationFragment.getName().getFullyQualifiedName());
                    this.buffer.append(" close];\n}\n");
                    this.buffer.append("@catch (JavaLangThrowable *e) {\n");
                    this.buffer.syncLineNumbers((ASTNode)variableDeclarationExpression);
                    this.buffer.append("if (__mainException) {\n");
                    this.buffer.syncLineNumbers((ASTNode)variableDeclarationExpression);
                    this.buffer.append("[__mainException addSuppressedWithJavaLangThrowable:e];\n} else {\n");
                    this.buffer.syncLineNumbers((ASTNode)variableDeclarationExpression);
                    this.buffer.append("__mainException = e;\n}\n");
                    this.buffer.append("}\n");
                }
            }
            this.buffer.syncLineNumbers((ASTNode)tryStatement);
            if (bl) {
                this.buffer.append("if (__mainException) {\n@throw __mainException;\n}\n");
            }
            this.buffer.append("}\n");
        }
        if (bl) {
            this.buffer.append("}\n");
        }
        return false;
    }

    private void printMainExceptionStore(boolean bl, CatchClause catchClause) {
        if (bl) {
            this.buffer.append("__mainException = ");
            this.buffer.append(catchClause.getException().getName().getFullyQualifiedName());
            this.buffer.append(";\n");
        }
    }

    public boolean visit(TypeLiteral typeLiteral) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeLiteral.getType());
        if (iTypeBinding.isPrimitive()) {
            this.buffer.append(String.format("[IOSClass %sClass]", iTypeBinding.getName()));
        } else if (iTypeBinding.isInterface()) {
            this.buffer.append("[IOSClass classWithProtocol:@protocol(");
            this.buffer.append(NameTable.getFullName(iTypeBinding));
            this.buffer.append(")]");
        } else {
            this.buffer.append("[IOSClass classWithClass:[");
            this.buffer.append(NameTable.getFullName(iTypeBinding));
            this.buffer.append(" class]]");
        }
        return false;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        String string = NameTable.getSpecificObjCType(Types.getTypeBinding(variableDeclarationExpression));
        boolean bl = string.endsWith("*");
        this.buffer.append(string);
        if (!bl) {
            this.buffer.append(' ');
        }
        Iterator iterator = variableDeclarationExpression.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            variableDeclarationFragment.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
            if (!bl) continue;
            this.buffer.append('*');
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        variableDeclarationFragment.getName().accept((ASTVisitor)this);
        Expression expression = variableDeclarationFragment.getInitializer();
        if (expression != null) {
            this.buffer.append(" = ");
            this.needsCastNodes.put(expression, false);
            expression.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        List<VariableDeclarationFragment> list = ASTUtil.getFragments(variableDeclarationStatement);
        assert (!list.isEmpty());
        IVariableBinding iVariableBinding = Types.getVariableBinding(list.get(0));
        String string = NameTable.getSpecificObjCType(iVariableBinding);
        String string2 = " ";
        int n = string.indexOf(" *");
        if (n != -1) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        this.buffer.append(string);
        Iterator<VariableDeclarationFragment> iterator = list.iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = iterator.next();
            this.buffer.append(string2);
            variableDeclarationFragment.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        this.buffer.append("while (");
        whileStatement.getExpression().accept((ASTVisitor)this);
        this.buffer.append(") ");
        whileStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Initializer initializer) {
        throw new AssertionError((Object)"initializer node not converted");
    }

    private static String extractCode(String string, int n, int n2) {
        return string.substring(n, n + n2);
    }

    private static String extractNodeCode(String string, ASTNode aSTNode) {
        return StatementGenerator.extractCode(string, aSTNode.getStartPosition(), aSTNode.getLength());
    }

    private static String makeQuotedString(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n = stringBuffer.indexOf("\\", n)) != -1) {
            stringBuffer.replace(n++, n++, "\\\\");
        }
        n = 0;
        while ((n = stringBuffer.indexOf("\"", n)) != -1) {
            stringBuffer.replace(n++, n++, "\\\"");
        }
        n = 0;
        while ((n = stringBuffer.indexOf("\n")) != -1) {
            stringBuffer.replace(n++, n++, "\\n");
        }
        return stringBuffer.toString();
    }
}

