/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.devtools.j2objc.types.IOSParameter;
import java.util.ArrayList;
import java.util.List;

public class IOSMethod {
    private final String name;
    private final boolean isFunction;
    private final String declaringClass;
    private final List<IOSParameter> parameters;
    private boolean varArgs = false;
    public static final IOSMethod DEREFERENCE = IOSMethod.newFunction("_dereference_");
    public static final IOSMethod ADDRESS_OF = IOSMethod.newFunction("_address_of_");

    private IOSMethod(String string, boolean bl, String string2, List<IOSParameter> list, boolean bl2) {
        this.name = string;
        this.isFunction = bl;
        this.declaringClass = string2;
        this.parameters = list;
        this.varArgs = bl2;
    }

    public static IOSMethod create(String string) {
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        int n = string.indexOf(32);
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        ImmutableList.Builder builder = ImmutableList.builder();
        String string3 = string;
        boolean bl = false;
        n = string.indexOf(58);
        if (n > 0) {
            string3 = string.substring(0, n);
            String[] stringArray = IOSMethod.splitParameterString(string);
            for (n = 0; n < stringArray.length; ++n) {
                IOSParameter iOSParameter = new IOSParameter(stringArray[n], n);
                builder.add((Object)iOSParameter);
                if (!iOSParameter.isVarArgs()) continue;
                bl = true;
                break;
            }
        }
        return new IOSMethod(string3, false, string2, (List<IOSParameter>)builder.build(), bl);
    }

    public static IOSMethod newFunction(String string) {
        return new IOSMethod(string, true, null, null, false);
    }

    public String getName() {
        return this.name;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public List<IOSParameter> getParameters() {
        return this.parameters;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    private static String[] splitParameterString(String string) {
        ArrayList arrayList = Lists.newArrayList();
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.contains("(")) {
                while (!string2.contains(")")) {
                    assert (i + 1 < stringArray.length);
                    string2 = string2 + ' ' + stringArray[++i];
                }
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }
}

