/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.IOSTypeBinding;
import com.google.devtools.j2objc.types.PointerTypeBinding;
import com.google.devtools.j2objc.types.Types;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class IOSMethodBinding
extends GeneratedMethodBinding {
    private final IOSMethod iosMethod;

    private IOSMethodBinding(IOSMethod iOSMethod, IMethodBinding iMethodBinding, int n, ITypeBinding iTypeBinding, IMethodBinding iMethodBinding2, ITypeBinding iTypeBinding2, boolean bl, boolean bl2) {
        super(iMethodBinding, iOSMethod.getName(), n, iTypeBinding, iMethodBinding2, iTypeBinding2, false, bl, bl2);
        this.iosMethod = iOSMethod;
    }

    public static IOSMethodBinding newMappedMethod(IOSMethod iOSMethod, IMethodBinding iMethodBinding) {
        ITypeBinding iTypeBinding = iMethodBinding.isConstructor() ? iMethodBinding.getDeclaringClass() : iMethodBinding.getReturnType();
        ITypeBinding iTypeBinding2 = Types.resolveIOSType(iOSMethod.getDeclaringClass());
        if (iTypeBinding2 == null) {
            iTypeBinding2 = IOSTypeBinding.newUnmappedClass(iOSMethod.getDeclaringClass());
        }
        IOSMethodBinding iOSMethodBinding = new IOSMethodBinding(iOSMethod, iMethodBinding, iMethodBinding.getModifiers(), iTypeBinding, null, iTypeBinding2, iMethodBinding.isVarargs(), false);
        iOSMethodBinding.addParameters(iMethodBinding);
        return iOSMethodBinding;
    }

    public static IOSMethodBinding newMethod(IOSMethod iOSMethod, int n, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        return new IOSMethodBinding(iOSMethod, null, n, iTypeBinding, null, iTypeBinding2, false, true);
    }

    public static IOSMethodBinding newTypedInvocation(IOSMethodBinding iOSMethodBinding, ITypeBinding iTypeBinding) {
        IOSMethodBinding iOSMethodBinding2 = new IOSMethodBinding(iOSMethodBinding.getIOSMethod(), null, iOSMethodBinding.getModifiers(), iTypeBinding, iOSMethodBinding, iOSMethodBinding.getDeclaringClass(), iOSMethodBinding.isVarargs(), true);
        iOSMethodBinding2.addParameters(iOSMethodBinding);
        return iOSMethodBinding2;
    }

    public static IOSMethodBinding newFunction(String string, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2, ITypeBinding ... iTypeBindingArray) {
        IOSMethodBinding iOSMethodBinding = new IOSMethodBinding(IOSMethod.newFunction(string), null, 0, iTypeBinding, null, iTypeBinding2, false, true);
        for (ITypeBinding iTypeBinding3 : iTypeBindingArray) {
            iOSMethodBinding.addParameter(iTypeBinding3);
        }
        return iOSMethodBinding;
    }

    public static IOSMethodBinding newDereference(ITypeBinding iTypeBinding) {
        assert (iTypeBinding instanceof PointerTypeBinding) : "Can't dereference a non-pointer.";
        return new IOSMethodBinding(IOSMethod.DEREFERENCE, null, 0, ((PointerTypeBinding)iTypeBinding).getPointeeType(), null, null, false, true);
    }

    public static IOSMethodBinding newAddressOf(ITypeBinding iTypeBinding) {
        return new IOSMethodBinding(IOSMethod.ADDRESS_OF, null, 0, new PointerTypeBinding(iTypeBinding), null, null, false, true);
    }

    public static IOSMethod getIOSMethod(IMethodBinding iMethodBinding) {
        if (iMethodBinding instanceof IOSMethodBinding) {
            return ((IOSMethodBinding)iMethodBinding).getIOSMethod();
        }
        return null;
    }

    public IOSMethod getIOSMethod() {
        return this.iosMethod;
    }

    public static boolean hasVarArgsTarget(IMethodBinding iMethodBinding) {
        IOSMethod iOSMethod = IOSMethodBinding.getIOSMethod(iMethodBinding);
        if (iOSMethod != null) {
            return iOSMethod.isVarArgs();
        }
        return false;
    }
}

