/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.types.Types;
import com.google.j2objc.annotations.Weak;
import com.google.j2objc.annotations.WeakOuter;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;

public final class BindingUtil {
    public static boolean isStatic(IBinding iBinding) {
        return Modifier.isStatic((int)iBinding.getModifiers());
    }

    public static boolean isFinal(IBinding iBinding) {
        return Modifier.isFinal((int)iBinding.getModifiers());
    }

    public static boolean isPrivate(IBinding iBinding) {
        return Modifier.isPrivate((int)iBinding.getModifiers());
    }

    public static boolean isPrimitiveConstant(IVariableBinding iVariableBinding) {
        return BindingUtil.isConstant(iVariableBinding) && iVariableBinding.getType().isPrimitive();
    }

    public static boolean isConstant(IVariableBinding iVariableBinding) {
        return iVariableBinding != null && BindingUtil.isStatic((IBinding)iVariableBinding) && BindingUtil.isFinal((IBinding)iVariableBinding) && iVariableBinding.getConstantValue() != null;
    }

    public static IMethodBinding getOriginalMethodBinding(IMethodBinding iMethodBinding) {
        if (!iMethodBinding.isConstructor()) {
            for (ITypeBinding iTypeBinding : BindingUtil.getAllInheritedTypes(iMethodBinding.getDeclaringClass())) {
                for (IMethodBinding iMethodBinding2 : iTypeBinding.getDeclaredMethods()) {
                    if (!iMethodBinding.overrides(iMethodBinding2)) continue;
                    iMethodBinding = iMethodBinding2;
                }
            }
        }
        return iMethodBinding.getMethodDeclaration();
    }

    public static Set<ITypeBinding> getAllInheritedTypes(ITypeBinding iTypeBinding) {
        Set<ITypeBinding> set = BindingUtil.getAllInterfaces(iTypeBinding);
        while ((iTypeBinding = iTypeBinding.getSuperclass()) != null) {
            set.add(iTypeBinding);
        }
        return set;
    }

    public static Set<ITypeBinding> getAllInterfaces(ITypeBinding iTypeBinding) {
        HashSet hashSet = Sets.newHashSet();
        LinkedList linkedList = Lists.newLinkedList();
        while (iTypeBinding != null) {
            linkedList.add(iTypeBinding);
            iTypeBinding = iTypeBinding.getSuperclass();
        }
        while (!linkedList.isEmpty()) {
            ITypeBinding iTypeBinding2 = (ITypeBinding)linkedList.poll();
            List<ITypeBinding> list = Arrays.asList(iTypeBinding2.getInterfaces());
            hashSet.addAll(list);
            linkedList.addAll(list);
        }
        return hashSet;
    }

    public static ITypeBinding findInterface(ITypeBinding iTypeBinding, String string) {
        if (iTypeBinding.isInterface() && iTypeBinding.getErasure().getQualifiedName().equals(string)) {
            return iTypeBinding;
        }
        for (ITypeBinding iTypeBinding2 : BindingUtil.getAllInterfaces(iTypeBinding)) {
            if (!iTypeBinding2.getErasure().getQualifiedName().equals(string)) continue;
            return iTypeBinding2;
        }
        return null;
    }

    public static ITypeBinding findDeclaredType(ITypeBinding iTypeBinding, String string) {
        for (ITypeBinding iTypeBinding2 : iTypeBinding.getDeclaredTypes()) {
            if (!iTypeBinding2.getName().equals(string)) continue;
            return iTypeBinding2;
        }
        return null;
    }

    public static IMethodBinding findDeclaredMethod(ITypeBinding iTypeBinding, String string, String ... stringArray) {
        block0: for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
            ITypeBinding[] iTypeBindingArray;
            if (!iMethodBinding.getName().equals(string) || stringArray.length != (iTypeBindingArray = iMethodBinding.getParameterTypes()).length) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(iTypeBindingArray[i].getQualifiedName())) continue block0;
            }
            return iMethodBinding;
        }
        return null;
    }

    public static String getSignature(IBinding iBinding) {
        if (iBinding instanceof ITypeBinding) {
            return ((ITypeBinding)iBinding).getBinaryName();
        }
        if (iBinding instanceof IMethodBinding) {
            return BindingUtil.getSignature((IMethodBinding)iBinding);
        }
        return iBinding.getName();
    }

    private static String getSignature(IMethodBinding iMethodBinding) {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (ITypeBinding iTypeBinding : iMethodBinding.getParameterTypes()) {
            BindingUtil.appendParameterSignature(iTypeBinding.getErasure(), stringBuilder);
        }
        stringBuilder.append(')');
        if (iMethodBinding.getReturnType() != null) {
            BindingUtil.appendParameterSignature(iMethodBinding.getReturnType().getErasure(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static void appendParameterSignature(ITypeBinding iTypeBinding, StringBuilder stringBuilder) {
        if (!iTypeBinding.isPrimitive() && !iTypeBinding.isArray()) {
            stringBuilder.append('L');
        }
        stringBuilder.append(iTypeBinding.getBinaryName().replace('.', '/'));
        if (!iTypeBinding.isPrimitive() && !iTypeBinding.isArray()) {
            stringBuilder.append(';');
        }
    }

    public static boolean hasAnnotation(IBinding iBinding, Class<?> clazz) {
        return BindingUtil.getAnnotation(iBinding, clazz) != null;
    }

    public static IAnnotationBinding getAnnotation(IBinding iBinding, Class<?> clazz) {
        for (IAnnotationBinding iAnnotationBinding : iBinding.getAnnotations()) {
            String string = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!string.equals(clazz.getName())) continue;
            return iAnnotationBinding;
        }
        return null;
    }

    public static Object getAnnotationValue(IAnnotationBinding iAnnotationBinding, String string) {
        for (IMemberValuePairBinding iMemberValuePairBinding : iAnnotationBinding.getAllMemberValuePairs()) {
            if (!string.equals(iMemberValuePairBinding.getName())) continue;
            return iMemberValuePairBinding.getValue();
        }
        return null;
    }

    public static boolean isWeakReference(IVariableBinding iVariableBinding) {
        return BindingUtil.hasAnnotation((IBinding)iVariableBinding, Weak.class) || iVariableBinding.getName().startsWith("this$") && BindingUtil.hasAnnotation((IBinding)iVariableBinding.getDeclaringClass(), WeakOuter.class);
    }

    public static boolean isRuntimeAnnotation(IExtendedModifier iExtendedModifier) {
        return iExtendedModifier.isAnnotation() ? BindingUtil.isRuntimeAnnotation(Types.getTypeBinding(iExtendedModifier)) : false;
    }

    public static boolean isRuntimeAnnotation(IAnnotationBinding iAnnotationBinding) {
        return BindingUtil.isRuntimeAnnotation(iAnnotationBinding.getAnnotationType());
    }

    public static boolean isRuntimeAnnotation(ITypeBinding iTypeBinding) {
        if (iTypeBinding != null) {
            for (IAnnotationBinding iAnnotationBinding : iTypeBinding.getAnnotations()) {
                if (!iAnnotationBinding.getName().equals("Retention")) continue;
                IVariableBinding iVariableBinding = (IVariableBinding)iAnnotationBinding.getDeclaredMemberValuePairs()[0].getValue();
                return iVariableBinding.getName().equals(RetentionPolicy.RUNTIME.name());
            }
        }
        return false;
    }

    public static IMethodBinding[] getSortedAnnotationMembers(ITypeBinding iTypeBinding) {
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        Arrays.sort(iMethodBindingArray, new Comparator<IMethodBinding>(){

            @Override
            public int compare(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
                return iMethodBinding.getName().compareTo(iMethodBinding2.getName());
            }
        });
        return iMethodBindingArray;
    }

    public static IMemberValuePairBinding[] getSortedMemberValuePairs(IAnnotationBinding iAnnotationBinding) {
        IMemberValuePairBinding[] iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs();
        Arrays.sort(iMemberValuePairBindingArray, new Comparator<IMemberValuePairBinding>(){

            @Override
            public int compare(IMemberValuePairBinding iMemberValuePairBinding, IMemberValuePairBinding iMemberValuePairBinding2) {
                return iMemberValuePairBinding.getName().compareTo(iMemberValuePairBinding2.getName());
            }
        });
        return iMemberValuePairBindingArray;
    }
}

