/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.Lists;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.UnicodeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class InitializationNormalizer
extends ErrorReportingASTVisitor {
    public void endVisit(TypeDeclaration typeDeclaration) {
        this.normalizeMembers((AbstractTypeDeclaration)typeDeclaration);
        super.endVisit(typeDeclaration);
    }

    public void endVisit(EnumDeclaration enumDeclaration) {
        this.normalizeMembers((AbstractTypeDeclaration)enumDeclaration);
        super.endVisit(enumDeclaration);
    }

    public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.normalizeMembers((AbstractTypeDeclaration)annotationTypeDeclaration);
        super.endVisit(annotationTypeDeclaration);
    }

    void normalizeMembers(AbstractTypeDeclaration abstractTypeDeclaration) {
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        ITypeBinding iTypeBinding = Types.getTypeBinding(abstractTypeDeclaration);
        List<BodyDeclaration> list = ASTUtil.getBodyDeclarations(abstractTypeDeclaration);
        Iterator<BodyDeclaration> iterator = list.iterator();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = iterator.next();
            switch (bodyDeclaration.getNodeType()) {
                case 55: 
                case 71: {
                    this.normalizeMembers((AbstractTypeDeclaration)bodyDeclaration);
                    break;
                }
                case 31: {
                    arrayList3.add((MethodDeclaration)bodyDeclaration);
                    break;
                }
                case 28: {
                    this.addInitializer(bodyDeclaration, arrayList, arrayList2);
                    iterator.remove();
                    break;
                }
                case 23: {
                    this.addFieldInitializer(bodyDeclaration, iTypeBinding.isInterface(), arrayList, arrayList2);
                }
            }
        }
        if (!iTypeBinding.isInterface()) {
            boolean bl = true;
            for (MethodDeclaration methodDeclaration : arrayList3) {
                if (methodDeclaration.isConstructor()) {
                    bl = false;
                }
                this.normalizeMethod(methodDeclaration, arrayList);
            }
            if (bl) {
                this.addDefaultConstructor(iTypeBinding, list, arrayList, abstractTypeDeclaration.getAST());
            }
        }
        if (!arrayList2.isEmpty()) {
            this.addClassInitializer(iTypeBinding, list, arrayList2, abstractTypeDeclaration.getAST());
        }
    }

    private void addInitializer(BodyDeclaration bodyDeclaration, List<Statement> list, List<Statement> list2) {
        Initializer initializer = (Initializer)bodyDeclaration;
        List<Statement> list3 = Modifier.isStatic((int)initializer.getModifiers()) ? list2 : list;
        list3.add((Statement)initializer.getBody());
    }

    private void addFieldInitializer(BodyDeclaration bodyDeclaration, boolean bl, List<Statement> list, List<Statement> list2) {
        FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
        for (VariableDeclarationFragment variableDeclarationFragment : ASTUtil.getFragments(fieldDeclaration)) {
            if (variableDeclarationFragment.getInitializer() == null) continue;
            ExpressionStatement expressionStatement = this.makeAssignmentStatement(variableDeclarationFragment);
            if (Modifier.isStatic((int)fieldDeclaration.getModifiers()) || bl) {
                if (!this.requiresInitializer(variableDeclarationFragment)) continue;
                list2.add((Statement)expressionStatement);
                variableDeclarationFragment.setInitializer(null);
                continue;
            }
            list.add((Statement)expressionStatement);
            variableDeclarationFragment.setInitializer(null);
        }
    }

    private boolean requiresInitializer(VariableDeclarationFragment variableDeclarationFragment) {
        Expression expression = variableDeclarationFragment.getInitializer();
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return false;
            }
            case 45: {
                return !UnicodeUtils.hasValidCppCharacters(((StringLiteral)expression).getLiteralValue());
            }
        }
        if (BindingUtil.isPrimitiveConstant(Types.getVariableBinding(variableDeclarationFragment))) {
            return false;
        }
        Object object = expression.resolveConstantExpressionValue();
        if (object != null) {
            if (object instanceof String && !UnicodeUtils.hasValidCppCharacters((String)object)) {
                return true;
            }
            variableDeclarationFragment.setInitializer(ASTFactory.makeLiteral(variableDeclarationFragment.getAST(), object, Types.getTypeBinding(variableDeclarationFragment)));
            return false;
        }
        return true;
    }

    private ExpressionStatement makeAssignmentStatement(VariableDeclarationFragment variableDeclarationFragment) {
        AST aST = variableDeclarationFragment.getAST();
        return aST.newExpressionStatement((Expression)ASTFactory.newAssignment(aST, (Expression)ASTFactory.newSimpleName(aST, (IBinding)Types.getVariableBinding(variableDeclarationFragment)), NodeCopier.copySubtree(aST, variableDeclarationFragment.getInitializer())));
    }

    void normalizeMethod(MethodDeclaration methodDeclaration, List<Statement> list) {
        if (this.isDesignatedConstructor(methodDeclaration)) {
            Object object;
            AST aST = methodDeclaration.getAST();
            List<Statement> list2 = ASTUtil.getStatements(methodDeclaration.getBody());
            int n = this.findSuperConstructorInvocation(list2);
            if (n == -1) {
                object = Types.getTypeBinding(methodDeclaration).getSuperclass();
                GeneratedMethodBinding generatedMethodBinding = GeneratedMethodBinding.newConstructor(object, 1);
                list2.add(0, (Statement)ASTFactory.newSuperConstructorInvocation(aST, generatedMethodBinding));
                n = 0;
            }
            object = NodeCopier.copySubtrees(aST, list);
            list2.addAll(n + 1, (Collection<Statement>)object);
        }
    }

    private int findSuperConstructorInvocation(List<Statement> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof SuperConstructorInvocation)) continue;
            return i;
        }
        return -1;
    }

    boolean isDesignatedConstructor(MethodDeclaration methodDeclaration) {
        if (!methodDeclaration.isConstructor()) {
            return false;
        }
        Block block = methodDeclaration.getBody();
        if (block == null) {
            return false;
        }
        List<Statement> list = ASTUtil.getStatements(block);
        if (list.isEmpty()) {
            return true;
        }
        Statement statement = list.get(0);
        return !(statement instanceof ConstructorInvocation);
    }

    void addDefaultConstructor(ITypeBinding iTypeBinding, List<BodyDeclaration> list, List<Statement> list2, AST aST) {
        SuperConstructorInvocation superConstructorInvocation = aST.newSuperConstructorInvocation();
        int n = iTypeBinding.getModifiers() & 7;
        GeneratedMethodBinding generatedMethodBinding = GeneratedMethodBinding.newConstructor(iTypeBinding.getSuperclass(), n);
        Types.addBinding(superConstructorInvocation, generatedMethodBinding);
        list2.add(0, (Statement)superConstructorInvocation);
        list.add((BodyDeclaration)this.createMethod(aST, GeneratedMethodBinding.newConstructor(iTypeBinding, n), list2));
    }

    void addClassInitializer(ITypeBinding iTypeBinding, List<BodyDeclaration> list, List<Statement> list2, AST aST) {
        int n = 9;
        list.add((BodyDeclaration)this.createMethod(aST, GeneratedMethodBinding.newMethod("initialize", n, aST.resolveWellKnownType("void"), iTypeBinding), list2));
    }

    private MethodDeclaration createMethod(AST aST, IMethodBinding iMethodBinding, List<Statement> list) {
        Block block = aST.newBlock();
        List<Statement> list2 = ASTUtil.getStatements(block);
        for (Statement statement : list) {
            Statement statement2 = NodeCopier.copySubtree(aST, statement);
            list2.add(statement2);
        }
        MethodDeclaration methodDeclaration = ASTFactory.newMethodDeclaration(aST, iMethodBinding);
        methodDeclaration.setBody(block);
        return methodDeclaration;
    }
}

