/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.collect.Sets;
import com.google.devtools.j2objc.types.GeneratedTypeBinding;
import com.google.devtools.j2objc.types.Import;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class HeaderImportCollector
extends ErrorReportingASTVisitor {
    private Set<Import> forwardDecls = Sets.newLinkedHashSet();
    private Set<Import> superTypes = Sets.newLinkedHashSet();
    private Set<Import> declaredTypes = Sets.newHashSet();
    private static final ITypeBinding JAVA_LANG_ENUM = GeneratedTypeBinding.newTypeBinding("java.lang.Enum", null, false);
    private static final ITypeBinding JAVA_LANG_ANNOTATION = GeneratedTypeBinding.newTypeBinding("java.lang.annotation.Annotation", null, false);

    public void collect(ASTNode aSTNode) {
        this.run(aSTNode);
        for (Import import_ : this.superTypes) {
            if (!this.forwardDecls.contains(import_)) continue;
            this.forwardDecls.remove(import_);
        }
    }

    public Set<Import> getForwardDeclarations() {
        return this.forwardDecls;
    }

    public Set<Import> getSuperTypes() {
        return this.superTypes;
    }

    private void addForwardDecl(Type type) {
        if (type != null) {
            this.addForwardDecl(Types.getTypeBinding(type));
        }
    }

    private void addForwardDecl(ITypeBinding iTypeBinding) {
        this.forwardDecls.addAll((Collection<Import>)Sets.difference(Import.getImports(iTypeBinding), this.declaredTypes));
    }

    private void addSuperType(Type type) {
        if (type != null) {
            this.addSuperType(Types.getTypeBinding(type));
        }
    }

    private void addSuperType(ITypeBinding iTypeBinding) {
        this.superTypes.addAll((Collection<Import>)Sets.difference(Import.getImports(iTypeBinding), this.declaredTypes));
    }

    private void addDeclaredType(ITypeBinding iTypeBinding) {
        Import.addImports(iTypeBinding, this.declaredTypes);
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        this.addForwardDecl(annotationTypeMemberDeclaration.getType());
        return true;
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        this.addForwardDecl(fieldDeclaration.getType());
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.addForwardDecl(methodDeclaration.getReturnType2());
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        for (ITypeBinding iTypeBinding : iMethodBinding.getParameterTypes()) {
            this.addForwardDecl(iTypeBinding);
        }
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
        this.addDeclaredType(iTypeBinding);
        if (iTypeBinding.isEqualTo((IBinding)Types.getNSObject())) {
            return false;
        }
        this.addSuperType(typeDeclaration.getSuperclassType());
        for (Type type : ASTUtil.getSuperInterfaceTypes(typeDeclaration)) {
            this.addSuperType(type);
        }
        return true;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        this.addSuperType(JAVA_LANG_ENUM);
        ITypeBinding iTypeBinding = Types.getTypeBinding(enumDeclaration);
        this.addDeclaredType(iTypeBinding);
        for (ITypeBinding iTypeBinding2 : iTypeBinding.getInterfaces()) {
            this.addSuperType(iTypeBinding2);
        }
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.addSuperType(JAVA_LANG_ANNOTATION);
        ITypeBinding iTypeBinding = Types.getTypeBinding(annotationTypeDeclaration);
        this.addDeclaredType(iTypeBinding);
        return true;
    }
}

