/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DeadCodeMap {
    private final ImmutableSet<String> deadClasses;
    private final ImmutableTable<String, String, ImmutableSet<String>> deadMethods;
    private final ImmutableMultimap<String, String> deadFields;

    public static Builder builder() {
        return new Builder();
    }

    private DeadCodeMap(ImmutableSet<String> immutableSet, ImmutableTable<String, String, ImmutableSet<String>> immutableTable, ImmutableMultimap<String, String> immutableMultimap) {
        this.deadClasses = immutableSet;
        this.deadMethods = immutableTable;
        this.deadFields = immutableMultimap;
    }

    public boolean isDeadClass(String string) {
        return this.deadClasses.contains((Object)string);
    }

    public boolean isDeadMethod(String string, String string2, String string3) {
        return this.deadClasses.contains((Object)string) || this.deadMethods.contains((Object)string, (Object)string2) && ((ImmutableSet)this.deadMethods.get((Object)string, (Object)string2)).contains((Object)string3);
    }

    public boolean isDeadField(String string, String string2) {
        return this.deadClasses.contains((Object)string) || this.deadFields.containsEntry((Object)string, (Object)string2);
    }

    public boolean isEmpty() {
        return this.deadClasses.isEmpty() && this.deadMethods.isEmpty() && this.deadFields.isEmpty();
    }

    public static class Builder {
        private final Set<String> deadClasses = new HashSet<String>();
        private final Table<String, String, Set<String>> deadMethods = HashBasedTable.create();
        private final ListMultimap<String, String> deadFields = ArrayListMultimap.create();

        public DeadCodeMap build() {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            for (Table.Cell cell : this.deadMethods.cellSet()) {
                builder.put(cell.getRowKey(), cell.getColumnKey(), (Object)ImmutableSet.copyOf((Collection)((Collection)cell.getValue())));
            }
            return new DeadCodeMap(ImmutableSet.copyOf(this.deadClasses), builder.build(), ImmutableMultimap.copyOf(this.deadFields));
        }

        public Builder addDeadClass(String string) {
            this.deadClasses.add(string);
            return this;
        }

        public Builder addDeadMethod(String string, String string2, String string3) {
            if (!this.deadMethods.contains((Object)string, (Object)string2)) {
                this.deadMethods.put((Object)string, (Object)string2, new HashSet());
            }
            ((Set)this.deadMethods.get((Object)string, (Object)string2)).add(string3);
            return this;
        }

        public Builder addDeadField(String string, String string2) {
            this.deadFields.put((Object)string, (Object)string2);
            return this;
        }
    }
}

